#ifndef SCREEM_CTAGS_MODEL_H
#define SCREEM_CTAGS_MODEL_H

#include <gtk/gtktreestore.h>

#define SCREEM_TYPE_CTAGS_MODEL  (screem_ctags_model_get_type())
#define SCREEM_CTAGS_MODEL(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ), SCREEM_TYPE_CTAGS_MODEL, \
                                                ScreemCtagsModel ) )
#define SCREEM_CTAGS_MODEL_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST( ( klass ), \
                                                             SCREEM_TYPE_CTAGS_MODEL, \
                                                             ScreemCtagsModelClass ) )
#define SCREEM_IS_CTAGS_MODEL(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), SCREEM_TYPE_CTAGS_MODEL ) )

typedef struct ScreemCtagsModelPrivate ScreemCtagsModelPrivate;

enum {
	CTAGS_NAME_COL,
	CTAGS_ICON_COL,
	CTAGS_FILE_COL,
	CTAGS_PATTERN_COL,
	CTAGS_LINE_COL,
	CTAGS_MAX_COLS
};

typedef struct {
	GtkTreeStore parent;
	
	ScreemCtagsModelPrivate *priv;
} ScreemCtagsModel;

typedef struct {
	GtkTreeStoreClass parent_class;

} ScreemCtagsModelClass;

GType screem_ctags_model_get_type( void );
ScreemCtagsModel *screem_ctags_model_new( void );

void screem_ctags_model_set_pathname( ScreemCtagsModel *model,
					const gchar *pathname );
gchar *screem_ctags_model_get_pathname( const ScreemCtagsModel *model );

#endif
