#ifndef SCREEM_ENCODINGS_H
#define SCREEM_ENCODINGS_H

#include <glib/gi18n.h>

struct {
	gchar *name;
	gchar *charset;
} const screem_encodings[] = {
	{ N_( "Arabic" ), "IBM-864" },
	{ N_( "Arabic" ), "ISO-8859-6" },
	{ N_( "Arabic" ), "MacArabic" },
	{ N_( "Arabic" ), "Windows-1256" },
	
	{ N_( "Armenian" ), "ARMSCII-8" },
	
	{ N_( "Baltic" ), "ISO-8859-13" },
	{ N_( "Baltic" ), "ISO-8859-4" },
	{ N_( "Baltic" ), "Windows-1257" },
	
	{ N_( "Celtic" ), "ISO-8859-14" },

	{ N_( "Central European" ), "IBM-852" },
	{ N_( "Central European" ), "ISO-8859-2" },
	{ N_( "Central European" ), "MacCE" },
	{ N_( "Central European" ), "Windows-1250" },

	{ N_( "Chinese Simplified" ), "GB18030" },
	{ N_( "Chinese Simplified" ), "GB2312" },
	{ N_( "Chinese Simplified" ), "GBK" },
	{ N_( "Chinese Simplified" ), "HZ" },
	{ N_( "Chinese Simplified" ), "ISO-2022-CN" },
	
	{ N_( "Chinese Traditional" ), "Big5" },
	{ N_( "Chinese Traditional" ), "Big5-HKSCS" },
	{ N_( "Chinese Traditional" ), "EUC-TW" },
	
	{ N_( "Croation" ), "MacCroation" },
	
	{ N_( "Cyrillic" ), "IBM-855" },
	{ N_( "Cyrillic" ), "ISO-8859-5" },
	{ N_( "Cyrillic" ), "ISO-IR-111" },
	{ N_( "Cyrillic" ), "KOI8-R" },
	{ N_( "Cyrillic" ), "MacCyrillic" },
	
	{ N_( "Cyrillic/Russian" ), "IBM-866" },
	
	{ N_( "Cyrillic/Ukrainian" ), "KOI8-U" },
	{ N_( "Cyrillic/Ukrainian" ), "MacUkrainian" },

	{ N_( "Cyrillic" ), "Windows-1251" },

	{ N_( "English" ), "US-ASCII" },

	{ N_( "Georgian" ), "GEOSTD8" },

	{ N_( "Greek" ), "ISO-8859-7" },
	{ N_( "Greek" ), "MacGreek" },
	{ N_( "Greek" ), "Windows-1253" },

	{ N_( "Gujarati" ), "MacGujarati" },
	
	{ N_( "Gurmukhi" ), "MacGurmukhi" },

	{ N_( "Hebrew" ), "IBM-862" },
	{ N_( "Hebrew" ), "ISO-8859-8-I" },
	{ N_( "Hebrew" ), "MacHewbrew" },
	{ N_( "Hebrew" ), "Windows-1255" },

	{ N_( "Hindi" ), "MacDevanagari" },

	{ N_( "Icelandic" ), "MacIcelandic" },

	{ N_( "Japanese" ), "EUC-JP" },
	{ N_( "Japanese" ), "ISO-2022-JP" },
	{ N_( "Japanese" ), "Shift-JIS" },
	
	{ N_( "Korean" ), "EUC-KR" },
	{ N_( "Korean" ), "ISO-2022-KR" },
	{ N_( "Korean" ), "JOHAB" },
	{ N_( "Korean" ), "UHC" },

	{ N_( "Nordic" ), "ISO-8859-10" },

	{ N_( "Persian" ), "MacFarsi" },

	{ N_( "Romanian" ), "ISO-8859-16" },
	{ N_( "Romanian" ), "MacRomanian" },

	{ N_( "South European" ), "ISO-8859-3" },

	{ N_( "Thai" ), "ISO-8859-11" },
	{ N_( "Thai" ), "TIS-620" },
	{ N_( "Thai" ), "Windows-874" },
	
	{ N_( "Turkish" ), "IBM-857" },
	{ N_( "Turkish" ), "ISO-8859-9" },
	{ N_( "Turkish" ), "MacTurkish" },
	{ N_( "Turkish" ), "Windows-1254" },
	
	{ N_( "Unicode" ), "UTF-16 BE" },
	{ N_( "Unicode" ), "UTF-16 LE" },
	{ N_( "Unicode" ), "UTF-32 BE" },
	{ N_( "Unicode" ), "UTF-32 LE" },
	{ N_( "Unicode" ), "UTF-8" },

	{ N_( "Vietnamese" ), "TCVN" },
	{ N_( "Vietnamese" ), "VISCII" },
	{ N_( "Vietnamese" ), "VPS" },
	{ N_( "Vietnamese" ), "Windows-1258" },

	{ N_( "Visual Hebrew" ), "ISO-8859-8" },

	{ N_( "Western" ), "IBM-850" },
	{ N_( "Western" ), "ISO-8859-1" },
	{ N_( "Western" ), "ISO-8859-15" },
	{ N_( "Western" ), "MacRoman" },
	{ N_( "Western" ), "Windows-1252" }
};
const gint screem_n_encodings = G_N_ELEMENTS( screem_encodings );

#endif
