#ifndef SCREEM_WINDOW_H
#define SCREEM_WINDOW_H

#include <gtk/gtk.h>

#include "screem-application.h"

#include "screem-search.h"

#include "screem-view.h"

#define SCREEM_TYPE_WINDOW  (screem_window_get_type())
#define SCREEM_WINDOW(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ), SCREEM_TYPE_WINDOW, \
                                                ScreemWindow ) )
#define SCREEM_WINDOW_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST( ( klass ), \
                                                             SCREEM_TYPE_WINDOW, \
                                                             ScreemWindowClass ) )
#define SCREEM_IS_WINDOW(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), SCREEM_TYPE_WINDOW ) )

#ifndef SCREEM_WINDOW_DEFINED
#define SCREEM_WINDOW_DEFINED
typedef struct ScreemWindow ScreemWindow;
#endif

typedef struct {
	GtkWindowClass parent_spot;

} ScreemWindowClass;

typedef struct ScreemWindowDetails ScreemWindowDetails;

struct ScreemWindow {
	GtkWindow parent_object;

	ScreemWindowDetails *details;

	/* UI Stuff */

	/* x,y + size, we need to rememeber
	 * non maximized values */
	gint x;
	gint y;
	gint w;
	gint h;
	gboolean max;

	GtkWidget *content_hbox;

	GtkWidget *dock;
	GObject *layout;

	/* the main action group */
	GtkActionGroup *action_group;

	/* open sites group */
	GtkActionGroup *sites_group;
	
	/* ui manager */
	GObject *merge;

	/* editable toolbars */
	GObject *toolbar_model;
	GtkWidget *toolbar;
	
	GtkWidget *status;
	GtkWidget *status_text;

	ScreemSearch *search;
	
	/* the app we belong to */
	ScreemApplication *application;
};

GType  screem_window_get_type( void );
void     screem_window_close( ScreemWindow *window );

void screem_window_set_current( ScreemWindow *window, ScreemSite *site );
ScreemSite *screem_window_get_current( ScreemWindow *window );

void screem_window_set_document( ScreemWindow *window, ScreemPage *page );
ScreemPage* screem_window_get_document( ScreemWindow *window );
gboolean screem_window_set_document_tab( ScreemWindow *window, ScreemPage *page );
void screem_window_remove_document( ScreemWindow *window, ScreemPage *page );

void screem_window_show_message( ScreemWindow *window, const gchar *message,
						gboolean force_msgs );
void screem_window_show_error( ScreemWindow *window, const gchar *error,
						gboolean force_msgs );

void screem_window_clear_messages( ScreemWindow *window );
void screem_window_clear_errors( ScreemWindow *window );

void screem_window_print( ScreemWindow *window, gboolean preview );

void screem_window_display_view( ScreemWindow *window );

void screem_window_toggle_online_status( ScreemWindow *window,
					 gpointer data );

GList *screem_window_get_documents( ScreemWindow *window );

/* yuk, need away to get the selection from the editor when the
 * window is all that is known about
 */
gchar *screem_window_get_selection( ScreemWindow *window );

/* and a way to replace the selection */
void screem_window_replace_selection( ScreemWindow *window, const gchar *data );

void screem_window_add_dock_item( ScreemWindow *window, const gchar *text,
				  const gchar *stock_id, const gchar *name,
				  GtkWidget *item, GtkPositionType pos );

void screem_window_set_title( ScreemWindow *window, ScreemPage *page );

ScreemView *screem_window_get_view( ScreemWindow *window );

#endif
