/* 
   sitecopy, manage remote web sites.
   Copyright (C) 1998-2000, Joe Orton <joe@orton.demon.co.uk>.
                                                                     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Id: common.c,v 1.4 2000/10/15 16:49:13 davek Exp $
*/

#include <config.h>

#include <stdio.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif 
#include <stdarg.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */

#include <ctype.h>

#include <string_utils.h>

#include "i18n.h"
#include "common.h"

#ifdef DEBUGGING

static const struct {
    const char *name;
    int val;
} debug_map[] = {
    { "socket", DEBUG_SOCKET },
    { "files", DEBUG_FILES },
    { "rcfile", DEBUG_RCFILE },
    { "ftp", DEBUG_FTP },
    { "xml", DEBUG_XML },
    { "xmlparse", DEBUG_XMLPARSE },
    { "http", DEBUG_HTTP },
    { "httpauth", DEBUG_HTTPAUTH },
    { "httpbody", DEBUG_HTTPBODY },
    { "cleartext", DEBUG_HTTPPLAIN },
    { NULL, 0 }
};

int map_debug_options(const char *opts, int *mask, char *errbuf)
{
    char **tokens = split_string(opts, ',', NULL, " ");
    int tok, n, ret = 0, mapped;

    for (tok = 0; tokens[tok] != NULL; tok++) {
	mapped = 0;
	for (n = 0; debug_map[n].name != NULL; n++) {
	    if (strcasecmp(tokens[tok], debug_map[n].name) == 0) {
		ret |= debug_map[n].val;
		mapped = 1;
		break;
	    }
	}
	if (!mapped) {
	    memset(errbuf, 0, 20);
	    strncpy(errbuf, tokens[tok], 19);
	    split_string_free(tokens);
	    return -1;
	}
    }
    
    *mask = ret;
    split_string_free(tokens);
    return 0;
}
#endif /* DEBUGGING */

/* Snagged from fetchmail */
# if !HAVE_STRERROR && !defined(strerror)
char *strerror (errnum)
     int errnum;
{
  extern char *sys_errlist[];
  extern int sys_nerr;

  if (errnum > 0 && errnum <= sys_nerr)
    return sys_errlist[errnum];
  return _("Unknown system error");
}
# endif /* HAVE_STRERROR */

