#ifndef SCREEM_SITE_H
#define SCREEM_SITE_H

#include "page.h"
#include "todo.h"

#include <glib.h>
#include <gnome-xml/debugXML.h>
#include <gnome-xml/tree.h>
#include <gnome-xml/parser.h>

typedef gpointer Site;

/* function pointer type for getting the file upload status' from
   the upload wizard */
typedef gboolean(*SiteSyncState)( GHashTable **table );

typedef enum _SitePerms {
	PERMS_EXEC = 0,
	PERMS_IGNORE = 1,
	PERMS_ALL = 2
} SitePerms;

typedef enum _SiteSymlinks {
	SYM_FOLLOW = 0,
	SYM_IGNORE = 1,
	SYM_MAINTAIN =2
} SiteSymlinks;

typedef enum _UploadMethods {
	LOCAL = 0,
	FTP = 1,
	WEBDAV = 2,
	RSH = 3,
	SSH = 4
} UploadMethods;

/* These are defined in Site.c */
extern const gchar *permission_strings[];
extern const gchar *symlink_strings[];
extern const gchar *upload_strings[];

Site* screem_site_new( void );
void screem_site_destroy( Site *site );

void screem_site_purge( Site *site );

void screem_site_set_name( Site *site, const gchar *name );
const gchar* screem_site_get_name( Site *site );

void screem_site_set_pathname( Site *site, const gchar *pathname );
const gchar* screem_site_get_pathname( Site *site );

void screem_site_set_remote_url( Site *site, const gchar *remote_url );
const gchar* screem_site_get_remote_url( Site *site );

void screem_site_set_remote_method( Site *site, UploadMethods method );
UploadMethods screem_site_get_remote_method( Site *site );

void screem_site_set_remote_path( Site *site, const gchar *remote_path );
const gchar* screem_site_get_remote_path( Site *site );

void screem_site_set_remote_user( Site *site, const gchar *remote_user );
const gchar* screem_site_get_remote_user( Site *site );

void screem_site_set_remote_pass( Site *site, const gchar *remote_pass );
const gchar* screem_site_get_remote_pass( Site *site );

void screem_site_set_cvs_root( Site *site, const gchar *cvs_root );
const gchar* screem_site_get_cvs_root( Site *site );
void screem_site_set_auto_update_ask( Site *site, gboolean value );
gboolean screem_site_get_auto_update_ask( Site *site );
void screem_site_set_auto_update( Site *site, gboolean value );
gboolean screem_site_get_auto_update( Site *site );

void screem_site_set_template_path( Site *site, const gchar *template_path );
const gchar* screem_site_get_template_path( Site *site );

void screem_site_set_http_url( Site *site, const gchar *http_url );
const gchar* screem_site_get_http_url( Site *site );

void screem_site_set_fake_flag( Site *site, gboolean flag );
gboolean screem_site_get_fake_flag( Site *site );

void screem_site_set_passive_ftp( Site *site, gboolean flag );
gboolean screem_site_get_passive_ftp( Site *site );

void screem_site_set_no_delete( Site *site, gboolean flag );
gboolean screem_site_get_no_delete( Site *site );

void screem_site_set_check_moved( Site *site, gboolean flag );
gboolean screem_site_get_check_moved( Site *site );

void screem_site_set_no_overwrite( Site *site, gboolean flag );
gboolean screem_site_get_no_overwrite( Site *site );

void screem_site_set_permissions( Site *site, SitePerms permissions );
SitePerms screem_site_get_permissions( Site *site );

void screem_site_set_symlinks( Site *site, SiteSymlinks symlinks );
SiteSymlinks screem_site_get_symlinks( Site *site );

void screem_site_set_current_page( Site *site, Page *page );
Page *screem_site_get_current_page( Site *site );

void screem_site_set_is_import( Site *site, gboolean val );
gboolean screem_site_get_is_import( Site *site );

void screem_site_set_open_pages( Site *site, gint num );
gint screem_site_get_open_pages( Site *site );
Page* screem_site_get_page_from_tab( Site *site, gint tab );

#define screem_site_inc_open_pages( s ) \
screem_site_set_open_pages( s, screem_site_get_open_pages( s ) + 1 )
#define screem_site_dec_open_pages( s ) \
screem_site_set_open_pages( s, screem_site_get_open_pages( s ) - 1 )

GList *screem_site_get_excludes( Site *site );
GList *screem_site_get_ignores( Site *site );
GList *screem_site_get_asciis( Site *site );
GList *screem_site_get_auto_open( Site *site );

gboolean screem_site_is_excluded( Site *site, const gchar *path );
void screem_site_add_exclude( Site *site, const gchar *path );
void screem_site_remove_exclude( Site *site, const gchar *path );

gboolean screem_site_is_ascii( Site *site, const gchar *path );
void screem_site_add_ascii( Site *site, const gchar *path );
void screem_site_remove_ascii( Site *site, const gchar *path );

gboolean screem_site_is_ignored( Site *site, const gchar *path );
void screem_site_add_ignore( Site *site, const gchar *path );
void screem_site_remove_ignore( Site *site, const gchar *path );

void screem_site_add_auto_open( Site *site, gchar *file );

void screem_site_save( Site *site );
gboolean screem_site_create( Site *site );
gboolean screem_site_load( Site *site );

gboolean screem_site_write_project_file( Site *site );
gboolean screem_site_parse_project_file( Site *site, xmlDocPtr doc );

Page* screem_site_locate_page( Site *site, const gchar *path );
void screem_site_add_page( Site *site, const gchar *path );
Page* screem_site_remove_page( Site *site, const gchar *path );
GList* screem_site_get_pages( Site *site );

TodoItem* screem_site_locate_task( Site *site, const gchar *task );
void screem_site_add_task( Site *site, TodoItem *item );
TodoItem* screem_site_remove_task( Site *site, const gchar *task );
GList* screem_site_get_tasks( Site *site );

void screem_site_file_change( Site *site, gchar *src, gchar *dest );

#endif
