;*=====================================================================*/
;*    serrano/prgm/project/scribe/examples/embedded/embedded.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov  6 14:58:46 2001                          */
;*    Last change :  Sat Dec  8 08:22:24 2001 (serrano)                */
;*    Copyright   :  2001 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    An example of embedded Scribe program.                           */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module scribe_embedded
   (library scribeapi
	    scribehtml
	    scribetext
	    scribetex
	    scribeman)
   (main main))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (let ((doc (document :title "A generated electronic document"
			:author (string-append (car argv) " -- scribeapi")
			(body))))
      ;; the html file
      (with-output-to-file (string-append (car argv) ".html")
	 (lambda () (html doc)))
      ;; the text file
      (with-output-to-file (string-append (car argv) ".ascii")
	 (lambda () (ascii doc)))
      ;; the tex file
      (with-output-to-file (string-append (car argv) ".tex")
	 (lambda () (tex doc)))
      ;; the man file
      (with-output-to-file (string-append (car argv) ".man")
	 (lambda () (man doc)))))

;*---------------------------------------------------------------------*/
;*    body ...                                                         */
;*---------------------------------------------------------------------*/
(define (body)
   (list
    (section :title "Fibonacci"
	     (let ((n 20))
		(string-append "fib("
			       (number->string n)
			       ") : "
			       (number->string (fib n)))))
    (section :title "Bigloo compiler options: "
	     (color :bg "#eebbbb"
		    (pre (let ((port (open-input-file "| bigloo -help")))
			    (let loop ((exp (read-line port))
				       (res '()))
			       (if (eof-object? exp)
				   (apply string-append (reverse! res))
				   (loop (read-line port)
					 (cons* exp "\n" res))))))))))

;*---------------------------------------------------------------------*/
;*    fib ...                                                          */
;*---------------------------------------------------------------------*/
(define (fib x)
   (if (< x 2)
       1
       (+ (fib (- x 1)) (fib (- x 2)))))	  

    
