;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribecgi/cgi.scm                    */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Nov 26 10:30:48 2001                          */
;*    Last change :  Mon Nov 26 15:57:04 2001 (serrano)                */
;*    Copyright   :  2001 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    A Bigloo library that enable CGI programming with Scribe.        */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribecgi_query
   (export (cgi-acknowledge . port)
	   (cgi-query->list::pair-nil ::bstring)))

;*---------------------------------------------------------------------*/
;*    cgi-acknowledge ...                                              */
;*---------------------------------------------------------------------*/
(define (cgi-acknowledge . p)
   (let ((p (if (pair? p) (car p) (current-output-port))))
      (fprint p "MIME-Version: 1.0") 
      (fprint p "Content-type: text/html")
      (newline p)))

;*---------------------------------------------------------------------*/
;*    unHex ...                                                        */
;*---------------------------------------------------------------------*/
(define (unHex hexadecimal-string)
   (string (integer->char (string->integer hexadecimal-string 16))))

;*---------------------------------------------------------------------*/
;*    cgi-query->list ...                                              */
;*---------------------------------------------------------------------*/
(define (cgi-query->list query)
   (let* ((fields-list '())
	  (field-name "")
	  (field-value "")
	  (gram (regular-grammar ()
		   ((when (not (rgc-context? 'val))
		       (+ (or (: (? #a013) #\newline) #\&)))
		    (ignore))
		   ((when (not (rgc-context? 'val))
		       (: (* (out "=%&")) "="))
		    (set! field-name
			  (string-append
			   field-name
			   (the-substring 0 (-fx (the-length) 1))))
		    (rgc-context 'val)
		    (ignore))
		   ((when (not (rgc-context? 'val))
		       (: (* (out "=%&")) "%" xdigit xdigit))
		    (set! field-name
			  (string-append
			   field-name
			   (the-substring 0
					  (-fx (the-length) 3))
			   (unHex (the-substring (-fx (the-length) 2)
						 (the-length)))))
		    (ignore))
		   
		   ((when (rgc-context? 'val)
		       (+ (or (: (? #a013) #\newline) #\&)))
		    (set! fields-list (cons (cons field-name field-value)
					    fields-list))
		    (set! field-name "")
		    (set! field-value "")
		    (rgc-context)
		    (ignore))
		   ((when (rgc-context? 'val)
		       (: (* (out "&%+")) #\% xdigit xdigit))
		    (set! field-value
			  (string-append
			   field-value
			   (the-substring 0
					  (-fx (the-length) 3))
			   (unHex (the-substring (-fx (the-length) 2)
						 (the-length)))))
		    (ignore))
		   ((when (rgc-context? 'val)
		       (: (* (out "&%+")) "+"))
		    (set! field-value (string-append
				       field-value
				       (the-substring 0 (-fx (the-length) 1))
				       " "))
		    (ignore))
		   ((when (rgc-context? 'val)
		       (* (out "&%+")))
		    (set! field-value (string-append field-value
						     (the-string)))
		    (set! fields-list (cons (cons field-name field-value)
					    fields-list))
		    (set! field-name "")
		    (set! field-value "")
		    (rgc-context)
		    (ignore))
		   
		   (else (reverse fields-list)))))
      (with-input-from-string query
	 (lambda () (read/rp gram (current-input-port))))))
