;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribehtml/html.scm                  */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Sep 23 14:03:53 2001                          */
;*    Last change :  Fri Jan 25 10:38:34 2002 (serrano)                */
;*    Copyright   :  2001-02 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The translator scribe->html                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribehtml_html
   
   (library scribeapi)

   (import  __scribehtml_api
	    __scribehtml_tools
	    __scribehtml_sui)
   
   (export  (generic html ::obj)
	    (scribehtml-apache-initialize)))

;*---------------------------------------------------------------------*/
;*    scribehtml-apache-initialize ...                                 */
;*---------------------------------------------------------------------*/
(define (scribehtml-apache-initialize)
   #unspecified)

;*---------------------------------------------------------------------*/
;*    html ::obj ...                                                   */
;*---------------------------------------------------------------------*/
(define-generic (html obj::obj)
   (cond
      ((procedure? obj)
       (html (obj)))
      ((string? obj)
       (display (html-string obj)))
      ((or (number? obj) (char? obj))
       (display obj))
      ((eq? obj #unspecified)
       obj)
      ((list? obj)
       (for-each html obj))
      ((or (symbol? obj) (boolean? obj))
       "")
      (else
       (with-access::%node obj (loc)
	  (error/location "html"
			  "Can't find method for node"
			  (find-runtime-type obj)
			  (car loc)
			  (cdr loc))))))

;*---------------------------------------------------------------------*/
;*    html ::%document ...                                             */
;*---------------------------------------------------------------------*/
(define-method (html obj::%document)
   (with-document
    obj
    (lambda ()
       (with-access::%document obj (title authors body footnotes)
	  (scribe-document->html title authors body footnotes)))))

;*---------------------------------------------------------------------*/
;*     scribe-document->html ...                                       */
;*---------------------------------------------------------------------*/
(define (scribe-document->html title authors body footnotes)
   ;; display the html header
   (define (html-header title)
      (print "<html>\n <head>")
      (print "  <title>" title "</title>")
      (display "  <style type=\"text/css\">
   pre { font-size: 10pt; color: black; font-family: monospace }
   tt { font-size: 10pt; font-family: monospace }
   code { font-size: 10pt; font-family: monospace }
   p.flushright {text-align: right } 
   p.flushleft {text-align: left }
  </style>
  <body")
      (if *scribe-background*
	  (display* " bgcolor=\"" *scribe-background* "\""))
      (if *scribe-foreground*
	  (display* " text=\"" *scribe-foreground* "\""))
      (print ">")
      (print " </head>\n"))
   ;; display the title and the authors
   (define (html-title dotitle doauthors)
      (if *scribe-tbackground*
	  (begin
	     (print "<table width=\"100%\">")
	     (print "<tr><td bgcolor=\"" *scribe-tbackground* "\"><br>")
	     (if (string? *scribe-tforeground*)
		 (print "<font color=\"" *scribe-tforeground* "\">"))
	     (dotitle)
	     (if (string? *scribe-tforeground*)
		 (print "</font>"))
	     (doauthors)
	     (print "</td></tr></table>"))
	  (begin
	     (print "<br>")
	     (dotitle)
	     (doauthors)))
      (newline)
      (newline))
   ;; manages the left and right margins
   (define (html-margins body)
      (cond
	 ((and *scribe-html-left-margin* *scribe-html-right-margin*)
	  (print "<table cellpadding=\"3\" width=\"100%\"><tr>")
	  (html *scribe-html-left-margin*)
	  (print "</td><td valign=\"top\" width=\"100%\">")
	  (body)
	  (print "</td>")
	  (html *scribe-html-right-margin*)
	  (print "</td></tr></table>"))
	 (*scribe-html-left-margin*
	  (print "<table cellpadding=\"3\" width=\"100%\"><tr>")
	  (html *scribe-html-left-margin*)
	  ;; the body
	  (print "</td><td valign=\"top\" width=\"100%\">")
	  (body)
	  (print "</td></tr></table>"))
	 (*scribe-html-right-margin*
	  (print "<table cellpadding=\"3\" width=\"100%\"><tr>")
	  ;; the body
	  (print "<td valign=\"top\" width=\"100%\">")
	  (body)
	  (print "</td>")
	  (html *scribe-html-right-margin*)
	  (print "</td></tr></table>"))
	 (else
	  (body))))
   ;; display the footer
   (define (html-footer)
      (if *scribe-footer* (html *scribe-footer*)))
   ;; the header of the Html document
   (html-header (if (string? title) title "scribe-document"))
   ;; the title background
   ;; the title and its font
   (html-title (lambda ()
		  (if (string? *scribe-title-font*)
		      (print "<center><font " *scribe-title-font* "><b>")
		      (print "<center><font face='sans-serif' size='+10'><b>"))
		  (cond
		     ((string? title)
		      (print " " title))
		     (title
		      (html title)))
		  (print "</b></font></center>"))
	       (lambda ()
		  (cond
		     ((not (pair? authors))
		      (print "<br>"))
		     (else
		      (print "<center>")
		      (html-authors authors)
		      (print "</center><br>")))))
   ;; the margins
   (html-margins (lambda ()
		    (html body)
		    ;; the footnotes
		    (html-footnotes footnotes)))
   ;; the footer of the document
   (html-footer)
   ;; we are done
   (print "\n</html>"))

;*---------------------------------------------------------------------*/
;*    html-authors ...                                                 */
;*---------------------------------------------------------------------*/
(define (html-authors authors)
   (define (html-authorsN authors cols first)
      (define (make-row authors . opt)
	 (apply tr (map (lambda (v)
			   (apply td :align 'center :valign 'top v opt))
			authors)))
      (define (make-rows authors)
	 (let loop ((authors authors)
		    (rows '())
		    (row '())
		    (cnum 0))
	    (cond
	       ((null? authors)
		(reverse! (cons (make-row (reverse! row)) rows)))
	       ((= cnum cols)
		(loop authors
		      (cons (make-row (reverse! row)) rows)
		      '()
		      0))
	       (else
		(loop (cdr authors)
		      rows
		      (cons (car authors) row)
		      (+fx cnum 1))))))
      (html (apply table :cellpadding 10
		   (if first
		       (cons (make-row (list (car authors)) :colspan cols)
			     (make-rows (cdr authors)))
		       (make-rows authors)))))
   (if (pair? authors)
       (begin
	  (print "<BR>")
	  (let ((len (length authors)))
	     (case len
		((1)
		 (html (car authors)))
		((2 3)
		 (html-authorsN authors len #f))
		((4)
		 (html-authorsN authors 2 #f))
		(else
		 (html-authorsN authors 3 #t)))))))

;*---------------------------------------------------------------------*/
;*    html ::%author ...                                               */
;*---------------------------------------------------------------------*/
(define-method (html obj::%author)
   (with-access::%author obj (name affiliation email url address phone photo)
      (if photo
	  (begin
	     (print "<table>")
	     (print "<tr><td>")
	     (html photo)
	     (print "</td><td>")))
      ;; name
      (if *scribe-author-font*
	  (display* "<font " *scribe-author-font* "><i>")
	  (display* "<font size='+5'><i>"))
      (html name)
      (print "</i></font>")
      ;; affiliation
      (if affiliation
	  (print "<br>" affiliation))
      ;; address
      (if (pair? address)
	  (for-each (lambda (x)
		       (print "<br>" x))
		    address))
      ;; email
      (if email
	  (print "<br><a href=\"mailto:" email "\"><tt>" email "</tt></a>"))
      ;; url
      (if url
	  (print "<br><a href=\"" url "\"><tt>" url "</tt></a>"))
      ;; telephone
      (if phone
	  (print "<br>" phone))
      (if photo
	  (print "<td></tr></table>"))))
   
;*---------------------------------------------------------------------*/
;*    html ::%margin ...                                               */
;*---------------------------------------------------------------------*/
(define-method (html obj::%margin)
   (with-access::%margin obj (bg width body tbg tfg)
      (display "<td valign=\"top\"")
      (if bg (display* " bgcolor=\"" bg "\""))
      (if width (display* " width=\"" (html-width width) "\""))
      (print ">")
      (let ((otbg *scribe-tbackground*)
	    (otfg *scribe-tforeground*))
	 (if tbg (set! *scribe-tbackground* tbg))
	 (if tfg (set! *scribe-tforeground* tfg))
	 (html body)
	 (set! *scribe-tforeground* otfg)
	 (set! *scribe-tbackground* otbg))
      (print "</td>")))

;*---------------------------------------------------------------------*/
;*    html ::%toc ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (html obj::%toc)
   (with-access::%toc obj (chapter section)
      ;; display the toc for a subsectino
      (define (subsection-toc s margin)
	 (if margin (display* (make-string margin #\space)))
	 (html-subsection-ref s '(#t))
	 (newline))
      ;; display the toc for a section
      (define (section-toc s margin subsection)
	 (with-access::%section s (toc number title children)
	    (if (and toc
		     (or (eq? section #t)
			 (and (pair? section) (member title section))))
		(begin
		   (if margin (display (make-string margin #\space)))
		   (html-section-ref s '(#t))
		   (newline)))
	    (if subsection
		(for-each (lambda (x)
			     (if (%subsection? x)
				 (subsection-toc x (+ margin 4))))
			  (section-subsections s)))))
      ;; display the toc for a chapter
      (define (chapter-toc c)
	 (with-access::%chapter c (toc number subtitle)
	    (if (and toc
		     (or (eq? chapter #t)
			 (and (pair? chapter) (member subtitle chapter))))
		(begin
		   (html-chapter-ref c '(#t))
		   (newline)))
	    (for-each (lambda (x)
			 (section-toc x 4 #f))
		      (chapter-sections c))))
      (define (partial-toc)
	 (let ((sections (if (current-chapter)
			     (chapter-sections (current-chapter))
			     (document-sections (current-document)))))
	    (for-each (lambda (x) (section-toc x 0 #t)) sections)))
      (define (full-toc)
	 ;; the top-level sections
	 (for-each (lambda (x)
		      (section-toc x 0 #f))
		   (document-sections (current-document)))
	 ;; the chapters
	 (for-each chapter-toc (document-chapters (current-document))))
      ;; the diplay of the toc
      (display "<pre><font face=\"normal\">")
      (if (eq? (%toc-chapter obj) #t)
	  ;; %toc-chapter may be a list of chapters
	  (full-toc)
	  (partial-toc))
      (display "</font></pre>")))

;*---------------------------------------------------------------------*/
;*    html ::%text ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (html obj::%text)
   (html (%text-body obj)))

;*---------------------------------------------------------------------*/
;*    html ::%linebreak ...                                            */
;*---------------------------------------------------------------------*/
(define-method (html obj::%linebreak)
   (let loop ((num (%linebreak-repetition obj)))
      (print "<br>")
      (if (>fx num 1)
	  (loop (-fx num 1)))))

;*---------------------------------------------------------------------*/
;*    html ::%center ...                                               */
;*---------------------------------------------------------------------*/
(define-method (html obj::%center)
   (print "<center>")
   (html (%center-body obj))
   (print "</center>"))

;*---------------------------------------------------------------------*/
;*    html ::%flush ...                                                */
;*---------------------------------------------------------------------*/
(define-method (html obj::%flush)
   (with-access::%flush obj (side loc)
      (case side
	 ((center)
	  (print "<center>")
	  (html (%flush-body obj))
	  (print "</center>"))
	 ((left)
	  (print "<p class=\"flushleft\">")
	  (html (%flush-body obj))
	  (print "</p>"))
	 ((right)
	  (print "<p class=\"flushright\">")
	  (html (%flush-body obj))
	  (print "</p>"))
	 (else
	  (error/location "html"
			  "Illegal flush value"
			  side
			  (car loc)
			  (cdr loc))))))

;*---------------------------------------------------------------------*/
;*    html ::%atom ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (html obj::%atom)
   (print (%atom-value obj)))

;*---------------------------------------------------------------------*/
;*    html ::%ornament ...                                             */
;*---------------------------------------------------------------------*/
(define-method (html obj::%ornament)
   (html (%ornament-body obj)))

;*---------------------------------------------------------------------*/
;*    html ::%bold ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (html obj::%bold)
   (*scribe-html-bold-start*)
   (call-next-method)
   (*scribe-html-bold-stop*))

;*---------------------------------------------------------------------*/
;*    html ::%emph ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (html obj::%emph)
   (*scribe-html-emph-start*)
   (call-next-method)
   (*scribe-html-emph-stop*))

;*---------------------------------------------------------------------*/
;*    html ::%underline ...                                            */
;*---------------------------------------------------------------------*/
(define-method (html obj::%underline)
   (*scribe-html-underline-start*)
   (call-next-method)
   (*scribe-html-underline-stop*))

;*---------------------------------------------------------------------*/
;*    html ::%kbd ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (html obj::%kbd)
   (*scribe-html-kbd-start*)
   (call-next-method)
   (*scribe-html-kbd-stop*))

;*---------------------------------------------------------------------*/
;*    html ::%it ...                                                   */
;*---------------------------------------------------------------------*/
(define-method (html obj::%it)
   (*scribe-html-it-start*)
   (call-next-method)
   (*scribe-html-it-stop*))

;*---------------------------------------------------------------------*/
;*    html ::%pre ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (html obj::%pre)
   (display "<pre>")
   (call-next-method)
   (display "</pre>"))

;*---------------------------------------------------------------------*/
;*    html ::%color ...                                                */
;*---------------------------------------------------------------------*/
(define-method (html obj::%color)
   (with-access::%color obj (body bg fg width margin)
      (if (string? bg)
	  (begin
	     (if width
		 (print "<table border='0' cellspacing='0' cellpadding='"
			(if margin margin 0)
			"' width='" (html-width width) "'>")
		 (print "<table border='0' cellspacing='0' cellpadding='"
			(if margin margin 0)
			"'>"))
	     (print "<tr>")
	     (print "<td bgcolor=\"" bg "\">")))
      (if (string? fg)
	  (display* "<font color=\"" fg "\">"))
      (html body)
      (if (string? fg)
	  (display "</font>"))
      (if (string? bg)
	  (begin
	     (print "</td></tr>\n</table>")))))

;*---------------------------------------------------------------------*/
;*    html ::%frame ...                                                */
;*---------------------------------------------------------------------*/
(define-method (html obj::%frame)
   (with-access::%frame obj (body width margin)
      (if width
	  (print "<table border='1' cellspacing='0' cellpadding='"
		 (if margin margin 0)
		 "' width='" (html-width width) "'>\n<tr><td>")
	  (print "<table border='1' cellspacing='0' cellpadding='"
		 (if margin margin 0)
		 "'>\n<tr><td>"))
      (html body)
      (print "</td></tr>\n</table>")))

;*---------------------------------------------------------------------*/
;*    html ::%tt ...                                                   */
;*---------------------------------------------------------------------*/
(define-method (html obj::%tt)
   (with-access::%tt obj (body)
      (*scribe-html-tt-start*)
      (html body)
      (*scribe-html-tt-stop*)))

;*---------------------------------------------------------------------*/
;*    html ::%code ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (html obj::%code)
   (with-access::%code obj (body)
      (*scribe-html-code-start*)
      (html body)
      (*scribe-html-code-stop*)))

;*---------------------------------------------------------------------*/
;*    html ::%samp ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (html obj::%samp)
   (with-access::%samp obj (body)
      (*scribe-html-samp-start*)
      (html body)
      (*scribe-html-samp-stop*)))

;*---------------------------------------------------------------------*/
;*    html ::%var ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (html obj::%var)
   (with-access::%var obj (body)
      (*scribe-html-var-start*)
      (html body)
      (*scribe-html-var-stop*)))

;*---------------------------------------------------------------------*/
;*    html ::%sc ...                                                   */
;*---------------------------------------------------------------------*/
(define-method (html obj::%sc)
   (with-access::%sc obj (body)
      (*scribe-html-sc-start*)
      (html body)
      (*scribe-html-sc-stop*)))

;*---------------------------------------------------------------------*/
;*    html ::%sup ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (html obj::%sup)
   (with-access::%sup obj (body)
      (*scribe-html-sup-start*)
      (html body)
      (*scribe-html-sup-stop*)))

;*---------------------------------------------------------------------*/
;*    html ::%sub ...                                                  */
;*---------------------------------------------------------------------*/
(define-method (html obj::%sub)
   (with-access::%sub obj (body)
      (*scribe-html-sub-start*)
      (html body)
      (*scribe-html-sub-stop*)))

;*---------------------------------------------------------------------*/
;*    html ::%mark ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (html obj::%mark)
   (with-access::%mark obj (id)
      (display* "<a name=\"" id "\">")))

;*---------------------------------------------------------------------*/
;*    referenced-file ...                                              */
;*---------------------------------------------------------------------*/
(define (referenced-file file)
   (if (string? file)
       (if (string=? (suffix file) "scr")
	   (display* (strip-ref-base (suffix file)) ".html")
	   (display (strip-ref-base file)))))

;*---------------------------------------------------------------------*/
;*    html ::%reference ...                                            */
;*---------------------------------------------------------------------*/
(define-method (html obj::%reference)
   (with-access::%reference obj (body anchor)
      (multiple-value-bind (file mark)
	 (find-reference obj (current-document))
	 (if (not mark)
	     (begin
		(warning "ref" "Can't find reference -- " anchor)
		(display-unref "reference:???"))
	     (begin
		(display "<a href=\"")
		(referenced-file file)
		(cond
		    ((string? mark)
		     (display* "#" mark))
		    ((%container? mark)
		     (display* "#" (%container-stamp mark))))
		(display* "\">")
		(html body)
		(display "</a>"))))))

;*---------------------------------------------------------------------*/
;*    html ::%url-ref ...                                              */
;*---------------------------------------------------------------------*/
(define-method (html obj::%url-ref)
   (with-access::%url-ref obj (url anchor body)
      (display "<a href=\"")
      (html url)
      (if anchor
	  (begin
	     (display "#")
	     (html anchor)))
      (display "\">")
      (html body)
      (display "</a>")))
   
;*---------------------------------------------------------------------*/
;*    html ::%chapter-ref ...                                          */
;*---------------------------------------------------------------------*/
(define-method (html obj::%chapter-ref)
   (with-access::%chapter-ref obj (anchor body)
      (multiple-value-bind (_ chapter)
	 (find-reference obj (current-document))
	 (if (not chapter)
	     (begin
		(warning "ref" "Can't find chapter -- " anchor)
		(display-unref "chapter:???"))
	     (html-chapter-ref chapter body)))))

;*---------------------------------------------------------------------*/
;*    html-chapter-ref ...                                             */
;*---------------------------------------------------------------------*/
(define (html-chapter-ref obj::%chapter body)
   (with-access::%chapter obj (stamp number)
      (multiple-value-bind (num title)
	 (make-chapter-title obj #f)
	 (if (not body) (display num))
	 (display "<a href=\"")
	 (referenced-file (chapter-file obj))
	 (display* "#" stamp)
	 (display "\">")
	 (if (and body (not (equal? body '(#t))))
	     (html body)
	     (display title))
	 (display "</a>"))))

;*---------------------------------------------------------------------*/
;*    html ::%section-ref ...                                          */
;*---------------------------------------------------------------------*/
(define-method (html obj::%section-ref)
   (with-access::%section-ref obj (anchor body)
      (multiple-value-bind (_ section)
	 (find-reference obj (current-document))
	 (if (not (%section? section))
	     (begin
		(warning "ref" "Can't find section -- " anchor)
		(display-unref "section:???"))
	     (html-section-ref section body)))))

;*---------------------------------------------------------------------*/
;*    html-section-ref ...                                             */
;*---------------------------------------------------------------------*/
(define (html-section-ref obj::%section body)
   (with-access::%section obj (stamp)
      (multiple-value-bind (num title)
	 (make-section-title obj)
	 (if (not body) (display "Section "))
	 (display "<a href=\"")
	 (referenced-file (container-file obj))
	 (display* "#" stamp)
	 (display "\">")
	 (if (and body (not (equal? body '(#t))))
	     (html body)
	     (display title))
	 (display "</a>"))))
   
;*---------------------------------------------------------------------*/
;*    html ::%subsection-ref ...                                       */
;*---------------------------------------------------------------------*/
(define-method (html obj::%subsection-ref)
   (with-access::%subsection-ref obj (anchor body)
      (multiple-value-bind (_ subsection)
	 (find-reference obj (current-document))
	 (if (not (%subsection? subsection))
	     (begin
		(warning "ref" "Can't find subsection -- " anchor)
		(display-unref "subsection:???"))
	     (html-subsection-ref subsection body)))))

;*---------------------------------------------------------------------*/
;*    html-subsection-ref ...                                          */
;*---------------------------------------------------------------------*/
(define (html-subsection-ref obj::%subsection body)
   (with-access::%subsection obj (stamp)
      (multiple-value-bind (num title)
	 (make-subsection-title obj)
	 (if (not body) (display "Section "))
	 (display "<a href=\"")
	 (referenced-file (container-file obj))
	 (display* "#" stamp)
	 (display "\">")
	 (if (and body (not (equal? body '(#t))))
	     (html body)
	     (display title))
	 (display "</a>"))))
   
;*---------------------------------------------------------------------*/
;*    html ::%subsubsection-ref ...                                    */
;*---------------------------------------------------------------------*/
(define-method (html obj::%subsubsection-ref)
   (with-access::%subsubsection-ref obj (anchor body)
      (multiple-value-bind (_ subsubsection)
	 (find-reference obj (current-document))
	 (if (not (%subsubsection? subsubsection))
	     (begin
		(warning "ref" "Can't find subsubsection -- " anchor)
		(display-unref "subsubsection:???"))
	     (html-subsubsection-ref subsubsection body)))))

;*---------------------------------------------------------------------*/
;*    html-subsubsection-ref ...                                       */
;*---------------------------------------------------------------------*/
(define (html-subsubsection-ref obj::%subsubsection body)
   (with-access::%subsubsection obj (stamp title)
      (multiple-value-bind (num title)
	 (make-subsubsection-title obj)
	 (if (not body) (display "Section "))
	 (display "<a href=\"")
	 (referenced-file (container-file obj))
	 (display* "#" stamp)
	 (display "\">")
	 (if (and body (not (equal? body '(#t))))
	     (html body)
	     (display title))
	 (display "</a>"))))

;*---------------------------------------------------------------------*/
;*    html ::%biblio-ref ...                                           */
;*---------------------------------------------------------------------*/
(define-method (html obj::%biblio-ref)
   (with-access::%biblio-ref obj (anchor body)
      (html-bibentry-ref anchor body)))

;*---------------------------------------------------------------------*/
;*    html-bibentry-ref ::%bibentry ...                                */
;*---------------------------------------------------------------------*/
(define (html-bibentry-ref obj::%bibentry body)
   (with-access::%bibentry obj (stamp parent number id)
      (if body (html body))
      (display " [<a href=\"")
      (referenced-file (container-file (if parent parent (current-document))))
      (display* "#" id)
      (display "\">")
      (display number)
      (display "</a>]")))

;*---------------------------------------------------------------------*/
;*    html ::%mailto ...                                               */
;*---------------------------------------------------------------------*/
(define-method (html obj::%mailto)
   (with-access::%mailto obj (email body)
      (display "<a href=\"mailto:")
      (if (string? email)
	  (display email)
	  (html body))
      (display "\">")
      (if (pair? body)
	  (html body)
	  (display email))
      (print "</a>")))

;*---------------------------------------------------------------------*/
;*    html ::%item ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (html obj::%item)
   (with-access::%item obj (value body)
      (if (not (null? value))
	  (begin
	     (display "<b>")
	     (html value)
	     (print "</b>")))
      (html body)))

;*---------------------------------------------------------------------*/
;*    html ::%itemize ...                                              */
;*---------------------------------------------------------------------*/
(define-method (html obj::%itemize)
   (with-access::%itemize obj (items)
      (print "<ul>")
      (for-each (lambda (item)
		   (display " <li>")
		   (html item)
		   (newline))
		items)
      (print "</ul>")))
      
;*---------------------------------------------------------------------*/
;*    html ::%enumerate ...                                            */
;*---------------------------------------------------------------------*/
(define-method (html obj::%enumerate)
   (with-access::%enumerate obj (items)
      (print "<ol>")
      (for-each (lambda (item)
		   (display " <li>")
		   (html item)
		   (newline))
		items)
      (print "</ol>")))

;*---------------------------------------------------------------------*/
;*    html ::%description ...                                          */
;*    -------------------------------------------------------------    */
;*    The description does not use the method defined over %ITEM       */
;*    to render its items.                                             */
;*---------------------------------------------------------------------*/
(define-method (html obj::%description)
   (with-access::%description obj (items)
      (print "<dl>")
      (for-each (lambda (item)
		   (with-access::%item item (body value)
		      (for-each (lambda (i)
				   (display " <dt>")
				   (html i)
				   (print "</dt>"))
				(if (pair? value)
				    value
				    (list value)))
		      (display "<dd>")
		      (html body)
		      (print "</dd>")))
		items)
      (print "</dl>")))
      
;*---------------------------------------------------------------------*/
;*    make-section-title ...                                           */
;*---------------------------------------------------------------------*/
(define (make-section-title obj)
   (with-access::%section obj (title number)
      (if (not number)
	  (values "" title)
	  (values (string-append (title-number obj) " ")
		  (if (string? title)
		      title
		      (with-output-to-string 
			 (lambda () (html title))))))))

;*---------------------------------------------------------------------*/
;*    do-section ...                                                   */
;*---------------------------------------------------------------------*/
(define (do-section title stitle body)
   (newline)
   (print "<!-- " stitle " -->")
   (print "<a name=\"" title "\">")
   (*scribe-html-section-start*)
   (*scribe-html-section-title-start*)
   (if (string? *scribe-tforeground*)
       (print "<font color=\"" *scribe-tforeground* "\">"))
   (display stitle)
   (if (string? *scribe-tforeground*)
       (print "</font>"))
   (*scribe-html-section-title-stop*)
   (newline)
   (html body)
   (*scribe-html-section-stop*))
   
;*---------------------------------------------------------------------*/
;*    html ::%section ...                                              */
;*---------------------------------------------------------------------*/
(define-method (html obj::%section)
   (with-access::%section obj (stamp title body)
      (multiple-value-bind (num title)
	 (make-section-title obj)
	 (do-section stamp (string-append num title) body))))

;*---------------------------------------------------------------------*/
;*    make-subsection-title ...                                        */
;*---------------------------------------------------------------------*/
(define (make-subsection-title obj)
   (with-access::%subsection obj (title number)
      (if (not number)
	  (values "" title)
	  (values (string-append (title-number obj) " ")
		  (if (string? title)
		      title
		      (with-output-to-string 
			 (lambda () (html title))))))))

;*---------------------------------------------------------------------*/
;*    html ::%subsection ...                                           */
;*---------------------------------------------------------------------*/
(define-method (html obj::%subsection)
   (with-access::%subsection obj (stamp body title)
      (newline)
      (print "<!-- " title " -->")
      (print "<a name=\"" stamp "\">")
      (*scribe-html-subsection-start*)
      (*scribe-html-subsection-title-start*)
      (if (string? *scribe-tforeground*)
	  (print "<font color=\"" *scribe-tforeground* "\">"))
      (multiple-value-bind (num title)
	 (make-subsection-title obj)
	 (display* num title))
      (if (string? *scribe-tforeground*)
	  (print "</font>"))
      (*scribe-html-subsection-title-stop*)
      (newline)
      (html body)
      (*scribe-html-subsection-stop*)))

;*---------------------------------------------------------------------*/
;*    make-subsubsection-title ...                                     */
;*---------------------------------------------------------------------*/
(define (make-subsubsection-title obj)
   (with-access::%subsubsection obj (title number)
      (if (not number)
	  (values "" title)
	  (values (string-append (title-number obj) " " title)
		  (if (string? title)
		      title
		      (with-output-to-string 
			 (lambda () (html title))))))))

;*---------------------------------------------------------------------*/
;*    html ::%subsubsection ...                                        */
;*---------------------------------------------------------------------*/
(define-method (html obj::%subsubsection)
   (with-access::%subsubsection obj (stamp body title)
      (newline)
      (print "<!-- " title " -->")
      (print "<a name=\"" stamp "\">")
      (*scribe-html-subsubsection-start*)
      (*scribe-html-subsubsection-title-start*)
      (if (string? *scribe-tforeground*)
	  (print "<font color=\"" *scribe-tforeground* "\">"))
      (multiple-value-bind (num title)
	 (make-subsubsection-title obj)
	 (display num))
      (if (string? *scribe-tforeground*)
	  (print "</font>"))
      (*scribe-html-subsubsection-title-stop*)
      (newline)
      (html body)
      (*scribe-html-subsubsection-stop*)))

;*---------------------------------------------------------------------*/
;*    html ::%paragraph ...                                            */
;*---------------------------------------------------------------------*/
(define-method (html obj::%paragraph)
   (with-access::%paragraph obj (body)
      (newline)
      (*scribe-html-paragraph-start*)
      (html body)
      (*scribe-html-paragraph-stop*)))

;*---------------------------------------------------------------------*/
;*    make-chapter-title ...                                           */
;*---------------------------------------------------------------------*/
(define (make-chapter-title obj full)
   (with-access::%chapter obj (title subtitle number)
      (let* ((doc (current-document))
	     (title (cond
		       (title
			title)
		       ((and full
			     (%document? doc)
			     (or (string? (%document-title doc))
				 (and (pair? (%document-title doc))
				      (string? (car (%document-title doc))))))
			(string-append (if (string? (%document-title doc))
					   (%document-title doc)
					   (car (%document-title doc)))
				       " -- "
				       subtitle))
		       (else
			subtitle))))
	 (if (not number)
	     (values "" title)
	     (values (string-append (title-number obj) ". ")
		     (if (string? title)
			 title
			 (with-output-to-string 
			    (lambda () (html title)))))))))

;*---------------------------------------------------------------------*/
;*    html ::%chapter ...                                              */
;*---------------------------------------------------------------------*/
(define-method (html obj::%chapter)
   (with-chapter
    obj
    (lambda ()
       (with-access::%chapter obj (body file title subtitle stamp footnotes)
	  (if (string? file)
	      (with-output-to-file (string-append (prefix file) ".html")
		 (lambda ()
		    (print "<!-- " (or title subtitle) " -->")
		    (print "<a name=\"" stamp "\">")
		    (multiple-value-bind (num title)
		       (make-chapter-title obj #t)
		       (scribe-document->html (string-append num title)
					      '()
					      body
					      footnotes))))
	      (begin
		 (display "<br>")
		 (multiple-value-bind (num title)
		    (make-chapter-title obj #t)
		    (do-section stamp
				(string-append num title)
				body))))))))

;*---------------------------------------------------------------------*/
;*    html ::%hrule ...                                                */
;*---------------------------------------------------------------------*/
(define-method (html obj::%hrule)
   (with-access::%hrule obj (width height)
      (display "<hr")
      (if (< width 100) (display* " width=\"" (html-width width) "\""))
      (if (> height 1) (display* " size=\"" height "\""))
      (print ">")))

;*---------------------------------------------------------------------*/
;*    html ::%font ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (html obj::%font)
   (with-access::%font obj (size face body)
      (display "<font")
      (if size (display* " size=\"" size))
      (if face (display* " face=\"" face))
      (print "\">")
      (html body)
      (print "</font>")))

;*---------------------------------------------------------------------*/
;*    html ::%image ...                                                */
;*---------------------------------------------------------------------*/
(define-method (html obj::%image)
   (with-access::%image obj (file width height zoom body)
      (display* "<img src=\"" file "\"")
      (if body
	  (begin
	     (display " alt=\"")
	     (html body)
	     (display "\""))
	  (display* " alt=\"" file "\""))
      (if width (display* " width=\"" (html-width width) "\""))
      (if height (display* " height=\"" height "\""))
      (if zoom (display* " zoom=\"" zoom "\""))
      (display ">")))

;*---------------------------------------------------------------------*/
;*    html ::%table ...                                                */
;*---------------------------------------------------------------------*/
(define-method (html obj::%table)
   (with-access::%table obj (rows width border cellpadding)
      (display "<table")
      (if width (display* " width=\"" (html-width width) "\""))
      (if border (display* " border=\"" border "\""))
      (if (> cellpadding 0) (display* " cellpadding='" cellpadding "'"))
      (print ">")
      (for-each html rows)
      (print "</table>")))

;*---------------------------------------------------------------------*/
;*    html ::%table-row ...                                            */
;*---------------------------------------------------------------------*/
(define-method (html obj::%table-row)
   (with-access::%table-row obj (cells bg)
      (display "<tr")
      (if bg
	  (display* " bgcolor=\"" bg "\">")
	  (display ">"))
      (for-each html cells)
      (print "</tr>")))

;*---------------------------------------------------------------------*/
;*    html ::%table-cell ...                                           */
;*---------------------------------------------------------------------*/
(define-method (html obj::%table-cell)
   (with-access::%table-cell obj (width align valign colspan rowspan)
      (if width (display* " width=\"" (html-width width) "\""))
      (if align (display* " align=\"" align "\""))
      (if valign (display* " valign=\"" valign "\""))
      (if colspan (display* " colspan=\"" colspan "\""))
      (if rowspan (display* " rowspan=\"" rowspan "\""))
      (display ">"))
   (call-next-method))
      
;*---------------------------------------------------------------------*/
;*    html ::%table-data ...                                           */
;*---------------------------------------------------------------------*/
(define-method (html obj::%table-data)
   (display "<td")
   (call-next-method)
   (display "</td>"))
    
;*---------------------------------------------------------------------*/
;*    html ::%table-header ...                                         */
;*---------------------------------------------------------------------*/
(define-method (html obj::%table-header)
   (display "<th")
   (call-next-method)
   (display "</th>"))

;*---------------------------------------------------------------------*/
;*    html ::%character ...                                            */
;*---------------------------------------------------------------------*/
(define-method (html obj::%character)
   (case (%character-value obj)
      ((copyright)
       (display "&copy;"))
      ((#\space)
       (display "&#x0020;"))
      ((#\tab)
       (display "&#x0009;"))))

;*---------------------------------------------------------------------*/
;*    html ::%hook ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (html obj::%hook)
   (with-access::%hook obj (body before after process)
      (if (procedure? before)
	  (let ((bef (before)))
	     (if process (html bef))))
      (call-next-method)
      (if (procedure? after)
	  (let ((af (after)))
	     (if process (html af))))))

;*---------------------------------------------------------------------*/
;*    html ::%figure ...                                               */
;*---------------------------------------------------------------------*/
(define-method (html obj::%figure)
   (with-access::%figure obj (body legend number)
      (print "<br>")
      (html body)
      (print "<br>")
      (if number (display* "<b>Fig. " number ": </b>"))
      (html legend)
      (display "<br>")))

;*---------------------------------------------------------------------*/
;*    html ::%footnote ...                                             */
;*---------------------------------------------------------------------*/
(define-method (html obj::%footnote)
   (with-access::%footnote obj (note body number id)
      (display* "<a name=\"from:" id "\">")
      (html body)
      (display "</a>")
      (display* "<a href=\"#to:" id "\">" "<sup><small>"
		number
		"</small></sup>" "</a>")))

;*---------------------------------------------------------------------*/
;*    html-footnotes ...                                               */
;*---------------------------------------------------------------------*/
(define (html-footnotes footnotes)
   (if (pair? footnotes)
       (begin
	  (print "<br><br>")
	  (print "<hr width=\"20%\" size='2' align=\"left\">")
	  (for-each (lambda (fn)
		       (with-access::%footnote fn (number note id)
			  (display "<a name=\"")
			  (display* "to:" id)
			  (display "\">")
			  (display* "<a href=\"#from:" id "\">")
			  (display* "<sup><small>"
				    (number->string number)
				    "</sup></small></a>: ")
			  (html note)
			  (print "</a>")
			  (print "<br>")))
		    footnotes))))

;*---------------------------------------------------------------------*/
;*    display-unref ...                                                */
;*---------------------------------------------------------------------*/
(define (display-unref anchor::bstring)
   (display* "<b><font color=\"#ff0000\">" anchor "</font></b>"))

;*---------------------------------------------------------------------*/
;*    Top level form to register the newly loaded back-end             */
;*---------------------------------------------------------------------*/
(register-backend! 'sui sui)
(register-backend! 'html html)
