;*=====================================================================*/
;*    serrano/prgm/project/scribe/scribehtmlgui/htmlgui.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Nov 23 10:06:33 2001                          */
;*    Last change :  Wed Jan  2 10:56:18 2002 (serrano)                */
;*    Copyright   :  2001-02 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    The htmlgui ast compilation                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __scribehtmlgui_html
   
   (library scribeapi
	    scribehtml)
   
   (import  __scribehtmlgui_ast
	    __scribehtmlgui_api)
   
   (export  (scribehtmlgui-apache-initialize)))

;*---------------------------------------------------------------------*/
;*    scribehtmlgui-apache-initialize ...                              */
;*---------------------------------------------------------------------*/
(define (scribehtmlgui-apache-initialize)
   (scribehtmlgui-api-apache-initialize))

;*---------------------------------------------------------------------*/
;*    html ::%form ...                                                 */
;*---------------------------------------------------------------------*/
(define-method (html obj::%form)
   (with-access::%form obj (url submit reset submit-name reset-name method)
      (display "<form ")
      (if (string? method)
	  (display* "method=\"" method "\" "))
      (display* "action=\"" url "\">")
      (call-next-method) 
      (if (string? submit)
	  (print "<input name=\"" submit-name
		 "\" type=\"submit\" value=\"" submit "\">"))
      (if (string? reset)
	  (print "<input name=\""reset-name
		 "\" type=\"reset\" value=\"" reset "\">"))
      (display "</form>")))

;*---------------------------------------------------------------------*/
;*    html ::%label ...                                                */
;*---------------------------------------------------------------------*/
(define-method (html obj::%label)
   (display "<label for=\"firstname\">")
   (call-next-method)
   (display "</label>"))

;*---------------------------------------------------------------------*/
;*    html ::%button ...                                               */
;*---------------------------------------------------------------------*/
(define-method (html obj::%button)
   (with-access::%button obj (name)
      (display* "<button name=\"" name "\">")
      (call-next-method)
      (display "</button>")))

;*---------------------------------------------------------------------*/
;*    html ::%checkbutton ...                                          */
;*---------------------------------------------------------------------*/
(define-method (html obj::%checkbutton)
   (with-access::%checkbutton obj (name)
      (display* "<input type=\"checkbox\" name=\"" name "\">")
      (call-next-method)))

;*---------------------------------------------------------------------*/
;*    html ::%entry ...                                                */
;*---------------------------------------------------------------------*/
(define-method (html obj::%entry)
   (with-access::%entry obj (name default width)
      (display* "<input type=\"text\" name=\"" name "\" size=\"" width "\"")
      (if (string? default) (display* " value=\"" default "\""))
      (display ">")))

;*---------------------------------------------------------------------*/
;*    html ::%passwd ...                                               */
;*---------------------------------------------------------------------*/
(define-method (html obj::%passwd)
   (with-access::%passwd obj (name width)
      (display* "<input type=\"password\" name=\"" name
		"\" size=\"" width "\"")
      (display ">")))
   

;*---------------------------------------------------------------------*/
;*    html ::%editor ...                                               */
;*---------------------------------------------------------------------*/
(define-method (html obj::%editor)
   (with-access::%editor obj (name ronly rows cols)
      (display* "<textarea name=\"" name
		"\" rows=\"" rows "\" cols=\"" cols "\"")
      (if ronly (display " readonly"))
      (print ">")
      (call-next-method)
      (display "</textarea>")))

;*---------------------------------------------------------------------*/
;*    html ::%radio ...                                                */
;*---------------------------------------------------------------------*/
(define-method (html obj::%radio)
   (with-access::%radio obj (body orientation name value)
      (for-each (lambda (v)
		   (display* "<input type=\"radio\" name=\"" name
			     "\" value=\"" (car v) "\"")
		   (if (equal? value (car v)) (display " selected"))
		   (display "> ")
		   (html (cadr v))
		   (if (eq? orientation 'vertical)
		       (print "<br>")))
		body)))
			     
;*---------------------------------------------------------------------*/
;*    html ::%fileselector ...                                         */
;*---------------------------------------------------------------------*/
(define-method (html obj::%fileselector)
   (with-access::%fileselector obj (name width)
      (display* "<input type=\"file\" name=\"" name "\" size=\"" width "\"")
      (display ">")))

;*---------------------------------------------------------------------*/
;*    html ::%listbox ...                                              */
;*---------------------------------------------------------------------*/
(define-method (html obj::%listbox)
   (with-access::%listbox obj (name height items selected-items)
      (print "<select multiple size=\"" height "\" name=\"" name "\">")
      (for-each (lambda (i)
		   (if (member i selected-items)
		       (display "<option selected>")
		       (display "<option>"))
		   (display i)
		   (print "</option>"))
		items)
      (print "</select>")))
 
;*---------------------------------------------------------------------*/
;*    html ::%combobox ...                                             */
;*---------------------------------------------------------------------*/
(define-method (html obj::%combobox)
   (with-access::%combobox obj (name items selected-item)
      (print "<select name=\"" name "\">")
      (for-each (lambda (i)
		   (if (equal? i selected-item)
		       (display "<option selected>")
		       (display "<option>"))
		   (display i)
		   (print "</option>"))
		items)
      (print "</select>")))
 
;*---------------------------------------------------------------------*/
;*    html ::%hidden ...                                               */
;*---------------------------------------------------------------------*/
(define-method (html obj::%hidden)
   (with-access::%hidden obj (name body)
      (display* "<input type=\"hidden\" name=\"" name)
      (display "\" value=\"")
      (html body)
      (display "\"")
      (display ">")))
   
