<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE TS><TS version="1.1">
<context>
    <name></name>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="21"/>
        <source>getColorNames() -&gt; list

Returns a list containing the names of all defined colors in the document.
If no document is open, returns a list of the default document colors.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="35"/>
        <source>getColor(&quot;name&quot;) -&gt; tuple

Returns a tuple (C, M, Y, K) containing the four color components of the
color &quot;name&quot; from the current document. If no document is open, returns
the value of the named color from the default document colors.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="50"/>
        <source>getColorAsRGB(&quot;name&quot;) -&gt; tuple

Returns a tuple (R,G,B) containing the three color components of the
color &quot;name&quot; from the current document, converted to the RGB color
space. If no document is open, returns the value of the named color
from the default document colors.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="64"/>
        <source>changeColor(&quot;name&quot;, c, m, y, k)

Changes the color &quot;name&quot; to the specified CMYK value. The color value is
defined via four components c = Cyan, m = Magenta, y = Yellow and k = Black.
Color components should be in the range from 0 to 255.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="77"/>
        <source>defineColor(&quot;name&quot;, c, m, y, k)

Defines a new color &quot;name&quot;. The color Value is defined via four components:
c = Cyan, m = Magenta, y = Yellow and k = Black. Color components should be in
the range from 0 to 255.

May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="94"/>
        <source>deleteColor(&quot;name&quot;, &quot;replace&quot;)

Deletes the color &quot;name&quot;. Every occurence of that color is replaced by the
color &quot;replace&quot;. If not specified, &quot;replace&quot; defaults to the color
&quot;None&quot; - transparent.

deleteColor works on the default document colors if there is no document open.
In that case, &quot;replace&quot;, if specified, has no effect.

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="106"/>
        <source>replaceColor(&quot;name&quot;, &quot;replace&quot;)

Every occurence of the color &quot;name&quot; is replaced by the color &quot;replace&quot;.

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="22"/>
        <source>newDocDialog() -&gt; bool

Displays the &quot;New Document&quot; dialog box. Creates a new document if the user
accepts the settings. Does not create a document if the user presses cancel.
Returns true if a new document was created.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="46"/>
        <source>fileDialog(&quot;caption&quot;, [&quot;filter&quot;, &quot;defaultname&quot;, haspreview, issave, isdir]) -&gt; string with filename

Shows a File Open dialog box with the caption &quot;caption&quot;. Files are filtered
with the filter string &quot;filter&quot;. A default filename or file path can also
supplied, leave this string empty when you don&apos;t want to use it.  A value of
True for haspreview enables a small preview widget in the FileSelect box.  When
the issave parameter is set to True the dialog acts like a &quot;Save As&quot; dialog
otherwise it acts like a &quot;File Open Dialog&quot;. When the isdir parameter is True
the dialog shows and returns only directories. The default for all of the
optional parameters is False.

The filter, if specified, takes the form &apos;comment (*.type *.type2 ...)&apos;.
For example &apos;Images (*.png *.xpm *.jpg)&apos;.

Refer to the Qt-Documentation for QFileDialog for details on filters.

Example: fileDialog(&apos;Open input&apos;, &apos;CSV files (*.csv)&apos;)
Example: fileDialog(&apos;Save report&apos;, defaultname=&apos;report.txt&apos;, issave=True)
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="88"/>
        <source>messageBox(&quot;caption&quot;, &quot;message&quot;,
    icon=ICON_NONE, button1=BUTTON_OK|BUTTONOPT_DEFAULT,
    button2=BUTTON_NONE, button3=BUTTON_NONE) -&gt; integer

Displays a message box with the title &quot;caption&quot;, the message &quot;message&quot;, and
an icon &quot;icon&quot; and up to 3 buttons. By default no icon is used and a single
button, OK, is displayed. Only the caption and message arguments are required,
though setting an icon and appropriate button(s) is strongly
recommended. The message text may contain simple HTML-like markup.

Returns the number of the button the user pressed. Button numbers start
at 1.

For the icon and the button parameters there are predefined constants available
with the same names as in the Qt Documentation. These are the BUTTON_* and
ICON_* constants defined in the module. There are also two extra constants that
can be binary-ORed with button constants:
    BUTTONOPT_DEFAULT   Pressing enter presses this button.
    BUTTONOPT_ESCAPE    Pressing escape presses this button.

Usage examples:
result = messageBox(&apos;Script failed&apos;,
                    &apos;This script only works when you have a text frame selected.&apos;,
                    ICON_ERROR)
result = messageBox(&apos;Monkeys!&apos;, &apos;Something went ook! &lt;i&gt;Was it a monkey?&lt;/i&gt;&apos;,
                    ICON_WARNING, BUTTON_YES|BUTTONOPT_DEFAULT,
                    BUTTON_NO, BUTTON_IGNORE|BUTTONOPT_ESCAPE)

Defined button and icon constants:
BUTTON_NONE, BUTTON_ABORT, BUTTON_CANCEL, BUTTON_IGNORE, BUTTON_NO,
BUTTON_NOALL, BUTTON_OK, BUTTON_RETRY, BUTTON_YES, BUTTON_YESALL,
ICON_NONE, ICON_INFORMATION, ICON_WARNING, ICON_CRITICAL.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="101"/>
        <source>valueDialog(caption, message [,defaultvalue]) -&gt; string

Shows the common &apos;Ask for string&apos; dialog and returns its value as a string
Parameters: window title, text in the window and optional &apos;default&apos; value.

Example: valueDialog(&apos;title&apos;, &apos;text in the window&apos;, &apos;optional&apos;)
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="111"/>
        <source>newStyleDialog() -&gt; string

Shows &apos;Create new paragraph style&apos; dialog. Function returns real
style name or None when user cancels the dialog.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="55"/>
        <source>newDocument(size, margins, orientation, firstPageNumber,
                        unit, pagesType, firstPageOrder, numPages) -&gt; bool

Creates a new document and returns true if successful. The parameters have the
following meaning:

size = A tuple (width, height) describing the size of the document. You can
use predefined constants named PAPER_&lt;paper_type&gt; e.g. PAPER_A4 etc.

margins = A tuple (left, right, top, bottom) describing the document
margins

orientation = the page orientation - constants PORTRAIT, LANDSCAPE

firstPageNumer = is the number of the first page in the document used for
pagenumbering. While you&apos;ll usually want 1, it&apos;s useful to have higher
numbers if you&apos;re creating a document in several parts.

unit: this value sets the measurement units used by the document. Use a
predefined constant for this, one of: UNIT_INCHES, UNIT_MILLIMETERS,
UNIT_PICAS, UNIT_POINTS.

pagesType = One of the predefined constants PAGE_n. PAGE_1 is single page,
PAGE_2 is for double sided documents, PAGE_3 is for 3 pages fold and
PAGE_4 is 4-fold.

firstPageOrder = What is position of first page in the document.
Indexed from 0 (0 = first).

numPage = Number of pages to be created.

The values for width, height and the margins are expressed in the given unit
for the document. PAPER_* constants are expressed in points. If your document
is not in points, make sure to account for this.

example: newDocument(PAPER_A4, (10, 10, 20, 20), LANDSCAPE, 7, UNIT_POINTS,
PAGE_4, 3, 1)

May raise ScribusError if is firstPageOrder bigger than allowed by pagesType.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="96"/>
        <source>newDoc(size, margins, orientation, firstPageNumber,
                   unit, facingPages, firstSideLeft) -&gt; bool

WARNING: Obsolete procedure! Use newDocument instead.

Creates a new document and returns true if successful. The parameters have the
following meaning:

    size = A tuple (width, height) describing the size of the document. You can
    use predefined constants named PAPER_&lt;paper_type&gt; e.g. PAPER_A4 etc.

    margins = A tuple (left, right, top, bottom) describing the document
    margins

    orientation = the page orientation - constants PORTRAIT, LANDSCAPE

    firstPageNumer = is the number of the first page in the document used for
    pagenumbering. While you&apos;ll usually want 1, it&apos;s useful to have higher
    numbers if you&apos;re creating a document in several parts.

    unit: this value sets the measurement units used by the document. Use a
    predefined constant for this, one of: UNIT_INCHES, UNIT_MILLIMETERS,
    UNIT_PICAS, UNIT_POINTS.

    facingPages = FACINGPAGES, NOFACINGPAGES

    firstSideLeft = FIRSTPAGELEFT, FIRSTPAGERIGHT

The values for width, height and the margins are expressed in the given unit
for the document. PAPER_* constants are expressed in points. If your document
is not in points, make sure to account for this.

example: newDoc(PAPER_A4, (10, 10, 20, 20), LANDSCAPE, 1, UNIT_POINTS,
                FACINGPAGES, FIRSTPAGERIGHT)
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="108"/>
        <source>closeDoc()

Closes the current document without prompting to save.

May throw NoDocOpenError if there is no document to close
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="117"/>
        <source>haveDoc() -&gt; bool

Returns true if there is a document open.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="128"/>
        <source>openDoc(&quot;name&quot;)

Opens the document &quot;name&quot;.

May raise ScribusError if the document could not be opened.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="141"/>
        <source>saveDoc()

Saves the current document with its current name, returns true if successful.
If the document has not already been saved, this may bring up an interactive
save file dialog.

If the save fails, there is currently no way to tell.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="152"/>
        <source>saveDocAs(&quot;name&quot;)

Saves the current document under the new name &quot;name&quot; (which may be a full or
relative path).

May raise ScribusError if the save fails.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="162"/>
        <source>setInfo(&quot;author&quot;, &quot;info&quot;, &quot;description&quot;) -&gt; bool

Sets the document information. &quot;Author&quot;, &quot;Info&quot;, &quot;Description&quot; are
strings.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="173"/>
        <source>setMargins(lr, rr, tr, br)

Sets the margins of the document, Qt::DockLeft(lr), Qt::DockRight(rr), Qt::DockTop(tr) and Qt::DockBottom(br)
margins are given in the measurement units of the document - see UNIT_&lt;type&gt;
constants.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="185"/>
        <source>setUnit(type)

Changes the measurement unit of the document. Possible values for &quot;unit&quot; are
defined as constants UNIT_&lt;type&gt;.

May raise ValueError if an invalid unit is passed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="196"/>
        <source>getUnit() -&gt; integer (Scribus unit constant)

Returns the measurement units of the document. The returned value will be one
of the UNIT_* constants:
UNIT_INCHES, UNIT_MILLIMETERS, UNIT_PICAS, UNIT_POINTS.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="206"/>
        <source>loadStylesFromFile(&quot;filename&quot;)

Loads paragraph styles from the Scribus document at &quot;filename&quot; into the
current document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="218"/>
        <source>setDocType(facingPages, firstPageLeft)

Sets the document type. To get facing pages set the first parameter to
FACINGPAGES, to switch facingPages off use NOFACINGPAGES instead.  If you want
to be the first page a left side set the second parameter to FIRSTPAGELEFT, for
a right page use FIRSTPAGERIGHT.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="226"/>
        <source>closeMasterPage()

Closes the currently active master page, if any, and returns editing
to normal. Begin editing with editMasterPage().
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="233"/>
        <source>masterPageNames()

Returns a list of the names of all master pages in the document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="241"/>
        <source>editMasterPage(pageName)

Enables master page editing and opens the named master page
for editing. Finish editing with closeMasterPage().
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="249"/>
        <source>createMasterPage(pageName)

Creates a new master page named pageName and opens it for
editing.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="256"/>
        <source>deleteMasterPage(pageName)

Delete the named master page.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="21"/>
        <source>getFillColor([&quot;name&quot;]) -&gt; string

Returns the name of the fill color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="31"/>
        <source>getFillTransparency([&quot;name&quot;]) -&gt; float

Returns the fill transparency of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="41"/>
        <source>getFillBlendmode([&quot;name&quot;]) -&gt; integer

Returns the fill blendmode of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="51"/>
        <source>getLineColor([&quot;name&quot;]) -&gt; string

Returns the name of the line color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="61"/>
        <source>getLineTransparency([&quot;name&quot;]) -&gt; float

Returns the line transparency of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="71"/>
        <source>getLineBlendmode([&quot;name&quot;]) -&gt; integer

Returns the line blendmode of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="81"/>
        <source>getLineWidth([&quot;name&quot;]) -&gt; integer

Returns the line width of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="91"/>
        <source>getLineShade([&quot;name&quot;]) -&gt; integer

Returns the shading value of the line color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="102"/>
        <source>getLineJoin([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line join style of the object &quot;name&quot;. If &quot;name&quot; is not given
the currently selected item is used.  The join types are:
JOIN_BEVEL, JOIN_MITTER, JOIN_ROUND
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="113"/>
        <source>getLineEnd([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line cap style of the object &quot;name&quot;. If &quot;name&quot; is not given the
currently selected item is used. The cap types are:
CAP_FLAT, CAP_ROUND, CAP_SQUARE
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="124"/>
        <source>getLineStyle([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line style of the object &quot;name&quot;. If &quot;name&quot; is not given the
currently selected item is used. Line style constants are:
LINE_DASH, LINE_DASHDOT, LINE_DASHDOTDOT, LINE_DOT, LINE_SOLID
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="134"/>
        <source>getFillShade([&quot;name&quot;]) -&gt; integer

Returns the shading value of the fill color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="145"/>
        <source>getCornerRadius([&quot;name&quot;]) -&gt; integer

Returns the corner radius of the object &quot;name&quot;. The radius is
expressed in points. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="155"/>
        <source>getImageScale([&quot;name&quot;]) -&gt; (x,y)

Returns a (x, y) tuple containing the scaling values of the image frame
&quot;name&quot;.  If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="165"/>
        <source>getImageName([&quot;name&quot;]) -&gt; string

Returns the filename for the image in the image frame. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="177"/>
        <source>getPosition([&quot;name&quot;]) -&gt; (x,y)

Returns a (x, y) tuple with the position of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
The position is expressed in the actual measurement unit of the document
- see UNIT_&lt;type&gt; for reference.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="189"/>
        <source>getSize([&quot;name&quot;]) -&gt; (width,height)

Returns a (width, height) tuple with the size of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used. The size is
expressed in the current measurement unit of the document - see UNIT_&lt;type&gt;
for reference.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="200"/>
        <source>getRotation([&quot;name&quot;]) -&gt; integer

Returns the rotation of the object &quot;name&quot;. The value is expressed in degrees,
and clockwise is positive. If &quot;name&quot; is not given the currently selected item
is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="209"/>
        <source>getAllObjects() -&gt; list

Returns a list containing the names of all objects on the current page.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="83"/>
        <source>getPropertyCType(object, property, includesuper=True)

Returns the name of the C type of `property&apos; of `object&apos;. See getProperty()
for details of arguments.

If `includesuper&apos; is true, search inherited properties too.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="101"/>
        <source>getPropertyNames(object, includesuper=True)

Return a list of property names supported by `object&apos;.
If `includesuper&apos; is true, return properties supported
by parent classes as well.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="135"/>
        <source>getProperty(object, property)

Return the value of the property `property&apos; of the passed `object&apos;.

The `object&apos; argument may be a string, in which case the named PageItem
is searched for. It may also be a PyCObject, which may point to any
C++ QObject instance.

The `property&apos; argument must be a string, and is the name of the property
to look up on `object&apos;.

The return value varies depending on the type of the property.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="165"/>
        <source>setProperty(object, property, value)

Set `property&apos; of `object&apos; to `value&apos;. If `value&apos; cannot be converted to a type
compatible with the type of `property&apos;, an exception is raised. An exception may
also be raised if the underlying setter fails.

See getProperty() for more information.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="23"/>
        <source>moveObject(dx, dy [, &quot;name&quot;])

Moves the object &quot;name&quot; by dx and dy relative to its current position. The
distances are expressed in the current measurement unit of the document (see
UNIT constants). If &quot;name&quot; is not given the currently selected item is used.
If the object &quot;name&quot; belongs to a group, the whole group is moved.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="35"/>
        <source>moveObjectAbs(x, y [, &quot;name&quot;])

Moves the object &quot;name&quot; to a new location. The coordinates are expressed in
the current measurement unit of the document (see UNIT constants).  If &quot;name&quot;
is not given the currently selected item is used.  If the object &quot;name&quot;
belongs to a group, the whole group is moved.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="48"/>
        <source>rotateObject(rot [, &quot;name&quot;])

Rotates the object &quot;name&quot; by &quot;rot&quot; degrees relatively. The object is
rotated by the vertex that is currently selected as the rotation point - by
default, the top left vertex at zero rotation. Positive values mean counter
clockwise rotation when the default rotation point is used. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="59"/>
        <source>rotateObjectAbs(rot [, &quot;name&quot;])

Sets the rotation of the object &quot;name&quot; to &quot;rot&quot;. Positive values
mean counter clockwise rotation. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="69"/>
        <source>sizeObject(width, height [, &quot;name&quot;])

Resizes the object &quot;name&quot; to the given width and height. If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="80"/>
        <source>getSelectedObject([nr]) -&gt; string

Returns the name of the selected object. &quot;nr&quot; if given indicates the number
of the selected object, e.g. 0 means the first selected object, 1 means the
second selected Object and so on.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="89"/>
        <source>selectionCount() -&gt; integer

Returns the number of selected objects.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="98"/>
        <source>selectObject(&quot;name&quot;)

Selects the object with the given &quot;name&quot;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="107"/>
        <source>deselectAll()

Deselects all objects in the whole document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="118"/>
        <source>groupObjects(list)

Groups the objects named in &quot;list&quot; together. &quot;list&quot; must contain the names
of the objects to be grouped. If &quot;list&quot; is not given the currently selected
items are used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="126"/>
        <source>unGroupObjects(&quot;name&quot;)

Destructs the group the object &quot;name&quot; belongs to.If &quot;name&quot; is not given the currently selected item is used.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="141"/>
        <source>scaleGroup(factor [,&quot;name&quot;])

Scales the group the object &quot;name&quot; belongs to. Values greater than 1 enlarge
the group, values smaller than 1 make the group smaller e.g a value of 0.5
scales the group to 50 % of its original size, a value of 1.5 scales the group
to 150 % of its original size.  The value for &quot;factor&quot; must be greater than
0. If &quot;name&quot; is not given the currently selected item is used.

May raise ValueError if an invalid scale factor is passed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="153"/>
        <source>loadImage(&quot;filename&quot; [, &quot;name&quot;])

Loads the picture &quot;picture&quot; into the image frame &quot;name&quot;. If &quot;name&quot; is
not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not an image frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="191"/>
        <source>lockObject([&quot;name&quot;]) -&gt; bool

Locks the object &quot;name&quot; if it&apos;s unlocked or unlock it if it&apos;s locked.
If &quot;name&quot; is not given the currently selected item is used. Returns true
if locked.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="201"/>
        <source>isLocked([&quot;name&quot;]) -&gt; bool

Returns true if is the object &quot;name&quot; locked.  If &quot;name&quot; is not given the
currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="213"/>
        <source>setScaleImageToFrame(scaletoframe, proportional=None, name=&lt;selection&gt;)

Sets the scale to frame on the selected or specified image frame to `scaletoframe&apos;.
If `proportional&apos; is specified, set fixed aspect ratio scaling to `proportional&apos;.
Both `scaletoframe&apos; and `proportional&apos; are boolean.

May raise WrongFrameTypeError.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="24"/>
        <source>setRedraw(bool)

Disables page redraw when bool = False, otherwise redrawing is enabled.
This change will persist even after the script exits, so make sure to call
setRedraw(True) in a finally: clause at the top level of your script.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="33"/>
        <source>getFontNames() -&gt; list

Returns a list with the names of all available fonts.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="43"/>
        <source>getXFontNames() -&gt; list of tuples

Returns a larger font info. It&apos;s a list of the tuples with:
[ (Scribus name, Family, Real name, subset (1|0), embed PS (1|0), font file), (...), ... ]
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="62"/>
        <source>renderFont(&quot;name&quot;, &quot;filename&quot;, &quot;sample&quot;, size, format=&quot;PPM&quot;) -&gt; bool

Creates an image preview of font &quot;name&quot; with given text &quot;sample&quot; and size.
If &quot;filename&quot; is not &quot;&quot;, image is saved into &quot;filename&quot;. Otherwise
image data is returned as a string. The optional &quot;format&quot; argument
specifies the image format to generate, and supports any format allowed
by QPixmap.save(). Common formats are PPM, JPEG, PNG and XPM.

May raise NotFoundError if the specified font can&apos;t be found.
May raise ValueError if an empty sample or filename is passed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="71"/>
        <source>getLayers() -&gt; list

Returns a list with the names of all defined layers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="83"/>
        <source>setActiveLayer(&quot;name&quot;)

Sets the active layer to the layer named &quot;name&quot;.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="92"/>
        <source>getActiveLayer() -&gt; string

Returns the name of the current active layer.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="105"/>
        <source>sentToLayer(&quot;layer&quot; [, &quot;name&quot;])

Sends the object &quot;name&quot; to the layer &quot;layer&quot;. The layer must exist.
If &quot;name&quot; is not given the currently selected item is used.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="118"/>
        <source>setLayerVisible(&quot;layer&quot;, visible)

Sets the layer &quot;layer&quot; to be visible or not. If is the visible set to false
the layer is invisible.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="131"/>
        <source>setLayerPrintable(&quot;layer&quot;, printable)

Sets the layer &quot;layer&quot; to be printable or not. If is the
printable set to false the layer won&apos;t be printed.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="144"/>
        <source>setLayerLocked(&quot;layer&quot;, locked)

Sets the layer &quot;layer&quot; to be locked or not. If locked is set to
true the layer will be locked.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="157"/>
        <source>setLayerOutlined(&quot;layer&quot;, outline)

Sets the layer &quot;layer&quot; to be locked or not. If outline is set to
true the layer will be displayed outlined.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="170"/>
        <source>setLayerFlow(&quot;layer&quot;, flow)

Sets the layers &quot;layer&quot;  flowcontrol to flow. If flow is set to
true text in layers above this one will flow around objects on this layer.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="182"/>
        <source>setLayerBlendmode(&quot;layer&quot;, blend)

Sets the layers &quot;layer&quot;  blendmode to blend.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="194"/>
        <source>setLayerTransparency(&quot;layer&quot;, trans)

Sets the layers &quot;layer&quot;  transparency to trans.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="208"/>
        <source>isLayerVisible(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is visible or not, a value of True means
that the layer &quot;layer&quot; is visible, a value of False means that the layer
&quot;layer&quot; is invisible.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="222"/>
        <source>isLayerPrintable(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is printable or not, a value of True means
that the layer &quot;layer&quot; can be printed, a value of False means that printing
the layer &quot;layer&quot; is disabled.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="236"/>
        <source>isLayerLocked(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is locked or not, a value of True means
that the layer &quot;layer&quot; is editable, a value of False means that the layer
&quot;layer&quot; is locked.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="250"/>
        <source>isLayerOutlined(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is outlined or not, a value of True means
that the layer &quot;layer&quot; is outlined, a value of False means that the layer
&quot;layer&quot; is normal.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="263"/>
        <source>isLayerFlow(&quot;layer&quot;) -&gt; bool

Returns whether text flows around objects on layer &quot;layer&quot;, a value of True means
that text flows around, a value of False means that the text does not flow around.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="275"/>
        <source>getLayerBlendmode(&quot;layer&quot;) -&gt; int

Returns the &quot;layer&quot; layer blendmode,

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="287"/>
        <source>getLayerTransparency(&quot;layer&quot;) -&gt; float

Returns the &quot;layer&quot; layer transparency,

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="300"/>
        <source>deleteLayer(&quot;layer&quot;)

Deletes the layer with the name &quot;layer&quot;. Nothing happens if the layer doesn&apos;t
exists or if it&apos;s the only layer in the document.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="311"/>
        <source>createLayer(layer)

Creates a new layer with the name &quot;name&quot;.

May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="320"/>
        <source>getGuiLanguage() -&gt; string

Returns a string with the -lang value.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="329"/>
        <source>moveSelectionToFront()

Moves current selection to front.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="338"/>
        <source>moveSelectionToFront()

Moves current selection to back.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="26"/>
        <source>createRect(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new rectangle on the current page and returns its name. The
coordinates are given in the current measurement units of the document
(see UNIT constants). &quot;name&quot; should be a unique identifier for the object
because you need this name to reference that object in future. If &quot;name&quot;
is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="43"/>
        <source>createEllipse(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new ellipse on the current page and returns its name.
The coordinates are given in the current measurement units of the document
(see UNIT constants). &quot;name&quot; should be a unique identifier for the object
because you need this name for further referencing of that object. If &quot;name&quot;
is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="60"/>
        <source>createImage(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new picture frame on the current page and returns its name. The
coordinates are given in the current measurement units of the document.
&quot;name&quot; should be a unique identifier for the object because you need this
name for further access to that object. If &quot;name&quot; is not given Scribus will
create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="75"/>
        <source>createText(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new text frame on the actual page and returns its name.
The coordinates are given in the actual measurement unit of the document (see
UNIT constants). &quot;name&quot; should be a unique identifier for the object because
you need this name for further referencing of that object. If &quot;name&quot; is not
given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="90"/>
        <source>createLine(x1, y1, x2, y2, [&quot;name&quot;]) -&gt; string

Creates a new line from the point(x1, y1) to the point(x2, y2) and returns
its name. The coordinates are given in the current measurement unit of the
document (see UNIT constants). &quot;name&quot; should be a unique identifier for the
object because you need this name for further access to that object. If
&quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="108"/>
        <source>createPolyLine(list, [&quot;name&quot;]) -&gt; string

Creates a new polyline and returns its name. The points for the polyline are
stored in the list &quot;list&quot; in the following order: [x1, y1, x2, y2...xn. yn].
The coordinates are given in the current measurement units of the document (see
UNIT constants). &quot;name&quot; should be a unique identifier for the object because
you need this name for further access to that object. If &quot;name&quot; is not given
Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="128"/>
        <source>createPolygon(list, [&quot;name&quot;]) -&gt; string

Creates a new polygon and returns its name. The points for the polygon are
stored in the list &quot;list&quot; in the following order: [x1, y1, x2, y2...xn. yn].
At least three points are required. There is no need to repeat the first point
to close the polygon. The polygon is automatically closed by connecting the
first and the last point.  The coordinates are given in the current measurement
units of the document (see UNIT constants).  &quot;name&quot; should be a unique
identifier for the object because you need this name for further access to that
object. If &quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="149"/>
        <source>createBezierLine(list, [&quot;name&quot;]) -&gt; string

Creates a new bezier curve and returns its name. The points for the bezier
curve are stored in the list &quot;list&quot; in the following order:
[x1, y1, kx1, ky1, x2, y2, kx2, ky2...xn. yn, kxn. kyn]
In the points list, x and y mean the x and y coordinates of the point and kx
and ky meaning the control point for the curve.  The coordinates are given in
the current measurement units of the document (see UNIT constants). &quot;name&quot;
should be a unique identifier for the object because you need this name for
further access to that object. If &quot;name&quot; is not given Scribus will create one
for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="165"/>
        <source>createPathText(x, y, &quot;textbox&quot;, &quot;beziercurve&quot;, [&quot;name&quot;]) -&gt; string

Creates a new pathText by merging the two objects &quot;textbox&quot; and
&quot;beziercurve&quot; and returns its name. The coordinates are given in the current
measurement unit of the document (see UNIT constants). &quot;name&quot; should be a
unique identifier for the object because you need this name for further access
to that object. If &quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise NotFoundError if one or both of the named base object don&apos;t exist.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="177"/>
        <source>deleteObject([&quot;name&quot;])

Deletes the item with the name &quot;name&quot;. If &quot;name&quot; is not given the currently
selected item is deleted.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="193"/>
        <source>textFlowMode(&quot;name&quot; [, state])

Enables/disables &quot;Text Flows Around Frame&quot; feature for object &quot;name&quot;.
Called with parameters string name and optional int &quot;state&quot; (0 &lt;= state &lt;= 3).
Setting &quot;state&quot; to 0 will disable text flow.
Setting &quot;state&quot; to 1 will make text flow around object frame.
Setting &quot;state&quot; to 2 will make text flow around bounding box.
Setting &quot;state&quot; to 3 will make text flow around contour line.
If &quot;state&quot; is not passed, text flow is toggled.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="211"/>
        <source>objectExists([&quot;name&quot;]) -&gt; bool

Test if an object with specified name really exists in the document.
The optional parameter is the object name. When no object name is given,
returns True if there is something selected.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="227"/>
        <source>setStyle(&quot;style&quot; [, &quot;name&quot;])

Apply the named &quot;style&quot; to the object named &quot;name&quot;. If is no object name
given, it&apos;s applied on the selected object.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="240"/>
        <source>getAllStyles() -&gt; list

Return a list of the names of all paragraph styles in the current document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="252"/>
        <source>duplicateObject([&quot;name&quot;]) -&gt; string

creates a Duplicate of the selected Object (or Selection Group).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="26"/>
        <source>newPage(where [,&quot;masterpage&quot;])

Creates a new page. If &quot;where&quot; is -1 the new Page is appended to the
document, otherwise the new page is inserted before &quot;where&quot;. Page numbers are
counted from 1 upwards, no matter what the displayed first page number of your
document is. The optional parameter &quot;masterpage&quot; specifies the name of the
master page for the new page.

May raise IndexError if the page number is out of range
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="36"/>
        <source>currentPage() -&gt; integer

Returns the number of the current working page. Page numbers are counted from 1
upwards, no matter what the displayed first page number of your document is.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="45"/>
        <source>redrawAll()

Redraws all pages.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="54"/>
        <source>getPageType() -&gt; integer

Returns the type of the Page, 0 means left Page, 1 is a middle Page and 2 is a right Page
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="65"/>
        <source>savePageAsEPS(&quot;name&quot;)

Saves the current page as an EPS to the file &quot;name&quot;.

May raise ScribusError if the save failed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="78"/>
        <source>deletePage(nr)

Deletes the given page. Does nothing if the document contains only one page.
Page numbers are counted from 1 upwards, no matter what the displayed first
page number is.

May raise IndexError if the page number is out of range
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="91"/>
        <source>gotoPage(nr)

Moves to the page &quot;nr&quot; (that is, makes the current page &quot;nr&quot;). Note that
gotoPage doesn&apos;t (currently) change the page the user&apos;s view is displaying, it
just sets the page that script commands will operates on.

May raise IndexError if the page number is out of range.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="100"/>
        <source>pageCount() -&gt; integer

Returns the number of pages in the document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="110"/>
        <source>getHGuides() -&gt; list

Returns a list containing positions of the horizontal guides. Values are in the
document&apos;s current units - see UNIT_&lt;type&gt; constants.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="123"/>
        <source>setHGuides(list)

Sets horizontal guides. Input parameter must be a list of guide positions
measured in the current document units - see UNIT_&lt;type&gt; constants.

Example: setHGuides(getHGuides() + [200.0, 210.0] # add new guides without any lost
         setHGuides([90,250]) # replace current guides entirely
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="132"/>
        <source>getVGuides()

See getHGuides.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="141"/>
        <source>setVGuides()

See setHGuides.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="151"/>
        <source>getPageSize() -&gt; tuple

Returns a tuple with page dimensions measured in the document&apos;s current units.
See UNIT_&lt;type&gt; constants and getPageMargins()
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="167"/>
        <source>getPageItems() -&gt; list

Returns a list of tuples with items on the current page. The tuple is:
(name, objectType, order) E.g. [(&apos;Text1&apos;, 4, 0), (&apos;Image1&apos;, 2, 1)]
means that object named &apos;Text1&apos; is a text frame (type 4) and is the first at
the page...
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="181"/>
        <source>getPageMargins()

Returns the page margins as a (top, left, right, bottom) tuple in the current
units. See UNIT_&lt;type&gt; constants and getPageSize().
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="198"/>
        <source>importPage(&quot;fromDoc&quot;, (pageList), [create, imortwhere, importwherePage])

Imports a set of pages (given as a tuple) from an existing document (the file name must be given). This functions maps the &quot;Page-&gt;Import&quot; dropdown menu function.
fromDoc: string; the filename of the document to import pages from
pageList: tuple with page numbers of pages to import
create: number; 0 to replace existing pages, 1 (default) to insert new pages
importWhere: number; the page number (of the current document) at which import the pages
importWherePage: number; used if create==1; 0 to create pages before selected page; 1 to create pages after selected page; 2 (default) to create pages at the end of the document
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="22"/>
        <source>setGradientFill(type, &quot;color1&quot;, shade1, &quot;color2&quot;, shade2, [&quot;name&quot;])

Sets the gradient fill of the object &quot;name&quot; to type. Color descriptions are
the same as for setFillColor() and setFillShade(). See the constants for
available types (FILL_&lt;type&gt;).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="44"/>
        <source>setFillColor(&quot;color&quot;, [&quot;name&quot;])

Sets the fill color of the object &quot;name&quot; to the color &quot;color&quot;. &quot;color&quot;
is the name of one of the defined colors. If &quot;name&quot; is not given the
currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="54"/>
        <source>setFillTransparency(transparency, [&quot;name&quot;])

Sets the fill transparency of the object &quot;name&quot; to transparency
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="64"/>
        <source>setFillBlendmode(blendmode, [&quot;name&quot;])

Sets the fill blendmode of the object &quot;name&quot; to blendmode
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="74"/>
        <source>setLineColor(&quot;color&quot;, [&quot;name&quot;])

Sets the line color of the object &quot;name&quot; to the color &quot;color&quot;. If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="84"/>
        <source>setLineTransparency(transparency, [&quot;name&quot;])

Sets the line transparency of the object &quot;name&quot; to transparency
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="94"/>
        <source>setLineBlendmode(blendmode, [&quot;name&quot;])

Sets the line blendmode of the object &quot;name&quot; to blendmode
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="107"/>
        <source>setLineWidth(width, [&quot;name&quot;])

Sets line width of the object &quot;name&quot; to &quot;width&quot;. &quot;width&quot; must be in the
range from 0.0 to 12.0 inclusive, and is measured in points. If &quot;name&quot; is not
given the currently selected item is used.

May raise ValueError if the line width is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="121"/>
        <source>setLineShade(shade, [&quot;name&quot;])

Sets the shading of the line color of the object &quot;name&quot; to &quot;shade&quot;.
&quot;shade&quot; must be an integer value in the range from 0 (lightest) to 100
(full color intensity). If &quot;name&quot; is not given the currently selected item
is used.

May raise ValueError if the line shade is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="132"/>
        <source>setLineJoin(join, [&quot;name&quot;])

Sets the line join style of the object &quot;name&quot; to the style &quot;join&quot;.
If &quot;name&quot; is not given the currently selected item is used. There are
predefined constants for join - JOIN_&lt;type&gt;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="143"/>
        <source>setLineEnd(endtype, [&quot;name&quot;])

Sets the line cap style of the object &quot;name&quot; to the style &quot;cap&quot;.
If &quot;name&quot; is not given the currently selected item is used. There are
predefined constants for &quot;cap&quot; - CAP_&lt;type&gt;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="154"/>
        <source>setLineStyle(style, [&quot;name&quot;])

Sets the line style of the object &quot;name&quot; to the style &quot;style&quot;. If &quot;name&quot;
is not given the currently selected item is used. There are predefined
constants for &quot;style&quot; - LINE_&lt;style&gt;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="168"/>
        <source>setFillShade(shade, [&quot;name&quot;])

Sets the shading of the fill color of the object &quot;name&quot; to &quot;shade&quot;.
&quot;shade&quot; must be an integer value in the range from 0 (lightest) to 100
(full Color intensity). If &quot;name&quot; is not given the currently selected
Item is used.

May raise ValueError if the fill shade is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="180"/>
        <source>setCornerRadius(radius, [&quot;name&quot;])

Sets the corner radius of the object &quot;name&quot;. The radius is expressed
in points. If &quot;name&quot; is not given the currently selected item is used.

May raise ValueError if the corner radius is negative.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="192"/>
        <source>setMultiLine(&quot;namedStyle&quot;, [&quot;name&quot;])

Sets the line style of the object &quot;name&quot; to the named style &quot;namedStyle&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise NotFoundError if the line style doesn&apos;t exist.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdstyle.h" line="43"/>
        <source>createParagraphStyle(...)

Creates a paragraph style. This function takes the following keyword parameters:

&quot;name&quot; [required] -&gt; specifies the name of the paragraphstyle to create

linespacingmode [optional] -&gt; specifies the linespacing mode; possible modes are:

fixed linespacing:          0

automatic linespacing:      1

baseline grid linespacing:  2

linespacing [optional] -&gt; specifies the linespacing if using fixed linespacing

alignment [optional] -&gt; specifies the alignment of the paragraph

-&gt; left:     0

-&gt; center:   1

-&gt; right:    2

-&gt; justify:  3

-&gt; extend:   4

leftmargin [optional], rightmargin [optional] -&gt; specify the margin

gapbefore [optional], gapafter [optional] -&gt; specify the gaps to the heading and following paragraphs

firstindent [optional] -&gt; the indent of the first line

hasdropcap [optional] -&gt; specifies if there are caps (1 = yes, 0 = no)

dropcaplines [optional] -&gt; height (in lines) of the caps if used

dropcapoffset [optional] -&gt; offset of the caps if used

&quot;charstyle&quot; [optional] -&gt; char style to use

</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdstyle.h" line="80"/>
        <source>createCharStyle(...)

Creates a character style. This function takes the following keyword parameters:

&quot;name&quot; [required] -&gt; name of the char style to create

&quot;font&quot; [optional] -&gt; name of the font to use

fontsize [optional] -&gt; font size to set (double)

&quot;features&quot; [optional] -&gt; nearer typographic details can be defined by a string that might contain the following phrases comma-seperated (without spaces!):

-&gt; inherit

-&gt; bold

-&gt; italic

-&gt; underline

-&gt; underlinewords

-&gt; strike

-&gt; superscript

-&gt; subscript

-&gt; outline

-&gt; shadowed

-&gt; allcaps

-&gt; smallcaps

&quot;fillcolor&quot; [optional], &quot;fillshade&quot; [optional] -&gt; specify fill options

&quot;strokecolor&quot; [optional], &quot;strokeshade&quot; [optional] -&gt; specify stroke options

baselineoffset [optional] -&gt; offset of the baseline

shadowxoffset [optional], shadowyoffset [optional] -&gt; offset of the shadow if used

outlinewidth [optional] -&gt; width of the outline if used

underlineoffset [optional], underlinewidth [optional] -&gt; underline options if used

strikethruoffset [optional], strikethruwidth [optional] -&gt; strikethru options if used

scaleh [optional], scalev [optional] -&gt; scale of the chars

tracking [optional] -&gt; tracking of the text

&quot;language&quot; [optional] -&gt; language code

</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="23"/>
        <source>getFontSize([&quot;name&quot;]) -&gt; float

Returns the font size in points for the text frame &quot;name&quot;. If this text
frame has some text selected the value assigned to the first character of
the selection is returned.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="35"/>
        <source>getFont([&quot;name&quot;]) -&gt; string

Returns the font name for the text frame &quot;name&quot;. If this text frame
has some text selected the value assigned to the first character
of the selection is returned. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="45"/>
        <source>getTextLength([&quot;name&quot;]) -&gt; integer

Returns the length of the text in the text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="55"/>
        <source>getTextLines([&quot;name&quot;]) -&gt; integer

Returns the number of lines of the text in the text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="67"/>
        <source>getText([&quot;name&quot;]) -&gt; string

Returns the text of the text frame &quot;name&quot;. If this text frame has some text
selected, the selected text is returned. All text in the frame, not just
currently visible text, is returned. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="79"/>
        <source>getAllText([&quot;name&quot;]) -&gt; string

Returns the text of the text frame &quot;name&quot; and of all text frames which are
linked with this frame. If this textframe has some text selected, the selected
text is returned. If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="89"/>
        <source>getLineSpacing([&quot;name&quot;]) -&gt; float

Returns the line spacing (&quot;leading&quot;) of the text frame &quot;name&quot; expressed in
points. If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="100"/>
        <source>getTextDistances([&quot;name&quot;]) -&gt; tuple

Returns the text distances of the text frame &quot;name&quot; expressed in points. The
distances are returned as a tuple like (left, right, top, bottom). If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="110"/>
        <source>getColumnGap([&quot;name&quot;]) -&gt; float

Returns the column gap size of the text frame &quot;name&quot; expressed in points. If
&quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="120"/>
        <source>getColumns([&quot;name&quot;]) -&gt; integer

Gets the number of columns of the text frame &quot;name&quot;. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="132"/>
        <source>setText(&quot;text&quot;, [&quot;name&quot;])

Sets the text of the text frame &quot;name&quot; to the text of the string &quot;text&quot;.
Text must be UTF8 encoded - use e.g. unicode(text, &apos;iso-8859-2&apos;). See the FAQ
for more details. If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="146"/>
        <source>insertText(&quot;text&quot;, pos, [&quot;name&quot;])

Inserts the text &quot;text&quot; at the position &quot;pos&quot; into the text frame &quot;name&quot;.
Text must be UTF encoded (see setText() as reference) The first character has an
index of 0. Inserting text at position -1 appends it to the frame. If &quot;name&quot; is
not given the currently selected Item is used.

May throw IndexError for an insertion out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="159"/>
        <source>setFont(&quot;font&quot;, [&quot;name&quot;])

Sets the font of the text frame &quot;name&quot; to &quot;font&quot;. If there is some text
selected only the selected text is changed.  If &quot;name&quot; is not given the
currently selected item is used.

May throw ValueError if the font cannot be found.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="173"/>
        <source>setFontSize(size, [&quot;name&quot;])

Sets the font size of the text frame &quot;name&quot; to &quot;size&quot;. &quot;size&quot; is treated
as a value in points. If there is some text selected only the selected text is
changed. &quot;size&quot; must be in the range 1 to 512. If &quot;name&quot; is not given the
currently selected item is used.

May throw ValueError for a font size that&apos;s out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="186"/>
        <source>setLineSpacing(size, [&quot;name&quot;])

Sets the line spacing (&quot;leading&quot;) of the text frame &quot;name&quot; to &quot;size&quot;.
&quot;size&quot; is a value in points. If &quot;name&quot; is not given the currently selected
item is used.

May throw ValueError if the line spacing is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="199"/>
        <source>setTextDistances(left, right, top, bottom, [&quot;name&quot;])

Sets the text distances of the text frame &quot;name&quot; to the values &quot;left&quot;
&quot;right&quot;, &quot;top&quot; and &quot;bottom&quot;. If &quot;name&quot; is not given the currently
selected item is used.

May throw ValueError if any of the distances are out of bounds (must be positive).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="211"/>
        <source>setColumnGap(size, [&quot;name&quot;])

Sets the column gap of the text frame &quot;name&quot; to the value &quot;size&quot;. If
&quot;name&quot; is not given the currently selected item is used.

May throw ValueError if the column gap is out of bounds (must be positive).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="223"/>
        <source>setColumns(nr, [&quot;name&quot;])

Sets the number of columns of the text frame &quot;name&quot; to the integer &quot;nr&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May throw ValueError if number of columns is not at least one.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="236"/>
        <source>setTextAlignment(align, [&quot;name&quot;])

Sets the text alignment of the text frame &quot;name&quot; to the specified alignment.
If &quot;name&quot; is not given the currently selected item is used. &quot;align&quot; should
be one of the ALIGN_ constants defined in this module - see dir(scribus).

May throw ValueError for an invalid alignment constant.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="250"/>
        <source>selectText(start, count, [&quot;name&quot;])

Selects &quot;count&quot; characters of text in the text frame &quot;name&quot; starting from the
character &quot;start&quot;. Character counting starts at 0. If &quot;count&quot; is zero, any
text selection will be cleared.  If &quot;name&quot; is not given the currently
selected item is used.

May throw IndexError if the selection is outside the bounds of the text.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="261"/>
        <source>deleteText([&quot;name&quot;])

Deletes any text in the text frame &quot;name&quot;. If there is some text selected,
only the selected text will be deleted. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="272"/>
        <source>setTextColor(&quot;color&quot;, [&quot;name&quot;])

Sets the text color of the text frame &quot;name&quot; to the color &quot;color&quot;. If there
is some text selected only the selected text is changed. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="282"/>
        <source>setTextStroke(&quot;color&quot;, [&quot;name&quot;])

Set &quot;color&quot; of the text stroke. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="315"/>
        <source>setTextShade(shade, [&quot;name&quot;])

Sets the shading of the text color of the object &quot;name&quot; to &quot;shade&quot;. If
there is some text selected only the selected text is changed. &quot;shade&quot; must
be an integer value in the range from 0 (lightest) to 100 (full color
intensity). If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="328"/>
        <source>linkTextFrames(&quot;fromname&quot;, &quot;toname&quot;)

Link two text frames. The frame named &quot;fromname&quot; is linked to the
frame named &quot;toname&quot;. The target frame must be an empty text frame
and must not link to or be linked from any other frames already.

May throw ScribusException if linking rules are violated.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="345"/>
        <source>unlinkTextFrames(&quot;name&quot;)

Remove the specified (named) object from the text frame flow/linkage. If the
frame was in the middle of a chain, the previous and next frames will be
connected, eg &apos;a-&gt;b-&gt;c&apos; becomes &apos;a-&gt;c&apos; when you unlinkTextFrames(b)&apos;

May throw ScribusException if linking rules are violated.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="358"/>
        <source>traceText([&quot;name&quot;])

Convert the text frame &quot;name&quot; to outlines. If &quot;name&quot; is not given the
currently selected item is used.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="372"/>
        <source>textOverflows([&quot;name&quot;, nolinks]) -&gt; integer

Returns the actual number of overflowing characters in text frame &quot;name&quot;.
If is nolinks set to non zero value it takes only one frame - it doesn&apos;t
use text frame linking. Without this parameter it search all linking chain.

May raise WrongFrameTypeError if the target frame is not an text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="385"/>
        <source>hyphenateText([&quot;name&quot;]) -&gt; bool

Does hyphenation on text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="399"/>
        <source>dehyphenateText([&quot;name&quot;]) -&gt; bool

Does dehyphenation on text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="414"/>
        <source>setPDFBookmark(&quot;toggle&quot;, [&quot;name&quot;])

Sets whether (toggle = 1) the text frame &quot;name&quot; is a bookmark nor not.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="426"/>
        <source>isPDFBookmark([&quot;name&quot;]) -&gt; bool

Returns true if the text frame &quot;name&quot; is a PDF bookmark.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="21"/>
        <source>messagebarText(&quot;string&quot;)

Writes the &quot;string&quot; into the Scribus message bar (status line). The text
must be UTF8 encoded or &apos;unicode&apos; string(recommended).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="34"/>
        <source>progressReset()

Cleans up the Scribus progress bar previous settings. It is called before the
new progress bar use. See progressSet.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="47"/>
        <source>progressTotal(max)

Sets the progress bar&apos;s maximum steps value to the specified number.
See progressSet.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="61"/>
        <source>progressSet(nr)

Set the progress bar position to &quot;nr&quot;, a value relative to the previously set
progressTotal. The progress bar uses the concept of steps; you give it the
total number of steps and the number of steps completed so far and it will
display the percentage of steps that have been completed. You can specify the
total number of steps with progressTotal(). The current number of steps is set
with progressSet(). The progress bar can be rewound to the beginning with
progressReset(). [based on info taken from Trolltech&apos;s Qt docs]
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="69"/>
        <source>setCursor()

[UNSUPPORTED!] This might break things, so steer clear for now.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="83"/>
        <source>docChanged(bool)

Enable/disable save icon in the Scribus icon bar and the Save menu item. It&apos;s
useful to call this procedure when you&apos;re changing the document, because Scribus
won&apos;t automatically notice when you change the document using a script.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="95"/>
        <source>zoomDocument(double)

Zoom the document in main GUI window. Actions have whole number
values like 20.0, 100.0, etc. Zoom to Fit uses -100 as a marker.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="106"/>
        <source>scrollDocument(x,y)

Scroll the document in main GUI window by x and y.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="21"/>
        <source>placeSVG(&quot;filename&quot;, x, y)

Places the SVG &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the SVG placed on the page

If loading was successful, the selection contains the imported SVG
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="33"/>
        <source>placeEPS(&quot;filename&quot;, x, y)

Places the EPS &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the EPS placed on the page

If loading was successful, the selection contains the imported EPS
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="45"/>
        <source>placeSXD(&quot;filename&quot;, x, y)

Places the SXD &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the SXD placed on the page

If loading was successful, the selection contains the imported SXD
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="57"/>
        <source>placeODG(&quot;filename&quot;, x, y)

Places the ODG &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the ODG placed on the page

If loading was successful, the selection contains the imported ODG
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="120"/>
        <source>isSpotColor(&quot;name&quot;) -&gt; bool

Returns True if the color &quot;name&quot; is a spot color.
See also setSpotColor()

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="135"/>
        <source>setSpotColor(&quot;name&quot;, spot)

Set the color &quot;name&quot; as a spot color if spot parameter is True.
See also isSpotColor()

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="167"/>
        <source>scaleImage(x, y [, &quot;name&quot;])

Sets the internal scaling factors of the picture in the image frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used. A number of 1
means 100 %. Internal scaling factors are different from the values shown on 
properties palette. Note : deprecated, use setImageScale() instead.

May raise WrongFrameTypeError if the target frame is not an image frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="180"/>
        <source>setImageScale(x, y [, &quot;name&quot;])

Sets the scaling factors of the picture in the image frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used. A number of 1
means 100 %. Scaling factors are equal to the values shown on properties palette.

May raise WrongFrameTypeError if the target frame is not an image frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="33"/>
        <source>setGradientStop(&quot;color&quot;, shade, opacity, ramppoint, [&quot;name&quot;])

Set or add a gradient stop to the gradient fill of the object &quot;name&quot; at position ramppoint.
Color descriptions are the same as for setFillColor() and setFillShade(). setGradientFill()
must have been called previously for the gradient fill to be visible.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="292"/>
        <source>setTextScalingV(scale, [&quot;name&quot;])

Sets the vertical character scaling of the object &quot;name&quot; to &quot;scale&quot; in percent.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="302"/>
        <source>setTextScalingH(scale, [&quot;name&quot;])

Sets the horizontal character scaling of the object &quot;name&quot; to &quot;scale&quot; in percent.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>@default</name>
    <message>
        <location filename="../plugins/fileloader/scribus12format/scribus12format.cpp" line="1593"/>
        <source>Copy #%1 of </source>
        <translation type="obsolete">Копија #%1 од</translation>
    </message>
</context>
<context>
    <name>AIPlug</name>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="125"/>
        <source>Importing: %1</source>
        <translation type="unfinished">Увожење: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="128"/>
        <source>Analyzing File:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="265"/>
        <source>Group%1</source>
        <translation type="unfinished">Група%1</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="2469"/>
        <source>Generating Items</source>
        <translation type="unfinished">Правим ставке</translation>
    </message>
</context>
<context>
    <name>About</name>
    <message>
        <location filename="../../scribus/about.cpp" line="188"/>
        <source>&amp;About</source>
        <translation>О прогр&amp;аму</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="297"/>
        <source>Development Team:</source>
        <translation>Развојни тим:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="305"/>
        <source>Contributions from:</source>
        <translation>Прилози од стране:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="307"/>
        <source>Official Documentation:</source>
        <translation>Званична документација:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="311"/>
        <source>Other Documentation:</source>
        <translation>Остала документација:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="201"/>
        <source>A&amp;uthors</source>
        <translation>А&amp;утори</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="215"/>
        <source>&amp;Translations</source>
        <translation>&amp;Преводи</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="345"/>
        <source>Homepage</source>
        <translation>Почетна страница</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="347"/>
        <source>Online Reference</source>
        <translation>Веб референца</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="351"/>
        <source>Bugs and Feature Requests</source>
        <translation>Грешке и захтеви за нове могућности</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="355"/>
        <source>Mailing List</source>
        <translation>Дискусиона листа</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="226"/>
        <source>&amp;Online</source>
        <translation>На &amp;вези</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="265"/>
        <source>&amp;Close</source>
        <translation>&amp;Затвори</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="329"/>
        <source>Official Translations and Translators:</source>
        <translation>Званични преводи и преводиоци:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="331"/>
        <source>Previous Translation Contributors:</source>
        <translation>Они који су претходно допринели превођењу:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="97"/>
        <source>About Scribus %1</source>
        <translation>О Скрибусу %1</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="349"/>
        <source>Wiki</source>
        <translation>Вики</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="125"/>
        <source>%1 %2 %3</source>
        <translation>%1 %2 %3</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="133"/>
        <source>%3-%2-%1 %4 %5</source>
        <translation>%3-%2-%1 %4 %5</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="183"/>
        <source>Using Ghostscript version %1</source>
        <translation>Користим Гоустскрипт верзију %1</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="185"/>
        <source>No Ghostscript version available</source>
        <translation>Гоустскрипт није доступан</translation>
    </message>
    <message>
        <location filename="../about.cpp" line="132"/>
        <source>&lt;b&gt;Scribus Version %1&lt;/b&gt;&lt;p&gt;%2&lt;br/&gt;%3 %4&lt;br/&gt;%5&lt;/p&gt;</source>
        <translation type="obsolete">&lt;b&gt;Скрибус верзија %1&lt;/b&gt;&lt;p&gt;%2&lt;br/&gt;%3 %4&lt;br/&gt;%5&lt;/p&gt;</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="186"/>
        <source>Build ID:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="299"/>
        <source>Mac OS&amp;#174; X Aqua Port:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="303"/>
        <source>Windows&amp;#174; Port:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="317"/>
        <source>Tango Project Icons:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="229"/>
        <source>&amp;Updates</source>
        <translation>&amp;Updates</translation>
    </message>
    <message>
        <location filename="../about.cpp" line="411"/>
        <source>Check for &amp;Updates</source>
        <translation type="obsolete">&amp;Aжурирај</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="277"/>
        <source>Check for updates to Scribus. No data from your machine will be transferred off it.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="301"/>
        <source>OS/2&amp;#174;/eComStation&amp;#8482; Port:</source>
        <translation>OS/2&amp;#174;/eComStation&amp;#8482; Port:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="315"/>
        <source>Splash Screen:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="273"/>
        <source>This panel shows the version, build date and compiled in library support in Scribus.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="274"/>
        <source>The C-C-T-F equates to C=littlecms C=CUPS T=TIFF support F=Fontconfig support.Last Letter is the renderer C=cairo or Q=Qt</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="275"/>
        <source>Missing library support is indicated by a *. This also indicates the version of Ghostscript which Scribus has detected.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="276"/>
        <source>The Windows version does not use fontconfig or CUPS libraries.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="186"/>
        <source>&lt;p align=&quot;center&quot;&gt;&lt;b&gt;%1 %2&lt;/b&gt;&lt;/p&gt;&lt;p align=&quot;center&quot;&gt;%3&lt;br&gt;%4 %5&lt;br&gt;%6&lt;/p&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="186"/>
        <source>Scribus Version</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="649"/>
        <source>Check for Updates</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="647"/>
        <source>Abort Update Check</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="353"/>
        <source>Developer Blog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="240"/>
        <source>&amp;Licence</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="249"/>
        <source>Unable to open licence file. Please check your install directory or the Scribus website for licencing information.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="309"/>
        <source>Doc Translators:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="313"/>
        <source>Webmasters:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="625"/>
        <source>Unable to open %1 file. Please check your install directory or the Scribus website for %1 information.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AboutPlugins</name>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="68"/>
        <source>Filename:</source>
        <translation>Име фајла:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="69"/>
        <source>Version:</source>
        <translation>Верзија:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="72"/>
        <source>Enabled:</source>
        <translation>Укључен:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="73"/>
        <source>Release Date:</source>
        <translation>Датум објављивања:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="80"/>
        <source>Description:</source>
        <translation>Опис:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="81"/>
        <source>Author(s):</source>
        <translation>Аутор(и):</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="82"/>
        <source>Copyright:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="83"/>
        <source>License:</source>
        <translation>Лиценца:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.ui" line="13"/>
        <source>Scribus: About Plug-ins</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AboutPluginsBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Close</source>
        <translation type="obsolete">&amp;Затвори</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
</context>
<context>
    <name>ActionManager</name>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1257"/>
        <source>&amp;New</source>
        <translation type="unfinished">&amp;Нови</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1259"/>
        <source>&amp;Open...</source>
        <translation type="unfinished">&amp;Отвори...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1260"/>
        <source>&amp;Close</source>
        <translation type="unfinished">&amp;Затвори</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1261"/>
        <source>&amp;Save</source>
        <translation type="unfinished">&amp;Сними</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1262"/>
        <source>Save &amp;As...</source>
        <translation type="unfinished">Сними &amp;као...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1263"/>
        <source>Re&amp;vert to Saved</source>
        <translation type="unfinished">Вр&amp;ати на снимљено</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1264"/>
        <source>Collect for O&amp;utput...</source>
        <translation type="unfinished">Сакупи за и&amp;злаз...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1265"/>
        <source>Get Text...</source>
        <translation type="unfinished">Добави текст...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1266"/>
        <source>Append &amp;Text...</source>
        <translation type="unfinished">Примени &amp;текст...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1267"/>
        <source>Get Image...</source>
        <translation>Добави слику...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1270"/>
        <source>Save &amp;Text...</source>
        <translation type="unfinished">Сними &amp;текст...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1272"/>
        <source>Save as P&amp;DF...</source>
        <translation type="unfinished">Сними као P&amp;DF...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1273"/>
        <source>Document &amp;Setup...</source>
        <translation type="unfinished">&amp;Поставке документа...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1275"/>
        <source>&amp;Print...</source>
        <translation type="unfinished">Ш&amp;тампај...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1277"/>
        <source>&amp;Quit</source>
        <translation type="unfinished">&amp;Заврши</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1279"/>
        <source>&amp;Undo</source>
        <translation type="unfinished">&amp;Опозови</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1280"/>
        <source>&amp;Redo</source>
        <translation type="unfinished">Поно&amp;ви</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1281"/>
        <source>&amp;Item Action Mode</source>
        <translation>&amp;Опозов по појединачним ставкама</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1282"/>
        <source>Cu&amp;t</source>
        <translation type="unfinished">&amp;Исеци</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1285"/>
        <source>&amp;Copy</source>
        <translation type="unfinished">&amp;Копирај</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1286"/>
        <source>&amp;Paste</source>
        <translation type="unfinished">&amp;Пренеси</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1289"/>
        <source>Select &amp;All</source>
        <translation type="unfinished">Изабери &amp;све</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1291"/>
        <source>&amp;Deselect All</source>
        <translation>&amp;Откази све изабрано</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1292"/>
        <source>&amp;Search/Replace...</source>
        <translation type="unfinished">&amp;Тражи/Замени...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1293"/>
        <source>Edit Image...</source>
        <translation>Доради слику...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1295"/>
        <source>C&amp;olors...</source>
        <translation type="unfinished">Б&amp;оје...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1299"/>
        <source>&amp;Master Pages...</source>
        <translation>&amp;Главне стране...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1274"/>
        <source>P&amp;references...</source>
        <translation type="unfinished">П&amp;одешавања...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1307"/>
        <source>%1 pt</source>
        <translation>%1 тачака</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1309"/>
        <source>&amp;Other...</source>
        <translation type="unfinished">&amp;Остало...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1310"/>
        <source>&amp;Left</source>
        <translation type="unfinished">&amp;Лево</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1311"/>
        <source>&amp;Center</source>
        <translation>&amp;Централно</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1312"/>
        <source>&amp;Right</source>
        <translation type="unfinished">&amp;Десно</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1313"/>
        <source>&amp;Block</source>
        <translation>У &amp;блок</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1314"/>
        <source>&amp;Forced</source>
        <translation>&amp;Усиљено</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1294"/>
        <source>&amp;%1 %</source>
        <translation type="obsolete">&amp;%1 %</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1325"/>
        <source>&amp;Normal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1326"/>
        <source>&amp;Underline</source>
        <translation type="unfinished">&amp;Подвуци</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1327"/>
        <source>Underline &amp;Words</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1328"/>
        <source>&amp;Strike Through</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1329"/>
        <source>&amp;All Caps</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1330"/>
        <source>Small &amp;Caps</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1331"/>
        <source>Su&amp;perscript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1332"/>
        <source>Su&amp;bscript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1334"/>
        <source>S&amp;hadow</source>
        <translation>С&amp;енка</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1336"/>
        <source>&amp;Image Effects</source>
        <translation>&amp;Ефекти на слици</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1337"/>
        <source>&amp;Tabulators...</source>
        <translation type="unfinished">&amp;Табулатори...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1340"/>
        <source>D&amp;uplicate</source>
        <translation>Д&amp;уплирање</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1341"/>
        <source>&amp;Multiple Duplicate</source>
        <translation type="unfinished">&amp;Умножено дуплирање</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1342"/>
        <source>&amp;Delete</source>
        <translation type="unfinished">&amp;Обриши</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1343"/>
        <source>&amp;Group</source>
        <translation type="unfinished">&amp;Група</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1344"/>
        <source>&amp;Ungroup</source>
        <translation type="unfinished">&amp;Растури групу</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1345"/>
        <source>Is &amp;Locked</source>
        <translation>је &amp;закључано</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1346"/>
        <source>Si&amp;ze is Locked</source>
        <translation>В&amp;еличина је закључана</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1350"/>
        <source>Lower to &amp;Bottom</source>
        <translation>Спусти на &amp;дно</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1351"/>
        <source>Raise to &amp;Top</source>
        <translation>Подигни на &amp;врх</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1352"/>
        <source>&amp;Lower</source>
        <translation type="unfinished">&amp;Спусти</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1353"/>
        <source>&amp;Raise</source>
        <translation type="unfinished">&amp;Подигни</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1354"/>
        <source>Send to S&amp;crapbook</source>
        <translation type="unfinished">Пошаљи у св&amp;еску</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1356"/>
        <source>&amp;Attributes...</source>
        <translation>&amp;Својства...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1358"/>
        <source>I&amp;mage Visible</source>
        <translation type="unfinished">С&amp;лика видљива</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1359"/>
        <source>&amp;Update Image</source>
        <translation>&amp;Ажурирај слику</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1360"/>
        <source>Adjust Frame to Image</source>
        <translation>Подеси оквир према слици</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1362"/>
        <source>Extended Image Properties</source>
        <translation type="unfinished">Додатна својства слике</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1363"/>
        <source>&amp;Low Resolution</source>
        <translation>&amp;Лоша резолуција</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1364"/>
        <source>&amp;Normal Resolution</source>
        <translation>&amp;Нормална резолуција</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1365"/>
        <source>&amp;Full Resolution</source>
        <translation>&amp;Висока резолуција</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1366"/>
        <source>Is PDF &amp;Bookmark</source>
        <translation type="unfinished">Је PDF &amp;маркер</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1367"/>
        <source>Is PDF A&amp;nnotation</source>
        <translation type="unfinished">Је PDF ан&amp;отација</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1368"/>
        <source>Annotation P&amp;roperties</source>
        <translation type="unfinished">С&amp;војства анотације</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1369"/>
        <source>Field P&amp;roperties</source>
        <translation type="unfinished">С&amp;војства поља</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1370"/>
        <source>&amp;Edit Shape...</source>
        <translation type="unfinished">&amp;Уређивање облика...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1371"/>
        <source>&amp;Attach Text to Path</source>
        <translation type="unfinished">&amp;Прикачи текст уз путању</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1372"/>
        <source>&amp;Detach Text from Path</source>
        <translation type="unfinished">&amp;Откачи текст од путање</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1373"/>
        <source>&amp;Combine Polygons</source>
        <translation type="unfinished">&amp;Комбинуј полигоне</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1374"/>
        <source>Split &amp;Polygons</source>
        <translation type="unfinished">Раздвоји &amp;полигоне</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1375"/>
        <source>&amp;Bezier Curve</source>
        <translation type="unfinished">&amp;Bezier крива</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1376"/>
        <source>&amp;Image Frame</source>
        <translation>&amp;Оквир слике</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1378"/>
        <source>&amp;Polygon</source>
        <translation>&amp;Полигон</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1379"/>
        <source>&amp;Text Frame</source>
        <translation type="unfinished">&amp;Текстуални оквир</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1383"/>
        <source>&amp;Glyph...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1384"/>
        <source>Sample Text</source>
        <translation>Пробни текст</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1388"/>
        <source>&amp;Insert...</source>
        <translation type="unfinished">Уметн&amp;и...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1389"/>
        <source>Im&amp;port...</source>
        <translation>Ув&amp;ези</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1390"/>
        <source>&amp;Delete...</source>
        <translation type="unfinished">&amp;Обриши...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1391"/>
        <source>&amp;Copy...</source>
        <translation>&amp;Копирај...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1392"/>
        <source>&amp;Move...</source>
        <translation type="unfinished">&amp;Помери...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1393"/>
        <source>&amp;Apply Master Page...</source>
        <translation>&amp;Примени главну страну...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1395"/>
        <source>Manage &amp;Guides...</source>
        <translation type="unfinished">Управљање &amp;водиљама...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1396"/>
        <source>Manage Page Properties...</source>
        <translation>Управљање својствима стране...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1401"/>
        <source>&amp;50%</source>
        <translation type="unfinished">&amp;50%</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1402"/>
        <source>&amp;75%</source>
        <translation type="unfinished">&amp;75%</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1403"/>
        <source>&amp;100%</source>
        <translation type="unfinished">&amp;100%</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1404"/>
        <source>&amp;200%</source>
        <translation type="unfinished">&amp;200%</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Thumbnails</source>
        <translation type="obsolete">&amp;Сличице</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1407"/>
        <source>Show &amp;Margins</source>
        <translation type="unfinished">Прикажи &amp;маргине</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1409"/>
        <source>Show &amp;Frames</source>
        <translation type="unfinished">Прикажи &amp;оквире</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1411"/>
        <source>Show &amp;Images</source>
        <translation type="unfinished">Прикажи &amp;слике</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1412"/>
        <source>Show &amp;Grid</source>
        <translation type="unfinished">Прикажи &amp;мрежу</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1413"/>
        <source>Show G&amp;uides</source>
        <translation type="unfinished">Прикажи &amp;водиље</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1415"/>
        <source>Show &amp;Baseline Grid</source>
        <translation type="unfinished">Прикажи мрежу &amp;основне линије</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1416"/>
        <source>Show &amp;Text Chain</source>
        <translation>Прикажи &amp;везе текстуалних оквира</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1417"/>
        <source>Show Control Characters</source>
        <translation>Прикажи контролне знакове</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1399"/>
        <source>Rulers relative to Page</source>
        <translation type="obsolete">Лењири се односе на страну</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1420"/>
        <source>Sn&amp;ap to Grid</source>
        <translation type="unfinished">Пре&amp;баци на мрежу</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1421"/>
        <source>Sna&amp;p to Guides</source>
        <translation type="unfinished">Преб&amp;аци на водиље</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1426"/>
        <source>&amp;Properties</source>
        <translation type="unfinished">&amp;Својства</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1428"/>
        <source>&amp;Scrapbook</source>
        <translation type="unfinished">&amp;Албум</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1429"/>
        <source>&amp;Layers</source>
        <translation type="unfinished">&amp;Слојеви</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1430"/>
        <source>&amp;Arrange Pages</source>
        <translation>&amp;Распореди стране</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1431"/>
        <source>&amp;Bookmarks</source>
        <translation type="unfinished">&amp;Маркери</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1432"/>
        <source>&amp;Measurements</source>
        <translation>&amp;Мерења</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1433"/>
        <source>Action &amp;History</source>
        <translation>Историја &amp;промена</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1434"/>
        <source>Preflight &amp;Verifier</source>
        <translation>Провера &amp;могућих проблема</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1435"/>
        <source>&amp;Align and Distribute</source>
        <translation>&amp;Поравнај и распореди</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1436"/>
        <source>&amp;Tools</source>
        <translation type="unfinished">&amp;Алати</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1437"/>
        <source>P&amp;DF Tools</source>
        <translation type="unfinished">P&amp;DF алати</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1440"/>
        <source>Select Item</source>
        <translation>Изабери ставку</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1351"/>
        <source>T&amp;able</source>
        <translation type="obsolete">Т&amp;абела</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1352"/>
        <source>&amp;Shape</source>
        <translation type="obsolete">&amp;Облик</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1354"/>
        <source>&amp;Line</source>
        <translation type="obsolete">&amp;Линија</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1356"/>
        <source>&amp;Freehand Line</source>
        <translation type="obsolete">Линија &amp;слободном руком</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1441"/>
        <source>Rotate Item</source>
        <translation type="unfinished">Ротирај ставку</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1442"/>
        <source>Zoom in or out</source>
        <translation type="unfinished">Увеличај или умањи</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1443"/>
        <source>Zoom in</source>
        <translation>Увеличај</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1444"/>
        <source>Zoom out</source>
        <translation>Умањи</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1445"/>
        <source>Edit Contents of Frame</source>
        <translation type="unfinished">Уређивање садржаја оквира</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1446"/>
        <source>Edit Text...</source>
        <translation type="unfinished">Уреди текст...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1447"/>
        <source>Link Text Frames</source>
        <translation type="unfinished">Повежи текстуалне оквире</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1448"/>
        <source>Unlink Text Frames</source>
        <translation type="unfinished">Прекини везу између текстуалних оквира</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1449"/>
        <source>&amp;Eye Dropper</source>
        <translation>&amp;Пипета</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1450"/>
        <source>Copy Item Properties</source>
        <translation>Копирај својства ставке</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1368"/>
        <source>Edit the text with the Story Editor</source>
        <translation type="obsolete">Уређивање текста помоћу уређивача</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1370"/>
        <source>Insert Text Frame</source>
        <translation type="obsolete">Уметни текстуални оквир</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1371"/>
        <source>Insert Image Frame</source>
        <translation type="obsolete">Уметни оквир за слику</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1372"/>
        <source>Insert Table</source>
        <translation type="obsolete">Убаци табелу</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1373"/>
        <source>Insert Shape</source>
        <translation type="obsolete">Убаци облик</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1374"/>
        <source>Insert Polygon</source>
        <translation type="obsolete">Убаци полигон</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1375"/>
        <source>Insert Line</source>
        <translation type="obsolete">Убаци линију</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1376"/>
        <source>Insert Bezier Curve</source>
        <translation type="obsolete">Убаци Безијерову криву</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1377"/>
        <source>Insert Freehand Line</source>
        <translation type="obsolete">Уметни слободоручну линију</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1412"/>
        <source>&amp;Manage Pictures</source>
        <translation type="obsolete">&amp;Управљање сликама</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1473"/>
        <source>&amp;Hyphenate Text</source>
        <translation>&amp;Растави на слогове</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1474"/>
        <source>Dehyphenate Text</source>
        <translation>Састави цртицама растављене речи</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1475"/>
        <source>&amp;Generate Table Of Contents</source>
        <translation>&amp;Направи садржај</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1482"/>
        <source>&amp;About Scribus</source>
        <translation type="unfinished">&amp;О Scribus-у</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1484"/>
        <source>About &amp;Qt</source>
        <translation type="unfinished">О &amp;Qt-у</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1485"/>
        <source>Toolti&amp;ps</source>
        <translation type="unfinished">Облач&amp;ићи</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1487"/>
        <source>Scribus &amp;Manual...</source>
        <translation type="unfinished">Scribus &amp;Приручник...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1505"/>
        <source>Smart &amp;Hyphen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1506"/>
        <source>Non Breaking Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1507"/>
        <source>Non Breaking &amp;Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1508"/>
        <source>Page &amp;Number</source>
        <translation>&amp;Број стране</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1510"/>
        <source>New Line</source>
        <translation>Нови ред</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1511"/>
        <source>Frame Break</source>
        <translation>Прекид оквира</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1512"/>
        <source>Column Break</source>
        <translation>Прекид колоне</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1515"/>
        <source>Copyright</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1516"/>
        <source>Registered Trademark</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1517"/>
        <source>Trademark</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1519"/>
        <source>Bullet</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1521"/>
        <source>Em Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1522"/>
        <source>En Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1523"/>
        <source>Figure Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1524"/>
        <source>Quotation Dash</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1495"/>
        <source>Toggle Palettes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1496"/>
        <source>Toggle Guides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1276"/>
        <source>Print Previe&amp;w</source>
        <translation type="unfinished">Прегл&amp;ед за штампање</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1300"/>
        <source>&amp;JavaScripts...</source>
        <translation>&amp;Јава Скрипте...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1394"/>
        <source>Convert to Master Page...</source>
        <translation>Преведи у главну страну...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1478"/>
        <source>&amp;Cascade</source>
        <translation type="unfinished">&amp;Наслажи</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1479"/>
        <source>&amp;Tile</source>
        <translation type="unfinished">Поп&amp;лочај</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1357"/>
        <source>More Info...</source>
        <translation>Више података...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1347"/>
        <source>&amp;Printing Enabled</source>
        <translation>&amp;Штампање могуће</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1348"/>
        <source>&amp;Flip Horizontally</source>
        <translation>&amp;Изврни водоравно</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1349"/>
        <source>&amp;Flip Vertically</source>
        <translation>&amp;Изврни усправно</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1418"/>
        <source>Show Rulers</source>
        <translation>Прикажи лењире</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Outline</source>
        <comment>



Document Outline Palette</comment>
        <translation type="obsolete">&amp;Контура</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1518"/>
        <source>Solidus</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1520"/>
        <source>Middle Dot</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1545"/>
        <source>En Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1546"/>
        <source>Em Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1547"/>
        <source>Thin Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1548"/>
        <source>Thick Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1549"/>
        <source>Mid Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1550"/>
        <source>Hair Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1464"/>
        <source>Insert Page Number</source>
        <translation type="obsolete">Уметни број странице</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1562"/>
        <source>ff</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1563"/>
        <source>fi</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1564"/>
        <source>fl</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1565"/>
        <source>ffi</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1566"/>
        <source>ffl</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1567"/>
        <source>ft</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1568"/>
        <source>st</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1298"/>
        <source>S&amp;tyles...</source>
        <translation>С&amp;тилови...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Outline</source>
        <comment>



type effect</comment>
        <translation type="obsolete">&amp;Контура</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1377"/>
        <source>&amp;Outlines</source>
        <comment>Convert to oulines</comment>
        <translation>&amp;Контурне линије</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1287"/>
        <source>Paste (&amp;Absolute)</source>
        <translation>Налепи (&amp;Апсолутно)</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1288"/>
        <source>C&amp;lear</source>
        <translation type="unfinished">Оч&amp;исти</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1462"/>
        <source>Insert PDF Push Button</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1463"/>
        <source>Insert PDF Text Field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1464"/>
        <source>Insert PDF Check Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1465"/>
        <source>Insert PDF Combo Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1466"/>
        <source>Insert PDF List Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1467"/>
        <source>Insert Text Annotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1468"/>
        <source>Insert Link Annotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1271"/>
        <source>Save as &amp;EPS...</source>
        <translation>Сними као &amp;EPS...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1414"/>
        <source>Show Text Frame Columns</source>
        <translation>Приказуј колоне текстуалног оквира</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1382"/>
        <source>&amp;Frame...</source>
        <translation>&amp;Оквир...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1406"/>
        <source>Preview Mode</source>
        <translation>Преглед стране</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1410"/>
        <source>Show Layer Indicators</source>
        <translation>Прикажи показатеље слојева</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1297"/>
        <source>Patterns...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1355"/>
        <source>Send to Patterns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1385"/>
        <source>Sticky Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1399"/>
        <source>&amp;Fit to Height</source>
        <translation>&amp;Рашири према висини</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1400"/>
        <source>Fit to Width</source>
        <translation>Рашири према ширини</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1408"/>
        <source>Show Bleeds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1513"/>
        <source>&amp;Zero Width Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1514"/>
        <source>Zero Width NB Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1526"/>
        <source>Apostrophe</source>
        <comment>Unicode 0x0027</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1527"/>
        <source>Straight Double</source>
        <comment>Unicode 0x0022</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1528"/>
        <source>Single Left</source>
        <comment>Unicode 0x2018</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1529"/>
        <source>Single Right</source>
        <comment>Unicode 0x2019</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1530"/>
        <source>Double Left</source>
        <comment>Unicode 0x201C</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1531"/>
        <source>Double Right</source>
        <comment>Unicode 0x201D</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1532"/>
        <source>Single Reversed</source>
        <comment>Unicode 0x201B</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1533"/>
        <source>Double Reversed</source>
        <comment>Unicode 0x201F</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1534"/>
        <source>Single Left Guillemet</source>
        <comment>Unicode 0x2039</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1535"/>
        <source>Single Right Guillemet</source>
        <comment>Unicode 0x203A</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1536"/>
        <source>Double Left Guillemet</source>
        <comment>Unicode 0x00AB</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1537"/>
        <source>Double Right Guillemet</source>
        <comment>Unicode 0x00BB</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1538"/>
        <source>Low Single Comma</source>
        <comment>Unicode 0x201A</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1539"/>
        <source>Low Double Comma</source>
        <comment>Unicode 0x201E</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1540"/>
        <source>CJK Single Left</source>
        <comment>Unicode 0x300C</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1541"/>
        <source>CJK Single Right</source>
        <comment>Unicode 0x300D</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1542"/>
        <source>CJK Double Left</source>
        <comment>Unicode 0x300E</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1543"/>
        <source>CJK Double Right</source>
        <comment>Unicode 0x300F</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1333"/>
        <source>&amp;Outline</source>
        <comment>type effect</comment>
        <translation type="unfinished">&amp;Контура</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1427"/>
        <source>&amp;Outline</source>
        <comment>Document Outline Palette</comment>
        <translation type="unfinished">&amp;Контура</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1405"/>
        <source>&amp;400%</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1452"/>
        <source>Insert &amp;Text Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1453"/>
        <source>Insert &amp;Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1455"/>
        <source>Insert T&amp;able</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1456"/>
        <source>Insert &amp;Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1457"/>
        <source>Insert &amp;Polygon</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1458"/>
        <source>Insert &amp;Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1459"/>
        <source>Insert &amp;Bezier Curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1460"/>
        <source>Insert &amp;Freehand Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1488"/>
        <source>Scribus Homepage</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1489"/>
        <source>Scribus Online Documentation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1490"/>
        <source>Scribus Wiki</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1491"/>
        <source>Getting Started with Scribus</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1422"/>
        <source>Show Context Menu</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1472"/>
        <source>&amp;Manage Images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1483"/>
        <source>&amp;About Plugins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1497"/>
        <source>Insert Unicode Character Begin Sequence</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1268"/>
        <source>Get Vector File...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1290"/>
        <source>Advanced Select All...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1294"/>
        <source>Edit Source...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1296"/>
        <source>Replace Colors...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1419"/>
        <source>Rulers Relative to Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1454"/>
        <source>Insert &amp;Render Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1492"/>
        <source>Check for Updates</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1509"/>
        <source>Number of Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1361"/>
        <source>Adjust Image to Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1690"/>
        <source>File</source>
        <translation type="unfinished">Фајл</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1690"/>
        <source>&amp;File</source>
        <translation type="unfinished">&amp;Фајл</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1692"/>
        <source>Edit</source>
        <translation type="unfinished">Уреди</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1692"/>
        <source>&amp;Edit</source>
        <translation type="unfinished">&amp;Уреди</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1694"/>
        <source>Style</source>
        <translation type="unfinished">Стил</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1694"/>
        <source>&amp;Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1696"/>
        <source>Item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1696"/>
        <source>&amp;Item</source>
        <translation type="unfinished">&amp;Ставка</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1698"/>
        <source>Insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1698"/>
        <source>I&amp;nsert</source>
        <translation type="unfinished">У&amp;баци</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1700"/>
        <source>Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1700"/>
        <source>&amp;Page</source>
        <translation type="unfinished">&amp;Страна</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1702"/>
        <source>View</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1702"/>
        <source>&amp;View</source>
        <translation type="unfinished">&amp;Прикажи</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1704"/>
        <source>Extras</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1704"/>
        <source>E&amp;xtras</source>
        <translation type="unfinished">Пр&amp;оширења</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1706"/>
        <source>Windows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1706"/>
        <source>&amp;Windows</source>
        <translation type="unfinished">&amp;Прозори</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1708"/>
        <source>Help</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1708"/>
        <source>&amp;Help</source>
        <translation type="unfinished">По&amp;моћ</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1876"/>
        <source>Plugin Menu Items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1878"/>
        <source>Others</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1880"/>
        <source>Unicode Characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1486"/>
        <source>Move/Resize Value Indicator</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1258"/>
        <source>New &amp;from Template...</source>
        <translation type="unfinished">Нови &amp;из шаблона...</translation>
    </message>
</context>
<context>
    <name>AdjustCmsDialog</name>
    <message>
        <location filename="../../scribus/adjustcmsdialog.cpp" line="16"/>
        <source>CMS Settings</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AlignDistribute</name>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="35"/>
        <source>Align</source>
        <translation type="unfinished">Поравнај</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="79"/>
        <source>&amp;Selected Guide:</source>
        <translation type="unfinished">&amp;Изабрана водиља:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="92"/>
        <source>&amp;Relative To:</source>
        <translation type="unfinished">&amp;У односу на:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="431"/>
        <source>...</source>
        <translation type="unfinished">...</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="270"/>
        <source>Distribute</source>
        <translation type="unfinished">Распореди</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="490"/>
        <source>&amp;Distance:</source>
        <translation type="unfinished">&amp;Удаљеност:</translation>
    </message>
</context>
<context>
    <name>AlignDistributeBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Align</source>
        <translation type="obsolete">Поравнај</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Selected Guide:</source>
        <translation type="obsolete">&amp;Изабрана водиља:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Relative To:</source>
        <translation type="obsolete">&amp;У односу на:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>...</source>
        <translation type="obsolete">...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Distribute</source>
        <translation type="obsolete">Распореди</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Distance:</source>
        <translation type="obsolete">&amp;Удаљеност:</translation>
    </message>
</context>
<context>
    <name>AlignDistributePalette</name>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="90"/>
        <source>Align and Distribute</source>
        <translation>Поравнај и распореди</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="91"/>
        <source>Align</source>
        <translation type="unfinished">Поравнај</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="93"/>
        <source>&amp;Relative to:</source>
        <translation>&amp;У односу на:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="96"/>
        <source>First Selected</source>
        <translation>Први изабрани</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="97"/>
        <source>Last Selected</source>
        <translation>Последњи изабрани</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="98"/>
        <source>Page</source>
        <translation>Страницу</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="99"/>
        <source>Margins</source>
        <translation>Маргине</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="100"/>
        <source>Guide</source>
        <translation>Водиље</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="101"/>
        <source>Selection</source>
        <translation>Избор</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="111"/>
        <source>Align bottoms</source>
        <translation>Поравнај дна</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="113"/>
        <source>Align right sides</source>
        <translation>Поравнај десне стране</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="117"/>
        <source>Center on vertical axis</source>
        <translation>Центрирај по усправној оси</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="119"/>
        <source>Align left sides</source>
        <translation>Поравнај леве стране</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="121"/>
        <source>Center on horizontal axis</source>
        <translation>Центрирај по водоравној оси</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="125"/>
        <source>Align tops</source>
        <translation>Поравнај врхове</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="127"/>
        <source>&amp;Selected Guide:</source>
        <translation>&amp;Изабрана водиља:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="135"/>
        <source>Distribute right sides equidistantly</source>
        <translation>Распореди десне стране на једнаку удаљеност</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="137"/>
        <source>Distribute bottoms equidistantly</source>
        <translation>Распореди дна на једнаку удаљеност</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="139"/>
        <source>Distribute centers equidistantly horizontally</source>
        <translation>Распореди центре на једнаку удаљеност водоравно</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="145"/>
        <source>Distribute left sides equidistantly</source>
        <translation>Распореди леве стране на једнаку удаљеност</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="147"/>
        <source>Distribute centers equidistantly vertically</source>
        <translation>Распореди центре на једнаку удаљеност усправно</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="149"/>
        <source>Distribute tops equidistantly</source>
        <translation>Распореди врхове на једнаку удаљеност</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="159"/>
        <source>&amp;Distance:</source>
        <translation>&amp;Удаљеност:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="160"/>
        <source>Distribute the items with the distance specified</source>
        <translation>Распоред ставки са назначеним растојањем</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="162"/>
        <source>None Selected</source>
        <translation>Нема избора</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="440"/>
        <source>Y: %1%2</source>
        <translation>Y: %1%2</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="448"/>
        <source>X: %1%2</source>
        <translation>X: %1%2</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="107"/>
        <source>Align right sides of items to left side of anchor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="109"/>
        <source>Align left sides of items to right side of anchor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="115"/>
        <source>Align tops of items to bottom of anchor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="123"/>
        <source>Align bottoms of items to top of anchor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="130"/>
        <source>Make horizontal gaps between items equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="132"/>
        <source>Make horizontal gaps between items equal to the value specified</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="141"/>
        <source>Make vertical gaps between items equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="143"/>
        <source>Make vertical gaps between items equal to the value specified</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="151"/>
        <source>Make horizontal gaps between items and sides of page equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="157"/>
        <source>Make vertical gaps between items and the top and bottom of page margins equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="155"/>
        <source>Make horizontal gaps between items and sides of page margins equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="153"/>
        <source>Make vertical gaps between items and the top and bottom of page equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="92"/>
        <source>Distribute</source>
        <translation>Распореди</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="103"/>
        <source>&lt;qt&gt;Align relative to the:&lt;ul&gt;&lt;li&gt;First selected item&lt;/li&gt;&lt;li&gt;Second Selected Item&lt;/li&gt;&lt;li&gt;The current page&lt;/li&gt;&lt;li&gt;The margins of the current page&lt;/li&gt;&lt;li&gt;A Guide&lt;/li&gt;&lt;li&gt;The selection&lt;/ul&gt;&lt;/qt&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="105"/>
        <source>The location of the selected guide to align to</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AlignSelect</name>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="110"/>
        <source>Align Text Left</source>
        <translation>Поравнај текст лево</translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="111"/>
        <source>Align Text Right</source>
        <translation>Поравнај текст десно</translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="112"/>
        <source>Align Text Center</source>
        <translation>Поравнај текст по средини</translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="113"/>
        <source>Align Text Justified</source>
        <translation>Поравнај текст развучено</translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="114"/>
        <source>Align Text Forced Justified</source>
        <translation>Поравнај текст насилно развучено</translation>
    </message>
</context>
<context>
    <name>Annot</name>
    <message>
        <location filename="../../scribus/annot.cpp" line="61"/>
        <source>Field Properties</source>
        <translation>Својства поља</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="533"/>
        <source>Type:</source>
        <translation>Врста:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Button</source>
        <translation>Дугме</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Text Field</source>
        <translation>Поље за текст</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Check Box</source>
        <translation>Кућица</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Combo Box</source>
        <translation>Комбо кутија</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>List Box</source>
        <translation>Кутија листе</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="111"/>
        <source>Properties</source>
        <translation>Својства</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="121"/>
        <source>Name:</source>
        <translation>Име:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="274"/>
        <source>Text</source>
        <translation>Текст</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="152"/>
        <source>Font for use with PDF 1.3:</source>
        <translation>Фонт за коришћење са PDF 1.3:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="176"/>
        <source>Border</source>
        <translation>Оквир</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="182"/>
        <source>Color:</source>
        <translation>Боја:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2104"/>
        <source>None</source>
        <translation>Ниједан</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="197"/>
        <source>Width:</source>
        <translation>Ширина:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="201"/>
        <source>Thin</source>
        <translation>Танак</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="311"/>
        <source>Normal</source>
        <translation>Нормално</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="201"/>
        <source>Wide</source>
        <translation>Широк</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="209"/>
        <source>Style:</source>
        <translation>Стил:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="213"/>
        <source>Solid</source>
        <translation>Пуно</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="213"/>
        <source>Dashed</source>
        <translation>Испрекидано</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="213"/>
        <source>Underline</source>
        <translation>Подвучено</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="214"/>
        <source>Beveled</source>
        <translation>Искошено</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="214"/>
        <source>Inset</source>
        <translation>Уметак</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="224"/>
        <source>Other</source>
        <translation>Остало</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="230"/>
        <source>Read Only</source>
        <translation>Само за читање</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="236"/>
        <source>Required</source>
        <translation>Захтевано</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="248"/>
        <source>Visibility:</source>
        <translation>Видљивост:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="252"/>
        <source>Visible</source>
        <translation>Видљиво</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="252"/>
        <source>Hidden</source>
        <translation>Скривен</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="252"/>
        <source>No Print</source>
        <translation>Не штампај</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="253"/>
        <source>No View</source>
        <translation>Без приказа</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="262"/>
        <source>Appearance</source>
        <translation>Изглед</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="280"/>
        <source>Text for Button Down</source>
        <translation>Текст за Дугме Доле</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="283"/>
        <source>Text for Roll Over</source>
        <translation>Текст за превртање</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="294"/>
        <source>Icons</source>
        <translation>Иконе</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="300"/>
        <source>Use Icons</source>
        <translation>Користи иконе</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="357"/>
        <source>Remove</source>
        <translation>Уклони</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="329"/>
        <source>Pressed</source>
        <translation>Притиснуто</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="347"/>
        <source>Roll Over</source>
        <translation>Превртање</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="366"/>
        <source>Icon Placement...</source>
        <translation>Постављање икона...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="414"/>
        <source>Highlight</source>
        <translation>Истицање</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>Invert</source>
        <translation>Инвертуј</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>Outlined</source>
        <translation>Уоквирено</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>Push</source>
        <translation>Гурни</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="438"/>
        <source>Multi-Line</source>
        <translation>Мулти-линија</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="442"/>
        <source>Password</source>
        <translation>Лозинка</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="449"/>
        <source>Limit of</source>
        <translation>Лимит од</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="460"/>
        <source>Characters</source>
        <translation>Знакови</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="466"/>
        <source>Do Not Scroll</source>
        <translation>Немој да скролујеш</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="470"/>
        <source>Do Not Spell Check</source>
        <translation>Немој да провераваш правопис</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="485"/>
        <source>Check Style:</source>
        <translation>Провери стил:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Check</source>
        <translation>Провери</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Cross</source>
        <translation>Крст</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Diamond</source>
        <translation>Дијамант</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Circle</source>
        <translation>Круг</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Star</source>
        <translation>Звезда</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Square</source>
        <translation>Квадрат</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="502"/>
        <source>Default is Checked</source>
        <translation>Подразумевано је обележено</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="514"/>
        <source>Editable</source>
        <translation>Може се уређивати</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="521"/>
        <source>Options</source>
        <translation>Опције</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2067"/>
        <source>Go To</source>
        <translation>Иди на</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2068"/>
        <source>Submit Form</source>
        <translation>Пошаљи формулар</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2068"/>
        <source>Reset Form</source>
        <translation>Ресетуј формулар</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2068"/>
        <source>Import Data</source>
        <translation>Увези податке</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="570"/>
        <source>Event:</source>
        <translation>Догађај:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2047"/>
        <source>Mouse Up</source>
        <translation>Миш горе</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2047"/>
        <source>Mouse Down</source>
        <translation>Миш доле</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2047"/>
        <source>Mouse Enter</source>
        <translation>Миш унеси</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2048"/>
        <source>Mouse Exit</source>
        <translation>Миш изађи</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2048"/>
        <source>On Focus</source>
        <translation>На фокус</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2048"/>
        <source>On Blur</source>
        <translation>На замућење</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="585"/>
        <source>Script:</source>
        <translation>Скрипта:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1111"/>
        <source>Edit...</source>
        <translation>Уреди...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="670"/>
        <source>Submit to URL:</source>
        <translation>Пошаљи до URL-а:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="678"/>
        <source>Submit Data as HTML</source>
        <translation type="obsolete">Пошаљи податке као HTML</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="707"/>
        <source>Import Data from:</source>
        <translation>Увези податке од:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="610"/>
        <source>Destination</source>
        <translation>Одредиште</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="616"/>
        <source>To File:</source>
        <translation>У фајл:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="623"/>
        <source>Change...</source>
        <translation>Измени...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="632"/>
        <source>Page:</source>
        <translation>Страна:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="646"/>
        <source>X-Pos:</source>
        <translation>X Поз:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="658"/>
        <source> pt</source>
        <translation> тач.</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="654"/>
        <source>Y-Pos:</source>
        <translation>Y Поз:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="716"/>
        <source>Action</source>
        <translation>Акција</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="747"/>
        <source>Field is formatted as:</source>
        <translation>Поље је форматирано као:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="750"/>
        <source>Plain</source>
        <translation>Обичан</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="750"/>
        <source>Number</source>
        <translation>Број</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="750"/>
        <source>Percentage</source>
        <translation>Проценат</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="750"/>
        <source>Date</source>
        <translation>Датум</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="750"/>
        <source>Time</source>
        <translation>Време</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="750"/>
        <source>Custom</source>
        <translation>Произвољно</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="768"/>
        <source>Number Format</source>
        <translation>Формат бројева</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="836"/>
        <source>Decimals:</source>
        <translation>Децимале:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="791"/>
        <source>Use Currency Symbol</source>
        <translation>Користи симбол валуте</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="800"/>
        <source>Prepend Currency Symbol</source>
        <translation>Валута Симбол</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="847"/>
        <source>Formatting</source>
        <translation>Форматирање</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="827"/>
        <source>Percent Format</source>
        <translation>Процентни формат</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="870"/>
        <source>Date Format</source>
        <translation>Формат датума</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="896"/>
        <source>Time Format</source>
        <translation>Формат времена</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="918"/>
        <source>Custom Scripts</source>
        <translation>Произвољне скрипте</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="930"/>
        <source>Format:</source>
        <translation>Формат:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="956"/>
        <source>Keystroke:</source>
        <translation>Притисак дугмета:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="980"/>
        <source>Format</source>
        <translation>Формат</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="996"/>
        <source>Value is not validated</source>
        <translation>Вредност није оверена</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1005"/>
        <source>Value must be greater than or equal to:</source>
        <translation>Вредност мора бити већа или једнака са:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1009"/>
        <source>and less or equal to:</source>
        <translation>и мања или једнака са:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1020"/>
        <source>Custom validate script:</source>
        <translation>Произвољне скрипте за оверавање:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1041"/>
        <source>Validate</source>
        <translation>Овери</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1058"/>
        <source>Value is not calculated</source>
        <translation>Вредност није израчуната</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1067"/>
        <source>Value is the</source>
        <translation>Вредност је</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1072"/>
        <source>sum</source>
        <translation>сума</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1072"/>
        <source>product</source>
        <translation>производ</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1072"/>
        <source>average</source>
        <translation>средња вредност</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1072"/>
        <source>minimum</source>
        <translation>минимум</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1073"/>
        <source>maximum</source>
        <translation>максимум</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1080"/>
        <source>of the following fields:</source>
        <translation>од следећих поља:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1090"/>
        <source>Pick...</source>
        <translation>Изабери...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1095"/>
        <source>Custom calculation script:</source>
        <translation>Произвољна скрипта за израчунавање:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1115"/>
        <source>Calculate</source>
        <translation>Израчунај</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1134"/>
        <source>OK</source>
        <translation>У реду</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1138"/>
        <source>Cancel</source>
        <translation>Поништи</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1190"/>
        <source>Flag is ignored for PDF 1.3</source>
        <translation>Застава се игнорише за PDF 1.3</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1191"/>
        <source>Enter a comma separated list of fields here</source>
        <translation>Овде унесите листу поља одвојених зарезима</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1192"/>
        <source>You need at least the Icon for Normal to use Icons for Buttons</source>
        <translation>Потребна Вам је барем икона за Нормално да бисте користили икону за дугмад</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2262"/>
        <source>Open</source>
        <translation>Отвори</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1469"/>
        <source>Example:</source>
        <translation>Пример:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2096"/>
        <source>Selection Change</source>
        <translation>Промена избора</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2262"/>
        <source>PDF Files (*.pdf);;All Files (*)</source>
        <translation>PDF фајлови (*.pdf);;Сви фајлови (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2105"/>
        <source>JavaScript</source>
        <translation>JavaScript</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <comment>



highlight</comment>
        <translation type="obsolete">Ниједан</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <comment>



action</comment>
        <translation type="obsolete">Ниједан</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="134"/>
        <source>Tooltip:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="242"/>
        <source>Do Not Export Value</source>
        <translation>Не извози вредност</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1358"/>
        <source>Images (*.tif *.png *.jpg *.xpm);;PostScript (*.eps *.epsi);;All Files (*)</source>
        <translation>Слике (*.tif *.png *.jpg *.xpm);;Пост скрипт (*.eps *.epsi);;Сви фајлови (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>None</source>
        <comment>highlight</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2067"/>
        <source>None</source>
        <comment>action</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1303"/>
        <source>Images (*.tif *.png *.jpg *.xpm);;%1;;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="625"/>
        <source>Export absolute Filename</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="682"/>
        <source>Submit format:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="685"/>
        <source>FDF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="685"/>
        <source>HTML</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="685"/>
        <source>XFDF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="685"/>
        <source>PDF</source>
        <translation type="unfinished">PDF</translation>
    </message>
</context>
<context>
    <name>Annota</name>
    <message>
        <location filename="../../scribus/annota.cpp" line="47"/>
        <source>Annotation Properties</source>
        <translation>Својства анотације</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="77"/>
        <source>Text</source>
        <translation>Текст</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="78"/>
        <source>Link</source>
        <translation>Веза</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="79"/>
        <source>External Link</source>
        <translation>Спољашња веза</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="80"/>
        <source>External Web-Link</source>
        <translation>Спољашња веб-веза</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="118"/>
        <source>Destination</source>
        <translation>Одредиште</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="177"/>
        <source> pt</source>
        <translation> тач.</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="409"/>
        <source>Open</source>
        <translation>Отвори</translation>
    </message>
    <message>
        <location filename="../annota.cpp" line="351"/>
        <source>PDF-Documents (*.pdf);;All Files (*)</source>
        <translation type="obsolete">PDF-Документи (*.pdf);;Сви фајлови (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="82"/>
        <source>&amp;Type:</source>
        <translation>&amp;Врста:</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="129"/>
        <source>C&amp;hange...</source>
        <translation>И&amp;змени...</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="147"/>
        <source>&amp;Page:</source>
        <translation>&amp;Страница:</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="171"/>
        <source>&amp;X-Pos</source>
        <translation>&amp;X-Поз</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="179"/>
        <source>&amp;Y-Pos:</source>
        <translation>&amp;Y Поз:</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="409"/>
        <source>%1;;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="131"/>
        <source>Export absolute Filename</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ApplyMasterPageDialog</name>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="267"/>
        <source>Apply Master Page</source>
        <translation>Примени главну страну</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="268"/>
        <source>&amp;Master Page:</source>
        <translation>&amp;Главна страна:</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="269"/>
        <source>Apply To</source>
        <translation type="obsolete">Примени на</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="270"/>
        <source>Current &amp;page</source>
        <translation type="obsolete">Текућу &amp;страну</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="271"/>
        <source>Alt+P</source>
        <translation>Alt+P</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="272"/>
        <source>&amp;Even pages</source>
        <translation type="obsolete">&amp;Парне стране</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="273"/>
        <source>Alt+E</source>
        <translation>Alt+E</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="274"/>
        <source>O&amp;dd pages</source>
        <translation type="obsolete">&amp;Непарне стране</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="275"/>
        <source>Alt+D</source>
        <translation>Alt+D</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="276"/>
        <source>&amp;All pages</source>
        <translation type="obsolete">&amp;Све странице</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="277"/>
        <source>Alt+A</source>
        <translation>Alt+A</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="278"/>
        <source>&amp;Within range</source>
        <translation type="obsolete">&amp;У опсегу</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="279"/>
        <source>Alt+W</source>
        <translation>Alt+W</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="281"/>
        <source>to</source>
        <translation type="unfinished">до</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="283"/>
        <source>Alt+O</source>
        <translation type="unfinished">Alt+O</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="285"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="280"/>
        <source>Apply the selected master page to even, odd or all pages within the following range</source>
        <translation>Примени изабрану главну страну на парне, непарне или све стране у опсегу</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="52"/>
        <source>Possible Hyphenation</source>
        <translation type="unfinished">Могуће спајање цртицом</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="269"/>
        <source>Apply to</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="270"/>
        <source>Current &amp;Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="272"/>
        <source>&amp;Even Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="274"/>
        <source>O&amp;dd Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="276"/>
        <source>&amp;All Pages</source>
        <translation type="unfinished">&amp;Све странице</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="278"/>
        <source>&amp;Within Range</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ArrowChooser</name>
    <message>
        <location filename="../arrowchooser.cpp" line="33"/>
        <source>None</source>
        <translation type="obsolete">Ниједан</translation>
    </message>
</context>
<context>
    <name>AspellPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="64"/>
        <source>Spell-checking support</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="69"/>
        <source>Adds support for spell-checking via aspell. Languages can be chosen from among the installed aspell dictionaries, and spell-checking can be done on the fly, or on selected text.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="70"/>
        <source>0.1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="32"/>
        <source>Spell Checker</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="95"/>
        <source>Aspell Plugin Error</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AspellPluginBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="13"/>
        <source>Spell Check</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="118"/>
        <source>Replacement:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="278"/>
        <source>&amp;Add Word</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="306"/>
        <source>&amp;Change</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="351"/>
        <source>&amp;Exit</source>
        <translation type="obsolete">&amp;Изађи</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="45"/>
        <source>Not in Dictionary:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="70"/>
        <source>Word that was not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="125"/>
        <source>Replacement text for the current word that was not found in the dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="181"/>
        <source>Active Dictionary: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="194"/>
        <source>The currently active dictionary. Scribus uses aspell for dictionary support.&lt;br /&gt;If you require updated or more dictionaries, you should install them via your system&apos;s installation system or package manager.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="225"/>
        <source>Ignore the current text not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="228"/>
        <source>&amp;Ignore</source>
        <translation type="unfinished">&amp;Игнориши</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="247"/>
        <source>Ignore all occurrences of the current text not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="250"/>
        <source>I&amp;gnore All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="275"/>
        <source>Add the current word to the your personal spelling dictionary for future use</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="303"/>
        <source>Change the current word that was not found to that shown in the replacement entry field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="331"/>
        <source>Change all occurrences of the current word in the text that was not found to that shown in the replacement entry field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="334"/>
        <source>Change A&amp;ll</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="372"/>
        <source>Close</source>
        <translation type="unfinished">Затвори</translation>
    </message>
</context>
<context>
    <name>AspellPluginImpl</name>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="37"/>
        <source>Loaded </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="37"/>
        <source>default </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="37"/>
        <source> aspell dictionary.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="84"/>
        <source>aspellplugin (AspellPluginImpl::AspellPluginImpl): Error in aspell speller configuration.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="91"/>
        <source>aspellplugin (AspellPluginImpl::AspellPluginImpl): Error in creating aspell speller.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="359"/>
        <source>AspellPluginImpl::on_fskipAllBtn_clicked(): Unable to skip all instances of &quot;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="360"/>
        <source> by adding it to the session list.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="382"/>
        <source>AspellPluginImpl::on_faddWordBtn_clicked(): Unable to add word to personal list.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="235"/>
        <source>Spelling check complete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="427"/>
        <source>Spell Checker</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="62"/>
        <source>No available Aspell dictionaries found. Install some, please.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="429"/>
        <source>Do you want start from the beginning of the selection with new language selected?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AutoformButtonGroup</name>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1280"/>
        <source>Arrows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1281"/>
        <source>Flow Chart</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1282"/>
        <source>Jigsaw</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1283"/>
        <source>Specials</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1279"/>
        <source>Default Shapes</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Barcode</name>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcode.cpp" line="22"/>
        <source>&amp;Barcode...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcode.cpp" line="39"/>
        <source>Scribus frontend for Pure PostScript Barcode Writer</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BarcodeGenerator</name>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="315"/>
        <source>Error opening file: %1</source>
        <translation>Грешка при отварању фајла: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="41"/>
        <source>12 or 13 digits</source>
        <translation>12 или 13 цифара</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="43"/>
        <source>8 digits</source>
        <translation>8 цифара</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="45"/>
        <source>11 or 12 digits</source>
        <translation>11 или 12 цифара</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="47"/>
        <source>7 or 8 digits</source>
        <translation>7 или 8 цифара</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="49"/>
        <source>5 digits</source>
        <translation>5 цифара</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="51"/>
        <source>2 digits</source>
        <translation>2 цифре</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="58"/>
        <source>Variable number of characters, digits and any of the symbols -. *$/+%.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="67"/>
        <source>Variable number of ASCII characters and special function symbols, starting with the appropriate start character for the initial character set. UCC/EAN-128s must have a mandatory FNC 1 symbol immediately following the start character.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="70"/>
        <source>Variable number of digits and any of the symbols -$:/.+ABCD.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="78"/>
        <source>Variable number of digits. An ITF-14 is 14 characters and does not have a check digit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="93"/>
        <source>Variable number of digits</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="89"/>
        <source>Variable number of digits and capital letters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="98"/>
        <source>Variable number of hexadecimal characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="349"/>
        <source>Barcode incomplete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="54"/>
        <source>12 or 13 digits with dashes. The legacy ISBN-10 format accepts 9 or 10 digits with dashes, but this standard was depreciated for public use after 1st January 2007. (Note: To convert an old ISBN-10 to a new ISBN-13, prefix 978- to the first 9 digits, e.g. 1-56592-479-7 -&gt; 978-1-56592-479. The final check-digit will be calculated automatically.)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="105"/>
        <source>Select Type</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="145"/>
        <source>Select Barcode Type</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BarcodeGeneratorBase</name>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="140"/>
        <source>&amp;Type:</source>
        <translation type="unfinished">&amp;Врста:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="133"/>
        <source>Select one of the available barcode type here</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="113"/>
        <source>The numeric representation of the code itself. See the help message below</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="103"/>
        <source>Reset the barcode samples</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="81"/>
        <source>Alt+I</source>
        <translation>Alt+I</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="75"/>
        <source>If checked, there will be numbers in the barcode too</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="68"/>
        <source>Alt+G</source>
        <translation>Alt+G</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="62"/>
        <source>Draw arrows to be sure of space next the code</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="156"/>
        <source>Colors</source>
        <translation type="unfinished">Боје</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="184"/>
        <source>&amp;Background</source>
        <translation>&amp;Позадина</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="187"/>
        <source>Alt+B</source>
        <translation>Alt+B</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="181"/>
        <source>Background color - under the code lines</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="216"/>
        <source>&amp;Lines</source>
        <translation>&amp;Линије</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="219"/>
        <source>Alt+L</source>
        <translation>Alt+L</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="213"/>
        <source>Color of the lines in barcode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="248"/>
        <source>&amp;Text</source>
        <translation type="unfinished">&amp;Текст</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="251"/>
        <source>Alt+T</source>
        <translation>Alt+T</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="245"/>
        <source>Color of the text and numbers</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="280"/>
        <source>Hints and help is shown here</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="290"/>
        <source>Preview of the result. 72dpi sample.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="120"/>
        <source>Co&amp;de:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="55"/>
        <source>Alt+N</source>
        <translation>Alt+N</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="49"/>
        <source>Generate and include a checksum in barcode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="42"/>
        <source>Alt+U</source>
        <translation>Alt+U</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="36"/>
        <source>Include the checksum digit in the barcode text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="15"/>
        <source>Insert Barcode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="24"/>
        <source>Format</source>
        <translation type="unfinished">Формат</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="39"/>
        <source>Incl&amp;ude Checksum Digit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="52"/>
        <source>I&amp;nclude Checksum</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="65"/>
        <source>&amp;Guard Whitespace</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="78"/>
        <source>&amp;Include Text in Barcode</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Biblio</name>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1444"/>
        <source>Scrapbook</source>
        <translation>Албум</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="837"/>
        <source>Rename</source>
        <translation>Преименуј</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="839"/>
        <source>Delete</source>
        <translation>Обриши</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1344"/>
        <source>Object</source>
        <translation>Објекат</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1257"/>
        <source>&amp;Name:</source>
        <translation>&amp;Име:</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1257"/>
        <source>New Entry</source>
        <translation>Нов унос</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1120"/>
        <source>Name &quot;%1&quot; is not unique.
Please choose another.</source>
        <translation>Име &quot;%1&quot; није јединствено. 
Изабери друго.</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="698"/>
        <source>Choose a Scrapbook Directory</source>
        <translation>Изабери директоријум Албума</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="759"/>
        <source>Choose a Directory</source>
        <translation type="unfinished">Изаберите директоријум</translation>
    </message>
    <message>
        <location filename="../scrapbookpalette.cpp" line="747"/>
        <source>Scrapbook (*.scs)</source>
        <translation type="obsolete">Албум (*.scs)</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="737"/>
        <source>Choose a scrapbook file to import</source>
        <translation>Изабери фајл Албума за ивоз</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1445"/>
        <source>Create a new scrapbook page</source>
        <translation>Направи нову страну Албума</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1446"/>
        <source>Load an existing scrapbook</source>
        <translation>Учитај постојећи Албум</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1447"/>
        <source>Save the selected scrapbook</source>
        <translation>Сними изабрани Албум</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1448"/>
        <source>Import an scrapbook file from Scribus &lt;=1.3.2</source>
        <translation>Увези Албум из Скрибуса &lt;=1.3.2</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1449"/>
        <source>Close the selected scrapbook</source>
        <translation>Затвори изабрани Албум</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="844"/>
        <source>Copy To:</source>
        <translation>Копирај у:</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="845"/>
        <source>Move To:</source>
        <translation>Премести у:</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="560"/>
        <source>Main</source>
        <translation>Главни</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="562"/>
        <source>Copied Items</source>
        <translation>Копиране ставке</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1113"/>
        <source>New Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="739"/>
        <source>Scrapbook (*.scs *.SCS)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="833"/>
        <source>Paste to Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="889"/>
        <source>Save as...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="892"/>
        <source>Close</source>
        <translation type="unfinished">Затвори</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="895"/>
        <source>Delete Contents</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1068"/>
        <source>Do you really want to delete all entries?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BookMView</name>
    <message>
        <location filename="../bookmwin.cpp" line="554"/>
        <source>Bookmarks</source>
        <translation type="obsolete">Маркери</translation>
    </message>
    <message>
        <location filename="../bookmwin.cpp" line="219"/>
        <source>Move Bookmark</source>
        <translation type="obsolete">Помери маркер</translation>
    </message>
    <message>
        <location filename="../bookmwin.cpp" line="220"/>
        <source>Insert Bookmark</source>
        <translation type="obsolete">Уметни маркер</translation>
    </message>
    <message>
        <location filename="../bookmwin.cpp" line="221"/>
        <source>Cancel</source>
        <translation type="obsolete">Поништи</translation>
    </message>
</context>
<context>
    <name>BookPalette</name>
    <message>
        <location filename="../../scribus/bookmarkpalette.cpp" line="51"/>
        <source>Bookmarks</source>
        <translation>Маркери</translation>
    </message>
</context>
<context>
    <name>ButtonIcon</name>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="29"/>
        <source>Icon Placement</source>
        <translation>Постављање икона</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="38"/>
        <source>Layout:</source>
        <translation>Распоред:</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption only</source>
        <translation>Само натпис</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Icon only</source>
        <translation>Само икона</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption below Icon</source>
        <translation>Натпис испод иконе</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption above Icon</source>
        <translation>Натпис изнад иконе</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption right to Icon</source>
        <translation>Натпис десно од иконе</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption left to Icon</source>
        <translation>Натпис лево од иконе</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption overlays Icon</source>
        <translation>Натпис преко иконе</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="50"/>
        <source>Scale:</source>
        <translation>Размера:</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="55"/>
        <source>Always</source>
        <translation>Увек</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="55"/>
        <source>When Icon is too small</source>
        <translation>Када је икона превише мала</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="56"/>
        <source>When Icon is too big</source>
        <translation>Када је икона превише велика</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="56"/>
        <source>Never</source>
        <translation>Никад</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="63"/>
        <source>Scale How:</source>
        <translation>Скалирај како:</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="66"/>
        <source>Proportional</source>
        <translation>Пропорционалан</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="67"/>
        <source>Non Proportional</source>
        <translation>Непропорционално</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="90"/>
        <source>Icon</source>
        <translation>Икона</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="117"/>
        <source>OK</source>
        <translation>У реду</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="121"/>
        <source>Cancel</source>
        <translation>Поништи</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="124"/>
        <source>Reset</source>
        <translation>Ресетуј</translation>
    </message>
</context>
<context>
    <name>CMSPrefs</name>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="31"/>
        <source>&amp;Activate Color Management</source>
        <translation type="obsolete">&amp;Активирај управљање бојама</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="34"/>
        <source>System Profiles</source>
        <translation type="obsolete">Системски профили</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="75"/>
        <source>&amp;Monitor:</source>
        <translation type="obsolete">&amp;Надгледач:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="83"/>
        <source>P&amp;rinter:</source>
        <translation type="obsolete">Ш&amp;тампач:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="89"/>
        <source>Rendering Intents</source>
        <translation type="obsolete">Намере рендеровања</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="69"/>
        <source>Perceptual</source>
        <translation>Перцептуално</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="69"/>
        <source>Relative Colorimetric</source>
        <translation>Релативна колорметрика</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="70"/>
        <source>Saturation</source>
        <translation>Засићење</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="70"/>
        <source>Absolute Colorimetric</source>
        <translation>Апсолутна колорметрика</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="113"/>
        <source>Sim&amp;ulate Printer on the Screen</source>
        <translation type="obsolete">Симу&amp;лирај штампач на екрану</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="130"/>
        <source>Mark Colors out of &amp;Gamut</source>
        <translation type="obsolete">Означи боје изван &amp;gamut-а</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="134"/>
        <source>Use &amp;Blackpoint Compensation</source>
        <translation type="obsolete">Користи компензацију &amp;црне тачке</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="143"/>
        <source>Color profile that you have generated or received from the manufacturer.
This profile should be specific to your monitor and not a generic profile (i.e. sRGB).</source>
        <translation type="obsolete">Профил боја који сте направили или добили од произвођача.
Овај профил би требало да буде баш за Ваш монитор, а не генерички профил (тј. sRGB).</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="144"/>
        <source>Color profile for your printer model from the manufacturer.
This profile should be specific to your printer and not a generic profile (i.e. sRGB).</source>
        <translation type="obsolete">Профил боја за Ваш модел штампача од произвођача.
Овај профил би требало да буде баш за Ваш штампач, а не генерички профил (тј. sRGB).</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="147"/>
        <source>Enable &apos;soft proofing&apos; of how your document colors will print,
based on the chosen printer profile.</source>
        <translation type="obsolete">Укључи „меко проверавање“ како ће се штампати боје у Вашем документу,
на основу изабраног профила за штампач.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="149"/>
        <source>Method of showing colors on the screen which may not print properly.
This requires very accurate profiles and serves only as a warning.</source>
        <translation type="obsolete">Метод за приказивање боја на екрану које можда неће бити добро одштампане.
Ово захтева веома прецизне профиле и служи само као упозорење.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="150"/>
        <source>Black Point Compensation is a method of improving contrast in photos.
It is recommended that you enable this if you have photos in your document.</source>
        <translation type="obsolete">Компензација црне тачке је метод поправљања контраста на фотографијама.
Препоручљиво је да ово укључите ако имате фотографије у документу.</translation>
    </message>
    <message>
        <location filename="../cmsprefs.cpp" line="43"/>
        <source>&amp;RGB Pictures:</source>
        <translation type="obsolete">&amp;RGB слике:</translation>
    </message>
    <message>
        <location filename="../cmsprefs.cpp" line="51"/>
        <source>&amp;CMYK Pictures:</source>
        <translation type="obsolete">&amp;CMYK слике:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="139"/>
        <source>Default color profile for imported CMYK images</source>
        <translation type="obsolete">Подразумевани профил боја за ивезене CMYK слике</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="140"/>
        <source>Default color profile for imported RGB images</source>
        <translation type="obsolete">Подразумевани профил боја за ивезене RGB слике</translation>
    </message>
    <message>
        <location filename="../cmsprefs.cpp" line="98"/>
        <source>Pictures:</source>
        <translation type="obsolete">Слике:</translation>
    </message>
</context>
<context>
    <name>CMSPrefsBase</name>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="19"/>
        <source>Form</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="40"/>
        <source>&amp;Activate Color Management</source>
        <translation type="unfinished">&amp;Активирај управљање бојама</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="50"/>
        <source>System Profiles</source>
        <translation type="unfinished">Системски профили</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="74"/>
        <source>&amp;RGB Images:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="90"/>
        <source>Default color profile for imported RGB images</source>
        <translation type="unfinished">Подразумевани профил боја за ивезене RGB слике</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="97"/>
        <source>&amp;CMYK Images:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="113"/>
        <source>Default color profile for imported CMYK images</source>
        <translation type="unfinished">Подразумевани профил боја за ивезене CMYK слике</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="120"/>
        <source>&amp;RGB Solid Colors:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="136"/>
        <source>Default color profile for solid RGB colors on the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="143"/>
        <source>&amp;CMYK Solid Colors:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="159"/>
        <source>Default color profile for solid CMYK colors on the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="166"/>
        <source>&amp;Monitor:</source>
        <translation type="unfinished">&amp;Надгледач:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="182"/>
        <source>Color profile that you have generated or received from the manufacturer.
This profile should be specific to your monitor and not a generic profile (i.e. sRGB).</source>
        <translation type="unfinished">Профил боја који сте направили или добили од произвођача.
Овај профил би требало да буде баш за Ваш монитор, а не генерички профил (тј. sRGB).</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="190"/>
        <source>P&amp;rinter:</source>
        <translation type="unfinished">Ш&amp;тампач:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="206"/>
        <source>Color profile for your printer model from the manufacturer.
This profile should be specific to your printer and not a generic profile (i.e. sRGB).</source>
        <translation type="unfinished">Профил боја за Ваш модел штампача од произвођача.
Овај профил би требало да буде баш за Ваш штампач, а не генерички профил (тј. sRGB).</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="220"/>
        <source>Rendering Intents</source>
        <translation type="unfinished">Намере рендеровања</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="244"/>
        <source>Images:</source>
        <translation type="unfinished">Слике:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="260"/>
        <source>Default rendering intent for images. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="268"/>
        <source>Sol&amp;id Colors:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="284"/>
        <source>Default rendering intent for solid colors. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="298"/>
        <source>Enable &apos;soft proofing&apos; of how your document colors will print,
based on the chosen printer profile.</source>
        <translation type="unfinished">Укључи „меко проверавање“ како ће се штампати боје у Вашем документу,
на основу изабраног профила за штампач.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="302"/>
        <source>Sim&amp;ulate Printer on the Screen</source>
        <translation type="unfinished">Симу&amp;лирај штампач на екрану</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="329"/>
        <source>Simulate a full color managed environment :
all colors, rgb or cmyk, are converted to printer color space.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="333"/>
        <source>Convert all colors to printer space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="340"/>
        <source>Method of showing colors on the screen which may not print properly.
This requires very accurate profiles and serves only as a warning.</source>
        <translation type="unfinished">Метод за приказивање боја на екрану које можда неће бити добро одштампане.
Ово захтева веома прецизне профиле и служи само као упозорење.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="344"/>
        <source>Mark Colors out of &amp;Gamut</source>
        <translation type="unfinished">Означи боје изван &amp;gamut-а</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="357"/>
        <source>Black Point Compensation is a method of improving contrast in photos.
It is recommended that you enable this if you have photos in your document.</source>
        <translation type="unfinished">Компензација црне тачке је метод поправљања контраста на фотографијама.
Препоручљиво је да ово укључите ако имате фотографије у документу.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="361"/>
        <source>Use &amp;Blackpoint Compensation</source>
        <translation type="unfinished">Користи компензацију &amp;црне тачке</translation>
    </message>
</context>
<context>
    <name>CMYKChoose</name>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="92"/>
        <source>Edit Color</source>
        <translation>Уређивање боја</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="101"/>
        <source>&amp;Name:</source>
        <translation>&amp;Име:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="111"/>
        <source>Color &amp;Model</source>
        <translation>&amp;Модел боја</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="906"/>
        <source>CMYK</source>
        <translation>CMYK</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="911"/>
        <source>RGB</source>
        <translation>RGB</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="764"/>
        <source>Web Safe RGB</source>
        <translation>Веб сигуран RGB</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="141"/>
        <source>New</source>
        <translation>Нови</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="158"/>
        <source>Old</source>
        <translation>Стари</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="195"/>
        <source>HSV-Colormap</source>
        <translation type="obsolete">HSV мапа боја</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="705"/>
        <source>C:</source>
        <translation>C:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="704"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="706"/>
        <source>M:</source>
        <translation>M:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="707"/>
        <source>Y:</source>
        <translation>Y:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="347"/>
        <source>K:</source>
        <translation>K:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="444"/>
        <source>Dynamic Color Bars</source>
        <translation>Динамичке линије боја</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="442"/>
        <source>Static Color Bars</source>
        <translation>Статичне линије боја</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="749"/>
        <source>R:</source>
        <translation>R:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="750"/>
        <source>G:</source>
        <translation>G:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="751"/>
        <source>B:</source>
        <translation>B:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="125"/>
        <source>Is Spot Color</source>
        <translation>је спот боја</translation>
    </message>
    <message>
        <location filename="../cmykfw.cpp" line="128"/>
        <source>Is Registration Color</source>
        <translation type="obsolete">је регистрациона боја</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="1002"/>
        <source>You cannot create a color named &quot;%1&quot;.
It is a reserved name for transparent color</source>
        <translation>Не можеш да направиш боју под називом &quot;%1&quot;. 
Назив је режервисан за провидну боју</translation>
    </message>
    <message>
        <location filename="../cmykfw.cpp" line="385"/>
        <source>Choosing this will enable printing this on all plates. Registration colors are used for printer marks such as crop marks, registration marks and the like. These are not typically used in the layout itself.</source>
        <translation type="obsolete">Избор ће одобрити штампање овога на свим плочама. Регистрационе боје се користе за штампарске ознаке као што су: ознаке за сечење, регистрационе ознаке и сл. Обично се не користе при креирању садржаја самих страна.</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>If color management is enabled, a triangle warning indicator is a warning the the color maybe outside of the color gamut of the current printer profile selected. What this means is the color may not print exactly as indicated on screen. More hints about gamut warnings are in the online help under Color Management.</source>
        <translation type="obsolete">Ако је управљање бојама укључено, упозорење у виду троугла је упзорење да је боја можда изван гамута тренутно изабраног колор профила штампе. То значи да боја можда неће бити одштампана како је приказана на екрану. Више савета о упозорењима о гамуту је доступно у помоћи под Управљање бојама, на мрежи.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="1011"/>
        <source>The name of the color already exists,
please choose another one.</source>
        <translation>Име боје већ постоји, изабери друго име.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="390"/>
        <source>Choosing this will make this color a spot color, thus creating another spot when creating plates or separations. This is used most often when a logo or other color needs exact representation or cannot be replicated with CMYK inks. Metallic and fluorescent inks are good examples which cannot be easily replicated with CMYK inks.</source>
        <translation>Избор ће направити ову боју спот бојом, стога, направиће још једну плочи или сепарацију. Најчешћа примена је када лого или нека боја захтевају потпуно тачну репродукцију или се жељена боја не може репродуковати коришћењем CMYK процесних боја. Металик и флуоресцентне боје су добри примери шта четворобојна CMYK штампа не може да пружи.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="785"/>
        <source>If color management is enabled, a triangle warning indicator is a warning that the color maybe outside of the color gamut of the current printer profile selected. What this means is the color may not print exactly as indicated on screen. More hints about gamut warnings are in the online help under Color Management.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="995"/>
        <source>You cannot create a color without a name
Please give it a name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="196"/>
        <source>HSV Color Map</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CStyleP</name>
    <message>
        <location filename="../smcstylew.ui" line="13"/>
        <source>Form1</source>
        <translation type="obsolete">Формулар1</translation>
    </message>
    <message>
        <location filename="../smcstylew.ui" line="89"/>
        <source>Basic Formatting</source>
        <translation type="obsolete">Основно уобличавање</translation>
    </message>
    <message>
        <location filename="../smcstylew.ui" line="99"/>
        <source>Advanced Formatting</source>
        <translation type="obsolete">Напредно уобличавање</translation>
    </message>
    <message>
        <location filename="../smcstylew.ui" line="109"/>
        <source>Colors</source>
        <translation type="obsolete">Боје</translation>
    </message>
</context>
<context>
    <name>CStylePBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Form1</source>
        <translation type="obsolete">Формулар1</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Based On:</source>
        <translation type="obsolete">На основу:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Basic Formatting</source>
        <translation type="obsolete">Основно уобличавање</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Advanced Formatting</source>
        <translation type="obsolete">Напредно уобличавање</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Colors</source>
        <translation type="obsolete">Боје</translation>
    </message>
</context>
<context>
    <name>CWDialog</name>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="319"/>
        <source>Merging colors</source>
        <translation>Спајам боје</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="325"/>
        <source>Error: </source>
        <translation>Грешка:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="325"/>
        <source>Color %1 exists already!</source>
        <translation>Боја %1 већ постоји!</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="330"/>
        <source>Color %1 appended.</source>
        <translation>Боја %1 придодата.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="334"/>
        <source>Now opening the color manager.</source>
        <translation>Сада отварам управљач бојама.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="337"/>
        <source>Color Merging</source>
        <translation>Спајање боја</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="488"/>
        <source>Unable to find the requested color. You have probably selected black, gray or white. There is no way to process this color.</source>
        <translation>Немогуће је наћи жељену боју. Вероватно је изабрана црна, сива или бела. Нема начина да се направи ова боја.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="15"/>
        <source>Color Wheel</source>
        <translation type="unfinished">Точак боја</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="45"/>
        <source>Click the wheel to get the base color. Its color model depends on the chosen tab.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="52"/>
        <source>Result Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="322"/>
        <source>CMYK</source>
        <translation type="unfinished">CMYK</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="543"/>
        <source>RGB</source>
        <translation type="unfinished">RGB</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="729"/>
        <source>HSV</source>
        <translation type="unfinished">HSV</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="106"/>
        <source>Colors of your chosen color scheme.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="116"/>
        <source>Color Scheme Method</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="142"/>
        <source>Angle:</source>
        <translation type="unfinished">Угао:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="152"/>
        <source>Difference between the selected value and the counted ones. Refer to documentation for more information.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="167"/>
        <source>Select one of the methods to create a color scheme. Refer to documentation for more information.</source>
        <translation type="unfinished">Изабери један од наћина за прављење шеме боја. Обрати се документацији за више информација.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="201"/>
        <source>Merge created colors into the document colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="204"/>
        <source>&amp;Merge</source>
        <translation type="unfinished">&amp;Сједини</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="207"/>
        <source>Alt+M</source>
        <translation type="unfinished">Alt+M</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="214"/>
        <source>Replace created colors in the document colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="217"/>
        <source>&amp;Replace</source>
        <translation type="unfinished">&amp;Замени</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="220"/>
        <source>Alt+R</source>
        <translation type="unfinished">Alt+R</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="227"/>
        <source>Leave colors untouched</source>
        <translation type="unfinished">Остави боје нетакнуте</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="230"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Откажи</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="233"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="242"/>
        <source>Preview:</source>
        <translation type="unfinished">Преглед:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="266"/>
        <source>Sample color scheme.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="285"/>
        <source>Simulate common vision defects here. Select type of the defect.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="292"/>
        <source>Vision Defect Type:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="342"/>
        <source>C:</source>
        <translation type="unfinished">C:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="442"/>
        <source> %</source>
        <translation type="unfinished"> %</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="372"/>
        <source>M:</source>
        <translation type="unfinished">M:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="402"/>
        <source>Y:</source>
        <translation type="unfinished">Y:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="432"/>
        <source>K:</source>
        <translation type="unfinished">K:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="838"/>
        <source>RGB:</source>
        <translation type="unfinished">RGB:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="685"/>
        <source>HSV:</source>
        <translation type="unfinished">HSV:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="571"/>
        <source>R:</source>
        <translation type="unfinished">R:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="598"/>
        <source>G:</source>
        <translation type="unfinished">G:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="625"/>
        <source>B:</source>
        <translation type="unfinished">B:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="874"/>
        <source>CMYK:</source>
        <translation type="unfinished">CMYK:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="757"/>
        <source>H:</source>
        <translation type="unfinished">H:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="784"/>
        <source>S:</source>
        <translation type="unfinished">S:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="811"/>
        <source>V:</source>
        <translation type="unfinished">V:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="918"/>
        <source>Document</source>
        <translation type="unfinished">Документ</translation>
    </message>
</context>
<context>
    <name>CWDialogBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Color Wheel</source>
        <translation type="obsolete">Точак боја</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>C:</source>
        <translation type="obsolete">C:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>M:</source>
        <translation type="obsolete">M:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Y:</source>
        <translation type="obsolete">Y:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>K:</source>
        <translation type="obsolete">K:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>RGB:</source>
        <translation type="obsolete">RGB:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>R:</source>
        <translation type="obsolete">R:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>G:</source>
        <translation type="obsolete">G:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>B:</source>
        <translation type="obsolete">B:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>CMYK:</source>
        <translation type="obsolete">CMYK:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Document</source>
        <translation type="obsolete">Документ</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Select one of the methods to create a color scheme. Refer to documentation for more information.</source>
        <translation type="obsolete">Изабери један од наћина за прављење шеме боја. Обрати се документацији за више информација.</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Angle:</source>
        <translation type="obsolete">Угао:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Preview:</source>
        <translation type="obsolete">Преглед:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Merge</source>
        <translation type="obsolete">&amp;Сједини</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+M</source>
        <translation type="obsolete">Alt+M</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Replace</source>
        <translation type="obsolete">&amp;Замени</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+R</source>
        <translation type="obsolete">Alt+R</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Откажи</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Leave colors untouched</source>
        <translation type="obsolete">Остави боје нетакнуте</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source> %</source>
        <translation type="obsolete"> %</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>HSV:</source>
        <translation type="obsolete">HSV:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>HSV</source>
        <translation type="obsolete">HSV</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>H:</source>
        <translation type="obsolete">H:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>S:</source>
        <translation type="obsolete">S:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>V:</source>
        <translation type="obsolete">V:</translation>
    </message>
</context>
<context>
    <name>Canvas</name>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2243"/>
        <source>X: %1
Y: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2228"/>
        <source>X: %1</source>
        <translation type="unfinished">X: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2235"/>
        <source>Y: %1</source>
        <translation type="unfinished">Y: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2251"/>
        <source>Length: %1
Angle: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2253"/>
        <source>Width: %1
Height: %2</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CanvasMode_EyeDropper</name>
    <message>
        <location filename="../../scribus/canvasmode_eyedropper.cpp" line="167"/>
        <source>The selected color does not exist in the document&apos;s color set. Please enter a name for this new color.</source>
        <translation type="unfinished">Изабрана боја не постоји у скупу боја овог документа. Унеси име нове боје.</translation>
    </message>
    <message>
        <location filename="../../scribus/canvasmode_eyedropper.cpp" line="170"/>
        <source>Color Not Found</source>
        <translation type="unfinished">Боја није пронађена</translation>
    </message>
    <message>
        <location filename="../../scribus/canvasmode_eyedropper.cpp" line="174"/>
        <source>The name you have selected already exists. Please enter a different name for this new color.</source>
        <translation type="unfinished">Изабрано име већ постоји. Унеси друго име за ову нову боју.</translation>
    </message>
</context>
<context>
    <name>CanvasMode_Normal</name>
    <message>
        <location filename="../../scribus/canvasmode_normal.cpp" line="1331"/>
        <source>All Supported Formats</source>
        <translation type="unfinished">Сви подржани формати</translation>
    </message>
    <message>
        <location filename="../../scribus/canvasmode_normal.cpp" line="1362"/>
        <source>Open</source>
        <translation type="unfinished">Отвори</translation>
    </message>
</context>
<context>
    <name>CharSelect</name>
    <message>
        <location filename="../../scribus/charselect.ui" line="100"/>
        <source>Font:</source>
        <translation type="obsolete">Фонт:</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="203"/>
        <source>&amp;Insert</source>
        <translation type="obsolete">Уметн&amp;и</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="213"/>
        <source>C&amp;lear</source>
        <translation type="obsolete">Оч&amp;исти</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="200"/>
        <source>Insert the characters at the cursor in the text</source>
        <translation type="obsolete">Уметни карактере на месту курсора у тексту</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="210"/>
        <source>Delete the current selection(s).</source>
        <translation type="obsolete">Обриши текући избор(е).</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="369"/>
        <source>Greek</source>
        <translation type="obsolete">Грчки</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="375"/>
        <source>Greek Extended</source>
        <translation type="obsolete">Проширени грчки</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="381"/>
        <source>Cyrillic</source>
        <translation type="obsolete">Ћирилични</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="393"/>
        <source>Arabic</source>
        <translation type="obsolete">Арапски</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="399"/>
        <source>Arabic Extended A</source>
        <translation type="obsolete">Проширени арапски А</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="405"/>
        <source>Arabic Extended B</source>
        <translation type="obsolete">Проширени арапски Б</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="411"/>
        <source>Hebrew</source>
        <translation type="obsolete">Хебрејски</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="31"/>
        <source>Scribus Char Palette (*.ucp);;All Files (*)</source>
        <translation>Скрибусова палета знакова (*.ucp);;Сви фајлови (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="226"/>
        <source>Choose a filename to open</source>
        <translation>Изабери име фајла који желиш да отвориш</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="297"/>
        <source>Error</source>
        <translation type="unfinished">Грешка</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="256"/>
        <source>Error reading file %1 - file is corrupted propably.</source>
        <translation>Грешка при отварању фајла %1 - фајл је вероватно оштећен.</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="625"/>
        <source>Choose a filename to save under</source>
        <translation type="obsolete">Изабери име фајла у којем желиш да буде сачувано</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="298"/>
        <source>Cannot write file %1</source>
        <translation>Не могу да запишем у фајл %1</translation>
    </message>
    <message>
        <location filename="../charselect.cpp" line="634"/>
        <source>Clean the Palette?</source>
        <translation type="obsolete">Очистити палету?</translation>
    </message>
    <message>
        <location filename="../charselect.cpp" line="635"/>
        <source>You will clean all characters from this palette. Are you sure?</source>
        <translation type="obsolete">Очистићеш све знакове из ове палете. Да ли си сигуран?</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="13"/>
        <source>Character Palette</source>
        <translation>Палета знакова</translation>
    </message>
    <message>
        <location filename="../charselect.ui" line="56"/>
        <source>&amp;Search</source>
        <translation type="obsolete">&amp;Тражи</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="306"/>
        <source>Empty the Palette?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="307"/>
        <source>You will remove all characters from this palette. Are you sure?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="24"/>
        <source>Hide/Show Enhanced Palette</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="272"/>
        <source>Save Quick Character Palette</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CharSelectEnhanced</name>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="205"/>
        <source>Full Character Set</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="210"/>
        <source>Basic Latin</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="216"/>
        <source>Latin-1 Supplement</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="222"/>
        <source>Latin Extended-A</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="228"/>
        <source>Latin Extended-B</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="234"/>
        <source>General Punctuation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="240"/>
        <source>Super- and Subscripts</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="246"/>
        <source>Currency Symbols</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="252"/>
        <source>Letterlike Symbols</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="258"/>
        <source>Number Forms</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="264"/>
        <source>Arrows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="270"/>
        <source>Mathematical Operators</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="276"/>
        <source>Box Drawing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="282"/>
        <source>Block Elements</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="288"/>
        <source>Geometric Shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="294"/>
        <source>Miscellaneous Symbols</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="300"/>
        <source>Dingbats</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="306"/>
        <source>Small Form Variants</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="312"/>
        <source>Ligatures</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="318"/>
        <source>Specials</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="324"/>
        <source>Greek</source>
        <translation type="unfinished">Грчки</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="330"/>
        <source>Greek Extended</source>
        <translation type="unfinished">Проширени грчки</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="336"/>
        <source>Cyrillic</source>
        <translation type="unfinished">Ћирилични</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="342"/>
        <source>Cyrillic Supplement</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="348"/>
        <source>Arabic</source>
        <translation type="unfinished">Арапски</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="354"/>
        <source>Arabic Extended A</source>
        <translation type="unfinished">Проширени арапски А</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="360"/>
        <source>Arabic Extended B</source>
        <translation type="unfinished">Проширени арапски Б</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="366"/>
        <source>Hebrew</source>
        <translation type="unfinished">Хебрејски</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="13"/>
        <source>Enhanced Character Palette</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="19"/>
        <source>&amp;Font:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="45"/>
        <source>C&amp;haracter Class:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="77"/>
        <source>You can see a thumbnail if you press and hold down the right mouse button.
The Insert key inserts a Glyph into the Selection below and the Delete key removes the last inserted one</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="96"/>
        <source>Insert &amp;Code:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="131"/>
        <source>Glyphs to Insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="171"/>
        <source>Insert the characters at the cursor in the text</source>
        <translation type="unfinished">Уметни карактере на месту курсора у тексту</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="174"/>
        <source>&amp;Insert</source>
        <translation type="unfinished">Уметн&amp;и</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="184"/>
        <source>Delete the current selection(s).</source>
        <translation type="unfinished">Обриши текући избор(е).</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="187"/>
        <source>C&amp;lear</source>
        <translation type="unfinished">Оч&amp;исти</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="106"/>
        <source>Type in a four digit Unicode value directly here</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CharStyleComboBox</name>
    <message>
        <location filename="../../scribus/spalette.cpp" line="118"/>
        <source>No Style</source>
        <translation type="unfinished">Нема стила</translation>
    </message>
</context>
<context>
    <name>CharTable</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Delete</source>
        <translation type="obsolete">Обриши</translation>
    </message>
</context>
<context>
    <name>CharTableView</name>
    <message>
        <location filename="../../scribus/chartableview.cpp" line="22"/>
        <source>Delete</source>
        <translation type="unfinished">Обриши</translation>
    </message>
</context>
<context>
    <name>CheckDocument</name>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="652"/>
        <source>Current Profile:</source>
        <translation>Тренутни профил:</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="647"/>
        <source>Items</source>
        <translation>Ставке</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="648"/>
        <source>Problems</source>
        <translation>Проблеми</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="660"/>
        <source>Glyphs missing</source>
        <translation>Знак недостаје</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="661"/>
        <source>Text overflow</source>
        <translation>Текст прелива</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="662"/>
        <source>Object is not on a Page</source>
        <translation>Објекат се не налази на страни</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="663"/>
        <source>Missing Image</source>
        <translation>Слика недостаје</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="667"/>
        <source>Object has transparency</source>
        <translation>Објекат има провидност</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="669"/>
        <source>Object is a placed PDF</source>
        <translation>Објекат је постављени PDF</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="379"/>
        <source>Document</source>
        <translation type="unfinished">Документ</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="381"/>
        <source>No Problems found</source>
        <translation>Нема пронађених проблема</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="548"/>
        <source>Page </source>
        <translation type="unfinished">Страница</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="612"/>
        <source>Free Objects</source>
        <translation>Слободни објекти</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="843"/>
        <source>Problems found</source>
        <translation type="obsolete">Пронађени проблеми</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="645"/>
        <source>Preflight Verifier</source>
        <translation>Провера могућих проблема</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="668"/>
        <source>Object is a PDF Annotation or Field</source>
        <translation>Објекат је PDF анотација или поље</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="653"/>
        <source>&amp;Ignore Errors</source>
        <translation>&amp;Игнориши грешке</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="654"/>
        <source>Check again</source>
        <translation>Провери поново</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="882"/>
        <source>Image resolution below %1 DPI, currently %2 x %3 DPI</source>
        <translation type="obsolete">Резолуција слике је испод %1 тпи, тренутно %2 x %3 тпи</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="883"/>
        <source>Image resolution above %1 DPI, currently %2 x %3 DPI</source>
        <translation type="obsolete">Резолуција слике је преко %1 тпи, тренутно %2 x %3 тпи</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="670"/>
        <source>Image is GIF</source>
        <translation>Слика је GIF</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="382"/>
        <source>OK</source>
        <translation type="unfinished">У реду</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="412"/>
        <source>Transparency used</source>
        <translation>Провидност је коришћена</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="415"/>
        <source>Blendmode used</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="422"/>
        <source>Layer &quot;%1&quot;</source>
        <translation>Слој &quot;%1&quot;</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="671"/>
        <source>Annotation uses a non TrueType font</source>
        <translation>Анотација користи font који није TrueType</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="656"/>
        <source>Preflight profile to base the report generation on. Options can be set in Document Setup or Preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="657"/>
        <source>Ignore found errors and continue to export or print. Be sure to understand the errors you are ignoring before continuing.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="658"/>
        <source>Rerun the document scan to check corrections you may have made</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="664"/>
        <source>Empty Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="393"/>
        <source>Layers</source>
        <translation type="unfinished">Слојеви</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="493"/>
        <source>Issue(s): %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="435"/>
        <source>Master Pages</source>
        <translation type="unfinished">Главне стране</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="648"/>
        <source>Layer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="665"/>
        <source>Image resolution below %1 DPI,
currently %2 x %3 DPI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="666"/>
        <source>Image resolution above %1 DPI,
currently %2 x %3 DPI</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ChooseStyles</name>
    <message>
        <location filename="../editformats.cpp" line="95"/>
        <source>Choose Styles</source>
        <translation type="obsolete">Изабери стил</translation>
    </message>
    <message>
        <location filename="../editformats.cpp" line="100"/>
        <source>Available Styles</source>
        <translation type="obsolete">Доступни стилови</translation>
    </message>
</context>
<context>
    <name>CollectForOutput</name>
    <message>
        <location filename="../../scribus/collect4output.cpp" line="52"/>
        <source>Choose a Directory</source>
        <translation type="unfinished">Изаберите директоријум</translation>
    </message>
    <message>
        <location filename="../../scribus/collect4output.cpp" line="68"/>
        <source>Collecting...</source>
        <translation>Сакупљам...</translation>
    </message>
    <message>
        <location filename="../../scribus/collect4output.cpp" line="73"/>
        <source>Cannot collect all files for output for file:
%1</source>
        <translation>Не могу да покупим све за извоз у фајл:
%1</translation>
    </message>
    <message>
        <location filename="../../scribus/collect4output.cpp" line="87"/>
        <source>Cannot collect the file: 
%1</source>
        <translation>Не могу да покупим фајл: 
%1</translation>
    </message>
</context>
<context>
    <name>ColorManager</name>
    <message>
        <location filename="../../scribus/colorm.cpp" line="54"/>
        <source>Colors</source>
        <translation type="unfinished">Боје</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="80"/>
        <source>&amp;Import</source>
        <translation type="unfinished">&amp;Увези</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="82"/>
        <source>&amp;New</source>
        <translation type="unfinished">&amp;Нови</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="84"/>
        <source>&amp;Edit</source>
        <translation type="unfinished">&amp;Уреди</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="88"/>
        <source>D&amp;uplicate</source>
        <translation>Д&amp;уплирај</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="91"/>
        <source>&amp;Delete</source>
        <translation type="unfinished">&amp;Обриши</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="96"/>
        <source>&amp;Remove Unused</source>
        <translation type="unfinished">&amp;Уклони некоришћено</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="103"/>
        <source>Color Sets</source>
        <translation type="unfinished">Скупови боја</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="109"/>
        <source>Current Color Set:</source>
        <translation type="unfinished">Текући скуп боја:</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="140"/>
        <source>&amp;Save Color Set</source>
        <translation type="unfinished">&amp;Сними скуп боја</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="159"/>
        <source>Choose a color set to load</source>
        <translation type="unfinished">Изаберите скуп боја за учитавање</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="160"/>
        <source>Save the current color set</source>
        <translation type="unfinished">Сними текући скуп боја</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="165"/>
        <source>Remove unused colors from current document&apos;s color set</source>
        <translation type="unfinished">Уклони некоришћене боје из скупа боја текућег документа</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="167"/>
        <source>Import colors to the current set from an existing document</source>
        <translation>Увези боје у текући скуп боја из документа</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="168"/>
        <source>Create a new color within the current set</source>
        <translation type="unfinished">Направи нову боју у оквиру текућег скупа</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="169"/>
        <source>Edit the currently selected color</source>
        <translation type="unfinished">Уреди тренутно изабрану боју</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="170"/>
        <source>Make a copy of the currently selected color</source>
        <translation type="unfinished">Направи копију тренутно изабране боје</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="171"/>
        <source>Delete the currently selected color</source>
        <translation type="unfinished">Обриши тренутно изабрану боју</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="172"/>
        <source>Make the current colorset the default color set</source>
        <translation type="unfinished">Учини да тренутни скуп боја буде подразумевани</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="190"/>
        <source>&amp;Name:</source>
        <translation type="unfinished">&amp;Име:</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="190"/>
        <source>Choose a Name</source>
        <translation type="unfinished">Изаберите име</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="353"/>
        <source>Copy of %1</source>
        <translation type="unfinished">Копија од %1</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="364"/>
        <source>New Color</source>
        <translation type="unfinished">Нова боја</translation>
    </message>
    <message>
        <location filename="../colorm.cpp" line="172"/>
        <source>If color management is enabled, a triangle warning indicator is a warning the the color maybe outside of the color gamut of the current printer profile selected.What this means is the color may not print exactly as indicated on screen. Spot colors are indicated by a red circle. Registration colors will have a registration mark next to the color. More hints about gamut warnings are in the online help under Color Management.</source>
        <translation type="obsolete">Ако је управљање бојама укључено, упозорење у виду троугла је упзорење да је боја можда изван гамута тренутно изабраног колор профила штампе. То значи да боја можда неће бити одштампана како је приказана на екрану. Спот боје су означене црвеним кругом. Регистрационе боје имају регистрациони знак одмах до боје саме. Више савета о упозорењима о гамуту је доступно у помоћи под Управљање бојама, на мрежи.</translation>
    </message>
    <message>
        <location filename="../colorm.cpp" line="428"/>
        <source>Documents (*.sla *.sla.gz *.scd *.scd.gz);;Other Files (*.eps *.epsi *.ps *.ai);;All Files (*)</source>
        <translation type="obsolete">Документи (*.sla *.sla.gz *.scd *.scd.gz);;Остали фајлови (*.eps *.epsi *.ps *.ai);;Сви фајлови (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="321"/>
        <source>Information</source>
        <translation type="unfinished">Информација</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="321"/>
        <source>Import</source>
        <translation type="obsolete">Увези</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="321"/>
        <source>The file %1 does not contain colors which can be imported.
If the file was a PostScript-based, try to import it with File -&amp;gt; Import. 
Not all files have DSC conformant comments where the color descriptions are located.
 This prevents importing colors from some files.
See the Edit Colors section of the documentation for more details.</source>
        <translation>Фајл %1 не садржи боје које је могуће увести. 
Ако је фајл заснован на ПостСкрипт-у, покушај да га увезеш са File -&amp;gt; Import. 
Не садрже сви фајлови DSC коментаре где се налази опис боја. 
 То онемогућује увоз  боја из неких фајлова. 
Обрати се \&quot;Уређивање боја\&quot; одељку документације за више детаља.</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="173"/>
        <source>If color management is enabled, a triangle warning indicator is a warning that the color maybe outside of the color gamut of the current printer profile selected. What this means is the color may not print exactly as indicated on screen. Spot colors are indicated by a red circle. More hints about gamut warnings are in the online help under Color Management. Registration colors will have a registration mark next to the color. Use Registration only for printers marks and crop marks.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="311"/>
        <source>All Supported Formats (%1);;Documents (%2);;Other Files (%3);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="312"/>
        <source>Import Colors</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ColorWheel</name>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="139"/>
        <source>Monochromatic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="140"/>
        <source>Analogous</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="224"/>
        <source>Complementary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="142"/>
        <source>Split Complementary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="143"/>
        <source>Triadic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="144"/>
        <source>Tetradic (Double Complementary)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="44"/>
        <source>Base Color</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="206"/>
        <source>Monochromatic Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="209"/>
        <source>Monochromatic Dark</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="216"/>
        <source>1st. Analogous</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="217"/>
        <source>2nd. Analogous</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="231"/>
        <source>1st. Split</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="232"/>
        <source>2nd. Split</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="233"/>
        <source>3rd. Split</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="234"/>
        <source>4th. Split</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="241"/>
        <source>1st. Triadic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="242"/>
        <source>2nd. Triadic</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="249"/>
        <source>1st. Tetradic (base opposite)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="250"/>
        <source>2nd. Tetradic (angle)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="251"/>
        <source>3rd. Tetradic (angle opposite)</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ColorWheelPlugin</name>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheel.cpp" line="47"/>
        <source>&amp;Color Wheel...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheel.cpp" line="64"/>
        <source>Color setting helper</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheel.cpp" line="65"/>
        <source>Color selector with color theory included.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CommonStrings</name>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="244"/>
        <source>&amp;Apply</source>
        <translation type="unfinished">&amp;Примени</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="247"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Откажи</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="250"/>
        <source>None</source>
        <translation type="unfinished">Ниједан</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="254"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;У реду</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="257"/>
        <source>&amp;Save</source>
        <translation type="unfinished">&amp;Сними</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="260"/>
        <source>Warning</source>
        <translation type="unfinished">Упозорење</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <comment>

color name</comment>
        <translation type="obsolete">Ниједна</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Custom</source>
        <comment>



CommonStrings, custom page size</comment>
        <translation type="obsolete">Произвољно</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="291"/>
        <source>Single Page</source>
        <translation>Једнострано</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="292"/>
        <source>Double Sided</source>
        <translation>Двострано</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="293"/>
        <source>3-Fold</source>
        <translation>Троструко савијен</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="294"/>
        <source>4-Fold</source>
        <translation>Четвороструко савијен</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="330"/>
        <source>Monday</source>
        <translation>Понедељак</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="331"/>
        <source>Tuesday</source>
        <translation>Уторак</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="332"/>
        <source>Wednesday</source>
        <translation>Среда</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="333"/>
        <source>Thursday</source>
        <translation>Четвртак</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="334"/>
        <source>Friday</source>
        <translation>Петак</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="335"/>
        <source>Saturday</source>
        <translation>Субота</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="336"/>
        <source>Sunday</source>
        <translation>Недеља</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="337"/>
        <source>January</source>
        <translation>Јануар</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="338"/>
        <source>February</source>
        <translation>Фебруар</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="339"/>
        <source>March</source>
        <translation>Март</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="340"/>
        <source>April</source>
        <translation>Април</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="341"/>
        <source>May</source>
        <translation>Мај</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="342"/>
        <source>June</source>
        <translation>Јун</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="343"/>
        <source>July</source>
        <translation>Јул</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="344"/>
        <source>August</source>
        <translation>Август</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="345"/>
        <source>September</source>
        <translation>Септембар</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="346"/>
        <source>October</source>
        <translation>Октобар</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="347"/>
        <source>November</source>
        <translation>Новембар</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="348"/>
        <source>December</source>
        <translation>Децембар</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="262"/>
        <source>Yes</source>
        <translation type="unfinished">Да</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="263"/>
        <source>No</source>
        <translation type="unfinished">Не</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="264"/>
        <source>&amp;Yes</source>
        <translation type="unfinished">&amp;Да</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="265"/>
        <source>&amp;No</source>
        <translation type="unfinished">&amp;Не</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="301"/>
        <source>Left Page</source>
        <comment>Left page location</comment>
        <translation>Лева страна</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="302"/>
        <source>Middle</source>
        <comment>Middle page location</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="303"/>
        <source>Middle Left</source>
        <comment>Middle Left page location</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="304"/>
        <source>Middle Right</source>
        <comment>Middle Right page location</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="305"/>
        <source>Right Page</source>
        <comment>Right page location</comment>
        <translation>Десна страна</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Normal</source>
        <comment>



Default single master page</comment>
        <translation type="obsolete">Нормално</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="310"/>
        <source>Normal Left</source>
        <comment>Default left master page</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="312"/>
        <source>Normal Middle</source>
        <comment>Default middle master page</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="314"/>
        <source>Normal Right</source>
        <comment>Default right master page</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="356"/>
        <source>Normal Vision</source>
        <comment>Color Blindness - Normal Vision</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="357"/>
        <source>Protanopia (Red)</source>
        <comment>Color Blindness - Red Color Blind</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="358"/>
        <source>Deuteranopia (Green)</source>
        <comment>Color Blindness - Greed Color Blind</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="359"/>
        <source>Tritanopia (Blue)</source>
        <comment>Color Blindness - Blue Color Blind</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="360"/>
        <source>Full Color Blindness</source>
        <comment>Color Blindness - Full Color Blindness</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="362"/>
        <source>Custom: </source>
        <comment>Custom Tab Fill Option</comment>
        <translation>Произвољна:</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="316"/>
        <source>Solid Line</source>
        <translation type="unfinished">Непрекидна линија</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="317"/>
        <source>Dashed Line</source>
        <translation type="unfinished">Испрекидана линија</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="318"/>
        <source>Dotted Line</source>
        <translation>Истачкана линија</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="319"/>
        <source>Dash Dot Line</source>
        <translation type="unfinished">Црта-тачка</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="320"/>
        <source>Dash Dot Dot Line</source>
        <translation type="unfinished">Црта-тачка-тачка</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <comment>



Optical Margin Setting</comment>
        <translation type="obsolete">Ниједан</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="365"/>
        <source>Left Protruding</source>
        <comment>Optical Margin Setting</comment>
        <translation>Избачен лево</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="366"/>
        <source>Right Protruding</source>
        <comment>Optical Margin Setting</comment>
        <translation>Избачен десно</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="367"/>
        <source>Left Hanging Punctuation</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="368"/>
        <source>Right Hanging Punctuation</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Both sides</source>
        <comment>Optical Margin Setting</comment>
        <translation type="obsolete">Обе стране</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="372"/>
        <source>Min. Word Tracking</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="376"/>
        <source>Min. Glyph Extension</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="377"/>
        <source>Max. Glyph Extension</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="251"/>
        <source>None</source>
        <comment>color name</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="285"/>
        <source>Custom</source>
        <comment>CommonStrings, custom page size</comment>
        <translation type="unfinished">Произвољно</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="308"/>
        <source>Normal</source>
        <comment>Default single master page</comment>
        <translation type="unfinished">Нормално</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="364"/>
        <source>None</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="369"/>
        <source>Default</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="373"/>
        <source>Max. Word Tracking</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="350"/>
        <source>RGB</source>
        <comment>Colorspace</comment>
        <translation type="unfinished">RGB</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="351"/>
        <source>CMYK</source>
        <comment>Colorspace</comment>
        <translation type="unfinished">CMYK</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="352"/>
        <source>Grayscale</source>
        <comment>Colorspace</comment>
        <translation type="unfinished">Нијансе сиве</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="353"/>
        <source>Duotone</source>
        <comment>Colorspace</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="354"/>
        <source>Unknown</source>
        <comment>Colorspace (Unknown)</comment>
        <translation type="unfinished">Непознат</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="381"/>
        <source>PostScript</source>
        <translation type="unfinished">PostScript</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="267"/>
        <source>Text Frame</source>
        <translation type="unfinished">Текстуални оквир</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="268"/>
        <source>Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="269"/>
        <source>Line</source>
        <translation type="unfinished">Линија</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="270"/>
        <source>Polygon</source>
        <translation type="unfinished">Полигон</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="271"/>
        <source>Polyline</source>
        <translation type="unfinished">Полилинија</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="272"/>
        <source>Text on a Path</source>
        <translation type="unfinished">Текст на путањи</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="274"/>
        <source>Multiple</source>
        <comment>Multiple frame types</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="275"/>
        <source>PDF Push Button</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="276"/>
        <source>PDF Text Field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="277"/>
        <source>PDF Check Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="278"/>
        <source>PDF Combo Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="279"/>
        <source>PDF List Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="280"/>
        <source>PDF Text Annotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="281"/>
        <source>PDF Link Annotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="388"/>
        <source>PostScript Level 1</source>
        <translation type="unfinished">PostScript Level 1</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="390"/>
        <source>PostScript Level 2</source>
        <translation type="unfinished">PostScript Level 2</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="392"/>
        <source>PostScript Level 3</source>
        <translation type="unfinished">PostScript Level 3</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="394"/>
        <source>Windows GDI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="273"/>
        <source>Render Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="325"/>
        <source>Default Paragraph Style</source>
        <translation type="unfinished">Подразумевани стил параграфа</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="326"/>
        <source>Default Character Style</source>
        <translation type="unfinished">Подразумевани стил знака</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="327"/>
        <source>Default Line Style</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ContextMenu</name>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="210"/>
        <source>Preview Settings</source>
        <translation type="unfinished">Подешења прегледа</translation>
    </message>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="421"/>
        <source>Paste File...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="454"/>
        <source>Delete Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="182"/>
        <source>Paste Image from Clipboard</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CopyPageToMasterPageBase</name>
    <message>
        <location filename="../../scribus/ui/copypagetomasterpage.ui" line="16"/>
        <source>Convert Page to Master Page</source>
        <translation type="unfinished">Преведи страну у главну страну</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/copypagetomasterpage.ui" line="24"/>
        <source>Name:</source>
        <translation type="unfinished">Име:</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/copypagetomasterpage.ui" line="39"/>
        <source>Copy Applied Master Page Items</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CopyPageToMasterPageDialog</name>
    <message>
        <location filename="../../scribus/ui/copypagetomasterpagedialog.cpp" line="18"/>
        <source>New Master Page %1</source>
        <translation type="unfinished">Нова главна страна %1</translation>
    </message>
</context>
<context>
    <name>Cpalette</name>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1001"/>
        <source>Shade:</source>
        <translation>Сенка:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="985"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1002"/>
        <source>Opacity:</source>
        <translation>Непрозирност:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1020"/>
        <source>Normal</source>
        <translation>Нормално</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1008"/>
        <source>Horizontal Gradient</source>
        <translation>Водоравни ферлауф</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1009"/>
        <source>Vertical Gradient</source>
        <translation>Усправни ферлауф</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1010"/>
        <source>Diagonal Gradient</source>
        <translation>Дијагонални ферлауф</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1011"/>
        <source>Cross Diagonal Gradient</source>
        <translation>Укрштени дијагонални ферлауф</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1012"/>
        <source>Radial Gradient</source>
        <translation>Кружни ферлауф</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1013"/>
        <source>Free linear Gradient</source>
        <translation>Слободни линијски ферлауф</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1014"/>
        <source>Free radial Gradient</source>
        <translation>Слободни кружни ферлауф</translation>
    </message>
    <message>
        <location filename="../cpalette.cpp" line="922"/>
        <source>X1:</source>
        <translation type="obsolete">X1:</translation>
    </message>
    <message>
        <location filename="../cpalette.cpp" line="923"/>
        <source>Y1:</source>
        <translation type="obsolete">Y1:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="984"/>
        <source> pt</source>
        <translation> тач.</translation>
    </message>
    <message>
        <location filename="../cpalette.cpp" line="924"/>
        <source>X2:</source>
        <translation type="obsolete">X2:</translation>
    </message>
    <message>
        <location filename="../cpalette.cpp" line="925"/>
        <source>Y2:</source>
        <translation type="obsolete">Y2:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1038"/>
        <source>Edit Line Color Properties</source>
        <translation>Уреди поставке линије са бојама</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1039"/>
        <source>Edit Fill Color Properties</source>
        <translation>Уреди поставке попуњености бојама</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1040"/>
        <source>Saturation of color</source>
        <translation>Засићење боје</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1041"/>
        <source>Normal or gradient fill method</source>
        <translation>Нормални или прелазни метод попуњавања</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1042"/>
        <source>Set the transparency for the color selected</source>
        <translation>Постави прозирност за изабрану боју</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1003"/>
        <source>Move Vector</source>
        <translation>Помери правац</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1043"/>
        <source>Move the start of the gradient vector with the left mouse button pressed and move the end of the gradient vector with the right mouse button pressed</source>
        <translation>Помери почетну тачку правца ферлауфа притиснутим левим тастером миша и помери крајњу тачку ферлауфа користећи десни тастер миша</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1017"/>
        <source>Transparency Settings</source>
        <translation>Подешавања провидности</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1018"/>
        <source>Blend Mode:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1021"/>
        <source>Darken</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1022"/>
        <source>Lighten</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1023"/>
        <source>Multiply</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1024"/>
        <source>Screen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1025"/>
        <source>Overlay</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1026"/>
        <source>Hard Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1027"/>
        <source>Soft Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1028"/>
        <source>Difference</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1030"/>
        <source>Color Dodge</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1031"/>
        <source>Color Burn</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1032"/>
        <source>Hue</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1033"/>
        <source>Saturation</source>
        <translation type="unfinished">Засићење</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1034"/>
        <source>Color</source>
        <translation type="unfinished">Боја</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1035"/>
        <source>Luminosity</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="988"/>
        <source>Offsets</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="989"/>
        <source>X:</source>
        <translation type="unfinished">X:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="991"/>
        <source>Y:</source>
        <translation type="unfinished">Y:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="993"/>
        <source>Scaling</source>
        <translation>Скалирање</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="998"/>
        <source>Rotation</source>
        <translation>Окретање</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="999"/>
        <source>Angle</source>
        <translation>Угао</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1015"/>
        <source>Pattern</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1029"/>
        <source>Exclusion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="994"/>
        <source>X-Scale:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="996"/>
        <source>Y-Scale:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1036"/>
        <source>Display only used Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1044"/>
        <source>Display all colors from the document color list, or only the already used colors</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CreateRange</name>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="13"/>
        <source>Create Range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="54"/>
        <source>Number of Pages in Document:</source>
        <translation type="unfinished">Број страна у документу:</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="64"/>
        <source>Doc Page Range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="112"/>
        <source>Basic Range Selection</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="136"/>
        <source>Range of Pages</source>
        <translation type="unfinished">Опсег страна</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="160"/>
        <source>De&amp;lete</source>
        <translation type="unfinished">&amp;Обриши</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="163"/>
        <source>Alt+L</source>
        <translation type="unfinished">Alt+L</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="186"/>
        <source>Move &amp;Down</source>
        <translation type="unfinished">Помери &amp;доле</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="189"/>
        <source>Alt+D</source>
        <translation type="unfinished">Alt+D</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="196"/>
        <source>Move &amp;Up</source>
        <translation type="unfinished">Помери &amp;Горе</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="199"/>
        <source>Alt+U</source>
        <translation type="unfinished">Alt+U</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="218"/>
        <source>Add a Range of Pages</source>
        <translation type="unfinished">Додај опсег страна</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="242"/>
        <source>Consecutive Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="252"/>
        <source>Even Pages</source>
        <translation type="unfinished">Парне стане </translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="259"/>
        <source>From:</source>
        <translation type="unfinished">Од:</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="291"/>
        <source>To:</source>
        <translation type="unfinished">До:</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="334"/>
        <source>&amp;Add To Range</source>
        <translation type="unfinished">&amp;Додај опсегу</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="337"/>
        <source>Alt+A</source>
        <translation type="unfinished">Alt+A</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="362"/>
        <source>Odd Pages</source>
        <translation type="unfinished">Непарне стране</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="372"/>
        <source>Comma Separated List</source>
        <translation type="unfinished">Листа страна одвојена зарезом</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="383"/>
        <source>Advanced Reordering</source>
        <translation type="unfinished">Напредна реорганизација</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="439"/>
        <source>Page Order</source>
        <translation type="unfinished">Редослед страна</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="449"/>
        <source>Sample Page Order:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="478"/>
        <source>Page Group Size:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="525"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;У реду</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="528"/>
        <source>Alt+O</source>
        <translation type="unfinished">Alt+O</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="535"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Откажи</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="538"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
</context>
<context>
    <name>CreateRangeBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Number of Pages in Document:</source>
        <translation type="obsolete">Број страна у документу:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Add a Range of Pages</source>
        <translation type="obsolete">Додај опсег страна</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>From:</source>
        <translation type="obsolete">Од:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>To:</source>
        <translation type="obsolete">До:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Comma Separated List</source>
        <translation type="obsolete">Листа страна одвојена зарезом</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Even Pages</source>
        <translation type="obsolete">Парне стане </translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Odd Pages</source>
        <translation type="obsolete">Непарне стране</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Add To Range</source>
        <translation type="obsolete">&amp;Додај опсегу</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Range of Pages</source>
        <translation type="obsolete">Опсег страна</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Move &amp;Up</source>
        <translation type="obsolete">Помери &amp;Горе</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+U</source>
        <translation type="obsolete">Alt+U</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Move &amp;Down</source>
        <translation type="obsolete">Помери &amp;доле</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+D</source>
        <translation type="obsolete">Alt+D</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>De&amp;lete</source>
        <translation type="obsolete">&amp;Обриши</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+L</source>
        <translation type="obsolete">Alt+L</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Advanced Reordering</source>
        <translation type="obsolete">Напредна реорганизација</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Page Order</source>
        <translation type="obsolete">Редослед страна</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;У реду</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+O</source>
        <translation type="obsolete">Alt+O</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Откажи</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
</context>
<context>
    <name>CsvDialog</name>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="27"/>
        <source>CSV Importer Options</source>
        <translation>Опције CSV увозника</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="37"/>
        <source>Field delimiter:</source>
        <translation>Границе поља:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="89"/>
        <source>(TAB)</source>
        <translation>(TAB)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="53"/>
        <source>Value delimiter:</source>
        <translation>Граничне вредности:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="68"/>
        <source>First row is a header</source>
        <translation>Први ред је заглавље</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="76"/>
        <source>OK</source>
        <translation>У реду</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="79"/>
        <source>Cancel</source>
        <translation>Поништи</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <comment>



delimiter</comment>
        <translation type="obsolete">Ниједан</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="59"/>
        <source>None</source>
        <comment>delimiter</comment>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CupsOptions</name>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="52"/>
        <source>Printer Options</source>
        <translation>Опције штампача</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="143"/>
        <source>Page Set</source>
        <translation>Поставка странице</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="147"/>
        <source>All Pages</source>
        <translation>Све странице</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="141"/>
        <source>Even Pages only</source>
        <translation>Само парне странице</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="142"/>
        <source>Odd Pages only</source>
        <translation>Само непарне странице</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="160"/>
        <source>Mirror</source>
        <translation>Огледало</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="177"/>
        <source>Orientation</source>
        <translation>Усмерење</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="181"/>
        <source>Portrait</source>
        <translation>Усправно</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="175"/>
        <source>Landscape</source>
        <translation>Водоравно</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="197"/>
        <source>N-Up Printing</source>
        <translation>N-Горе штампање</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="201"/>
        <source>Page per Sheet</source>
        <translation>Једна страница по листу</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="196"/>
        <source>Pages per Sheet</source>
        <translation>Број страница на листу</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="63"/>
        <source>Option</source>
        <translation>Опција</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="64"/>
        <source>Value</source>
        <translation>Вредност</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="224"/>
        <source>This panel displays various CUPS options when printing. The exact parameters available will depend on your printer driver. You can confirm CUPS support by selecting Help &gt; About. Look for the listings: C-C-T These equate to C=CUPS C=littlecms T=TIFF support. Missing library support is indicated by a *</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CurveWidget</name>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="414"/>
        <source>Open</source>
        <translation type="unfinished">Отвори</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="449"/>
        <source>Curve Files (*.scu);;All Files (*)</source>
        <translation>Фајл који садржи криве (*.scu);;Сви фајлови (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="449"/>
        <source>Save as</source>
        <translation type="unfinished">Сними као</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="483"/>
        <source>Cannot write the file: 
%1</source>
        <translation>Не могу да запишем фалј: 
%1</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="509"/>
        <source>Inverts the curve</source>
        <translation>Преокреће криву уназад</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="510"/>
        <source>Resets the curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="511"/>
        <source>Switches between linear and cubic interpolation of the curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="512"/>
        <source>Loads a curve</source>
        <translation>Учитава криву</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="513"/>
        <source>Saves this curve</source>
        <translation>Снима ову криву</translation>
    </message>
</context>
<context>
    <name>CustomFDialog</name>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="327"/>
        <source>&amp;Compress File</source>
        <translation>&amp;Компресуј фајл</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="306"/>
        <source>&amp;Include Fonts</source>
        <translation>&amp;Укључи фонтове</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="355"/>
        <source>Encoding:</source>
        <translation>Кодирање:</translation>
    </message>
    <message>
        <location filename="../customfdialog.cpp" line="366"/>
        <source>Moves to your Document Directory.
This can be set in the Preferences.</source>
        <translation type="obsolete">Премешта у Ваш директоријум за документе.
Ово се може наместити у поставкама.</translation>
    </message>
    <message>
        <location filename="../customfdialog.cpp" line="314"/>
        <source>&amp;Include ICC Profiles</source>
        <translation type="obsolete">&amp;Укључи ICC профиле</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="274"/>
        <source>Show Preview</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="308"/>
        <source>&amp;Include Color Profiles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="275"/>
        <source>Show a preview and information for the selected file</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="342"/>
        <source>Compress the Scribus document on save</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="344"/>
        <source>Include fonts when collecting files for the document. Be sure to know and understand licensing information for any fonts you collect and possibly redistribute.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="346"/>
        <source>Include color profiles when collecting files for the document</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DashEditor</name>
    <message>
        <location filename="../../scribus/dasheditor.cpp" line="363"/>
        <source>Value:</source>
        <translation type="unfinished">Вредност:</translation>
    </message>
    <message>
        <location filename="../../scribus/dasheditor.cpp" line="364"/>
        <source>Offset:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DeferredTask</name>
    <message>
        <location filename="../../scribus/deferredtask.cpp" line="82"/>
        <source>Cancelled by user</source>
        <translation>Обустављено од стране корисника</translation>
    </message>
</context>
<context>
    <name>DelColor</name>
    <message>
        <location filename="../../scribus/dcolor.cpp" line="28"/>
        <source>Delete Color</source>
        <translation>Обриши боју</translation>
    </message>
    <message>
        <location filename="../../scribus/dcolor.cpp" line="36"/>
        <source>Delete Color:</source>
        <translation>Обриши боју: </translation>
    </message>
    <message>
        <location filename="../../scribus/dcolor.cpp" line="45"/>
        <source>Replace With:</source>
        <translation>Замени са: </translation>
    </message>
</context>
<context>
    <name>DelPages</name>
    <message>
        <location filename="../../scribus/delpages.cpp" line="17"/>
        <source>Delete Pages</source>
        <translation>Обриши странице</translation>
    </message>
    <message>
        <location filename="../../scribus/delpages.cpp" line="34"/>
        <source>to:</source>
        <translation>у:</translation>
    </message>
    <message>
        <location filename="../../scribus/delpages.cpp" line="26"/>
        <source>Delete From:</source>
        <translation>Обриши од:</translation>
    </message>
</context>
<context>
    <name>DelStyle</name>
    <message>
        <location filename="../editformats.cpp" line="36"/>
        <source>Delete Style</source>
        <translation type="obsolete">Обриши стил</translation>
    </message>
    <message>
        <location filename="../editformats.cpp" line="42"/>
        <source>Delete Style:</source>
        <translation type="obsolete">Обриши стил:</translation>
    </message>
    <message>
        <location filename="../editformats.cpp" line="46"/>
        <source>Replace With:</source>
        <translation type="obsolete">Замени са: </translation>
    </message>
    <message>
        <location filename="../editformats.cpp" line="49"/>
        <source>No Style</source>
        <translation type="obsolete">Нема стила</translation>
    </message>
</context>
<context>
    <name>DocIm</name>
    <message>
        <location filename="../../scribus/plugins/gettext/docim/docim.cpp" line="160"/>
        <source>Importing failed</source>
        <translation>Ивожење није успело</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/docim/docim.cpp" line="161"/>
        <source>Importing Word document failed 
%1</source>
        <translation>Увожење Word документа није успело 
%1</translation>
    </message>
</context>
<context>
    <name>DocInfos</name>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="30"/>
        <source>Document Information</source>
        <translation>Информације о документу</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="39"/>
        <source>&amp;Title:</source>
        <translation>&amp;Наслов:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="46"/>
        <source>&amp;Author:</source>
        <translation>&amp;Аутор:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="53"/>
        <source>&amp;Keywords:</source>
        <translation>&amp;Кључне речи:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="61"/>
        <source>Descri&amp;ption:</source>
        <translation>Оп&amp;ис:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="74"/>
        <source>P&amp;ublisher:</source>
        <translation>И&amp;здавач:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="81"/>
        <source>&amp;Contributors:</source>
        <translation>&amp;Помагачи:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="89"/>
        <source>Dat&amp;e:</source>
        <translation>&amp;Датум:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="96"/>
        <source>T&amp;ype:</source>
        <translation>В&amp;рста:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="103"/>
        <source>F&amp;ormat:</source>
        <translation>Ф&amp;ормат:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="110"/>
        <source>Identi&amp;fier:</source>
        <translation>Означ&amp;ивач:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="117"/>
        <source>&amp;Source:</source>
        <translation>&amp;Извор:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="124"/>
        <source>&amp;Language:</source>
        <translation>&amp;Језик:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="131"/>
        <source>&amp;Relation:</source>
        <translation>&amp;Однос:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="138"/>
        <source>Co&amp;verage:</source>
        <translation>Покр&amp;ивеност:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="145"/>
        <source>Ri&amp;ghts:</source>
        <translation>Пр&amp;ава:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="153"/>
        <source>Further &amp;Information</source>
        <translation>Додатне &amp;информације</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="163"/>
        <source>A person or organisation responsible for making the document available</source>
        <translation>Особа или организација одговорни за издавање документа</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="164"/>
        <source>A person or organisation responsible for making contributions to the content of the document</source>
        <translation>Особа или организација одговорни за допринос садржају документа</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="165"/>
        <source>A date associated with an event in the life cycle of the document, in YYYY-MM-DD format, as per ISO 8601</source>
        <translation>Датум повезан са неким догађајем у животном циклусу документа, у ГГГГ-ММ-ДД формату, као по ISO 8601</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="166"/>
        <source>The nature or genre of the content of the document, eg. categories, functions, genres, etc</source>
        <translation>Природа или жанр садржаја документа, нпр. категорије, функције, жанрови, итд.</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="168"/>
        <source>An unambiguous reference to the document within a given context such as ISBN or URI</source>
        <translation>Прецизна референца на документ у оквиру датог контекста као што је ISBN 
или URI</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="169"/>
        <source>A reference to a document from which the present document is derived, eg. ISBN or URI</source>
        <translation>Референца на документ из кога је тренутни документ изведен, нпр. 
ISBN или URI</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="171"/>
        <source>A reference to a related document, possibly using a formal identifier such as a ISBN or URI</source>
        <translation>Референца на повезани документ, вероватно коришћењем формалног идентификатора као што је ISBN или URI</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="172"/>
        <source>The extent or scope of the content of the document, possibly including location, time and jurisdiction ranges</source>
        <translation>Степен или делокруг садржаја документа, вероватно укључујући место, време и опсеге надлежности</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="173"/>
        <source>Information about rights held in and over the document, eg. copyright, patent or trademark</source>
        <translation>Информације о правима у и над документом, нпр. copyright, патент или бренд</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="152"/>
        <source>Documen&amp;t</source>
        <translation>Докумен&amp;т</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="159"/>
        <source>The person or organisation primarily responsible for making the content of the document. This field can be embedded in the Scribus document for reference, as well as in the metadata of a PDF</source>
        <translation>Особа или организација првенствено одговорна за настанак овог документа. Ово поље може бити укључено у Скрибусов документ, као и у мета-податке PDF-а</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="160"/>
        <source>A name given to the document. This field can be embedded in the Scribus document for reference, as well as in the metadata of a PDF</source>
        <translation>Име дато документу. Ово поље може бити укључено у Скрибусов документ, као и у мета-податке PDF-а</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="161"/>
        <source>An account of the content of the document. This field is for a brief description or abstract of the document. It is embedded in the PDF on export</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="162"/>
        <source>The topic of the content of the document. This field is for document keywords you wish to embed in a PDF, to assist searches and indexing of PDF files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="167"/>
        <source>The physical or digital manifestation of the document. Media type and dimensions would be worth noting. RFC2045,RFC2046 for MIME types are also useful here</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="170"/>
        <source>The language in which the content of the document is written, usually a ISO-639 language code optionally suffixed with a hypen and an ISO-3166 country code, eg. en-GB, fr-CH</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DocSections</name>
    <message>
        <location filename="../../scribus/docsections.cpp" line="72"/>
        <source>Add a page numbering section to the document. The new section will be added after the currently selected section.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="73"/>
        <source>Delete the currently selected section.</source>
        <translation>Обриши тренутно изабран одељак.</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>1, 2, 3, ...</source>
        <translation>1, 2, 3, ...</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>i, ii, iii, ...</source>
        <translation>i, ii, iii, ...</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>I, II, III, ...</source>
        <translation>I, II, III, ...</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>a, b, c, ...</source>
        <translation>a, b, c, ...</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>A, B, C, ...</source>
        <translation>A, B, C, ...</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="79"/>
        <source>&lt;b&gt;Name:&lt;/b&gt; Optional name for section eg. Index&lt;br/&gt;&lt;b&gt;Shown:&lt;/b&gt; Select to show the page numbers in this section if there is one or more text frames setup to do so.&lt;br/&gt;&lt;b&gt;From:&lt;/b&gt; The page index for this section to start at.&lt;br/&gt;&lt;b&gt;To:&lt;/b&gt; The page index for this section to stop at.&lt;br/&gt;&lt;b&gt;Style:&lt;/b&gt; Select the page number style to be used.&lt;br/&gt;&lt;b&gt;Start:&lt;/b&gt; The index within the Style&apos;s range to star at. Eg. If Start=2 and Style=a,b,c, ..., the numbers will begin at b. For the first section in the document this replaces the older First Page Number in the new file window.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="201"/>
        <source>Page Number Out Of Bounds</source>
        <translation>Број стране је изван опсега</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="201"/>
        <source>The value you have entered is outside the range of page numbers in the current document (%1-%2).</source>
        <translation>Унешена вредност је изван опсега броја страна овог документа (%1-%2).</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="13"/>
        <source>Document Sections</source>
        <translation type="unfinished">Одељци у документу</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="83"/>
        <source>&amp;Add</source>
        <translation type="unfinished">&amp;Додај</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="86"/>
        <source>Alt+A</source>
        <translation type="unfinished">Alt+A</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="93"/>
        <source>&amp;Delete</source>
        <translation type="unfinished">&amp;Обриши</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="96"/>
        <source>Alt+D</source>
        <translation type="unfinished">Alt+D</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="32"/>
        <source>Name</source>
        <translation type="unfinished">Име</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="37"/>
        <source>Shown</source>
        <translation type="unfinished">Приказан</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="42"/>
        <source>From</source>
        <translation type="unfinished">Од</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="47"/>
        <source>To</source>
        <translation type="unfinished">Ка</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="52"/>
        <source>Style</source>
        <translation type="unfinished">Стил</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="57"/>
        <source>Start</source>
        <translation type="unfinished">Почетак</translation>
    </message>
</context>
<context>
    <name>DocSectionsBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Document Sections</source>
        <translation type="obsolete">Одељци у документу</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Name</source>
        <translation type="obsolete">Име</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>From</source>
        <translation type="obsolete">Од</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>To</source>
        <translation type="obsolete">Ка</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Style</source>
        <translation type="obsolete">Стил</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Start</source>
        <translation type="obsolete">Почетак</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Add</source>
        <translation type="obsolete">&amp;Додај</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Delete</source>
        <translation type="obsolete">&amp;Обриши</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+D</source>
        <translation type="obsolete">Alt+D</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Shown</source>
        <translation type="obsolete">Приказан</translation>
    </message>
</context>
<context>
    <name>DocumentItemAttributes</name>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>Relates To</source>
        <translation>Односи се према</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>Is Parent Of</source>
        <translation>је предак</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>Is Child Of</source>
        <translation>је наследник</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="19"/>
        <source>Text Frames</source>
        <translation>Текстуални оквири</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="19"/>
        <source>Image Frames</source>
        <translation>Оквири слика</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>Boolean</source>
        <translation>Логичка вредност</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>Integer</source>
        <translation>Целобројна вредност</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>String</source>
        <translation>Низ знакова</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <comment>



relationship</comment>
        <translation type="obsolete">Ниједан</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <comment>



auto add</comment>
        <translation type="obsolete">Ниједан</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <comment>



types</comment>
        <translation type="obsolete">Ниједан</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>Real Number</source>
        <translation>Реалан број</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>None</source>
        <comment>relationship</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="19"/>
        <source>None</source>
        <comment>auto add</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>None</source>
        <comment>types</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="13"/>
        <source>Document Item Attributes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="82"/>
        <source>&amp;Add</source>
        <translation type="unfinished">&amp;Додај</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="85"/>
        <source>Alt+A</source>
        <translation type="unfinished">Alt+A</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="92"/>
        <source>&amp;Copy</source>
        <translation type="unfinished">&amp;Копирај</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="95"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="102"/>
        <source>&amp;Delete</source>
        <translation type="unfinished">&amp;Обриши</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="105"/>
        <source>Alt+D</source>
        <translation type="unfinished">Alt+D</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="112"/>
        <source>C&amp;lear</source>
        <translation type="unfinished">Оч&amp;исти</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="115"/>
        <source>Alt+L</source>
        <translation type="unfinished">Alt+L</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="26"/>
        <source>Name</source>
        <translation type="unfinished">Име</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="31"/>
        <source>Type</source>
        <translation type="unfinished">Врста</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="36"/>
        <source>Value</source>
        <translation type="unfinished">Вредност</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="41"/>
        <source>Parameter</source>
        <translation type="unfinished">Парамета</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="46"/>
        <source>Relationship</source>
        <translation type="unfinished">Однос</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="51"/>
        <source>Relationship To</source>
        <translation type="unfinished">Однос према</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="56"/>
        <source>Auto Add To</source>
        <translation type="unfinished">Сам додај</translation>
    </message>
</context>
<context>
    <name>DocumentItemAttributesBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Name</source>
        <translation type="obsolete">Име</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Type</source>
        <translation type="obsolete">Врста</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Value</source>
        <translation type="obsolete">Вредност</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Parameter</source>
        <translation type="obsolete">Парамета</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Relationship</source>
        <translation type="obsolete">Однос</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Relationship To</source>
        <translation type="obsolete">Однос према</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Auto Add To</source>
        <translation type="obsolete">Сам додај</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Add</source>
        <translation type="obsolete">&amp;Додај</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Copy</source>
        <translation type="obsolete">&amp;Копирај</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Delete</source>
        <translation type="obsolete">&amp;Обриши</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+D</source>
        <translation type="obsolete">Alt+D</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>C&amp;lear</source>
        <translation type="obsolete">Оч&amp;исти</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+L</source>
        <translation type="obsolete">Alt+L</translation>
    </message>
</context>
<context>
    <name>EPSPlug</name>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="478"/>
        <source>Importing File:
%1
failed!</source>
        <translation>Увожење фајла: 
%1 
није успело!</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="479"/>
        <source>Fatal Error</source>
        <translation>Кобна грешка</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="877"/>
        <source>Error</source>
        <translation type="unfinished">Грешка</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="85"/>
        <source>Analyzing PostScript:</source>
        <translation>Пост скрипт анализа:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="484"/>
        <source>Generating Items</source>
        <translation>Правим ставке</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="876"/>
        <source>Converting of %1 images failed!</source>
        <translation>Конверзија %1 слика није успела!</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="743"/>
        <source>Group%1</source>
        <translation>Група%1</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="82"/>
        <source>Importing: %1</source>
        <translation>Увожење: %1</translation>
    </message>
</context>
<context>
    <name>EditStyle</name>
    <message>
        <location filename="../edit1format.cpp" line="47"/>
        <source>Edit Style</source>
        <translation type="obsolete">Уреди стил</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="67"/>
        <source>&amp;Name:</source>
        <translation type="obsolete">&amp;Име:</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="80"/>
        <source>Character</source>
        <translation type="obsolete">Знак</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="272"/>
        <source> pt</source>
        <translation type="obsolete"> тач.</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="268"/>
        <source>&amp;Lines:</source>
        <translation type="obsolete">&amp;Линије:</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="300"/>
        <source>Tabulators and Indentation</source>
        <translation type="obsolete">Табулатори и увлачење</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="360"/>
        <source>Name of your paragraph style</source>
        <translation type="obsolete">Име Вашег стила пасуса</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="361"/>
        <source>Font of selected text or object</source>
        <translation type="obsolete">Фонт изабраног текста или објекта</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="362"/>
        <source>Font Size</source>
        <translation type="obsolete">Величина фонта</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="363"/>
        <source>Color of text fill</source>
        <translation type="obsolete">Боја попуњеног текста</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="364"/>
        <source>Color of text stroke</source>
        <translation type="obsolete">Боја текста</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="366"/>
        <source>Determines the overall height, in line numbers, of the Drop Caps</source>
        <translation type="obsolete">Утврђује свеукупну висину, бројеве у низу, испуштених великих слова</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="369"/>
        <source>Spacing above the paragraph</source>
        <translation type="obsolete">Проред изнад пасуса</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="370"/>
        <source>Spacing below the paragraph</source>
        <translation type="obsolete">Проред испод пасуса</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="373"/>
        <source>Line Spacing</source>
        <translation type="obsolete">Проред</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="239"/>
        <source> %</source>
        <translation type="obsolete"> %</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="200"/>
        <source>Distances</source>
        <translation type="obsolete">Удаљеност</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="274"/>
        <source>Distance from Text:</source>
        <translation type="obsolete">Удаљеност од текста:</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="324"/>
        <source>Preview of the Paragraph Style</source>
        <translation type="obsolete">Приказ стила параграфа</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="508"/>
        <source>Name of the style is not unique</source>
        <translation type="obsolete">Име овог стила није јединствено</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="328"/>
        <source>Background</source>
        <translation type="obsolete">Позадина</translation>
    </message>
</context>
<context>
    <name>EditToolBar</name>
    <message>
        <location filename="../../scribus/ui/edittoolbar.cpp" line="29"/>
        <source>Edit</source>
        <translation type="unfinished">Уреди</translation>
    </message>
</context>
<context>
    <name>Editor</name>
    <message>
        <location filename="../../scribus/editor.cpp" line="30"/>
        <source>Editor</source>
        <translation>Уређивач</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="36"/>
        <source>&amp;New</source>
        <translation>&amp;Нови</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="39"/>
        <source>&amp;Open...</source>
        <translation>&amp;Отвори...</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="41"/>
        <source>Save &amp;As...</source>
        <translation>Сними &amp;као...</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="43"/>
        <source>&amp;Save and Exit</source>
        <translation>&amp;Сними и изађи</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="45"/>
        <source>&amp;Exit without Saving</source>
        <translation>&amp;Изађи без снимања</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="47"/>
        <source>&amp;Undo</source>
        <translation>&amp;Опозови</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="50"/>
        <source>&amp;Redo</source>
        <translation>Поно&amp;ви</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="52"/>
        <source>Cu&amp;t</source>
        <translation>&amp;Исеци</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="55"/>
        <source>&amp;Copy</source>
        <translation>&amp;Копирај</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="58"/>
        <source>&amp;Paste</source>
        <translation>&amp;Пренеси</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="61"/>
        <source>C&amp;lear</source>
        <translation>Оч&amp;исти</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="63"/>
        <source>&amp;Get Field Names</source>
        <translation>&amp;Добави имена поља</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="65"/>
        <source>&amp;File</source>
        <translation>&amp;Фајл</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="72"/>
        <source>&amp;Edit</source>
        <translation>&amp;Уреди</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="127"/>
        <source>JavaScripts (*.js);;All Files (*)</source>
        <translation>Јава Скрипт (*.js);;Сви фајлови (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="37"/>
        <source>Ctrl+N</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="48"/>
        <source>Ctrl+Z</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="53"/>
        <source>Ctrl+X</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="56"/>
        <source>Ctrl+C</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="59"/>
        <source>Ctrl-V</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>EffectsDialog</name>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="44"/>
        <source>Image Effects</source>
        <translation>Ефекти на слици</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="81"/>
        <source>Options:</source>
        <translation>Опције:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="98"/>
        <source>Color:</source>
        <translation type="unfinished">Боја:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="109"/>
        <source>Shade:</source>
        <translation type="unfinished">Сенка:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="125"/>
        <source>Brightness:</source>
        <translation>Осветљеност:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="147"/>
        <source>Contrast:</source>
        <translation>Контраст:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="198"/>
        <source>Radius:</source>
        <translation>Пречник:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="180"/>
        <source>Value:</source>
        <translation>Вредност:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="216"/>
        <source>Posterize:</source>
        <translation>Постеризација:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="500"/>
        <source>Available Effects</source>
        <translation>Доступни ефекти</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1393"/>
        <source>Blur</source>
        <translation>Замућење</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1371"/>
        <source>Brightness</source>
        <translation>Осветљеност</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1362"/>
        <source>Colorize</source>
        <translation>Колоризација</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1377"/>
        <source>Contrast</source>
        <translation>Контраст</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="981"/>
        <source>Grayscale</source>
        <translation>Нијансе сиве</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="983"/>
        <source>Invert</source>
        <translation type="unfinished">Инвертуј</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1406"/>
        <source>Posterize</source>
        <translation>Постеризација</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1383"/>
        <source>Sharpen</source>
        <translation>Изоштравање</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="482"/>
        <source>&gt;&gt;</source>
        <translation>&gt;&gt;</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="486"/>
        <source>&lt;&lt;</source>
        <translation>&lt;&lt;</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="497"/>
        <source>Effects in use</source>
        <translation>Ефекти у употреби</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="616"/>
        <source>OK</source>
        <translation type="unfinished">У реду</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="620"/>
        <source>Cancel</source>
        <translation type="unfinished">Поништи</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="351"/>
        <source>Color 1:</source>
        <translation>Боја 1:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="371"/>
        <source>Color 2:</source>
        <translation>Боја 2:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="391"/>
        <source>Color 3:</source>
        <translation>Боја 3:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="411"/>
        <source>Color 4:</source>
        <translation>Боја 4:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1412"/>
        <source>Duotone</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1448"/>
        <source>Tritone</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1499"/>
        <source>Quadtone</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1565"/>
        <source>Curves</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ExportBitmap</name>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="204"/>
        <source>File exists. Overwrite?</source>
        <translation type="unfinished">Фајл постоји. Да пребришем?</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="205"/>
        <source>exists already. Overwrite?</source>
        <translation type="unfinished">већ постоји Да пребришем?</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>All</source>
        <translation type="obsolete">Све</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="218"/>
        <source>Save as Image</source>
        <translation type="unfinished">Сними као слику</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="192"/>
        <source>Insufficient memory for this image size.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="219"/>
        <source>Error writing the output file(s).</source>
        <translation type="unfinished">Грешка при писању излазног фајла(ова).</translation>
    </message>
</context>
<context>
    <name>ExportForm</name>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="80"/>
        <source>Choose a Export Directory</source>
        <translation>Изаберите директоријум за извоз</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="13"/>
        <source>Export as Image(s)</source>
        <translation>Извези као слику(е)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="153"/>
        <source>&amp;Export to Directory:</source>
        <translation>&amp;Извези у директоријум:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="166"/>
        <source>C&amp;hange...</source>
        <translation>И&amp;змени...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="25"/>
        <source>Options</source>
        <translation>Опције</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="54"/>
        <source>Image &amp;Type:</source>
        <translation>&amp;Врста слике:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="64"/>
        <source>&amp;Quality:</source>
        <translation>&amp;Квалитет:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="74"/>
        <source>&amp;Resolution:</source>
        <translation>&amp;Резолуција:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="126"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="110"/>
        <source> dpi</source>
        <translation> тпи</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="175"/>
        <source>Range</source>
        <translation>Опсег</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="197"/>
        <source>&amp;Current page</source>
        <translation>&amp;Текућа страница</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="224"/>
        <source>&amp;All pages</source>
        <translation>&amp;Све странице</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="217"/>
        <source>&amp;Range</source>
        <translation>&amp;Опсег</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>C</source>
        <translation type="obsolete">C</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="117"/>
        <source>Export a range of pages</source>
        <translation>Извези опсег страница</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="118"/>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation>Унесите листу обележја раздвојених зарезима где
обележје може бити * за све странице, 1-5 за
опсег страница или број једне странице.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="119"/>
        <source>Export all pages</source>
        <translation>Извези све странице</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="120"/>
        <source>Export only the current page</source>
        <translation>Извези само текућу страницу</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="121"/>
        <source>Resolution of the Images
Use 72 dpi for Images intended for the Screen</source>
        <translation>Резолуција слика
Користи 72 тпи за слике предвиђене за приказивање на екрану</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="114"/>
        <source>The quality of your images - 100% is the best, 1% the lowest quality</source>
        <translation type="obsolete">Квалитет Ваших слика - 100\\% је најбољи, 1\\% је најлошији</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="125"/>
        <source>Available export formats</source>
        <translation>Доступни формати за извоз</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="126"/>
        <source>The output directory - the place to store your images.
Name of the export file will be &apos;documentname-pagenumber.filetype&apos;</source>
        <translation>Излазни директоријум - место за смештање Ваших слика.
Име извезеног фајла ће бити „имедокумента-бројстране.врстафајла“</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="127"/>
        <source>Change the output directory</source>
        <translation>Промени излазни директоријум</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="84"/>
        <source>&amp;Size:</source>
        <translation type="unfinished">&amp;Величина:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="122"/>
        <source>Size of the images. 100% for no changes, 200% for two times larger etc.</source>
        <translation>Величина слике. 100% за непромењену величину, 200% за два пута већу слику итд.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="44"/>
        <source>Image size in Pixels</source>
        <translation>Величина слике у пикселима</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="37"/>
        <source>TextLabel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="123"/>
        <source>The compression ratio of your images - 100% is no compression, 0% highest compression. If in doubt, use &apos;Automatic&apos;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="124"/>
        <source>Automatic</source>
        <translation type="unfinished">Аутоматски</translation>
    </message>
</context>
<context>
    <name>ExtImageProps</name>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="39"/>
        <source>Extended Image Properties</source>
        <translation type="unfinished">Додатна својства слике</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="102"/>
        <source>Normal</source>
        <translation type="unfinished">Нормално</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="103"/>
        <source>Darken</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="104"/>
        <source>Lighten</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="105"/>
        <source>Hue</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="106"/>
        <source>Saturation</source>
        <translation type="unfinished">Засићење</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="107"/>
        <source>Color</source>
        <translation type="unfinished">Боја</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="108"/>
        <source>Luminosity</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="109"/>
        <source>Multiply</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="110"/>
        <source>Screen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="111"/>
        <source>Dissolve</source>
        <translation type="unfinished">Растварање</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="112"/>
        <source>Overlay</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="113"/>
        <source>Hard Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="114"/>
        <source>Soft Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="115"/>
        <source>Difference</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="116"/>
        <source>Exclusion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="117"/>
        <source>Color Dodge</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="118"/>
        <source>Color Burn</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="98"/>
        <source>Blend Mode:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="121"/>
        <source>Opacity:</source>
        <translation type="unfinished">Непрозирност:</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="127"/>
        <source> %</source>
        <translation type="unfinished"> %</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="133"/>
        <source>Name</source>
        <translation type="unfinished">Име</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="214"/>
        <source>Layers</source>
        <translation type="unfinished">Слојеви</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="267"/>
        <source>Don&apos;t use any Path</source>
        <translation>Не користи ниједну путању</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="269"/>
        <source>Paths</source>
        <translation type="unfinished">Путање</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="276"/>
        <source>Live Preview</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FDialogPreview</name>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="198"/>
        <source>Size:</source>
        <translation>Величина:</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="216"/>
        <source>Title:</source>
        <translation>Наслов:</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="219"/>
        <source>No Title</source>
        <translation>Без наслова</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="221"/>
        <source>Author:</source>
        <translation>Аутор:</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="229"/>
        <source>Unknown</source>
        <translation>Непознат</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="231"/>
        <source>Scribus Document</source>
        <translation>Scribus документ</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="199"/>
        <source>Resolution:</source>
        <translation>Резолуција:</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="199"/>
        <source>DPI</source>
        <translation>тпи</translation>
    </message>
    <message>
        <location filename="../customfdialog.cpp" line="193"/>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <location filename="../customfdialog.cpp" line="190"/>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="205"/>
        <source>Colorspace:</source>
        <translation>Простор боја:</translation>
    </message>
    <message>
        <location filename="../customfdialog.cpp" line="196"/>
        <source>Grayscale</source>
        <translation type="obsolete">Нијансе сиве</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="226"/>
        <source>File Format:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FileLoader</name>
    <message>
        <location filename="../../scribus/fileloader.cpp" line="594"/>
        <source>Some fonts used by this document have been substituted:</source>
        <translation>Неки фонтови коришћени у овом докумену су замењени:</translation>
    </message>
    <message>
        <location filename="../../scribus/fileloader.cpp" line="598"/>
        <source> was replaced by: </source>
        <translation>је замењен са:</translation>
    </message>
</context>
<context>
    <name>FileToolBar</name>
    <message>
        <location filename="../../scribus/ui/filetoolbar.cpp" line="31"/>
        <source>File</source>
        <translation type="unfinished">Фајл</translation>
    </message>
</context>
<context>
    <name>FontComboH</name>
    <message>
        <location filename="../../scribus/fontcombo.cpp" line="148"/>
        <source>Face:</source>
        <translation>Изглед:</translation>
    </message>
    <message>
        <location filename="../../scribus/fontcombo.cpp" line="149"/>
        <source>Style:</source>
        <translation type="unfinished">Стил:</translation>
    </message>
</context>
<context>
    <name>FontListModel</name>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="63"/>
        <source>Font Name</source>
        <translation type="unfinished">Име фонта</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="65"/>
        <source>Use Font</source>
        <translation type="unfinished">Користи фонт</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="67"/>
        <source>Family</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="69"/>
        <source>Style</source>
        <translation type="unfinished">Стил</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="71"/>
        <source>Variant</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="73"/>
        <source>Type</source>
        <translation type="unfinished">Врста</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="75"/>
        <source>Format</source>
        <translation type="unfinished">Формат</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="77"/>
        <source>Embed in PostScript</source>
        <translation type="unfinished">Укључи у PostScript</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="79"/>
        <source>Subset</source>
        <translation type="unfinished">Подсет</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="81"/>
        <source>Access</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="83"/>
        <source>Used in Doc</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="85"/>
        <source>Path to Font File</source>
        <translation type="unfinished">Путања до фајла фонта</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="144"/>
        <source>Unknown</source>
        <comment>font type</comment>
        <translation type="unfinished">Непознат</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="157"/>
        <source>Unknown</source>
        <comment>font format</comment>
        <translation type="unfinished">Непознат</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="164"/>
        <source>User</source>
        <comment>font preview</comment>
        <translation type="unfinished">Кориснички</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="165"/>
        <source>System</source>
        <comment>font preview</comment>
        <translation type="unfinished">Системски</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="190"/>
        <source>Click to change the value</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FontPrefs</name>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="48"/>
        <source>Available Fonts</source>
        <translation>Доступни фонтови</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="48"/>
        <source>Font Substitutions</source>
        <translation>Замене за фонтове</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="48"/>
        <source>Additional Paths</source>
        <translation>Додатне путање</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="66"/>
        <source>Font Name</source>
        <translation>Име фонта</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="58"/>
        <source>&amp;Available Fonts</source>
        <translation>&amp;Доступни фонтови</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="67"/>
        <source>Replacement</source>
        <translation>Замена</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="82"/>
        <source>&amp;Delete</source>
        <translation>&amp;Обриши</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="88"/>
        <source>Font &amp;Substitutions</source>
        <translation>&amp;Замене за фонтове</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="107"/>
        <source>C&amp;hange...</source>
        <translation>И&amp;змени...</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="109"/>
        <source>A&amp;dd...</source>
        <translation>&amp;Додај...</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="111"/>
        <source>&amp;Remove</source>
        <translation>&amp;Уклони</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="135"/>
        <source>Additional &amp;Paths</source>
        <translation>Додатне &amp;путање</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="247"/>
        <source>Choose a Directory</source>
        <translation>Изаберите директоријум</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Font Name</source>
        <comment>



font preview</comment>
        <translation type="obsolete">Име фонта</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Use Font</source>
        <comment>



font preview</comment>
        <translation type="obsolete">Користи фонт</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Subset</source>
        <comment>



font preview</comment>
        <translation type="obsolete">Подсет</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Path to Font File</source>
        <comment>



font preview</comment>
        <translation type="obsolete">Путања до фајла фонта</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="51"/>
        <source>Embed in PostScript</source>
        <comment>font preview</comment>
        <translation type="obsolete">Укључи у PostScript</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="130"/>
        <source>Font search paths can only be set in File &gt; Preferences, and only when there is no document currently open. Close any open documents, then use File &gt; Preferences &gt; Fonts to change the font search path.</source>
        <translation>Путања за тражење фонтова се може подесити у File &gt; Preferences и само онда када нема тренутно отвореног документа. Затвори отворене документе, па затим користи File &gt; Preferences &gt; Fonts за промену путање у којој се фонтови траже.</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="48"/>
        <source>Font Name</source>
        <comment>font preview</comment>
        <translation type="obsolete">Име фонта</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="49"/>
        <source>Use Font</source>
        <comment>font preview</comment>
        <translation type="obsolete">Користи фонт</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="53"/>
        <source>Subset</source>
        <comment>font preview</comment>
        <translation type="obsolete">Подсет</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="55"/>
        <source>Path to Font File</source>
        <comment>font preview</comment>
        <translation type="obsolete">Путања до фајла фонта</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="57"/>
        <source>Use Font</source>
        <translation type="obsolete">Користи фонт</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="58"/>
        <source>Embed in PostScript</source>
        <translation type="obsolete">Укључи у PostScript</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="59"/>
        <source>Subset</source>
        <translation type="obsolete">Подсет</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="60"/>
        <source>Path to Font File</source>
        <translation type="obsolete">Путања до фајла фонта</translation>
    </message>
</context>
<context>
    <name>FontPreview</name>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="97"/>
        <source>User</source>
        <comment>font preview</comment>
        <translation type="obsolete">Кориснички</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="98"/>
        <source>System</source>
        <comment>font preview</comment>
        <translation type="obsolete">Системски</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.cpp" line="111"/>
        <source>Leave preview</source>
        <comment>font preview</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Woven silk pyjamas exchanged for blue quartz</source>
        <comment>



font preview</comment>
        <translation type="obsolete">Плетене свилене пиџаме замењене за плави кварц</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.cpp" line="114"/>
        <source>Start searching</source>
        <translation type="obsolete">Започни претрагу</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.cpp" line="113"/>
        <source>Size of the selected font</source>
        <translation>Величина изабраног фонта</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="42"/>
        <source>Font Name</source>
        <translation type="obsolete">Име фонта</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="44"/>
        <source>Type</source>
        <translation type="obsolete">Врста</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="45"/>
        <source>Subset</source>
        <translation type="obsolete">Подсет</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.cpp" line="44"/>
        <source>Woven silk pyjamas exchanged for blue quartz</source>
        <comment>font preview</comment>
        <translation type="unfinished">Плетене свилене пиџаме замењене за плави кварц</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="13"/>
        <source>Fonts Preview</source>
        <translation type="unfinished">Преглед фонтова</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="19"/>
        <source>&amp;Quick Search:</source>
        <translation type="unfinished">&amp;Брза претрага:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="35"/>
        <source>&amp;Search</source>
        <translation type="obsolete">&amp;Тражи</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="38"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="80"/>
        <source>&amp;Font Size:</source>
        <translation type="unfinished">Величина &amp;фонта:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="103"/>
        <source>Text</source>
        <translation type="unfinished">Текст</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="113"/>
        <source>Sample text to display</source>
        <translation type="unfinished">Узорак текста за приказ</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="123"/>
        <source>Se&amp;t</source>
        <translation type="unfinished">Пос&amp;тави</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="126"/>
        <source>Alt+T</source>
        <translation type="unfinished">Alt+T</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="133"/>
        <source>Reset the text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.ui" line="209"/>
        <source>&amp;Append</source>
        <translation type="obsolete">&amp;Примени</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.ui" line="212"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="167"/>
        <source>&amp;Close</source>
        <translation type="unfinished">&amp;Затвори</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="170"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.cpp" line="112"/>
        <source>Typing the text here provides quick searching in the font names. Searching is case insensitive. The given text is taken as substring.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="136"/>
        <source>&amp;Default</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="35"/>
        <source>Show Extended Font Information</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="120"/>
        <source>Set the preview text</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FontPreviewBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Fonts Preview</source>
        <translation type="obsolete">Преглед фонтова</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Quick Search:</source>
        <translation type="obsolete">&amp;Брза претрага:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Search</source>
        <translation type="obsolete">&amp;Тражи</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Font Name</source>
        <translation type="obsolete">Име фонта</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Type</source>
        <translation type="obsolete">Врста</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Subset</source>
        <translation type="obsolete">Подсет</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Font Size:</source>
        <translation type="obsolete">Величина &amp;фонта:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Text</source>
        <translation type="obsolete">Текст</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Sample text to display</source>
        <translation type="obsolete">Узорак текста за приказ</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Se&amp;t</source>
        <translation type="obsolete">Пос&amp;тави</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+T</source>
        <translation type="obsolete">Alt+T</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Append</source>
        <translation type="obsolete">&amp;Примени</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Close</source>
        <translation type="obsolete">&amp;Затвори</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
</context>
<context>
    <name>FontPreviewPlugin</name>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="49"/>
        <source>&amp;Font Preview...</source>
        <translation>Приказ &amp;фонта...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="66"/>
        <source>Font Preview dialog</source>
        <translation>Прозор прегледа фонтова</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="67"/>
        <source>Sorting, searching and browsing available fonts.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FontReplaceDialog</name>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="30"/>
        <source>Font Substitution</source>
        <translation>Замене фонтова</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="45"/>
        <source>Original Font</source>
        <translation>Изворни фонт</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="46"/>
        <source>Substitution Font</source>
        <translation>Фонт замене</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="72"/>
        <source>Make these substitutions permanent</source>
        <translation>Учини ову замену трајном</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="40"/>
        <source>This document contains some fonts that are not installed on your system, please choose a suitable replacement for them. Cancel will stop the document from loading.</source>
        <translation>Овај документ садржи неке фонтове који нису присутни на овом систему, изабери одговарајућу замену за њих. Поништење ће зауставити учитавање документа.</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="83"/>
        <source>Cancels these font substitutions and stops loading the document.</source>
        <translation>Поништава замену фонтова и зауставља учитавање документа.</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="84"/>
        <source>Enabling this tells Scribus to use these replacements for missing fonts permanently in all future layouts. This can be reverted or changed in Edit &gt; Preferences &gt; Fonts.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="85"/>
        <source>If you select OK, then save, these substitutions are made permanent in the document.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>GradientEditor</name>
    <message>
        <location filename="../../scribus/gradienteditor.cpp" line="327"/>
        <source>Position:</source>
        <translation>Позиција:</translation>
    </message>
    <message>
        <location filename="../../scribus/gradienteditor.cpp" line="328"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../scribus/gradienteditor.cpp" line="336"/>
        <source>Add, change or remove color stops here</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>GradientVectorDialog</name>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="100"/>
        <source>Gradient Vector</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>GuideManager</name>
    <message>
        <location filename="../guidemanager.cpp" line="229"/>
        <source>Edit Guide</source>
        <translation type="obsolete">Уреди водиље</translation>
    </message>
    <message>
        <location filename="../guidemanager.cpp" line="257"/>
        <source>Enter a position:</source>
        <translation type="obsolete">Позиција:</translation>
    </message>
    <message>
        <location filename="../guidemanager.cpp" line="256"/>
        <source>New Guide</source>
        <translation type="obsolete">Нова водиља</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="31"/>
        <source>&amp;Single</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="146"/>
        <source>Horizontals</source>
        <translation type="unfinished">Хоризонтале</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="55"/>
        <source>&amp;Add</source>
        <translation type="unfinished">&amp;Додај</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="356"/>
        <source>Alt+A</source>
        <translation type="unfinished">Alt+A</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="65"/>
        <source>D&amp;elete</source>
        <translation type="unfinished">&amp;Обриши</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="307"/>
        <source>Alt+E</source>
        <translation type="unfinished">Alt+E</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="233"/>
        <source>Verticals</source>
        <translation type="unfinished">Вертикале</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="94"/>
        <source>A&amp;dd</source>
        <translation type="unfinished">&amp;Додај</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="97"/>
        <source>Alt+D</source>
        <translation type="unfinished">Alt+D</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="104"/>
        <source>De&amp;lete</source>
        <translation type="unfinished">&amp;Обриши</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="122"/>
        <source>Alt+L</source>
        <translation type="unfinished">Alt+L</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="119"/>
        <source>&amp;Lock Guides</source>
        <translation type="unfinished">&amp;Закључај водиље</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="320"/>
        <source>Appl&amp;y to All Pages</source>
        <translation type="unfinished">Примен&amp;и на све стране</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="323"/>
        <source>Alt+Y</source>
        <translation type="unfinished">Alt+Y</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="140"/>
        <source>&amp;Column/Row</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="152"/>
        <source>&amp;Number:</source>
        <translation type="unfinished">&amp;Број:</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="175"/>
        <source>U&amp;se Gap:</source>
        <translation type="unfinished">К&amp;ористи размак:</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="178"/>
        <source>Alt+S</source>
        <translation type="unfinished">Alt+S</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="281"/>
        <source>&amp;Page</source>
        <translation type="unfinished">&amp;Страна</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="343"/>
        <source>Alt+P</source>
        <translation type="unfinished">Alt+P</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="294"/>
        <source>M&amp;argins</source>
        <translation type="unfinished">М&amp;аргине</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="304"/>
        <source>S&amp;election</source>
        <translation type="unfinished">И&amp;збор</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="239"/>
        <source>Nu&amp;mber:</source>
        <translation type="unfinished">&amp;Број:</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="262"/>
        <source>Use &amp;Gap:</source>
        <translation type="unfinished">Користи &amp;размак:</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="265"/>
        <source>Alt+G</source>
        <translation type="unfinished">Alt+G</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="331"/>
        <source>&amp;Misc</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="337"/>
        <source>Delete all guides from the current page</source>
        <translation type="unfinished">Избриши све водиље са текуће стране</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="340"/>
        <source>Delete Guides from Current &amp;Page</source>
        <translation type="unfinished">Избриши водиље са текуће &amp;стране</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="350"/>
        <source>Delete all guides from the current document</source>
        <translation type="unfinished">Избриши све водиље из текућег документа</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="353"/>
        <source>Delete Guides from &amp;All Pages</source>
        <translation type="unfinished">Избриши водиље са с&amp;вих страна</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="15"/>
        <source>Guide Manager</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="253"/>
        <source>Add a new horizontal guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="254"/>
        <source>Delete the selected horizontal guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="255"/>
        <source>Add a new vertical guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="256"/>
        <source>Delete the selected vertical guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="257"/>
        <source>Lock the guides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="258"/>
        <source>Apply to all pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="259"/>
        <source>Number of horizontal guides to create</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="260"/>
        <source>Number of vertical guides to create</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="261"/>
        <source>Create rows with guides, with an additional gap between the rows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="262"/>
        <source>Create columns with guides, with an additional gap between the columns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="263"/>
        <source>Create the selected number of horizontal guides relative to the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="264"/>
        <source>Create the selected number of horizontal guides relative to the current page&apos;s margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="265"/>
        <source>Create the selected number of horizontal guides relative to the current selection of items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="266"/>
        <source>Create the selected number of vertical guides relative to the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="267"/>
        <source>Create the selected number of vertical guides relative to the current page&apos;s margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="268"/>
        <source>Create the selected number of vertical guides relative to the current selection of items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="269"/>
        <source>Apply the shown guides to all pages in the document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="270"/>
        <source>Delete all guides shown on the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="271"/>
        <source>Delete all guides from all pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="275"/>
        <source>Refer to</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>GuideManagerBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Manage Guides</source>
        <translation type="obsolete">Управљање водиљама</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Horizontals</source>
        <translation type="obsolete">Хоризонтале</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Guide</source>
        <translation type="obsolete">Водиља</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Add</source>
        <translation type="obsolete">&amp;Додај</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>D&amp;elete</source>
        <translation type="obsolete">&amp;Обриши</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+E</source>
        <translation type="obsolete">Alt+E</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Verticals</source>
        <translation type="obsolete">Вертикале</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>A&amp;dd</source>
        <translation type="obsolete">&amp;Додај</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+D</source>
        <translation type="obsolete">Alt+D</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>De&amp;lete</source>
        <translation type="obsolete">&amp;Обриши</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+L</source>
        <translation type="obsolete">Alt+L</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Lock Guides</source>
        <translation type="obsolete">&amp;Закључај водиље</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Appl&amp;y to All Pages</source>
        <translation type="obsolete">Примен&amp;и на све стране</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+Y</source>
        <translation type="obsolete">Alt+Y</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Number:</source>
        <translation type="obsolete">&amp;Број:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>U&amp;se Gap:</source>
        <translation type="obsolete">К&amp;ористи размак:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Nu&amp;mber:</source>
        <translation type="obsolete">&amp;Број:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Use &amp;Gap:</source>
        <translation type="obsolete">Користи &amp;размак:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+G</source>
        <translation type="obsolete">Alt+G</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Page</source>
        <translation type="obsolete">&amp;Страна</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+P</source>
        <translation type="obsolete">Alt+P</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>M&amp;argins</source>
        <translation type="obsolete">М&amp;аргине</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>S&amp;election</source>
        <translation type="obsolete">И&amp;збор</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Delete all guides from the current page</source>
        <translation type="obsolete">Избриши све водиље са текуће стране</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Delete all guides from the current document</source>
        <translation type="obsolete">Избриши све водиље из текућег документа</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Delete Guides from Current &amp;Page</source>
        <translation type="obsolete">Избриши водиље са текуће &amp;стране</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Delete Guides from &amp;All Pages</source>
        <translation type="obsolete">Избриши водиље са с&amp;вих страна</translation>
    </message>
</context>
<context>
    <name>HelpBrowser</name>
    <message>
        <location filename="../helpbrowser.cpp" line="265"/>
        <source>Sorry, no manual available! Please see: http://docs.scribus.net for updated docs
and www.scribus.net for downloads.</source>
        <translation type="obsolete">Извините, нема доступног упутства! Молим Вас погледајте: http://docs.scribus.net за освежене документе
и www.scribus.net за преузимање.</translation>
    </message>
    <message>
        <location filename="../helpbrowser.cpp" line="343"/>
        <source>Link</source>
        <translation type="obsolete">Веза</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="287"/>
        <source>Scribus Online Help</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="31"/>
        <source>&amp;Contents</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="60"/>
        <source>&amp;Search</source>
        <translation type="unfinished">&amp;Тражи</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="45"/>
        <source>Se&amp;arch</source>
        <translation>Тр&amp;ажи</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="96"/>
        <source>&amp;New</source>
        <translation type="unfinished">&amp;Нови</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="178"/>
        <source>&amp;Delete</source>
        <translation type="unfinished">&amp;Обриши</translation>
    </message>
    <message>
        <location filename="../helpbrowser.cpp" line="355"/>
        <source>De&amp;lete All</source>
        <translation type="obsolete">Обр&amp;иши све</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="79"/>
        <source>Book&amp;marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="148"/>
        <source>&amp;Print...</source>
        <translation type="unfinished">Ш&amp;тампај...</translation>
    </message>
    <message>
        <location filename="../helpbrowser.cpp" line="216"/>
        <source>E&amp;xit</source>
        <translation type="obsolete">Из&amp;ађи</translation>
    </message>
    <message>
        <location filename="../helpbrowser.cpp" line="461"/>
        <source>Searching is case unsensitive</source>
        <translation type="obsolete">Тражење је неосетљиво на велика и мала слова</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="377"/>
        <source>Find</source>
        <translation>Фражи</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="377"/>
        <source>Search Term:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="409"/>
        <source>New Bookmark</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="409"/>
        <source>New Bookmark&apos;s Title:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="289"/>
        <source>&amp;File</source>
        <translation type="unfinished">&amp;Фајл</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="158"/>
        <source>&amp;Find...</source>
        <translation>&amp;Тражи...</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="296"/>
        <source>Find &amp;Next</source>
        <translation>Нађи &amp;наредно</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="297"/>
        <source>Find &amp;Previous</source>
        <translation>Нађи &amp;претходно</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="290"/>
        <source>&amp;Edit</source>
        <translation type="unfinished">&amp;Уреди</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="298"/>
        <source>&amp;Add Bookmark</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="183"/>
        <source>D&amp;elete All</source>
        <translation>Из&amp;бриши све</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="291"/>
        <source>&amp;Bookmarks</source>
        <translation type="unfinished">&amp;Маркери</translation>
    </message>
    <message>
        <location filename="../helpbrowser.cpp" line="325"/>
        <source>Relevance</source>
        <translation type="obsolete">Важност</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="137"/>
        <source>Scribus Help</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="53"/>
        <source>Searching is case insensitive</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="86"/>
        <source>1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="153"/>
        <source>&amp;Exit</source>
        <translation type="unfinished">&amp;Изађи</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="163"/>
        <source>Find &amp;Next...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="168"/>
        <source>Find &amp;Previous...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="173"/>
        <source>&amp;Add</source>
        <translation type="unfinished">&amp;Додај</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="294"/>
        <source>&amp;Quit</source>
        <translation type="unfinished">&amp;Заврши</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="715"/>
        <source>&lt;h2&gt;&lt;p&gt;Sorry, no manual is installed!&lt;/p&gt;&lt;p&gt;Please see:&lt;/p&gt;&lt;ul&gt;&lt;li&gt;http://docs.scribus.net for updated documentation&lt;/li&gt;&lt;li&gt;http://www.scribus.net for downloads&lt;/li&gt;&lt;/ul&gt;&lt;/h2&gt;</source>
        <comment>HTML message for no documentation available to show</comment>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>HelpBrowser2</name>
    <message>
        <location filename="../ui/hb2.ui" line="49"/>
        <source>Se&amp;arch</source>
        <translation type="obsolete">Тр&amp;ажи</translation>
    </message>
    <message>
        <location filename="../ui/hb2.ui" line="64"/>
        <source>&amp;Search</source>
        <translation type="obsolete">&amp;Тражи</translation>
    </message>
</context>
<context>
    <name>HyAsk</name>
    <message>
        <location filename="../../scribus/hyask.cpp" line="48"/>
        <source>Possible Hyphenation</source>
        <translation>Могуће спајање цртицом</translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="68"/>
        <source>Accept</source>
        <translation>Прихвати</translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="89"/>
        <source>Skip</source>
        <translation>Прескочи</translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="107"/>
        <source>Cancel</source>
        <translation>Поништи</translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="77"/>
        <source>Add to the
Exception List</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="97"/>
        <source>Add to the
Ignore List</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>HySettings</name>
    <message>
        <location filename="../hysettings.cpp" line="20"/>
        <source>&amp;Hyphenation Suggestions</source>
        <translation type="obsolete">Предлози за &amp;спајање цртицом</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="23"/>
        <source>Hyphenate Text Automatically &amp;During Typing</source>
        <translation type="obsolete">Аутоматски спајај текст цртицама &amp;приликом куцања</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="40"/>
        <source>&amp;Language:</source>
        <translation type="obsolete">&amp;Језик:</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="46"/>
        <source>&amp;Smallest Word:</source>
        <translation type="obsolete">&amp;Најмања реч:</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="52"/>
        <source>Consecutive Hyphenations &amp;Allowed:</source>
        <translation type="obsolete">&amp;Дозвољена су узастопна спајања цртицом:</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="56"/>
        <source>A dialog box showing all possible hyphens for each word will show up when you use the Extras, Hyphenate Text option.</source>
        <translation type="obsolete">Појавиће се прозор који приказује сва могућа спајања цртицом за сваку реч када користите опцију „Екстра&gt;Спајај текст цртицом“.</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="57"/>
        <source>Enables automatic hyphenation of your text while typing.</source>
        <translation type="obsolete">Укључује аутоматско спајање текста цртицама у току куцања.</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="58"/>
        <source>Length of the smallest word to be hyphenated.</source>
        <translation type="obsolete">Дужина најмање речи која се може спајати цртицом.</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="59"/>
        <source>Maximum number of Hyphenations following each other.
A value of 0 means unlimited hyphenations.</source>
        <translation type="obsolete">Максималан број спајања цртицом који могу ићи једно за другим.
Вредност 0 означава неограничено спајање цртицом.</translation>
    </message>
    <message>
        <location filename="../../scribus/hysettings.cpp" line="92"/>
        <source>Ignore List</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/hysettings.cpp" line="121"/>
        <source>Add a new Entry</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/hysettings.cpp" line="133"/>
        <source>Edit Entry</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/hysettings.cpp" line="133"/>
        <source>Exception List</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImageInfoDialog</name>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="23"/>
        <source>Image Info</source>
        <translation>Подаци о слици</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="30"/>
        <source>General Info</source>
        <translation>Општи подаци</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="34"/>
        <source>Date / Time:</source>
        <translation>Датум / Време:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="38"/>
        <source>Has Embedded Profile:</source>
        <translation>Има укључен профил:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="46"/>
        <source>Profile Name:</source>
        <translation>Име профила:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="50"/>
        <source>Has Embedded Paths:</source>
        <translation>Има укључене стазе:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="58"/>
        <source>Has Layers:</source>
        <translation>Има слојеве:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="69"/>
        <source>EXIF Info</source>
        <translation>EXIF подаци</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="84"/>
        <source>Artist:</source>
        <translation>Уметник:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="126"/>
        <source>Comment:</source>
        <translation>Коментар:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="127"/>
        <source>User Comment:</source>
        <translation>Корисников коментар:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="128"/>
        <source>Camera Model:</source>
        <translation>Модел фото апарата:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="129"/>
        <source>Camera Manufacturer:</source>
        <translation>Произвођач фото апарата:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="135"/>
        <source>Description:</source>
        <translation>Опис:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="136"/>
        <source>Copyright:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="137"/>
        <source>Scanner Model:</source>
        <translation>Тип скенера:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="138"/>
        <source>Scanner Manufacturer:</source>
        <translation>Произвођач скенера:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="130"/>
        <source>Exposure time</source>
        <translation>Време експозиције</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="131"/>
        <source>Aperture:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="132"/>
        <source>ISO equiv.:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImportAIPlugin</name>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="58"/>
        <source>Import AI...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="79"/>
        <source>Imports Illustrator Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="80"/>
        <source>Imports most Illustrator files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="162"/>
        <source>The file could not be imported</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImportDialog</name>
    <message>
        <location filename="../smstyleimport.cpp" line="30"/>
        <source>Choose Styles</source>
        <translation type="obsolete">Изабери стилове</translation>
    </message>
    <message>
        <location filename="../smstyleimport.cpp" line="35"/>
        <source>Available Styles</source>
        <translation type="obsolete">Доступни стилови</translation>
    </message>
    <message>
        <location filename="../smstyleimport.cpp" line="40"/>
        <source>Character Styles</source>
        <translation type="obsolete">Стилови знакова</translation>
    </message>
    <message>
        <location filename="../smstyleimport.cpp" line="49"/>
        <source>Paragraph Styles</source>
        <translation type="obsolete">Стилови параграфа</translation>
    </message>
    <message>
        <location filename="../smstyleimport.cpp" line="58"/>
        <source>Line Styles</source>
        <translation type="obsolete">Стилови линија</translation>
    </message>
    <message>
        <location filename="../smstyleimport.cpp" line="77"/>
        <source>Rename imported style</source>
        <translation type="obsolete">Преименуј увезени стил</translation>
    </message>
    <message>
        <location filename="../smstyleimport.cpp" line="79"/>
        <source>Replace existing style</source>
        <translation type="obsolete">Уклони постојећи стил</translation>
    </message>
</context>
<context>
    <name>ImportPSPlugin</name>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="57"/>
        <source>Import &amp;EPS/PS...</source>
        <translation type="obsolete">Увези &amp;EPS/PS...</translation>
    </message>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="78"/>
        <source>Imports EPS Files</source>
        <translation type="obsolete">Увози EPS фајлове</translation>
    </message>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="79"/>
        <source>Imports most EPS files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="obsolete">Увози већину EPS фајлова у текући документ, преводећи њихове векторске податке у Скрибусове објекте.</translation>
    </message>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="92"/>
        <source>PostScript</source>
        <translation type="obsolete">PostScript</translation>
    </message>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="105"/>
        <source>PDF</source>
        <translation type="obsolete">PDF</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importpsplugin.cpp" line="57"/>
        <source>Import PostScript...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importpsplugin.cpp" line="78"/>
        <source>Imports PostScript Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importpsplugin.cpp" line="79"/>
        <source>Imports most PostScript files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImportXfigPlugin</name>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="58"/>
        <source>Import Xfig...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="79"/>
        <source>Imports Xfig Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="80"/>
        <source>Imports most Xfig files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="126"/>
        <source>All Supported Formats</source>
        <translation type="unfinished">Сви подржани формати</translation>
    </message>
</context>
<context>
    <name>Imposition</name>
    <message>
        <location filename="../../scribus/plugins/imposition/imposition.cpp" line="72"/>
        <source>Portrait</source>
        <translation type="unfinished">Усправно</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/imposition.cpp" line="73"/>
        <source>Landscape</source>
        <translation type="unfinished">Водоравно</translation>
    </message>
</context>
<context>
    <name>ImpositionBase</name>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="19"/>
        <source>Imposition</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="44"/>
        <source>Gri&amp;d</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="102"/>
        <source>Copies</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="157"/>
        <source>Do&amp;uble sided</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="160"/>
        <source>Alt+U</source>
        <translation type="unfinished">Alt+U</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="186"/>
        <source>Front side</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="218"/>
        <source>Back side</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="253"/>
        <source>&amp;Booklet</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="285"/>
        <source>Pages per sheet</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="296"/>
        <source>4</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="301"/>
        <source>8</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="306"/>
        <source>16</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="318"/>
        <source>Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="325"/>
        <source>&lt;html&gt;&lt;head&gt;&lt;meta name=&quot;qrichtext&quot; content=&quot;1&quot; /&gt;&lt;style type=&quot;text/css&quot;&gt;
p, li { white-space: pre-wrap; }
&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot; font-family:&apos;Sans Serif&apos;; font-size:9pt; font-weight:400; font-style:normal;&quot;&gt;
&lt;p style=&quot; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;Separate pages with a comma, ranges with a hyphen, e.g. 1,4,9-11 to get pages 1,4,9,10,11.&lt;/p&gt;&lt;/body&gt;&lt;/html&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="339"/>
        <source>Fold</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="349"/>
        <source>Front page from</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="376"/>
        <source>Double sided</source>
        <translation type="unfinished">Двострано</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="387"/>
        <source>Back page from</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="415"/>
        <source>Destination page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="455"/>
        <source>Size</source>
        <translation type="unfinished">Величина</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="487"/>
        <source>Orientation</source>
        <translation type="unfinished">Усмерење</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="519"/>
        <source>Width</source>
        <translation type="unfinished">Ширина</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="564"/>
        <source>Height</source>
        <translation type="unfinished">Висина</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="620"/>
        <source>Preview</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="627"/>
        <source>Refresh preview</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="671"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;У реду</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="674"/>
        <source>Alt+G</source>
        <translation type="unfinished">Alt+G</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="681"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Откажи</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="684"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
</context>
<context>
    <name>ImpositionPlugin</name>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionplugin.cpp" line="37"/>
        <source>&amp;Imposition...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionplugin.cpp" line="69"/>
        <source>Imposition dialog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionplugin.cpp" line="70"/>
        <source>Imposition on grids, booklets and folds</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>InsPage</name>
    <message>
        <location filename="../../scribus/inspage.cpp" line="30"/>
        <source>Insert Page</source>
        <translation>Убаци страну</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="46"/>
        <source>Page(s)</source>
        <translation>Страна(е)</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="50"/>
        <source>before Page</source>
        <translation>пре странице</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="51"/>
        <source>after Page</source>
        <translation>после странице</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="52"/>
        <source>at End</source>
        <translation>на крају</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="63"/>
        <source>&amp;Insert</source>
        <translation type="unfinished">Уметн&amp;и</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="67"/>
        <source>Master Pages</source>
        <translation>Главне стране</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="77"/>
        <source>&amp;Master Page:</source>
        <translation>&amp;Главна страна:</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="205"/>
        <source>Page Size</source>
        <translation type="unfinished">Величина папира</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="209"/>
        <source>&amp;Size:</source>
        <translation type="unfinished">&amp;Величина:</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="224"/>
        <source>Orie&amp;ntation:</source>
        <translation type="unfinished">Усм&amp;ерење:</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="227"/>
        <source>Portrait</source>
        <translation type="unfinished">Усправно</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="228"/>
        <source>Landscape</source>
        <translation type="unfinished">Водоравно</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="233"/>
        <source>&amp;Width:</source>
        <translation type="unfinished">Ш&amp;ирина:</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="240"/>
        <source>&amp;Height:</source>
        <translation type="unfinished">&amp;Висина:</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="245"/>
        <source>Move Objects with their Page</source>
        <translation>Премести објекте са њиховом страном</translation>
    </message>
</context>
<context>
    <name>InsertAFrame</name>
    <message>
        <location filename="../../scribus/insertaframe.cpp" line="237"/>
        <source>Open</source>
        <translation type="unfinished">Отвори</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="13"/>
        <source>Insert A Frame</source>
        <translation type="unfinished">Убаци оквир</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="37"/>
        <source>T&amp;ype</source>
        <translation type="unfinished">Т&amp;ип</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="75"/>
        <source>&amp;Text Frame</source>
        <translation type="unfinished">&amp;Текстуални оквир</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="73"/>
        <source>Alt+T</source>
        <translation type="obsolete">Alt+T</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="85"/>
        <source>&amp;Image Frame</source>
        <translation type="unfinished">&amp;Оквир слике</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="83"/>
        <source>Alt+I</source>
        <translation type="obsolete">Alt+I</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="93"/>
        <source>T&amp;able</source>
        <translation type="obsolete">Т&amp;абела</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="96"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="106"/>
        <source>Shape</source>
        <translation type="obsolete">Облик</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="116"/>
        <source>Polygon</source>
        <translation type="obsolete">Полигон</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="122"/>
        <source>&amp;Location</source>
        <translation type="unfinished">&amp;Локација</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="137"/>
        <source>Page Placement</source>
        <translation type="unfinished">Постављање на страни</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="195"/>
        <source>Selecting this will place the frame only on the current page.</source>
        <translation type="obsolete">Овај избор ће поставити оквир само на текућу страну.</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="152"/>
        <source>Current Page</source>
        <translation type="unfinished">Текућа страна</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="162"/>
        <source>All Pages</source>
        <translation type="unfinished">Све странице</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="205"/>
        <source>Selecting this will place frame on the selected range. </source>
        <translation type="obsolete">Овај избор ће поставити оквир у изабраном опсегу.</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="208"/>
        <source>Range of Pages:</source>
        <translation type="obsolete">Опсег страна:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="773"/>
        <source>...</source>
        <translation type="unfinished">...</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="225"/>
        <source>Position of Frame</source>
        <translation type="unfinished">Положај оквира</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="310"/>
        <source>Selecting this places the frame in the upper left of the page margins defined in your doc setup.</source>
        <translation type="obsolete">Овај избор ће поставити оквир у горе лево на маргине стране одређене у подешењима документа.</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="240"/>
        <source>Top Left of Margins</source>
        <translation type="unfinished">Горе лево на маргини</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="320"/>
        <source>Selecting this puts the frame on the top left with postion 0,0</source>
        <translation type="obsolete">Овај избор ће поставити оквир у горњи леви положај 0,0</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="250"/>
        <source>Top Left of Page</source>
        <translation type="unfinished">Горе лево на страни</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="260"/>
        <source>Top Left of Bleed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="340"/>
        <source>Set the dimensions wished below in the X: Y: dialog below.</source>
        <translation type="obsolete">Упиши жељену димензију у X: Y: поља доле.</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="343"/>
        <source>Custom Position:</source>
        <translation type="obsolete">Произвољан положај:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="316"/>
        <source>X:</source>
        <translation type="unfinished">X:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="309"/>
        <source>Y:</source>
        <translation type="unfinished">Y:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="379"/>
        <source>&amp;Size</source>
        <translation type="unfinished">&amp;Величина</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="409"/>
        <source>Same as the Page Margins</source>
        <translation type="unfinished">Исто као и маргине стране</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="419"/>
        <source>Same as the Page</source>
        <translation type="unfinished">Исто као и страна</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="429"/>
        <source>Same as the Bleed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="439"/>
        <source>Same as the Imported Image</source>
        <translation type="unfinished">Исто као и увезена слика</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="539"/>
        <source>Custom Size:</source>
        <translation type="obsolete">Произвољна величина:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="488"/>
        <source>Height:</source>
        <translation type="unfinished">Висина:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="495"/>
        <source>Width:</source>
        <translation type="unfinished">Ширина:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="558"/>
        <source>&amp;Options</source>
        <translation type="unfinished">&amp;Опције</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="759"/>
        <source>Source Image:</source>
        <translation type="unfinished">Изворна слика:</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="914"/>
        <source>&amp;Select File...</source>
        <translation type="obsolete">&amp;Изабери фајл...</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="917"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="813"/>
        <source>There are no options for this type of frame</source>
        <translation type="unfinished">Не постоје опције за овај тип оквира</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="625"/>
        <source>Columns:</source>
        <translation type="unfinished">Колоне:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="611"/>
        <source>Gap:</source>
        <translation type="unfinished">Размак:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="531"/>
        <source>Link Created Frames</source>
        <translation type="obsolete">Повежи направљене оквире</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="697"/>
        <source>Source Document:</source>
        <translation type="unfinished">Изворни документ</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="974"/>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;У реду</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="990"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Откажи</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="172"/>
        <source>Range of Pages</source>
        <translation type="unfinished">Опсег страна</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="270"/>
        <source>Custom Position</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="449"/>
        <source>Custom Size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.cpp" line="133"/>
        <source>&lt;b&gt;Insert a text frame&lt;/b&gt;&lt;br/&gt;A text frame allows you to enter any text in a defined position with the formatting you choose. You may select a text file on the Options tab if you want to immediately import a document into the frame. Scribus supports a wide variety of importable formats from plain text to OpenOffice.org.&lt;br/&gt;Your text may be edited and formatted on the page directly or in the Story Editor.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.cpp" line="137"/>
        <source>&lt;b&gt;Insert an image frame&lt;/b&gt;&lt;br/&gt;An image frame allows you to place an image onto your page. Various image effects may be applied or combined including transparencies, brightness, and posterisation that allow retouching or the creation of interesting visual results. Image scaling and shaping is performed with the Properties Palette.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="72"/>
        <source>Insert one or more text frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="82"/>
        <source>Insert one or more image frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="134"/>
        <source>Place the new frames on the current page, on all pages or on a selected range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="149"/>
        <source>Insert the frame on the current page only</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="159"/>
        <source>Insert one frame for each existing page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="169"/>
        <source>Insert frames on a range of pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="187"/>
        <source>Range of pages to insert frames on</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="222"/>
        <source>Position the new frame in relation to the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="237"/>
        <source>Insert the frame at the top left of the page margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="247"/>
        <source>Insert the frame at the top left of the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="257"/>
        <source>Insert the frame at the top left of the page bleed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="267"/>
        <source>Insert the frame at a custom position on the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="323"/>
        <source>Top position of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="330"/>
        <source>Left position of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="406"/>
        <source>Insert the new frame with the same dimensions as the page margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="416"/>
        <source>Insert the new frame with the same dimensions as the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="426"/>
        <source>Insert the new frame with the same dimensions as the bleed area outside the boundary of the page itself</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="436"/>
        <source>Insert the new frame with the same dimensions as the image that will be imported</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="446"/>
        <source>Insert the new frame with a custom size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="502"/>
        <source>Width of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="509"/>
        <source>Height of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="601"/>
        <source>Number of columns for the inserted text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="618"/>
        <source>Distance between the columns in the text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="649"/>
        <source>Link the inserted text frames together to form a chain of frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="652"/>
        <source>Link Inserted Frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="661"/>
        <source>Link the first inserted frame to a preexisting text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="664"/>
        <source>Link to Existing Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="680"/>
        <source>Name of existing text frame to link to</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="704"/>
        <source>Source document to load into the text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="766"/>
        <source>Source image to load into the inserted image frame</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>InsertAFrameBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Insert A Frame</source>
        <translation type="obsolete">Убаци оквир</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>T&amp;ype</source>
        <translation type="obsolete">Т&amp;ип</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Text Frame</source>
        <translation type="obsolete">&amp;Текстуални оквир</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+T</source>
        <translation type="obsolete">Alt+T</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Image Frame</source>
        <translation type="obsolete">&amp;Оквир слике</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+I</source>
        <translation type="obsolete">Alt+I</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>T&amp;able</source>
        <translation type="obsolete">Т&amp;абела</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Shape</source>
        <translation type="obsolete">Облик</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Polygon</source>
        <translation type="obsolete">Полигон</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Location</source>
        <translation type="obsolete">&amp;Локација</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Page Placement</source>
        <translation type="obsolete">Постављање на страни</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Current Page</source>
        <translation type="obsolete">Текућа страна</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Selecting this will place the frame only on the current page.</source>
        <translation type="obsolete">Овај избор ће поставити оквир само на текућу страну.</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Range of Pages:</source>
        <translation type="obsolete">Опсег страна:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Selecting this will place frame on the selected range. </source>
        <translation type="obsolete">Овај избор ће поставити оквир у изабраном опсегу.</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Position of Frame</source>
        <translation type="obsolete">Положај оквира</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Top Left of Page</source>
        <translation type="obsolete">Горе лево на страни</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Selecting this puts the frame on the top left with postion 0,0</source>
        <translation type="obsolete">Овај избор ће поставити оквир у горњи леви положај 0,0</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Top Left of Margins</source>
        <translation type="obsolete">Горе лево на маргини</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Selecting this places the frame in the upper left of the page margins defined in your doc setup.</source>
        <translation type="obsolete">Овај избор ће поставити оквир у горе лево на маргине стране одређене у подешењима документа.</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Custom Position:</source>
        <translation type="obsolete">Произвољан положај:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Set the dimensions wished below in the X: Y: dialog below.</source>
        <translation type="obsolete">Упиши жељену димензију у X: Y: поља доле.</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>X:</source>
        <translation type="obsolete">X:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Y:</source>
        <translation type="obsolete">Y:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Size</source>
        <translation type="obsolete">&amp;Величина</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Same as the Page</source>
        <translation type="obsolete">Исто као и страна</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Same as the Page Margins</source>
        <translation type="obsolete">Исто као и маргине стране</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Custom Size:</source>
        <translation type="obsolete">Произвољна величина:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Height:</source>
        <translation type="obsolete">Висина:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Width:</source>
        <translation type="obsolete">Ширина:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Options</source>
        <translation type="obsolete">&amp;Опције</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Source Image:</source>
        <translation type="obsolete">Изворна слика:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Select File...</source>
        <translation type="obsolete">&amp;Изабери фајл...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>There are no options for this type of frame</source>
        <translation type="obsolete">Не постоје опције за овај тип оквира</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Source Document:</source>
        <translation type="obsolete">Изворни документ</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Columns:</source>
        <translation type="obsolete">Колоне:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Gap:</source>
        <translation type="obsolete">Размак:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;У реду</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Откажи</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Link Created Frames</source>
        <translation type="obsolete">Повежи направљене оквире</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>All Pages</source>
        <translation type="obsolete">Све странице</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>...</source>
        <translation type="obsolete">...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Same as the Imported Image</source>
        <translation type="obsolete">Исто као и увезена слика</translation>
    </message>
</context>
<context>
    <name>InsertTable</name>
    <message>
        <location filename="../../scribus/insertTable.cpp" line="15"/>
        <source>Insert Table</source>
        <translation>Убаци табелу</translation>
    </message>
    <message>
        <location filename="../../scribus/insertTable.cpp" line="28"/>
        <source>Number of rows:</source>
        <translation>Број редова:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertTable.cpp" line="29"/>
        <source>Number of columns:</source>
        <translation>Број колона:</translation>
    </message>
</context>
<context>
    <name>JavaDocs</name>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="27"/>
        <source>Edit JavaScripts</source>
        <translation>Уређивање JavaScript-а</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="46"/>
        <source>&amp;Edit...</source>
        <translation>&amp;Уреди...</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="49"/>
        <source>&amp;Add...</source>
        <translation>&amp;Додај...</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="52"/>
        <source>&amp;Delete</source>
        <translation>&amp;Обриши</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="57"/>
        <source>&amp;Close</source>
        <translation>&amp;Затвори</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="77"/>
        <source>&amp;New Script:</source>
        <translation>&amp;Нови скрипта:</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="78"/>
        <source>New Script</source>
        <translation>Нова скрипта</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="123"/>
        <source>Do you really want to delete this script?</source>
        <translation>Да ли стварно желиш да избришеш ову скрипту?</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="71"/>
        <source>Adds a new Script, predefines a function with the same name. If you want to use this script as an &quot;Open Action&quot; script be sure not to change the name of the function.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LatexEditor</name>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="33"/>
        <source>Enter Code:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="45"/>
        <source>Update</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="52"/>
        <source>Revert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="123"/>
        <source>Program Messages:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="174"/>
        <source>Status: Unknown</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="158"/>
        <source>Kill Program</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="66"/>
        <source>Options</source>
        <translation type="unfinished">Опције</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="74"/>
        <source>Resolution:</source>
        <translation type="unfinished">Резолуција:</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="81"/>
        <source>Automatic</source>
        <translation type="unfinished">Аутоматски</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="84"/>
        <source> DPI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="97"/>
        <source>Program:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="109"/>
        <source>Use Preamble</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="336"/>
        <source>Status: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="340"/>
        <source>Error</source>
        <translation type="unfinished">Грешка</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="342"/>
        <source>Finished</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="345"/>
        <source>Running</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="522"/>
        <source>No item selected!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="14"/>
        <source>Editor</source>
        <translation type="unfinished">Уређивач</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="130"/>
        <source>Information</source>
        <translation type="unfinished">Информација</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="124"/>
        <source>An editor for this frame is already running!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="150"/>
        <source>Editor running!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="132"/>
        <source>Please specify an editor in the preferences!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="167"/>
        <source>Could not create a temporary file to run the external editor!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="148"/>
        <source>Run External Editor...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="207"/>
        <source>Running the editor failed with exitcode %d!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="225"/>
        <source>Running the editor &quot;%1&quot; failed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="523"/>
        <source>Insert Symbol</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LayerPalette</name>
    <message>
        <location filename="../../scribus/layers.cpp" line="567"/>
        <source>Layers</source>
        <translation>Слојеви</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="598"/>
        <source>Delete Layer</source>
        <translation>Обриши слој</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="588"/>
        <source>Name</source>
        <translation type="unfinished">Име</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="291"/>
        <source>Do you want to delete all objects on this layer too?</source>
        <translation>Да ли желиш да избришеш све објекте на овом слоју такође?</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="596"/>
        <source>Add a new layer</source>
        <translation type="obsolete">Додај нови слој</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="598"/>
        <source>Delete layer</source>
        <translation type="obsolete">Обриши слој</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="599"/>
        <source>Raise layer</source>
        <translation type="obsolete">Подигни слој</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="600"/>
        <source>Lower layer</source>
        <translation type="obsolete">Спусти слој</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="586"/>
        <source>Opacity:</source>
        <translation type="unfinished">Непрозирност:</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="587"/>
        <source> %</source>
        <translation type="unfinished"> %</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="568"/>
        <source>Blend Mode:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="570"/>
        <source>Normal</source>
        <translation type="unfinished">Нормално</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="571"/>
        <source>Darken</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="572"/>
        <source>Lighten</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="573"/>
        <source>Multiply</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="574"/>
        <source>Screen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="575"/>
        <source>Overlay</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="576"/>
        <source>Hard Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="577"/>
        <source>Soft Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="578"/>
        <source>Difference</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="580"/>
        <source>Color Dodge</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="581"/>
        <source>Color Burn</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="579"/>
        <source>Exclusion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="582"/>
        <source>Hue</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="583"/>
        <source>Saturation</source>
        <translation type="unfinished">Засићење</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="584"/>
        <source>Color</source>
        <translation type="unfinished">Боја</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="585"/>
        <source>Luminosity</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="603"/>
        <source>Color of the Layer Indicator - Each layer has a color assigned to display on the canvas when layer indicators are enabled. You can double click to edit the color. </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="604"/>
        <source>Make Layer Visible - Uncheck to hide the layer from the display </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="605"/>
        <source>Print Layer - Uncheck to disable printing. </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="606"/>
        <source>Lock or Unlock Layer - Unchecked is unlocked </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="607"/>
        <source>Text flows around objects in lower Layers - Enabling this forces text frames to flow around other objects, even in layers below</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="608"/>
        <source>Outline Mode - Toggles the &apos;wireframe&apos; display of objects to speed the display of very complex objects.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="601"/>
        <source>Selects the Blendmode, works only in PDF 1.4</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="602"/>
        <source>Layer Transparency, works only in PDF 1.4 and SVG</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="596"/>
        <source>Add a New Layer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="597"/>
        <source>Duplicate the Current Layer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="599"/>
        <source>Raise Layer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="600"/>
        <source>Lower Layer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="609"/>
        <source>Name of the Layer - Double click on the name of a layer to edit the name</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LegacyMode</name>
    <message>
        <location filename="../canvasmode_legacy.cpp" line="4973"/>
        <source>All Files (*)</source>
        <translation type="obsolete">Сви фајлови (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/canvasmode_legacy.cpp" line="5004"/>
        <source>Open</source>
        <translation type="unfinished">Отвори</translation>
    </message>
    <message>
        <location filename="../../scribus/canvasmode_legacy.cpp" line="4974"/>
        <source>All Supported Formats</source>
        <translation type="unfinished">Сви подржани формати</translation>
    </message>
</context>
<context>
    <name>LensDialogBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="13"/>
        <source>Optical Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="98"/>
        <source>+</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="108"/>
        <source>-</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="126"/>
        <source>Lens Parameters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="198"/>
        <source>Radius:</source>
        <translation type="obsolete">Пречник:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="55"/>
        <source>Add a new lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="58"/>
        <source>&amp;Add Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="65"/>
        <source>Remove selected lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="68"/>
        <source>&amp;Remove Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="95"/>
        <source>Zoom In</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="105"/>
        <source>Zoom Out</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="138"/>
        <source>&amp;X Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="148"/>
        <source>Horizontal position of the lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="161"/>
        <source>&amp;Y Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="171"/>
        <source>Vertical position of the lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="184"/>
        <source>The selected lens acts like a magnification lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="187"/>
        <source>&amp;Magnification Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="197"/>
        <source>The selected lens acts like a fish eye lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="200"/>
        <source>&amp;Fish Eye Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="207"/>
        <source>Ra&amp;dius:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="217"/>
        <source>Radius of the lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="230"/>
        <source>&amp;Strength:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="240"/>
        <source>Strength of the lens</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LensEffectsPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="66"/>
        <source>Lens Effects...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="70"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="90"/>
        <source>Lens Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="91"/>
        <source>Apply fancy lens effects</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LineFormate</name>
    <message>
        <location filename="../lineformats.cpp" line="33"/>
        <source>Edit Line Styles</source>
        <translation type="obsolete">Уређивање стилова линија</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="52"/>
        <source>&amp;New</source>
        <translation type="obsolete">&amp;Нови</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="55"/>
        <source>&amp;Edit</source>
        <translation type="obsolete">&amp;Уреди</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="60"/>
        <source>D&amp;uplicate</source>
        <translation type="obsolete">Д&amp;упликуј</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="64"/>
        <source>&amp;Delete</source>
        <translation type="obsolete">&amp;Обриши</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="68"/>
        <source>&amp;Save</source>
        <translation type="obsolete">&amp;Сними</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="125"/>
        <source>Copy of %1</source>
        <translation type="obsolete">Копија од %1</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="154"/>
        <source>New Style</source>
        <translation type="obsolete">Нови стил</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="216"/>
        <source>Open</source>
        <translation type="obsolete">Отвори</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="216"/>
        <source>Documents (*.sla *.sla.gz *.scd *.scd.gz);;All Files (*)</source>
        <translation type="obsolete">Документи (*.sla *.sla.gz *.scd *.scd.gz);;Сви фајлови (*)</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="49"/>
        <source>&amp;Import</source>
        <translation type="obsolete">&amp;Увези</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="194"/>
        <source>Do you really want to delete this style?</source>
        <translation type="obsolete">Да ли стварно желиш да избришеш овај стил?</translation>
    </message>
</context>
<context>
    <name>LineStyleW</name>
    <message>
        <location filename="../smlinestylew.ui" line="184"/>
        <source>%</source>
        <translation type="obsolete">%</translation>
    </message>
    <message>
        <location filename="../smlinestylew.ui" line="208"/>
        <source>Line Width:</source>
        <translation type="obsolete">Ширина линије:</translation>
    </message>
</context>
<context>
    <name>LineStyleWBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>%</source>
        <translation type="obsolete">%</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Line Width:</source>
        <translation type="obsolete">Ширина линије:</translation>
    </message>
</context>
<context>
    <name>LineStyleWidget</name>
    <message>
        <location filename="../smlinestyle.cpp" line="180"/>
        <source> pt</source>
        <translation type="obsolete"> тач.</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="52"/>
        <source>Flat Cap</source>
        <translation type="obsolete">Раван поклопац</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="53"/>
        <source>Square Cap</source>
        <translation type="obsolete">Квадратни поклопац</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="54"/>
        <source>Round Cap</source>
        <translation type="obsolete">Кружни поклопац</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="56"/>
        <source>Miter Join</source>
        <translation type="obsolete">Угаони спој</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="57"/>
        <source>Bevel Join</source>
        <translation type="obsolete">Коси спој</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="58"/>
        <source>Round Join</source>
        <translation type="obsolete">Кружни спој</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="70"/>
        <source>Add a new line</source>
        <translation type="obsolete">Додај нову линију</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="71"/>
        <source>Remove a line</source>
        <translation type="obsolete">Уклони линију</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="72"/>
        <source>Line style</source>
        <translation type="obsolete">Стил линије</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="73"/>
        <source>Line width</source>
        <translation type="obsolete">Дебљина линије</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="76"/>
        <source>Line color</source>
        <translation type="obsolete">Боја линије</translation>
    </message>
</context>
<context>
    <name>LoadSavePlugin</name>
    <message>
        <location filename="../../scribus/loadsaveplugin.cpp" line="81"/>
        <source>All Files (*)</source>
        <translation type="unfinished">Сви фајлови (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/loadsaveplugin.cpp" line="80"/>
        <source>No File Loader Plugins Found</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LoremManager</name>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="152"/>
        <source>Select Lorem Ipsum</source>
        <translation>Изабери Lorem Ipsum</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="220"/>
        <source>Author:</source>
        <translation type="unfinished">Аутор:</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="222"/>
        <source>Get More:</source>
        <translation>Добави више:</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="224"/>
        <source>XML File:</source>
        <translation>XML фајл:</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="264"/>
        <source>Lorem Ipsum</source>
        <translation>Lorem Ipsum</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="265"/>
        <source>Paragraphs:</source>
        <translation>Параграфи:</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="268"/>
        <source>Alt+O</source>
        <translation type="unfinished">Alt+O</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="270"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="271"/>
        <source>Standard Lorem Ipsum</source>
        <translation>Уоблићајни Lorem Ipsum</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="266"/>
        <source>Random Paragraphs</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="272"/>
        <source>Number of paragraphs of selected sample text to insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="273"/>
        <source>List of languages available to insert sample text in</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MarginDialog</name>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="31"/>
        <source>Manage Page Properties</source>
        <translation>Управљај својствима стране</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="39"/>
        <source>Page Size</source>
        <translation type="unfinished">Величина папира</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="44"/>
        <source>&amp;Size:</source>
        <translation type="unfinished">&amp;Величина:</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="60"/>
        <source>Orie&amp;ntation:</source>
        <translation type="unfinished">Усм&amp;ерење:</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="63"/>
        <source>Portrait</source>
        <translation type="unfinished">Усправно</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="64"/>
        <source>Landscape</source>
        <translation type="unfinished">Водоравно</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="71"/>
        <source>&amp;Width:</source>
        <translation type="unfinished">Ш&amp;ирина:</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="78"/>
        <source>&amp;Height:</source>
        <translation type="unfinished">&amp;Висина:</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="83"/>
        <source>Move Objects with their Page</source>
        <translation>Помери објекте са њиховом страном</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="89"/>
        <source>Type:</source>
        <translation type="unfinished">Врста:</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="109"/>
        <source>Margin Guides</source>
        <translation type="unfinished">Водиље маргина</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="116"/>
        <source>Other Settings</source>
        <translation>Остала подешавања</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="121"/>
        <source>Master Page:</source>
        <translation>Главна страна:</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="175"/>
        <source>Size of the inserted pages, either a standard or custom size.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="176"/>
        <source>Orientation of the page(s) to be inserted</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="177"/>
        <source>Width of the page(s) to be inserted</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="178"/>
        <source>Height of the page(s) to be inserted</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="179"/>
        <source>When inserting a new page between others, move objects with their current pages. This is the default action.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MarginWidget</name>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="43"/>
        <source>&amp;Bottom:</source>
        <translation type="unfinished">&amp;Дно:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="45"/>
        <source>&amp;Top:</source>
        <translation type="unfinished">&amp;Врх:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="212"/>
        <source>&amp;Right:</source>
        <translation type="unfinished">&amp;Десно:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="211"/>
        <source>&amp;Left:</source>
        <translation type="unfinished">&amp;Лево:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="156"/>
        <source>Distance between the top margin guide and the edge of the page</source>
        <translation type="unfinished">Растојање између водиље горње маргине и обода странице</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="157"/>
        <source>Distance between the bottom margin guide and the edge of the page</source>
        <translation type="unfinished">Растојање између водиље доње маргине и обода странице</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="211"/>
        <source>&amp;Inside:</source>
        <translation type="unfinished">&amp;Унутра:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="212"/>
        <source>O&amp;utside:</source>
        <translation type="unfinished">Спо&amp;ља:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="33"/>
        <source>Preset Layouts:</source>
        <translation>Предефинисање распореда страна:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="90"/>
        <source>Apply the margin changes to all existing pages in the document</source>
        <translation>Примени промене маргина на све постојеће стране документа</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="102"/>
        <source>Printer Margins...</source>
        <translation>Маргине штампача...</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="104"/>
        <source>Import the margins for the selected page size from the available printers.</source>
        <translation>Увези маргине за изабрану величину папира од доступних штампача.</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="79"/>
        <source>Apply settings to:</source>
        <translation>Примени подешења на:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="82"/>
        <source>All Document Pages</source>
        <translation>Све стране документа</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="86"/>
        <source>All Master Pages</source>
        <translation>Све главне стране</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="91"/>
        <source>Apply the margin changes to all existing master pages in the document</source>
        <translation>Примени промене маргина на све постојеће главне стране документа</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="108"/>
        <source>Margin Guides</source>
        <translation type="unfinished">Водиље маргина</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="126"/>
        <source>Top:</source>
        <translation>Горе:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="131"/>
        <source>Bottom:</source>
        <translation>Доле:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="143"/>
        <source>Distance for bleed from the top of the physical page</source>
        <translation type="unfinished">Растојање за цурење од врха физичке странице</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="144"/>
        <source>Distance for bleed from the bottom of the physical page</source>
        <translation type="unfinished">Растојање за цурење од дна физичке странице</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="145"/>
        <source>Distance for bleed from the left of the physical page</source>
        <translation type="unfinished">Растојање за цурење с лева физичке странице</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="146"/>
        <source>Distance for bleed from the right of the physical page</source>
        <translation type="unfinished">Растојање за цурење с десна физичке странице</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="152"/>
        <source>Bleeds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="217"/>
        <source>Inside:</source>
        <translation>Унутар:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="218"/>
        <source>Outside:</source>
        <translation>Споља:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="222"/>
        <source>Left:</source>
        <translation>Лево:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="223"/>
        <source>Right:</source>
        <translation>Десно:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="158"/>
        <source>Distance between the left margin guide and the edge of the page. If a double-sided, 3 or 4-fold layout is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="159"/>
        <source>Distance between the right margin guide and the edge of the page. If a double-sided, 3 or 4-fold layout is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MasterPagesPalette</name>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="43"/>
        <source>Edit Master Pages</source>
        <translation>Уреди главне стране</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="116"/>
        <source>Do you really want to delete this master page?</source>
        <translation type="obsolete">Да ли стварно желиш да избришеш ову главну страну?</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="177"/>
        <source>&amp;Name:</source>
        <translation type="unfinished">&amp;Име:</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="177"/>
        <source>New Master Page</source>
        <translation>Нова главна страна</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="292"/>
        <source>Name:</source>
        <translation type="unfinished">Име:</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="292"/>
        <source>New MasterPage</source>
        <translation>Нова главна страна</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="359"/>
        <source>Copy #%1 of </source>
        <translation type="unfinished">Копија #%1 од</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="98"/>
        <source>Duplicate the selected master page</source>
        <translation>Дуплирај изабрану главну страну</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="99"/>
        <source>Delete the selected master page</source>
        <translation>Избриши изабрану главну страну</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="100"/>
        <source>Add a new master page</source>
        <translation>Додај нову главну страну</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="101"/>
        <source>Import master pages from another document</source>
        <translation>Увези главну страну из другог документа</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="292"/>
        <source>New Master Page %1</source>
        <translation>Нова главна страна %1</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="449"/>
        <source>Unable to Rename Master Page</source>
        <translation>Не могу да преименујем главну страну</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="449"/>
        <source>The Normal page is not allowed to be renamed.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="453"/>
        <source>Rename Master Page</source>
        <translation>Преименуј главну страну</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="453"/>
        <source>New Name:</source>
        <translation>Ново име:</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="175"/>
        <source>Copy #%1 of %2</source>
        <translation>Копија #%1 од %2</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="139"/>
        <source>This master page is used at least once in the document.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="143"/>
        <source>Do you really want to delete master page &quot;%1&quot;?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Mdup</name>
    <message>
        <location filename="../mdup.cpp" line="29"/>
        <source>Multiple Duplicate</source>
        <translation type="obsolete">Многоструки дупликат</translation>
    </message>
    <message>
        <location filename="../mdup.cpp" line="48"/>
        <source>&amp;Number of Copies:</source>
        <translation type="obsolete">&amp;Број копија:</translation>
    </message>
    <message>
        <location filename="../mdup.cpp" line="50"/>
        <source>&amp;Horizontal Shift:</source>
        <translation type="obsolete">&amp;Водоравна промена:</translation>
    </message>
    <message>
        <location filename="../mdup.cpp" line="52"/>
        <source>&amp;Vertical Shift:</source>
        <translation type="obsolete">&amp;Усправна промена:</translation>
    </message>
</context>
<context encoding="UTF-8">
    <name>Measurements</name>
    <message>
        <location filename="../../scribus/measurements.cpp" line="127"/>
        <source>Distances</source>
        <translation type="obsolete">Удаљеност</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="129"/>
        <source>X1:</source>
        <translation type="obsolete">X1:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="130"/>
        <source>Y1:</source>
        <translation type="obsolete">Y1:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="131"/>
        <source>X2:</source>
        <translation type="obsolete">X2:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="132"/>
        <source>Y2:</source>
        <translation type="obsolete">Y2:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="133"/>
        <source>DX:</source>
        <translation type="obsolete">DX:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="134"/>
        <source>DY:</source>
        <translation type="obsolete">DY:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="135"/>
        <source>Angle:</source>
        <translation type="obsolete">Угао:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="136"/>
        <source>Length:</source>
        <translation type="obsolete">Дужина:</translation>
    </message>
    <message>
        <location filename="../measurements.cpp" line="49"/>
        <source>pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/measurements.cpp" line="51"/>
        <source> °</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MeasurementsBase</name>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="13"/>
        <source>Distances</source>
        <translation type="unfinished">Удаљеност</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="19"/>
        <source>X1:</source>
        <translation type="unfinished">X1:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="145"/>
        <source>10000.0000</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="36"/>
        <source>Y1:</source>
        <translation type="unfinished">Y1:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="53"/>
        <source>X2:</source>
        <translation type="unfinished">X2:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="70"/>
        <source>Y2:</source>
        <translation type="unfinished">Y2:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="87"/>
        <source>Length:</source>
        <translation type="unfinished">Дужина:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="104"/>
        <source>DX:</source>
        <translation type="unfinished">DX:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="121"/>
        <source>DY:</source>
        <translation type="unfinished">DY:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="138"/>
        <source>Angle:</source>
        <translation type="unfinished">Угао:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="155"/>
        <source>Unit:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MergeDoc</name>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="37"/>
        <source>Import Page(s)</source>
        <translation>Увези страницу(е)</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="75"/>
        <source> from 0</source>
        <translation> из 0</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="78"/>
        <source>Create Page(s)</source>
        <translation>Направи страницу(е)</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="135"/>
        <source>Open</source>
        <translation>Отвори</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="135"/>
        <source>Documents (*.sla *.sla.gz *.scd *.scd.gz);;All Files (*)</source>
        <translation>Документи (*.sla *.sla.gz *.scd *.scd.gz);;Сви фајлови (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="190"/>
        <source> from %1</source>
        <translation> из %1</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="48"/>
        <source>&amp;From Document:</source>
        <translation>&amp;Из документа:</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="52"/>
        <source>Chan&amp;ge...</source>
        <translation type="obsolete">Про&amp;мени...</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="55"/>
        <source>&amp;Import Page(s):</source>
        <translation>&amp;Увези страну(е):</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="82"/>
        <source>Before Page</source>
        <translation>Пре стране</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="83"/>
        <source>After Page</source>
        <translation>После стране</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="84"/>
        <source>At End</source>
        <translation>На крају</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="101"/>
        <source>&amp;Import</source>
        <translation type="unfinished">&amp;Увези</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="37"/>
        <source>Import Master Page</source>
        <translation>Увези главну страну</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="59"/>
        <source>&amp;Import Master Page</source>
        <translation>&amp;Увези главну страну</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="72"/>
        <source>Insert a comma separated list of tokens import where a token can be * for all the pages, 1-5 for a range of pages or a single page number.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="52"/>
        <source>&amp;Select...</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MeshDistortionDialog</name>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="44"/>
        <source>+</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="54"/>
        <source>-</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="13"/>
        <source>Mesh Distortion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="27"/>
        <source>Drag the red handles with the mouse to distort the mesh</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="41"/>
        <source>Zoom In</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="51"/>
        <source>Zoom Out</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="82"/>
        <source>Resets the selected handles to their initial position.
If no handle is selected all handles will be reset.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="86"/>
        <source>&amp;Reset</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MeshDistortionPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="69"/>
        <source>Mesh Distortion...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="73"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="95"/>
        <source>Mesh Distortion of Polygons</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MissingFont</name>
    <message>
        <location filename="../../scribus/missing.cpp" line="309"/>
        <source>Missing Font</source>
        <translation type="unfinished">Недостаје фонт</translation>
    </message>
    <message>
        <location filename="../../scribus/missing.cpp" line="317"/>
        <source>The Font %1 is not installed.</source>
        <translation type="unfinished">Фонт %1 није инсталиран.</translation>
    </message>
    <message>
        <location filename="../../scribus/missing.cpp" line="322"/>
        <source>Use</source>
        <translation type="unfinished">Користи</translation>
    </message>
    <message>
        <location filename="../../scribus/missing.cpp" line="336"/>
        <source>instead</source>
        <translation type="unfinished">уместо</translation>
    </message>
</context>
<context>
    <name>ModeToolBar</name>
    <message>
        <location filename="../../scribus/ui/modetoolbar.cpp" line="39"/>
        <source>Tools</source>
        <translation type="unfinished">Алати</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/modetoolbar.cpp" line="121"/>
        <source>Properties...</source>
        <translation type="unfinished">Својства...</translation>
    </message>
</context>
<context>
    <name>MovePages</name>
    <message>
        <location filename="../../scribus/movepage.cpp" line="28"/>
        <source>Move Pages</source>
        <translation>Помери странице</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="37"/>
        <source>Copy Page</source>
        <translation>Копирај страницу</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="78"/>
        <source>Move Page(s):</source>
        <translation>Помери страницу(е):</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="37"/>
        <source>Move Page(s)</source>
        <translation>Помери страницу(е)</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="68"/>
        <source>Before Page</source>
        <translation>Пре стране</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="69"/>
        <source>After Page</source>
        <translation>После стране</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="70"/>
        <source>At End</source>
        <translation>На крају</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="48"/>
        <source>To:</source>
        <translation type="unfinished">За:</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="58"/>
        <source>Number of copies:</source>
        <translation type="obsolete">Број копија:</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="58"/>
        <source>Number of Copies:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MultiLine</name>
    <message>
        <location filename="../multiline.cpp" line="32"/>
        <source>Edit Style</source>
        <translation type="obsolete">Уреди стил</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="86"/>
        <source>Flat Cap</source>
        <translation type="obsolete">Раван поклопац</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="87"/>
        <source>Square Cap</source>
        <translation type="obsolete">Квадратни поклопац</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="88"/>
        <source>Round Cap</source>
        <translation type="obsolete">Кружни поклопац</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="92"/>
        <source>Miter Join</source>
        <translation type="obsolete">Угаони спој</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="93"/>
        <source>Bevel Join</source>
        <translation type="obsolete">Коси спој</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="94"/>
        <source>Round Join</source>
        <translation type="obsolete">Кружни спој</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="100"/>
        <source>Line Width:</source>
        <translation type="obsolete">Ширина линије:</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="105"/>
        <source> pt</source>
        <translation type="obsolete"> тач.</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="118"/>
        <source> %</source>
        <translation type="obsolete"> %</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="284"/>
        <source>OK</source>
        <translation type="obsolete">У реду</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="284"/>
        <source>Name &quot;%1&quot; isn&apos;t unique.&lt;br/&gt;Please choose another.</source>
        <translation type="obsolete">Име &quot;%1&quot; није јединствено.&lt;br/&gt;Изабери неко друго.</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="270"/>
        <source>pt</source>
        <translation type="obsolete">pt</translation>
    </message>
</context>
<context>
    <name>MultiProgressDialog</name>
    <message>
        <location filename="../../scribus/multiprogressdialog.ui" line="13"/>
        <source>Progress</source>
        <translation type="unfinished">Напредовање</translation>
    </message>
    <message>
        <location filename="../../scribus/multiprogressdialog.ui" line="24"/>
        <source>Overall Progress:</source>
        <translation type="unfinished">Укупно напредовање:</translation>
    </message>
    <message>
        <location filename="../../scribus/multiprogressdialog.ui" line="67"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Откажи</translation>
    </message>
    <message>
        <location filename="../../scribus/multiprogressdialog.cpp" line="74"/>
        <source>%v of %m</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MultiProgressDialogBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Progress</source>
        <translation type="obsolete">Напредовање</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Overall Progress:</source>
        <translation type="obsolete">Укупно напредовање:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Откажи</translation>
    </message>
</context>
<context>
    <name>MultipleDuplicate</name>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="112"/>
        <source>&amp;Horizontal Shift:</source>
        <translation type="unfinished">&amp;Водоравна промена:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="165"/>
        <source>&amp;Vertical Shift:</source>
        <translation type="unfinished">&amp;Усправна промена:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.cpp" line="69"/>
        <source>&amp;Horizontal Gap:</source>
        <translation>&amp;Водоравни размак:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.cpp" line="70"/>
        <source>&amp;Vertical Gap:</source>
        <translation>&amp;Усправни размак:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="13"/>
        <source>Multiple Duplicate</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="32"/>
        <source>&amp;By Number of Copies</source>
        <translation type="unfinished">&amp;По броју жељених копија</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="50"/>
        <source>&amp;Number of Copies:</source>
        <translation type="unfinished">&amp;Број копија:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="91"/>
        <source>&amp;Shift Created Items By</source>
        <translation type="unfinished">&amp;Помери направљене ставке за</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="94"/>
        <source>Alt+S</source>
        <translation type="unfinished">Alt+S</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="81"/>
        <source>Create &amp;Gap Between Items Of</source>
        <translation type="unfinished">Направи &amp;размак између ставки од</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="84"/>
        <source>Alt+G</source>
        <translation type="unfinished">Alt+G</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="145"/>
        <source>Rotation:</source>
        <translation type="unfinished">Заокретање:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="217"/>
        <source>By &amp;Rows &amp;&amp; Columns</source>
        <translation type="unfinished">По &amp;редовима и колонама</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="245"/>
        <source>Vertical Gap:</source>
        <translation type="unfinished">Усправни размак:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="272"/>
        <source>Horizontal Gap:</source>
        <translation type="unfinished">Водоравни размак:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="289"/>
        <source>Number of Rows:</source>
        <translation type="unfinished">Број редова:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="309"/>
        <source>Number of Columns:</source>
        <translation type="unfinished">Број колона:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="383"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;У реду</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="399"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Откажи</translation>
    </message>
</context>
<context>
    <name>MultipleDuplicateBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Multiple Duplicate</source>
        <translation type="obsolete">Многострукио умножавање</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;By Number of Copies</source>
        <translation type="obsolete">&amp;По броју жељених копија</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Number of Copies:</source>
        <translation type="obsolete">&amp;Број копија:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Create &amp;Gap Between Items Of</source>
        <translation type="obsolete">Направи &amp;размак између ставки од</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Shift Created Items By</source>
        <translation type="obsolete">&amp;Помери направљене ставке за</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Horizontal Shift:</source>
        <translation type="obsolete">&amp;Водоравно померање:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Vertical Shift:</source>
        <translation type="obsolete">&amp;Усправно померање:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>By &amp;Rows &amp;&amp; Columns</source>
        <translation type="obsolete">По &amp;редовима и колонама</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Vertical Gap:</source>
        <translation type="obsolete">Усправни размак:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Horizontal Gap:</source>
        <translation type="obsolete">Водоравни размак:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Number of Rows:</source>
        <translation type="obsolete">Број редова:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Number of Columns:</source>
        <translation type="obsolete">Број колона:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;У реду</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Откажи</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Rotation:</source>
        <translation type="obsolete">Заокретање:</translation>
    </message>
</context>
<context>
    <name>MyPlugin</name>
    <message>
        <location filename="../../scribus/plugins/myplugin/myplugin.cpp" line="31"/>
        <source>My &amp;Plugin</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MyPluginImpl</name>
    <message>
        <location filename="../../scribus/plugins/myplugin/mypluginimpl.cpp" line="23"/>
        <source>Scribus - My Plugin</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/myplugin/mypluginimpl.cpp" line="24"/>
        <source>The plugin worked!</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>NewDoc</name>
    <message>
        <location filename="../../scribus/newfile.cpp" line="101"/>
        <source>New Document</source>
        <translation>Нови документ</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="225"/>
        <source>&amp;Size:</source>
        <translation>&amp;Величина:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="234"/>
        <source>Orie&amp;ntation:</source>
        <translation>Усм&amp;ерење:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="237"/>
        <source>Portrait</source>
        <translation>Усправно</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="238"/>
        <source>Landscape</source>
        <translation>Водоравно</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="244"/>
        <source>&amp;Width:</source>
        <translation>Ш&amp;ирина:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="250"/>
        <source>&amp;Height:</source>
        <translation>&amp;Висина:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="266"/>
        <source>Margin Guides</source>
        <translation>Водиље маргина</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="285"/>
        <source>Options</source>
        <translation>Опције</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="298"/>
        <source>&amp;Default Unit:</source>
        <translation>&amp;Подразумевана јединица:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="308"/>
        <source>&amp;Automatic Text Frames</source>
        <translation>&amp;Аутоматски текстуални оквир</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="318"/>
        <source>&amp;Gap:</source>
        <translation>&amp;Процеп:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="310"/>
        <source>Colu&amp;mns:</source>
        <translation>&amp;Колоне:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="144"/>
        <source>Document page size, either a standard size or a custom size</source>
        <translation>Величина странице документа, или стандардна величина или произвољна величина</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="145"/>
        <source>Orientation of the document&apos;s pages</source>
        <translation>Усмерење страница документа</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="146"/>
        <source>Width of the document&apos;s pages, editable if you have chosen a custom page size</source>
        <translation>Ширина страница документа, подложна изменама ако изаберете произвољну величину странице</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="147"/>
        <source>Height of the document&apos;s pages, editable if you have chosen a custom page size</source>
        <translation>Висина страница документа, подложна изменама ако изаберете произвољну величину странице</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="149"/>
        <source>Default unit of measurement for document editing</source>
        <translation>Подразумевана јединица мере за уређивање документа</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="150"/>
        <source>Create text frames automatically when new pages are added</source>
        <translation>Направи текстуалне оквире аутоматски при додавању нових страница</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="151"/>
        <source>Number of columns to create in automatically created text frames</source>
        <translation>Број колона у аутоматски направљеним текстуалним оквирима</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="152"/>
        <source>Distance between automatically created columns</source>
        <translation>Растојање између аутоматски направљених колона</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="130"/>
        <source>Do not show this dialog again</source>
        <translation>Не приказуј овај прозор поново</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="148"/>
        <source>Initial number of pages of the document</source>
        <translation>Почетни број страна документа</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="292"/>
        <source>N&amp;umber of Pages:</source>
        <translation>Б&amp;рој страна:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="371"/>
        <source>Open</source>
        <translation type="unfinished">Отвори</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="111"/>
        <source>&amp;New Document</source>
        <translation>&amp;Нови документ</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="116"/>
        <source>Open &amp;Existing Document</source>
        <translation>Отвори &amp;Постојећи документ</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="119"/>
        <source>Open Recent &amp;Document</source>
        <translation>Отвори скорашњи документ</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="257"/>
        <source>First Page is:</source>
        <translation>Прва страна је:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="330"/>
        <source>Show Document Settings After Creation</source>
        <translation>Прикажи поставке документа након што је документ направљен</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="182"/>
        <source>Document Layout</source>
        <translation>Шема распореда страна у документу</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="114"/>
        <source>New &amp;from Template</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>NewFromPlugin</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Start a document from a template made by other users or yourself (f.e. for documents you have a constant style).</source>
        <translation type="obsolete">Начини документ из шаблона који је направио други корисник или ти сам (нпр. документи где имаш стилове које би поново користио)</translation>
    </message>
</context>
<context>
    <name>NewFromTemplatePlugin</name>
    <message>
        <location filename="../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="59"/>
        <source>New &amp;from Template...</source>
        <translation type="unfinished">Нови &amp;из шаблона...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="79"/>
        <source>Load documents with predefined layout</source>
        <translation>Учитај документ са унапред одређеном шемом</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="81"/>
        <source>Start a document from a template made by other users or yourself (f.e. for documents you have a constant style).</source>
        <translation type="unfinished">Начини документ из шаблона који је направио други корисник или ти сам (нпр. документи где имаш стилове које би поново користио)</translation>
    </message>
</context>
<context>
    <name>NodePalette</name>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="897"/>
        <source>Nodes</source>
        <translation>Нодови</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="900"/>
        <source>&amp;Absolute Coordinates</source>
        <translation>&amp;Апсолутне координате</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="903"/>
        <source>&amp;X-Pos:</source>
        <translation>&amp;X Позиција:</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="904"/>
        <source>&amp;Y-Pos:</source>
        <translation>&amp;Y Позиција:</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="905"/>
        <source>Edit &amp;Contour Line</source>
        <translation>Уреди &amp;контуру</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="906"/>
        <source>&amp;Reset Contour Line</source>
        <translation>&amp;Ресетуј контуру</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="909"/>
        <source>&amp;End Editing</source>
        <translation>&amp;Крај уређивања</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="910"/>
        <source>Move Nodes</source>
        <translation>Помери нодове</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="911"/>
        <source>Move Control Points</source>
        <translation>Помери контролне тачке</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="912"/>
        <source>Add Nodes</source>
        <translation>Додај нодове</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="913"/>
        <source>Delete Nodes</source>
        <translation>Обриши нодове</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="914"/>
        <source>Move Control Points Independently</source>
        <translation>Помери контролне тачке независно</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="915"/>
        <source>Move Control Points Symmetrical</source>
        <translation>Помери контролне тачке симетрично</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="916"/>
        <source>Reset Control Points</source>
        <translation>Ресетуј контролне тачке</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="917"/>
        <source>Reset this Control Point</source>
        <translation>Ресетуј ову контролну тачку</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="918"/>
        <source>Open a Polygon or Cuts a Bezier Curve</source>
        <translation>Отвори полигон или исеци bezier криву</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="919"/>
        <source>Close this Bezier Curve</source>
        <translation>Затвори ову bezier криву</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="920"/>
        <source>Mirror the Path Horizontally</source>
        <translation>Окрени путању водоравно</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="921"/>
        <source>Mirror the Path Vertically</source>
        <translation>Окрени путању усправно</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="922"/>
        <source>Shear the Path Horizontally to the Right</source>
        <translation>Развуци путању водоравно на десно</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="923"/>
        <source>Shear the Path Horizontally to the Left</source>
        <translation>Развуци путању водоравно на лево</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="924"/>
        <source>Shear the Path Vertically Up</source>
        <translation>Развуци путању усправно на горе</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="925"/>
        <source>Shear the Path Vertically Down</source>
        <translation>Развуци путању усправно на доле</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="926"/>
        <source>Rotate the Path Counter-Clockwise</source>
        <translation>Ротирај путању супротно од смера казаљке на часовнику</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="927"/>
        <source>Rotate the Path Clockwise</source>
        <translation>Ротирај путању у смеру казаљке на часовнику</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="929"/>
        <source>Enlarge the Size of the Path by shown %</source>
        <translation>Повећај величину путање за приказаних %</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="932"/>
        <source>Angle of Rotation</source>
        <translation>Угао ротације</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="935"/>
        <source>Activate Contour Line Editing Mode</source>
        <translation>Активирај режим уређивања контура</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="936"/>
        <source>Reset the Contour Line to the Original Shape of the Frame</source>
        <translation>Ресетуј контуре на оригинални облик оквира</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="898"/>
        <source> %</source>
        <translation type="unfinished"> %</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="939"/>
        <source>When checked use coordinates relative to the page, otherwise coordinates are relative to the Object.</source>
        <translation>Када је изабрано, користе се координате стране, у супротном, координате се постављају у односу на објекат.</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="928"/>
        <source>Shrink the Size of the Path by shown %</source>
        <translation>Повећај стазу за приказаних %</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="930"/>
        <source>Reduce the Size of the Path by the shown value</source>
        <translation>Смањи стазу за приказану вредност</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="931"/>
        <source>Enlarge the Size of the Path by the shown value</source>
        <translation>Повећај стазу за приказану вредност</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="933"/>
        <source>% to Enlarge or Shrink By</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="934"/>
        <source>Value to Enlarge or Shrink By</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="907"/>
        <source>Set Contour to Image Clip</source>
        <translation>Постави контуру по одсецању слике</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="937"/>
        <source>Reset the Contour Line to the Clipping Path of the Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="901"/>
        <source>to Canvas</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="902"/>
        <source>to Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="908"/>
        <source>Set Shape to Image Clip</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="938"/>
        <source>Set the Shape to the Clipping Path of the Image</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OODPlug</name>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="300"/>
        <source>This document does not seem to be an OpenOffice Draw file.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="619"/>
        <source>Group%1</source>
        <translation>Група%1</translation>
    </message>
</context>
<context>
    <name>OODrawImportPlugin</name>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="97"/>
        <source>Import &amp;OpenOffice.org Draw...</source>
        <translation>Увези &amp;OpenOffice.org Draw...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="112"/>
        <source>Imports OpenOffice.org Draw Files</source>
        <translation>Увези &amp;OpenOffice.org Draw фајлове</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="113"/>
        <source>Imports most OpenOffice.org Draw files into the current document, converting their vector data into Scribus objects.</source>
        <translation>Увози већину OpenOffice.org Draw фајлове у текући документ, претварајући њихове векторске податке у Скрибусове објекте.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="127"/>
        <source>OpenDocument 1.0 Draw</source>
        <comment>Import/export format name</comment>
        <translation>OpenDocument 1.0 Draw</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="139"/>
        <source>OpenOffice.org 1.x Draw</source>
        <comment>Import/export format name</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="211"/>
        <source>This file contains some unsupported features</source>
        <translation>Фајл садржи неке неподржане функције</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="209"/>
        <source>The file could not be imported</source>
        <translation>Не могу да увезем фајл</translation>
    </message>
</context>
<context>
    <name>OdtDialog</name>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="43"/>
        <source>OpenDocument Importer Options</source>
        <translation>Опције увозника OpenDocument фајлова</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="52"/>
        <source>Overwrite Paragraph Styles</source>
        <translation>Написати преко стила параграфа</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="54"/>
        <source>Enabling this will overwrite existing styles in the current Scribus document</source>
        <translation>Омогућење овога ће дозволити писање преко постојећих стилова  текућег Скрибусовог документа</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="61"/>
        <source>Merge Paragraph Styles</source>
        <translation>Сједини стилове параграфа</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="63"/>
        <source>Merge paragraph styles by attributes. This will result in fewer similar paragraph styles, will retain style attributes, even if the original document&apos;s styles are named differently.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="70"/>
        <source>Use document name as a prefix for paragraph styles</source>
        <translation type="unfinished">Користи име документа као префикс за стилове пасуса</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="72"/>
        <source>Prepend the document name to the paragraph style name in Scribus.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="79"/>
        <source>Do not ask again</source>
        <translation type="unfinished">Не питај опет</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="81"/>
        <source>Make these settings the default and do not prompt again when importing an OASIS OpenDocument.</source>
        <translation>Постави ова подешења као подразумевана и не питај поново при увозу OASIS OpenDocument формата.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="90"/>
        <source>OK</source>
        <translation type="unfinished">У реду</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="92"/>
        <source>Cancel</source>
        <translation type="unfinished">Поништи</translation>
    </message>
</context>
<context>
    <name>OldScribusFormat</name>
    <message>
        <location filename="../../scribus/plugins/fileloader/oldscribusformat/oldscribusformat.cpp" line="59"/>
        <source>Scribus Document</source>
        <translation type="unfinished">Scribus документ</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oldscribusformat/oldscribusformat.cpp" line="70"/>
        <source>Scribus 1.2.x Document</source>
        <translation>Документ Скрибуса 1.2.x</translation>
    </message>
</context>
<context>
    <name>OneClick</name>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="37"/>
        <source>Origin</source>
        <translation>Порекло</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="54"/>
        <source>Size</source>
        <translation type="unfinished">Величина</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="59"/>
        <source>Width:</source>
        <translation type="unfinished">Ширина:</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="61"/>
        <source>Length:</source>
        <translation type="unfinished">Дужина:</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="69"/>
        <source>Height:</source>
        <translation type="unfinished">Висина:</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="71"/>
        <source>Angle:</source>
        <translation type="unfinished">Угао:</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="101"/>
        <source>Remember Values</source>
        <translation>Запамти вредности</translation>
    </message>
</context>
<context>
    <name>OutlinePalette</name>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="908"/>
        <source>Element</source>
        <translation type="unfinished">Елемент</translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="287"/>
        <source>Name &quot;%1&quot; isn&apos;t unique.&lt;br/&gt;Please choose another.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="876"/>
        <source>Group </source>
        <translation type="unfinished">Група </translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="751"/>
        <source>Page </source>
        <translation type="unfinished">Страница</translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="806"/>
        <source>Free Objects</source>
        <translation type="unfinished">Слободни објекти</translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="907"/>
        <source>Outline</source>
        <translation type="unfinished">Контура</translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="140"/>
        <source>Enter a keyword or regular expression to filter the outline.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="909"/>
        <source>Filter:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="141"/>
        <source>Ctrl+F</source>
        <comment>Filter the Outline using a keyword</comment>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OutlineValues</name>
    <message>
        <location filename="../../scribus/styleselect.cpp" line="97"/>
        <source> %</source>
        <translation type="unfinished"> %</translation>
    </message>
    <message>
        <location filename="../../scribus/styleselect.cpp" line="98"/>
        <source>Linewidth</source>
        <translation>Дужина реда</translation>
    </message>
</context>
<context>
    <name>PDFExportDialog</name>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="152"/>
        <source>Save as PDF</source>
        <translation>Сачувај као  PDF</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="65"/>
        <source>O&amp;utput to File:</source>
        <translation type="unfinished">Из&amp;лаз у фајл:</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="94"/>
        <source>Cha&amp;nge...</source>
        <translation type="unfinished">Изме&amp;ни...</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="97"/>
        <source>Output one file for eac&amp;h page</source>
        <translation>Извези по један фајл за сваку страну</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="110"/>
        <source>&amp;Save</source>
        <translation type="unfinished">&amp;Сними</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="204"/>
        <source>Save as</source>
        <translation type="obsolete">Сними као</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="204"/>
        <source>PDF Files (*.pdf);;All Files (*)</source>
        <translation type="unfinished">PDF фајлови (*.pdf);;Сви фајлови (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="122"/>
        <source>This enables exporting one individually named PDF file for each page in the document. Page numbers are added automatically. This is most useful for imposing PDF for commercial printing.</source>
        <translation>Извоз PDF фајла јединственог имена за сваку страну документа. Бројеви страна се додају аутоматски. Ово је најкорисније користити за PDF-ове намењене за комерцијалну штампу.</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="123"/>
        <source>The save button will be disabled if you are trying to export PDF/X-3 and the info string is missing from the PDF/X-3 tab.</source>
        <translation>Дугме за снимање неће бити доступно при покушају извоза PDF/X-3 ако  \&quot;info string\&quot; није попуњен у PDF/X-3 страници.</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="153"/>
        <source>%1 does not exists and will be created, continue?</source>
        <translation>%1 не постоји и биће направљен, наставити?</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="170"/>
        <source>Cannot create directory: 
%1</source>
        <translation>Не могу да направим директоријум: 
%1</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="204"/>
        <source>Save As</source>
        <translation type="unfinished">Сними као</translation>
    </message>
</context>
<context>
    <name>PDFLibCore</name>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="135"/>
        <source>Saving PDF</source>
        <translation type="unfinished">Снимам PDF</translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="139"/>
        <source>Exporting Master Page:</source>
        <translation type="unfinished">Извозим главне стране:</translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="139"/>
        <source>Exporting Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="139"/>
        <source>Exporting Items on Current Page:</source>
        <translation type="unfinished">Извозим ставке са текуће стране:</translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="2470"/>
        <source>Page:</source>
        <translation type="unfinished">Страна:</translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="2483"/>
        <source>Date:</source>
        <translation type="unfinished">Датум:</translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7753"/>
        <source>Failed to load an image : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7758"/>
        <source>Failed to write an image : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7763"/>
        <source>Failed to load an image mask : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7768"/>
        <source>Insufficient memory for processing an image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7748"/>
        <source>A write error occurred, please check available disk space</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PDFToolBar</name>
    <message>
        <location filename="../../scribus/ui/pdftoolbar.cpp" line="29"/>
        <source>PDF Tools</source>
        <translation type="unfinished">PDF алати</translation>
    </message>
</context>
<context>
    <name>PDFlib</name>
    <message>
        <location filename="../pdflib.cpp" line="119"/>
        <source>Saving PDF</source>
        <translation type="obsolete">Снимам PDF</translation>
    </message>
    <message>
        <location filename="../pdflib.cpp" line="123"/>
        <source>Exporting Items on Current Page:</source>
        <translation type="obsolete">Извозим ставке са текуће стране:</translation>
    </message>
    <message>
        <location filename="../pdflib.cpp" line="123"/>
        <source>Exporting Master Page:</source>
        <translation type="obsolete">Извозим главне стране:</translation>
    </message>
    <message>
        <location filename="../pdflib.cpp" line="123"/>
        <source>Exporting Page:</source>
        <translation type="obsolete">Извозим страну:</translation>
    </message>
    <message>
        <location filename="../pdflib.cpp" line="2275"/>
        <source>Page:</source>
        <translation type="obsolete">Страна:</translation>
    </message>
    <message>
        <location filename="../pdflib.cpp" line="2288"/>
        <source>Date:</source>
        <translation type="obsolete">Датум:</translation>
    </message>
</context>
<context>
    <name>PPreview</name>
    <message>
        <location filename="../../scribus/preview.cpp" line="82"/>
        <source>Print Preview</source>
        <translation>Преглед пре штампања</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="134"/>
        <source>Display Trans&amp;parency</source>
        <translation>Прикажи провидн&amp;ост</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="278"/>
        <source>&amp;Under Color Removal</source>
        <translation>&amp;Под уклањањем боја</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="139"/>
        <source>&amp;Display CMYK</source>
        <translation>&amp;Прикажи CMYK</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="236"/>
        <source>&amp;C</source>
        <translation>&amp;C</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="241"/>
        <source>&amp;M</source>
        <translation>&amp;M</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="246"/>
        <source>&amp;Y</source>
        <translation>&amp;Y</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="251"/>
        <source>&amp;K</source>
        <translation>&amp;K</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="356"/>
        <source>Shows transparency and transparent items in your document. Requires Ghostscript 7.07 or later</source>
        <translation>Приказује провидност и провидне ставке у Вашем документу. Захтева Ghostscript 7.07 или новији</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="357"/>
        <source>Gives a print preview using simulations of generic CMYK inks, instead of RGB colors</source>
        <translation>Даје преглед за штампу користећи симулацију генеричких CMYK мастила, уместо RGB боја</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="380"/>
        <source>Enable/disable the C (Cyan) ink plate</source>
        <translation>Укључи/искључи C (Цијан) палету мастила</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="381"/>
        <source>Enable/disable the M (Magenta) ink plate</source>
        <translation>Укључи/искључи М (Магента) палету мастила</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="382"/>
        <source>Enable/disable the Y (Yellow) ink plate</source>
        <translation>Укључи/искључи Y (Жута) палету мастила</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="383"/>
        <source>Enable/disable the K (Black) ink plate</source>
        <translation>Укључи/искључи К (Црна) палету мастила</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="691"/>
        <source>All</source>
        <translation>Све</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="152"/>
        <source>Separation Name</source>
        <translation>Име издвајања</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="164"/>
        <source>Cyan</source>
        <translation type="unfinished">Цијан</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="171"/>
        <source>Magenta</source>
        <translation type="unfinished">Магента</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="178"/>
        <source>Yellow</source>
        <translation type="unfinished">Жута</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="185"/>
        <source>Black</source>
        <translation type="unfinished">Црна</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="299"/>
        <source>Scaling:</source>
        <translation>Скалирање:</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="327"/>
        <source>Print...</source>
        <translation type="unfinished">Штампај...</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="358"/>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis. UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation>Начин замене неких нијанси сиве које су састављене од цијана, жуте и магенте и коришћење црне уместо њих. UCR (смањење засићења бојом) углавном утиче на делове слика које су неутрални или тамних тонова који су врло близу сивој. Коришћење ове опције може умногоме побољшати неке слике и захтева одређено експериментисање и пробе од слушаја до случаја. UCR смањује могућност презасићења CMY бојама.</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="359"/>
        <source>Resize the scale of the page.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="324"/>
        <source>Close</source>
        <translation type="unfinished">Затвори</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="1256"/>
        <source>File</source>
        <translation type="unfinished">Фајл</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="129"/>
        <source>Enable &amp;Antialiasing</source>
        <translation>Одобри &amp;ублажабање</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="311"/>
        <source>Fit to Width</source>
        <translation>Углави у ширину</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="312"/>
        <source>Fit to Height</source>
        <translation>Углави у висину</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="313"/>
        <source>Fit to Page</source>
        <translation>Углави целу страну</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="355"/>
        <source>Provides a more pleasant view of Type 1 fonts, TrueType Fonts, OpenType Fonts, EPS, PDF and vector graphics in the preview, at the expense of a slight slowdown in previewing</source>
        <translation>Омогућава много пријатнији доживљај Type 1, TrueType и OpenType фонтова, EPS, PDF и векторске графике у прегледу, али по цени мало споријег прегледа</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="123"/>
        <source>Display Settings</source>
        <translation>Подешења приказа</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="260"/>
        <source>Print Settings</source>
        <translation>Подешења штампе</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="266"/>
        <source>Mirror Page(s) Horizontal</source>
        <translation>Изврни страну(е) водоравно</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="269"/>
        <source>Mirror Page(s) Vertical</source>
        <translation>Изврни страну(е) усправно</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="242"/>
        <source>Clip to Page Margins</source>
        <translation type="obsolete">Одсеци до маргина стране</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="275"/>
        <source>Print in Grayscale</source>
        <translation>Штампај у нијансама сиве</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="281"/>
        <source>Convert Spot Colors</source>
        <translation>Преведи спот боје</translation>
    </message>
    <message>
        <location filename="../preview.cpp" line="255"/>
        <source>Apply ICC Profiles</source>
        <translation type="obsolete">Примени ICC профиле</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="360"/>
        <source>Enables Spot Colors to be converted to composite colors. Unless you are planning to print spot colors at a commercial printer, this is probably best left enabled.</source>
        <translation>Омогућава да спот боје буду преведене у композитне боје. Уколико је планирано да се штампање врши у комерцијалној штампи, најбоље је оставити омогућено.</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="284"/>
        <source>Apply Color Profiles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="361"/>
        <source>Allows you to embed color profiles in the print stream when color management is enabled</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="272"/>
        <source>Clip to Printer Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="206"/>
        <source>Display Ink Coverage</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="214"/>
        <source>Threshold:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="217"/>
        <source> %</source>
        <translation type="unfinished"> %</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="221"/>
        <source>None</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PSLib</name>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1839"/>
        <source>Processing Master Page:</source>
        <translation>Обрађујем главне стране:</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1839"/>
        <source>Exporting Page:</source>
        <translation>Извозим стране:</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1772"/>
        <source>Failed to write data for an image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1777"/>
        <source>Failed to load an image : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1782"/>
        <source>Failed to load an image mask : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1787"/>
        <source>Insufficient memory for processing an image</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PStyleW</name>
    <message>
        <location filename="../smpstylew.ui" line="13"/>
        <source>Form1</source>
        <translation type="obsolete">Формулар1</translation>
    </message>
    <message>
        <location filename="../smpstylew.ui" line="26"/>
        <source>Properties</source>
        <translation type="obsolete">Својства</translation>
    </message>
    <message>
        <location filename="../smpstylew.ui" line="46"/>
        <source>Tabulators and Indentation</source>
        <translation type="obsolete">Табулатори и увлачење</translation>
    </message>
    <message>
        <location filename="../smpstylew.ui" line="104"/>
        <source>Distances and Alignment</source>
        <translation type="obsolete">Удаљености и поравнања</translation>
    </message>
    <message>
        <location filename="../smpstylew.ui" line="190"/>
        <source>Ch&amp;aracter Style</source>
        <translation type="obsolete">Стилови зн&amp;акова</translation>
    </message>
</context>
<context>
    <name>PStyleWBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Properties</source>
        <translation type="obsolete">Својства</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Distances and Alignment</source>
        <translation type="obsolete">Удаљености и поравнања</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Tabulators and Indentation</source>
        <translation type="obsolete">Табулатори и увлачење</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Ch&amp;aracter Style</source>
        <translation type="obsolete">Стилови зн&amp;акова</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Based On:</source>
        <translation type="obsolete">Заснива се на:</translation>
    </message>
</context>
<context>
    <name>PageItem</name>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="388"/>
        <source>Image</source>
        <translation>Слика</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="392"/>
        <source>Text</source>
        <translation>Текст</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="396"/>
        <source>Line</source>
        <translation>Линија</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="400"/>
        <source>Polygon</source>
        <translation>Полигон</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="404"/>
        <source>Polyline</source>
        <translation>Полилинија</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="408"/>
        <source>PathText</source>
        <translation>Текста путање</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="3724"/>
        <source>Copy of</source>
        <translation type="unfinished">Копија</translation>
    </message>
</context>
<context>
    <name>PageItemAttributes</name>
    <message>
        <location filename="../../scribus/pageitemattributes.cpp" line="21"/>
        <source>Relates To</source>
        <translation>Односи се на</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.cpp" line="21"/>
        <source>Is Parent Of</source>
        <translation>је предак</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.cpp" line="21"/>
        <source>Is Child Of</source>
        <translation>је наследник</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <comment>



relationship</comment>
        <translation type="obsolete">Ниједан</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.cpp" line="21"/>
        <source>None</source>
        <comment>relationship</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="58"/>
        <source>&amp;Add</source>
        <translation type="unfinished">&amp;Додај</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="61"/>
        <source>Alt+A</source>
        <translation type="unfinished">Alt+A</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="68"/>
        <source>&amp;Copy</source>
        <translation type="unfinished">&amp;Копирај</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="71"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="78"/>
        <source>&amp;Delete</source>
        <translation type="unfinished">&amp;Обриши</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="81"/>
        <source>Alt+D</source>
        <translation type="unfinished">Alt+D</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="88"/>
        <source>C&amp;lear</source>
        <translation type="unfinished">Оч&amp;исти</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="91"/>
        <source>Alt+L</source>
        <translation type="unfinished">Alt+L</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="114"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;У реду</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="130"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Откажи</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="23"/>
        <source>Name</source>
        <translation type="unfinished">Име</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="28"/>
        <source>Type</source>
        <translation type="unfinished">Врста</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="33"/>
        <source>Value</source>
        <translation type="unfinished">Вредност</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="38"/>
        <source>Parameter</source>
        <translation type="unfinished">Парамета</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="43"/>
        <source>Relationship</source>
        <translation type="unfinished">Однос</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="48"/>
        <source>Relationship To</source>
        <translation type="unfinished">Однос према</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="13"/>
        <source>Attributes</source>
        <translation type="unfinished">Атрибути</translation>
    </message>
</context>
<context>
    <name>PageItemAttributesBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Name</source>
        <translation type="obsolete">Име</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Type</source>
        <translation type="obsolete">Врста</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Value</source>
        <translation type="obsolete">Вредност</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Relationship</source>
        <translation type="obsolete">Однос</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Relationship To</source>
        <translation type="obsolete">Однос према</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Add</source>
        <translation type="obsolete">&amp;Додај</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Copy</source>
        <translation type="obsolete">&amp;Копирај</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Delete</source>
        <translation type="obsolete">&amp;Обриши</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+D</source>
        <translation type="obsolete">Alt+D</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>C&amp;lear</source>
        <translation type="obsolete">Оч&amp;исти</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+L</source>
        <translation type="obsolete">Alt+L</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;У реду</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Откажи</translation>
    </message>
</context>
<context>
    <name>PageItem_ImageFrame</name>
    <message>
        <location filename="../pageitem_imageframe.cpp" line="244"/>
        <source>Picture</source>
        <translation type="obsolete">Слика</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="394"/>
        <source>Preview Settings</source>
        <translation type="obsolete">Подешења прегледа</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="464"/>
        <source>Image</source>
        <translation type="unfinished">Слика</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="470"/>
        <source>Embedded Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="499"/>
        <source>File:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="473"/>
        <source>Original PPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="474"/>
        <source>Actual PPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="104"/>
        <source>Size:</source>
        <translation type="unfinished">Величина:</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="475"/>
        <source>Colorspace:</source>
        <translation type="unfinished">Простор боја:</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="479"/>
        <source>Unknown</source>
        <translation type="unfinished">Непознат</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="486"/>
        <source>Page:</source>
        <translation type="unfinished">Страна:</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="488"/>
        <source>Pages:</source>
        <translation type="unfinished">Стране:</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="497"/>
        <source>Embedded Image missing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="499"/>
        <source>missing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="502"/>
        <source>No Image Loaded</source>
        <translation type="unfinished">Нема учитане слике</translation>
    </message>
</context>
<context>
    <name>PageItem_LatexFrame</name>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="565"/>
        <source>Error</source>
        <translation type="unfinished">Грешка</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="166"/>
        <source>Running the external application failed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="239"/>
        <source>Could not create a temporary file to run the application!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="248"/>
        <source>Information</source>
        <translation type="obsolete">Информација</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="415"/>
        <source>Running the application &quot;%1&quot; failed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../pageitem_latexframe.cpp" line="647"/>
        <source>OK</source>
        <translation type="obsolete">У реду</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="570"/>
        <source>Running</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="405"/>
        <source>The application &quot;%1&quot; failed to start!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="409"/>
        <source>The application &quot;%1&quot; crashed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="559"/>
        <source>Application</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="560"/>
        <source>DPI</source>
        <translation type="unfinished">тпи</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="562"/>
        <source>State</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="567"/>
        <source>Finished</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="44"/>
        <source>Render</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="260"/>
        <source>The config file didn&apos;t specify a executable path!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="558"/>
        <source>Render Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="224"/>
        <source>No configuration defined to run the application!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="421"/>
        <source>No application defined</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="130"/>
        <source>Rendering...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="139"/>
        <source>Render Error</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PageItem_PathText</name>
    <message>
        <location filename="../../scribus/pageitem_pathtext.cpp" line="319"/>
        <source>Paragraphs: </source>
        <translation type="unfinished">Пасуси: </translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_pathtext.cpp" line="327"/>
        <source>Lines: </source>
        <translation type="unfinished">Линија:</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_pathtext.cpp" line="333"/>
        <source>Words: </source>
        <translation type="unfinished">Речи: </translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_pathtext.cpp" line="341"/>
        <source>Chars: </source>
        <translation type="unfinished">Карактери: </translation>
    </message>
</context>
<context>
    <name>PageItem_TextFrame</name>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3471"/>
        <source>Linked Text</source>
        <translation type="unfinished">Повезан текст</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3473"/>
        <source>Text Frame</source>
        <translation type="unfinished">Текстуални оквир</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3477"/>
        <source>Paragraphs: </source>
        <translation type="unfinished">Пасуси: </translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3485"/>
        <source>Lines: </source>
        <translation type="unfinished">Линија:</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3491"/>
        <source>Words: </source>
        <translation type="unfinished">Речи: </translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3499"/>
        <source>Chars: </source>
        <translation type="unfinished">Карактери: </translation>
    </message>
</context>
<context>
    <name>PageLayouts</name>
    <message>
        <location filename="../../scribus/pagelayout.cpp" line="266"/>
        <source>First Page is:</source>
        <translation>Прва страна је:</translation>
    </message>
    <message>
        <location filename="../../scribus/pagelayout.cpp" line="197"/>
        <source>Document Layout</source>
        <translation>Шема распореда страна у документу</translation>
    </message>
    <message>
        <location filename="../../scribus/pagelayout.cpp" line="268"/>
        <source>Number of pages to show side-by-side on the canvas
Often used for allowing items to be placed across page spreads</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagelayout.cpp" line="273"/>
        <source>Location on the canvas where the first page of the document is placed</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PagePalette</name>
    <message>
        <location filename="../pagepalette.cpp" line="533"/>
        <source>Double sided</source>
        <translation type="obsolete">Двострано</translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="933"/>
        <source>Arrange Pages</source>
        <translation type="unfinished">Намести странице</translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="934"/>
        <source>Available Master Pages:</source>
        <translation>Доступне главне стране:</translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="935"/>
        <source>Document Pages:</source>
        <translation type="unfinished">Странице документа:</translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="938"/>
        <source>List of normal pages in the document, shown with the document layout. Pages may be dragged to rearrange or delete them.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="939"/>
        <source>Drag pages or master pages onto the trash to delete them</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="937"/>
        <source>List of master pages in the document. Master page names may be dragged onto the page view below to apply master pages, or onto the empty space between pages to create new pages.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="628"/>
        <source>This master page is used at least once in the document.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="632"/>
        <source>Do you really want to delete this master page?</source>
        <translation type="unfinished">Да ли стварно желиш да избришеш ову главну страну?</translation>
    </message>
</context>
<context>
    <name>PageSelector</name>
    <message>
        <location filename="../../scribus/pageselector.cpp" line="266"/>
        <source>%1 of %2</source>
        <translation type="obsolete">%1 од %2</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>%1 of %1</source>
        <translation type="obsolete">%1 од %1</translation>
    </message>
    <message>
        <location filename="../../scribus/pageselector.cpp" line="267"/>
        <source>Go to the first page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageselector.cpp" line="268"/>
        <source>Go to the previous page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageselector.cpp" line="269"/>
        <source>Go to the next page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageselector.cpp" line="270"/>
        <source>Go to the last page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageselector.cpp" line="271"/>
        <source>Select the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageselector.cpp" line="272"/>
        <source> of %1</source>
        <comment>number of pages in document</comment>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ParaStyleComboBox</name>
    <message>
        <location filename="../../scribus/spalette.cpp" line="62"/>
        <source>No Style</source>
        <translation type="unfinished">Нема стила</translation>
    </message>
</context>
<context>
    <name>PathAlongPathPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="69"/>
        <source>Path Along Path...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="73"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="96"/>
        <source>Bends a Polygon along a Polyline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="97"/>
        <source>This plugin bends a Polygon with the help of a Polyline.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathConnectDialogBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="13"/>
        <source>Connect Paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="48"/>
        <source>Starting Point</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="53"/>
        <source>End Point</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="69"/>
        <source>a straight Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="74"/>
        <source>Points moving</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="82"/>
        <source>Preview on Canvas</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="19"/>
        <source>Connect First Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="40"/>
        <source>with Second Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="61"/>
        <source>by using:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathConnectPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="90"/>
        <source>Connect Paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="69"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="91"/>
        <source>Connect 2 Polylines.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathCutPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="70"/>
        <source>Cut Polygon</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="76"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="100"/>
        <source>Cuts a Polygon by a Polyline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="119"/>
        <source>Qt Version too old</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="119"/>
        <source>This plugin requires at least version 4.3.3 of the Qt library</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="150"/>
        <source>Error</source>
        <translation type="unfinished">Грешка</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="150"/>
        <source>The cutting line must cross the polygon and
both end points must lie outside of the polygon</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context encoding="UTF-8">
    <name>PathDialogBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="13"/>
        <source>Path along Path</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="21"/>
        <source>Effect Type</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="29"/>
        <source>Single</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="34"/>
        <source>Single, stretched</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="39"/>
        <source>Repeated</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="44"/>
        <source>Repeated, stretched</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="52"/>
        <source>Horizontal Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="62"/>
        <source>Vertical Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="103"/>
        <source>Gap between Objects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="113"/>
        <source>Preview on Canvas</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="72"/>
        <source>Rotate Objects by:</source>
        <translation type="unfinished"></translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="80"/>
        <source>0°</source>
        <translation type="unfinished"></translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="85"/>
        <source>90°</source>
        <translation type="unfinished"></translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="90"/>
        <source>180°</source>
        <translation type="unfinished"></translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="95"/>
        <source>270°</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathFinderBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="13"/>
        <source>Boolean Path Operations</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="97"/>
        <source>+</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="195"/>
        <source>=</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="274"/>
        <source>Operation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="357"/>
        <source>...</source>
        <translation type="unfinished">...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="381"/>
        <source>Swap Shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="386"/>
        <source>Options</source>
        <translation type="obsolete">Опције</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="41"/>
        <source>First source shape.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="139"/>
        <source>Second source shape.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="234"/>
        <source>The resulting shape.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="286"/>
        <source>Unites the shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="321"/>
        <source>Intersection of the shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="337"/>
        <source>Result is the area where the two shapes do not intersect</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="353"/>
        <source>Break apart,
The result is a combination of &quot;Intersection&quot; and &quot;Exclusion&quot;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="450"/>
        <source>Custom Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="462"/>
        <source>Stroke:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="488"/>
        <source>Fill:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="158"/>
        <source>Keep a copy of the original item after applying the operation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="161"/>
        <source>Keep</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="305"/>
        <source>Subtracts the second shape from the first shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="378"/>
        <source>Exchange the Source Shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="424"/>
        <source>The resulting shape uses the color of the first source shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="427"/>
        <source>First Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="437"/>
        <source>The resulting shape uses the color of the second source shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="440"/>
        <source>Second Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="447"/>
        <source>The resulting shape uses the colors listed below</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="478"/>
        <source>Stroke Color</source>
        <translation type="unfinished">Боја потеза</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="498"/>
        <source>Fill Color</source>
        <translation type="unfinished">Боја испуњавања</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="418"/>
        <source>Result Takes Color from:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathFinderDialog</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderdialog.cpp" line="103"/>
        <source>Result gets Color of:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderdialog.cpp" line="127"/>
        <source>Intersection gets Color of:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathFinderPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="74"/>
        <source>Path Operations...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="78"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="103"/>
        <source>Path Operations</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="104"/>
        <source>Apply fancy boolean operations to paths.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="123"/>
        <source>Qt Version too old</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="123"/>
        <source>This plugin requires at least version 4.3.3 of the Qt library</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathStrokerPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="95"/>
        <source>Create Path from Stroke</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="74"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="96"/>
        <source>Converts the stroke of a Path to a filled Path.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PatternDialog</name>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="134"/>
        <source>Choose a Directory</source>
        <translation type="unfinished">Изаберите директоријум</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="162"/>
        <source>Loading Patterns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="296"/>
        <source>All Files (*)</source>
        <translation type="unfinished">Сви фајлови (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="310"/>
        <source>Open</source>
        <translation type="unfinished">Отвори</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="14"/>
        <source>Patterns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="56"/>
        <source>Load</source>
        <translation type="unfinished">Учитај</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="63"/>
        <source>Load Set</source>
        <translation type="unfinished">Учитај сет</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="77"/>
        <source>Remove</source>
        <translation type="unfinished">Уклони</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="84"/>
        <source>Remove All</source>
        <translation type="unfinished">Уклони све</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="107"/>
        <source>OK</source>
        <translation type="unfinished">У реду</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="114"/>
        <source>Cancel</source>
        <translation type="unfinished">Поништи</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="84"/>
        <source>&amp;Name:</source>
        <translation type="unfinished">&amp;Име:</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="84"/>
        <source>Rename Entry</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="213"/>
        <source>All Supported Formats</source>
        <translation type="unfinished">Сви подржани формати</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="70"/>
        <source>Rename</source>
        <translation type="unfinished">Преименуј</translation>
    </message>
</context>
<context>
    <name>PicSearch</name>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="108"/>
        <source>Size:</source>
        <translation type="unfinished">Величина:</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="109"/>
        <source>Resolution:</source>
        <translation>Резолуција:</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="109"/>
        <source>DPI</source>
        <translation>тпи</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="112"/>
        <source>Unknown</source>
        <translation type="unfinished">Непознат</translation>
    </message>
    <message>
        <location filename="../picsearch.cpp" line="118"/>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <location filename="../picsearch.cpp" line="121"/>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <location filename="../picsearch.cpp" line="124"/>
        <source>Grayscale</source>
        <translation type="obsolete">Нијансе сиве</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="115"/>
        <source>Colorspace:</source>
        <translation type="unfinished">Простор боја:</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="14"/>
        <source>Result</source>
        <translation type="unfinished">Резултат</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="34"/>
        <source>Search Results for: </source>
        <translation type="unfinished">Тражи резултате за: </translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="86"/>
        <source>&amp;Preview</source>
        <translation type="unfinished">&amp;Преглед</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="89"/>
        <source>Alt+P</source>
        <translation type="unfinished">Alt+P</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="115"/>
        <source>&amp;Select</source>
        <translation type="unfinished">&amp;Изабери</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="118"/>
        <source>Alt+S</source>
        <translation type="unfinished">Alt+S</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="128"/>
        <source>Cancel</source>
        <translation type="unfinished">Поништи</translation>
    </message>
</context>
<context>
    <name>PicSearchBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Result</source>
        <translation type="obsolete">Резултат</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Search Results for: </source>
        <translation type="obsolete">Тражи резултате за: </translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Preview</source>
        <translation type="obsolete">&amp;Преглед</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+P</source>
        <translation type="obsolete">Alt+P</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Select</source>
        <translation type="obsolete">&amp;Изабери</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
</context>
<context>
    <name>PicSearchOptions</name>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="51"/>
        <source>The filesystem will be searched for case insensitive file names when you check this on. Remember it is not default on most operating systems except MS Windows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="58"/>
        <source>Cancel Search</source>
        <translation>Обустави претрагу</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="124"/>
        <source>Start Search</source>
        <translation>Започни претрагу</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="91"/>
        <source>Select a base directory for search</source>
        <translation>Изабери почетни директоријум за претрагу</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="140"/>
        <source>Scribus - Image Search</source>
        <translation>Скрибус - Тражење слика</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="140"/>
        <source>The search failed: %1</source>
        <translation>Претрага није успела: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="13"/>
        <source>Search Images</source>
        <translation type="unfinished">Тражи слике</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="25"/>
        <source>Search for:</source>
        <translation type="unfinished">Тражи:</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="38"/>
        <source>Start at:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="64"/>
        <source>Change...</source>
        <translation type="unfinished">Измени...</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="79"/>
        <source>Searching</source>
        <translation type="unfinished">Претрага...</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="141"/>
        <source>Case insensitive search</source>
        <translation type="unfinished">Претрага неосетљива на величину слова</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="148"/>
        <source>Search recursively</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="103"/>
        <source>Base directory for search does not exist.
Please choose another one.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PicSearchOptionsBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Search Images</source>
        <translation type="obsolete">Тражи слике</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Change...</source>
        <translation type="obsolete">Измени...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Search for:</source>
        <translation type="obsolete">Тражи:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Case insensitive search</source>
        <translation type="obsolete">Претрага неосетљива на величину слова</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Search recursivly</source>
        <translation type="obsolete">Rekuryivna pretraga</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Searching</source>
        <translation type="obsolete">Претрага...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Start Search</source>
        <translation type="obsolete">Започни претрагу</translation>
    </message>
</context>
<context>
    <name>PicStatus</name>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="422"/>
        <source>Scribus - Image Search</source>
        <translation>Скрибус - Тражење слика</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="422"/>
        <source>No images named &quot;%1&quot; were found.</source>
        <translation>Слика са именом &quot;%1&quot; није пронађена.</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="253"/>
        <source>Not on a Page</source>
        <translation>Није на страни</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="278"/>
        <source>JPG</source>
        <translation>JPG</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="281"/>
        <source>TIFF</source>
        <translation>TIFF</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="284"/>
        <source>PSD</source>
        <translation>PSD</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="287"/>
        <source>EPS/PS</source>
        <translation>EPS/PS</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="290"/>
        <source>PDF</source>
        <translation>PDF</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="293"/>
        <source>JPG2000</source>
        <translation>JPG2000</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="299"/>
        <source>emb. PSD</source>
        <translation>emb. PSD</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="305"/>
        <source>Unknown</source>
        <translation type="unfinished">Непознат</translation>
    </message>
    <message>
        <location filename="../picstatus.cpp" line="194"/>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <location filename="../picstatus.cpp" line="197"/>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <location filename="../picstatus.cpp" line="200"/>
        <source>Grayscale</source>
        <translation type="obsolete">Нијансе сиве</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="322"/>
        <source>n/a</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../picstatus.ui" line="16"/>
        <source>Manage Pictures</source>
        <translation type="obsolete">Управљање сликама</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="83"/>
        <source>Information</source>
        <translation type="unfinished">Информација</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="155"/>
        <source>Path:</source>
        <translation type="unfinished">Путања:</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="198"/>
        <source>Search...</source>
        <translation type="unfinished">Тражи...</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="105"/>
        <source>Name:</source>
        <translation type="unfinished">Име:</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="215"/>
        <source>Image</source>
        <translation type="unfinished">Слика</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="288"/>
        <source>DPI:</source>
        <translation type="unfinished">тпи:</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="221"/>
        <source>Format:</source>
        <translation type="unfinished">Формат:</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="256"/>
        <source>Colorspace:</source>
        <translation type="unfinished">Простор боја:</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="323"/>
        <source>Size</source>
        <translation type="unfinished">Величина</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="329"/>
        <source>Pixels:</source>
        <translation type="unfinished">Пиксела:</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="358"/>
        <source>Scale:</source>
        <translation type="unfinished">Размера:</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="387"/>
        <source>Printed:</source>
        <translation type="unfinished">Штампано:</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="425"/>
        <source>Layout</source>
        <translation type="unfinished">Распоред</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="433"/>
        <source>On Page:</source>
        <translation type="unfinished">На страни:</translation>
    </message>
    <message>
        <location filename="../picstatus.ui" line="575"/>
        <source>Goto</source>
        <translation type="obsolete">Иди на</translation>
    </message>
    <message>
        <location filename="../picstatus.ui" line="562"/>
        <source>eff. DPI:</source>
        <translation type="obsolete">eff. :</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="552"/>
        <source>Object:</source>
        <translation type="obsolete">Објекат:</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="546"/>
        <source>Select</source>
        <translation type="unfinished">Изабери</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="575"/>
        <source>Image Tools</source>
        <translation type="unfinished">Алати за слике</translation>
    </message>
    <message>
        <location filename="../picstatus.ui" line="558"/>
        <source>Layers &amp;&amp; Paths...</source>
        <translation type="obsolete">Слојеви и путање...</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="623"/>
        <source>Image Visible</source>
        <translation type="unfinished">Слика видљива</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="633"/>
        <source>Image Effects...</source>
        <translation type="unfinished">Ефекти на слици...</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="613"/>
        <source>Edit Image...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="628"/>
        <source>Print Image</source>
        <translation type="obsolete">Штампај слику</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="684"/>
        <source>Close</source>
        <translation type="unfinished">Затвори</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="600"/>
        <source>Extended Image Properties...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="228"/>
        <source>Sort by Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="230"/>
        <source>Sort by Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="16"/>
        <source>Manage Images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="530"/>
        <source>Go to</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="127"/>
        <source>Name of the image file</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="177"/>
        <source>Location where the image file is stored</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="195"/>
        <source>Search for a missing image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="240"/>
        <source>Type of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="253"/>
        <source>The colorspace of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="275"/>
        <source>Colorspace used within the image, eg RGB or CMYK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="307"/>
        <source>Native resolution of the image, in dots per inch</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="345"/>
        <source>Height and width of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="374"/>
        <source>Horizontal and vertical scaling applied to the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="409"/>
        <source>Size of the image when printed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="449"/>
        <source>Page that the image is displayed on</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="462"/>
        <source>Page Item:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="478"/>
        <source>Name of the page item that contains the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="491"/>
        <source>Effective DPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="510"/>
        <source>Effective resolution of the image after scaling</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="527"/>
        <source>Move to the page that the image is on</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="543"/>
        <source>Move to the page that the item is on and select it</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="587"/>
        <source>Enable or disable exporting of the item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="590"/>
        <source>Export/Print Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="597"/>
        <source>Set format specfic properties of certain image types, like clipping paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="610"/>
        <source>Edit the image in the default editor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="620"/>
        <source>Make the image visible or invisible</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="630"/>
        <source>Apply non destructive effects to the image in its frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="264"/>
        <source>Embedded Image</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PicStatusBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Manage Pictures</source>
        <translation type="obsolete">Управљање сликама</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Information</source>
        <translation type="obsolete">Информација</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Path:</source>
        <translation type="obsolete">Путања:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Search...</source>
        <translation type="obsolete">Тражи...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Name:</source>
        <translation type="obsolete">Име:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Image</source>
        <translation type="obsolete">Слика</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>DPI:</source>
        <translation type="obsolete">тпи:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Format:</source>
        <translation type="obsolete">Формат:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Colorspace:</source>
        <translation type="obsolete">Простор боја:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Size</source>
        <translation type="obsolete">Величина</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Pixels:</source>
        <translation type="obsolete">Пиксела:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Scale:</source>
        <translation type="obsolete">Размера:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Printed:</source>
        <translation type="obsolete">Штампано:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Layout</source>
        <translation type="obsolete">Распоред</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>On Page:</source>
        <translation type="obsolete">На страни:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Goto</source>
        <translation type="obsolete">Иди на</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>eff. DPI:</source>
        <translation type="obsolete">eff. :</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Object:</source>
        <translation type="obsolete">Објекат:</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Select</source>
        <translation type="obsolete">Изабери</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Image Tools</source>
        <translation type="obsolete">Алати за слике</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Layers &amp;&amp; Paths...</source>
        <translation type="obsolete">Слојеви и путање...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Image Visible</source>
        <translation type="obsolete">Слика видљива</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Image Effects...</source>
        <translation type="obsolete">Ефекти на слици...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Edit Image...</source>
        <translation type="obsolete">Мењај слику...</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Print Image</source>
        <translation type="obsolete">Штампај слику</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Close</source>
        <translation type="obsolete">Затвори</translation>
    </message>
</context>
<context>
    <name>PixmapExportPlugin</name>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="59"/>
        <source>Save as &amp;Image...</source>
        <translation type="unfinished">Сними као &amp;слику...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="78"/>
        <source>Export As Image</source>
        <translation>Извези као слику</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="79"/>
        <source>Exports selected pages as bitmap images.</source>
        <translation>Извози изабране стране као растерске слике.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="123"/>
        <source>Save as Image</source>
        <translation type="unfinished">Сними као слику</translation>
    </message>
    <message>
        <location filename="../plugins/pixmapexport/export.cpp" line="130"/>
        <source>Error writing the output file(s).</source>
        <translation type="obsolete">Грешка при писању излазног фајла(ова).</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="145"/>
        <source>Export successful</source>
        <translation>Извезено успешно</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="118"/>
        <source>The target location %1 must be an existing directory</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="124"/>
        <source>The target location %1 must be writable</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PluginManager</name>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="72"/>
        <source>Cannot find plugin</source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="61"/>
        <source>unknown error</source>
        <comment>plugin manager</comment>
        <translation>непозната грешка</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="97"/>
        <source>Cannot find symbol (%1)</source>
        <comment>plugin manager</comment>
        <translation>Не могу да нађем симбол (%1)</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="157"/>
        <source>Plugin: loading %1</source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="264"/>
        <source>init failed</source>
        <comment>plugin load error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="270"/>
        <source>unknown plugin type</source>
        <comment>plugin load error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="274"/>
        <source>Plugin: %1 loaded</source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="278"/>
        <source>Plugin: %1 failed to load: %2</source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="344"/>
        <source>Plugin: %1 initialized ok </source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="346"/>
        <source>Plugin: %1 failed post initialization</source>
        <comment>plugin manager</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="231"/>
        <source>There is a problem loading %1 of %2 plugins. %3 This is probably caused by some kind of dependency issue or old plugins existing in your install directory. If you clean out your install directory and reinstall and this still occurs, please report it on bugs.scribus.net.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PluginManagerPrefsGui</name>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="20"/>
        <source>Plugin Manager</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="36"/>
        <source>Plugin</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="41"/>
        <source>How to run</source>
        <translation>Како покренути</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="46"/>
        <source>Type</source>
        <translation type="unfinished">Врста</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="51"/>
        <source>Load it?</source>
        <translation>Да учитам?</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="56"/>
        <source>Plugin ID</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="61"/>
        <source>File</source>
        <translation type="unfinished">Фајл</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="69"/>
        <source>You need to restart the application to apply the changes.</source>
        <translation>Програм је неопходно поново покренути да би се промене примениле.</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="14"/>
        <source>Form</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PolygonProps</name>
    <message>
        <location filename="../../scribus/polyprops.cpp" line="20"/>
        <source>Polygon Properties</source>
        <translation>Својства полигона</translation>
    </message>
</context>
<context>
    <name>PolygonWidget</name>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="55"/>
        <source>Corn&amp;ers:</source>
        <translation type="obsolete">Угл&amp;ови:</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="75"/>
        <source>&amp;Rotation:</source>
        <translation type="obsolete">&amp;Ротација:</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="91"/>
        <source>Apply &amp;Factor</source>
        <translation type="obsolete">Примени &amp;фактор</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="106"/>
        <source> %</source>
        <translation type="obsolete"> %</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="110"/>
        <source>&amp;Factor:</source>
        <translation type="obsolete">&amp;Фактор:</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="140"/>
        <source>Number of corners for polygons</source>
        <translation type="obsolete">Број углова за полигоне</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="142"/>
        <source>Degrees of rotation for polygons</source>
        <translation type="obsolete">Степени ротације за полигоне</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="143"/>
        <source>Apply Convex/Concave Factor to change shape of Polygons</source>
        <translation type="obsolete">Примени конвексно/конкавно фактор да би променио облик полигона</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="144"/>
        <source>Sample Polygon</source>
        <translation type="obsolete">Пример полигона</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="146"/>
        <source>A negative value will make the polygon concave (or star shaped), a positive value will make it convex</source>
        <translation type="obsolete">Негативна вредност ће начинити полигон цонкавним (звездолики облик), а позитивна вредност конвексним.</translation>
    </message>
</context>
<context>
    <name>PolygonWidgetBase</name>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="19"/>
        <source>Form</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="30"/>
        <source>Corn&amp;ers:</source>
        <translation type="unfinished">Угл&amp;ови:</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="40"/>
        <source>Number of corners for polygons</source>
        <translation type="unfinished">Број углова за полигоне</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="53"/>
        <source>&amp;Rotation:</source>
        <translation type="unfinished">&amp;Ротација:</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="76"/>
        <source>Degrees of rotation for polygons</source>
        <translation type="unfinished">Степени ротације за полигоне</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="121"/>
        <source>Sample Polygon</source>
        <translation type="unfinished">Пример полигона</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="143"/>
        <source>Apply Convex/Concave Factor to change shape of Polygons</source>
        <translation type="unfinished">Примени конвексно/конкавно фактор да би променио облик полигона</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="146"/>
        <source>Apply &amp;Factor</source>
        <translation type="unfinished">Примени &amp;фактор</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="161"/>
        <source>&amp;Factor:</source>
        <translation type="unfinished">&amp;Фактор:</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="187"/>
        <source>A negative value will make the polygon concave (or star shaped), a positive value will make it convex</source>
        <translation type="unfinished">Негативна вредност ће начинити полигон цонкавним (звездолики облик), а позитивна вредност конвексним.</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="216"/>
        <source> %</source>
        <translation type="unfinished"> %</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="206"/>
        <source>C&amp;urvature:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Preferences</name>
    <message>
        <location filename="../../scribus/prefs.cpp" line="73"/>
        <source>Preferences</source>
        <translation>Подешавања</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="76"/>
        <source>General</source>
        <translation>Опште</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="79"/>
        <source>Document</source>
        <translation>Документ</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="82"/>
        <source>Guides</source>
        <translation>Водиље</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="85"/>
        <source>Typography</source>
        <translation>Типографија</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="88"/>
        <source>Tools</source>
        <translation>Алати</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="136"/>
        <source>Scrapbook</source>
        <translation type="unfinished">Албум</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="139"/>
        <source>Display</source>
        <translation>Приказ</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="142"/>
        <source>External Tools</source>
        <translation type="unfinished">Спољашњи алати</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="91"/>
        <source>Hyphenator</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="94"/>
        <source>Fonts</source>
        <translation>Фонтови</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="105"/>
        <source>Color Management</source>
        <translation>Управљање бојама</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="120"/>
        <source>PDF Export</source>
        <translation>Извоз PDF-ова</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="133"/>
        <source>Keyboard Shortcuts</source>
        <translation>Пречице са тастатуре</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="149"/>
        <source>Plugins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="100"/>
        <source>Preflight Verifier</source>
        <translation>Провера могућих проблема</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="125"/>
        <source>Document Item Attributes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="130"/>
        <source>Table of Contents and Indexes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="145"/>
        <source>Miscellaneous</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="97"/>
        <source>Printer</source>
        <translation type="unfinished">Штампач</translation>
    </message>
</context>
<context>
    <name>PrefsDialogBase</name>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="192"/>
        <source>&amp;Defaults</source>
        <translation>&amp;Подразумевано</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="201"/>
        <source>Save Preferences</source>
        <translation>Сачувај подешавања</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="191"/>
        <source>Export...</source>
        <translation>Извоз...</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="193"/>
        <source>&amp;Apply</source>
        <translation type="unfinished">&amp;Примени</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="194"/>
        <source>All preferences can be reset here</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="195"/>
        <source>Apply all changes without closing the dialog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="196"/>
        <source>Export current preferences into file</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PrefsManager</name>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2075"/>
        <source>Postscript</source>
        <translation type="unfinished">Postscript</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="816"/>
        <source>Migrate Old Scribus Settings?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="818"/>
        <source>Scribus has detected existing Scribus 1.2 preferences files.
Do you want to migrate them to the new Scribus version?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2075"/>
        <source>PostScript</source>
        <translation>PostScript</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="1696"/>
        <source>Could not open preferences file &quot;%1&quot; for writing: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="1708"/>
        <source>Writing to preferences file &quot;%1&quot; failed: QIODevice status code %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="1722"/>
        <source>Failed to open prefs file &quot;%1&quot;: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="1732"/>
        <source>Failed to read prefs XML from &quot;%1&quot;: %2 at line %3, col %4</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../prefsmanager.cpp" line="2099"/>
        <source>PDF 1.3</source>
        <translation type="obsolete">PDF 1.3</translation>
    </message>
    <message>
        <location filename="../prefsmanager.cpp" line="2101"/>
        <source>PDF 1.4</source>
        <translation type="obsolete">PDF 1.4</translation>
    </message>
    <message>
        <location filename="../prefsmanager.cpp" line="2106"/>
        <source>PDF/X-3</source>
        <translation type="obsolete">PDF/X-3</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2414"/>
        <source>Error Writing Preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2420"/>
        <source>Scribus was not able to save its preferences:&lt;br&gt;%1&lt;br&gt;Please check file and directory permissions and available disk space.</source>
        <comment>scribus app error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2433"/>
        <source>Error Loading Preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2438"/>
        <source>Scribus was not able to load its preferences:&lt;br&gt;%1&lt;br&gt;Default settings will be loaded.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../prefsmanager.cpp" line="2102"/>
        <source>PDF 1.5</source>
        <translation type="obsolete">PDF 1.5</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2146"/>
        <source>No valid renderframe config found. Using defaults!</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PresetLayout</name>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="555"/>
        <source>Magazine</source>
        <translation>Магазин</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="556"/>
        <source>Fibonacci</source>
        <translation>Фибоначи</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="557"/>
        <source>Golden Mean</source>
        <translation>Златни пресек</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="558"/>
        <source>Nine Parts</source>
        <translation>Девет делова</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="554"/>
        <source>Gutenberg</source>
        <translation>Гутенберг</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>None</source>
        <comment>



layout type</comment>
        <translation type="obsolete">Ниједан</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="553"/>
        <source>None</source>
        <comment>layout type</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="561"/>
        <source>When you have selected a Document Layout other than Single Page, you can select a predefined page layout here. &apos;None&apos; leaves margins as is, Gutenberg sets margins classically. &apos;Magazine&apos; sets all margins to the same value. Leading is Left/Inside value.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PrintDialog</name>
    <message>
        <location filename="../printdialog.cpp" line="67"/>
        <source>Setup Printer</source>
        <translation type="obsolete">Подеси штампач</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="74"/>
        <source>Print Destination</source>
        <translation type="obsolete">Одредиште за штампу</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="565"/>
        <source>File</source>
        <translation>Фајл</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="89"/>
        <source>&amp;Options...</source>
        <translation type="obsolete">&amp;Опције...</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="100"/>
        <source>&amp;File:</source>
        <translation type="obsolete">&amp;Фајл:</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="106"/>
        <source>C&amp;hange...</source>
        <translation type="obsolete">И&amp;змени...</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="113"/>
        <source>A&amp;lternative Printer Command</source>
        <translation type="obsolete">А&amp;лтернативна наредба штампача</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="122"/>
        <source>Co&amp;mmand:</source>
        <translation type="obsolete">&amp;Наредба:</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="130"/>
        <source>Range</source>
        <translation type="obsolete">Опсег</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="135"/>
        <source>Print &amp;All</source>
        <translation type="obsolete">Штампај &amp;све</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="375"/>
        <source>Print Current Pa&amp;ge</source>
        <translation>Штампај текућу стр&amp;аницу</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="139"/>
        <source>Print &amp;Range</source>
        <translation type="obsolete">&amp;Опсег штампања</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="378"/>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation type="obsolete">Унесите листу обележја раздвојених зарезима где
обележје може бити * за све странице, 1-5 за
опсег страница или број једне странице.</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="159"/>
        <source>N&amp;umber of Copies:</source>
        <translation type="obsolete">Б&amp;рој копија:</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="190"/>
        <source>Options</source>
        <translation type="obsolete">Опције</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="509"/>
        <source>All</source>
        <translation>Све</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="508"/>
        <source>Cyan</source>
        <translation>Цијан</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="507"/>
        <source>Magenta</source>
        <translation>Магента</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="506"/>
        <source>Yellow</source>
        <translation>Жута</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="505"/>
        <source>Black</source>
        <translation>Црна</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="308"/>
        <source>&amp;Print</source>
        <translation type="obsolete">&amp;Штампај</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="359"/>
        <source>Save as</source>
        <translation type="obsolete">Сними као</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="336"/>
        <source>Print Normal</source>
        <translation>Нормална штампа</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="172"/>
        <source>Print Separations</source>
        <translation type="obsolete">Штампа издвајања боја</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="176"/>
        <source>Print in Color if Available</source>
        <translation type="obsolete">Штампа у боји ако је могуће</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="177"/>
        <source>Print in Grayscale</source>
        <translation type="obsolete">Штампа у нијансама сиве</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="221"/>
        <source>PostScript Level 1</source>
        <translation type="obsolete">PostScript Level 1</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="222"/>
        <source>PostScript Level 2</source>
        <translation type="obsolete">PostScript Level 2</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="223"/>
        <source>PostScript Level 3</source>
        <translation type="obsolete">PostScript Level 3</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="196"/>
        <source>Page</source>
        <translation type="obsolete">Страна</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="202"/>
        <source>Mirror Page(s) Horizontal</source>
        <translation type="obsolete">Изврни страну(е) водоравно</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="205"/>
        <source>Mirror Page(s) Vertical</source>
        <translation type="obsolete">Изврни страну(е) усправно</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="208"/>
        <source>Set Media Size</source>
        <translation type="obsolete">Подеси величину медиа</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="214"/>
        <source>Color</source>
        <translation type="obsolete">Боја</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="220"/>
        <source>Apply Under Color Removal</source>
        <translation type="obsolete">Примени смањење засићења бојом</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="223"/>
        <source>Convert Spot Colors to Process Colors</source>
        <translation type="obsolete">Преведи Спот боје у процесне боје</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="263"/>
        <source>Apply ICC Profiles</source>
        <translation type="obsolete">Примени ICC профиле</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="232"/>
        <source>Advanced Options</source>
        <translation type="obsolete">Напредне опције</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="303"/>
        <source>Preview...</source>
        <translation type="obsolete">Преглед...</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="380"/>
        <source>Sets the PostScript Level.
 Setting to Level 1 or 2 can create huge files</source>
        <translation type="obsolete">Одређује Пост скрипт ниво. 
Постављање на Level 1 или 2 може да направи огромне фајлове</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="361"/>
        <source>PostScript Files (*.ps);;All Files (*)</source>
        <translation>Пост скрипт фајлови (*.ps);;Сви фајлови (*)</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="379"/>
        <source>Use an alternative print manager, such as kprinter or gtklp, to utilize additional printing options</source>
        <translation type="obsolete">Користи алтернативни управљач штампом, као што је kprinter или gtklp, да би подесио додатне опције штампе</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="381"/>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis.UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="obsolete">Начин замене неких нијанси сиве које су састављене од цијана, жуте и магенте и коришћење црне уместо њих. UCR (смањење засићења бојом) углавном утиче на делове слика које су неутрални или тамних тонова који су врло близу сивој. Коришћење ове опције може умногоме побољшати неке слике и захтева одређено експериментисање и пробе од слушаја до случаја. UCR смањује могућност презасићења CMY бојама.</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="382"/>
        <source>Enables Spot Colors to be converted to composite colors. Unless you are planning to print spot colors at a commercial printer, this is probably best left enabled.</source>
        <translation type="obsolete">Омогућава да спот боје буду преведене у композитне боје. Ако није планирано да се спот боје штампају у комерцијалној штампи, најбоље је оставити ово поље укључено.</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="385"/>
        <source>This enables you to explicitely set the media size of the PostScript file. Not recommended unless requested by your printer.</source>
        <translation type="obsolete">Омогућава да се назначи величина медијума штампе у ПостСкрипт фајлу. Ноје препоручљино уколико није захтевано од стране штампара.</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="210"/>
        <source>Clip to Page Margins</source>
        <translation type="obsolete">Одсеци до маргина стране</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="311"/>
        <source>Failed to retrieve printer settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="375"/>
        <source>Do not show objects outside the margins on the printed page</source>
        <translation type="obsolete">Не приказуј објекте изван маргина на штампаној страни</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="239"/>
        <source>Printer Marks</source>
        <translation type="obsolete">Ознаке за штампу</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="244"/>
        <source>Crop Marks</source>
        <translation type="obsolete">Ознаке за сечење</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="248"/>
        <source>Registration Marks</source>
        <translation type="obsolete">Регистрационе ознаке</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="250"/>
        <source>Color Bars</source>
        <translation type="obsolete">Клинови боја</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="258"/>
        <source>Marks</source>
        <translation type="obsolete">Ознаке</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="271"/>
        <source>Top:</source>
        <translation type="obsolete">Горе:</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="276"/>
        <source>Bottom:</source>
        <translation type="obsolete">Доле:</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="281"/>
        <source>Left:</source>
        <translation type="obsolete">Лево:</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="286"/>
        <source>Right:</source>
        <translation type="obsolete">Десно:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="103"/>
        <source>Inside:</source>
        <translation type="unfinished">Унутар:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="104"/>
        <source>Outside:</source>
        <translation type="unfinished">Споља:</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="391"/>
        <source>Distance for bleed from the top of the physical page</source>
        <translation type="obsolete">Растојање за цурење од врха физичке странице</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="392"/>
        <source>Distance for bleed from the bottom of the physical page</source>
        <translation type="obsolete">Растојање за цурење од дна физичке странице</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="393"/>
        <source>Distance for bleed from the left of the physical page</source>
        <translation type="obsolete">Растојање за цурење с лева физичке странице</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="394"/>
        <source>Distance for bleed from the right of the physical page</source>
        <translation type="obsolete">Растојање за цурење с десна физичке странице</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>This creates crop marks in the PDF indicating where the paper should be cut or trimmed after printing.</source>
        <translation type="obsolete">Поставља ознаке за сечење у PDF-у да укаже где папир треба сећи или обрезати након штампања.</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="361"/>
        <source>Save As</source>
        <translation type="unfinished">Сними као</translation>
    </message>
</context>
<context>
    <name>PrintDialogBase</name>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="13"/>
        <source>Setup Printer</source>
        <translation type="unfinished">Подеси штампач</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="22"/>
        <source>Print Destination</source>
        <translation type="unfinished">Одредиште за штампу</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="49"/>
        <source>&amp;Options...</source>
        <translation type="unfinished">&amp;Опције...</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="85"/>
        <source>&amp;File:</source>
        <translation type="unfinished">&amp;Фајл:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="101"/>
        <source>C&amp;hange...</source>
        <translation type="unfinished">И&amp;змени...</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="116"/>
        <source>Use an alternative print manager, such as kprinter or gtklp, to utilize additional printing options</source>
        <translation type="unfinished">Користи алтернативни управљач штампом, као што је kprinter или gtklp, да би подесио додатне опције штампе</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="119"/>
        <source>A&amp;lternative Printer Command</source>
        <translation type="unfinished">А&amp;лтернативна наредба штампача</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="137"/>
        <source>Co&amp;mmand:</source>
        <translation type="unfinished">&amp;Наредба:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="159"/>
        <source>Range</source>
        <translation type="unfinished">Опсег</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="171"/>
        <source>Print &amp;All</source>
        <translation type="unfinished">Штампај &amp;све</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="191"/>
        <source>N&amp;umber of Copies:</source>
        <translation type="unfinished">Б&amp;рој копија:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="211"/>
        <source>Print Current Pa&amp;ge</source>
        <translation type="unfinished">Штампај текућу стр&amp;аницу</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="218"/>
        <source>Print &amp;Range</source>
        <translation type="unfinished">&amp;Опсег штампања</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="228"/>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation type="unfinished">Унесите листу обележја раздвојених зарезима где
обележје може бити * за све странице, 1-5 за
опсег страница или број једне странице.</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="273"/>
        <source>Options</source>
        <translation type="unfinished">Опције</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="280"/>
        <source>Print Normal</source>
        <translation type="unfinished">Нормална штампа</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="285"/>
        <source>Print Separations</source>
        <translation type="unfinished">Штампа издвајања боја</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="294"/>
        <source>Print in Color if Available</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="299"/>
        <source>Print in Grayscale</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="314"/>
        <source>Sets the PostScript Level.
 Setting to Level 1 or 2 can create huge files</source>
        <translation type="unfinished">Одређује Пост скрипт ниво. 
Постављање на Level 1 или 2 може да направи огромне фајлове</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="334"/>
        <source>Advanced Options</source>
        <translation type="unfinished">Напредне опције</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="340"/>
        <source>Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="346"/>
        <source>Mirror Page(s) Horizontal</source>
        <translation type="unfinished">Изврни страну(е) водоравно</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="353"/>
        <source>Mirror Page(s) Vertical</source>
        <translation type="unfinished">Изврни страну(е) усправно</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="360"/>
        <source>This enables you to explicitely set the media size of the PostScript file. Not recommended unless requested by your printer.</source>
        <translation type="obsolete">Омогућава да се назначи величина медијума штампе у ПостСкрипт фајлу. Ноје препоручљино уколико није захтевано од стране штампара.</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="363"/>
        <source>Set Media Size</source>
        <translation type="unfinished">Подеси величину медиа</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="370"/>
        <source>Clip to Page Margins</source>
        <translation type="obsolete">Одсеци до маргина стране</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="380"/>
        <source>Color</source>
        <translation type="unfinished">Боја</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="386"/>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis.UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="obsolete">Начин замене неких нијанси сиве које су састављене од цијана, жуте и магенте и коришћење црне уместо њих. UCR (смањење засићења бојом) углавном утиче на делове слика које су неутрални или тамних тонова који су врло близу сивој. Коришћење ове опције може умногоме побољшати неке слике и захтева одређено експериментисање и пробе од слушаја до случаја. UCR смањује могућност презасићења CMY бојама.</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="389"/>
        <source>Apply Under Color Removal</source>
        <translation type="unfinished">Примени смањење засићења бојом</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="396"/>
        <source>Enables Spot Colors to be converted to composite colors. Unless you are planning to print spot colors at a commercial printer, this is probably best left enabled.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="399"/>
        <source>Convert Spot Colors to Process Colors</source>
        <translation type="unfinished">Преведи Спот боје у процесне боје</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="406"/>
        <source>Allows you to embed color profiles in the print stream when color management is enabled</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="409"/>
        <source>Apply Color Profiles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="436"/>
        <source>Marks</source>
        <translation type="unfinished">Ознаке</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="442"/>
        <source>This creates crop marks in the PDF indicating where the paper should be cut or trimmed after printing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="445"/>
        <source>Crop Marks</source>
        <translation type="unfinished">Ознаке за сечење</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="452"/>
        <source>Add registration marks which are added to each separation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="455"/>
        <source>Registration Marks</source>
        <translation type="unfinished">Регистрационе ознаке</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="462"/>
        <source>This creates bleed marks which are indicated by  _ . _ and show the bleed limit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="465"/>
        <source>Bleed Marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="472"/>
        <source>Add color calibration bars</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="475"/>
        <source>Color Bars</source>
        <translation type="unfinished">Клинови боја</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="484"/>
        <source>Offset:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="491"/>
        <source>Indicate the distance offset for the registration marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="514"/>
        <source>Bleeds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="520"/>
        <source>Top:</source>
        <translation type="unfinished">Горе:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="527"/>
        <source>Distance for bleed from the top of the physical page</source>
        <translation type="unfinished">Растојање за цурење од врха физичке странице</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="534"/>
        <source>Left:</source>
        <translation type="unfinished">Лево:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="541"/>
        <source>Distance for bleed from the right of the physical page</source>
        <translation type="unfinished">Растојање за цурење с десна физичке странице</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="548"/>
        <source>Bottom:</source>
        <translation type="unfinished">Доле:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="555"/>
        <source>Distance for bleed from the bottom of the physical page</source>
        <translation type="unfinished">Растојање за цурење од дна физичке странице</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="562"/>
        <source>Right:</source>
        <translation type="unfinished">Десно:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="569"/>
        <source>Distance for bleed from the left of the physical page</source>
        <translation type="unfinished">Растојање за цурење с лева физичке странице</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="576"/>
        <source>Use the existing bleed settings from the document preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="579"/>
        <source>Use Document Bleeds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="605"/>
        <source>Preview...</source>
        <translation type="unfinished">Преглед...</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="615"/>
        <source>&amp;Print</source>
        <translation type="unfinished">&amp;Штампај</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="625"/>
        <source>Cancel</source>
        <translation type="unfinished">Поништи</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="322"/>
        <source>Include PDF Annotations and Links into the output.
Note: PDF Forms will not be exported.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="326"/>
        <source>Include PDF Annotations and Links</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="360"/>
        <source>This enables you to explicitly set the media size of the PostScript file. Not recommended unless requested by your printer.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="370"/>
        <source>Clip to Printer Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="386"/>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis. UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="unfinished">Начин замене неких нијанси сиве које су састављене од цијана, жуте и магенте и коришћење црне уместо њих. UCR (смањење засићења бојом) углавном утиче на делове слика које су неутрални или тамних тонова који су врло близу сивој. Коришћење ове опције може умногоме побољшати неке слике и захтева одређено експериментисање и пробе од слушаја до случаја. UCR смањује могућност презасићења CMY бојама.</translation>
    </message>
</context>
<context>
    <name>PropertiesPalette</name>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5087"/>
        <source>Properties</source>
        <translation>Својства</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5089"/>
        <source>X, Y, &amp;Z</source>
        <translation>X, Y, &amp;Z</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5092"/>
        <source>&amp;Shape</source>
        <translation>&amp;Облик</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5090"/>
        <source>&amp;Text</source>
        <translation>&amp;Текст</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5091"/>
        <source>&amp;Image</source>
        <translation>Сл&amp;ика</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5093"/>
        <source>&amp;Line</source>
        <translation>&amp;Линија</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5094"/>
        <source>&amp;Colors</source>
        <translation>&amp;Боје</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5097"/>
        <source>Name</source>
        <translation>Име</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5098"/>
        <source>Geometry</source>
        <translation>Геометрија</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5301"/>
        <source> pt</source>
        <translation> тач.</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5210"/>
        <source>&amp;X-Pos:</source>
        <translation>&amp;X Поз:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5211"/>
        <source>&amp;Y-Pos:</source>
        <translation>&amp;Y Поз:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5101"/>
        <source>&amp;Width:</source>
        <translation>Ш&amp;ирина:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5102"/>
        <source>&amp;Height:</source>
        <translation>&amp;Висина:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5103"/>
        <source>&amp;Rotation:</source>
        <translation>&amp;Ротација:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5104"/>
        <source>Basepoint:</source>
        <translation>Почетна тачка:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5105"/>
        <source>Level</source>
        <translation>Ниво</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5111"/>
        <source>Shape:</source>
        <translation>Облик:</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4341"/>
        <source>&amp;Edit Shape...</source>
        <translation type="obsolete">&amp;Уређивање облика...</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5133"/>
        <source>R&amp;ound
Corners:</source>
        <translation>За&amp;обљени углови:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4923"/>
        <source>Distance of Text</source>
        <translation type="obsolete">Растојање текста</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5134"/>
        <source>Colu&amp;mns:</source>
        <translation>&amp;Колоне:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5141"/>
        <source>To&amp;p:</source>
        <translation>Вр&amp;х:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5142"/>
        <source>&amp;Bottom:</source>
        <translation>&amp;Дно:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5143"/>
        <source>&amp;Left:</source>
        <translation>&amp;Лево:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5144"/>
        <source>&amp;Right:</source>
        <translation>&amp;Десно:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5145"/>
        <source>T&amp;abulators...</source>
        <translation>Т&amp;абулатори...</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5205"/>
        <source>Path Text Properties</source>
        <translation>Својства путање текста</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5154"/>
        <source>Show Curve</source>
        <translation>Прикажи криву</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5156"/>
        <source>Start Offset:</source>
        <translation>Покрени померај:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5157"/>
        <source>Distance from Curve:</source>
        <translation>Растојање од криве:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5170"/>
        <source>Use &amp;Bounding Box</source>
        <translation>Користи  оквирни правоугаоник                  &amp;</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5171"/>
        <source>&amp;Use Contour Line</source>
        <translation>&amp;Користи контуру</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5287"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5207"/>
        <source>&amp;Free Scaling</source>
        <translation>&amp;Слободно скалирање</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5212"/>
        <source>X-Sc&amp;ale:</source>
        <translation>X Ска&amp;лирај:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5213"/>
        <source>Y-Scal&amp;e:</source>
        <translation>Y Ска&amp;лирај:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5214"/>
        <source>Scale &amp;To Frame Size</source>
        <translation>Скалирај &amp;до величине оквира</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5215"/>
        <source>P&amp;roportional</source>
        <translation>Пр&amp;опорционалан</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5218"/>
        <source>Input Profile:</source>
        <translation>Улазни профил:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5219"/>
        <source>Rendering Intent:</source>
        <translation>Намера рендеровања:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5232"/>
        <source>Perceptual</source>
        <translation>Перцептуално</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5233"/>
        <source>Relative Colorimetric</source>
        <translation>Релативна колорметрика</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5234"/>
        <source>Saturation</source>
        <translation>Засићење</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5235"/>
        <source>Absolute Colorimetric</source>
        <translation>Апсолутна колорметрика</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5244"/>
        <source>Left Point</source>
        <translation>Лева тачка</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5245"/>
        <source>End Points</source>
        <translation>Крајње тачке</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5247"/>
        <source>&amp;Basepoint:</source>
        <translation>&amp;Основна тачка:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5248"/>
        <source>T&amp;ype of Line:</source>
        <translation>В&amp;рста линије:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5260"/>
        <source>Line &amp;Width:</source>
        <translation>&amp;Ширина линије:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5264"/>
        <source>Miter Join</source>
        <translation>Угаони спој</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5265"/>
        <source>Bevel Join</source>
        <translation>Коси спој</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5266"/>
        <source>Round Join</source>
        <translation>Кружни спој</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5261"/>
        <source>Ed&amp;ges:</source>
        <translation>Ив&amp;ице:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5271"/>
        <source>Flat Cap</source>
        <translation>Раван поклопац</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5272"/>
        <source>Square Cap</source>
        <translation>Квадратни поклопац</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5273"/>
        <source>Round Cap</source>
        <translation>Кружни поклопац</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5275"/>
        <source>&amp;Endings:</source>
        <translation>&amp;Завршеци:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5328"/>
        <source>No Style</source>
        <translation>Нема стила</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5277"/>
        <source>Cell Lines</source>
        <translation>Линије ћелије</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5278"/>
        <source>Line at Top</source>
        <translation>Линија на врху</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5279"/>
        <source>Line at the Left</source>
        <translation>Линија лево</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5280"/>
        <source>Line at the Right </source>
        <translation>Линија десно</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5281"/>
        <source>Line at Bottom</source>
        <translation>Линија на дну</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5423"/>
        <source>Name of selected object</source>
        <translation>Име изабраног објекта</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5424"/>
        <source>Horizontal position of current basepoint</source>
        <translation>Водоравни положај тренутне почетне тачке</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5425"/>
        <source>Vertical position of current basepoint</source>
        <translation>Усправни положај тренутне почетне тачке</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5426"/>
        <source>Width</source>
        <translation>Ширина</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5427"/>
        <source>Height</source>
        <translation>Висина</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5428"/>
        <source>Rotation of object at current basepoint</source>
        <translation>Ротација објекта у тренутној почетној тачки</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5429"/>
        <source>Point from which measurements or rotation angles are referenced</source>
        <translation>Тачка од које се референцирају мере или углови ротације</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4783"/>
        <source>Select top left for basepoint</source>
        <translation type="obsolete">Изабери врх лево за почетну тачку</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4784"/>
        <source>Select top right for basepoint</source>
        <translation type="obsolete">Изабери врх десно за почетну тачку</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4785"/>
        <source>Select bottom left for basepoint</source>
        <translation type="obsolete">Изабери дно лево за почетну тачку</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4786"/>
        <source>Select bottom right for basepoint</source>
        <translation type="obsolete">Изабери дно десно за почетну тачку</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4787"/>
        <source>Select center for basepoint</source>
        <translation type="obsolete">Изабери центар за почетну тачку</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5437"/>
        <source>Flip Horizontal</source>
        <translation>Преврни водоравно</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5438"/>
        <source>Flip Vertical</source>
        <translation>Преврни усправно</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5439"/>
        <source>Move one level up</source>
        <translation>Помери за један ниво на горе</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5440"/>
        <source>Move one level down</source>
        <translation>Помери за један ниво на доле</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5441"/>
        <source>Move to front</source>
        <translation>Помери ка напред</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5442"/>
        <source>Move to back</source>
        <translation>Помери у позадину</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5443"/>
        <source>Indicates the level the object is on, 0 means the object is at the bottom</source>
        <translation>Указује на ком је нивоу објекат, 0 значи да је објекат на дну</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5444"/>
        <source>Lock or unlock the object</source>
        <translation>Закључај или откључај објекат</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5445"/>
        <source>Lock or unlock the size of the object</source>
        <translation>Закључај или откључај величину објекта</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4619"/>
        <source>Enable or disable printing of the object</source>
        <translation type="obsolete">Укључи или искључи штампање објекта</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5459"/>
        <source>Font of selected text or object</source>
        <translation>Фонт изабраног текста или објекта</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5460"/>
        <source>Font Size</source>
        <translation>Величина фонта</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5462"/>
        <source>Scaling width of characters</source>
        <translation>Скалирање ширине карактера</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5466"/>
        <source>Saturation of color of text stroke</source>
        <translation>Засићење боје текста</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5467"/>
        <source>Saturation of color of text fill</source>
        <translation>Засићење боје испуњеног текста</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5470"/>
        <source>Line Spacing</source>
        <translation>Проред</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5489"/>
        <source>Change settings for left or end points</source>
        <translation>Измени поставке за леве или крајње тачке</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5490"/>
        <source>Pattern of line</source>
        <translation>Узорак линије</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5491"/>
        <source>Thickness of line</source>
        <translation>Дебљина линије</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5492"/>
        <source>Type of line joins</source>
        <translation>Врста спојева линија</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5493"/>
        <source>Type of line end</source>
        <translation>Врста краја линије</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5494"/>
        <source>Line style of current object</source>
        <translation>Стил линија тренутног објекта</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5498"/>
        <source>Choose the shape of frame...</source>
        <translation>Изаберите облик оквира...</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5499"/>
        <source>Edit shape of the frame...</source>
        <translation>Уређивање облика оквира...</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5500"/>
        <source>Set radius of corner rounding</source>
        <translation>Подеси полупречник за заобљавање углова</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5501"/>
        <source>Number of columns in text frame</source>
        <translation>Број колона у тексталном оквиру</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5502"/>
        <source>Switches between Gap or Column width</source>
        <translation>Пребацује између ширине процепа и ширине колоне</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5503"/>
        <source>Distance between columns</source>
        <translation>Растојање између колона</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5504"/>
        <source>Distance of text from top of frame</source>
        <translation>Растојање текста од врха оквира</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5505"/>
        <source>Distance of text from bottom of frame</source>
        <translation>Растојање текста од дна оквира</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5506"/>
        <source>Distance of text from left of frame</source>
        <translation>Растојање текста од леве стране оквира</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5507"/>
        <source>Distance of text from right of frame</source>
        <translation>Растојање текста од десне стране оквира</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5508"/>
        <source>Edit tab settings of text frame...</source>
        <translation>Уређивање поставки језичака текстуалног оквира...</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5510"/>
        <source>Allow the image to be a different size to the frame</source>
        <translation>Дозволи да слика буде различите величине од оквира</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5511"/>
        <source>Horizontal offset of image within frame</source>
        <translation>Водоравно одступање слике унутар оквира</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5512"/>
        <source>Vertical offset of image within frame</source>
        <translation>Усправно одступање слике унутар оквира</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5513"/>
        <source>Resize the image horizontally</source>
        <translation>Промени величину слике водоравно</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5514"/>
        <source>Resize the image vertically</source>
        <translation>Промени величину слике усправно</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5515"/>
        <source>Keep the X and Y scaling the same</source>
        <translation>Задржи исто X и Y скалирање</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5516"/>
        <source>Keep the aspect ratio</source>
        <translation>Задржи аспектни однос</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5517"/>
        <source>Make the image fit within the size of the frame</source>
        <translation>Натерај слику да стане у оквир</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5520"/>
        <source>Use image proportions rather than those of the frame</source>
        <translation>Радије користи пропорције слике него оквира</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5521"/>
        <source>Source profile of the image</source>
        <translation>Изворни профил слике</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5522"/>
        <source>Rendering intent for the image</source>
        <translation>Намера рендеровања за слику</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4045"/>
        <source>&amp;X1:</source>
        <translation>&amp;X1:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4046"/>
        <source>X&amp;2:</source>
        <translation>X&amp;2:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4047"/>
        <source>Y&amp;1:</source>
        <translation>Y&amp;1:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4048"/>
        <source>&amp;Y2:</source>
        <translation>&amp;Y2:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3809"/>
        <source>Column width</source>
        <translation>Ширина колона</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5468"/>
        <source>Right to Left Writing</source>
        <translation>Писање с десна на лево</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5249"/>
        <source>Start Arrow:</source>
        <translation>Изглед почетка стрелице:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5250"/>
        <source>End Arrow:</source>
        <translation>Изглед краја стрелице:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5226"/>
        <source>Fixed Linespacing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5227"/>
        <source>Automatic Linespacing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5228"/>
        <source>Align to Baseline Grid</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5208"/>
        <source>Actual X-DPI:</source>
        <translation>Стварна X-тпи:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5209"/>
        <source>Actual Y-DPI:</source>
        <translation>Стварна Y-тпи:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5461"/>
        <source>Offset to baseline of characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5463"/>
        <source>Scaling height of characters</source>
        <translation type="unfinished">Скалирање висине знакова</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5469"/>
        <source>Manual Tracking</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4963"/>
        <source>Name &quot;%1&quot; isn&apos;t unique.&lt;br/&gt;Please choose another.</source>
        <translation>Име &quot;%1&quot; Није јединствено.&lt;br/&gt;Изабери друго.</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5158"/>
        <source>Fill Rule</source>
        <translation>Начин попуњавања</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5159"/>
        <source>Even-Odd</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5160"/>
        <source>Non Zero</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5283"/>
        <source>Overprinting</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5284"/>
        <source>Knockout</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5285"/>
        <source>Overprint</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5464"/>
        <source>Color of text stroke and/or drop shadow, depending which is chosen.If both are chosen, then they share the same color.</source>
        <translation>Боја уоквирења текста или бачене сенке, у зависности од тога која је опција одабрана. Ако су обе активне онда деле исту боју.</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5465"/>
        <source>Color of selected text. If Outline text decoration is enabled, this color will be the fill color. If Drop Shadow Text is enabled, then this will be the top most color.</source>
        <translation>Боја изабраног текста. Ако је уоквиравање текста изабрано, ово ће бити боја попуњавања. Ако је изабрана и бачена сенка, онда ће ово бити \&quot;највиша\&quot; боја.</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5137"/>
        <source>Gap:</source>
        <translation>Размак:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5138"/>
        <source>Width:</source>
        <translation type="unfinished">Ширина:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5167"/>
        <source>Text &amp;Flow Around Frame</source>
        <translation>Текст тече око рама</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5168"/>
        <source>Disabled</source>
        <translation>Не</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5169"/>
        <source>Use Frame &amp;Shape</source>
        <translation>Користи облик рама</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5216"/>
        <source>Image Effects</source>
        <translation>Ефекти на слици</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5217"/>
        <source>Extended Image Properties</source>
        <translation>Додатна својства слике</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5453"/>
        <source>Disable text flow from lower frames around object</source>
        <translation>Искључи проток текста из оквира постављених испод објекта</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5454"/>
        <source>Use the frame shape for text flow of text frames below the object.</source>
        <translation>За ток текста користи облик из текстуалних оквира испод објекта</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5455"/>
        <source>Use the bounding box, which is always rectangular, instead of the frame&apos;s shape for text flow of text frames below the object. </source>
        <translation>Користи оквирну линију, која је увек правоугаона, уместо облика рама за ток текста из текстуалних оквира испод објекта.</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5112"/>
        <source>Transparency Settings</source>
        <translation>Подешења провидности</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5095"/>
        <source>&amp;Group</source>
        <translation type="unfinished">&amp;Група</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5113"/>
        <source>Opacity:</source>
        <translation type="unfinished">Непрозирност:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5114"/>
        <source>Blend Mode:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5117"/>
        <source>Normal</source>
        <translation type="unfinished">Нормално</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5118"/>
        <source>Darken</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5119"/>
        <source>Lighten</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5120"/>
        <source>Multiply</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5121"/>
        <source>Screen</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5122"/>
        <source>Overlay</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5123"/>
        <source>Hard Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5124"/>
        <source>Soft Light</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5125"/>
        <source>Difference</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5126"/>
        <source>Exclusion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5127"/>
        <source>Color Dodge</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5128"/>
        <source>Color Burn</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5129"/>
        <source>Hue</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5131"/>
        <source>Color</source>
        <translation type="unfinished">Боја</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5435"/>
        <source>Group the selected objects</source>
        <translation>Групиши изабране објекте</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4739"/>
        <source>Destroys the selected group</source>
        <translation type="obsolete">Растури изабрану групу</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3154"/>
        <source>Auto</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5456"/>
        <source>When chosen, the contour line can be edited with the Edit Shape Tool on the palette further above. When edited via the shape palette, this becomes a second separate line originally based on the frame&apos;s shape for text flow of text frames below the object. T</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4774"/>
        <source>Click and hold down to select the line spacing mode.</source>
        <translation type="obsolete">Кликни и држи притиснут тастер миша да би изабрао проред између редова текста.</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5149"/>
        <source>Default</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5150"/>
        <source>Stair Step</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5151"/>
        <source>Skew</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5153"/>
        <source>Flip Text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5155"/>
        <source>Type:</source>
        <translation type="unfinished">Врста:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5172"/>
        <source>Use Image Clip Path</source>
        <translation>Користи стазу за опсецање</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5173"/>
        <source>Paragraph St&amp;yle:</source>
        <translation>Ст&amp;ил параграфа:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5174"/>
        <source>Character St&amp;yle:</source>
        <translation>Ст&amp;ил знака:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4902"/>
        <source>Optical Margins:</source>
        <translation type="obsolete">Оптичке маргине:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5194"/>
        <source>Word Tracking</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5198"/>
        <source>Min:</source>
        <translation>Мин:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5196"/>
        <source>Norm:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5197"/>
        <source>Glyph Extension</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5199"/>
        <source>Max:</source>
        <translation>Макс:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5457"/>
        <source>Use the clipping path of the image</source>
        <translation>Користи линију опсецања слике</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5473"/>
        <source>Paragraph style of currently selected text or paragraph</source>
        <translation>Стил параграфа тренутно изабраног текста или параграфа</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5474"/>
        <source>Character style of currently selected text or paragraph</source>
        <translation>Стил знака тренутно изабраног текста или параграфа</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5483"/>
        <source>Minimal width of spaces between words</source>
        <translation>Најмања ширина размака између речи</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5484"/>
        <source>Normal width of spaces between words</source>
        <translation>Уобичајна ширина размака између речи</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5485"/>
        <source>Minimal shrinkage of glyphs for justification</source>
        <translation>Најмање скупљање знака за коришћење при поравнавању текста</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5486"/>
        <source>Maximal extension of glyphs for justification</source>
        <translation>Највеће проширење знака за коришћење при поравнавању текста</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5475"/>
        <source>Remove Direct Paragraph Formatting</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5476"/>
        <source>Remove Direct Character Formatting</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5446"/>
        <source>Enable or disable exporting of the object</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5240"/>
        <source>Custom</source>
        <translation type="unfinished">Произвољно</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5110"/>
        <source>&amp;Edit...</source>
        <translation type="unfinished">&amp;Уреди...</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5203"/>
        <source>First Line Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="832"/>
        <source>Maximum Ascent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="833"/>
        <source>Font Ascent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5200"/>
        <source>Color &amp; Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5201"/>
        <source>Advanced Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5202"/>
        <source>Style Settings</source>
        <translation type="unfinished">Поставке стила</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3156"/>
        <source>Baseline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5436"/>
        <source>Ungroup the selected group</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5472"/>
        <source>Select the line spacing mode.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5479"/>
        <source>Set the height of the first line of the text frame to use the tallest height of the included characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5480"/>
        <source>Set the height of the first line of text frame to use the full ascent of the font(s) in use</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5481"/>
        <source>Set the height of the first line of the text frame to the specified line height</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5206"/>
        <source>&amp;Page Number:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5204"/>
        <source>Columns &amp; Text Distances</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4984"/>
        <source>Left Protruding</source>
        <translation type="obsolete">Избачен лево</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4985"/>
        <source>Right Protruding</source>
        <translation type="obsolete">Избачен десно</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5193"/>
        <source>Reset</source>
        <translation type="unfinished">Ресетуј</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="945"/>
        <source>Optical Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5310"/>
        <source>Hairline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5189"/>
        <source>None</source>
        <comment>optical margins</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5190"/>
        <source>Both Sides</source>
        <comment>optical margins</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5191"/>
        <source>Left Only</source>
        <comment>optical margins</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5192"/>
        <source>Right Only</source>
        <comment>optical margins</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5495"/>
        <source>Arrow head style for start of line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5496"/>
        <source>Arrow head style for end of line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5518"/>
        <source>Effective horizontal DPI of the image after scaling</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5519"/>
        <source>Effective vertical DPI of the image after scaling</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PythonConsole</name>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="93"/>
        <source>&amp;Open...</source>
        <translation type="unfinished">&amp;Отвори...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="98"/>
        <source>&amp;Save</source>
        <translation type="unfinished">&amp;Сними</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="103"/>
        <source>Save &amp;As...</source>
        <translation type="unfinished">Сними &amp;као...</translation>
    </message>
    <message>
        <location filename="../plugins/scriptplugin/pconsole.ui" line="96"/>
        <source>&amp;Exit</source>
        <translation type="obsolete">&amp;Изађи</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="71"/>
        <source>&amp;File</source>
        <translation type="unfinished">&amp;Фајл</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="113"/>
        <source>&amp;Run</source>
        <translation>&amp;Покрени</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="118"/>
        <source>Run As &amp;Console</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="123"/>
        <source>&amp;Save Output...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="81"/>
        <source>&amp;Script</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="60"/>
        <source>Scribus Python Console</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="13"/>
        <source>Script Console</source>
        <translation type="unfinished">Конзола за скрипте</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="117"/>
        <source>Write your commands here. A selection is processed as script</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="118"/>
        <source>Output of your script</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="195"/>
        <source>Save the Python Commands in File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="220"/>
        <source>Text Files (*.txt)</source>
        <translation>Текстуални фајлови (*.txt)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="218"/>
        <source>Save Current Output</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="161"/>
        <source>Open Python Script File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="197"/>
        <source>Python Scripts (*.py *.PY)</source>
        <translation>Python скрипте (*.py *.PY)</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>Line: %1 Column: %2</source>
        <translation type="obsolete">Линија: %1 Колона: %2</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="33"/>
        <source>Col: %1 Row: %2/%3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="44"/>
        <source>Ctrl+O</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="45"/>
        <source>Ctrl+S</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="108"/>
        <source>&amp;Quit</source>
        <translation type="unfinished">&amp;Заврши</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="65"/>
        <source>This is a standard Python console with some 
known limitations. Please consult the Scribus 
Scripter documentation for futher information. </source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>QColorDialog</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="130"/>
        <source>Hu&amp;e:</source>
        <translation>Нијансира&amp;ј:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="131"/>
        <source>&amp;Sat:</source>
        <translation>&amp;Зас:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="132"/>
        <source>&amp;Val:</source>
        <translation>&amp;Вре:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="133"/>
        <source>&amp;Red:</source>
        <translation>&amp;Црвена:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="134"/>
        <source>&amp;Green:</source>
        <translation>&amp;Зелена:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="135"/>
        <source>Bl&amp;ue:</source>
        <translation>Пл&amp;ава:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="136"/>
        <source>A&amp;lpha channel:</source>
        <translation>А&amp;лфа канал:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="137"/>
        <source>&amp;Basic colors</source>
        <translation>&amp;Основне боје</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="138"/>
        <source>&amp;Custom colors</source>
        <translation>&amp;Произвољне боје</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="139"/>
        <source>&amp;Define Custom Colors &gt;&gt;</source>
        <translation>&amp;Дефинишите произвољне боје &gt;&gt;</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="140"/>
        <source>OK</source>
        <translation>У реду</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="141"/>
        <source>Cancel</source>
        <translation>Поништи</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="142"/>
        <source>&amp;Add to Custom Colors</source>
        <translation>&amp;Додај у биране боје</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="143"/>
        <source>Select color</source>
        <translation>Изаберите боју</translation>
    </message>
</context>
<context>
    <name>QFileDialog</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="14"/>
        <source>Copy or Move a File</source>
        <translation>Копирај или помери фајл</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="15"/>
        <source>Read: %1</source>
        <translation>Прочитај: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="16"/>
        <source>Write: %1</source>
        <translation>Упиши: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="17"/>
        <source>File &amp;name:</source>
        <translation>&amp;Име фајла:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="18"/>
        <source>File &amp;type:</source>
        <translation>&amp;Врста фајла:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="19"/>
        <source>One directory up</source>
        <translation>Један директоријум горе</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="20"/>
        <source>Cancel</source>
        <translation>Поништи</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="21"/>
        <source>All Files (*)</source>
        <translation>Сви фајлови (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="22"/>
        <source>Name</source>
        <translation>Име</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="23"/>
        <source>Size</source>
        <translation>Величина</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="24"/>
        <source>Type</source>
        <translation>Врста</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="25"/>
        <source>Date</source>
        <translation>Датум</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="26"/>
        <source>Attributes</source>
        <translation>Атрибути</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="27"/>
        <source>OK</source>
        <translation>У реду</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="28"/>
        <source>Look &amp;in:</source>
        <translation>Т&amp;ражи у:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="29"/>
        <source>Back</source>
        <translation>Назад</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="30"/>
        <source>Create New Folder</source>
        <translation>Направи нови директоријум</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="31"/>
        <source>List View</source>
        <translation>Приказ листе</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="32"/>
        <source>Detail View</source>
        <translation>Приказ детаља</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="33"/>
        <source>Preview File Info</source>
        <translation>Преглед информација о фајлу</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="34"/>
        <source>Preview File Contents</source>
        <translation>Преглед садржаја фајла</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="35"/>
        <source>Read-write</source>
        <translation>Читање-упис</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="36"/>
        <source>Read-only</source>
        <translation>Само за читање</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="37"/>
        <source>Write-only</source>
        <translation>Само за упис</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="38"/>
        <source>Inaccessible</source>
        <translation>Није приступачан</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="39"/>
        <source>Symlink to File</source>
        <translation>Симболичка веза до фајла</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="40"/>
        <source>Symlink to Directory</source>
        <translation>Симболичка веза до директоријума</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="41"/>
        <source>Symlink to Special</source>
        <translation>Симболичка веза до специјалног</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="42"/>
        <source>File</source>
        <translation>Фајл</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="43"/>
        <source>Dir</source>
        <translation>Дир.</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="44"/>
        <source>Special</source>
        <translation>Специјално</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="45"/>
        <source>Open</source>
        <translation>Отвори</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="46"/>
        <source>Save As</source>
        <translation>Сними као</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="47"/>
        <source>&amp;Open</source>
        <translation>&amp;Отвори</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="48"/>
        <source>&amp;Save</source>
        <translation>&amp;Сними</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="49"/>
        <source>&amp;Rename</source>
        <translation>&amp;Преименуј</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="50"/>
        <source>&amp;Delete</source>
        <translation>&amp;Обриши</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="51"/>
        <source>R&amp;eload</source>
        <translation>У&amp;читај поново</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="52"/>
        <source>Sort by &amp;Name</source>
        <translation>Поређај по &amp;имену</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="53"/>
        <source>Sort by &amp;Size</source>
        <translation>Поређај по &amp;величини</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="54"/>
        <source>Sort by &amp;Date</source>
        <translation>Поређај по &amp;датуму</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="55"/>
        <source>&amp;Unsorted</source>
        <translation>&amp;Није поређано</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="56"/>
        <source>Sort</source>
        <translation>Поређај</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="57"/>
        <source>Show &amp;hidden files</source>
        <translation>Приказуј &amp;скривене фајлове</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="58"/>
        <source>the file</source>
        <translation>тај фајл</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="59"/>
        <source>the directory</source>
        <translation>тај директоријум</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="60"/>
        <source>the symlink</source>
        <translation>та симболичка веза</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="61"/>
        <source>Delete %1</source>
        <translation>Обриши %1</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="62"/>
        <source>&lt;qt&gt;Are you sure you wish to delete %1 &quot;%2&quot;?&lt;/qt&gt;</source>
        <translation>&lt;qt&gt;Да ли сте сигурни да желите да обришете %1 „%2“?&lt;/qt&gt;</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="65"/>
        <source>New Folder 1</source>
        <translation>Нови директоријум 1</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="66"/>
        <source>New Folder</source>
        <translation>Нови директоријум</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="67"/>
        <source>New Folder %1</source>
        <translation>Нови директоријум %1</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="68"/>
        <source>Find Directory</source>
        <translation>Нађи директоријум</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="69"/>
        <source>Directories</source>
        <translation>Директоријуми</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="70"/>
        <source>Save</source>
        <translation>Сними</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="71"/>
        <source>Error</source>
        <translation>Грешка</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="72"/>
        <source>%1
File not found.
Check path and filename.</source>
        <translation>%1
Фајл није пронађен.
Проверите путању и име фајла.</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="73"/>
        <source>All Files (*.*)</source>
        <translation>Сви фајлови (*.*)</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="74"/>
        <source>Select a Directory</source>
        <translation>Изаберите директоријум</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="75"/>
        <source>Directory:</source>
        <translation>Директоријум:</translation>
    </message>
</context>
<context>
    <name>QFontDialog</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="147"/>
        <source>&amp;Font</source>
        <translation>&amp;Фонт</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="148"/>
        <source>Font st&amp;yle</source>
        <translation>Ст&amp;ил фонта</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="149"/>
        <source>&amp;Size</source>
        <translation>&amp;Величина</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="150"/>
        <source>Effects</source>
        <translation>Ефекти</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="151"/>
        <source>Stri&amp;keout</source>
        <translation>&amp;Прецртано</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="152"/>
        <source>&amp;Underline</source>
        <translation>&amp;Подвуци</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="153"/>
        <source>&amp;Color</source>
        <translation>&amp;Боја</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="154"/>
        <source>Sample</source>
        <translation>Пример</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="155"/>
        <source>Scr&amp;ipt</source>
        <translation>Скр&amp;ипт</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="156"/>
        <source>OK</source>
        <translation>У реду</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="157"/>
        <source>Apply</source>
        <translation>Примени</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="158"/>
        <source>Cancel</source>
        <translation>Поништи</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="159"/>
        <source>Close</source>
        <translation>Затвори</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="160"/>
        <source>Select Font</source>
        <translation>Изаберите фонт</translation>
    </message>
</context>
<context>
    <name>QLineEdit</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="79"/>
        <source>Clear</source>
        <translation>Очисти</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="80"/>
        <source>Select All</source>
        <translation>Изабери све</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="81"/>
        <source>&amp;Undo</source>
        <translation>&amp;Опозови</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="82"/>
        <source>&amp;Redo</source>
        <translation>Поно&amp;ви</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="83"/>
        <source>Cu&amp;t</source>
        <translation>&amp;Исеци</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="84"/>
        <source>&amp;Copy</source>
        <translation>&amp;Копирај</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="85"/>
        <source>&amp;Paste</source>
        <translation>&amp;Пренеси</translation>
    </message>
</context>
<context>
    <name>QMainWindow</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="99"/>
        <source>Line up</source>
        <translation>Поравнај</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="100"/>
        <source>Customize...</source>
        <translation>Подеси...</translation>
    </message>
</context>
<context>
    <name>QMessageBox</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="9"/>
        <source>&lt;h3&gt;About Qt&lt;/h3&gt;&lt;p&gt;This program uses Qt version %1.&lt;/p&gt;&lt;p&gt;Qt is a C++ toolkit for multiplatform GUI &amp;amp; application development.&lt;/p&gt;&lt;p&gt;Qt provides single-source portability across MS&amp;nbsp;Windows, Mac&amp;nbsp;OS&amp;nbsp;X, Linux, and all major commercial Unix variants.&lt;br&gt;Qt is also available for embedded devices.&lt;/p&gt;&lt;p&gt;Qt is a Trolltech product. See &lt;tt&gt;http://www.trolltech.com/qt/&lt;/tt&gt; for more information.&lt;/p&gt;</source>
        <translation>&lt;h3&gt;О Qt-у&lt;/h3&gt;
&lt;p&gt;Овај програм користи Qt верзију %1.&lt;/p&gt;
&lt;p&gt;Qt је  вишеплатформски C++ GUI скуп алата од 
фирме Trolltech.&lt;/p&gt;
&lt;p&gt;Qt пружа портабилност на нивоу изворног 
кода кроз MS Windows, Mac OS X, Linux, и све главне 
комерцијалне Unix варијанте.
&lt;br&gt;Qt такође, постоји и за преносне и 
уградиве уређаје.&lt;/p&gt;
&lt;p&gt;Погледајте &lt;tt&gt;http://www.trolltech.com/qt/&lt;/tt&gt; за више 
информација.&lt;/p&gt;</translation>
    </message>
</context>
<context>
    <name>QObject</name>
    <message>
        <location filename="../../scribus/gtaction.cpp" line="77"/>
        <source>Importing text</source>
        <translation>Увозим текст</translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="195"/>
        <source>All Supported Formats</source>
        <translation>Сви подржани формати</translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="242"/>
        <source>All Files (*)</source>
        <translation>Сви фајлови (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="327"/>
        <source>Font %1 is broken, discarding it</source>
        <translation>Фонт %1 није исправан, одбацујем га</translation>
    </message>
    <message>
        <location filename="../../scribus/scribuscore.cpp" line="247"/>
        <source>Initializing...</source>
        <translation>Иницијализује се...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus13format/scribus13format.cpp" line="1104"/>
        <source>Background</source>
        <translation>Позадина</translation>
    </message>
    <message>
        <location filename="../plugins/svgexplugin/svgexplugin.cpp" line="139"/>
        <source>Do you really want to overwrite the File:
%1 ?</source>
        <translation type="obsolete">Да ли стварно желите да пребришете фајл: 
%1 ?</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="155"/>
        <source>Newsletters</source>
        <translation>Кружно писмо</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="156"/>
        <source>Brochures</source>
        <translation>Брошуре</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="157"/>
        <source>Catalogs</source>
        <translation>Каталози</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="158"/>
        <source>Flyers</source>
        <translation>Флајери</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="159"/>
        <source>Signs</source>
        <translation>Знаци</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="160"/>
        <source>Cards</source>
        <translation>Картице</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="161"/>
        <source>Letterheads</source>
        <translation>Заглавља</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="162"/>
        <source>Envelopes</source>
        <translation>Коверте</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="163"/>
        <source>Business Cards</source>
        <translation>Подсетнице</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="164"/>
        <source>Calendars</source>
        <translation>Календари</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="165"/>
        <source>Advertisements</source>
        <translation>Огласи</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="166"/>
        <source>Labels</source>
        <translation>Ознаке</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="167"/>
        <source>Menus</source>
        <translation>Менији</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="168"/>
        <source>Programs</source>
        <translation>Програми</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="169"/>
        <source>PDF Forms</source>
        <translation>PDF формулари</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="170"/>
        <source>PDF Presentations</source>
        <translation>PDF презентације</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="171"/>
        <source>Magazines</source>
        <translation>Часописи</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="172"/>
        <source>Posters</source>
        <translation>Постери</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="173"/>
        <source>Announcements</source>
        <translation>Објаве</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="174"/>
        <source>Text Documents</source>
        <translation>Текстуални документи</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="175"/>
        <source>Folds</source>
        <translation>Фасцикле</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satemplate.cpp" line="261"/>
        <source>Own Templates</source>
        <translation>Властити шаблони</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="126"/>
        <source>Open</source>
        <translation>Отвори</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="570"/>
        <source>&amp;Scribus Scripts</source>
        <translation type="unfinished">&amp;Scribus скрипте</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="565"/>
        <source>&amp;Execute Script...</source>
        <translation type="unfinished">&amp;Изврши скрипту...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="571"/>
        <source>&amp;Recent Scripts</source>
        <translation type="unfinished">&amp;Скорашње скрипте</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="566"/>
        <source>Show &amp;Console</source>
        <translation type="unfinished">Прикажи &amp;конзолу</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="126"/>
        <source>Save as</source>
        <translation>Сними као</translation>
    </message>
    <message>
        <location filename="../plugins/svgimplugin/svgplugin.cpp" line="151"/>
        <source>SVG-Images (*.svg *.svgz);;All Files (*)</source>
        <translation type="obsolete">SVG-слике (*.svg *.svgz);;Сви фајлови (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvim.cpp" line="12"/>
        <source>Comma Separated Value Files</source>
        <translation>Фајлови са вредностима одвојеним запетом</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvim.cpp" line="58"/>
        <source>CSV_data</source>
        <translation>CSV_подаци</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvim.cpp" line="62"/>
        <source>CSV_header</source>
        <translation>CSV_заглавље</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/htmlim/htmlim.cpp" line="43"/>
        <source>HTML Files</source>
        <translation>HTML фајлови</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/htmlim/htmlim.cpp" line="48"/>
        <source>html</source>
        <translation>html</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/htmlim/htmlreader.cpp" line="616"/>
        <source>
External Links
</source>
        <translation>
Спољашње везе</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/textfilter/textfilter.cpp" line="26"/>
        <source>Text Filters</source>
        <translation>Текст филтери</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/txtim/txtim.cpp" line="21"/>
        <source>Text Files</source>
        <translation>Текстуални фајлови</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="176"/>
        <source>Media Cases</source>
        <translation>Медисјки случајеви</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="60"/>
        <source>Albanian</source>
        <translation>Албански</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="61"/>
        <source>Basque</source>
        <translation>Баскијски</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="64"/>
        <source>Bulgarian</source>
        <translation>Бугарски</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="65"/>
        <source>Catalan</source>
        <translation type="unfinished">Каталански</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="66"/>
        <source>Chinese</source>
        <translation>Кинески</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="70"/>
        <source>Czech</source>
        <translation type="unfinished">Чешки</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="72"/>
        <source>Danish</source>
        <translation type="unfinished">Дански</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="74"/>
        <source>Dutch</source>
        <translation type="unfinished">Холандски</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="239"/>
        <source>English</source>
        <translation type="unfinished">Енглески</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="77"/>
        <source>English (British)</source>
        <translation>Британски енглески</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="79"/>
        <source>Esperanto</source>
        <translation>Есперанто</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="81"/>
        <source>German</source>
        <translation type="unfinished">Немачки</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="84"/>
        <source>Finnish</source>
        <translation type="unfinished">Фински</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="85"/>
        <source>French</source>
        <translation type="unfinished">Француски</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="88"/>
        <source>Galician</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="89"/>
        <source>Greek</source>
        <translation type="unfinished">Грчки</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="91"/>
        <source>Hungarian</source>
        <translation type="unfinished">Мађарски</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="94"/>
        <source>Indonesian</source>
        <translation>Индонежански</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="95"/>
        <source>Italian</source>
        <translation type="unfinished">Италијански</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="98"/>
        <source>Korean</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="102"/>
        <source>Lithuanian</source>
        <translation type="unfinished">Литвански</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="108"/>
        <source>Norwegian (Nnyorsk)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="110"/>
        <source>Norwegian</source>
        <translation>Норвешки</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="112"/>
        <source>Polish</source>
        <translation type="unfinished">Пољски</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="116"/>
        <source>Russian</source>
        <translation type="unfinished">Руски</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="124"/>
        <source>Swedish</source>
        <translation type="unfinished">Шведски</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="119"/>
        <source>Spanish</source>
        <translation type="unfinished">Шпански</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="120"/>
        <source>Spanish (Latin)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="121"/>
        <source>Slovak</source>
        <translation type="unfinished">Словачки</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="122"/>
        <source>Slovenian</source>
        <translation type="unfinished">Словеначки</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="123"/>
        <source>Serbian</source>
        <translation>Српски</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="28"/>
        <source>Cannot get font size of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="54"/>
        <source>Cannot get font of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="80"/>
        <source>Cannot get text size of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="116"/>
        <source>Cannot get column count of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="134"/>
        <source>Cannot get line space of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="174"/>
        <source>Cannot get column gap of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="224"/>
        <source>Cannot get text of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="257"/>
        <source>Cannot set text of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="291"/>
        <source>Cannot insert text into non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="329"/>
        <source>Alignment out of range. Use one of the scribus.ALIGN* constants.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="564"/>
        <source>Selection index out of bounds</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.cpp" line="220"/>
        <source>Unit out of range. Use one of the scribus.UNIT_* constants.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="27"/>
        <source>Target is not an image frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="350"/>
        <source>Corner radius must be a positive number.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="64"/>
        <source>Cannot get a color with an empty name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="87"/>
        <source>Cannot change a color with an empty name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="123"/>
        <source>Cannot create a color with an empty name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="159"/>
        <source>Cannot delete a color with an empty name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="204"/>
        <source>Cannot replace a color with an empty name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/sxwim/sxwim.cpp" line="45"/>
        <source>OpenOffice.org Writer Documents</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.cpp" line="65"/>
        <source>Color not found - python error</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/configuration.cpp" line="153"/>
        <source>Custom (optional) configuration: </source>
        <comment>short words plugin</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/configuration.cpp" line="149"/>
        <source>Standard configuration: </source>
        <comment>short words plugin</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/shortwords.cpp" line="129"/>
        <source>Short Words processing. Wait please...</source>
        <comment>short words plugin</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/shortwords.cpp" line="148"/>
        <source>Short Words processing. Done.</source>
        <comment>short words plugin</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="58"/>
        <source>Afrikaans</source>
        <translation type="unfinished">Африканерски</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="128"/>
        <source>Turkish</source>
        <translation>Турски</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="129"/>
        <source>Ukranian</source>
        <translation>Украјински</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="131"/>
        <source>Welsh</source>
        <translation>Велшки</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/objimageexport.cpp" line="75"/>
        <source>The filename must be a string.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/objimageexport.cpp" line="98"/>
        <source>Cannot delete image type settings.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/objimageexport.cpp" line="102"/>
        <source>The image type must be a string.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/objimageexport.cpp" line="127"/>
        <source>&apos;allTypes&apos; attribute is READ-ONLY</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/objimageexport.cpp" line="188"/>
        <source>Failed to export image</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="291"/>
        <source>Cannot scale by 0%.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="406"/>
        <source>Specified item not an image frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="417"/>
        <source>Font not found.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="104"/>
        <source>Cannot render an empty sample.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="690"/>
        <source>Cannot have an empty layer name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="729"/>
        <source>Layer not found.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="695"/>
        <source>Cannot remove the last layer.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="746"/>
        <source>Cannot create layer without a name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="300"/>
        <source>Insert index out of bounds.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="337"/>
        <source>Cannot set text alignment on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="363"/>
        <source>Font size out of bounds - must be 1 &lt;= size &lt;= 512.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="372"/>
        <source>Cannot set font size on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="401"/>
        <source>Cannot set font on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="435"/>
        <source>Line space out of bounds, must be &gt;= 0.1.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="443"/>
        <source>Cannot set line spacing on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="498"/>
        <source>Column gap out of bounds, must be positive.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="506"/>
        <source>Cannot set column gap on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="525"/>
        <source>Column count out of bounds, must be &gt; 1.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="533"/>
        <source>Cannot set number of columns on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="569"/>
        <source>Cannot select text in a non-text frame</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="606"/>
        <source>Cannot delete text from a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="638"/>
        <source>Cannot set text fill on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="674"/>
        <source>Cannot set text stroke on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="787"/>
        <source>Cannot set text shade on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="827"/>
        <source>Can only link text frames.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="837"/>
        <source>Target frame links to another frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="842"/>
        <source>Target frame is linked to by another frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="847"/>
        <source>Source and target are the same object.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="872"/>
        <source>Cannot unlink a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="927"/>
        <source>Cannot convert a non-text frame to outlines.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/page.cpp" line="82"/>
        <source>Page</source>
        <translation type="unfinished">Страница</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="585"/>
        <source>Scribus Development Version</source>
        <translation>Развојни тим Скрибуса</translation>
    </message>
    <message>
        <location filename="../units.cpp" line="135"/>
        <source> pt</source>
        <translation type="obsolete"> тач.</translation>
    </message>
    <message>
        <location filename="../units.cpp" line="136"/>
        <source> mm</source>
        <translation type="obsolete"> mm</translation>
    </message>
    <message>
        <location filename="../units.cpp" line="137"/>
        <source> in</source>
        <translation type="obsolete"> in</translation>
    </message>
    <message>
        <location filename="../units.cpp" line="138"/>
        <source> p</source>
        <translation type="obsolete"> p</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="155"/>
        <source>pt</source>
        <translation type="unfinished">pt</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="156"/>
        <source>mm</source>
        <translation type="unfinished">mm</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="157"/>
        <source>in</source>
        <translation type="unfinished">in</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="158"/>
        <source>p</source>
        <translation type="unfinished">p</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="207"/>
        <source>Points (pt)</source>
        <translation type="unfinished">тачке (pt)</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="209"/>
        <source>Inches (in)</source>
        <translation type="unfinished">Инчи (in)</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="210"/>
        <source>Picas (p)</source>
        <translation type="unfinished">Пика (p)</translation>
    </message>
    <message>
        <location filename="../../scribus/util.cpp" line="362"/>
        <source>File exists</source>
        <translation>Фајл постоји</translation>
    </message>
    <message>
        <location filename="" line="136965632"/>
        <source>&amp;Replace</source>
        <translation type="obsolete">&amp;Замени</translation>
    </message>
    <message>
        <location filename="../../scribus/scprintengine_gdi.cpp" line="486"/>
        <source>All</source>
        <translation type="unfinished">Све</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.cpp" line="153"/>
        <source>Failed to open document.</source>
        <comment>python error</comment>
        <translation>Неуспешно опварање документа.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.cpp" line="182"/>
        <source>Failed to save document.</source>
        <comment>python error</comment>
        <translation>Неуспешно снимање документа.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="39"/>
        <source>Argument must be page item name, or PyCObject instance</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="90"/>
        <source>Property not found</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="310"/>
        <source>Couldn&apos;t convert result type &apos;%1&apos;.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="442"/>
        <source>Property type &apos;%1&apos; not supported</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="461"/>
        <source>Couldn&apos;t convert &apos;%1&apos; to property type &apos;%2&apos;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="469"/>
        <source>Types matched, but setting property failed.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="138"/>
        <source>Unable to save pixmap</source>
        <comment>scripter error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="215"/>
        <source>Point list must contain at least two points (four values).</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="300"/>
        <source>Point list must contain an even number of values.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="295"/>
        <source>Point list must contain at least three points (six values).</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="377"/>
        <source>Point list must contain at least four points (eight values).</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="382"/>
        <source>Point list must have a multiple of six values.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="481"/>
        <source>Object not found.</source>
        <comment>python error</comment>
        <translation>Објекат није пронађен.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="607"/>
        <source>Style not found.</source>
        <comment>python error</comment>
        <translation>Стил није пронађен.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="633"/>
        <source>Cannot set style on a non-text frame.</source>
        <comment>python error</comment>
        <translation>Не могу да подесим стил нетекстуалног оквира.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="58"/>
        <source>Failed to save EPS.</source>
        <comment>python error</comment>
        <translation>Неуспешно снимање EPS.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="149"/>
        <source>Page number out of range.</source>
        <comment>python error</comment>
        <translation>Број стране изван опсега.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="292"/>
        <source>argument is not list: must be list of float values.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="252"/>
        <source>argument contains non-numeric values: must be list of float values.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="303"/>
        <source>argument contains no-numeric values: must be list of float values.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="245"/>
        <source>Line width out of bounds, must be 0 &lt;= line_width &lt;= 12.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="265"/>
        <source>Line shade out of bounds, must be 0 &lt;= shade &lt;= 100.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="285"/>
        <source>Fill shade out of bounds, must be 0 &lt;= shade &lt;= 100.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="377"/>
        <source>Line style not found.</source>
        <comment>python error</comment>
        <translation>Стил линије није пронађен.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="878"/>
        <source>Object is not a linked text frame, can&apos;t unlink.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="952"/>
        <source>Only text frames can be checked for overflowing</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="567"/>
        <source>&amp;About Script...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="569"/>
        <source>&amp;Script</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptercore.cpp" line="538"/>
        <source>About Script</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="68"/>
        <source>Croatian</source>
        <translation>Хрватски</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="113"/>
        <source>Portuguese</source>
        <translation type="unfinished">Португалски</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="114"/>
        <source>Portuguese (BR)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/main_win32.cpp" line="259"/>
        <source>Scribus Crash</source>
        <translation type="unfinished">Пуцање scribus-а</translation>
    </message>
    <message>
        <location filename="../../scribus/main_nix.cpp" line="128"/>
        <source>Scribus crashes due to Signal #%1</source>
        <translation type="unfinished">Scribus пуца због сигнала #%1</translation>
    </message>
    <message>
        <location filename="../../scribus/main_win32.cpp" line="261"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;У реду</translation>
    </message>
    <message>
        <location filename="../../scribus/page.cpp" line="91"/>
        <source>Master Page </source>
        <translation>Главна страна</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="124"/>
        <source>4A0</source>
        <translation>4A0</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="130"/>
        <source>2A0</source>
        <translation>2A0</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="220"/>
        <source>Comm10E</source>
        <translation>Comm10E</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="226"/>
        <source>DLE</source>
        <translation>DLE</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="41"/>
        <source>Could not open output file %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="57"/>
        <source>Output stream not writeable</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="80"/>
        <source>Verification of settings failed: %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="282"/>
        <source>Could not open input file %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="664"/>
        <source>Unable to read settings XML:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="298"/>
        <source>%1 (line %2 col %3)</source>
        <comment>Load PDF settings</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="317"/>
        <source>Unable to read settings XML: %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="317"/>
        <source>null root node</source>
        <comment>Load PDF settings</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="442"/>
        <source>&lt;pdfVersion&gt; invalid</source>
        <comment>Load PDF settings</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="455"/>
        <source>found %1 &lt;%2&gt; nodes, need 1.</source>
        <comment>Load PDF settings</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="470"/>
        <source>unexpected null &lt;%2&gt; node</source>
        <comment>Load PDF settings</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="478"/>
        <source>node &lt;%1&gt; not an element</source>
        <comment>Load PDF settings</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="498"/>
        <source>element &lt;%1&gt; lacks `value&apos; attribute</source>
        <comment>Load PDF settings</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="527"/>
        <source>element &lt;%1&gt; value must be `true&apos; or `false&apos;</source>
        <comment>Load PDF settings</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="665"/>
        <source>element &lt;lpiSettingsEntry&gt; lacks `name&apos; attribute</source>
        <comment>Load PDF settings</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/ftface.cpp" line="48"/>
        <source>Freetype2 library not available</source>
        <translation>Freetype2 библиотека није доступна</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="186"/>
        <source>Font %1 is broken (read stream), no embedding</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="390"/>
        <source>Font %1 has broken glyph %2 (charcode %3)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ps.h" line="216"/>
        <source>Font %1 cannot be read, no embedding</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="334"/>
        <source>Failed to load font %1 - font type unknown</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="538"/>
        <source>Font %1 loaded from %2(%3)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="554"/>
        <source>Font %1(%2) is duplicate of %3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="666"/>
        <source>Loading font %1 (found using fontconfig)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="671"/>
        <source>Failed to load a font - freetype2 couldn&apos;t find the font file</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="72"/>
        <source>extracting face %1 from font %2 (offset=%3, nTables=%4)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="85"/>
        <source>memcpy header: %1 %2 %3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="94"/>
        <source>table &apos;%1&apos;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="95"/>
        <source>memcpy table: %1 %2 %3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="98"/>
        <source>memcpy offset: %1 %2 %3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../units.cpp" line="139"/>
        <source> cm</source>
        <translation type="obsolete"> cm</translation>
    </message>
    <message>
        <location filename="../units.cpp" line="140"/>
        <source> c</source>
        <translation type="obsolete"> c</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="159"/>
        <source>cm</source>
        <translation>cm</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="160"/>
        <source>c</source>
        <translation>c</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="208"/>
        <source>Millimeters (mm)</source>
        <translation>Милиметри (mm)</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="211"/>
        <source>Centimeters (cm)</source>
        <translation>Центиметри (cm)</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="212"/>
        <source>Cicero (c)</source>
        <translation>Цицеро (c)</translation>
    </message>
    <message>
        <location filename="../../scribus/util.cpp" line="525"/>
        <source>page</source>
        <comment>page export</comment>
        <translation>страна</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="2322"/>
        <source>Document Template: </source>
        <translation>Шаблон документа:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="268"/>
        <source>Color not found.</source>
        <comment>python error</comment>
        <translation>Боја није пронађена.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="173"/>
        <source>Color not found in document.</source>
        <comment>python error</comment>
        <translation>Боја није пронађена у документу.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="184"/>
        <source>Color not found in default colors.</source>
        <comment>python error</comment>
        <translation>Боја није пронађена међу подразумеваним бојама.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="254"/>
        <source>Cannot group less than two items</source>
        <comment>python error</comment>
        <translation>Не могу да направим групу са мање од две ставке</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="229"/>
        <source>Can&apos;t group less than two items</source>
        <comment>python error</comment>
        <translation type="obsolete">Не могу да направим групу са мање од две ставке</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="222"/>
        <source>Need selection or argument list of items to group</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="1044"/>
        <source>Can&apos;t set bookmark on a non-text frame</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="1078"/>
        <source>Can&apos;t get info from a non-text frame</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/objimageexport.cpp" line="80"/>
        <source>The filename should not be empty string.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptplugin.cpp" line="765"/>
        <source>Scribus Python interface module

This module is the Python interface for Scribus. It provides functions
to control scribus and to manipulate objects on the canvas. Each
function is documented individually below.

A few things are common across most of the interface.

Most functions operate on frames. Frames are identified by their name,
a string - they are not real Python objects. Many functions take an
optional (non-keyword) parameter, a frame name.
Many exceptions are also common across most functions. These are
not currently documented in the docstring for each function.
- Many functions will raise a NoDocOpenError if you try to use them
without a document to operate on.
- If you do not pass a frame name to a function that requires one,
the function will use the currently selected frame, if any, or
raise a NoValidObjectError if it can&apos;t find anything to operate
on.
- Many functions will raise WrongFrameTypeError if you try to use them
on a frame type that they do not make sense with. For example, setting
the text color on a graphics frame doesn&apos;t make sense, and will result
in this exception being raised.
- Errors resulting from calls to the underlying Python API will be
passed through unaltered. As such, the list of exceptions thrown by
any function as provided here and in its docstring is incomplete.

Details of what exceptions each function may throw are provided on the
function&apos;s documentation, though as with most Python code this list
is not exhaustive due to exceptions from called functions.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtim.cpp" line="47"/>
        <source>OpenDocument Text Documents</source>
        <translation>OpenDocument текстуални документи</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus13format/scribus13format.cpp" line="2656"/>
        <source>Copy #%1 of </source>
        <translation type="unfinished">Копија #%1 од</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="2013"/>
        <source>Black</source>
        <translation type="unfinished">Црна</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="2015"/>
        <source>Cyan</source>
        <translation type="unfinished">Цијан</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="2017"/>
        <source>Magenta</source>
        <translation type="unfinished">Магента</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="2019"/>
        <source>Yellow</source>
        <translation type="unfinished">Жута</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheel.cpp" line="56"/>
        <source>Color Wheel</source>
        <translation>Точак боја</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="58"/>
        <source>Font Preview</source>
        <translation>Преглед фонтова</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/myplugin/myplugin.cpp" line="45"/>
        <source>My Plugin</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="71"/>
        <source>New From Template</source>
        <translation type="unfinished">Нови из шаблона</translation>
    </message>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="70"/>
        <source>PS/EPS Importer</source>
        <translation type="obsolete">PS/EPS увозник</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satemplate.cpp" line="66"/>
        <source>Save As Template</source>
        <translation>Сачувај као шаблон</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/scriptplugin.cpp" line="133"/>
        <source>Scripter</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/short-words/shortwords.cpp" line="84"/>
        <source>Short Words</source>
        <translation>Скраћенице</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="98"/>
        <source>SVG Export</source>
        <translation>SVG извоз</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgimplugin/svgplugin.cpp" line="102"/>
        <source>SVG Import</source>
        <translation>SVG увоз</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="105"/>
        <source>OpenOffice.org Draw Importer</source>
        <translation>OpenOffice.org Draw увозник</translation>
    </message>
    <message>
        <location filename="../../scribus/main_win32.cpp" line="236"/>
        <source>Scribus crashes due to the following exception : %1</source>
        <translation>Скрибус је умро због: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="318"/>
        <source>Creating Font Cache</source>
        <translation>Правим фонт кеш</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="344"/>
        <source>New Font found, checking...</source>
        <translation>Нови фонт пронађен, проверавам...</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="381"/>
        <source>Modified Font found, checking...</source>
        <translation>Промењен фон пронађен, проверавам...</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="767"/>
        <source>Reading Font Cache</source>
        <translation>Читам фонт кеш</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="814"/>
        <source>Writing updated Font Cache</source>
        <translation>Пишем ажурирани фон кеш</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="831"/>
        <source>Searching for Fonts</source>
        <translation type="unfinished">Тражим фонтове</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="4349"/>
        <source>The changes to your document have not been saved and you have requested to revert them. Do you wish to continue?</source>
        <translation>Промене на документу нису сачуване, а захтевано је враћање на последњу сачувану варијанту. Да ли желиш да наставиш?</translation>
    </message>
    <message>
        <location filename="../../scribus/util.cpp" line="363"/>
        <source>A file named &apos;%1&apos; already exists.&lt;br/&gt;Do you want to replace it with the file you are saving?</source>
        <translation>Фајл под именом &apos;%1&apos; већ постоји.&lt;br/&gt;Да ли желиш да га преснимиш?</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.cpp" line="45"/>
        <source>firstPageOrder is bigger than allowed.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oldscribusformat/oldscribusformat.cpp" line="40"/>
        <source>Old .sla format support</source>
        <translation>Подршка за стари .sla формат.</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="83"/>
        <source>German (Trad.)</source>
        <translation>Немачки (трад.)</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1829"/>
        <source>Exporting PostScript File</source>
        <translation>Извозим PostScript фајл</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1831"/>
        <source>Printing File</source>
        <translation>Штампам фај</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3689"/>
        <source>&lt;p&gt;You are trying to import more pages than there are available in the current document counting from the active page.&lt;/p&gt;Choose one of the following:&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;b&gt;Create&lt;/b&gt; missing pages&lt;/li&gt;&lt;li&gt;&lt;b&gt;Import&lt;/b&gt; pages until the last page&lt;/li&gt;&lt;li&gt;&lt;b&gt;Cancel&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;</source>
        <translation>&lt;p&gt;Покушаваш да увезеш више страна него што је могуће у текућем документу, бројећи од активне стране.&lt;/p&gt;Изабери једану од следећих могућности:&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;b&gt;Направи&lt;/b&gt; недостајуће стране&lt;/li&gt;&lt;li&gt;&lt;b&gt;Увези&lt;/b&gt; до последње стране&lt;/li&gt;&lt;li&gt;&lt;b&gt;Поништи&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3690"/>
        <source>C&amp;reate</source>
        <translation>Н&amp;аправи</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3691"/>
        <source>&amp;Import</source>
        <translation type="unfinished">&amp;Увези</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="126"/>
        <source>Thai</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcode.cpp" line="31"/>
        <source>Barcode Generator</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="173"/>
        <source>OpenOffice.org Draw (*.sxd *.odg);;All Files (*)</source>
        <translation>OpenOffice.org Draw (*.sxd *.odg);;Сви фајлови (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/docim/docim.cpp" line="52"/>
        <source>Word Documents</source>
        <translation>Word документи</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/pdbim/pdbim.cpp" line="32"/>
        <source>Palm PDB Documents</source>
        <comment>PDB Importer</comment>
        <translation>Palm PDB документи</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/pdbim/pdbim.cpp" line="100"/>
        <source>PDB Import</source>
        <comment>PDB Importer</comment>
        <translation>PDB увоз</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/pdbim/pdbim.cpp" line="92"/>
        <source>Could not open file %1</source>
        <comment>PDB Importer</comment>
        <translation>Не могу да отворим фајл %1</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="103"/>
        <source>Luxembourgish</source>
        <translation>Луксембургшки</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="96"/>
        <source>Japanese</source>
        <translation>Јапанск</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/ftface.cpp" line="80"/>
        <source>Font %1(%2) is broken</source>
        <translation>Фонт %1(%2) је неисправан</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="139"/>
        <source>Given master page name does not match any existing.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="59"/>
        <source>Arabic</source>
        <translation>Арапски</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="73"/>
        <source>Dzongkha</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="80"/>
        <source>Estonian</source>
        <translation>Естонски</translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="181"/>
        <source>font %1 </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="183"/>
        <source>size %1 </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="185"/>
        <source>+style </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="187"/>
        <source>+color </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="189"/>
        <source>+underline </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="189"/>
        <source>-underline </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="191"/>
        <source>+strikeout </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="191"/>
        <source>-strikeout </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="193"/>
        <source>+shadow </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="193"/>
        <source>-shadow </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="195"/>
        <source>+outline </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="195"/>
        <source>-outline </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="197"/>
        <source>-tracking </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="201"/>
        <source>+stretch </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="203"/>
        <source>parent= %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ps.h" line="53"/>
        <source>Font %1 is broken (no Face), discarding it</source>
        <translation>Фонт %1 је неисправан (нема изглед), распуштам га</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="100"/>
        <source>Latin</source>
        <translation>Латински</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="93"/>
        <source>Icelandic</source>
        <translation>Исландски</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="115"/>
        <source>Romanian</source>
        <translation>Румунски</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="199"/>
        <source>Quarto</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="199"/>
        <source>Foolscap</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="199"/>
        <source>Letter</source>
        <translation type="unfinished">Letter</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="200"/>
        <source>Govt. Letter</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="200"/>
        <source>Legal</source>
        <translation type="unfinished">Legal</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="200"/>
        <source>Ledger</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="200"/>
        <source>Executive</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="201"/>
        <source>Post</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="201"/>
        <source>Crown</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="201"/>
        <source>Large Post</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="201"/>
        <source>Demy</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="202"/>
        <source>Medium</source>
        <translation type="unfinished">Средњи</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="202"/>
        <source>Royal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="202"/>
        <source>Elephant</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="202"/>
        <source>Double Demy</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="203"/>
        <source>Quad Demy</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="203"/>
        <source>STMT</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="203"/>
        <source>A</source>
        <translation>A</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="203"/>
        <source>B</source>
        <translation>B</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="203"/>
        <source>C</source>
        <translation type="unfinished">C</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="204"/>
        <source>D</source>
        <translation>D</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="204"/>
        <source>E</source>
        <translation>E</translation>
    </message>
    <message>
        <location filename="../../scribus/scimgdataloader_tiff.cpp" line="957"/>
        <source>%1 may be corrupted : missing resolution tags</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/ftface.cpp" line="177"/>
        <source>Font %1 has broken glyph %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="205"/>
        <source>Transparency out of bounds, must be 0 &lt;= transparency &lt;= 1.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="225"/>
        <source>Blendmode out of bounds, must be 0 &lt;= blendmode &lt;= 15.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus12format/scribus12format.cpp" line="60"/>
        <source>Scribus 1.2.x Support</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/pdbim/pdbim.cpp" line="101"/>
        <source>This file is not recognized as a PDB document. Please, report this as a bug if you are sure it is one.</source>
        <comment>PDB Importer</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="98"/>
        <source>Cannot get number of lines of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="586"/>
        <source>You are running a development version of Scribus 1.3.x. The document you are working with was created in Scribus 1.2.x.  Saving the current file under 1.3.x renders it unable to be edited in Scribus 1.2.x versions. To preserve the ability to edit in 1.2.x, save this file under a different name and further edit the newly named file and the original will be untouched. Are you sure you wish to proceed with this operation?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="197"/>
        <source>+tracking %1 </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/styles/charstyle.cpp" line="199"/>
        <source>+baseline %1 </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="63"/>
        <source>Breton</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="78"/>
        <source>English (American)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scimgdataloader_jpeg.cpp" line="314"/>
        <source>%1 may be corrupted : missing or wrong resolution tags</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="76"/>
        <source>English (Australian)</source>
        <translation>Аустралијски енглески</translation>
    </message>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="141"/>
        <source>All Supported Formats (*.eps *.EPS *.epsi *.EPSI *.ps *.PS);;</source>
        <translation type="obsolete">Сви подржани формати (*.eps *.EPS *.epsi *.EPSI *.ps *.PS);;</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="82"/>
        <source>German (Swiss)</source>
        <translation>Немачни (Швајцарска)</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="90"/>
        <source>Hebrew</source>
        <translation>Хебрејски</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ps.cpp" line="99"/>
        <source>Font %1 has broken metrics in file %2, ignoring metrics</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="72"/>
        <source>Image</source>
        <translation type="obsolete">Слика</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="99"/>
        <source>Text</source>
        <translation type="obsolete">Текст</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="104"/>
        <source>Line</source>
        <translation type="obsolete">Линија</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="107"/>
        <source>Polygon</source>
        <translation type="obsolete">Полигон</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="110"/>
        <source>Polyline</source>
        <translation type="obsolete">Полилинија</translation>
    </message>
    <message>
        <location filename="../outlinepalette.cpp" line="113"/>
        <source>PathText</source>
        <translation type="obsolete">Текста путање</translation>
    </message>
    <message>
        <location filename="../../scribus/serializer.cpp" line="380"/>
        <source>Copy of %1 (%2)</source>
        <translation>Копија %1 (%2)</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="67"/>
        <source>Chinese (Trad.)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus13format/scribus13format.cpp" line="64"/>
        <source>Scribus 1.3.0-&gt;1.3.3.x Support</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../units.cpp" line="143"/>
        <source> %</source>
        <translation type="obsolete"> %</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="163"/>
        <source>%</source>
        <translation type="unfinished">%</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="97"/>
        <source>Khmer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="99"/>
        <source>Lao</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="130"/>
        <source>Vietnamese</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scdocoutput_ps2.cpp" line="107"/>
        <source>An error occurred while initializing icc transforms</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scdocoutput_ps2.cpp" line="134"/>
        <source>Output profile is not supported</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/wmfimplugin/wmfimportplugin.cpp" line="89"/>
        <source>WMF Import</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/sclayer.cpp" line="388"/>
        <source>New Layer</source>
        <translation type="unfinished">Нови слој</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="71"/>
        <source>Adobe Illustrator Importer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionplugin.cpp" line="61"/>
        <source>Imposition</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importpsplugin.cpp" line="70"/>
        <source>PostScript Importer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="126"/>
        <source>%1;;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="169"/>
        <source>Do you really want to overwrite the file:
%1 ?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="34"/>
        <source>Encapsulated PostScript</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="35"/>
        <source>GIF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="36"/>
        <source>JPEG</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="37"/>
        <source>Pattern Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="38"/>
        <source>PDF Document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="39"/>
        <source>PNG</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="40"/>
        <source>PostScript</source>
        <translation type="unfinished">PostScript</translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="41"/>
        <source>Adobe Photoshop</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="42"/>
        <source>TIFF</source>
        <translation type="unfinished">TIFF</translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="43"/>
        <source>XPM</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="44"/>
        <source>Windows Meta File</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="45"/>
        <source>Scalable Vector Graphics</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="46"/>
        <source>Adobe Illustrator</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ps.cpp" line="105"/>
        <source>Valid metrics were found for font %1, using metrics in file %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ps.cpp" line="112"/>
        <source>No metrics found for font %1, ignoring font</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexhelpers.cpp" line="388"/>
        <source>Error</source>
        <translation type="unfinished">Грешка</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="381"/>
        <source>Configfile %1 not found or the file is not readable</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="387"/>
        <source>second argument is not tuple: must be tuple of int values.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="399"/>
        <source>second argument contains non-numeric values: must be list of int values.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdstyle.cpp" line="51"/>
        <source>Cannot have an empty paragraph style name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdstyle.cpp" line="71"/>
        <source>hasdropcap has to be 0 or 1.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdstyle.cpp" line="128"/>
        <source>Cannot have an empty char style name.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="1001"/>
        <source>Can only hyphenate text frame</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="1024"/>
        <source>Can only dehyphenate text frame</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="82"/>
        <source>Lens Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="91"/>
        <source>PathCutter</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="95"/>
        <source>PathFinder</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="87"/>
        <source>PathStroker</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="56"/>
        <source>Spell check (aspell)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/subdivide/subdivide.cpp" line="79"/>
        <source>Subdivide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="71"/>
        <source>Xfig Importer</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="47"/>
        <source>Xfig File</source>
        <translation type="unfinished"></translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/langmgr.cpp" line="106"/>
        <source>Norwegian (Bokmål)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexhelpers.cpp" line="390"/>
        <source>Parsing the configfile %1 failed! Depending on the type of the error render frames might not work correctly!
%2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="86"/>
        <source>MeshDistortion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="88"/>
        <source>PathAlongPath</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/transform/transformeffect.cpp" line="78"/>
        <source>Transform Effect</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="161"/>
        <source>&#xb0;</source>
        <comment>degrees, unicode 0xB0</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="152"/>
        <source>Cannot get text distances of non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="472"/>
        <source>Text distances out of bounds, must be positive.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="480"/>
        <source>Cannot set text distances on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="62"/>
        <source>Bengali</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="117"/>
        <source>Sanskrit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus134format/scribus134format.cpp" line="65"/>
        <source>Scribus 1.3.4+ Support</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="82"/>
        <source>PathConnect</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scimgdataloader_ps.cpp" line="502"/>
        <source>The Font(s):
%1 are not embedded or available for Scribus.
They might be replaced by &quot;Courier&quot;, depending how your Ghostscript is configured.
Therefore the image may be not correct</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scprintengine_gdi.cpp" line="108"/>
        <source>Save As</source>
        <translation type="unfinished">Сними као</translation>
    </message>
    <message>
        <location filename="../../scribus/scprintengine_gdi.cpp" line="257"/>
        <source>Printing...</source>
        <translation type="unfinished">Штампам...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="258"/>
        <source>Color name cannot be an empty string.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="100"/>
        <source>Stop shade out of bounds, must be 0 &lt;= shade &lt;= 100.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="105"/>
        <source>Ramp point out of bounds, must be 0 &lt;= rampPoint &lt;= 1.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="110"/>
        <source>Opacity out of bounds, must be 0 &lt;= transparency &lt;= 1.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="743"/>
        <source>Character scaling out of bounds, must be &gt;= 10</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="751"/>
        <source>Cannot set character scaling on a non-text frame.</source>
        <comment>python error</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexhelpers.cpp" line="75"/>
        <source>Opening the configfile %1 failed! %2</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>QTextEdit</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="89"/>
        <source>Clear</source>
        <translation>Очисти</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="90"/>
        <source>Select All</source>
        <translation>Изабери све</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="91"/>
        <source>&amp;Undo</source>
        <translation>&amp;Опозови</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="92"/>
        <source>&amp;Redo</source>
        <translation>Поно&amp;ви</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="93"/>
        <source>Cu&amp;t</source>
        <translation>&amp;Исеци</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="94"/>
        <source>&amp;Copy</source>
        <translation>&amp;Копирај</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="95"/>
        <source>&amp;Paste</source>
        <translation>&amp;Пренеси</translation>
    </message>
</context>
<context>
    <name>QTitleBar</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="104"/>
        <source>System Menu</source>
        <translation>Системски мени</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="105"/>
        <source>Shade</source>
        <translation>Намотај</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="106"/>
        <source>Unshade</source>
        <translation>Одмотај</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="107"/>
        <source>Normalize</source>
        <translation>Нормализуј</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="108"/>
        <source>Minimize</source>
        <translation>Минимизуј</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="109"/>
        <source>Maximize</source>
        <translation>Максимизуј</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="110"/>
        <source>Close</source>
        <translation>Затвори</translation>
    </message>
</context>
<context>
    <name>QWorkspace</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="114"/>
        <source>&amp;Restore</source>
        <translation>&amp;Обнови</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="115"/>
        <source>&amp;Move</source>
        <translation>&amp;Помери</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="116"/>
        <source>&amp;Size</source>
        <translation>&amp;Величина</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="117"/>
        <source>Mi&amp;nimize</source>
        <translation>Ми&amp;нимизуј</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="118"/>
        <source>Ma&amp;ximize</source>
        <translation>Ма&amp;ксимизуј</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="119"/>
        <source>&amp;Close</source>
        <translation>&amp;Затвори</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="120"/>
        <source>Stay on &amp;Top</source>
        <translation>Ос&amp;тани на врху</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="121"/>
        <source>Minimize</source>
        <translation>Минимизуј</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="122"/>
        <source>Restore Down</source>
        <translation>Врати доле</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="123"/>
        <source>Close</source>
        <translation>Затвори</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="124"/>
        <source>Sh&amp;ade</source>
        <translation>Намот&amp;ај</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="125"/>
        <source>%1 - [%2]</source>
        <translation>%1 - [%2]</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="126"/>
        <source>&amp;Unshade</source>
        <translation>&amp;Одмотај</translation>
    </message>
</context>
<context>
    <name>ReformDoc</name>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="63"/>
        <source>Document Setup</source>
        <translation>Поставке документа</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="66"/>
        <source>Document</source>
        <translation type="unfinished">Документ</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="72"/>
        <source>Guides</source>
        <translation type="unfinished">Водиље</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="76"/>
        <source>Display</source>
        <translation type="unfinished">Приказ</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="79"/>
        <source>Typography</source>
        <translation type="unfinished">Типографија</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="82"/>
        <source>Tools</source>
        <translation type="unfinished">Алати</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="85"/>
        <source>Hyphenator</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="88"/>
        <source>Fonts</source>
        <translation>Фонтови</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="96"/>
        <source>PDF Export</source>
        <translation>Извоз PDF-ова</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="116"/>
        <source>Color Management</source>
        <translation>Управљање бојама</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="69"/>
        <source>Document Information</source>
        <translation type="unfinished">Информације о документу</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="91"/>
        <source>Preflight Verifier</source>
        <translation>Провера могућих проблема</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="101"/>
        <source>Document Item Attributes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="106"/>
        <source>Table of Contents and Indexes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="461"/>
        <source>Adjusting Colors</source>
        <translation type="unfinished">Прилагођавам боје</translation>
    </message>
    <message>
        <location filename="../../scribus/reformdoc.cpp" line="110"/>
        <source>Sections</source>
        <translation>Избор</translation>
    </message>
</context>
<context>
    <name>RulerMover</name>
    <message>
        <location filename="../../scribus/rulermover.cpp" line="82"/>
        <source>Reset Rulers</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/rulermover.cpp" line="88"/>
        <source>Move on current Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/rulermover.cpp" line="89"/>
        <source>Origin at Top Left</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/rulermover.cpp" line="90"/>
        <source>Origin at Top Right</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/rulermover.cpp" line="91"/>
        <source>Origin at Bottom Left</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/rulermover.cpp" line="92"/>
        <source>Origin at Bottom Right</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/rulermover.cpp" line="93"/>
        <source>Origin at Center</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>RunScriptDialog</name>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/runscriptdialog.cpp" line="27"/>
        <source>Python Scripts (*.py *.PY);; All Files (*)</source>
        <translation>Python скрипта (*.py *.PY);; Сви фајлови (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/runscriptdialog.ui" line="22"/>
        <source>Run as Extension Script</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/runscriptdialog.ui" line="13"/>
        <source>Run Script</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMAlignSelect</name>
    <message>
        <location filename="../../scribus/smalignselect.cpp" line="20"/>
        <source>P</source>
        <comment>P as in Parent</comment>
        <translation>P</translation>
    </message>
    <message>
        <location filename="../../scribus/smalignselect.cpp" line="21"/>
        <source>Use parent style&apos;s alignment instead of overriding it</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMBase</name>
    <message>
        <location filename="" line="136965632"/>
        <source>Style Manager</source>
        <translation type="obsolete">Управљач стиловима</translation>
    </message>
    <message>
        <location filename="../stylemanager.ui" line="96"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="../stylemanager.ui" line="358"/>
        <source>&amp;Delete</source>
        <translation type="obsolete">&amp;Обриши</translation>
    </message>
    <message>
        <location filename="../stylemanager.ui" line="361"/>
        <source>Alt+D</source>
        <translation type="obsolete">Alt+D</translation>
    </message>
    <message>
        <location filename="../stylemanager.ui" line="429"/>
        <source>Name:</source>
        <translation type="obsolete">Име:</translation>
    </message>
    <message>
        <location filename="../stylemanager.ui" line="266"/>
        <source>Alt+N</source>
        <translation type="obsolete">Alt+N</translation>
    </message>
    <message>
        <location filename="../stylemanager.ui" line="93"/>
        <source>&amp;Apply</source>
        <translation type="obsolete">&amp;Примени</translation>
    </message>
    <message>
        <location filename="../stylemanager.ui" line="263"/>
        <source>&amp;New</source>
        <translation type="obsolete">&amp;Нови</translation>
    </message>
    <message>
        <location filename="../stylemanager.ui" line="296"/>
        <source>&amp;Clone</source>
        <translation type="obsolete">&amp;Клонирај</translation>
    </message>
    <message>
        <location filename="../stylemanager.ui" line="299"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
    <message>
        <location filename="../stylemanager.ui" line="340"/>
        <source>&amp;Import</source>
        <translation type="obsolete">&amp;Увези</translation>
    </message>
    <message>
        <location filename="../stylemanager.ui" line="343"/>
        <source>Alt+I</source>
        <translation type="obsolete">Alt+I</translation>
    </message>
    <message>
        <location filename="../stylemanager.ui" line="460"/>
        <source>Please select a unique name for the style</source>
        <translation type="obsolete">Изабери јединствено име за стил</translation>
    </message>
    <message>
        <location filename="../stylemanager.ui" line="69"/>
        <source>&lt;&lt; &amp;Done</source>
        <translation type="obsolete">&lt;&lt; &amp;Готово</translation>
    </message>
    <message>
        <location filename="../stylemanager.ui" line="120"/>
        <source>Alt+R</source>
        <translation type="obsolete">Alt+R</translation>
    </message>
</context>
<context>
    <name>SMCStylePage</name>
    <message>
        <location filename="../smtextstylewidgets.cpp" line="240"/>
        <source> %</source>
        <translation type="obsolete"> %</translation>
    </message>
    <message>
        <location filename="../smtextstylewidgets.cpp" line="219"/>
        <source>Font face</source>
        <translation type="obsolete">Изглед фонта</translation>
    </message>
    <message>
        <location filename="../smtextstylewidgets.cpp" line="220"/>
        <source>Font size</source>
        <translation type="obsolete">Величина фонта</translation>
    </message>
    <message>
        <location filename="../smtextstylewidgets.cpp" line="223"/>
        <source>Horizontal scaling</source>
        <translation type="obsolete">Водоравно скалирање</translation>
    </message>
    <message>
        <location filename="../smtextstylewidgets.cpp" line="224"/>
        <source>Vertical scaling</source>
        <translation type="obsolete">Вертикално скалирање</translation>
    </message>
    <message>
        <location filename="../smtextstylewidgets.cpp" line="225"/>
        <source>Language</source>
        <translation type="obsolete">Језик</translation>
    </message>
    <message>
        <location filename="../smtextstylewidgets.cpp" line="577"/>
        <source>Shade</source>
        <translation type="obsolete">Намотај</translation>
    </message>
    <message>
        <location filename="../smtextstylewidgets.cpp" line="236"/>
        <source>Language:</source>
        <translation type="obsolete">Језик:</translation>
    </message>
</context>
<context>
    <name>SMCStyleWidget</name>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="82"/>
        <source>Font face</source>
        <translation type="obsolete">Изглед фонта</translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="83"/>
        <source>Font size</source>
        <translation type="obsolete">Величина фонта</translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="86"/>
        <source>Tracking</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="86"/>
        <source>Horizontal scaling</source>
        <translation type="obsolete">Водоравно скалирање</translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="87"/>
        <source>Vertical scaling</source>
        <translation type="obsolete">Вертикално скалирање</translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="91"/>
        <source>Language</source>
        <translation type="unfinished">Језик</translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.ui" line="24"/>
        <source>Based On:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.ui" line="342"/>
        <source>Language:</source>
        <translation type="unfinished">Језик:</translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="484"/>
        <source>Shade</source>
        <translation type="unfinished">Намотај</translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.ui" line="49"/>
        <source>Basic Formatting</source>
        <translation type="unfinished">Основно уобличавање</translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.ui" line="312"/>
        <source> %</source>
        <translation type="unfinished"> %</translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.ui" line="230"/>
        <source>Advanced Formatting</source>
        <translation type="unfinished">Напредно уобличавање</translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.ui" line="481"/>
        <source>TextLabel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.ui" line="389"/>
        <source>Colors</source>
        <translation type="unfinished">Боје</translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="83"/>
        <source>Parent Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="84"/>
        <source>Font Face</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="85"/>
        <source>Font Size</source>
        <translation type="unfinished">Величина фонта</translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="88"/>
        <source>Baseline Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="89"/>
        <source>Horizontal Scaling</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="90"/>
        <source>Vertical Scaling</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="92"/>
        <source>Fill Color</source>
        <translation type="unfinished">Боја испуњавања</translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="93"/>
        <source>Fill Shade</source>
        <translation type="unfinished">Сенка испуњавања</translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="94"/>
        <source>Stroke Color</source>
        <translation type="unfinished">Боја потеза</translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="95"/>
        <source>Stroke Shade</source>
        <translation type="unfinished">Сенка потеза</translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="229"/>
        <source>A default style cannot be assigned a parent style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smcstylewidget.cpp" line="87"/>
        <source>Default width for space</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMCharacterStyle</name>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="1812"/>
        <source>Properties</source>
        <translation type="unfinished">Својства</translation>
    </message>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="1443"/>
        <source>Character Styles</source>
        <translation>Стилови знакова</translation>
    </message>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="1448"/>
        <source>Character Style</source>
        <translation>Стил знака</translation>
    </message>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="1588"/>
        <source>New Style</source>
        <translation type="unfinished">Нови стил</translation>
    </message>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="1610"/>
        <source>Clone of %1</source>
        <translation>Клон %1</translation>
    </message>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="1637"/>
        <source>%1 (%2)</source>
        <comment>This for unique name when creating a new character style. %1 will be the name of the style and %2 will be a number forming a style name like: New Style (2)</comment>
        <translation>%1 (%2)</translation>
    </message>
    <message>
        <location filename="../../scribus/smtextstyles.cpp" line="2309"/>
        <source>Setting that style as parent would create an infinite loop.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMColorCombo</name>
    <message>
        <location filename="../../scribus/smcolorcombo.cpp" line="121"/>
        <source>Use Parent Value</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMFontComboH</name>
    <message>
        <location filename="../../scribus/smfontcomboh.cpp" line="15"/>
        <source>Use Parent Font</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>SMLineStyle</name>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="33"/>
        <source>Properties</source>
        <translation type="unfinished">Својства</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="42"/>
        <source>Line Styles</source>
        <translation>Стилови линија</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="47"/>
        <source>Line Style</source>
        <translation>Стил линије</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="184"/>
        <source>New Style</source>
        <translation type="unfinished">Нови стил</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="194"/>
        <source>Clone of %1</source>
        <translation>Клон %1</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="210"/>
        <source>%1 (%2)</source>
        <comment>This for unique name when creating a new character style. %1 will be the name of the style and %2 will be a number forming a style name like: New Style (2)</comment>
        <translation>%1 (%2)</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="593"/>
        <source> pt</source>
        <translation type="unfinished"> тач.</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="673"/>
        <source>Solid Line</source>
        <translation type="unfinished">Непрекидна линија</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="676"/>
        <source>Dashed Line</source>
        <translation type="unfinished">Испрекидана линија</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="679"/>
        <source>Dotted Line</source>
        <translation type="unfinished">Тачкаста линија</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="682"/>
        <source>Dash Dot Line</source>
        <translation type="unfinished">Црта-тачка</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="685"/>
        <source>Dash Dot Dot Line</source>
        <translation type="unfinished">Црта-тачка-тачка</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestyle.cpp" line="669"/>
        <source> pt </source>
        <translation type="unfinished"> pt </translation>
    </message>
</context>
<context>
    <name>SMLineStyleWidget</name>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="36"/>
        <source>Flat Cap</source>
        <translation type="unfinished">Раван поклопац</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="37"/>
        <source>Square Cap</source>
        <translation type="unfinished">Квадратни поклопац</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="38"/>
        <source>Round Cap</source>
        <translation type="unfinished">Кружни поклопац</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="40"/>
        <source>Miter Join</source>
        <translation type="unfinished">Угаони спој</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="41"/>
        <source>Bevel Join</source>
        <translation type="unfinished">Коси спој</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="42"/>
        <source>Round Join</source>
        <translation type="unfinished">Кружни спој</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="62"/>
        <source>Add a new line</source>
        <translation type="unfinished">Додај нову линију</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="63"/>
        <source>Remove a line</source>
        <translation type="unfinished">Уклони линију</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="64"/>
        <source>Line style</source>
        <translation type="unfinished">Стил линије</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="65"/>
        <source>Line width</source>
        <translation type="unfinished">Дебљина линије</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="66"/>
        <source>End style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="67"/>
        <source>Join style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="68"/>
        <source>Line color</source>
        <translation type="unfinished">Боја линије</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="69"/>
        <source>Line shade</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.cpp" line="148"/>
        <source> pt</source>
        <translation type="unfinished"> тач.</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.ui" line="234"/>
        <source>%</source>
        <translation type="unfinished">%</translation>
    </message>
    <message>
        <location filename="../../scribus/smlinestylewidget.ui" line="256"/>
        <source>Line Width:</source>
        <translation type="unfinished">Ширина линије:</translation>
    </message>
</context>
<context>
    <name>SMPStyleWidget</name>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="330"/>
        <source>Fixed Linespacing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="331"/>
        <source>Automatic Linespacing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="332"/>
        <source>Align to Baseline Grid</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="72"/>
        <source>Distances and Alignment</source>
        <translation type="unfinished">Удаљености и поравнања</translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="247"/>
        <source>Drop Caps</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="589"/>
        <source>Tabulators and Indentation</source>
        <translation type="unfinished">Табулатори и увлачење</translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="20"/>
        <source>Properties</source>
        <translation type="unfinished">Својства</translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="137"/>
        <source>Character Style</source>
        <translation>Стил знака</translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="265"/>
        <source>&amp;Lines:</source>
        <translation type="unfinished">&amp;Линије:</translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.ui" line="289"/>
        <source>Distance from Text:</source>
        <translation type="unfinished">Удаљеност од текста:</translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="96"/>
        <source>Alignment</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/smpstylewidget.cpp" line="82"/>
        <source>Parent Style</source>
        <translation type="unfinished"></translation>
    </mess