#include "frameedit.h"
#include "frameedit.moc"

extern QPixmap loadIcon(QString nam);

NodePalette::NodePalette( QWidget* parent)
    : QDialog( parent, "Npal", false, WStyle_Customize | WStyle_DialogBorder)
{
    resize( 137, 64 ); 
    setCaption( tr( "Nodes" ) );
  	setIcon(loadIcon("AppIcon.xpm"));
    NodePaletteLayout = new QVBoxLayout( this ); 
    NodePaletteLayout->setSpacing( 5 );
    NodePaletteLayout->setMargin( 0 );

    ButtonGroup1 = new QButtonGroup( this, "ButtonGroup1" );
    ButtonGroup1->setFrameShape( QButtonGroup::NoFrame );
    ButtonGroup1->setFrameShadow( QButtonGroup::Plain );
    ButtonGroup1->setTitle( tr( "" ) );
    ButtonGroup1->setExclusive( TRUE );
    ButtonGroup1->setColumnLayout(0, Qt::Vertical );
    ButtonGroup1->layout()->setSpacing( 0 );
    ButtonGroup1->layout()->setMargin( 0 );
    ButtonGroup1Layout = new QHBoxLayout( ButtonGroup1->layout() );
    ButtonGroup1Layout->setAlignment( Qt::AlignTop );
    ButtonGroup1Layout->setSpacing( 5 );
    ButtonGroup1Layout->setMargin( 0 );

    ToolButton1_3 = new QToolButton( ButtonGroup1, "ToolButton1_3" );
    ToolButton1_3->setText( tr( "" ) );
    ToolButton1_3->setPixmap(loadIcon("MoveNode.xpm"));
    ToolButton1_3->setToggleButton( TRUE );
    ToolButton1_3->setOn( TRUE );
    ToolButton1_3->setToggleButton( TRUE );
    ToolButton1_3->setOn( TRUE );
    ButtonGroup1->insert( ToolButton1_3, 1 );
    ButtonGroup1Layout->addWidget( ToolButton1_3 );

    ToolButton1_2 = new QToolButton( ButtonGroup1, "ToolButton1_2" );
    ToolButton1_2->setText( tr( "" ) );
    ToolButton1_2->setPixmap(loadIcon("AddNode.xpm"));
    ToolButton1_2->setToggleButton( TRUE );
    ToolButton1_2->setToggleButton( TRUE );
    ButtonGroup1->insert( ToolButton1_2, 2 );
    ButtonGroup1Layout->addWidget( ToolButton1_2 );

    ToolButton1 = new QToolButton( ButtonGroup1, "ToolButton1" );
    ToolButton1->setText( tr( "" ) );
    ToolButton1->setPixmap(loadIcon("DelNode.xpm"));
    ToolButton1->setToggleButton( TRUE );
    ToolButton1->setToggleButton( TRUE );
    ButtonGroup1->insert( ToolButton1, 3 );
    ButtonGroup1Layout->addWidget( ToolButton1 );
    NodePaletteLayout->addWidget( ButtonGroup1 );

    PushButton1 = new QPushButton( this, "PushButton1" );
    PushButton1->setText( tr( "End Editing Frame" ) );
    NodePaletteLayout->addWidget( PushButton1 );
    QToolTip::add(  ToolButton1_3, tr( "Move Node" ) );
    QToolTip::add(  ToolButton1_2, tr( "Add Node" ) );
    QToolTip::add(  ToolButton1, tr( "Delete Node" ) );

    // signals and slots connections
    connect( PushButton1, SIGNAL( clicked() ), this, SLOT( EndEdit() ) );
    connect( ToolButton1, SIGNAL( clicked() ), this, SLOT( DelN() ) );
    connect( ToolButton1_2, SIGNAL( clicked() ), this, SLOT( AddN() ) );
    connect( ToolButton1_3, SIGNAL( clicked() ), this, SLOT( MoveN() ) );
}

NodePalette::~NodePalette()
{
}

void NodePalette::setDoc(ScribusDoc *dc)
{
	doc = dc;
}

void NodePalette::MoveN()
{
	doc->EditClipMode = 0;
}

void NodePalette::AddN()
{
	doc->EditClipMode = 1;
}

void NodePalette::DelN()
{
	doc->EditClipMode = 2;
}

void NodePalette::closeEvent(QCloseEvent *)
{
	emit Schliessen();
}

void NodePalette::EndEdit()
{
	emit Schliessen();
}
