/***************************************************************************
                          scribus.h  -  description
                             -------------------
    begin                : Fre Apr  6 21:09:31 CEST 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SCRIBUS_H
#define SCRIBUS_H


// include files for QT
#include <qapp.h>
#include <qmainwindow.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qstatusbar.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qmsgbox.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qmap.h>
#include <qfont.h>
#include <qtimer.h>
#include <qintdict.h>
#include <qprogressdialog.h>
#include <qstatusbar.h>

// application specific includes
#include "scribusview.h"
#include "scribusdoc.h"
#include "colorm.h"
#include "cpalette.h"
#include "tree.h"
#include "modify.h"
#include "mpal.h"
#include "spalette.h"
#include "frameedit.h"
#include "scrap.h"
#include "libpostscript/pslib.h"
#include "libpdf/pdflib.h"
// #include "texttoolb.h"

/**
  * This Class is the base class for your application. It sets up the main
  * window and providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class ScribusView is
  * created which creates your view.
  */
class ScribusApp : public QMainWindow
{
  Q_OBJECT
  
  public:
    /** construtor */
    ScribusApp();
    /** destructor */
    ~ScribusApp();
    /** initMenuBar creates the menu_bar and inserts the menuitems */
    void initMenuBar();
    /** setup the statusbar */
    void initStatusBar();
    void SetShortCut();
    void SetKeyEntry(int Nr, QString text, int Men, int KeyC);
    bool queryExit();
    void closeEvent(QCloseEvent *ce);
    void keyPressEvent(QKeyEvent *k);
    void wheelEvent(QWheelEvent *w);
    void DeleteSel(PageItem *b);
    void setTBvals(PageItem *b);
    void SavePrefs();
    void ReadPrefs();
    void ShowSubs();
    void applyNewMaster(QString name);
    void UpdateRecent(QString fn);
    void InitPlugs();
    QString DLLName(QString name);
    void CallDLL(QString name);
    int DLLType(QString name);
    PSLib* getPSDriver(bool psart, SCFonts &AllFonts, QMap<QString,QFont> DocFonts, CListe DocColors, bool pdf);
    void closePSDriver();
    PDFlib* getPDFDriver();
    void closePDFDriver();
    QString CFileDialog(QString caption = "", QString filter = "", QString defNa = "", bool Pre = false);
    void GetCMSProfiles();
    void OpenCMSProfiles();
    void RecalcColors(QProgressDialog *dia = 0);
    void CloseCMSProfiles();
    struct CLBuf Buffer;
    QString Buffer2;
    QString Buffer3;
    ProfilesL MonitorProfiles;
    ProfilesL PrinterProfiles;
#ifdef HAVE_CMS
		cmsHPROFILE CMSDinputProf;
		cmsHPROFILE CMSDoutputProf;
		cmsHPROFILE CMSDprinterProf;
#endif
    float DispX;
    float DispY;
    float Umrech;
    QTimer *CurTimer;
    bool NoFonts;
    bool HaveDoc;
    struct preV Prefs;
    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
    ScribusView *view;
    /** doc represents your actual document and is created only once. It keeps
     * information such as filename and does the serialization of your files.
     */
    ScribusDoc *doc;

  public slots:
    void slotTest();
    void slotTest2();
    void SetCMSPrefs();
    void ManageTemp();
    void ManTempEnd();
    /** generate a new document in the actual view */
    void slotFileNew();
    /** open a document */
    void slotFileOpen();
    /** open a document */
    void LoadRecent(int id);
    void slotDocOpen();
    void LadeDoc(QString fileName);
    /** save a document */
    void slotFileSave();
    /** save a document under a different filename*/
    void slotFileSaveAs();
    /** Sichert den Text eines Elements */
    void SaveText();
    /** close the actual file */
    bool slotFileClose();
    /** print the actual file */
    void slotFilePrint();
    /** exits the application */
    void slotFileQuit();
    /** put the marked text/object into the clipboard and remove
     * it from the document */
    void slotEditCut();
    /** put the marked text/object into the clipboard*/
    void slotEditCopy();
    /** paste the clipboard into the document*/
    void slotEditPaste();
    void EnableTxEdit();
    void DisableTxEdit();
    void SelectAll();
    void DeleteText();

    /** shows an about dlg*/
    void slotHelpAbout();
    void slotHelpAboutQt();
    void slotOnlineHelp();
    void ToggleTips();
  /** Erzeugt eine neue Seite */
  void slotNewPageM();
  void slotNewPage(int w);
  /** Lscht die aktuelle Seite */
  void DeletePage();
  /** Verschiebt Seiten */
  void MovePage();
  void CopyPage();
  /** Ansicht absolut zoomen */
	void slotZoomAbs(float z);
	/** Ansicht ganzes Blatt) */
	void slotZoomFit();
  /** Ansicht 20 % */
	void slotZoom20();
  /** Ansicht 50 % */
	void slotZoom50();
  /** Ansicht 75 % */
	void slotZoom75();
	/** Ansicht 100 % */
	void slotZoom100();
	/** Ansicht 200 % */
	void slotZoom200();
	/** Schaltet Rnder ein/aus */
	void ToggleMarks();
	void ToggleFrames();
	/** Schaltet Werkzeuge ein/aus */
	void ToggleTools();
	/** Schaltet Mapalette ein/aus */
	void ToggleMpal();
	/** Schaltet bersichtspalette ein/aus*/
	void ToggleTpal();
	/** Schaltet Farbpalette ein/aus */
	void ToggleCpal();
	void ToggleSpal();
	void ToggleBpal();
	/** Schaltet Bilder ein/aus */
	void TogglePics();
	/** Schaltet Raster ein/aus */
	void ToggleRaster();
	/** Schaltet Rasterbenutzung ein/aus */
	void ToggleURaster();
	/** Schaltet Rahmenbearbeitung ein/aus */
	void ToggleFrameEdit();
	void slotSelect();
	void ModeFromTB();
	/** Switch AppMode */
	void setAppMode(int mode);
	/** Neues Dokument erzeugt */
	void HaveNewDoc();
	/** Element ausgewhlt */
	void HaveNewSel(int Nr);
	/** Dokument ist gendert worden */
	void slotDocCh();
	/** Setzt die Farbe */
	void setItemFarbe(int id);
	/** Setzt die Abstufung */
	void setItemShade(int id);
	/** Setzt den Font */
	void setItemFont(int id);
	/** Korrigiert das FontMenu */
	void AdjustFontMenu(QString nf);
	void SetNewFont(QString nf);
	/** Setz die Zeichensatzgre */
	void setItemFSize(int id);
	void setFSizeMenu(int size);
	/** Farbeditor */
	void slotEditColors();
	/** Setzt den Pen-Tonwert */
	void setPenShade(int sh);
	/** Setzt den Brush-Tonwert */
	void setBrushShade(int sh);
	/** Setzt die Pen-Farbe */
	void setPenFarbe(QString farbe);
	/** Setzt die Brush-Farbe */
	void setBrushFarbe(QString farbe);
	void setCSMenu(QString f, QString l, int fs, int ls);
	/** Fragt nach den Farben */
	void GetBrushPen();
	/** Erzeugt einen rechteckigen Rahmen */
	void RectFrame();
	/** Erzeugt einen ovalen Rahmen */
	void OvalFrame();
	void RoundedFrame();
	/** Lscht ein Element */
	void DeleteObjekt();
	/** Setzt das Element in den Hintergrund */
	void Objekt2Back();
	/** Setzt das Element in den Vordergrund */
	void Objekt2Front();
	/** Bewegt das Element eine Ebene nach oben */
	void ObjektRaise();
	/** Bewegt das Element nach unten */
	void ObjektLower();
	/** Dupliziert das Element */
	void ObjektDup();
	/** Dupliziert das Element mehrfach*/
	void ObjektDupM();
	/** Setzt die Infos fr das Dokument */
	void InfoDoc();
	/** Reformatiert das Dokument */
	void SetupDoc();
	/** Richtet Objekte aus */
	void ObjektAlign();
	void DoAlign(bool xa, bool ya, bool Vth, bool Vtv, float xdp, float ydp, int xart, int yart);
	void GetAllFonts();
	void BuildFontMenu();
	void slotFontOrg();
	void slotPrefsOrg();
	void slotEditStyles();
	void setNewAbStyle(int a);
	void setAbsValue(int a);
	void SelectFromOutl(int Page, int Item);
	void SelectFromOutlS(int Page);
	void SaveAsEps();
	void SaveAsPDF();
	void ModifyObject();
	void Aktiv();
	void setItemHoch(int h);
	void setStilvalue(int s);
	void setItemTypeStyle(int id);
	void slotElemRead(QString Name, int x, int y, bool art, bool loca);
	void slotChangeUnit(int art);
	void NoFrameEdit();
	void setItemTextAli(int id);
	void ApplyTemp();
	void GroupObj();
	void UnGroupObj();
	void StatusPic();
	void RunPlug(int id);
	void RunImportPlug(int id);
	void RunExportPlug(int id);
	void ModifyAnnot();

signals:
	void TextISize(int);
	void TextIFont(QString);
	void TextUSval(float);
	void TextStil(int);
	void TextFarben(QString, QString, int, int);
	
private:

    /** file_menu contains all items of the menubar entry "File" */
    QPopupMenu *fileMenu;
    /** edit_menu contains all items of the menubar entry "Edit" */
    QPopupMenu *editMenu;
    /** StilMenu enthlt das Stilemen */
    QPopupMenu *StilMenu;
    /** ObjMenu enthlt das Objektemen */
    QPopupMenu *ObjMenu;
    /** pageMenu enthlt das Seitenmen */
    QPopupMenu *pageMenu;
    /** view_menu contains all items of the menubar entry "View" */
    QPopupMenu *viewMenu;
    /** ColorMenu enthlt die Farben des Dokuments */
    QPopupMenu *ColorMenu;
    /** SizeTMenu enthlt die Schriftgren */
    QPopupMenu *SizeTMenu;
    /** ShadeMenu enthlt die Tonwerte */
    QPopupMenu *ShadeMenu;
    /** ShapeMenu enthlt die Rahmenformen */
    QPopupMenu *ShapeMenu;
    /** FontMenu enthlt die Fonts */
    QPopupMenu *FontMenu;
    QPopupMenu *FStyleMenu;
    QPopupMenu *TypeStyleMenu;
    QPopupMenu *AliMenu;
    QPopupMenu *recentMenu;
    QToolBar *WerkTools;
    QToolBar *WerkTools2;
//    TextToolB* TextTools;
    QToolButton* DatOpe;
    QToolButton* DatSav;
    QToolButton* DatClo;
    QToolButton* DatPri;
    QToolButton* DatPDF;
    QToolButton* DatNeu;
		QToolButton* Select;
    QToolButton* Rotiere;
		QToolButton* Textedit;
    QToolButton* Zoom;
    QToolButton* Texte;
    QToolButton* BildB;
    QToolButton* Linien;
    QToolButton* Kreis;
    QToolButton* Rechteck;
    QToolButton* KetteEin;
    QToolButton* KetteAus;
/*    QLabel* CapsStat;
    QStatusBar* Status;       */
    int KeyMod;
    int ShapeEdit;
    int ShapeM;
    int DistM;
    int pgmd;
    int pgmm;
    int pgmv;
    int Stm;
    int Obm;
    int Markers;
    int FrameDr;
    int Bilder;
    int Ras;
    int uRas;
    int viewTools;
    int viewMpal;
    int viewCpal;
    int viewTpal;
    int viewSpal;
    int viewNpal;
    int viewBpal;
    int fid1;
    int fid2;
    int fid3;
    int fid4;
    int fid5;
    int fid6;
    int fid7;
    int fid8;
    int fid9;
    int fid10;
    int fid11;
    int fid12;
    int fid13;
    int fid14;
    int edid1;
    int edid2;
    int edid3;
    int edid4;
    int edid5;
    int edid6;
    int Loesch;
    int tman;
    int tip;
    int Gr;
    int UnGr;
    int exmn;
    bool tipsOn;
    QPopupMenu *helpMenu;
    QPopupMenu *toolMenu;
    QPopupMenu *extraMenu;
    QPopupMenu *importMenu;
    QPopupMenu *exportMenu;
    float mm2pts(int mm);
    float pts2mm(float pts);
    Mpalette2 *Mpal2;
    Cpalette *Cpal;
    Spalette *Spal;
    NodePalette *Npal;
    Tree *Tpal;
    Biblio *ScBook;
    bool BufferSet;
    bool BufferSet2;
    QIntDict<QString> FontID;
    int HaveGS;
    bool PDFavailable;
    void *PSDriver;
    void *PDFDriver;
    int DocNr;
    int CurrentStyle;
    int CurrentABStil;
    QStringList RecentDocs;
    QMap<QString, QString> PluginMap;
    bool PrinterUsed;
    bool MenuStat[7];
    bool TemplateMode;
    struct PDe { QString Pname;
    						 QString Dname;
    						} PDef ;
};
#endif 

