/***************************************************************************
                          scribusdoc.h  -  description
                             -------------------
    begin                : Fre Apr  6 21:47:55 CEST 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef SCRIBUSDOC_H
#define SCRIBUSDOC_H
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
// include files for QT
#include <qobject.h>
#include <qdict.h>
#include <qcolor.h>
#include <qvaluelist.h>
#include <qvaluestack.h>
#include <qlist.h>
#include <qfont.h>
#include <qmap.h>
#include <qpointarray.h>
#include <qstringlist.h>
#include "cmykcolor.h"
#include "scfonts.h"
#ifdef HAVE_CMS
	#include <lcms.h>
#endif

class PageItem;
class Page;

/* Struktur fr Pageitem Text */
struct Pti { QString ch;
				     float xp;
				     float yp;
				     int csize;
				     QString cfont;
				     QString ccolor;
				     bool cselect;
				     float cextra;
				     int cshade;
				     int cstyle;
				     int cab;
				    };

struct CLBuf { int PType;
							 float Xpos;
							 float Ypos;
							 float Width;
							 float Height;
							 float RadRect;
							 int FrameType;
							 bool ClipEdited;
							 int Pwidth;
							 QString Pcolor;
							 QString Pcolor2;
							 int Shade;
							 int Shade2;
							 float Rot;
							 int PLineArt;
							 int PLineJoin;
							 int PLineEnd;
							 float LineSp;
							 float ExtraV;
							 float LocalScX;
							 float LocalScY;
							 float LocalX;
							 float LocalY;
							 bool PicArt;
							 int flippedH;
							 int flippedV;
							 float BBoxX;
							 float BBoxH;
							 bool isPrintable;
							 bool isBookmark;
							 bool isAnnotation;
							 int AnType;
							 QString AnAction;
							 int AnZiel;
							 float Extra;
							 QString Pfile;
							 QString IProfile;
							 QString EmProfile;
							 int IRender;
							 bool UseEmbedded;
							 QString Ptext;
							 QPointArray Clip;
							 bool Textflow;
							 int Ausrich;
							 QString IFont;
							 int ISize;
							 QValueStack<int> Groups;
							};

  /** Seitenrnder */
struct Margs { float Top;
           		 float Left;
           		 float Right;
           		 float Bottom;
          		};

struct StVorL { QString Vname;
								float LineSpa;
								int Ausri;
								float Indent;
								float First;
								float Avor;
								float Anach;
							};

struct CMSset {
  						QString DefaultMonitorProfile;
  						QString DefaultPrinterProfile;
  						QString DefaultInputProfile;
  						QString DefaultInputProfile2;
  						int DefaultIntentMonitor;
  						int DefaultIntentMonitor2;
  						int DefaultIntentPrinter;
  						bool CMSinUse;
  						bool SoftProofOn;
							} ;

/** Definition der Farbenlisten */
typedef QMap<QString,CMYKColor> CListe;
typedef QMap<QString,QString> ProfilesL;

struct PreSet { int EffektLen;
								int AnzeigeLen;
								int Effekt;
								int Dm;
								int M;
								int Di;
							};
							
struct PDFOpt { bool Thumbnails;
								bool Articles;
								bool Compress;
								bool RecalcPic;
								bool Bookmarks;
								int PicRes;
								int Version;
								int Resolution;
								int Binding;
								QValueList<QString> EmbedList;
								bool PresentMode;
								QValueList<PreSet> PresentVals;
							};
							
struct Keys { QString Name;
 							int MenuID;
 							int KeyID;
 						};
							
struct preV  { SCFonts AvailFonts;
							 QString DefFont;
							 int DefSize;
							 CListe DColors;
							 int Wheelval;
							 int AppFontSize;
							 int GrabRad;
							 float DminGrid;
							 float DmajGrid;
							 QColor DminColor;
							 QColor DmajColor;
							 QColor DpapColor;
							 QColor DmargColor;
							 int GUI;
							 int DVHoch;
							 int DVHochSc;
							 int DVTief;
							 int DVTiefSc;
							 int DVKapit;
							 QString Dpen;
							 QString Dbrush;
							 int Dshade;
							 int Dshade2;
							 int DLineArt;
							 int Dwidth;
							 QString DpenLine;
							 QString DpenText;
							 int DshadeLine;
							 int DwidthLine;
							 int DLstyleLine;
							 int MagMin;
							 int MagMax;
							 int MagStep;
							 QString DbrushPict;
							 int ShadePict;
							 float ScaleX;
							 float ScaleY;
							 bool Before;
							 int Einheit;
							 bool Werkv;
							 bool Mpalv;
							 int Mpalx;
							 int Mpaly;
							 bool Cpalv;
							 int Cpalx;
							 int Cpaly;
							 bool Tpalv;
							 int Tpalx;
							 int Tpaly;
							 bool Spalv;
							 int Spalx;
							 int Spaly;
							 int Npalx;
							 int Npaly;
							 int MainX;
							 int MainY;
							 int MainW;
							 int MainH;
							 bool SCpalv;
							 int SCpalx;
							 int SCpaly;
							 int SCpalw;
							 int SCpalh;
							 int PSize;
							 bool SaveAtQ;
							 bool PagesSbS;
							 bool ShFrames;
							 bool RandFarbig;
							 QStringList RecentDocs;
							 uint RecentDCount;
							 int AutoLine;
							 CMSset DCMSset;
    					 QMap<int,Keys> KeyActions;
						 };
/**
  * the Document Class
  */

class ScribusDoc : public QObject
{

public:
    ScribusDoc();
    ~ScribusDoc();
    void setModified();
    void setUnModified();
    bool isModified() const;
  /** Setzt die Seitenattribute */
  void setPage(float b, float h, float t, float l, float r, float bo, float sp, float ab, bool atf, bool fp);
  void resetPage(float t, float l, float r, float bo, bool fp);
  void AddFont(QString name, QFont fo);
  protected:
    bool modified;
	public: // Public attributes
  /** Vergrerungsfaktor fr das Dokument */
  float Scale;
  bool Marks;
  bool loading;
  /** Breite der Seite  */
  float PageB;
  /** Hhe der Seite */
  float PageH;
  /** Anzahl der Seiten */
  int PageC;
  /** Seitenrnder */
  Margs PageM;
  /** Anzahl der Spalten */
  float PageSp;
  /** Abstand der Spalten */
  float PageSpa;
  /** Flag fr AutoTextrahmen */
  bool PageAT;
  /** Flag fr Doppelseiten */
  bool PageFP;
  /** Flag fr Raster */
  bool Raster;
  /** Flag fr Rasterbenutzung */
  bool useRaster;
  /** Flag fr Bilder */
  bool ShowPic;
  /** Im Dokument benutzte Farben */
  CListe PageColors;
  Page* ActPage;
  /** InfoStrings fr das aktuelle Dokument */
  QString DocAutor;
  QString DocTitel;
  QString DocComments;
  int AppMode;
  QString Dpen;
  QString Dbrush;
  int Dwidth;
  int Dshade;
  int Dshade2;
  PenStyle DLineArt;
  QString DpenLine;
  QString DpenText;
  int DshadeLine;
  PenStyle DLstyleLine;
  int DwidthLine;
  QString Dfont;
  QString DocName;
  QMap<QString,QFont> UsedFonts;
  SCFonts *AllFonts;
  int Dsize;
  QColor minorColor;
  QColor majorColor;
  QColor papColor;
  QColor margColor;
  float minorGrid;
  float majorGrid;
  int CurrentSel;
  bool EditClip;
  int EditClipMode;
  /** um wieviel Prozent wird hochgestellt */
  int VHoch;
  /** Verkleinerung in Prozent bei Hochstellung */
  int VHochSc;
  /** um wieviel Prozent wird tiefgestellt */
  int VTief;
  /** Verkleinerung in Prozent bei Tiefstellung */
  int VTiefSc;
  /** Verkleinerunug in Prozent bei Kapitlchen */
  int VKapit;
  /** Letztes Element fr AutoTextrahmen */
  PageItem *LastAuto;
  /** Erstes Element fr AutoTextrahmen */
  PageItem *FirstAuto;
  int MagMin;
  int MagMax;
  int MagStep;
  int GrabRad;
	QString DbrushPict;
	int ShadePict;
	float ScaleX;
	float ScaleY;
	bool Before;
	int Einheit;
  bool DragP;
  PageItem *DraggedElem;
  PageItem *ElemToLink;
  QValueList<uint> DragElements;
  QValueList<StVorL> Vorlagen;
  bool MasterP;
  bool FirstPageLeft;
  bool PagesSbS;
  bool ShFrames;
  bool RandFarbig;
  int GroupCounter;
  int AutoLine;
  CMSset CMSSettings;
#ifdef HAVE_CMS
	cmsHPROFILE DocInputProf;
	cmsHPROFILE DocOutputProf;
	cmsHPROFILE DocPrinterProf;
#endif
  bool HasCMS;
};

#endif
