/***************************************************************************
                          spalette.cpp  -  description
                             -------------------
    begin                : Wed Apr 25 2001
    copyright            : (C) 2001 by Franz Schmid
    email                : Franz.Schmid@altmuehlnet.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "spalette.h"
#include "spalette.moc"
extern QPixmap loadIcon(QString nam);

Spalette::Spalette(QWidget* parent)
        : QDialog( parent, "Sfloat", false, WStyle_Customize | WStyle_DialogBorder)
{
	resize(150,210);
  setCaption(tr("Styles"));
  setIcon(loadIcon("AppIcon.xpm"));
  setMinimumSize(QSize(150,210));
  setMaximumSize(QSize(150,210));
  Form1Layout = new QHBoxLayout( this );
  Form1Layout->setSpacing( 0 );
  Form1Layout->setMargin( 0 );
  ListBox1 = new QListBox( this, "ListBox1" );
  ListBox1->setMinimumSize( QSize( 150, 210 ) );
  ListBox1->setMaximumSize( QSize( 150, 210 ) );
  Form1Layout->addWidget( ListBox1 );
  doc = 0;
  connect(ListBox1, SIGNAL(clicked(QListBoxItem*)), this, SLOT(selFormat(QListBoxItem*)));
  connect(ListBox1, SIGNAL(selected(int)), this, SIGNAL(EditSt()));
}

Spalette::~Spalette()
{
}

void Spalette::closeEvent(QCloseEvent *ce)
{
	emit Schliessen();
	ce->accept();
}

void Spalette::SetFormats(ScribusDoc *dd)
{
	doc = dd;
	updateFList();
}

void Spalette::updateFList()
{
	ListBox1->clear();
	if (doc != 0)
		{
		ListBox1->insertItem(tr("No Style"));
		for (uint x = 5; x < doc->Vorlagen.count(); x++)
			{
			ListBox1->insertItem(doc->Vorlagen[x].Vname);
			}
		ListBox1->setSelected(ListBox1->currentItem(), false);
		}
}

void Spalette::selFormat(QListBoxItem *c)
{
	if (c == NULL)
  	return;
  if (c->listBox()->currentItem() > 0)
  	emit NewStyle(c->listBox()->currentItem()+4);
  else
  	emit NewStyle(c->listBox()->currentItem());
}
