#include <PalmOS.h>
#include "b_globals.h"

typedef Int16 int16;

typedef struct {
	int16 x, y;
	int16 frame;
} BamDataObj;

typedef struct {
	BamDataObj obj1; // truck / Frank
	BamDataObj obj2; // Rico  / robot
	BamDataObj fx;
	int16 sfx;
} BamDataBlock;

static void addGraphics_carData() {
	BamDataBlock _carData[] = {
		{ { 310, 105, 1 }, { 314, 106, 17 }, { 366, 101,  1 },  0 },
		{ { 303, 105, 1 }, { 307, 106, 17 }, { 214,   0, 10 },  0 },
		{ { 297, 104, 1 }, { 301, 105, 17 }, { 214,   0, 10 },  0 },
		{ { 294, 103, 1 }, { 298, 104, 17 }, { 214,   0, 10 },  0 },
		{ { 291, 102, 1 }, { 295, 103, 18 }, { 214,   0, 10 },  0 },
		{ { 287, 101, 1 }, { 291, 102, 18 }, { 266,  51, 10 },  2 },
		{ { 283, 100, 1 }, { 287, 101, 19 }, { 279,  47, 11 },  0 },
		{ { 279,  99, 1 }, { 283, 100, 20 }, { 294,  46, 12 },  0 },
		{ { 274,  98, 1 }, { 278,  99, 20 }, { 305,  44, 13 },  0 },
		{ { 269,  98, 1 }, { 273,  99, 20 }, { 320,  42, 14 },  0 },
		{ { 264,  98, 1 }, { 268,  99, 17 }, { 214,   0, 10 },  0 },
		{ { 261,  98, 1 }, { 265,  99, 17 }, { 214,   0, 10 },  0 },
		{ { 259,  98, 1 }, { 263,  99, 17 }, { 214,   0, 10 },  0 },
		{ { 258,  98, 1 }, { 262,  99, 17 }, { 214,   0, 10 },  0 },
		{ { 257,  98, 2 }, { 260,  99, 17 }, { 214,   0, 10 },  0 },
		{ { 255,  99, 3 }, { 258, 100, 17 }, { 214,   0, 10 },  0 },
		{ { 258,  99, 4 }, { 257, 100, 17 }, { 214,   0, 10 },  0 },
		{ { 264, 102, 4 }, { 263, 103, 17 }, { 214,   0, 10 },  0 },
		{ { 272, 105, 5 }, { 274, 106, 17 }, { 214,   0, 10 },  0 },
		{ { 276, 107, 5 }, { 277, 108, 17 }, { 214,   0, 10 },  0 },
		{ { 283, 108, 5 }, { 284, 109, 17 }, { 214,   0, 10 },  0 },
		{ { 288, 109, 5 }, { 288, 110, 17 }, { 214,   0, 10 },  0 },
		{ { 293, 110, 5 }, { 293, 111, 18 }, { 266,  59, 10 },  2 },
		{ { 298, 110, 5 }, { 299, 111, 18 }, { 277,  56, 11 },  0 },
		{ { 303, 110, 5 }, { 304, 111, 19 }, { 285,  55, 12 },  0 },
		{ { 308, 110, 4 }, { 307, 111, 20 }, { 296,  54, 13 },  0 },
		{ { 309, 110, 3 }, { 312, 111, 20 }, { 304,  53, 14 },  0 },
		{ { 310, 110, 3 }, { 313, 111, 20 }, { 214,   0, 10 },  0 },
		{ { 311, 110, 3 }, { 314, 111, 17 }, { 214,   0, 10 },  0 },
		{ { 309, 110, 2 }, { 312, 111, 17 }, { 214,   0, 10 },  0 },
		{ { 304, 111, 2 }, { 307, 112, 17 }, { 214,   0, 10 },  0 },
		{ { 300, 110, 2 }, { 303, 111, 17 }, { 214,   0, 10 },  0 },
		{ { 296, 109, 2 }, { 299, 110, 17 }, { 214,   0, 10 },  0 },
		{ { 292, 108, 1 }, { 296, 109, 17 }, { 214,   0, 10 },  0 },
		{ { 285, 107, 2 }, { 289, 108, 17 }, { 214,   0, 10 },  0 },
		{ { 282, 107, 3 }, { 285, 108, 17 }, { 214,   0, 10 },  0 },
		{ { 278, 107, 4 }, { 277, 108, 18 }, { 214,   0, 10 },  0 },
		{ { 279, 108, 4 }, { 278, 109, 18 }, { 252,  57, 10 },  2 },
		{ { 281, 108, 5 }, { 283, 109, 18 }, { 265,  55, 11 },  0 },
		{ { 284, 109, 5 }, { 285, 110, 19 }, { 277,  55, 12 },  0 },
		{ { 287, 110, 5 }, { 288, 111, 20 }, { 288,  54, 13 },  0 },
		{ { 289, 111, 5 }, { 290, 112, 20 }, { 299,  54, 14 },  0 },
		{ { 291, 112, 4 }, { 290, 113, 20 }, { 214,   0, 10 },  0 },
		{ { 293, 113, 3 }, { 295, 114, 17 }, { 214,   0, 10 },  0 },
		{ { 296, 114, 2 }, { 299, 115, 17 }, { 214,   0, 10 },  0 },
		{ { 295, 115, 2 }, { 298, 116, 17 }, { 214,   0, 10 },  0 },
		{ { 293, 116, 1 }, { 297, 117, 17 }, { 214,   0, 10 },  0 },
		{ { 289, 116, 1 }, { 292, 117, 17 }, { 214,   0, 10 },  0 },
		{ { 285, 115, 1 }, { 289, 116, 17 }, { 214,   0, 10 },  0 },
		{ { 281, 114, 1 }, { 284, 115, 17 }, { 214,   0, 10 },  0 },
		{ { 277, 113, 1 }, { 280, 114, 17 }, { 214,   0, 10 },  0 },
		{ { 274, 112, 1 }, { 277, 113, 17 }, { 214,   0, 10 },  0 },
		{ { 271, 111, 1 }, { 274, 112, 17 }, { 214,   0, 10 },  0 },
		{ { 267, 110, 1 }, { 270, 111, 17 }, { 214,   0, 10 },  0 },
		{ { 263, 109, 1 }, { 266, 110, 17 }, { 214,   0, 10 },  0 },
		{ { 260, 108, 1 }, { 263, 109, 17 }, { 214,   0, 10 },  0 },
		{ { 254, 108, 2 }, { 256, 109, 17 }, { 214,   0, 10 },  0 },
		{ { 252, 107, 3 }, { 254, 108, 17 }, { 214,   0, 10 },  0 },
		{ { 253, 108, 3 }, { 255, 109, 17 }, { 214,   0, 10 },  0 },
		{ { 255, 109, 3 }, { 257, 110, 18 }, { 231,  59, 10 },  2 },
		{ { 258, 111, 3 }, { 260, 112, 18 }, { 242,  57, 11 },  0 },
		{ { 263, 112, 4 }, { 262, 113, 19 }, { 256,  57, 12 },  0 },
		{ { 270, 111, 4 }, { 269, 112, 20 }, { 267,  57, 13 },  0 },
		{ { 274, 112, 5 }, { 276, 113, 20 }, { 281,  56, 14 },  0 },
		{ { 280, 111, 6 }, { 282, 112, 19 }, { 214,   0, 10 },  0 },
		{ { 284, 109, 6 }, { 285, 110, 17 }, { 214,   0, 10 },  0 },
		{ { 289, 108, 6 }, { 291, 109, 17 }, { 214,   0, 10 },  0 },
		{ { 294, 107, 6 }, { 296, 108, 17 }, { 214,   0, 10 },  0 },
		{ { 294, 107, 5 }, { 296, 108, 18 }, { 272,  57, 10 },  2 },
		{ { 295, 107, 5 }, { 297, 108, 18 }, { 282,  57, 11 },  0 },
		{ { 296, 108, 5 }, { 298, 109, 19 }, { 295,  57, 12 },  0 },
		{ { 300, 108, 4 }, { 299, 109, 20 }, { 303,  57, 13 },  0 },
		{ { 303, 108, 3 }, { 306, 109, 20 }, { 313,  57, 14 },  0 },
		{ { 307, 109, 2 }, { 311, 110, 17 }, { 214,   0, 10 },  0 },
		{ { 310, 110, 1 }, { 314, 111, 17 }, { 214,   0, 10 }, 99 }
	};
	writeRecord(_carData, sizeof(_carData), GBVARS_GRAPHICSCARDATA_INDEX , GBVARS_QUEEN);
}

static void addGraphics_fight1Data() {
	BamDataBlock _fight1Data[] = {
		{ {  75,  96,  1 }, { 187, 96, -23 }, {  58,  37, 46 },  0 },
		{ {  75,  96,  2 }, { 187, 96, -23 }, {  58,  37, 46 },  0 },
		{ {  75,  96,  3 }, { 187, 96, -23 }, {  58,  37, 46 },  0 },
		{ {  75,  96,  4 }, { 187, 96, -23 }, {  58,  37, 46 },  0 },
		{ {  75,  96,  1 }, { 187, 96, -23 }, {  58,  37, 46 },  0 },
		{ {  75,  96,  2 }, { 187, 96, -23 }, {  58,  37, 46 },  0 },
		{ {  75,  96,  3 }, { 187, 96, -23 }, {  58,  37, 46 },  0 },
		{ {  75,  96,  4 }, { 187, 96, -24 }, {  58,  37, 46 },  0 },
		{ {  79,  96,  1 }, { 187, 96, -24 }, {  58,  37, 46 },  0 },
		{ {  85,  96,  2 }, { 187, 96, -24 }, {  58,  37, 46 },  0 },
		{ {  94,  96,  3 }, { 187, 96, -24 }, {  58,  37, 46 },  0 },
		{ { 100,  96,  4 }, { 187, 96, -24 }, {  58,  37, 46 },  0 },
		{ { 113,  96,  1 }, { 187, 96, -25 }, {  58,  37, 46 },  0 },
		{ { 121,  96,  1 }, { 187, 96, -25 }, {  58,  37, 46 },  0 },
		{ { 136,  96, 16 }, { 187, 96, -26 }, {  58,  37, 46 },  0 },
		{ { 151,  93,  6 }, { 187, 96, -27 }, {  58,  37, 46 },  0 },
		{ { 159,  83, 16 }, { 187, 96, -28 }, {  58,  37, 46 },  0 },
		{ { 170,  73, 16 }, { 187, 96, -29 }, { 182,  96, 48 },  3 },
		{ { 176,  69, 13 }, { 187, 96, -31 }, { 182,  94, 49 },  1 },
		{ { 168,  66, 13 }, { 187, 98, -32 }, { 182,  92, 50 },  0 },
		{ { 155,  75, 13 }, { 187, 96, -32 }, { 182,  88, 51 },  3 },
		{ { 145,  86, 13 }, { 187, 98, -32 }, { 182,  85, 52 },  0 },
		{ { 127, 104, 13 }, { 187, 98, -32 }, { 182,  25, 52 },  1 },
		{ { 122, 108, 13 }, { 187, 98, -32 }, { 182,  25, 52 },  1 },
		{ { 120, 104, 14 }, { 187, 96, -34 }, { 107, 145, 42 },  2 },
		{ { 111, 103, 13 }, { 187, 96, -23 }, { 107, 144, 43 },  0 },
		{ { 102, 105, 13 }, { 187, 96, -23 }, { 107, 142, 43 },  0 },
		{ {  97, 107, 13 }, { 187, 96, -23 }, { 107, 139, 44 },  0 },
		{ {  92, 101, 14 }, { 187, 96, -23 }, { 107,  34, 47 },  3 },
		{ {  90, 105, 14 }, { 187, 96, -23 }, { 107,  34, 47 },  0 },
		{ {  88, 104, 14 }, { 187, 96, -23 }, { 107,  34, 47 },  0 },
		{ {  87, 105, 14 }, { 187, 96, -23 }, { 107,  34, 47 },  0 },
		{ {  86, 105, 14 }, { 187, 96, -23 }, { 107,  34, 47 },  0 },
		{ {  86, 105, 14 }, { 187, 96, -23 }, { 107,  34, 47 },  0 },
		{ {  86, 105, 15 }, { 187, 96, -23 }, {   0,   0,  0 },  0 },
		{ {  85,  98, 16 }, { 187, 96, -23 }, {   0,   0,  0 },  0 },
		{ {  92,  96,  1 }, { 187, 96, -23 }, {   0,   0,  0 },  0 },
		{ {  92,  96,  1 }, { 187, 96, -23 }, {   0,   0,  0 },  0 },
		{ {  89,  96,  4 }, { 187, 96, -23 }, {   0,   0,  0 },  0 },
		{ {  86,  96,  3 }, { 187, 96, -23 }, {   0,   0,  0 },  0 },
		{ {  83,  96,  2 }, { 187, 96, -23 }, {   0,   0,  0 },  0 },
		{ {  81,  96,  1 }, { 187, 96, -23 }, {   0,   0,  0 },  0 },
		{ {  78,  96,  4 }, { 187, 96, -23 }, {   0,   0,  0 },  0 },
		{ {  75,  96,  3 }, { 187, 96, -23 }, {   0,   0,  0 },  0 },
		{ {  75,  96,  1 }, { 187, 96, -23 }, {   0,   0,  0 },  0 },
		{ {  75,  96,  1 }, { 187, 96, -23 }, {   0,   0,  0 }, 99 }
	};
	writeRecord(_fight1Data, sizeof(_fight1Data), GBVARS_GRAPHICSFIGHT1DATA_INDEX , GBVARS_QUEEN);
}

static void addGraphics_fight2Data() {
	BamDataBlock _fight2Data[] = {
		{ {  75, 96,  1 }, { 187, 96, -23 }, { 150,  45, 35 },  0 },
		{ {  78, 96,  2 }, { 187, 96, -23 }, { 150,  45, 35 },  0 },
		{ {  81, 96,  3 }, { 189, 96, -18 }, { 150,  45, 35 },  0 },
		{ {  84, 96,  4 }, { 183, 96, -19 }, { 150,  45, 35 },  0 },
		{ {  87, 96,  1 }, { 181, 96, -20 }, { 150,  45, 35 },  0 },
		{ {  90, 96,  2 }, { 177, 96, -21 }, { 150,  45, 35 },  0 },
		{ {  93, 96,  3 }, { 171, 96, -22 }, { 150,  45, 35 },  0 },
		{ {  96, 96,  4 }, { 169, 96, -17 }, { 150,  45, 35 },  0 },
		{ {  99, 96,  1 }, { 165, 96, -18 }, { 150,  45, 35 },  0 },
		{ { 102, 96,  2 }, { 159, 96, -19 }, { 150,  45, 35 },  0 },
		{ { 105, 96,  3 }, { 157, 96, -20 }, { 150,  45, 35 },  0 },
		{ { 108, 96,  4 }, { 153, 96, -21 }, { 150,  45, 35 },  0 },
		{ { 111, 96,  1 }, { 147, 96, -22 }, { 150,  45, 35 },  0 },
		{ { 114, 96,  2 }, { 147, 96, -23 }, { 150,  45, 35 },  0 },
		{ { 117, 96,  3 }, { 147, 96, -23 }, { 150,  45, 35 },  0 },
		{ { 120, 96,  4 }, { 147, 96, -24 }, { 150,  45, 35 },  0 },
		{ { 123, 96,  1 }, { 147, 96, -25 }, { 150,  45, 35 },  0 },
		{ { 125, 96,  2 }, { 147, 96, -25 }, { 150,  45, 35 },  0 },
		{ { 127, 96, 12 }, { 147, 96, -69 }, { 122,  94, 36 },  3 },
		{ { 127, 95, 11 }, { 147, 96, -70 }, { 122,  94, 41 },  0 },
		{ { 127, 96, 12 }, { 147, 96, -71 }, { 122, 100, 36 },  3 },
		{ { 127, 97, 11 }, { 147, 96, -69 }, { 122, 100, 41 },  0 },
		{ { 127, 96, 12 }, { 147, 96, -70 }, { 127, 103, 36 },  3 },
		{ { 127, 95, 11 }, { 147, 96, -71 }, { 127, 103, 41 },  0 },
		{ { 127, 94, 12 }, { 147, 96, -69 }, { 123,  94, 36 },  3 },
		{ { 127, 95, 11 }, { 147, 96, -70 }, { 123,  94, 41 },  0 },
		{ { 127, 96, 12 }, { 147, 96, -71 }, { 120,  99, 36 },  3 },
		{ { 127, 96, 12 }, { 147, 96, -71 }, { 115,  98, 41 },  0 },
		{ { 117, 93, 11 }, { 147, 96, -25 }, { 115, 134, 42 },  0 },
		{ { 110, 92, 11 }, { 147, 96, -25 }, { 114, 133, 42 },  0 },
		{ { 102, 93, 11 }, { 147, 96, -25 }, { 114, 131, 43 },  0 },
		{ {  92, 93, 11 }, { 147, 96, -25 }, { 114, 130, 43 },  0 },
		{ {  82, 94, 11 }, { 147, 96, -25 }, { 114, 128, 44 },  0 },
		{ {  76, 95, 11 }, { 147, 96, -25 }, { 114, 127, 44 },  0 },
		{ {  70, 96, 11 }, { 147, 96, -25 }, { 114, 126, 45 },  0 },
		{ {  75, 96,  5 }, { 147, 96, -25 }, { 114, 125, 46 },  1 },
		{ {  75, 96,  6 }, { 147, 96, -25 }, { 114,  43, 46 },  0 },
		{ {  75, 96,  6 }, { 147, 96, -25 }, { 114,  43, 46 },  0 },
		{ {  75, 96,  5 }, { 147, 96, -25 }, { 114,  43, 46 },  0 },
		{ {  75, 96,  7 }, { 147, 96, -25 }, { 114,  43, 46 },  0 },
		{ {  75, 96, 68 }, { 147, 96, -25 }, { 114,  43, 46 },  0 },
		{ {  75, 96, 68 }, { 147, 96, -25 }, {  89, 104, 36 },  2 },
		{ {  75, 96, 68 }, { 147, 96, -25 }, {  94, 103, 62 },  0 },
		{ {  75, 96, 68 }, { 147, 96, -25 }, { 122, 103, 63 },  0 },
		{ {  75, 96, 68 }, { 147, 96, -25 }, { 141, 103, 64 },  0 },
		{ {  75, 96, 68 }, { 147, 96, -30 }, { 150, 103, 65 },  3 },
		{ {  75, 96, 68 }, { 156, 96, -30 }, { 160, 103, 66 },  0 },
		{ {  75, 96,  7 }, { 164, 96, -30 }, { 169, 103, 67 },  0 },
		{ {  75, 96,  5 }, { 169, 96, -30 }, { 177, 103, 48 },  3 },
		{ {  75, 96,  5 }, { 173, 96, -30 }, { 185, 103, 49 },  0 },
		{ {  75, 96,  6 }, { 178, 96, -30 }, { 198, 103, 50 },  0 },
		{ {  75, 96,  6 }, { 181, 96, -30 }, { 207, 103, 51 },  1 },
		{ {  75, 96,  5 }, { 184, 96, -30 }, { 221, 103, 52 },  0 },
		{ {  75, 96,  5 }, { 186, 96, -30 }, { 224,  53, 53 },  0 },
		{ {  75, 96,  5 }, { 187, 96, -23 }, { 224,  53, 53 }, 99 }
	};
	writeRecord(_fight2Data, sizeof(_fight2Data), GBVARS_GRAPHICSFIGHT2DATA_INDEX , GBVARS_QUEEN);
}

static void addGraphics_fight3Data() {
	BamDataBlock _fight3Data[] = {
		{ {  75, 96,  1 }, { 187,  96, -23 }, { 150,  45, 35 },  0 },
		{ {  77, 96,  2 }, { 187,  96, -22 }, { 150,  45, 35 },  0 },
		{ {  80, 96,  3 }, { 185,  96, -17 }, { 150,  45, 35 },  0 },
		{ {  83, 96,  4 }, { 181,  96, -18 }, { 150,  45, 35 },  0 },
		{ {  86, 96,  1 }, { 175,  96, -19 }, { 150,  45, 35 },  0 },
		{ {  88, 96,  2 }, { 173,  96, -20 }, { 150,  45, 35 },  0 },
		{ {  91, 96,  3 }, { 169,  96, -21 }, { 150,  45, 35 },  0 },
		{ {  94, 96,  4 }, { 163,  96, -22 }, { 150,  45, 35 },  0 },
		{ {  97, 96,  1 }, { 161,  96, -17 }, { 150,  45, 35 },  0 },
		{ {  99, 96,  2 }, { 157,  96, -18 }, { 150,  45, 35 },  0 },
		{ { 102, 96,  3 }, { 151,  96, -19 }, { 150,  45, 35 },  0 },
		{ { 105, 96,  4 }, { 149,  96, -20 }, { 150,  45, 35 },  0 },
		{ { 108, 96,  1 }, { 145,  96, -21 }, { 150,  45, 35 },  0 },
		{ { 110, 96,  2 }, { 145,  96, -25 }, { 150,  45, 35 },  0 },
		{ { 113, 96,  3 }, { 145,  96, -26 }, { 132,  96, 36 },  2 },
		{ { 117, 96,  7 }, { 145,  96, -27 }, { 122,  97, 36 },  0 },
		{ { 117, 96,  7 }, { 145,  96, -28 }, { 117,  97, 37 },  0 },
		{ { 116, 96, 12 }, { 145,  96, -24 }, { 110,  96, 38 },  3 },
		{ { 109, 96, 12 }, { 145,  96, -24 }, { 103,  95, 39 },  0 },
		{ { 105, 96, 12 }, { 145,  96, -24 }, {  95,  90, 40 },  1 },
		{ {  96, 96, 11 }, { 145,  96, -24 }, {  86,  80, 41 },  0 },
		{ {  92, 96, 11 }, { 145,  96, -24 }, {  86,  80, 41 },  0 },
		{ {  93, 96,  5 }, { 145,  96, -24 }, {  86,  38, 41 },  0 },
		{ {  91, 96,  5 }, { 145,  96, -24 }, {  86,  38, 41 },  0 },
		{ {  89, 96,  5 }, { 145,  96, -24 }, {  86,  38, 41 },  0 },
		{ {  88, 96,  5 }, { 145,  96, -24 }, {  86,  38, 41 },  0 },
		{ {  87, 96,  6 }, { 145,  96, -24 }, {  86,  38, 41 },  0 },
		{ {  87, 96,  6 }, { 145,  96, -23 }, {  86,  38, 41 },  0 },
		{ {  87, 96,  6 }, { 145,  96, -23 }, {  86,  38, 41 },  0 },
		{ {  87, 96,  5 }, { 145,  96, -23 }, {  86,  38, 41 },  0 },
		{ {  87, 96,  5 }, { 145,  96, -23 }, {  86,  38, 41 },  0 },
		{ {  87, 96,  6 }, { 145,  96, -23 }, {  86,  38, 41 },  0 },
		{ {  87, 96,  6 }, { 145,  96, -23 }, {  86,  38, 41 },  0 },
		{ {  87, 96,  5 }, { 145,  96, -23 }, {  86,  38, 41 },  0 },
		{ {  87, 96,  5 }, { 145,  96, -23 }, {  86,  38, 41 },  0 },
		{ {  87, 96,  6 }, { 145,  96, -23 }, {  86,  38, 41 },  0 },
		{ {  87, 96,  6 }, { 145,  96, -26 }, {  86,  38, 41 },  0 },
		{ {  87, 96,  6 }, { 145,  96, -27 }, { 132,  97, 36 },  2 },
		{ {  87, 96,  5 }, { 145,  96, -28 }, { 118,  97, 36 },  0 },
		{ {  87, 96,  7 }, { 145,  96, -24 }, { 107,  97, 36 },  0 },
		{ {  87, 96,  8 }, { 145,  96, -24 }, { 101,  97, 36 },  0 },
		{ {  87, 96,  9 }, { 145,  96, -23 }, { 102,  97, 66 },  3 },
		{ {  87, 96, 10 }, { 145,  96, -23 }, { 120,  97, 67 },  0 },
		{ {  87, 96, 10 }, { 145,  96, -30 }, { 139,  97, 67 },  1 },
		{ {  87, 96,  7 }, { 146,  96, -30 }, { 144,  97, 62 },  2 },
		{ {  86, 96,  4 }, { 160,  96, -30 }, { 144,  97, 48 },  1 },
		{ {  83, 96,  3 }, { 170,  96, -31 }, { 154,  93, 49 },  0 },
		{ {  80, 96,  2 }, { 174,  96, -31 }, { 161,  89, 50 },  0 },
		{ {  78, 96,  1 }, { 178,  99, -31 }, { 169,  85, 51 },  0 },
		{ {  75, 96,  4 }, { 183, 104, -31 }, { 175,  79, 52 },  0 },
		{ {  75, 96,  1 }, { 185,  99, -32 }, { 180, 144, 42 },  3 },
		{ {  75, 96,  1 }, { 185, 106, -31 }, { 181, 141, 42 },  0 },
		{ {  75, 96,  5 }, { 185, 104, -31 }, { 181, 138, 43 },  0 },
		{ {  75, 96,  5 }, { 188, 106, -31 }, { 182, 135, 43 },  0 },
		{ {  75, 96,  6 }, { 191,  99, -32 }, { 183, 131, 44 },  3 },
		{ {  75, 96,  6 }, { 191,  99, -32 }, { 183, 127, 45 },  0 },
		{ {  75, 96,  5 }, { 191,  99, -32 }, { 184, 121, 46 },  0 },
		{ {  75, 96,  5 }, { 191,  99, -32 }, { 183, 115, 46 },  0 },
		{ {  75, 96,  6 }, { 191,  99, -32 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  6 }, { 191,  99, -32 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  6 }, { 191,  99, -32 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  5 }, { 191,  99, -32 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  5 }, { 191,  99, -32 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  5 }, { 191,  99, -32 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  5 }, { 191,  99, -32 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  5 }, { 191,  99, -32 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  6 }, { 191,  99, -32 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  6 }, { 191,  99, -32 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  5 }, { 195,  98, -33 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  6 }, { 191,  96, -34 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  6 }, { 193,  96, -25 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  5 }, { 193,  96, -24 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  5 }, { 193,  96, -24 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  5 }, { 193,  96, -24 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  6 }, { 191,  96, -18 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  6 }, { 190,  96, -19 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  6 }, { 187,  96, -20 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  1 }, { 187,  96, -23 }, { 183,  41, 47 },  0 },
		{ {  75, 96,  1 }, { 187,  96, -23 }, { 183,  41, 47 }, 99 }
	};
	writeRecord(_fight3Data, sizeof(_fight3Data), GBVARS_GRAPHICSFIGHT3DATA_INDEX , GBVARS_QUEEN);
}

void Queen_addGraphics() {
	addGraphics_carData();
	addGraphics_fight1Data();
	addGraphics_fight2Data();
	addGraphics_fight3Data();
}
