#ifndef TASMRECOVER_DREAMGEN_STUBS_H__
#define TASMRECOVER_DREAMGEN_STUBS_H__

/* PLEASE DO NOT MODIFY THIS FILE. ALL CHANGES WILL BE LOST! LOOK FOR README FOR DETAILS */

/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */




#include "dreamweb/runtime.h"

namespace DreamGen {
#include "structs.h"
class DreamGenContext : public Context {
public:
	void __start();
	void __dispatch_call(uint16 addr);
#include "stubs.h" // Allow hand-reversed functions to have a signature different than void f()

	static const uint16 addr_dreamweb = 0xc948;
	static const uint16 addr_keyboardread = 0xcbb4;
	static const uint16 addr_resetkeyboard = 0xcbb0;
	static const uint16 addr_setkeyboardint = 0xcbac;
	static const uint16 addr_readfromfile = 0xcba8;
	static const uint16 addr_closefile = 0xcba4;
	static const uint16 addr_openforsave = 0xcba0;
	static const uint16 addr_openfilenocheck = 0xcb9c;
	static const uint16 addr_openfilefromc = 0xcb94;
	static const uint16 addr_openfile = 0xcb90;
	static const uint16 addr_createfile = 0xcb8c;
	static const uint16 addr_readsetdata = 0xcb88;
	static const uint16 addr_getridoftempsp = 0xcb84;
	static const uint16 addr_getridoftempcharset = 0xcb80;
	static const uint16 addr_getridoftemp3 = 0xcb7c;
	static const uint16 addr_getridoftemp2 = 0xcb78;
	static const uint16 addr_getridoftemptext = 0xcb74;
	static const uint16 addr_getridoftemp = 0xcb70;
	static const uint16 addr_allocateload = 0xcb68;
	static const uint16 addr_dontloadseg = 0xcb64;
	static const uint16 addr_findroominloc = 0xcb58;
	static const uint16 addr_disablepath = 0xcb50;
	static const uint16 addr_sortoutmap = 0xcb48;
	static const uint16 addr_restoreall = 0xcb44;
	static const uint16 addr_restorereels = 0xcb40;
	static const uint16 addr_getridofall = 0xcb3c;
	static const uint16 addr_getridofreels = 0xcb38;
	static const uint16 addr_loadroomssample = 0xcb34;
	static const uint16 addr_loadroom = 0xcb30;
	static const uint16 addr_loadtemptext = 0xcb2c;
	static const uint16 addr_standardload = 0xcb28;
	static const uint16 addr_loadtempcharset = 0xcb24;
	static const uint16 addr_loadintotemp3 = 0xcb20;
	static const uint16 addr_loadintotemp2 = 0xcb1c;
	static const uint16 addr_loadintotemp = 0xcb18;
	static const uint16 addr_loadtraveltext = 0xcb14;
	static const uint16 addr_randomnum2 = 0xcb08;
	static const uint16 addr_randomnum1 = 0xcb04;
	static const uint16 addr_readkey = 0xcafc;
	static const uint16 addr_mousecall = 0xcae8;
	static const uint16 addr_setmouse = 0xcae0;
	static const uint16 addr_undertextline = 0xcad0;
	static const uint16 addr_putunderzoom = 0xcabc;
	static const uint16 addr_dumpzoom = 0xcab8;
	static const uint16 addr_getunderzoom = 0xcab4;
	static const uint16 addr_hangoncurs = 0xcab0;
	static const uint16 addr_hangonw = 0xcaac;
	static const uint16 addr_allpointer = 0xcaa4;
	static const uint16 addr_blank = 0xcaa0;
	static const uint16 addr_worktoscreenm = 0xca9c;
	static const uint16 addr_zoomicon = 0xca90;
	static const uint16 addr_gettime = 0xca8c;
	static const uint16 addr_showwatch = 0xca88;
	static const uint16 addr_panelicons1 = 0xca84;
	static const uint16 addr_showexit = 0xca80;
	static const uint16 addr_usetempcharset = 0xca7c;
	static const uint16 addr_usecharset1 = 0xca78;
	static const uint16 addr_roomname = 0xca74;
	static const uint16 addr_showman = 0xca6c;
	static const uint16 addr_middlepanel = 0xca68;
	static const uint16 addr_showicon = 0xca64;
	static const uint16 addr_workoutframes = 0xca54;
	static const uint16 addr_setwalk = 0xca44;
	static const uint16 addr_printmessage2 = 0xca30;
	static const uint16 addr_afterintroroom = 0xca14;
	static const uint16 addr_walkintoroom = 0xca10;
	static const uint16 addr_atmospheres = 0xca0c;
	static const uint16 addr_afternewroom = 0xca08;
	static const uint16 addr_findfirstpath = 0xc9f0;
	static const uint16 addr_findpathofpoint = 0xc9ec;
	static const uint16 addr_identifyob = 0xc9d4;
	static const uint16 addr_madmanrun = 0xc9cc;
	static const uint16 addr_mainscreen = 0xc9c8;
	static const uint16 addr_convnum = 0xc9c4;
	static const uint16 addr_showword = 0xc9c0;
	static const uint16 addr_twodigitnum = 0xc9bc;
	static const uint16 addr_onedigit = 0xc9b8;
	static const uint16 addr_showbyte = 0xc9b4;
	static const uint16 addr_dumpwatch = 0xc9b0;
	static const uint16 addr_showtime = 0xc9ac;
	static const uint16 addr_watchcount = 0xc9a8;
	static const uint16 addr_checkforshake = 0xc9a4;
	static const uint16 addr_watchreel = 0xc9a0;
	static const uint16 addr_screenupdate = 0xc99c;
	static const uint16 addr_startup1 = 0xc998;
	static const uint16 addr_startup = 0xc994;
	static const uint16 addr_allocatemem = 0xc988;
	static const uint16 addr_deallocatemem = 0xc984;
	static const uint16 addr_clearrest = 0xc980;
	static const uint16 addr_clearreels = 0xc97c;
	static const uint16 addr_clearbeforeload = 0xc978;
	static const uint16 addr_clearchanges = 0xc974;
	static const uint16 addr_clearbuffers = 0xc970;
	static const uint16 addr_allocatebuffers = 0xc96c;
	static const uint16 addr_checkbasemem = 0xc968;
	static const uint16 addr_checkforemm = 0xc964;
	static const uint16 addr_removeemm = 0xc960;
	static const uint16 addr_setupemm = 0xc95c;
	static const uint16 addr_pickupob = 0xc958;
	static const uint16 addr_initialinv = 0xc954;
	static const uint16 addr_entryanims = 0xc950;
	static const uint16 addr_entrytexts = 0xc94c;
	static const uint16 addr_pitinterupt = 0xc944;
	static const uint16 addr_getridofpit = 0xc940;
	static const uint16 addr_setuppit = 0xc93c;
	static const uint16 addr_startdmablock = 0xc938;
	static const uint16 addr_dmaend = 0xc934;
	static const uint16 addr_restoreems = 0xc92c;
	static const uint16 addr_saveems = 0xc928;
	static const uint16 addr_bothchannels = 0xc924;
	static const uint16 addr_channel1only = 0xc91c;
	static const uint16 addr_channel0only = 0xc918;
	static const uint16 addr_volumeadjust = 0xc908;
	static const uint16 addr_playchannel1 = 0xc900;
	static const uint16 addr_playchannel0 = 0xc8fc;
	static const uint16 addr_out22c = 0xc8f8;
	static const uint16 addr_soundend = 0xc8f4;
	static const uint16 addr_interupttest = 0xc8f0;
	static const uint16 addr_disablesoundint = 0xc8ec;
	static const uint16 addr_enablesoundint = 0xc8e8;
	static const uint16 addr_checksoundint = 0xc8e4;
	static const uint16 addr_setsoundoff = 0xc8e0;
	static const uint16 addr_trysoundalloc = 0xc8dc;
	static const uint16 addr_soundstartup = 0xc8d8;
	static const uint16 addr_loadsecondsample = 0xc8d4;
	static const uint16 addr_loadsample = 0xc8d0;
	static const uint16 addr_createname = 0xc8cc;
	static const uint16 addr_loadspeech = 0xc8c8;
	static const uint16 addr_loadold = 0xc8c4;
	static const uint16 addr_doload = 0xcbb8;
	static const uint16 addr_newgame = 0xc8c0;
	static const uint16 addr_showdecisions = 0xc8bc;
	static const uint16 addr_decide = 0xc8b8;
	static const uint16 addr_scanfornames = 0xc8b4;
	static const uint16 addr_saveseg = 0xc8ac;
	static const uint16 addr_storeit = 0xc8a8;
	static const uint16 addr_makeheader = 0xc8a4;
	static const uint16 addr_loadseg = 0xc8a0;
	static const uint16 addr_loadposition = 0xc89c;
	static const uint16 addr_saveposition = 0xc898;
	static const uint16 addr_savefileread = 0xc894;
	static const uint16 addr_savefilewrite = 0xc890;
	static const uint16 addr_oldtonames = 0xc88c;
	static const uint16 addr_namestoold = 0xc888;
	static const uint16 addr_error = 0xc884;
	static const uint16 addr_generalerror = 0xcbbc;
	static const uint16 addr_dosreturn = 0xc880;
	static const uint16 addr_shownames = 0xc87c;
	static const uint16 addr_showslots = 0xc878;
	static const uint16 addr_selectslot = 0xc874;
	static const uint16 addr_showsaveops = 0xc870;
	static const uint16 addr_showloadops = 0xc86c;
	static const uint16 addr_showopbox = 0xc868;
	static const uint16 addr_getnamepos = 0xc864;
	static const uint16 addr_checkinput = 0xc860;
	static const uint16 addr_selectslot2 = 0xc85c;
	static const uint16 addr_actualload = 0xc858;
	static const uint16 addr_actualsave = 0xc854;
	static const uint16 addr_savegame = 0xc850;
	static const uint16 addr_discops = 0xc84c;
	static const uint16 addr_getbacktoops = 0xc848;
	static const uint16 addr_loadgame = 0xc844;
	static const uint16 addr_loadsavebox = 0xc840;
	static const uint16 addr_showdiscops = 0xc83c;
	static const uint16 addr_showmainops = 0xc838;
	static const uint16 addr_getbackfromops = 0xc834;
	static const uint16 addr_dosaveload = 0xc830;
	static const uint16 addr_saveload = 0xc82c;
	static const uint16 addr_zoomonoff = 0xc828;
	static const uint16 addr_findtext1 = 0xc824;
	static const uint16 addr_showdiarypage = 0xc820;
	static const uint16 addr_diarykeyn = 0xc81c;
	static const uint16 addr_diarykeyp = 0xc818;
	static const uint16 addr_dumpdiarykeys = 0xc814;
	static const uint16 addr_showdiarykeys = 0xc810;
	static const uint16 addr_showdiary = 0xc80c;
	static const uint16 addr_usediary = 0xc808;
	static const uint16 addr_dumpsymbox = 0xc804;
	static const uint16 addr_updatesymbolbot = 0xc800;
	static const uint16 addr_updatesymboltop = 0xc7fc;
	static const uint16 addr_nextsymbol = 0xc7f8;
	static const uint16 addr_showsymbol = 0xc7f4;
	static const uint16 addr_dumpsymbol = 0xc7f0;
	static const uint16 addr_setbotright = 0xc7ec;
	static const uint16 addr_setbotleft = 0xc7e8;
	static const uint16 addr_settopright = 0xc7e4;
	static const uint16 addr_settopleft = 0xc7e0;
	static const uint16 addr_quitsymbol = 0xc7dc;
	static const uint16 addr_entersymbol = 0xc7d8;
	static const uint16 addr_showrightpage = 0xc7d4;
	static const uint16 addr_showleftpage = 0xc7d0;
	static const uint16 addr_folderexit = 0xc7cc;
	static const uint16 addr_showfolder = 0xc7c8;
	static const uint16 addr_loadfolder = 0xc7c4;
	static const uint16 addr_lastfolder = 0xc7c0;
	static const uint16 addr_folderhints = 0xc7bc;
	static const uint16 addr_nextfolder = 0xc7b8;
	static const uint16 addr_viewfolder = 0xc7b4;
	static const uint16 addr_loadmenu = 0xc7b0;
	static const uint16 addr_showmenu = 0xc7ac;
	static const uint16 addr_showoutermenu = 0xc7a8;
	static const uint16 addr_putundermenu = 0xc7a4;
	static const uint16 addr_getundermenu = 0xc7a0;
	static const uint16 addr_dumpmenu = 0xc79c;
	static const uint16 addr_usemenu = 0xc798;
	static const uint16 addr_dumpkeypad = 0xc794;
	static const uint16 addr_singlekey = 0xc790;
	static const uint16 addr_showkeypad = 0xc78c;
	static const uint16 addr_showouterpad = 0xc788;
	static const uint16 addr_buttonpress = 0xc784;
	static const uint16 addr_buttonenter = 0xc780;
	static const uint16 addr_buttonnought = 0xc77c;
	static const uint16 addr_buttonnine = 0xc778;
	static const uint16 addr_buttoneight = 0xc774;
	static const uint16 addr_buttonseven = 0xc770;
	static const uint16 addr_buttonsix = 0xc76c;
	static const uint16 addr_buttonfive = 0xc768;
	static const uint16 addr_buttonfour = 0xc764;
	static const uint16 addr_buttonthree = 0xc760;
	static const uint16 addr_buttontwo = 0xc75c;
	static const uint16 addr_buttonone = 0xc758;
	static const uint16 addr_addtopresslist = 0xc754;
	static const uint16 addr_quitkey = 0xc750;
	static const uint16 addr_loadkeypad = 0xc74c;
	static const uint16 addr_entercode = 0xc748;
	static const uint16 addr_usewinch = 0xc744;
	static const uint16 addr_useplate = 0xc740;
	static const uint16 addr_usebuttona = 0xc73c;
	static const uint16 addr_useshield = 0xc738;
	static const uint16 addr_usegun = 0xc734;
	static const uint16 addr_usechurchgate = 0xc730;
	static const uint16 addr_usewall = 0xc72c;
	static const uint16 addr_edenscdplayer = 0xc728;
	static const uint16 addr_setuptimeduse = 0xc71c;
	static const uint16 addr_autoappear = 0xc70c;
	static const uint16 addr_switchryanoff = 0xc700;
	static const uint16 addr_switchryanon = 0xc6fc;
	static const uint16 addr_removefreeobject = 0xc6f4;
	static const uint16 addr_placefreeobject = 0xc6f0;
	static const uint16 addr_issetobonmap = 0xc6ec;
	static const uint16 addr_findpuztext = 0xc6e0;
	static const uint16 addr_showpuztext = 0xc6dc;
	static const uint16 addr_putbackobstuff = 0xc6d8;
	static const uint16 addr_checkinside = 0xc6d0;
	static const uint16 addr_isryanholding = 0xc6cc;
	static const uint16 addr_findexobject = 0xc6c8;
	static const uint16 addr_findsetobject = 0xc6c4;
	static const uint16 addr_selectob = 0xc6bc;
	static const uint16 addr_withwhat = 0xc6b8;
	static const uint16 addr_useelvdoor = 0xc6b4;
	static const uint16 addr_useaxe = 0xc6b0;
	static const uint16 addr_usecooker = 0xc6ac;
	static const uint16 addr_usestereo = 0xc6a8;
	static const uint16 addr_usekey = 0xc6a4;
	static const uint16 addr_useelevator5 = 0xc6a0;
	static const uint16 addr_useelevator2 = 0xc69c;
	static const uint16 addr_useelevator4 = 0xc698;
	static const uint16 addr_useelevator3 = 0xc694;
	static const uint16 addr_showfirstuse = 0xc690;
	static const uint16 addr_useelevator1 = 0xc68c;
	static const uint16 addr_usehandle = 0xc688;
	static const uint16 addr_usewire = 0xc684;
	static const uint16 addr_usehatch = 0xc680;
	static const uint16 addr_usecontrol = 0xc67c;
	static const uint16 addr_moneypoke = 0xc678;
	static const uint16 addr_lookatcard = 0xc674;
	static const uint16 addr_usecashcard = 0xc670;
	static const uint16 addr_usecardreader3 = 0xc66c;
	static const uint16 addr_usecardreader2 = 0xc668;
	static const uint16 addr_usecardreader1 = 0xc664;
	static const uint16 addr_showseconduse = 0xc660;
	static const uint16 addr_uselighter = 0xc65c;
	static const uint16 addr_usepoolreader = 0xc658;
	static const uint16 addr_calledensdlift = 0xc654;
	static const uint16 addr_calledenslift = 0xc650;
	static const uint16 addr_callhotellift = 0xc64c;
	static const uint16 addr_trapdoor = 0xc648;
	static const uint16 addr_grafittidoor = 0xc644;
	static const uint16 addr_openhoteldoor2 = 0xc640;
	static const uint16 addr_openhoteldoor = 0xc63c;
	static const uint16 addr_drawitall = 0xc638;
	static const uint16 addr_isitright = 0xc634;
	static const uint16 addr_opensarters = 0xc630;
	static const uint16 addr_openeden = 0xc62c;
	static const uint16 addr_openpoolboss = 0xc628;
	static const uint16 addr_openryan = 0xc624;
	static const uint16 addr_usebalcony = 0xc620;
	static const uint16 addr_usewindow = 0xc61c;
	static const uint16 addr_openyourneighbour = 0xc618;
	static const uint16 addr_nextcolon = 0xc614;
	static const uint16 addr_openlouis = 0xc610;
	static const uint16 addr_usedryer = 0xc60c;
	static const uint16 addr_opentvdoor = 0xc608;
	static const uint16 addr_usealtar = 0xc604;
	static const uint16 addr_usehole = 0xc600;
	static const uint16 addr_usechurchhole = 0xc5fc;
	static const uint16 addr_sitdowninbar = 0xc5f8;
	static const uint16 addr_wearshades = 0xc5f4;
	static const uint16 addr_wearwatch = 0xc5f0;
	static const uint16 addr_useopenbox = 0xc5ec;
	static const uint16 addr_userailing = 0xc5e8;
	static const uint16 addr_usecoveredbox = 0xc5e4;
	static const uint16 addr_useclearbox = 0xc5e0;
	static const uint16 addr_usecart = 0xc5dc;
	static const uint16 addr_useslab = 0xc5d8;
	static const uint16 addr_slabdoorf = 0xc5d4;
	static const uint16 addr_slabdoore = 0xc5d0;
	static const uint16 addr_slabdoorc = 0xc5cc;
	static const uint16 addr_slabdoord = 0xc5c8;
	static const uint16 addr_slabdoorb = 0xc5c4;
	static const uint16 addr_slabdoora = 0xc5c0;
	static const uint16 addr_useladderb = 0xc5bc;
	static const uint16 addr_useladder = 0xc5b8;
	static const uint16 addr_chewy = 0xc5b4;
	static const uint16 addr_useplinth = 0xc5b0;
	static const uint16 addr_usefullcart = 0xc5ac;
	static const uint16 addr_usepipe = 0xc5a8;
	static const uint16 addr_nothelderror = 0xc5a4;
	static const uint16 addr_usetrainer = 0xc5a0;
	static const uint16 addr_opentomb = 0xc59c;
	static const uint16 addr_hotelbell = 0xc598;
	static const uint16 addr_hotelcontrol = 0xc594;
	static const uint16 addr_playguitar = 0xc590;
	static const uint16 addr_runtap = 0xc58c;
	static const uint16 addr_wheelsound = 0xc588;
	static const uint16 addr_useobject = 0xc580;
	static const uint16 addr_delcurs = 0xc57c;
	static const uint16 addr_printcurs = 0xc578;
	static const uint16 addr_triggermessage = 0xc574;
	static const uint16 addr_processtrigger = 0xc570;
	static const uint16 addr_monmessage = 0xc56c;
	static const uint16 addr_showcurrentfile = 0xc568;
	static const uint16 addr_printlogo = 0xc564;
	static const uint16 addr_monitorlogo = 0xc560;
	static const uint16 addr_scrollmonitor = 0xc558;
	static const uint16 addr_parser = 0xc554;
	static const uint16 addr_searchforstring = 0xc550;
	static const uint16 addr_getkeyandlogo = 0xc54c;
	static const uint16 addr_dirfile = 0xc548;
	static const uint16 addr_read = 0xc544;
	static const uint16 addr_showkeys = 0xc540;
	static const uint16 addr_signon = 0xc53c;
	static const uint16 addr_searchforfiles = 0xc538;
	static const uint16 addr_dircom = 0xc534;
	static const uint16 addr_neterror = 0xc530;
	static const uint16 addr_execcommand = 0xc52c;
	static const uint16 addr_delchar = 0xc528;
	static const uint16 addr_makecaps = 0xc524;
	static const uint16 addr_input = 0xc520;
	static const uint16 addr_locklightoff = 0xc51c;
	static const uint16 addr_locklighton = 0xc518;
	static const uint16 addr_accesslightoff = 0xc514;
	static const uint16 addr_accesslighton = 0xc510;
	static const uint16 addr_powerlightoff = 0xc50c;
	static const uint16 addr_powerlighton = 0xc508;
	static const uint16 addr_randomaccess = 0xc504;
	static const uint16 addr_turnonpower = 0xc500;
	static const uint16 addr_lookininterface = 0xc4fc;
	static const uint16 addr_loadcart = 0xc4f8;
	static const uint16 addr_loadnews = 0xc4f4;
	static const uint16 addr_loadpersonal = 0xc4f0;
	static const uint16 addr_printoutermon = 0xc4ec;
	static const uint16 addr_usemon = 0xc4e8;
	static const uint16 addr_readcitypic = 0xc4e4;
	static const uint16 addr_readdesticon = 0xc4e0;
	static const uint16 addr_resetlocation = 0xc4dc;
	static const uint16 addr_setlocation = 0xc4d8;
	static const uint16 addr_getlocation = 0xc4d4;
	static const uint16 addr_destselect = 0xc4d0;
	static const uint16 addr_lastdest = 0xc4cc;
	static const uint16 addr_nextdest = 0xc4c8;
	static const uint16 addr_showarrows = 0xc4c4;
	static const uint16 addr_getdestinfo = 0xc4c0;
	static const uint16 addr_locationpic = 0xc4bc;
	static const uint16 addr_putundercentre = 0xc4b8;
	static const uint16 addr_getundercentre = 0xc4b4;
	static const uint16 addr_lookatplace = 0xc4b0;
	static const uint16 addr_showcity = 0xc4ac;
	static const uint16 addr_selectlocation = 0xc4a8;
	static const uint16 addr_newplace = 0xc4a4;
	static const uint16 addr_redes = 0xc4a0;
	static const uint16 addr_hangonpq = 0xc49c;
	static const uint16 addr_dosometalk = 0xc498;
	static const uint16 addr_moretalk = 0xc494;
	static const uint16 addr_getpersontext = 0xc490;
	static const uint16 addr_starttalk = 0xc48c;
	static const uint16 addr_getpersframe = 0xc488;
	static const uint16 addr_convicons = 0xc484;
	static const uint16 addr_talk = 0xc480;
	static const uint16 addr_getback1 = 0xc47c;
	static const uint16 addr_redrawmainscrn = 0xc478;
	static const uint16 addr_dolook = 0xc474;
	static const uint16 addr_look = 0xc470;
	static const uint16 addr_autolook = 0xc46c;
	static const uint16 addr_drawfloor = 0xc428;
	static const uint16 addr_blockget = 0xc424;
	static const uint16 addr_deleteextext = 0xc420;
	static const uint16 addr_deleteexframe = 0xc41c;
	static const uint16 addr_deleteexobject = 0xc418;
	static const uint16 addr_purgeanitem = 0xc414;
	static const uint16 addr_emergencypurge = 0xc410;
	static const uint16 addr_purgealocation = 0xc40c;
	static const uint16 addr_transfertext = 0xc404;
	static const uint16 addr_transfercontoex = 0xc400;
	static const uint16 addr_pickupconts = 0xc3fc;
	static const uint16 addr_transfertoex = 0xc3f8;
	static const uint16 addr_outofopen = 0xc3f4;
	static const uint16 addr_checkobjectsize = 0xc3f0;
	static const uint16 addr_errormessage3 = 0xc3ec;
	static const uint16 addr_errormessage2 = 0xc3e8;
	static const uint16 addr_errormessage1 = 0xc3e4;
	static const uint16 addr_useopened = 0xc3e0;
	static const uint16 addr_selectopenob = 0xc3dc;
	static const uint16 addr_removeobfrominv = 0xc3d8;
	static const uint16 addr_cantdrop = 0xc3d0;
	static const uint16 addr_droperror = 0xc3cc;
	static const uint16 addr_dropobject = 0xc3c8;
	static const uint16 addr_findopenpos = 0xc3c4;
	static const uint16 addr_findinvpos = 0xc3c0;
	static const uint16 addr_getsetad = 0xc3bc;
	static const uint16 addr_getopenedsize = 0xc3b8;
	static const uint16 addr_getanyaddir = 0xc3b4;
	static const uint16 addr_getanyad = 0xc3b0;
	static const uint16 addr_geteitherad = 0xc3ac;
	static const uint16 addr_getexad = 0xc3a8;
	static const uint16 addr_getfreead = 0xc3a4;
	static const uint16 addr_outofinv = 0xc3a0;
	static const uint16 addr_intoinv = 0xc398;
	static const uint16 addr_swapwithopen = 0xc394;
	static const uint16 addr_swapwithinv = 0xc390;
	static const uint16 addr_reexfromopen = 0xc38c;
	static const uint16 addr_reexfrominv = 0xc388;
	static const uint16 addr_examinventory = 0xc384;
	static const uint16 addr_setpickup = 0xc380;
	static const uint16 addr_inventory = 0xc37c;
	static const uint16 addr_searchforsame = 0xc374;
	static const uint16 addr_getobtextstart = 0xc370;
	static const uint16 addr_obsthatdothings = 0xc36c;
	static const uint16 addr_additionaltext = 0xc368;
	static const uint16 addr_describeob = 0xc364;
	static const uint16 addr_examicon = 0xc35c;
	static const uint16 addr_openob = 0xc354;
	static const uint16 addr_openinv = 0xc34c;
	static const uint16 addr_incryanpage = 0xc348;
	static const uint16 addr_getbackfromob = 0xc344;
	static const uint16 addr_makemainscreen = 0xc340;
	static const uint16 addr_examineob = 0xc33c;
	static const uint16 addr_findallopen = 0xc32c;
	static const uint16 addr_fillopen = 0xc324;
	static const uint16 addr_monprint = 0xc314;
	static const uint16 addr_realcredits = 0xc2f8;
	static const uint16 addr_set16colpalette = 0xc2f4;
	static const uint16 addr_mode640x480 = 0xc2f0;
	static const uint16 addr_loadintroroom = 0xc2ec;
	static const uint16 addr_runendseq = 0xc2e8;
	static const uint16 addr_runintroseq = 0xc2e4;
	static const uint16 addr_intro = 0xc2e0;
	static const uint16 addr_hangone = 0xc2dc;
	static const uint16 addr_biblequote = 0xc2d8;
	static const uint16 addr_credits = 0xc2d4;
	static const uint16 addr_gettingshot = 0xc2d0;
	static const uint16 addr_showmonk = 0xc2cc;
	static const uint16 addr_monkspeaking = 0xc2c8;
	static const uint16 addr_endgame = 0xc2c4;
	static const uint16 addr_titles = 0xc2c0;
	static const uint16 addr_initialmoncols = 0xc2bc;
	static const uint16 addr_fadeupyellows = 0xc2b8;
	static const uint16 addr_fadeupmonfirst = 0xc2b4;
	static const uint16 addr_fadeupmon = 0xc2b0;
	static const uint16 addr_fadedownmon = 0xc2ac;
	static const uint16 addr_dumpcurrent = 0xc2a8;
	static const uint16 addr_allpalette = 0xc2a4;
	static const uint16 addr_paltoendpal = 0xc2a0;
	static const uint16 addr_startpaltoend = 0xc29c;
	static const uint16 addr_endpaltostart = 0xc298;
	static const uint16 addr_paltostartpal = 0xc294;
	static const uint16 addr_showgroup = 0xc290;
	static const uint16 addr_greyscalesum = 0xc28c;
	static const uint16 addr_fadecalculation = 0xc288;
	static const uint16 addr_rollem = 0xc284;
	static const uint16 addr_rollendcredits2 = 0xc280;
	static const uint16 addr_showgun = 0xc27c;
	static const uint16 addr_clearstartpal = 0xc278;
	static const uint16 addr_fadescreendowns = 0xc274;
	static const uint16 addr_fadescreendown = 0xc270;
	static const uint16 addr_fadescreenuphalf = 0xc26c;
	static const uint16 addr_fadescreendownhalf = 0xc268;
	static const uint16 addr_fadescreenups = 0xc264;
	static const uint16 addr_fadefromwhite = 0xc260;
	static const uint16 addr_fadetowhite = 0xc25c;
	static const uint16 addr_fadescreenup = 0xc258;
	static const uint16 addr_clearpalette = 0xc254;
	static const uint16 addr_clearendpal = 0xc250;
	static const uint16 addr_dofade = 0xc24c;
	static const uint16 addr_fadedos = 0xc248;
	static const uint16 addr_transfermap = 0xc244;
	static const uint16 addr_doshake = 0xc20c;
	static const uint16 addr_vsync = 0xc208;
	static const uint16 addr_createpanel2 = 0xc200;
	static const uint16 addr_createpanel = 0xc1fc;
	static const uint16 addr_setmode = 0xc1dc;
	static const uint16 addr_loadpalfromiff = 0xc1d8;
	static const uint16 addr_showpcx = 0xc1cc;
	static const uint16 addr_deleverything = 0xc1c0;
	static const uint16 addr_reconstruct = 0xc1ac;
	static const uint16 addr_soundonreels = 0xc1a8;
	static const uint16 addr_reelsonscreen = 0xc1a0;
	static const uint16 addr_constant = 0xc184;
	static const uint16 addr_steady = 0xc180;
	static const uint16 addr_random = 0xc17c;
	static const uint16 addr_liftnoise = 0xc178;
	static const uint16 addr_backobject = 0xc170;
	static const uint16 addr_splitintolines = 0xc164;
	static const uint16 addr_initrain = 0xc160;
	static const uint16 addr_reminders = 0xc15c;
	static const uint16 addr_adjustright = 0xc158;
	static const uint16 addr_adjustleft = 0xc154;
	static const uint16 addr_adjustup = 0xc150;
	static const uint16 addr_adjustdown = 0xc14c;
	static const uint16 addr_checkforexit = 0xc148;
	static const uint16 addr_mainman = 0xc138;
	static const uint16 addr_checkspeed = 0xc110;
	static const uint16 addr_train = 0xc104;
	static const uint16 addr_sparky = 0xc100;
	static const uint16 addr_copper = 0xc0fc;
	static const uint16 addr_advisor = 0xc0f8;
	static const uint16 addr_drunk = 0xc0f4;
	static const uint16 addr_textformonk = 0xc0f0;
	static const uint16 addr_textforend = 0xc0ec;
	static const uint16 addr_priesttext = 0xc0e8;
	static const uint16 addr_madman = 0xc0dc;
	static const uint16 addr_madmanstelly = 0xc0d8;
	static const uint16 addr_priest = 0xc0d4;
	static const uint16 addr_rollendcredits = 0xc0d0;
	static const uint16 addr_endgameseq = 0xc0cc;
	static const uint16 addr_monkandryan = 0xc0c8;
	static const uint16 addr_intro3text = 0xc0c4;
	static const uint16 addr_intro2text = 0xc0c0;
	static const uint16 addr_intro1text = 0xc0bc;
	static const uint16 addr_monks2text = 0xc0b8;
	static const uint16 addr_handclap = 0xc0b4;
	static const uint16 addr_intromonks2 = 0xc0b0;
	static const uint16 addr_intromonks1 = 0xc0ac;
	static const uint16 addr_intromagic3 = 0xc0a8;
	static const uint16 addr_intromagic2 = 0xc0a4;
	static const uint16 addr_gates = 0xc0a0;
	static const uint16 addr_candles2 = 0xc09c;
	static const uint16 addr_candles = 0xc098;
	static const uint16 addr_intromagic1 = 0xc094;
	static const uint16 addr_smallcandle = 0xc090;
	static const uint16 addr_candles1 = 0xc08c;
	static const uint16 addr_keeper = 0xc088;
	static const uint16 addr_carparkdrip = 0xc084;
	static const uint16 addr_sparkydrip = 0xc080;
	static const uint16 addr_gamer = 0xc07c;
	static const uint16 addr_bossman = 0xc078;
	static const uint16 addr_heavy = 0xc074;
	static const uint16 addr_security = 0xc070;
	static const uint16 addr_poolguard = 0xc06c;
	static const uint16 addr_businessman = 0xc068;
	static const uint16 addr_aide = 0xc064;
	static const uint16 addr_mugger = 0xc060;
	static const uint16 addr_helicopter = 0xc05c;
	static const uint16 addr_rockstar = 0xc058;
	static const uint16 addr_soldier1 = 0xc054;
	static const uint16 addr_interviewer = 0xc050;
	static const uint16 addr_barwoman = 0xc04c;
	static const uint16 addr_othersmoker = 0xc048;
	static const uint16 addr_bartender = 0xc044;
	static const uint16 addr_drinker = 0xc040;
	static const uint16 addr_tattooman = 0xc03c;
	static const uint16 addr_mansatstill = 0xc038;
	static const uint16 addr_manasleep2 = 0xc034;
	static const uint16 addr_louischair = 0xc030;
	static const uint16 addr_louis = 0xc02c;
	static const uint16 addr_femalefan = 0xc028;
	static const uint16 addr_malefan = 0xc024;
	static const uint16 addr_edeninbath = 0xc020;
	static const uint16 addr_eden = 0xc01c;
	static const uint16 addr_manasleep = 0xc018;
	static const uint16 addr_attendant = 0xc014;
	static const uint16 addr_smokebloke = 0xc010;
	static const uint16 addr_receptionist = 0xc00c;
	static const uint16 addr_foghornsound = 0xc008;
	static const uint16 addr_intromusic = 0xc004;
	static const uint16 addr_alleybarksound = 0xc000;
	static const uint16 offset_quitlist = 0x0a84;
	static const uint16 offset_savelist = 0x0f44;
	static const uint16 offset_mainlist = 0x1402;
	static const uint16 offset_gameerror8 = 0x113f;
	static const uint16 offset_gameerror5 = 0x1074;
	static const uint16 offset_error2patch = 0x0ff6;
	static const uint16 offset_openchangesize = 0x0a1c;
	static const uint16 offset_keys = 0x0b14;
	static const uint16 offset_mainlist2 = 0x1440;
	static const uint16 offset_gameerror2 = 0x0fb2;
	static const uint16 offset_loadlist = 0x0ef0;
	static const uint16 offset_gameerror6 = 0x10be;
	static const uint16 offset_speechfile = 0x13f1;
	static const uint16 offset_atmospherelist = 0x147e;
	static const uint16 offset_gameerror4 = 0x1037;
	static const uint16 offset_gameerror1 = 0x0f6e;
	static const uint16 offset_examlist = 0x09be;
	static const uint16 offset_gameinfo = 0x1170;
	static const uint16 offset_opslist = 0x0ec6;
	static const uint16 offset_invlist1 = 0x09fc;
	static const uint16 offset_money2poke = 0x0d97;
	static const uint16 offset_talklist = 0x0a64;
	static const uint16 offset_menulist = 0x0e1e;
	static const uint16 offset_comlist = 0x0ad8;
	static const uint16 offset_withlist1 = 0x0a3a;
	static const uint16 offset_money1poke = 0x0d92;
	static const uint16 offset_gameerror7 = 0x1104;
	static const uint16 offset_discopslist = 0x0f1a;
	static const uint16 offset_commandline = 0x16d7;
	static const uint16 offset_destlist = 0x0a9a;
	static const uint16 offset_shaketable = 0x06af;
	static const uint16 offset_error6patch = 0x10fe;
	static const uint16 offset_keybuffer = 0x1718;
	static const uint16 offset_speechfilename = 0x13eb;
	static const uint16 offset_rootdir = 0x0b8c;
	static const uint16 offset_gameerror3 = 0x1003;
	static const uint16 offset_rainlocations = 0x0459;
	static const uint16 offset_diarylist = 0x0e9c;
	static const uint16 offset_decidelist = 0x13c1;
	static const uint16 offset_symbollist = 0x0e5e;
	static const uint16 offset_folderlist = 0x0e34;
	static const uint16 offset_facelist = 0x0451;
	static const uint16 offset_operand1 = 0x0b7e;
	static const uint16 offset_keypadlist = 0x0d9a;
	static const uint16 kStartvars = 0;
	static const uint16 kProgresspoints = 1;
	static const uint16 kWatchon = 2;
	static const uint16 kShadeson = 3;
	static const uint16 kSecondcount = 4;
	static const uint16 kMinutecount = 5;
	static const uint16 kHourcount = 6;
	static const uint16 kZoomon = 7;
	static const uint16 kLocation = 8;
	static const uint16 kExpos = 9;
	static const uint16 kExframepos = 10;
	static const uint16 kExtextpos = 12;
	static const uint16 kCard1money = 14;
	static const uint16 kListpos = 16;
	static const uint16 kRyanpage = 18;
	static const uint16 kWatchingtime = 19;
	static const uint16 kReeltowatch = 21;
	static const uint16 kEndwatchreel = 23;
	static const uint16 kSpeedcount = 25;
	static const uint16 kWatchspeed = 26;
	static const uint16 kReeltohold = 27;
	static const uint16 kEndofholdreel = 29;
	static const uint16 kWatchmode = 31;
	static const uint16 kDestafterhold = 32;
	static const uint16 kNewsitem = 33;
	static const uint16 kLiftflag = 34;
	static const uint16 kLiftpath = 35;
	static const uint16 kLockstatus = 36;
	static const uint16 kDoorpath = 37;
	static const uint16 kCounttoopen = 38;
	static const uint16 kCounttoclose = 39;
	static const uint16 kRockstardead = 40;
	static const uint16 kGeneraldead = 41;
	static const uint16 kSartaindead = 42;
	static const uint16 kAidedead = 43;
	static const uint16 kBeenmugged = 44;
	static const uint16 kGunpassflag = 45;
	static const uint16 kCanmovealtar = 46;
	static const uint16 kTalkedtoattendant = 47;
	static const uint16 kTalkedtosparky = 48;
	static const uint16 kTalkedtoboss = 49;
	static const uint16 kTalkedtorecep = 50;
	static const uint16 kCardpassflag = 51;
	static const uint16 kMadmanflag = 52;
	static const uint16 kKeeperflag = 53;
	static const uint16 kLasttrigger = 54;
	static const uint16 kMandead = 55;
	static const uint16 kSeed = 56;
	static const uint16 kNeedtotravel = 59;
	static const uint16 kThroughdoor = 60;
	static const uint16 kNewobs = 61;
	static const uint16 kRyanon = 62;
	static const uint16 kCombatcount = 63;
	static const uint16 kLastweapon = 64;
	static const uint16 kDreamnumber = 65;
	static const uint16 kRoomafterdream = 66;
	static const uint16 kShakecounter = 67;
	static const uint16 kSpeechcount = 68;
	static const uint16 kCharshift = 69;
	static const uint16 kKerning = 71;
	static const uint16 kBrightness = 72;
	static const uint16 kRoomloaded = 73;
	static const uint16 kDidzoom = 74;
	static const uint16 kLinespacing = 75;
	static const uint16 kTextaddressx = 77;
	static const uint16 kTextaddressy = 79;
	static const uint16 kTextlen = 81;
	static const uint16 kLastxpos = 82;
	static const uint16 kIcontop = 84;
	static const uint16 kIconleft = 86;
	static const uint16 kItemframe = 88;
	static const uint16 kItemtotran = 89;
	static const uint16 kRoomad = 90;
	static const uint16 kOldsubject = 92;
	static const uint16 kWithobject = 94;
	static const uint16 kWithtype = 95;
	static const uint16 kLookcounter = 96;
	static const uint16 kCommand = 98;
	static const uint16 kCommandtype = 99;
	static const uint16 kOldcommandtype = 100;
	static const uint16 kObjecttype = 101;
	static const uint16 kGetback = 102;
	static const uint16 kInvopen = 103;
	static const uint16 kMainmode = 104;
	static const uint16 kPickup = 105;
	static const uint16 kLastinvpos = 106;
	static const uint16 kExamagain = 107;
	static const uint16 kNewtextline = 108;
	static const uint16 kOpenedob = 109;
	static const uint16 kOpenedtype = 110;
	static const uint16 kOldmapadx = 111;
	static const uint16 kOldmapady = 113;
	static const uint16 kMapadx = 115;
	static const uint16 kMapady = 117;
	static const uint16 kMapoffsetx = 119;
	static const uint16 kMapoffsety = 121;
	static const uint16 kMapxstart = 123;
	static const uint16 kMapystart = 125;
	static const uint16 kMapxsize = 127;
	static const uint16 kMapysize = 128;
	static const uint16 kHavedoneobs = 129;
	static const uint16 kManisoffscreen = 130;
	static const uint16 kRainspace = 131;
	static const uint16 kFacing = 132;
	static const uint16 kLeavedirection = 133;
	static const uint16 kTurntoface = 134;
	static const uint16 kTurndirection = 135;
	static const uint16 kMaintimer = 136;
	static const uint16 kIntrocount = 138;
	static const uint16 kArrowad = 139;
	static const uint16 kCurrentkey = 141;
	static const uint16 kOldkey = 142;
	static const uint16 kUseddirection = 143;
	static const uint16 kCurrentkey2 = 144;
	static const uint16 kTimercount = 145;
	static const uint16 kOldtimercount = 146;
	static const uint16 kMapx = 147;
	static const uint16 kMapy = 148;
	static const uint16 kNewscreen = 149;
	static const uint16 kRyanx = 150;
	static const uint16 kRyany = 151;
	static const uint16 kLastflag = 152;
	static const uint16 kLastflagex = 153;
	static const uint16 kFlagx = 154;
	static const uint16 kFlagy = 155;
	static const uint16 kCurrentex = 156;
	static const uint16 kCurrentfree = 157;
	static const uint16 kCurrentframe = 158;
	static const uint16 kFramesad = 160;
	static const uint16 kDataad = 162;
	static const uint16 kFrsegment = 164;
	static const uint16 kObjectx = 166;
	static const uint16 kObjecty = 168;
	static const uint16 kOffsetx = 170;
	static const uint16 kOffsety = 172;
	static const uint16 kSavesize = 174;
	static const uint16 kSavesource = 176;
	static const uint16 kSavex = 178;
	static const uint16 kSavey = 179;
	static const uint16 kCurrentob = 180;
	static const uint16 kPrioritydep = 181;
	static const uint16 kDestpos = 182;
	static const uint16 kReallocation = 183;
	static const uint16 kRoomnum = 184;
	static const uint16 kNowinnewroom = 185;
	static const uint16 kResetmanxy = 186;
	static const uint16 kNewlocation = 187;
	static const uint16 kAutolocation = 188;
	static const uint16 kMustload = 189;
	static const uint16 kAnswered = 190;
	static const uint16 kSaidno = 191;
	static const uint16 kDoorcheck1 = 192;
	static const uint16 kDoorcheck2 = 193;
	static const uint16 kDoorcheck3 = 194;
	static const uint16 kDoorcheck4 = 195;
	static const uint16 kMousex = 196;
	static const uint16 kMousey = 198;
	static const uint16 kMousebutton = 200;
	static const uint16 kMousebutton1 = 202;
	static const uint16 kMousebutton2 = 204;
	static const uint16 kMousebutton3 = 206;
	static const uint16 kMousebutton4 = 208;
	static const uint16 kOldbutton = 210;
	static const uint16 kOldx = 212;
	static const uint16 kOldy = 214;
	static const uint16 kLastbutton = 216;
	static const uint16 kOldpointerx = 218;
	static const uint16 kOldpointery = 220;
	static const uint16 kDelherex = 222;
	static const uint16 kDelherey = 224;
	static const uint16 kPointerxs = 226;
	static const uint16 kPointerys = 227;
	static const uint16 kDelxs = 228;
	static const uint16 kDelys = 229;
	static const uint16 kPointerframe = 230;
	static const uint16 kPointerpower = 231;
	static const uint16 kAuxpointerframe = 232;
	static const uint16 kPointermode = 233;
	static const uint16 kPointerspeed = 234;
	static const uint16 kPointercount = 235;
	static const uint16 kInmaparea = 236;
	static const uint16 kReelpointer = 237;
	static const uint16 kSlotdata = 239;
	static const uint16 kThisslot = 240;
	static const uint16 kSlotflags = 241;
	static const uint16 kTakeoff = 242;
	static const uint16 kTalkmode = 244;
	static const uint16 kTalkpos = 245;
	static const uint16 kCharacter = 246;
	static const uint16 kPersondata = 247;
	static const uint16 kTalknum = 249;
	static const uint16 kNumberinroom = 250;
	static const uint16 kCurrentcel = 251;
	static const uint16 kOldselection = 252;
	static const uint16 kStopwalking = 253;
	static const uint16 kMouseon = 254;
	static const uint16 kPlayed = 255;
	static const uint16 kTimer1 = 257;
	static const uint16 kTimer2 = 258;
	static const uint16 kTimer3 = 259;
	static const uint16 kWholetimer = 260;
	static const uint16 kTimer1to = 262;
	static const uint16 kTimer2to = 263;
	static const uint16 kTimer3to = 264;
	static const uint16 kWatchdump = 265;
	static const uint16 kCurrentset = 266;
	static const uint16 kLogonum = 268;
	static const uint16 kOldlogonum = 269;
	static const uint16 kNewlogonum = 270;
	static const uint16 kNetseg = 271;
	static const uint16 kNetpoint = 273;
	static const uint16 kKeynum = 275;
	static const uint16 kCursorstate = 276;
	static const uint16 kPressed = 277;
	static const uint16 kPresspointer = 278;
	static const uint16 kGraphicpress = 280;
	static const uint16 kPresscount = 281;
	static const uint16 kKeypadax = 282;
	static const uint16 kKeypadcx = 284;
	static const uint16 kLightcount = 286;
	static const uint16 kFolderpage = 287;
	static const uint16 kDiarypage = 288;
	static const uint16 kMenucount = 289;
	static const uint16 kSymboltopx = 290;
	static const uint16 kSymboltopnum = 291;
	static const uint16 kSymboltopdir = 292;
	static const uint16 kSymbolbotx = 293;
	static const uint16 kSymbolbotnum = 294;
	static const uint16 kSymbolbotdir = 295;
	static const uint16 kSymboltolight = 296;
	static const uint16 kSymbol1 = 297;
	static const uint16 kSymbol2 = 298;
	static const uint16 kSymbol3 = 299;
	static const uint16 kSymbolnum = 300;
	static const uint16 kDumpx = 301;
	static const uint16 kDumpy = 303;
	static const uint16 kWalkandexam = 305;
	static const uint16 kWalkexamtype = 306;
	static const uint16 kWalkexamnum = 307;
	static const uint16 kCursloc = 308;
	static const uint16 kCurslocx = 310;
	static const uint16 kCurslocy = 312;
	static const uint16 kCurpos = 314;
	static const uint16 kMonadx = 316;
	static const uint16 kMonady = 318;
	static const uint16 kGotfrom = 320;
	static const uint16 kMonsource = 322;
	static const uint16 kNumtodo = 324;
	static const uint16 kTimecount = 326;
	static const uint16 kCounttotimed = 328;
	static const uint16 kTimedseg = 330;
	static const uint16 kTimedoffset = 332;
	static const uint16 kTimedy = 334;
	static const uint16 kTimedx = 335;
	static const uint16 kNeedtodumptimed = 336;
	static const uint16 kHandle = 337;
	static const uint16 kLoadingorsave = 339;
	static const uint16 kCurrentslot = 340;
	static const uint16 kCursorpos = 341;
	static const uint16 kColourpos = 342;
	static const uint16 kFadedirection = 343;
	static const uint16 kNumtofade = 344;
	static const uint16 kFadecount = 345;
	static const uint16 kAddtogreen = 346;
	static const uint16 kAddtored = 347;
	static const uint16 kAddtoblue = 348;
	static const uint16 kLastsoundreel = 349;
	static const uint16 kSoundbuffer = 351;
	static const uint16 kSoundbufferad = 353;
	static const uint16 kSoundbufferpage = 355;
	static const uint16 kSoundtimes = 356;
	static const uint16 kNeedsoundbuff = 357;
	static const uint16 kOldint9seg = 358;
	static const uint16 kOldint9add = 360;
	static const uint16 kOldint8seg = 362;
	static const uint16 kOldint8add = 364;
	static const uint16 kOldsoundintseg = 366;
	static const uint16 kOldsoundintadd = 368;
	static const uint16 kSoundbaseadd = 370;
	static const uint16 kDsp_status = 372;
	static const uint16 kDsp_write = 374;
	static const uint16 kDmaaddress = 376;
	static const uint16 kSoundint = 377;
	static const uint16 kSounddmachannel = 378;
	static const uint16 kSampleplaying = 379;
	static const uint16 kTestresult = 380;
	static const uint16 kCurrentirq = 381;
	static const uint16 kSpeechloaded = 382;
	static const uint16 kSpeechlength = 383;
	static const uint16 kVolume = 385;
	static const uint16 kVolumeto = 386;
	static const uint16 kVolumedirection = 387;
	static const uint16 kVolumecount = 388;
	static const uint16 kPlayblock = 389;
	static const uint16 kWongame = 390;
	static const uint16 kLasthardkey = 391;
	static const uint16 kBufferin = 392;
	static const uint16 kBufferout = 394;
	static const uint16 kExtras = 396;
	static const uint16 kWorkspace = 398;
	static const uint16 kMapstore = 400;
	static const uint16 kCharset1 = 402;
	static const uint16 kTempcharset = 404;
	static const uint16 kIcons1 = 406;
	static const uint16 kIcons2 = 408;
	static const uint16 kBuffers = 410;
	static const uint16 kMainsprites = 412;
	static const uint16 kBackdrop = 414;
	static const uint16 kMapdata = 416;
	static const uint16 kSounddata = 418;
	static const uint16 kSounddata2 = 420;
	static const uint16 kRecordspace = 422;
	static const uint16 kFreedat = 424;
	static const uint16 kSetdat = 426;
	static const uint16 kReel1 = 428;
	static const uint16 kReel2 = 430;
	static const uint16 kReel3 = 432;
	static const uint16 kRoomdesc = 434;
	static const uint16 kFreedesc = 436;
	static const uint16 kSetdesc = 438;
	static const uint16 kBlockdesc = 440;
	static const uint16 kSetframes = 442;
	static const uint16 kFreeframes = 444;
	static const uint16 kPeople = 446;
	static const uint16 kReels = 448;
	static const uint16 kCommandtext = 450;
	static const uint16 kPuzzletext = 452;
	static const uint16 kTraveltext = 454;
	static const uint16 kTempgraphics = 456;
	static const uint16 kTempgraphics2 = 458;
	static const uint16 kTempgraphics3 = 460;
	static const uint16 kTempsprites = 462;
	static const uint16 kTextfile1 = 464;
	static const uint16 kTextfile2 = 466;
	static const uint16 kTextfile3 = 468;
	static const uint16 kBlinkframe = 470;
	static const uint16 kBlinkcount = 471;
	static const uint16 kReasseschanges = 472;
	static const uint16 kPointerspath = 473;
	static const uint16 kManspath = 474;
	static const uint16 kPointerfirstpath = 475;
	static const uint16 kFinaldest = 476;
	static const uint16 kDestination = 477;
	static const uint16 kLinestartx = 478;
	static const uint16 kLinestarty = 480;
	static const uint16 kLineendx = 482;
	static const uint16 kLineendy = 484;
	static const uint16 kIncrement1 = 486;
	static const uint16 kIncrement2 = 488;
	static const uint16 kLineroutine = 490;
	static const uint16 kLinepointer = 491;
	static const uint16 kLinedirection = 492;
	static const uint16 kLinelength = 493;
	static const uint16 kLiftsoundcount = 494;
	static const uint16 kEmmhandle = 495;
	static const uint16 kEmmpageframe = 497;
	static const uint16 kEmmhardwarepage = 499;
	static const uint16 kCh0emmpage = 500;
	static const uint16 kCh0offset = 502;
	static const uint16 kCh0blockstocopy = 504;
	static const uint16 kCh0playing = 506;
	static const uint16 kCh0repeat = 507;
	static const uint16 kCh0oldemmpage = 508;
	static const uint16 kCh0oldoffset = 510;
	static const uint16 kCh0oldblockstocopy = 512;
	static const uint16 kCh1playing = 514;
	static const uint16 kCh1emmpage = 515;
	static const uint16 kCh1offset = 517;
	static const uint16 kCh1blockstocopy = 519;
	static const uint16 kCh1blocksplayed = 521;
	static const uint16 kSoundbufferwrite = 523;
	static const uint16 kSoundemmpage = 525;
	static const uint16 kSpeechemmpage = 527;
	static const uint16 kCurrentsample = 529;
	static const uint16 kRoomssample = 530;
	static const uint16 kGameerror = 531;
	static const uint16 kHowmuchalloc = 532;
	static const uint16 kReelroutines = 534;
	static const uint16 kReelcalls = 991;
	static const uint16 kRoombyroom = 1214;
	static const uint16 kR0 = 1326;
	static const uint16 kR1 = 1327;
	static const uint16 kR2 = 1331;
	static const uint16 kR6 = 1350;
	static const uint16 kR8 = 1357;
	static const uint16 kR9 = 1373;
	static const uint16 kR10 = 1380;
	static const uint16 kR11 = 1384;
	static const uint16 kR12 = 1388;
	static const uint16 kR13 = 1392;
	static const uint16 kR14 = 1405;
	static const uint16 kR20 = 1439;
	static const uint16 kR22 = 1461;
	static const uint16 kR23 = 1492;
	static const uint16 kR25 = 1505;
	static const uint16 kR26 = 1527;
	static const uint16 kR27 = 1549;
	static const uint16 kR28 = 1574;
	static const uint16 kR29 = 1593;
	static const uint16 kR45 = 1609;
	static const uint16 kR46 = 1616;
	static const uint16 kR47 = 1653;
	static const uint16 kR52 = 1666;
	static const uint16 kR53 = 1670;
	static const uint16 kR55 = 1677;
	static const uint16 kSpritename1 = 1819;
	static const uint16 kSpritename3 = 1832;
	static const uint16 kIdname = 1845;
	static const uint16 kCharacterset1 = 1857;
	static const uint16 kCharacterset2 = 1870;
	static const uint16 kCharacterset3 = 1883;
	static const uint16 kSamplename = 1896;
	static const uint16 kBasicsample = 1909;
	static const uint16 kIcongraphics0 = 1922;
	static const uint16 kIcongraphics1 = 1935;
	static const uint16 kExtragraphics1 = 1948;
	static const uint16 kIcongraphics8 = 1961;
	static const uint16 kMongraphicname = 1974;
	static const uint16 kMongraphics2 = 1987;
	static const uint16 kCityname = 2000;
	static const uint16 kTravelgraphic1 = 2013;
	static const uint16 kTravelgraphic2 = 2026;
	static const uint16 kDiarygraphic = 2039;
	static const uint16 kMonitorfile1 = 2052;
	static const uint16 kMonitorfile2 = 2065;
	static const uint16 kMonitorfile10 = 2078;
	static const uint16 kMonitorfile11 = 2091;
	static const uint16 kMonitorfile12 = 2104;
	static const uint16 kMonitorfile13 = 2117;
	static const uint16 kMonitorfile20 = 2130;
	static const uint16 kMonitorfile21 = 2143;
	static const uint16 kMonitorfile22 = 2156;
	static const uint16 kMonitorfile23 = 2169;
	static const uint16 kMonitorfile24 = 2182;
	static const uint16 kFoldertext = 2195;
	static const uint16 kDiarytext = 2208;
	static const uint16 kPuzzletextname = 2221;
	static const uint16 kTraveltextname = 2234;
	static const uint16 kIntrotextname = 2247;
	static const uint16 kEndtextname = 2260;
	static const uint16 kCommandtextname = 2273;
	static const uint16 kVolumetabname = 2286;
	static const uint16 kFoldergraphic1 = 2299;
	static const uint16 kFoldergraphic2 = 2312;
	static const uint16 kFoldergraphic3 = 2325;
	static const uint16 kSymbolgraphic = 2338;
	static const uint16 kGungraphic = 2351;
	static const uint16 kMonkface = 2364;
	static const uint16 kTitle0graphics = 2377;
	static const uint16 kTitle1graphics = 2390;
	static const uint16 kTitle2graphics = 2403;
	static const uint16 kTitle3graphics = 2416;
	static const uint16 kTitle4graphics = 2429;
	static const uint16 kTitle5graphics = 2442;
	static const uint16 kTitle6graphics = 2455;
	static const uint16 kTitle7graphics = 2468;
	static const uint16 kPalettescreen = 2481;
	static const uint16 kCurrentfile = 2970;
	static const uint16 kDmaaddresses = 5118;
	static const uint16 kFileheader = 6091;
	static const uint16 kFiledata = 6141;
	static const uint16 kExtradata = 6181;
	static const uint16 kRoomdata = 6187;
	static const uint16 kMadeuproomdat = 7979;
	static const uint16 kRoomscango = 8011;
	static const uint16 kRoompics = 8027;
	static const uint16 kOplist = 8042;
	static const uint16 kInputline = 8045;
	static const uint16 kLinedata = 8173;
	static const uint16 kPresslist = 8573;
	static const uint16 kSavenames = 8579;
	static const uint16 kSavefiles = 8698;
	static const uint16 kRecname = 8789;
	static const uint16 kQuitrequested = 8802;
	static const uint16 kSubtitles = 8803;
	static const uint16 kForeignrelease = 8804;
	static const uint16 kStak = 8805;
	static const uint16 kBlocktextdat = (0);
	static const uint16 kPersonframes = (0);
	static const uint16 kDebuglevel1 = (0);
	static const uint16 kDebuglevel2 = (0);
	static const uint16 kPlayback = (0);
	static const uint16 kMap = (0);
	static const uint16 kSettextdat = (0);
	static const uint16 kSpanish = (0);
	static const uint16 kFramedata = (0);
	static const uint16 kRecording = (0);
	static const uint16 kFlags = (0);
	static const uint16 kGerman = (0);
	static const uint16 kTextunder = (0);
	static const uint16 kPathdata = (0);
	static const uint16 kDemo = (0);
	static const uint16 kExframedata = (0);
	static const uint16 kIntextdat = (0);
	static const uint16 kFreetextdat = (0);
	static const uint16 kFrframedata = (0);
	static const uint16 kSettext = (0+(130*2));
	static const uint16 kOpeninvlist = (0+(228*13));
	static const uint16 kRyaninvlist = (0+(228*13)+32);
	static const uint16 kPointerback = (0+(228*13)+32+60);
	static const uint16 kMapflags = (0+(228*13)+32+60+(32*32));
	static const uint16 kStartpal = (0+(228*13)+32+60+(32*32)+(11*10*3));
	static const uint16 kEndpal = (0+(228*13)+32+60+(32*32)+(11*10*3)+768);
	static const uint16 kMaingamepal = (0+(228*13)+32+60+(32*32)+(11*10*3)+768+768);
	static const uint16 kSpritetable = (0+(228*13)+32+60+(32*32)+(11*10*3)+768+768+768);
	static const uint16 kSetlist = (0+(228*13)+32+60+(32*32)+(11*10*3)+768+768+768+(32*32));
	static const uint16 kFreelist = (0+(228*13)+32+60+(32*32)+(11*10*3)+768+768+768+(32*32)+(128*5));
	static const uint16 kExlist = (0+(228*13)+32+60+(32*32)+(11*10*3)+768+768+768+(32*32)+(128*5)+(80*5));
	static const uint16 kPeoplelist = (0+(228*13)+32+60+(32*32)+(11*10*3)+768+768+768+(32*32)+(128*5)+(80*5)+(100*5));
	static const uint16 kZoomspace = (0+(228*13)+32+60+(32*32)+(11*10*3)+768+768+768+(32*32)+(128*5)+(80*5)+(100*5)+(12*5));
	static const uint16 kPrintedlist = (0+(228*13)+32+60+(32*32)+(11*10*3)+768+768+768+(32*32)+(128*5)+(80*5)+(100*5)+(12*5)+(46*40));
	static const uint16 kListofchanges = (0+(228*13)+32+60+(32*32)+(11*10*3)+768+768+768+(32*32)+(128*5)+(80*5)+(100*5)+(12*5)+(46*40)+(5*80));
	static const uint16 kUndertimedtext = (0+(228*13)+32+60+(32*32)+(11*10*3)+768+768+768+(32*32)+(128*5)+(80*5)+(100*5)+(12*5)+(46*40)+(5*80)+(250*4));
	static const uint16 kRainlist = (0+(228*13)+32+60+(32*32)+(11*10*3)+768+768+768+(32*32)+(128*5)+(80*5)+(100*5)+(12*5)+(46*40)+(5*80)+(250*4)+(256*30));
	static const uint16 kInitialreelrouts = (0+(228*13)+32+60+(32*32)+(11*10*3)+768+768+768+(32*32)+(128*5)+(80*5)+(100*5)+(12*5)+(46*40)+(5*80)+(250*4)+(256*30)+(6*64));
	static const uint16 kInitialvars = (0+(228*13)+32+60+(32*32)+(11*10*3)+768+768+768+(32*32)+(128*5)+(80*5)+(100*5)+(12*5)+(46*40)+(5*80)+(250*4)+(256*30)+(6*64)+991-534);
	static const uint16 kLengthofbuffer = (0+(228*13)+32+60+(32*32)+(11*10*3)+768+768+768+(32*32)+(128*5)+(80*5)+(100*5)+(12*5)+(46*40)+(5*80)+(250*4)+(256*30)+(6*64)+991-534+68-0);
	static const uint16 kReellist = (0+(36*144));
	static const uint16 kIntext = (0+(38*2));
	static const uint16 kLengthofmap = (0+(66*60));
	static const uint16 kFreetext = (0+(82*2));
	static const uint16 kBlocktext = (0+(98*2));
	static const uint16 kBlocks = (0+192);
	static const uint16 kFrframes = (0+2080);
	static const uint16 kExframes = (0+2080);
	static const uint16 kFrames = (0+2080);
	static const uint16 kExdata = (0+2080+30000);
	static const uint16 kExtextdat = (0+2080+30000+(16*114));
	static const uint16 kExtext = (0+2080+30000+(16*114)+((114+2)*2));
	static const uint16 kLengthofextra = (0+2080+30000+(16*114)+((114+2)*2)+18000);
	static const uint16 kPersontxtdat = (0+24);
	static const uint16 kPersontext = (0+24+(1026*2));
	static const uint16 kInputport = (0x63);
	static const uint16 kForeign = (1);
	static const uint16 kCd = (1);
	static const uint16 kNumexobjects = (114);
	static const uint16 kUndertextsizey = (13);
	static const uint16 kZoomy = (132);
	static const uint16 kFreedatlen = (16*80);
	static const uint16 kExtextlen = (18000);
	static const uint16 kLenofmapstore = (22*8*20*8);
	static const uint16 kUndertextsizex = (228);
	static const uint16 kNumchanges = (250);
	static const uint16 kUndertimedysize = (30);
	static const uint16 kExframeslen = (30000);
	static const uint16 kTablesize = (32);
	static const uint16 kScreenwidth = (320);
	static const uint16 kKeypadx = (36+112);
	static const uint16 kItempicsize = (44);
	static const uint16 kDiaryy = (48+12);
	static const uint16 kOpsy = (52);
	static const uint16 kSymboly = (56);
	static const uint16 kInventy = (58);
	static const uint16 kMenuy = (60);
	static const uint16 kOpsx = (60);
	static const uint16 kMaplength = (60);
	static const uint16 kHeaderlen = (6187-6091);
	static const uint16 kSymbolx = (64);
	static const uint16 kSetdatlen = (64*128);
	static const uint16 kMapwidth = (66);
	static const uint16 kTextstart = (66*2);
	static const uint16 kMaplen = (66*60);
	static const uint16 kDiaryx = (68+24);
	static const uint16 kLengthofvars = (68-0);
	static const uint16 kKeypady = (72);
	static const uint16 kZoomx = (8);
	static const uint16 kInventx = (80);
	static const uint16 kMenux = (80+40);
	static const uint16 kLenofreelrouts = (991-534);

	void bothchannels();
	void usewire();
	void getnamepos();
	void loadtemptext();
	void clearstartpal();
	void femalefan();
	//void showgamereel();
	void identifyob();
	void trysoundalloc();
	void uselighter();
	void showmenu();
	void usepoolreader();
	void startdmablock();
	void useopenbox();
	void clearbuffers();
	//void getyad();
	void neterror();
	void storeit();
	//void lockeddoorway();
	//void isitworn();
	//void putundertimed();
	//void dumpmap();
	//void multidump();
	void channel0only();
	void worktoscreenm();
	//void obicons();
	void removeemm();
	//void frameoutbh();
	void getobtextstart();
	void loadfolder();
	void decide();
	//void dumppointer();
	void reelsonscreen();
	void getridofreels();
	void readkey();
	void louis();
	void entrytexts();
	//void getreelstart();
	void buttonenter();
	void checkinput();
	//void crosshair();
	void setmode();
	void getbackfromops();
	//void frameoutv();
	void showbyte();
	void screenupdate();
	//void addlength();
	//void usetimedtext();
	void putundercentre();
	void checkobjectsize();
	//void commandonly();
	void titles();
	void deallocatemem();
	void mainscreen();
	void watchreel();
	void showfolder();
	//void turnanypathoff();
	void openfilefromc();
	void gettime();
	//void clearwork();
	void loadtraveltext();
	//void worktoscreen();
	//void getexpos();
	void fadedos();
	//void fillspace();
	void selectlocation();
	//void multiget();
	//void autosetwalk();
	void fadeupmonfirst();
	void drawfloor();
	void loadkeypad();
	//void findsource();
	void clearendpal();
	void findtext1();
	void isryanholding();
	void showslots();
	void usecashcard();
	void usewall();
	void opentomb();
	//void makename();
	void buttonfour();
	void restoreall();
	//void lockmon();
	//void dochange();
	void getanyaddir();
	//void dumpblink();
	void showsaveops();
	void intromonks1();
	void resetlocation();
	void oldtonames();
	void showdiscops();
	void advisor();
	void additionaltext();
	//void compare();
	void othersmoker();
	void dofade();
	//void setuptimedtemp();
	//void blocknametext();
	void useelevator5();
	void useelevator4();
	void useelevator1();
	//void findormake();
	void useelevator3();
	void useelevator2();
	void buttonone();
	void keyboardread();
	//void deltextline();
	void entercode();
	void getopenedsize();
	void getpersframe();
	void doshake();
	void resetkeyboard();
	//void showpanel();
	void soundstartup();
	void slabdoora();
	void fadeupyellows();
	void slabdoorc();
	void slabdoorb();
	void slabdoore();
	void slabdoord();
	void adjustup();
	void slabdoorf();
	void loadintotemp();
	void loadintroroom();
	void saveseg();
	//void showblink();
	void mousecall();
	void train();
	void watchcount();
	void fadedownmon();
	void loadcart();
	//void calcfrframe();
	void bartender();
	void eden();
	void showdiary();
	void purgealocation();
	//void updatepeople();
	//void addtopeoplelist();
	void hangoncurs();
	//void getblockofpixel();
	//void kernchars();
	void printcurs();
	//void convertkey();
	void outofopen();
	//void dealwithspecial();
	//void eraseoldobs();
	void dircom();
	//void liftsprite();
	void dumpkeypad();
	void showsymbol();
	void endgameseq();
	//void cancelch0();
	void setbotleft();
	void findfirstpath();
	//void cancelch1();
	void loadold();
	void loadtempcharset();
	void useslab();
	void dumpzoom();
	//void aboutturn();
	void usealtar();
	void createpanel2();
	void turnonpower();
	void manasleep2();
	void moretalk();
	//void printslow();
	void loadroom();
	void starttalk();
	void delchar();
	void getanyad();
	void endgame();
	void monprint();
	void usepipe();
	//void startloading();
	void getunderzoom();
	void candles();
	void backobject();
	void rollendcredits2();
	void reminders();
	void selectslot2();
	void runtap();
	//void domix();
	//void paneltomap();
	//void obname();
	void getridoftemp3();
	void getridoftemp2();
	void usebalcony();
	void runendseq();
	void dumpdiarykeys();
	void disablesoundint();
	void priesttext();
	//void showallex();
	void openpoolboss();
	void buttontwo();
	//void delsprite();
	//void getroomspaths();
	//void dumptextline();
	void fadescreendownhalf();
	void useplate();
	void candles1();
	void lookininterface();
	void manasleep();
	//void isitdescribed();
	void hotelbell();
	void loadspeech();
	void interupttest();
	//void cls();
	//void printsprites();
	//void checkifperson();
	//void showallobs();
	//void getnumber();
	void adjustleft();
	void calledenslift();
	void useclearbox();
	void entryanims();
	void nextfolder();
	void getfreead();
	void showarrows();
	void walkintoroom();
	void usehatch();
	void printoutermon();
	void setuppit();
	void showpcx();
	void showdecisions();
	void checkspeed();
	//void printchar();
	void showkeypad();
	//void obtoinv();
	//void getroomdata();
	void removeobfrominv();
	void usecoveredbox();
	void openyourneighbour();
	void fadescreenuphalf();
	void getridoftempcharset();
	void heavy();
	void endpaltostart();
	void showkeys();
	void usekey();
	void locklighton();
	void useladderb();
	//void spriteupdate();
	void usetempcharset();
	void discops();
	//void printdirect();
	//void delthisone();
	//void makebackob();
	void middlepanel();
	void dumpwatch();
	void saveload();
	void monitorlogo();
	void loadposition();
	//void wornerror();
	void entersymbol();
	void showword();
	void dirfile();
	//void bresenhams();
	//void walktotext();
	void pickupconts();
	void locklightoff();
	void wearwatch();
	void runintroseq();
	//void doblocks();
	void opensarters();
	//void delpointer();
	void attendant();
	void nextsymbol();
	void monks2text();
	void clearpalette();
	void cantdrop();
	//void maptopanel();
	//void calcmapad();
	void getridofall();
	void copper();
	void folderhints();
	void openhoteldoor();
	//void removesetobject();
	//void dumptimedtext();
	//void frameoutfx();
	void blank();
	void drinker();
	void nextcolon();
	void placefreeobject();
	void allpalette();
	//void loopchannel0();
	void initrain();
	void showleftpage();
	void rockstar();
	void adjustright();
	void putunderzoom();
	void vsync();
	//void finishedwalking();
	void findinvpos();
	void dumpmenu();
	//void examineobtext();
	void liftnoise();
	void workoutframes();
	void getbackfromob();
	void dumpsymbox();
	void loadgame();
	void getridoftemp();
	void showcity();
	void dumpsymbol();
	void disablepath();
	void buttonsix();
	void intro2text();
	void showouterpad();
	void getkeyandlogo();
	void selectob();
	//void checkcoords();
	//void usetext();
	void chewy();
	void accesslighton();
	void useplinth();
	//void adjustlen();
	//void quickquit();
	//void showpointer();
	void usecooker();
	void loadmenu();
	void checkforemm();
	//void checkifpathison();
	//void finalframe();
	void receptionist();
	void selectslot();
	void openfilenocheck();
	//void readoneblock();
	void fadeupmon();
	void paltoendpal();
	void fadetowhite();
	void loadsavebox();
	void soundend();
	void redes();
	void errormessage1();
	void clearchanges();
	void errormessage3();
	//void deletetaken();
	void putundermenu();
	void intromonks2();
	void intromagic2();
	void intromagic3();
	void edeninbath();
	void intromagic1();
	void showdiarypage();
	void useshield();
	void getbacktoops();
	void rollendcredits();
	void intro1text();
	void transfertoex();
	void playchannel1();
	void playchannel0();
	void usemon();
	void steady();
	//void pixelcheckset();
	void reexfrominv();
	void examinventory();
	void talk();
	void usedryer();
	//void dumpeverything();
	//void readmouse2();
	//void zoom();
	void outofinv();
	void viewfolder();
	//void walking();
	void diarykeyp();
	//void readabyte();
	//void showframe();
	void random();
	void mainman();
	void mansatstill();
	void channel1only();
	void checkbasemem();
	void lastfolder();
	void transfermap();
	//void showreelframe();
	void showmonk();
	void diarykeyn();
	void set16colpalette();
	void convicons();
	void interviewer();
	void sparky();
	void purgeanitem();
	void madman();
	void createpanel();
	//void turnpathon();
	void enablesoundint();
	void madmanstelly();
	void constant();
	void loadroomssample();
	void sparkydrip();
	void paltostartpal();
	void bossman();
	void getridofpit();
	void convnum();
	//void checkifset();
	void nothelderror();
	//void readheader();
	void getsetad();
	void textformonk();
	void reconstruct();
	void soldier1();
	//void animpointer();
	void getundercentre();
	void checkforexit();
	void loadseg();
	void makeheader();
	void setkeyboardint();
	void priest();
	//void readmouse();
	void powerlighton();
	void savefilewrite();
	void printmessage2();
	//void showallfree();
	void loadnews();
	void rollem();
	//void makeworn();
	void hangonpq();
	void startup();
	void savegame();
	void startpaltoend();
	void showicon();
	void findopenpos();
	void describeob();
	void deleteexframe();
	void folderexit();
	void dosreturn();
	void wheelsound();
	void actualsave();
	void autolook();
	void playguitar();
	void transfertext();
	void searchforsame();
	void showmainops();
	void getback1();
	void setlocation();
	void fadefromwhite();
	void checksoundint();
	void usewindow();
	void wearshades();
	void onedigit();
	void pitinterupt();
	void deleverything();
	void fadescreendown();
	//void findxyfrompath();
	void namestoold();
	//void getxad();
	void openinv();
	void lookatplace();
	void useaxe();
	void examineob();
	void buttonnought();
	void useelvdoor();
	void putbackobstuff();
	void useladder();
	void realcredits();
	void handclap();
	void smokebloke();
	void afterintroroom();
	//void printundermon();
	void buttonnine();
	void findallopen();
	void loadintotemp3();
	void loadintotemp2();
	void gamer();
	void poolguard();
	void readfromfile();
	void initialinv();
	void quitsymbol();
	//void modifychar();
	//void initman();
	void settopright();
	void findsetobject();
	void singlekey();
	//void seecommandtail();
	//void getundertimed();
	void hangone();
	void carparkdrip();
	void usediary();
	void deleteexobject();
	//void frameoutnm();
	void moneypoke();
	void destselect();
	void restoreems();
	void lastdest();
	void removefreeobject();
	void trapdoor();
	void openlouis();
	void buttonthree();
	void getundermenu();
	//void randomnumber();
	void lookatcard();
	void helicopter();
	void scrollmonitor();
	void setsoundoff();
	void setpickup();
	//void doorway();
	void dropobject();
	void isitright();
	void reexfromopen();
	//void fillryan();
	void drawitall();
	void usestereo();
	void showcurrentfile();
	//void turnpathoff();
	//void copyname();
	void look();
	void setmouse();
	//void checkone();
	//void transferinv();
	void candles2();
	void pickupob();
	void error();
	void showopbox();
	void clearbeforeload();
	void biblequote();
	void doload();
	void showexit();
	void blockget();
	void usetrainer();
	//void allocatework();
	void addtopresslist();
	//void walkandexamine();
	void dmaend();
	//void quickquit2();
	void twodigitnum();
	//void madmantext();
	void dumpcurrent();
	void textforend();
	void showdiarykeys();
	void dontloadseg();
	//void madmode();
	void intro3text();
	void allocatemem();
	void sortoutmap();
	//void showrain();
	void useopened();
	void inventory();
	void powerlightoff();
	void fillopen();
	void showoutermenu();
	void signon();
	void deleteextext();
	void foghornsound();
	void showrightpage();
	void showloadops();
	void examicon();
	void showgun();
	void switchryanon();
	//void personnametext();
	void louischair();
	void saveems();
	void locationpic();
	//void getflagunderp();
	void dolook();
	void opentvdoor();
	void triggermessage();
	void smallcandle();
	//void plotreel();
	void swapwithopen();
	//void makesprite();
	void dreamweb();
	void droperror();
	void edenscdplayer();
	void calledensdlift();
	void checkinside();
	void gates();
	void newgame();
	void showwatch();
	//void turnanypathon();
	void restorereels();
	void setwalk();
	//void useroutine();
	void zoomicon();
	//void findlen();
	void findpathofpoint();
	void issetobonmap();
	void getdestinfo();
	void drunk();
	void getridoftemptext();
	void setuptimeduse();
	void grafittidoor();
	void input();
	void nextdest();
	//void getdimension();
	void makecaps();
	void read();
	void fadescreenups();
	//void checkdest();
	//void hangon();
	void loadpalfromiff();
	//void facerightway();
	void startup1();
	void hotelcontrol();
	void mugger();
	void atmospheres();
	void out22c();
	void loadpersonal();
	void gettingshot();
	void settopleft();
	void searchforstring();
	//void clearsprites();
	//void obpicture();
	void selectopenob();
	//void widedoor();
	void security();
	//void printasprite();
	void buttonfive();
	void soundonreels();
	void usegun();
	void autoappear();
	//void findnextcolon();
	//void readmouse4();
	void openryan();
	void callhotellift();
	void showman();
	void usefullcart();
	void newplace();
	//void movemap();
	void loadsample();
	void usecardreader1();
	void usecardreader2();
	void usecardreader3();
	void tattooman();
	void usehandle();
	void openfile();
	void usecharset1();
	//void makenextblock();
	void showpuztext();
	//void addalong();
	//void width160();
	void incryanpage();
	//void dodoor();
	void greyscalesum();
	void buttoneight();
	void findexobject();
	void errormessage2();
	void usechurchhole();
	void searchforfiles();
	void monkspeaking();
	void fadecalculation();
	//void waitframes();
	void clearrest();
	//void getreelframeax();
	void barwoman();
	void roomname();
	void credits();
	void madmanrun();
	void randomnum1();
	void keeper();
	void afternewroom();
	void getexad();
	void openforsave();
	void closefile();
	void delcurs();
	void randomaccess();
	void splitintolines();
	//void checkifex();
	//void findobname();
	void initialmoncols();
	void checkforshake();
	void usebuttona();
	void fadescreenup();
	//void getnextword();
	void generalerror();
	void actualload();
	void allocateload();
	void saveposition();
	void mode640x480();
	void openeden();
	void execcommand();
	void obsthatdothings();
	void updatesymbolbot();
	void findpuztext();
	void usechurchgate();
	void monkandryan();
	void allocatebuffers();
	void swapwithinv();
	void usecontrol();
	void buttonseven();
	void redrawmainscrn();
	void showgroup();
	//void findallryan();
	//void channel0tran();
	void buttonpress();
	//void parseblaster();
	//void readmouse1();
	void makemainscreen();
	void usewinch();
	void setbotright();
	//void readmouse3();
	void showfirstuse();
	void setupemm();
	void aide();
	//void getmapad();
	void getlocation();
	void geteitherad();
	//void placesetobject();
	//void drawflags();
	void zoomonoff();
	void updatesymboltop();
	//void showryanpage();
	void printlogo();
	void allpointer();
	void showseconduse();
	void clearreels();
	void malefan();
	void dosaveload();
	void createname();
	void readcitypic();
	void getpersontext();
	void intoinv();
	void showtime();
	void parser();
	void hangonw();
	void intro();
	//void hangonp();
	void fadescreendowns();
	void openhoteldoor2();
	void getridoftempsp();
	void scanfornames();
	//void setallchanges();
	void readsetdata();
	//void printboth();
	void standardload();
	void undertextline();
	void findroominloc();
	void sitdowninbar();
	void shownames();
	void savefileread();
	void emergencypurge();
	void usemenu();
	void alleybarksound();
	void dosometalk();
	void usecart();
	void intromusic();
	void quitkey();
	void processtrigger();
	void monmessage();
	void readdesticon();
	void randomnum2();
	void loadsecondsample();
	void transfercontoex();
	//void multiput();
	//void printmessage();
	void businessman();
	void switchryanoff();
	//void commandwithob();
	void panelicons1();
	void adjustdown();
	void withwhat();
	void openob();
	void createfile();
	void userailing();
	void accesslightoff();
	void usehole();
	void useobject();
	void volumeadjust();
	//void checkiffree();
};
}

#endif
