/*
                            SAR Mission Management
 */

#ifndef MISSION_H
#define MISSION_H

#include "obj.h"

/*
 *	Mission time left type codes:
 */
#define MISSION_TIME_LEFT_TYPE_RESCUE_ALL	0	/* Must rescue all
							 * victims and
							 * bring to safety
							 * within time limit.
							 */
#define MISSION_TIME_LEFT_TYPE_PICKUP_ALL	1	/* Must have picked
							 * up all victims
							 * within time
							 * limit.
							 */

/*
 *      Mission objective arrive structure:
 */
typedef struct {

        int type;       /* Must be MISSION_TYPE_ARRIVE. */

	/* Time left in seconds, note we use type double because
	 * we need to keep track of milliseconds as well.
	 *
	 * This value always specifies the time left for the player to
	 * reach the arrive at object specified by arrive_at_name.
	 *
	 * If this value is not positive (0.0 or negative) then that
	 * implies there is no time limit.
	 */
	double time_left;

        /* Name of object to arrive at. */
        char *arrive_at_name;

	/* Messages. */
	char	*message_success,	/* Displayed when reached the arrive
					 * at object.
					 */
		*message_fail;		/* Displayed when time runs out or
					 * crash.
					 */

} sar_mobj_arrive_struct;


/*
 *	Mission objective rescue humans structure:
 */
typedef struct {

	int type;	/* Must be MISSION_TYPE_RESCUE. */

	int time_left_type;	/* One of MISSION_TIME_LEFT_*. */

	/* Time left in seconds, note we use type double because
	 * we need to keep track of milliseconds as well.
	 *
	 * What this value specifies is determined by time_left_type.
	 *
	 * If this value is not positive (0.0 or negative) then that
	 * implies there is no time limit and time_left_type is ignored.
	 */
	double time_left;

	int	humans_rescued,		/* Humans brought to safety. */
		humans_need_rescue,	/* Total people that needed saving,
					 * value never changes after mission
					 * begins.
					 */
		humans_died;		/* Number of humans that needed
					 * rescue but have died.
					 */

	/* Name of object to rescue objectives to. */
	char *arrive_at_name;

        /* Messages. */
        char    *message_success,
                *message_fail;

} sar_mobj_rescue_struct;


/*
 *	Core mission structure:
 */
typedef struct {

#define MISSION_TYPE_NONE	0
#define MISSION_TYPE_ARRIVE	1
#define MISSION_TYPE_RESCUE	2
	int type;	/* Mission type, one of MISSION_TYPE_*. */

#define MISSION_STATE_IN_PROGRESS	0
#define MISSION_STATE_FAILED		1
#define MISSION_STATE_ACCOMPLISHED	2
	int state;	/* Mission state, one of MISSION_STATE_*. */

        char *title;
	char *description;

        char *scene_file;
        char *player_model_file;
        char *player_stats_file;

	/* Objective substructure, type determined by member type. */
	void *objective;

	/* Time spend on mission in seconds. */
	double time_spent;

	/* Timmings in milliseconds. */
	time_t next_check, check_int;

} sar_mission_struct;



#endif	/* MISSION_H */
