/* context_to_sid.c
 *
 * given a security context, returns the associated SID
 */


#include <ss.h>
#include <stdlib.h>
#include <string.h>

int main(int argc, char **argv)
{
	security_id_t out_sid;
	int ret_val;

	if (argc != 2) {
		printf("usage:  %s scontext\n\n", argv[0]);
		exit(1);
	}

	ret_val =
	    security_context_to_sid(argv[1], strlen(argv[1]) + 1,
				    &out_sid);

	if (ret_val) {
		perror("security_context_to_sid");
		exit(2);
	}

	printf("%ld\n", out_sid);
	exit(0);
}
