/*
 * Functions to deal with TOS contexts in user space.
 */

typedef struct {
  void * ptr;
} context_s_t;

typedef context_s_t *context_t;

/* Return a new context initialized to a context string */

extern context_t context_new(char *);

/* 
 * Return a pointer to the string value of the context_t
 * Valid until the next call to context_str or context_free 
 * for the same context_t*
 */

extern char* context_str(context_t);

/* Free the storage used by a context */
extern void context_free(context_t);

/* Get a pointer to the string value of a context component */

extern char* context_type_get(context_t);
extern char* context_level_get(context_t);
extern char* context_role_get(context_t);
extern char* context_user_get(context_t);

/* Set a context component.  Returns nonzero if unsuccessful */

extern int context_type_set(context_t,char*);
extern int context_level_set(context_t,char*);
extern int context_role_set(context_t,char*);
extern int context_user_set(context_t,char*);

