/*
 * shmsid.c
 *
 * Author: Howard Holm (NSA), <hdholm@epoch.ncsc.mil>
 * 
 * return the SID and context for a shared memory region with the given id
 *
 */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <linux/flask/flask.h>
#include <sys/shm.h>
#include <ipc_secure.h>

/* print the usage information for this program */
void usage(char *progname) 
{
  fprintf(stderr, "usage: %s id\n", progname);
  exit(1);
}


int main(int argc, char **argv)
{
  char context[255];
  int id, err, contextlen;
  security_id_t sid;
  
  if (argc != 2)
    usage(argv[0]);
  id = atoi(argv[1]);

  err = shmsid (id, &sid);
  if (err)
    perror (argv[0]);
  else {
    contextlen = sizeof (context);
    security_sid_to_context(sid, context, &contextlen);
    fprintf (stderr, "%s: shared memory region id = %d, has context %s (%d)\n", argv[0], id, context, sid );
  }
}
