#ifndef _HASHTAB_H_
#define _HASHTAB_H_

typedef unsigned long hashtab_key_t;	
typedef unsigned long hashtab_datum_t;	

#define INOTAB_SIZE 71
#define HASH_VALUE(k) ((k) % INOTAB_SIZE)
#define KEYCMP(k1,k2) ((k1) != (k2))

typedef struct hashtab_node_t* hashtab_ptr_t;

struct hashtab_node_t
{
    hashtab_key_t key;
    hashtab_datum_t datum;
    hashtab_ptr_t next;
};


typedef struct 
{
    hashtab_ptr_t *htable;
} hashtab_val_t;


typedef hashtab_val_t* hashtab_t;

#include <sys/errno.h>
#define HASHTAB_SUCCESS     0		
#define HASHTAB_OVERFLOW    -ENOMEM
#define HASHTAB_PRESENT     -EEXIST
#define HASHTAB_MISSING     -ENOENT

/* Symbol space cleanliness */
#define hashtab_create psid_hashtab_create
#define hashtab_destroy psid_hashtab_destroy
#define hashtab_insert psid_hashtab_insert
#define hashtab_remove psid_hashtab_remove
#define hashtab_replace psid_hashtab_replace
#define hashtab_search psid_hashtab_search
#define hashtab_reverse_search psid_hashtab_reverse_search
#define hashtab_map psid_hashtab_map
#define hashtab_map_remove_on_error psid_hashtab_map_remove_on_error

hashtab_t hashtab_create(void);
int hashtab_insert(hashtab_t h, hashtab_key_t k, hashtab_datum_t d);
int hashtab_remove(hashtab_t h, hashtab_key_t k);
int hashtab_replace(hashtab_t h, hashtab_key_t k, hashtab_datum_t d);
hashtab_datum_t hashtab_search(hashtab_t h, hashtab_key_t k);
hashtab_key_t hashtab_reverse_search(hashtab_t h, hashtab_datum_t d);
void hashtab_destroy(hashtab_t h);
int hashtab_map(hashtab_t h, 
		int (*apply)(hashtab_key_t k, 
			     hashtab_datum_t d,
			     void *args), 
		void *args);
void hashtab_map_remove_on_error(hashtab_t h, 
				int (*apply)(hashtab_key_t k,
					     hashtab_datum_t d,
					     void *args),
				void *args);

#endif
