/***************************************************************************
 *  Module:      $Id: verify.c,v 2.18 1997/12/31 05:18:32 nemesis Exp nemesis $
 *  Description: Verify mode of sendpage
 *  Author:      maf, cjc
 *
 * Copyright (c) 1995 Mark Fullmer and The Ohio State University
 * Copyright (c) 1997 Cornelius Cook and Counterpoint Networking, Inc.
 * http://www.cpoint.net/projects/sendpage
 ***************************************************************************/
/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
$Log: verify.c,v $
Revision 2.18  1997/12/31 05:18:32  nemesis
CLOCAL for all, GCC fixes, WAIT_WORD finished

Revision 2.17  1997/12/28 23:20:45  nemesis
include cleanups, configure additions/corrections

Revision 2.16  1997/12/26 02:37:31  nemesis
code clean up, b* -> mem* funcs, finding NL -> # bug

Revision 2.15  1997/12/25 08:30:52  nemesis
code cleanups

Revision 2.14  1997/12/25 06:44:34  nemesis
time_t declarations and "make install" fix

Revision 2.13  1997/12/24 21:50:04  nemesis
mailing list updates

Revision 2.12  1997/12/24 21:42:54  nemesis
0.8a released.

Revision 2.11  1997/12/24 21:02:02  nemesis
more changes

Revision 2.10  1997/12/24 20:56:03  nemesis
gearing up for 0.8a more

Revision 2.9  1997/12/24 20:45:35  nemesis
trying to make 0.8a release

Revision 2.8  1997/12/24 20:29:08  nemesis
fixed up autoconf modifications, cleaned up signal stuff

Revision 2.7  1997/12/24 20:15:13  nemesis
sendpage.h now mostly contained within 'configure'

Revision 2.6  1997/12/24 19:52:04  nemesis
fixing posix checking

Revision 2.5  1997/12/24 19:41:49  nemesis
posix additions, syslog autoconf'd

Revision 2.4  1997/12/24 19:33:03  nemesis
check for POSIX

Revision 2.3  1997/12/17 09:37:27  nemesis
more autoconf changes... mostly strerror.o

Revision 2.2  1997/12/17 08:24:05  nemesis
autoconf-ing

Revision 2.1  1997/12/17 08:03:38  nemesis
adjustments

Revision 2.0  1997/12/17 08:01:05  nemesis
setting up autoconf

Revision 1.9  1997/12/17 07:56:23  nemesis
starting on the autoconfing

Revision 1.8  1997/12/17 04:47:05  nemesis
still adjusting

Revision 1.7  1997/12/17 04:46:25  nemesis
adjusting version numbers

Revision 1.6  1997/12/17 04:44:36  nemesis
*** empty log message ***

Revision 1.1  1997/12/15 15:58:19  nemesis
Initial revision

 * Revision 1.7  1996/02/14  09:49:33  maf
 * *** empty log message ***
 *
 * Revision 1.6  1996/02/14  05:03:04  maf
 * *** empty log message ***
 *
 * Revision 1.5  1995/11/13  04:45:04  maf
 * *** empty log message ***
 *
 * Revision 1.4  1995/11/13  03:28:16  maf
 * *** empty log message ***
 *
 * Revision 1.3  1995/10/09  01:40:40  maf
 * added support for user profile in VerifyMode
 *
 * Revision 1.2  1995/03/15  04:41:09  maf
 * *** empty log message ***
 *
 * Revision 1.1  1995/01/10  01:45:24  maf
 * Initial revision
 *
*/

/*
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <limits.h>
#include <stdio.h>
#include <errno.h>
#include <signal.h>
#include <string.h>
#include <fcntl.h>
#include <syslog.h>
#include <stdlib.h>
#include <unistd.h>
#include <db.h>
*/
#include "sendpage.h"
#include "report.h"
#include "misc.h"
#include "cf.h"

/*********************************************************************
 * Function: VerifyMode
 *	implements a high level interface to verifying aliases, and this the
 *	sendpage config file were read
 *
 *	aliasdb and pcdb should be setup by ReadConfig() before calling this.
 *
 *	returns 0	good
 *	       !0	bad
 *
 *	errors are reported to stderr
 *
 *********************************************************************/
int VerifyMode(DB* aliasdb, DB* pcdb, DB* profdb) {
  struct dynstring aliaslist;
  DBT dbkey, dbval;
  struct linebuf linebuf;
  int err, ret;
  int len, r;
  char *p;
  struct profile profile;
  extern struct profile defaultProfile;
  
  
  bzero(&aliaslist, sizeof(aliaslist));
  bzero(&linebuf, sizeof(linebuf));
  err = 1;							/* bad */

  if (!aliasdb) {
    printf("Error, alias database not initialized.\n");
    goto VerifyModeout;
  }
  if (!pcdb) {
    printf("Error, paging central database not initialized.\n");
    goto VerifyModeout;
  }

  printf("\nsendpage verify mode\nEnter address\n");
  
  while (1) {
    if ((r = GetLine(STDIN_FILENO, &linebuf)) == -1) {
      fprintf(stderr, "GetLine() failed\n");
      goto VerifyModeout;
    }

    /* exit loop EOF */
    if (r == 1)
      break;
    
    /* skip blank and comment lines */
    if (!linebuf.len2)
      continue;
    
    dbkey.data = linebuf.buf;
    dbkey.size = linebuf.len2;
    
    aliaslist = AliasExpand(aliasdb, dbkey);
    
    if (aliaslist.bufused == -1)  {
      fprintf(stderr, "AliasExpand() returned an error condition\n");
      goto VerifyModeout;
    }
    
    if (!aliaslist.bufused) {
      printf("---> no expansion\n");
      continue;
    }

    p = aliaslist.buf;
    for (; (len = strlen(p)); p += len+1) {
      
      if ((ret = profdb->get(profdb, &dbkey, &dbval, (u_int)0)) == -1) {
	fprintf(stderr, "profdb->get: %s", strerror(errno));
	goto VerifyModeout;
      }
      
      if (ret) /* no match */
	memcpy(&profile, &defaultProfile, sizeof profile);
      else
	memcpy(&profile, dbval.data, sizeof profile);
      
      printf("  rhs:            %s\n", p);
      printf("  emailCC:        %s\n", profile.emailCC);
      printf("  trMap:          %s\n", profile.trMap);
      printf("  maxMsgSize:     %d\n", profile.maxMsgSize);
      printf("  emailReply:     %s\n",
	     profile.flags & PROF_FLAGS_MAIL_GOOD  ? "yes" : "no");
      printf("  emailReplyErr:  %s\n",
	     profile.flags & PROF_FLAGS_MAIL_BAD  ? "yes" : "no");
      printf("  msgIncSender:   %s\n",
	     profile.flags & PROF_FLAGS_INC_SENDER  ? "yes" : "no");
      printf("  msgIncDate:     %s\n",
	     profile.flags & PROF_FLAGS_INC_DATE ? "yes" : "no");
      printf("  msgIncTime:     %s\n\n",
	     profile.flags & PROF_FLAGS_INC_TIME ? "yes" : "no");
    }
    
    printf("\n");

    if (aliaslist.buf)
      free (aliaslist.buf);

#ifdef DEBUG
#ifdef SYSV_MALLOC
    if (debug > 10) 
      PrintMallinfo(mallinfo());
#endif /* SYSV_MALLOC */
#endif /* DEBUG */
  } /* while 1*/
  
  err = 0; /* good */

VerifyModeout:
  
  if (linebuf.buf)
    free (linebuf.buf);
  
  return err;
} /* VerifyMode */
