/*
 * Sentinella
 * http://sourceforge.net/projects/sentinella/
 * Copyright (c) 2009, 2010 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef ABSTRACTLOOPCONDITION_H_
#define ABSTRACTLOOPCONDITION_H_

#include "AbstractCondition.h"

class AbstractLoopCondition : public AbstractCondition {

public:
	AbstractLoopCondition(const int secondsLimit, const short resolution);
	void run();

protected:
	virtual void open() = 0;
	virtual bool evaluate() = 0;
	virtual void close() = 0;

private:
	int secondsLimit;
	short resolution;

};

#endif /* ABSTRACTLOOPCONDITION_H_ */
