/* $Id: sfskey.h,v 1.50 2001/08/24 23:03:01 ericp Exp $ */

/*
 *
 * Copyright (C) 1999 David Mazieres (dm@uun.org)
 * Copyright (C) 1999 Michael Kaminsky (kaminsky@lcs.mit.edu)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "agentmisc.h"
#include "parseopt.h"
#include "rxx.h"
#include "crypt.h"
#include "password.h"
#include "sfsconnect.h"

#define RANDOM_SEED "~/.sfs/random_seed"

extern vec<int> pwd_fds;

#if __GNUC__ == 2 && __GNUC_MINOR__ <= 95 && defined (__alpha__)
# define XXX_EXIT 1
#endif /* gcc <= 2.95.x && alpha */

#ifdef XXX_EXIT
void XXX_call_exit (int code);
#define exit XXX_call_exit
#endif /* XXX_EXIT */

void setbool (bool *bp);
void rndaskcd ();
void rndkbd ();
str getpwd (str prompt);
str getpwdconfirm (str prompt);
str getline (str prompt, str def = NULL);
void usage () __attribute__ ((noreturn));
void nularg (int argc, char **argv);
ref<aclnt> cagent ();
ref<aclnt> ccd ();
str defkey ();
str defkeyname (str user = NULL);
str myusername ();

struct srp_client;
void sfs_connect_srp (str &user, srp_client *srpp, sfs_connect_cb cb,
		      str *userp = NULL, str *pwdp = NULL);

struct sfskey {
  ptr<rabin_priv> key;
  str keyname;
  str pwd;
  u_int cost;
  sfssrp_parms *srpparms;
  sfskey () : cost (0), srpparms (NULL) {}
};

bool isremote (str keyname);
str keysave (str path, const sfskey *sk, bool excl = true);
str keygen (sfskey *sk, u_int nbits, str prompt = NULL, bool askname = true,
	    bool nopwd = false, bool nokbdnoise = false);
str keyfetch (sfskey *sk, str keyname, ptr<sfscon> *scp = NULL);

inline void
fetchkey (str keyname, callback<void, ptr<sfskey>, str, ptr<sfscon> >::ref cb)
{
  ptr<sfskey> sk = New refcounted<sfskey>;
  ptr<sfscon> sc;
  if (str err = keyfetch (sk, keyname, &sc))
    (*cb) (NULL, err, NULL);
  else
    (*cb) (sk, NULL, sc);
}

void sfskey_add (int argc, char **argv);
void sfskey_certclear (int argc, char **argv);
void sfskey_certlist (int argc, char **argv);
void sfskey_certprog (int argc, char **argv);
void sfskey_clear (int argc, char **argv);
void sfskey_delete (int argc, char **argv);
void sfskey_edit (int argc, char **argv);
void sfskey_gen (int argc, char **argv);
void sfskey_hostid (int argc, char **argv);
void sfskey_sesskill (int argc, char **argv);
void sfskey_list (int argc, char **argv);
void sfskey_sesslist (int argc, char **argv);
void sfskey_norevokelist (int argc, char **argv);
void sfskey_norevokeset (int argc, char **argv);
void sfskey_reg (int argc, char **argv);
void sfskey_reset (int argc, char **argv);
void sfskey_revoke (int argc, char **argv);
void sfskey_revokeclear (int argc, char **argv);
void sfskey_revokegen (int argc, char **argv);
void sfskey_revokelist (int argc, char **argv);
void sfskey_revokeprog (int argc, char **argv);
void sfskey_srpgen (int argc, char **argv);
void sfskey_update (int argc, char **argv);
