/* $Id: sfsconnect.h,v 1.2 2001/06/28 04:47:23 dm Exp $ */

/*
 *
 * Copyright (C) 1999 David Mazieres (dm@uun.org)
 * Copyright (C) 2000 Michael Kaminsky (kaminsky@lcs.mit.edu)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "async.h"
#include "arpc.h"
#include "crypt.h"
#include "sfsmisc.h"

struct sfscon {
  ptr<axprt_crypt> x;
  str path;
  sfs_servinfo servinfo;
  sfs_hash hostid;
  sfs_hash sessid;
  sfs_hash authid;
  bool hostid_valid;
  sfscon () : hostid_valid (false) {}
};

void sfs_initci (sfs_connectinfo *ci, str path, sfs_service service,
		 vec<sfs_extension> *exts = NULL);
bool sfs_nextci (sfs_connectinfo *ci);
typedef callback<void, ptr<sfscon>, str>::ref sfs_connect_cb;
void sfs_connect (const sfs_connectarg &carg, sfs_connect_cb cb,
		  bool encrypt = true, bool check_hostid = true);
void sfs_connect_path (str path, sfs_service service, sfs_connect_cb cb,
		       bool encrypt = true, bool check_hostid = true);
void sfs_connect_host (str host, sfs_service service, sfs_connect_cb cb,
		       bool encrypt = true);
