/*
 * Smart Gnome Control - file functions definition file
 * Copyright (C) 2004 by Mark J. Fine <fineware@users.sourceforge.net>
 *
 * This program provides a graphical user interface to multiple
 * communications receivers using the Hamlib library.
 *
 * $Id: logfile.h,v 1.2 2004/12/29 21:05:49 fineware Exp $
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 *      Free Software Foundation, Inc.
 *      59 Temple Place - Suite 330
 *      Boston, MA  02111-1307
 *      USA
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <libgnomevfs/gnome-vfs-init.h>
#include <libgnomevfs/gnome-vfs-ops.h>
#include <libgnomevfs/gnome-vfs-directory.h>
#include <libgnomevfs/gnome-vfs-xfer.h>

gchar*		basepath;
gchar*		basedbpath;
gchar*		baselogpath;
gchar*		log_name;
GList*		log_details;
GtkWidget*	log_selector;

gchar*
get_user_base(void);

void
prep_user_dir(void);

gboolean
file_exists                            (gchar* in_file);

gchar*
strchrins                              (gchar* in_ins,
                                        gchar* in_str,
                                        int    in_pos);

gchar*
strchrdel                              (gchar* in_str,
                                        int    in_pos,
                                        int    in_len);

void
select_from_log_list                   (GtkWidget* inWidget,
                                        GdkEventButton  *inEvent,
                                        gint in_row);

void
set_log_data                           (int in_row);

void
create_log_file(void);

void
create_logname						   (GtkFileSelection *selector,
                                        gpointer         user_data);

void
new_logfile(void);

void
get_log_file(void);

void
store_logname						   (GtkFileSelection *selector,
                                        gpointer         user_data);

void
open_logfile(void);

void
put_log_file(void);

void
store_logname_as					   (GtkFileSelection *selector,
                                        gpointer         user_data);

void
save_logfile(void);

void
change_log_selection                   (gboolean is_next);

void
show_log_entry                         (gint     in_mode,
										gboolean use_faceplate,
							 			gint	 in_row);

void
process_log_entry(void);

void
add_log_entry(void);

void
modify_log_entry(void);

void
delete_log_entry(void);
