/***************************************************************************
                          interface_popups.h  -  description
                             -------------------
    begin                : Thu Dec 21 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INTERFACE_POPUPS_H
#define INTERFACE_POPUPS_H

#include <gtk--/window.h>
#include <gtk--/label.h>
#include <gtk--/spinbutton.h>
#include <gtk--/separator.h>
#include <gtk--/button.h>
#include <gtk--/table.h>
#include <gtk--/frame.h>
#include <gtk--/adjustment.h>
#include <gtk--/box.h>
#include <gtk--/menu.h>
#include <gtk--/menuitem.h>
#include <gtk--/clist.h>
#include <gtk--/scrolledwindow.h>
 #include <gdk/gdkkeysyms.h>

#include "song.h"


class PopUp_Pattern_Properties : public Gtk::Window {

        Gtk::Label label1;
        Gtk::Label label2;
        Gtk::HSeparator hseparator1;
        Gtk::Label label3;
        Gtk::Label label4;
        Gtk::Label label5;
        Gtk::HSeparator hseparator2;
        Gtk::Button button_cancel;
        Gtk::HSeparator hseparator3;
        Gtk::HSeparator hseparator4;
        Gtk::Table table1;
        Gtk::Frame frame1;

	void cancel_callback();
public:
        Gtk::SpinButton *spinbutton_highlight_major;
        Gtk::Adjustment *spinbutton_highlight_major_adj;
        Gtk::SpinButton *spinbutton_highlight_minor;
        Gtk::Adjustment *spinbutton_highlight_minor_adj;
        Gtk::SpinButton *spinbutton_pattern_length;
        Gtk::Adjustment *spinbutton_pattern_length_adj;
        Gtk::SpinButton *spinbutton_highlight_extra;
        Gtk::Adjustment *spinbutton_highlight_extra_adj;
        Gtk::SpinButton *spinbutton_pattern_extra;
        Gtk::Adjustment *spinbutton_pattern_extra_adj;
        Gtk::Button button_apply;

        PopUp_Pattern_Properties();
        ~PopUp_Pattern_Properties();

};

class Popup_Scale_Volume : public Gtk::Window {

	Gtk::Label label1;
	Gtk::Adjustment *spinbutton_volume_scale_adj;
	Gtk::Label label2;
	Gtk::HBox hbox1;
	Gtk::VBox vbox1;
	Popup_Scale_Volume();

	int key_press_event_impl(GdkEventKey* event) {

		switch (event->keyval) {

			case GDK_Return: {

				button_ok.clicked.emit();
			} break;
			case GDK_Up:
			case GDK_Left: {

				spinbutton_volume_scale->set_value(spinbutton_volume_scale->get_value_as_int()-1);
			} break;
			case GDK_Down:
			case GDK_Right: {


				spinbutton_volume_scale->set_value(spinbutton_volume_scale->get_value_as_int()+1);
			} break;
		}
		
		return 1;
	}
public:

	Gtk::SpinButton *spinbutton_volume_scale;
	Gtk::Button button_ok;

	Popup_Scale_Volume(int p_base_percent);
	~Popup_Scale_Volume();
};

class Popup_Pattern_Utils {
public:

 	Gtk::MenuItem *item_copy;
 	Gtk::MenuItem *item_cut;
 	Gtk::MenuItem *item_paste;
 	Gtk::MenuItem *item_zap;
	/* -=-=- */
 	Gtk::MenuItem *item_add_column;
 	Gtk::MenuItem *item_del_column;
	/* -=-=- */
 	Gtk::MenuItem *item_pat_props;
 	Gtk::MenuItem *item_vol_scale;
	/* -=-=- */
 	Gtk::MenuItem *separator1;
 	Gtk::MenuItem *separator2;

	Gtk::Menu pattern_menu;

	Popup_Pattern_Utils () {

		item_copy = new Gtk::MenuItem("Copy (alt-c)");
		item_cut = new Gtk::MenuItem("Cut");
		item_paste = new Gtk::MenuItem("Paste (alt-p)");
		item_zap = new Gtk::MenuItem ("Zap (alt-z)");
		item_add_column = new Gtk::MenuItem("+Column (alt-])");
		item_del_column = new Gtk::MenuItem("-Column (alt-[)");
		item_pat_props = new Gtk::MenuItem("Pattern Properties (f2)");
		item_vol_scale = new Gtk::MenuItem("Scale Volumes (alt-j)");

		separator1 = new Gtk::MenuItem();
		separator2 = new Gtk::MenuItem();

		pattern_menu.append(*item_copy);
		pattern_menu.append(*item_cut);
		pattern_menu.append(*item_paste);
		pattern_menu.append(*item_zap);

		pattern_menu.append(*separator1);

		pattern_menu.append(*item_add_column);
		pattern_menu.append(*item_del_column);

		pattern_menu.append(*separator2);

		pattern_menu.append(*item_pat_props);
		pattern_menu.append(*item_vol_scale);

		item_copy->show();
		item_cut->show();
		item_paste->show();
		item_zap->show();
		item_add_column->show();
		item_del_column->show();
		item_pat_props->show();
		item_vol_scale->show();
		separator1->show();
		separator2->show();

	}

	~Popup_Pattern_Utils () {};

};

class Window_File_Popup : public Gtk::Window {
public:
        Gtk::Button button_popup_file_load;
        Gtk::Button button_popup_file_new;
        Gtk::Button button_popup_file_save_current;
        Gtk::Button button_popup_file_save_as;
        Gtk::Button button_popup_file_export_midi;
        Gtk::Button button_popup_file_quit;
        Gtk::VBox vbox2;
        Gtk::Frame frame1;

	Window_File_Popup();
	~Window_File_Popup();
};

class Window_Variables_Popup : public Gtk::Window {

        int index;
	Song* song;

	int selected_left,selected_right;

	Gtk::CList clist_aviable;
	Gtk::ScrolledWindow scrolledwindow1;
	Gtk::VSeparator vseparator1;
	Gtk::Button button_add;
	Gtk::Button button_delete;
	Gtk::VSeparator vseparator2;
	Gtk::VBox vbox2;
	Gtk::CList clist_used;
	Gtk::ScrolledWindow scrolledwindow2;
	Gtk::Button button_move_up;
	Gtk::HSeparator hseparator3;
	Gtk::Button button_move_down;
	Gtk::HBox hbox4;
	Gtk::VBox vbox3;
	Gtk::HBox hbox3;
	Gtk::HSeparator hseparator1;
	Gtk::HSeparator hseparator2;
	Gtk::Button button_cancel;
	Gtk::HBox hbox2;
	Gtk::VBox vbox1;

        void fill_clist(Gtk::CList *p_clist,Instrument::Initial_Value_List *p_vlist);

	void button_add_pressed();
	void button_cancel_pressed();
	void clist_track_aviable_clicked(gint row,gint column,GdkEvent *event);
	void clist_track_used_clicked(gint row,gint column,GdkEvent *event);

//	Window_Variables_Popup(){};

        Instrument::Initial_Value_List var_list;
		
public:

        Instrument::Initial_Value_List value_list;
	Gtk::Button button_ok;

        Window_Variables_Popup(Song* p_song,int p_index);
        ~Window_Variables_Popup();
};
#endif /* interface_popups.h */
