/***************************************************************************
                          player_interface.cpp  -  description
                             -------------------
    begin                : Sun Sep 16 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "player_interface.h"

void Player_Interface::parse_note(int p_track,int p_pattern,int p_column,int p_row) {

        queue_note(p_track,p_column,song->get_note(p_track,p_pattern,p_column,p_row));
	parse_effect(p_track,p_column);
}

void Player_Interface::parse_row(int p_pattern,int p_row) {

	int i,j;

	for (i=0;i<song->get_tracks();i++) {
	
		for (j=0;j<song->get_track_width(i);j++) {

			queue_note(i,j,song->get_note(i,p_pattern,j,p_row));
		}
	}

	for (i=0;i<song->get_tracks();i++) {
	
		for (j=0;j<song->get_track_width(i);j++) {

			parse_effect(i,j);
		}
	}
}

void Player_Interface::queue_note(int p_track,int p_column,Note p_note) {
	
	Note note=p_note;
	int event_flags=Effect::PROCESS_NOTE;
	int event_delay;

	data->tmp.event_delay=0;
	
	/* PRE-COMMAND CHECK */

	if (note.command!=Note::CLEAR) {

			Effect *current_fx=fx[p_track][p_column].table->get_effect(note.command);
			current_fx->notify_command(note.parameter);
			event_flags=current_fx->notify_begin(note.note,note.volume,fx[p_track][p_column].last_note);

			if ((event_flags&Effect::PROCESS_COMMAND)==0) {
				//not calling the effect.
				note.command=Note::CLEAR;
			}

			if (note.command!=fx[p_track][p_column].current_command) {

				current_fx->begin_notify();
			}
	}

	if ( (note.command!=fx[p_track][p_column].current_command) &&
 	     (fx[p_track][p_column].current_command!=Note::CLEAR) ) {

		fx[p_track][p_column].table->get_effect(fx[p_track][p_column].current_command)->stop_notify();
	}

	fx[p_track][p_column].current_command=note.command;
	fx[p_track][p_column].current_parameter=note.command;


	event_delay=data->tmp.event_delay; //todo row delay

	if (event_flags&Effect::PROCESS_NOTE) {

		if (note.note<128) {

		        Event_NoteOn *noteon_event = new Event_NoteOn;
			noteon_event->set_note(note.note,note.volume);
			queue->push(event_delay,p_track,p_column,noteon_event);
			fx[p_track][p_column].last_note=note.note;

		} else if (note.note==Note::OFF) {

		        Event_NoteOff *noteoff_event = new Event_NoteOff;
			noteoff_event->set_volume(note.volume);
			queue->push(event_delay,p_track,p_column,noteoff_event);
			fx[p_track][p_column].last_note=note.note;
		}


	}

	if ((note.note==Note::CLEAR) && (note.volume<65)) {

	        Event_Volume *vol_event = new Event_Volume;
		vol_event->set_volume(note.volume);
		queue->push(event_delay,p_track,p_column,vol_event);
	}
/*
	if (process_command) {

	        Event_Volume *vol_event = new Event_NoteOff;
		vol_event->set_volume(note.volume);
		CONFIGURE_EVENT_PARAMETERS(vol_event);
		queue->push(event_delay,vol_event);

	}
*/
	if (note.controller_set!=Note::CLEAR) {
	
		Event_Controller *cnt_event = new Event_Controller;
		cnt_event->set_controller(note.controller_set,note.controller_value*127/0xFF);
		queue->push(event_delay,p_track,p_column,cnt_event);
	}


/*
	switch ('A'+note.command) {
		case 'A': {

                        if (note.parameter>0) {

				variables.rpq=note.parameter;
				variables.calculate_real_increment();
			}
			process_command=false;
		} break;
		case 'T': {

                        if (tmpnote.parameter>0) {

				variables.tempo=note.parameter;
				variables.calculate_real_increment();				
			}
			process_command=false;
		} break;
		case 'G': {

			if (trackdata[track].column[column].current_note==0) {

				process_command=false;
				break;

			}
			

			process_note=false;

			if ( (tmpnote.note>0) && (tmpnote.note<129) ) { // we have a new note, change target -

				if (song->get_track(track)->instrument.volume_column_behavior==VOLUME_COLUMN_BEHAVIOR_TRACKER) { //set volume in case we're emulating a tracker.

					eventlist.queue_event(event_type_Volume_Column_Set,note_delay,track,column,(int)convert_volume_to_velocity(track,tmpnote.volume)*64/127,0);
				}

   				trackdata[track].column[column].pitch_porta.set_target_bender_val(get_bender_value_from_note(trackdata[track].column[column].current_note-1,tmpnote.note-1,trackdata[track].current_bender_sens));
				
			}
		}
	}
	
*/

	

}

void Player_Interface::execute_effect(Effect *p_effect) {

	float max_msecs,msecs_count,msecs_incr;
	float decre;

	if (!p_effect->has_processing()) return;

	//max_msecs=data->variables.next_row_msecs-(float)data->variables.msecs_elapsed;
	max_msecs=data->variables.real_increment-1; // -1 is just to make sure that the last event will be triggered before the new note.
	msecs_count=0;

	msecs_incr=30; // tob echanged

	while ((msecs_count+=msecs_incr)<=max_msecs) {
		p_effect->process(msecs_incr,msecs_count);
		decre+=msecs_incr;
	}
	
	if ((msecs_count-max_msecs)<msecs_incr) {

		p_effect->process(msecs_incr-(msecs_count-max_msecs),(int)max_msecs);		
		decre+=msecs_incr-(msecs_count-max_msecs);
	}


}


void Player_Interface::parse_effect(int p_track,int p_column) {

	int current_command=fx[p_track][p_column].current_command;

	if (current_command!=Note::CLEAR) {

		execute_effect(fx[p_track][p_column].table->get_effect(current_command));
	}
}

void Player_Interface::set_song(Song *p_song) {

	song=p_song;
}
void Player_Interface::set_data(Player_Data *p_data) {

	data=p_data;
}
void Player_Interface::set_queue(Event_Queue *p_queue) {

	queue=p_queue;
}

void Player_Interface::reset() {

	unsigned int i;

	if (fx.size()!=song->get_tracks()) {

		fx.resize(song->get_tracks());
	}

	for (i=0;i<song->get_tracks();i++) {

		int j;

		if (fx[i].size()!=song->get_track_width(i)) {
			
			if (fx[i].size()>song->get_track_width(i)) {

                         	for (j=song->get_track_width(i);j<fx[i].size();j++) {

					delete fx[i][j].table;
				}

				fx[i].resize(song->get_track_width(i));
			}			

			if (fx[i].size()<song->get_track_width(i)) {

				int oldsize=fx[i].size();

				fx[i].resize(song->get_track_width(i));

                         	for (j=oldsize;j<song->get_track_width(i);j++) {

					fx[i][j].table = new Effect_Table(queue,data,i,j);
				}
			}

		}

		for (j=0;j<song->get_track_width(i);j++) {

			fx[i][j].reset();
		}
	}

}



Player_Interface::Player_Interface(){
}
Player_Interface::~Player_Interface(){
}
