#include <new>
#include <string.h>
#include "classdef.hpp"
extern "C" {
	#include "log.h"
}

using namespace std;

static int find_in_vector(int *v, int n, int pr);
static void sort_vector(int *v, int n);

classdef::classdef()
{
	id = -1;
	name = 0;
	bandwidth = -1;
	divert_reinjection = 0; // 0 -> inbound, 1 -> outbound
	n_classifiers = 0;
	v_classifiers = 0;

	v_queues = 0;
	n_queues = 0;
	q_maxbytes = 0;
	q_maxpckts = 1;
	q_bytes = q_pckts = 0;
}

classdef::~classdef()
{
	int i;

	// delete queued packets ...
	for( i = 0 ; i<n_queues ; i++ ) {
		queue<generic_packet*> *q = v_queues + i;
		while( !q->empty() ) {
			generic_packet *packet = q->front();
			q->pop();
			delete packet;
		}
	}
	// delete queues ...
	n_queues = 0;
	delete[] v_queues;

	delete[] name;
	id = -1;

	for( int i = 0 ; i<n_classifiers ; i++ ) delete v_classifiers[i];
	n_classifiers = 0;
	delete[] v_classifiers;

	list<char*>::iterator iter;
	for( iter = lenders.begin() ; iter!=lenders.end() ; iter++ ) {
		delete[] (*iter);
		(*iter) = 0;
	}

	bandwidth = -1;
}

void classdef::set_bw(const int &bw)
{
	bandwidth = bw;
}

int classdef::set_name(const char *newname, int len)
{
	if( len<=0 ) return -1;

	name = new(nothrow) char[len+1];
	if( name==0 ) return -1;

	memcpy(name, newname, len);
	name[len] = '\0';

	return 0;
}

int classdef::add_lender(char *id)
{
	int n = strlen(id);
	char *str;

	list<char*>::iterator iter;
	for( iter = lenders.begin() ; iter!=lenders.end() ; iter++ ) {
		if( strcmp(id, *iter)==0 ) {
			// duplicated entries are okay ...
			return 0;
		}
	}

	str = new(nothrow) char[n+1];
	if( str==0 ) return -1;

	memcpy(str, id, n+1);
	lenders.push_back(str);

	return 0;
}

int classdef::add_packet_classifier(packet_classifier *pc)
{
	packet_classifier **new_vector;

	new_vector = new(nothrow) (packet_classifier*)[n_classifiers+1];
	if( new_vector==0 ) goto __err_new;

	if( n_classifiers>0 ) {
		size_t nbytes = n_classifiers * sizeof(packet_classifier*);
		memcpy(new_vector, v_classifiers, nbytes);
		delete[] v_classifiers;
	}
	v_classifiers = new_vector;
	v_classifiers[n_classifiers++] = pc;
	return 0;
	__err_new:
		return -1;
}

int classdef::check_packet(generic_packet *packet, int *r_prio)
{
	int i, result;

	for( i = 0 ; i<n_classifiers ; i++ ) {
		result = v_classifiers[i]->check(packet);
		if( result==+1 ) {
			(*r_prio) = v_classifiers[i]->get_real_prio();
			return +1;
		}
	}
	return 0;
}

void classdef::get_queue_limits(int *bytes, int *pckts)
{
	*bytes = q_maxbytes;
	*pckts = q_maxpckts;
}

void classdef::set_queue_limits(int bytes, int pckts)
{
	q_maxbytes = bytes;
	q_maxpckts = pckts;
}

char *classdef::get_name()
{
	return name;
}

int classdef::get_bw()
{
	return bandwidth;
}

void classdef::set_id(int newid)
{
	id = newid;
}

int classdef::get_id()
{
	return id;
}

int classdef::queue_packet(generic_packet *packet, int prio)
{
	int b = packet->payload_size;

	if( q_maxbytes>0 && q_bytes+b>q_maxbytes || 
	    q_maxpckts>0 && q_pckts+1>q_maxpckts ) {
		int pr, okay;

		okay = 0;
		for( pr = 0 ; pr<prio && okay==0 ; pr++ ) {
			queue<generic_packet*> *q = v_queues + pr;
			while( !q->empty() && okay==0 ) {
				// remove from queue & delete
				// this isn't ideal, maybe this should be
				// some kind of atomic transaction, or
				// maybe it would be better to search first
				// for a large packet...
				generic_packet *pckt = q->front();
				q->pop();
				q_bytes -= pckt->payload_size;
				q_pckts--;
				log_info(LL_DEBUG1, "dropping packet (no "
					"space left) prio=%d, packet prio=%d, "
					"class=[%s] {%s:%d}",
					pr, prio, name, __FILE__, __LINE__);
				delete pckt;

				if( q_maxbytes>0 && q_bytes+b>q_maxbytes ||
				    q_maxpckts>0 && q_pckts+1>q_maxpckts ) {
					okay = 0;
				} else {
					okay = 1;
				}
			}
		}

		if( okay==0 ) {
			log_info(LL_DEBUG1, "dropping rx'd packet (prio=%d) "
				"for class [%s]; q_bytes=%d q_pckts=%d "
				"q_maxbytes=%d q_maxpckts=%d {%s:%d}", 
				prio, name, q_bytes, q_pckts, q_maxbytes, 
				q_maxpckts, __FILE__, __LINE__);
			delete packet;
			return 0;
		}
	}

	v_queues[prio].push(packet);
	q_bytes += b;
	q_pckts++;
	return 0;
}

generic_packet *classdef::dequeue_packet()
{
	if( q_pckts==0 ) return 0;

	for( int pr = n_queues-1 ; pr>=0 ; pr-- ) {
		queue<generic_packet*> *q = v_queues + pr;
		if( !q->empty() ) {
			generic_packet *pckt = q->front();
			q->pop();
			q_bytes -= pckt->payload_size;
			q_pckts--;
			return pckt;
		}
	}
	log_info(LL_ALERT, "all queues empty, q_pckts=%d, class=[%s] "
		"{%s:%d}", q_pckts, name, __FILE__, __LINE__);
	return 0;
}

int classdef::queue_empty()
{
	return q_pckts==0 ? 1 : 0;
}

// must be called after all classifiers have been created
int classdef::queue_init()
{
	int i, n, *v_prio;

	if( n_classifiers==0 ) return 0;

	v_prio = new(nothrow) int[n_classifiers];
	if( v_prio==0 ) {
		log_info(LL_ALERT, "no memory for vector {%s:%d}", 
			__FILE__, __LINE__);
		goto __err_new;
	}

	n = 0;
	for( i = 0 ; i<n_classifiers ; i++ ) {
		int u_pr = v_classifiers[i]->get_user_prio();
		if( find_in_vector(v_prio, n, u_pr)>=0 ) continue;
		v_prio[n++] = u_pr;
	}

	sort_vector(v_prio, n);

	for( i = 0 ; i<n_classifiers ; i++ ) {
		int u_pr = v_classifiers[i]->get_user_prio();
		int r_pr = find_in_vector(v_prio, n, u_pr);
		v_classifiers[i]->set_real_prio(r_pr);
	}

	v_queues = new(nothrow) (queue<generic_packet*>)[n];
	if( v_queues==0 ) {
		log_info(LL_ALERT, "no memory for queue {%s:%d}", 
			__FILE__, __LINE__);
		goto __err_new_q;
	}
	n_queues = n;

	delete[] v_prio;
	return 0;
	__err_new_q:
		delete[] v_prio;
	__err_new:
		return -1;
}

static int find_in_vector(int *v, int n, int pr)
{
	for( int i = 0 ; i<n ; i++ ) if( v[i]==pr ) return i;
	return -1;
}

static void sort_vector(int *v, int n)
{
	int i, j;
	for( i = 0 ; i<n ; i++ )
	for( j = i+1 ; j<n ; j++ ) if( v[i]>v[j] ) {
		int x = v[i];
		v[i] = v[j];
		v[j] = x;
	}
}
