/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
*/
/*
 * AtFS -- Attribute Filesystem
 *
 * atfsrepair.h -- definitions for archive repair tool
 *
 * Author: Andreas Lampen (Andreas.Lampen@cs.tu-berlin.de)
 *
 * $Header: atfsrepair.h[7.0] Fri Jun 25 14:32:47 1993 andy@cs.tu-berlin.de frozen $
 */

/*** levels ***/
#define SILENT  0
#define NOASK   1
#define NORMAL  2
#define EDIT	3

#define MAXREVS 256
#define MAXUDAS 256

/*** definitions for compatibility with old versions ***/
#define AF_OLD_ATFSFILEID "\02A"  	/* filename prefix for AtFS archives */
#define AF_OLD_ARCHEXT	  'A'		/* extension for archive names */
#define AF_OLD_DATAEXT	  'D'		/* extension for datafile names */
#define AF_OLD_BPFILEID   "\02B"  	/* filename prefix for BP files */

typedef struct {
  char    *string;
  int     curPos;
  int     length;
} Input;

typedef struct {
  off_t   datasize;
  int     noOfRevisions;
  char    *host;
  char    *syspath;
  char    *name;
  char    *type;
  char    *ownerName;
  char    *ownerHost;
  char    *ownerDomain;
} ConstAttrs;

typedef struct {
  int     generation;
  int     revision;
  int     state;
  mode_t  mode;
  char    *authorName;
  char    *authorHost;
  char    *authorDomain;
  char    *lockerName;
  char    *lockerHost;
  char    *lockerDomain;
  time_t  lockTime;
  time_t  modTime;
  time_t  accessTime;
  time_t  statChangeTime;
  time_t  saveTime;
  int     representation;
  off_t   fileSize;
  off_t   deltaSize;
  int     succGen;
  int     succRev;
  int     predGen;
  int     predRev;
} Revision;

typedef struct {
  int     generation;
  int     revision;
  int     size;
  char    *uda[MAXUDAS];
} Udas;

typedef struct {
  int     generation;
  int     revision;
  off_t   size;
  char    *contents;
} Note;

typedef struct {
  int     generation;
  int     revision;
  int     representation;
  off_t   size;
  char    *contents;
} Data;


