
#include <gtk/gtk.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>

#define READ 0
#define WRITE 1



/* This routine executes "ps ax -w" and looks at the restult for giving name.*/
/* the /tmp catalog must be writable to us, otherwise we got problem. */

/* This can surely be done more beautiful, but this works, so I feel no */
/* need to make it look better. :-) */

int checkfor(char *name)
{

    int td, fsize, i, status;
    int k1 = 0, k2 = 0, k3 = 0, k4 = 0;
    char tmpname[] = "/tmp/XXXXXX";
    FILE *tmpfile;
    char *buffer, *name1, *name2, *name3, *name4;


    td = mkstemp(tmpname);
    if (td == -1)
	return -2;

    switch (fork()) {
    case 0:
	close(WRITE);
	dup(td);
	close(td);
	execlp("ps", "ps", "ax", "-w", NULL);
	printf("Can't find ps! - We got problems!\n");
	exit(-1);
    case -1:
	return -4;
    }
    /* We are ignoring the status. Hopefully everything went ok. */
    wait(&status);
    close(td);

    tmpfile = fopen(tmpname, "r");
    if (!tmpfile)
	return -1;


    fseek(tmpfile, 0, SEEK_END);
    fsize = ftell(tmpfile);
    if (fsize == 0)
	return -3;
    buffer = g_malloc0(fsize);
    fseek(tmpfile, 0, SEEK_SET);
    fread(buffer, fsize, 1, tmpfile);

    /* some extra bytes */

    name1 = g_malloc0(strlen(name) + 10);
    name2 = g_malloc0(strlen(name) + 10);
    name3 = g_malloc0(strlen(name) + 10);
    name4 = g_malloc0(strlen(name) + 10);


    g_snprintf(name1,strlen(name)+9, " %s\n", name);
    g_snprintf(name2,strlen(name)+9, "/%s\n", name);
    g_snprintf(name3,strlen(name)+9, " %s ", name);
    g_snprintf(name4,strlen(name)+9, "/%s ", name);

    for (i = 0; i < fsize; i++) {
	if (buffer[i] == name1[k1]) {
	    k1++;
	    if (strlen(name1) == k1)
		break;
	} else
	    k1 = 0;

	if (buffer[i] == name2[k2]) {
	    k2++;
	    if (strlen(name2) == k2)
		break;
	} else
	    k2 = 0;

	if (buffer[i] == name3[k3]) {
	    k3++;
	    if (strlen(name3) == k3)
		break;
	} else
	    k3 = 0;

	if (buffer[i] == name4[k4]) {
	    k4++;
	    if (strlen(name4) == k4)
		break;
	} else
	    k4 = 0;


    }

    fclose(tmpfile);
    unlink(tmpname);
    g_free(buffer);
    g_free(name1);
    g_free(name2);
    g_free(name3);
    g_free(name4);


    if (i != fsize)
	return 1;
    return 0;
}

void status_error(int status)
{
    if (status == -1)
	printf("\nCan't open temporary file!\n");
    if (status == -2)
	printf
	    ("\nProblems with creating temporary file. Is /tmp writable?\n");
    if (status == -3)
	printf
	    ("\nSize of temporary file is zero bytes. Problemes with ps?\n");
    if (status == -4)
	printf("\nCan't fork! - I don't know why.\n");
    printf
	("I carry on, assuimg that enlightenment is NOT used as window manager\n");
}

/* This routine tries to detect broken window managers. 
   Broken:
   - Enlightenment, fvwm2(assume fvwm is broken), twm & Sawfish.

   Working:
   - Waimea & blackbox

   Not tested:
   Afterstep, windowmaker, icewm, & kde (Some missed?)

*/

int detect_brokenwm()
{
    int status;

    status = checkfor("enlightenment");
    if (status)
	return 1;
    if (status < 0)
	status_error(status);


    status = checkfor("sawfish");
    if (status)
	return 2;
    if (status < 0)
	status_error(status);

    status = checkfor("twm");
    if (status)
	return 3;
    if (status < 0)
	status_error(status);


    status = checkfor("fvwm");
    if (status)
	return 4;
    if (status < 0)
	status_error(status);

    status = checkfor("fvwm2");
    if (status)
	return 5;
    if (status < 0)
	status_error(status);

    return 0;

}
