/* SavedSearchDBTable.c generated by valac 0.34.4, the Vala compiler
 * generated from SavedSearchDBTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>
#include <gee.h>
#include <sqlite3.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SAVED_SEARCH_ID (saved_search_id_get_type ())
typedef struct _SavedSearchID SavedSearchID;

#define TYPE_SAVED_SEARCH_ROW (saved_search_row_get_type ())
#define SAVED_SEARCH_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SAVED_SEARCH_ROW, SavedSearchRow))
#define SAVED_SEARCH_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SAVED_SEARCH_ROW, SavedSearchRowClass))
#define IS_SAVED_SEARCH_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SAVED_SEARCH_ROW))
#define IS_SAVED_SEARCH_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SAVED_SEARCH_ROW))
#define SAVED_SEARCH_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SAVED_SEARCH_ROW, SavedSearchRowClass))

typedef struct _SavedSearchRow SavedSearchRow;
typedef struct _SavedSearchRowClass SavedSearchRowClass;
typedef struct _SavedSearchRowPrivate SavedSearchRowPrivate;

#define TYPE_SEARCH_OPERATOR (search_operator_get_type ())

#define TYPE_SEARCH_CONDITION (search_condition_get_type ())
#define SEARCH_CONDITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION, SearchCondition))
#define SEARCH_CONDITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION, SearchConditionClass))
#define IS_SEARCH_CONDITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION))
#define IS_SEARCH_CONDITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION))
#define SEARCH_CONDITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION, SearchConditionClass))

typedef struct _SearchCondition SearchCondition;
typedef struct _SearchConditionClass SearchConditionClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecSavedSearchRow ParamSpecSavedSearchRow;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define TYPE_SAVED_SEARCH_DB_TABLE (saved_search_db_table_get_type ())
#define SAVED_SEARCH_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SAVED_SEARCH_DB_TABLE, SavedSearchDBTable))
#define SAVED_SEARCH_DB_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SAVED_SEARCH_DB_TABLE, SavedSearchDBTableClass))
#define IS_SAVED_SEARCH_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SAVED_SEARCH_DB_TABLE))
#define IS_SAVED_SEARCH_DB_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SAVED_SEARCH_DB_TABLE))
#define SAVED_SEARCH_DB_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SAVED_SEARCH_DB_TABLE, SavedSearchDBTableClass))

typedef struct _SavedSearchDBTable SavedSearchDBTable;
typedef struct _SavedSearchDBTableClass SavedSearchDBTableClass;
typedef struct _SavedSearchDBTablePrivate SavedSearchDBTablePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _search_condition_unref0(var) ((var == NULL) ? NULL : (var = (search_condition_unref (var), NULL)))
#define _saved_search_row_unref0(var) ((var == NULL) ? NULL : (var = (saved_search_row_unref (var), NULL)))

#define TYPE_SEARCH_CONDITION_TEXT (search_condition_text_get_type ())
#define SEARCH_CONDITION_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_TEXT, SearchConditionText))
#define SEARCH_CONDITION_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_TEXT, SearchConditionTextClass))
#define IS_SEARCH_CONDITION_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_TEXT))
#define IS_SEARCH_CONDITION_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_TEXT))
#define SEARCH_CONDITION_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_TEXT, SearchConditionTextClass))

typedef struct _SearchConditionText SearchConditionText;
typedef struct _SearchConditionTextClass SearchConditionTextClass;

#define SEARCH_CONDITION_TYPE_SEARCH_TYPE (search_condition_search_type_get_type ())

#define SEARCH_CONDITION_TEXT_TYPE_CONTEXT (search_condition_text_context_get_type ())

#define TYPE_SEARCH_CONDITION_MEDIA_TYPE (search_condition_media_type_get_type ())
#define SEARCH_CONDITION_MEDIA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaType))
#define SEARCH_CONDITION_MEDIA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaTypeClass))
#define IS_SEARCH_CONDITION_MEDIA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_MEDIA_TYPE))
#define IS_SEARCH_CONDITION_MEDIA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_MEDIA_TYPE))
#define SEARCH_CONDITION_MEDIA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_MEDIA_TYPE, SearchConditionMediaTypeClass))

typedef struct _SearchConditionMediaType SearchConditionMediaType;
typedef struct _SearchConditionMediaTypeClass SearchConditionMediaTypeClass;

#define SEARCH_CONDITION_MEDIA_TYPE_TYPE_CONTEXT (search_condition_media_type_context_get_type ())

#define SEARCH_CONDITION_MEDIA_TYPE_TYPE_MEDIA_TYPE (search_condition_media_type_media_type_get_type ())

#define TYPE_SEARCH_CONDITION_FLAGGED (search_condition_flagged_get_type ())
#define SEARCH_CONDITION_FLAGGED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlagged))
#define SEARCH_CONDITION_FLAGGED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlaggedClass))
#define IS_SEARCH_CONDITION_FLAGGED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_FLAGGED))
#define IS_SEARCH_CONDITION_FLAGGED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_FLAGGED))
#define SEARCH_CONDITION_FLAGGED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_FLAGGED, SearchConditionFlaggedClass))

typedef struct _SearchConditionFlagged SearchConditionFlagged;
typedef struct _SearchConditionFlaggedClass SearchConditionFlaggedClass;

#define SEARCH_CONDITION_FLAGGED_TYPE_STATE (search_condition_flagged_state_get_type ())

#define TYPE_SEARCH_CONDITION_MODIFIED (search_condition_modified_get_type ())
#define SEARCH_CONDITION_MODIFIED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModified))
#define SEARCH_CONDITION_MODIFIED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModifiedClass))
#define IS_SEARCH_CONDITION_MODIFIED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_MODIFIED))
#define IS_SEARCH_CONDITION_MODIFIED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_MODIFIED))
#define SEARCH_CONDITION_MODIFIED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_MODIFIED, SearchConditionModifiedClass))

typedef struct _SearchConditionModified SearchConditionModified;
typedef struct _SearchConditionModifiedClass SearchConditionModifiedClass;

#define SEARCH_CONDITION_MODIFIED_TYPE_CONTEXT (search_condition_modified_context_get_type ())

#define SEARCH_CONDITION_MODIFIED_TYPE_STATE (search_condition_modified_state_get_type ())

#define TYPE_SEARCH_CONDITION_RATING (search_condition_rating_get_type ())
#define SEARCH_CONDITION_RATING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_RATING, SearchConditionRating))
#define SEARCH_CONDITION_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_RATING, SearchConditionRatingClass))
#define IS_SEARCH_CONDITION_RATING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_RATING))
#define IS_SEARCH_CONDITION_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_RATING))
#define SEARCH_CONDITION_RATING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_RATING, SearchConditionRatingClass))

typedef struct _SearchConditionRating SearchConditionRating;
typedef struct _SearchConditionRatingClass SearchConditionRatingClass;

#define TYPE_RATING (rating_get_type ())

#define SEARCH_CONDITION_RATING_TYPE_CONTEXT (search_condition_rating_context_get_type ())

#define TYPE_SEARCH_CONDITION_DATE (search_condition_date_get_type ())
#define SEARCH_CONDITION_DATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_CONDITION_DATE, SearchConditionDate))
#define SEARCH_CONDITION_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_CONDITION_DATE, SearchConditionDateClass))
#define IS_SEARCH_CONDITION_DATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_CONDITION_DATE))
#define IS_SEARCH_CONDITION_DATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_CONDITION_DATE))
#define SEARCH_CONDITION_DATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_CONDITION_DATE, SearchConditionDateClass))

typedef struct _SearchConditionDate SearchConditionDate;
typedef struct _SearchConditionDateClass SearchConditionDateClass;

#define SEARCH_CONDITION_DATE_TYPE_CONTEXT (search_condition_date_context_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SavedSearchID {
	gint64 id;
};

typedef enum  {
	SEARCH_OPERATOR_ANY = 0,
	SEARCH_OPERATOR_ALL,
	SEARCH_OPERATOR_NONE
} SearchOperator;

struct _SavedSearchRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SavedSearchRowPrivate * priv;
	SavedSearchID search_id;
	gchar* name;
	SearchOperator operator;
	GeeList* conditions;
};

struct _SavedSearchRowClass {
	GTypeClass parent_class;
	void (*finalize) (SavedSearchRow *self);
};

struct _ParamSpecSavedSearchRow {
	GParamSpec parent_instance;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _SavedSearchDBTable {
	DatabaseTable parent_instance;
	SavedSearchDBTablePrivate * priv;
};

struct _SavedSearchDBTableClass {
	DatabaseTableClass parent_class;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
typedef enum  {
	SEARCH_CONDITION_SEARCH_TYPE_ANY_TEXT = 0,
	SEARCH_CONDITION_SEARCH_TYPE_TITLE,
	SEARCH_CONDITION_SEARCH_TYPE_TAG,
	SEARCH_CONDITION_SEARCH_TYPE_EVENT_NAME,
	SEARCH_CONDITION_SEARCH_TYPE_FILE_NAME,
	SEARCH_CONDITION_SEARCH_TYPE_MEDIA_TYPE,
	SEARCH_CONDITION_SEARCH_TYPE_FLAG_STATE,
	SEARCH_CONDITION_SEARCH_TYPE_MODIFIED_STATE,
	SEARCH_CONDITION_SEARCH_TYPE_RATING,
	SEARCH_CONDITION_SEARCH_TYPE_COMMENT,
	SEARCH_CONDITION_SEARCH_TYPE_DATE
} SearchConditionSearchType;

typedef enum  {
	SEARCH_CONDITION_TEXT_CONTEXT_CONTAINS = 0,
	SEARCH_CONDITION_TEXT_CONTEXT_IS_EXACTLY,
	SEARCH_CONDITION_TEXT_CONTEXT_STARTS_WITH,
	SEARCH_CONDITION_TEXT_CONTEXT_ENDS_WITH,
	SEARCH_CONDITION_TEXT_CONTEXT_DOES_NOT_CONTAIN,
	SEARCH_CONDITION_TEXT_CONTEXT_IS_NOT_SET,
	SEARCH_CONDITION_TEXT_CONTEXT_IS_SET
} SearchConditionTextContext;

typedef enum  {
	SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS = 0,
	SEARCH_CONDITION_MEDIA_TYPE_CONTEXT_IS_NOT
} SearchConditionMediaTypeContext;

typedef enum  {
	SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_ALL = 0,
	SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_PHOTO_RAW,
	SEARCH_CONDITION_MEDIA_TYPE_MEDIA_TYPE_VIDEO
} SearchConditionMediaTypeMediaType;

typedef enum  {
	SEARCH_CONDITION_FLAGGED_STATE_FLAGGED = 0,
	SEARCH_CONDITION_FLAGGED_STATE_UNFLAGGED
} SearchConditionFlaggedState;

typedef enum  {
	SEARCH_CONDITION_MODIFIED_CONTEXT_HAS = 0,
	SEARCH_CONDITION_MODIFIED_CONTEXT_HAS_NO
} SearchConditionModifiedContext;

typedef enum  {
	SEARCH_CONDITION_MODIFIED_STATE_MODIFIED = 0,
	SEARCH_CONDITION_MODIFIED_STATE_INTERNAL_CHANGES,
	SEARCH_CONDITION_MODIFIED_STATE_EXTERNAL_CHANGES
} SearchConditionModifiedState;

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

typedef enum  {
	SEARCH_CONDITION_RATING_CONTEXT_AND_HIGHER = 0,
	SEARCH_CONDITION_RATING_CONTEXT_ONLY,
	SEARCH_CONDITION_RATING_CONTEXT_AND_LOWER
} SearchConditionRatingContext;

typedef enum  {
	SEARCH_CONDITION_DATE_CONTEXT_EXACT = 0,
	SEARCH_CONDITION_DATE_CONTEXT_AFTER,
	SEARCH_CONDITION_DATE_CONTEXT_BEFORE,
	SEARCH_CONDITION_DATE_CONTEXT_BETWEEN,
	SEARCH_CONDITION_DATE_CONTEXT_IS_NOT_SET
} SearchConditionDateContext;


static gpointer saved_search_row_parent_class = NULL;
static gpointer saved_search_db_table_parent_class = NULL;
static SavedSearchDBTable* saved_search_db_table_instance;
static SavedSearchDBTable* saved_search_db_table_instance = NULL;
extern sqlite3* database_table_db;

GType saved_search_id_get_type (void) G_GNUC_CONST;
SavedSearchID* saved_search_id_dup (const SavedSearchID* self);
void saved_search_id_free (SavedSearchID* self);
#define SAVED_SEARCH_ID_INVALID ((gint64) -1)
void saved_search_id_init (SavedSearchID *self, gint64 id);
gboolean saved_search_id_is_invalid (SavedSearchID *self);
gboolean saved_search_id_is_valid (SavedSearchID *self);
gpointer saved_search_row_ref (gpointer instance);
void saved_search_row_unref (gpointer instance);
GParamSpec* param_spec_saved_search_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_saved_search_row (GValue* value, gpointer v_object);
void value_take_saved_search_row (GValue* value, gpointer v_object);
gpointer value_get_saved_search_row (const GValue* value);
GType saved_search_row_get_type (void) G_GNUC_CONST;
GType search_operator_get_type (void) G_GNUC_CONST;
gpointer search_condition_ref (gpointer instance);
void search_condition_unref (gpointer instance);
GParamSpec* param_spec_search_condition (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_search_condition (GValue* value, gpointer v_object);
void value_take_search_condition (GValue* value, gpointer v_object);
gpointer value_get_search_condition (const GValue* value);
GType search_condition_get_type (void) G_GNUC_CONST;
enum  {
	SAVED_SEARCH_ROW_DUMMY_PROPERTY
};
SavedSearchRow* saved_search_row_new (void);
SavedSearchRow* saved_search_row_construct (GType object_type);
static void saved_search_row_finalize (SavedSearchRow* obj);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_database_table (GValue* value, gpointer v_object);
void value_take_database_table (GValue* value, gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType saved_search_db_table_get_type (void) G_GNUC_CONST;
enum  {
	SAVED_SEARCH_DB_TABLE_DUMMY_PROPERTY
};
static SavedSearchDBTable* saved_search_db_table_new (void);
static SavedSearchDBTable* saved_search_db_table_construct (GType object_type);
DatabaseTable* database_table_construct (GType object_type);
void database_table_set_table_name (DatabaseTable* self, const gchar* table_name);
void database_table_fatal (const gchar* op, gint res);
SavedSearchDBTable* saved_search_db_table_get_instance (void);
GQuark database_error_quark (void);
SavedSearchRow* saved_search_db_table_add (SavedSearchDBTable* self, const gchar* name, SearchOperator operator, GeeArrayList* conditions, GError** error);
gchar* search_operator_to_string (SearchOperator self);
void database_table_throw_error (const gchar* method, gint res, GError** error);
static void saved_search_db_table_add_condition (SavedSearchDBTable* self, SavedSearchID* id, SearchCondition* condition, GError** error);
GType search_condition_text_get_type (void) G_GNUC_CONST;
GType search_condition_search_type_get_type (void) G_GNUC_CONST;
SearchConditionSearchType search_condition_get_search_type (SearchCondition* self);
gchar* search_condition_search_type_to_string (SearchConditionSearchType self);
GType search_condition_text_context_get_type (void) G_GNUC_CONST;
SearchConditionTextContext search_condition_text_get_context (SearchConditionText* self);
gchar* search_condition_text_context_to_string (SearchConditionTextContext self);
const gchar* search_condition_text_get_text (SearchConditionText* self);
GType search_condition_media_type_get_type (void) G_GNUC_CONST;
GType search_condition_media_type_context_get_type (void) G_GNUC_CONST;
SearchConditionMediaTypeContext search_condition_media_type_get_context (SearchConditionMediaType* self);
gchar* search_condition_media_type_context_to_string (SearchConditionMediaTypeContext self);
GType search_condition_media_type_media_type_get_type (void) G_GNUC_CONST;
SearchConditionMediaTypeMediaType search_condition_media_type_get_media_type (SearchConditionMediaType* self);
gchar* search_condition_media_type_media_type_to_string (SearchConditionMediaTypeMediaType self);
GType search_condition_flagged_get_type (void) G_GNUC_CONST;
GType search_condition_flagged_state_get_type (void) G_GNUC_CONST;
SearchConditionFlaggedState search_condition_flagged_get_state (SearchConditionFlagged* self);
gchar* search_condition_flagged_state_to_string (SearchConditionFlaggedState self);
GType search_condition_modified_get_type (void) G_GNUC_CONST;
GType search_condition_modified_context_get_type (void) G_GNUC_CONST;
SearchConditionModifiedContext search_condition_modified_get_context (SearchConditionModified* self);
gchar* search_condition_modified_context_to_string (SearchConditionModifiedContext self);
GType search_condition_modified_state_get_type (void) G_GNUC_CONST;
SearchConditionModifiedState search_condition_modified_get_state (SearchConditionModified* self);
gchar* search_condition_modified_state_to_string (SearchConditionModifiedState self);
GType search_condition_rating_get_type (void) G_GNUC_CONST;
GType rating_get_type (void) G_GNUC_CONST;
Rating search_condition_rating_get_rating (SearchConditionRating* self);
gint rating_serialize (Rating self);
GType search_condition_rating_context_get_type (void) G_GNUC_CONST;
SearchConditionRatingContext search_condition_rating_get_context (SearchConditionRating* self);
gchar* search_condition_rating_context_to_string (SearchConditionRatingContext self);
GType search_condition_date_get_type (void) G_GNUC_CONST;
GType search_condition_date_context_get_type (void) G_GNUC_CONST;
SearchConditionDateContext search_condition_date_get_context (SearchConditionDate* self);
gchar* search_condition_date_context_to_string (SearchConditionDateContext self);
GDateTime* search_condition_date_get_date_one (SearchConditionDate* self);
GDateTime* search_condition_date_get_date_two (SearchConditionDate* self);
static void saved_search_db_table_remove_conditions_for_search_id (SavedSearchDBTable* self, SavedSearchID* search_id, GError** error);
static void saved_search_db_table_remove_conditions_for_table (SavedSearchDBTable* self, const gchar* table_name, SavedSearchID* search_id, GError** error);
static GeeList* saved_search_db_table_get_conditions_for_id (SavedSearchDBTable* self, SavedSearchID* search_id, GError** error);
SearchConditionSearchType search_condition_search_type_from_string (const gchar* str);
SearchConditionTextContext search_condition_text_context_from_string (const gchar* str);
SearchConditionText* search_condition_text_new (SearchConditionSearchType search_type, const gchar* text, SearchConditionTextContext context);
SearchConditionText* search_condition_text_construct (GType object_type, SearchConditionSearchType search_type, const gchar* text, SearchConditionTextContext context);
SearchConditionMediaTypeContext search_condition_media_type_context_from_string (const gchar* str);
SearchConditionMediaTypeMediaType search_condition_media_type_media_type_from_string (const gchar* str);
SearchConditionMediaType* search_condition_media_type_new (SearchConditionSearchType search_type, SearchConditionMediaTypeContext context, SearchConditionMediaTypeMediaType media_type);
SearchConditionMediaType* search_condition_media_type_construct (GType object_type, SearchConditionSearchType search_type, SearchConditionMediaTypeContext context, SearchConditionMediaTypeMediaType media_type);
SearchConditionFlaggedState search_condition_flagged_state_from_string (const gchar* str);
SearchConditionFlagged* search_condition_flagged_new (SearchConditionSearchType search_type, SearchConditionFlaggedState state);
SearchConditionFlagged* search_condition_flagged_construct (GType object_type, SearchConditionSearchType search_type, SearchConditionFlaggedState state);
SearchConditionModifiedContext search_condition_modified_context_from_string (const gchar* str);
SearchConditionModifiedState search_condition_modified_state_from_string (const gchar* str);
SearchConditionModified* search_condition_modified_new (SearchConditionSearchType search_type, SearchConditionModifiedContext context, SearchConditionModifiedState state);
SearchConditionModified* search_condition_modified_construct (GType object_type, SearchConditionSearchType search_type, SearchConditionModifiedContext context, SearchConditionModifiedState state);
Rating rating_unserialize (gint value);
SearchConditionRatingContext search_condition_rating_context_from_string (const gchar* str);
SearchConditionRating* search_condition_rating_new (SearchConditionSearchType search_type, Rating rating, SearchConditionRatingContext context);
SearchConditionRating* search_condition_rating_construct (GType object_type, SearchConditionSearchType search_type, Rating rating, SearchConditionRatingContext context);
SearchConditionDateContext search_condition_date_context_from_string (const gchar* str);
SearchConditionDate* search_condition_date_new (SearchConditionSearchType search_type, SearchConditionDateContext context, GDateTime* date_one, GDateTime* date_two);
SearchConditionDate* search_condition_date_construct (GType object_type, SearchConditionSearchType search_type, SearchConditionDateContext context, GDateTime* date_one, GDateTime* date_two);
void saved_search_db_table_create_from_row (SavedSearchDBTable* self, SavedSearchRow* row, SavedSearchID* result, GError** error);
void saved_search_db_table_remove (SavedSearchDBTable* self, SavedSearchID* search_id, GError** error);
void database_table_delete_by_id (DatabaseTable* self, gint64 id, GError** error);
SavedSearchRow* saved_search_db_table_get_row (SavedSearchDBTable* self, SavedSearchID* search_id, GError** error);
SearchOperator search_operator_from_string (const gchar* str);
GeeList* saved_search_db_table_get_all_rows (SavedSearchDBTable* self, GError** error);
void saved_search_db_table_rename (SavedSearchDBTable* self, SavedSearchID* search_id, const gchar* new_name, GError** error);
void database_table_update_text_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, const gchar* text, GError** error);
static void saved_search_db_table_finalize (DatabaseTable* obj);


void saved_search_id_init (SavedSearchID *self, gint64 id) {
	gint64 _tmp0_ = 0LL;
#line 12 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	memset (self, 0, sizeof (SavedSearchID));
#line 13 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = id;
#line 13 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	(*self).id = _tmp0_;
#line 434 "SavedSearchDBTable.c"
}


gboolean saved_search_id_is_invalid (SavedSearchID *self) {
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
#line 17 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = (*self).id;
#line 17 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	result = _tmp0_ == SAVED_SEARCH_ID_INVALID;
#line 17 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return result;
#line 447 "SavedSearchDBTable.c"
}


gboolean saved_search_id_is_valid (SavedSearchID *self) {
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
#line 21 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = (*self).id;
#line 21 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	result = _tmp0_ != SAVED_SEARCH_ID_INVALID;
#line 21 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return result;
#line 460 "SavedSearchDBTable.c"
}


SavedSearchID* saved_search_id_dup (const SavedSearchID* self) {
	SavedSearchID* dup;
#line 7 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	dup = g_new0 (SavedSearchID, 1);
#line 7 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	memcpy (dup, self, sizeof (SavedSearchID));
#line 7 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return dup;
#line 472 "SavedSearchDBTable.c"
}


void saved_search_id_free (SavedSearchID* self) {
#line 7 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_free (self);
#line 479 "SavedSearchDBTable.c"
}


GType saved_search_id_get_type (void) {
	static volatile gsize saved_search_id_type_id__volatile = 0;
	if (g_once_init_enter (&saved_search_id_type_id__volatile)) {
		GType saved_search_id_type_id;
		saved_search_id_type_id = g_boxed_type_register_static ("SavedSearchID", (GBoxedCopyFunc) saved_search_id_dup, (GBoxedFreeFunc) saved_search_id_free);
		g_once_init_leave (&saved_search_id_type_id__volatile, saved_search_id_type_id);
	}
	return saved_search_id_type_id__volatile;
}


SavedSearchRow* saved_search_row_construct (GType object_type) {
	SavedSearchRow* self = NULL;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	self = (SavedSearchRow*) g_type_create_instance (object_type);
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return self;
#line 500 "SavedSearchDBTable.c"
}


SavedSearchRow* saved_search_row_new (void) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return saved_search_row_construct (TYPE_SAVED_SEARCH_ROW);
#line 507 "SavedSearchDBTable.c"
}


static void value_saved_search_row_init (GValue* value) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	value->data[0].v_pointer = NULL;
#line 514 "SavedSearchDBTable.c"
}


static void value_saved_search_row_free_value (GValue* value) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (value->data[0].v_pointer) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		saved_search_row_unref (value->data[0].v_pointer);
#line 523 "SavedSearchDBTable.c"
	}
}


static void value_saved_search_row_copy_value (const GValue* src_value, GValue* dest_value) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (src_value->data[0].v_pointer) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		dest_value->data[0].v_pointer = saved_search_row_ref (src_value->data[0].v_pointer);
#line 533 "SavedSearchDBTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		dest_value->data[0].v_pointer = NULL;
#line 537 "SavedSearchDBTable.c"
	}
}


static gpointer value_saved_search_row_peek_pointer (const GValue* value) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return value->data[0].v_pointer;
#line 545 "SavedSearchDBTable.c"
}


static gchar* value_saved_search_row_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (collect_values[0].v_pointer) {
#line 552 "SavedSearchDBTable.c"
		SavedSearchRow* object;
		object = collect_values[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (object->parent_instance.g_class == NULL) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 559 "SavedSearchDBTable.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 563 "SavedSearchDBTable.c"
		}
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		value->data[0].v_pointer = saved_search_row_ref (object);
#line 567 "SavedSearchDBTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		value->data[0].v_pointer = NULL;
#line 571 "SavedSearchDBTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return NULL;
#line 575 "SavedSearchDBTable.c"
}


static gchar* value_saved_search_row_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SavedSearchRow** object_p;
	object_p = collect_values[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (!object_p) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 586 "SavedSearchDBTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (!value->data[0].v_pointer) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		*object_p = NULL;
#line 592 "SavedSearchDBTable.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		*object_p = value->data[0].v_pointer;
#line 596 "SavedSearchDBTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		*object_p = saved_search_row_ref (value->data[0].v_pointer);
#line 600 "SavedSearchDBTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return NULL;
#line 604 "SavedSearchDBTable.c"
}


GParamSpec* param_spec_saved_search_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecSavedSearchRow* spec;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SAVED_SEARCH_ROW), NULL);
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return G_PARAM_SPEC (spec);
#line 618 "SavedSearchDBTable.c"
}


gpointer value_get_saved_search_row (const GValue* value) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_ROW), NULL);
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return value->data[0].v_pointer;
#line 627 "SavedSearchDBTable.c"
}


void value_set_saved_search_row (GValue* value, gpointer v_object) {
	SavedSearchRow* old;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	old = value->data[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (v_object) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SAVED_SEARCH_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		value->data[0].v_pointer = v_object;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		saved_search_row_ref (value->data[0].v_pointer);
#line 647 "SavedSearchDBTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		value->data[0].v_pointer = NULL;
#line 651 "SavedSearchDBTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (old) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		saved_search_row_unref (old);
#line 657 "SavedSearchDBTable.c"
	}
}


void value_take_saved_search_row (GValue* value, gpointer v_object) {
	SavedSearchRow* old;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SAVED_SEARCH_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	old = value->data[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (v_object) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SAVED_SEARCH_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		value->data[0].v_pointer = v_object;
#line 676 "SavedSearchDBTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		value->data[0].v_pointer = NULL;
#line 680 "SavedSearchDBTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (old) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		saved_search_row_unref (old);
#line 686 "SavedSearchDBTable.c"
	}
}


static void saved_search_row_class_init (SavedSearchRowClass * klass) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_row_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	((SavedSearchRowClass *) klass)->finalize = saved_search_row_finalize;
#line 696 "SavedSearchDBTable.c"
}


static void saved_search_row_instance_init (SavedSearchRow * self) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	self->ref_count = 1;
#line 703 "SavedSearchDBTable.c"
}


static void saved_search_row_finalize (SavedSearchRow* obj) {
	SavedSearchRow * self;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SAVED_SEARCH_ROW, SavedSearchRow);
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_signal_handlers_destroy (self);
#line 28 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_g_free0 (self->name);
#line 30 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_g_object_unref0 (self->conditions);
#line 717 "SavedSearchDBTable.c"
}


GType saved_search_row_get_type (void) {
	static volatile gsize saved_search_row_type_id__volatile = 0;
	if (g_once_init_enter (&saved_search_row_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_saved_search_row_init, value_saved_search_row_free_value, value_saved_search_row_copy_value, value_saved_search_row_peek_pointer, "p", value_saved_search_row_collect_value, "p", value_saved_search_row_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SavedSearchRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) saved_search_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SavedSearchRow), 0, (GInstanceInitFunc) saved_search_row_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType saved_search_row_type_id;
		saved_search_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SavedSearchRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&saved_search_row_type_id__volatile, saved_search_row_type_id);
	}
	return saved_search_row_type_id__volatile;
}


gpointer saved_search_row_ref (gpointer instance) {
	SavedSearchRow* self;
	self = instance;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_atomic_int_inc (&self->ref_count);
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return instance;
#line 742 "SavedSearchDBTable.c"
}


void saved_search_row_unref (gpointer instance) {
	SavedSearchRow* self;
	self = instance;
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		SAVED_SEARCH_ROW_GET_CLASS (self)->finalize (self);
#line 25 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 755 "SavedSearchDBTable.c"
	}
}


static SavedSearchDBTable* saved_search_db_table_construct (GType object_type) {
	SavedSearchDBTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	sqlite3* _tmp8_ = NULL;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	sqlite3* _tmp16_ = NULL;
	sqlite3_stmt* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	sqlite3_stmt* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	sqlite3* _tmp24_ = NULL;
	sqlite3_stmt* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	sqlite3_stmt* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	sqlite3* _tmp32_ = NULL;
	sqlite3_stmt* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	sqlite3_stmt* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	sqlite3* _tmp40_ = NULL;
	sqlite3_stmt* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	sqlite3_stmt* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	sqlite3* _tmp48_ = NULL;
	sqlite3_stmt* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
	sqlite3_stmt* _tmp52_ = NULL;
	gint _tmp53_ = 0;
	gint _tmp54_ = 0;
	sqlite3* _tmp56_ = NULL;
	sqlite3_stmt* _tmp57_ = NULL;
	gint _tmp58_ = 0;
	gint _tmp59_ = 0;
	sqlite3_stmt* _tmp60_ = NULL;
	gint _tmp61_ = 0;
	gint _tmp62_ = 0;
	sqlite3* _tmp64_ = NULL;
	sqlite3_stmt* _tmp65_ = NULL;
	gint _tmp66_ = 0;
	gint _tmp67_ = 0;
	sqlite3_stmt* _tmp68_ = NULL;
	gint _tmp69_ = 0;
	gint _tmp70_ = 0;
	sqlite3* _tmp72_ = NULL;
	sqlite3_stmt* _tmp73_ = NULL;
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	sqlite3_stmt* _tmp76_ = NULL;
	gint _tmp77_ = 0;
	gint _tmp78_ = 0;
	sqlite3* _tmp80_ = NULL;
	sqlite3_stmt* _tmp81_ = NULL;
	gint _tmp82_ = 0;
	gint _tmp83_ = 0;
	sqlite3_stmt* _tmp84_ = NULL;
	gint _tmp85_ = 0;
	gint _tmp86_ = 0;
	sqlite3* _tmp88_ = NULL;
	sqlite3_stmt* _tmp89_ = NULL;
	gint _tmp90_ = 0;
	gint _tmp91_ = 0;
	sqlite3_stmt* _tmp92_ = NULL;
	gint _tmp93_ = 0;
	gint _tmp94_ = 0;
	sqlite3* _tmp96_ = NULL;
	sqlite3_stmt* _tmp97_ = NULL;
	gint _tmp98_ = 0;
	gint _tmp99_ = 0;
	sqlite3_stmt* _tmp100_ = NULL;
	gint _tmp101_ = 0;
	gint _tmp102_ = 0;
#line 36 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	self = (SavedSearchDBTable*) database_table_construct (object_type);
#line 37 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	database_table_set_table_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), "SavedSearchDBTable");
#line 41 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = database_table_db;
#line 41 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable " "(" "id INTEGER PRIMARY KEY, " "name TEXT UNIQUE NOT NULL, " "operator TEXT NOT NULL" ")", -1, &_tmp1_, NULL);
#line 41 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 41 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp1_;
#line 41 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp2_;
#line 48 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp3_ = res;
#line 48 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 50 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp4_ = stmt;
#line 50 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp5_ = sqlite3_step (_tmp4_);
#line 50 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp5_;
#line 51 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp6_ = res;
#line 51 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp6_ != SQLITE_DONE) {
#line 883 "SavedSearchDBTable.c"
		gint _tmp7_ = 0;
#line 52 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp7_ = res;
#line 52 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable", _tmp7_);
#line 889 "SavedSearchDBTable.c"
	}
#line 55 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp8_ = database_table_db;
#line 55 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp10_ = sqlite3_prepare_v2 (_tmp8_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_Text " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "context TEXT NOT NULL, " "text TEXT" ")", -1, &_tmp9_, NULL);
#line 55 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 55 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp9_;
#line 55 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp10_;
#line 64 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp11_ = res;
#line 64 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 66 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp12_ = stmt;
#line 66 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp13_ = sqlite3_step (_tmp12_);
#line 66 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp13_;
#line 67 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp14_ = res;
#line 67 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp14_ != SQLITE_DONE) {
#line 915 "SavedSearchDBTable.c"
		gint _tmp15_ = 0;
#line 68 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp15_ = res;
#line 68 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Text", _tmp15_);
#line 921 "SavedSearchDBTable.c"
	}
#line 71 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp16_ = database_table_db;
#line 71 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp18_ = sqlite3_prepare_v2 (_tmp16_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_MediaType " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "context TEXT NOT NULL, " "type TEXT NOT_NULL" ")", -1, &_tmp17_, NULL);
#line 71 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 71 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp17_;
#line 71 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp18_;
#line 80 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp19_ = res;
#line 80 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp19_ == SQLITE_OK, "res == Sqlite.OK");
#line 82 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp20_ = stmt;
#line 82 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp21_ = sqlite3_step (_tmp20_);
#line 82 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp21_;
#line 83 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp22_ = res;
#line 83 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp22_ != SQLITE_DONE) {
#line 947 "SavedSearchDBTable.c"
		gint _tmp23_ = 0;
#line 84 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp23_ = res;
#line 84 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_MediaType", _tmp23_);
#line 953 "SavedSearchDBTable.c"
	}
#line 87 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp24_ = database_table_db;
#line 87 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp26_ = sqlite3_prepare_v2 (_tmp24_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_Flagged " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "flag_state TEXT NOT NULL" ")", -1, &_tmp25_, NULL);
#line 87 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 87 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp25_;
#line 87 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp26_;
#line 95 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp27_ = res;
#line 95 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp27_ == SQLITE_OK, "res == Sqlite.OK");
#line 97 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp28_ = stmt;
#line 97 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp29_ = sqlite3_step (_tmp28_);
#line 97 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp29_;
#line 98 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp30_ = res;
#line 98 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp30_ != SQLITE_DONE) {
#line 979 "SavedSearchDBTable.c"
		gint _tmp31_ = 0;
#line 99 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp31_ = res;
#line 99 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Flagged", _tmp31_);
#line 985 "SavedSearchDBTable.c"
	}
#line 102 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp32_ = database_table_db;
#line 102 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp34_ = sqlite3_prepare_v2 (_tmp32_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_Modified " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "context TEXT NOT NULL, " "modified_state TEXT NOT NULL" ")", -1, &_tmp33_, NULL);
#line 102 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 102 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp33_;
#line 102 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp34_;
#line 111 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp35_ = res;
#line 111 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp35_ == SQLITE_OK, "res == Sqlite.OK");
#line 113 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp36_ = stmt;
#line 113 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp37_ = sqlite3_step (_tmp36_);
#line 113 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp37_;
#line 114 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp38_ = res;
#line 114 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp38_ != SQLITE_DONE) {
#line 1011 "SavedSearchDBTable.c"
		gint _tmp39_ = 0;
#line 115 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp39_ = res;
#line 115 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Modified", _tmp39_);
#line 1017 "SavedSearchDBTable.c"
	}
#line 118 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp40_ = database_table_db;
#line 118 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp42_ = sqlite3_prepare_v2 (_tmp40_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_Rating " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "rating INTEGER NOT_NULL, " "context TEXT NOT NULL" ")", -1, &_tmp41_, NULL);
#line 118 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 118 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp41_;
#line 118 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp42_;
#line 127 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp43_ = res;
#line 127 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp43_ == SQLITE_OK, "res == Sqlite.OK");
#line 129 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp44_ = stmt;
#line 129 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp45_ = sqlite3_step (_tmp44_);
#line 129 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp45_;
#line 130 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp46_ = res;
#line 130 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp46_ != SQLITE_DONE) {
#line 1043 "SavedSearchDBTable.c"
		gint _tmp47_ = 0;
#line 131 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp47_ = res;
#line 131 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Rating", _tmp47_);
#line 1049 "SavedSearchDBTable.c"
	}
#line 134 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp48_ = database_table_db;
#line 134 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp50_ = sqlite3_prepare_v2 (_tmp48_, "CREATE TABLE IF NOT EXISTS " "SavedSearchDBTable_Date " "(" "id INTEGER PRIMARY KEY, " "search_id INTEGER NOT NULL, " "search_type TEXT NOT NULL, " "context TEXT NOT NULL, " "date_one INTEGER NOT_NULL, " "date_two INTEGER NOT_NULL" ")", -1, &_tmp49_, NULL);
#line 134 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 134 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp49_;
#line 134 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp50_;
#line 144 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp51_ = res;
#line 144 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp51_ == SQLITE_OK, "res == Sqlite.OK");
#line 146 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp52_ = stmt;
#line 146 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp53_ = sqlite3_step (_tmp52_);
#line 146 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp53_;
#line 147 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp54_ = res;
#line 147 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp54_ != SQLITE_DONE) {
#line 1075 "SavedSearchDBTable.c"
		gint _tmp55_ = 0;
#line 148 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp55_ = res;
#line 148 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Rating", _tmp55_);
#line 1081 "SavedSearchDBTable.c"
	}
#line 151 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp56_ = database_table_db;
#line 151 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp58_ = sqlite3_prepare_v2 (_tmp56_, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_Text_Index " "ON SavedSearchDBTable_Text(search_id)", -1, &_tmp57_, NULL);
#line 151 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 151 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp57_;
#line 151 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp58_;
#line 154 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp59_ = res;
#line 154 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp59_ == SQLITE_OK, "res == Sqlite.OK");
#line 155 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp60_ = stmt;
#line 155 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp61_ = sqlite3_step (_tmp60_);
#line 155 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp61_;
#line 156 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp62_ = res;
#line 156 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp62_ != SQLITE_DONE) {
#line 1107 "SavedSearchDBTable.c"
		gint _tmp63_ = 0;
#line 157 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp63_ = res;
#line 157 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Text_Index", _tmp63_);
#line 1113 "SavedSearchDBTable.c"
	}
#line 159 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp64_ = database_table_db;
#line 159 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp66_ = sqlite3_prepare_v2 (_tmp64_, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_MediaType_Index " "ON SavedSearchDBTable_MediaType(search_id)", -1, &_tmp65_, NULL);
#line 159 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 159 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp65_;
#line 159 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp66_;
#line 162 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp67_ = res;
#line 162 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp67_ == SQLITE_OK, "res == Sqlite.OK");
#line 163 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp68_ = stmt;
#line 163 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp69_ = sqlite3_step (_tmp68_);
#line 163 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp69_;
#line 164 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp70_ = res;
#line 164 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp70_ != SQLITE_DONE) {
#line 1139 "SavedSearchDBTable.c"
		gint _tmp71_ = 0;
#line 165 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp71_ = res;
#line 165 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_MediaType_Index", _tmp71_);
#line 1145 "SavedSearchDBTable.c"
	}
#line 167 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp72_ = database_table_db;
#line 167 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp74_ = sqlite3_prepare_v2 (_tmp72_, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_Flagged_Index " "ON SavedSearchDBTable_Flagged(search_id)", -1, &_tmp73_, NULL);
#line 167 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 167 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp73_;
#line 167 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp74_;
#line 170 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp75_ = res;
#line 170 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp75_ == SQLITE_OK, "res == Sqlite.OK");
#line 171 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp76_ = stmt;
#line 171 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp77_ = sqlite3_step (_tmp76_);
#line 171 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp77_;
#line 172 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp78_ = res;
#line 172 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp78_ != SQLITE_DONE) {
#line 1171 "SavedSearchDBTable.c"
		gint _tmp79_ = 0;
#line 173 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp79_ = res;
#line 173 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Flagged_Index", _tmp79_);
#line 1177 "SavedSearchDBTable.c"
	}
#line 175 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp80_ = database_table_db;
#line 175 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp82_ = sqlite3_prepare_v2 (_tmp80_, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_Modified_Index " "ON SavedSearchDBTable_Modified(search_id)", -1, &_tmp81_, NULL);
#line 175 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 175 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp81_;
#line 175 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp82_;
#line 178 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp83_ = res;
#line 178 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp83_ == SQLITE_OK, "res == Sqlite.OK");
#line 179 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp84_ = stmt;
#line 179 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp85_ = sqlite3_step (_tmp84_);
#line 179 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp85_;
#line 180 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp86_ = res;
#line 180 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp86_ != SQLITE_DONE) {
#line 1203 "SavedSearchDBTable.c"
		gint _tmp87_ = 0;
#line 181 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp87_ = res;
#line 181 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Modified_Index", _tmp87_);
#line 1209 "SavedSearchDBTable.c"
	}
#line 183 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp88_ = database_table_db;
#line 183 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp90_ = sqlite3_prepare_v2 (_tmp88_, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_Rating_Index " "ON SavedSearchDBTable_Rating(search_id)", -1, &_tmp89_, NULL);
#line 183 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 183 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp89_;
#line 183 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp90_;
#line 186 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp91_ = res;
#line 186 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp91_ == SQLITE_OK, "res == Sqlite.OK");
#line 187 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp92_ = stmt;
#line 187 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp93_ = sqlite3_step (_tmp92_);
#line 187 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp93_;
#line 188 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp94_ = res;
#line 188 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp94_ != SQLITE_DONE) {
#line 1235 "SavedSearchDBTable.c"
		gint _tmp95_ = 0;
#line 189 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp95_ = res;
#line 189 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Rating_Index", _tmp95_);
#line 1241 "SavedSearchDBTable.c"
	}
#line 191 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp96_ = database_table_db;
#line 191 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp98_ = sqlite3_prepare_v2 (_tmp96_, "CREATE INDEX IF NOT EXISTS " "SavedSearchDBTable_Date_Index " "ON SavedSearchDBTable_Date(search_id)", -1, &_tmp97_, NULL);
#line 191 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 191 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp97_;
#line 191 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp98_;
#line 194 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp99_ = res;
#line 194 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp99_ == SQLITE_OK, "res == Sqlite.OK");
#line 195 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp100_ = stmt;
#line 195 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp101_ = sqlite3_step (_tmp100_);
#line 195 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp101_;
#line 196 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp102_ = res;
#line 196 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp102_ != SQLITE_DONE) {
#line 1267 "SavedSearchDBTable.c"
		gint _tmp103_ = 0;
#line 197 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp103_ = res;
#line 197 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_fatal ("create SavedSearchDBTable_Date_Index", _tmp103_);
#line 1273 "SavedSearchDBTable.c"
	}
#line 36 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 36 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return self;
#line 1279 "SavedSearchDBTable.c"
}


static SavedSearchDBTable* saved_search_db_table_new (void) {
#line 36 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return saved_search_db_table_construct (TYPE_SAVED_SEARCH_DB_TABLE);
#line 1286 "SavedSearchDBTable.c"
}


static gpointer _database_table_ref0 (gpointer self) {
#line 204 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return self ? database_table_ref (self) : NULL;
#line 1293 "SavedSearchDBTable.c"
}


SavedSearchDBTable* saved_search_db_table_get_instance (void) {
	SavedSearchDBTable* result = NULL;
	SavedSearchDBTable* _tmp0_ = NULL;
	SavedSearchDBTable* _tmp2_ = NULL;
	SavedSearchDBTable* _tmp3_ = NULL;
#line 201 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = saved_search_db_table_instance;
#line 201 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp0_ == NULL) {
#line 1306 "SavedSearchDBTable.c"
		SavedSearchDBTable* _tmp1_ = NULL;
#line 202 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp1_ = saved_search_db_table_new ();
#line 202 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_database_table_unref0 (saved_search_db_table_instance);
#line 202 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		saved_search_db_table_instance = _tmp1_;
#line 1314 "SavedSearchDBTable.c"
	}
#line 204 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp2_ = saved_search_db_table_instance;
#line 204 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp3_ = _database_table_ref0 (_tmp2_);
#line 204 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	result = _tmp3_;
#line 204 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return result;
#line 1324 "SavedSearchDBTable.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 227 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return self ? g_object_ref (self) : NULL;
#line 1331 "SavedSearchDBTable.c"
}


SavedSearchRow* saved_search_db_table_add (SavedSearchDBTable* self, const gchar* name, SearchOperator operator, GeeArrayList* conditions, GError** error) {
	SavedSearchRow* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GDestroyNotify _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	sqlite3_stmt* _tmp10_ = NULL;
	SearchOperator _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	GDestroyNotify _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	sqlite3_stmt* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	SavedSearchRow* row = NULL;
	SavedSearchRow* _tmp20_ = NULL;
	SavedSearchRow* _tmp21_ = NULL;
	sqlite3* _tmp22_ = NULL;
	gint64 _tmp23_ = 0LL;
	SavedSearchRow* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	SavedSearchRow* _tmp27_ = NULL;
	SearchOperator _tmp28_ = 0;
	SavedSearchRow* _tmp29_ = NULL;
	GeeArrayList* _tmp30_ = NULL;
	GeeList* _tmp31_ = NULL;
	GError * _inner_error_ = NULL;
#line 207 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (IS_SAVED_SEARCH_DB_TABLE (self), NULL);
#line 207 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 207 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (GEE_IS_ARRAY_LIST (conditions), NULL);
#line 210 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = database_table_db;
#line 210 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO SavedSearchDBTable (name, operator) VALUES (?, ?)", -1, &_tmp1_, NULL);
#line 210 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 210 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp1_;
#line 210 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp2_;
#line 212 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp3_ = res;
#line 212 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 214 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp4_ = stmt;
#line 214 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp5_ = name;
#line 214 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 214 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp7_ = g_free;
#line 214 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp8_ = sqlite3_bind_text (_tmp4_, 1, _tmp6_, -1, _tmp7_);
#line 214 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp8_;
#line 215 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp9_ = res;
#line 215 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp9_ == SQLITE_OK, "res == Sqlite.OK");
#line 216 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp10_ = stmt;
#line 216 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp11_ = operator;
#line 216 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp12_ = search_operator_to_string (_tmp11_);
#line 216 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp13_ = g_free;
#line 216 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp14_ = sqlite3_bind_text (_tmp10_, 2, _tmp12_, -1, _tmp13_);
#line 216 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp14_;
#line 217 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp15_ = res;
#line 217 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp15_ == SQLITE_OK, "res == Sqlite.OK");
#line 219 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp16_ = stmt;
#line 219 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp17_ = sqlite3_step (_tmp16_);
#line 219 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp17_;
#line 220 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp18_ = res;
#line 220 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp18_ != SQLITE_DONE) {
#line 1434 "SavedSearchDBTable.c"
		gint _tmp19_ = 0;
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp19_ = res;
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_throw_error ("SavedSearchDBTable.add", _tmp19_, &_inner_error_);
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				g_propagate_error (error, _inner_error_);
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_sqlite3_finalize0 (stmt);
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				return NULL;
#line 1450 "SavedSearchDBTable.c"
			} else {
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_sqlite3_finalize0 (stmt);
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				g_clear_error (&_inner_error_);
#line 221 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				return NULL;
#line 1460 "SavedSearchDBTable.c"
			}
		}
	}
#line 223 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp20_ = saved_search_row_new ();
#line 223 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	row = _tmp20_;
#line 224 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp21_ = row;
#line 224 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp22_ = database_table_db;
#line 224 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp23_ = sqlite3_last_insert_rowid (_tmp22_);
#line 224 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_id_init (&_tmp21_->search_id, _tmp23_);
#line 225 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp24_ = row;
#line 225 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp25_ = name;
#line 225 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp26_ = g_strdup (_tmp25_);
#line 225 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_g_free0 (_tmp24_->name);
#line 225 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp24_->name = _tmp26_;
#line 226 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp27_ = row;
#line 226 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp28_ = operator;
#line 226 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp27_->operator = _tmp28_;
#line 227 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp29_ = row;
#line 227 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp30_ = conditions;
#line 227 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_LIST, GeeList));
#line 227 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_g_object_unref0 (_tmp29_->conditions);
#line 227 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp29_->conditions = _tmp31_;
#line 1502 "SavedSearchDBTable.c"
	{
		GeeArrayList* _sc_list = NULL;
		GeeArrayList* _tmp32_ = NULL;
		GeeArrayList* _tmp33_ = NULL;
		gint _sc_size = 0;
		GeeArrayList* _tmp34_ = NULL;
		gint _tmp35_ = 0;
		gint _tmp36_ = 0;
		gint _sc_index = 0;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp32_ = conditions;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp33_ = _g_object_ref0 (_tmp32_);
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_sc_list = _tmp33_;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp34_ = _sc_list;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp35_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_COLLECTION, GeeCollection));
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp36_ = _tmp35_;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_sc_size = _tmp36_;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_sc_index = -1;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		while (TRUE) {
#line 1530 "SavedSearchDBTable.c"
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
			gint _tmp39_ = 0;
			SearchCondition* sc = NULL;
			GeeArrayList* _tmp40_ = NULL;
			gint _tmp41_ = 0;
			gpointer _tmp42_ = NULL;
			SavedSearchRow* _tmp43_ = NULL;
			SavedSearchID _tmp44_ = {0};
			SearchCondition* _tmp45_ = NULL;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp37_ = _sc_index;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_sc_index = _tmp37_ + 1;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp38_ = _sc_index;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp39_ = _sc_size;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (!(_tmp38_ < _tmp39_)) {
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				break;
#line 1553 "SavedSearchDBTable.c"
			}
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp40_ = _sc_list;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp41_ = _sc_index;
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp42_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp41_);
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			sc = (SearchCondition*) _tmp42_;
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp43_ = row;
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp44_ = _tmp43_->search_id;
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp45_ = sc;
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			saved_search_db_table_add_condition (self, &_tmp44_, _tmp45_, &_inner_error_);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_propagate_error (error, _inner_error_);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_search_condition_unref0 (sc);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_g_object_unref0 (_sc_list);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_saved_search_row_unref0 (row);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return NULL;
#line 1587 "SavedSearchDBTable.c"
				} else {
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_search_condition_unref0 (sc);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_g_object_unref0 (_sc_list);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_saved_search_row_unref0 (row);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_clear_error (&_inner_error_);
#line 230 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return NULL;
#line 1603 "SavedSearchDBTable.c"
				}
			}
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_search_condition_unref0 (sc);
#line 1608 "SavedSearchDBTable.c"
		}
#line 229 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_g_object_unref0 (_sc_list);
#line 1612 "SavedSearchDBTable.c"
	}
#line 233 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	result = row;
#line 233 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 233 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return result;
#line 1620 "SavedSearchDBTable.c"
}


static gpointer _search_condition_ref0 (gpointer self) {
#line 238 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return self ? search_condition_ref (self) : NULL;
#line 1627 "SavedSearchDBTable.c"
}


static void saved_search_db_table_add_condition (SavedSearchDBTable* self, SavedSearchID* id, SearchCondition* condition, GError** error) {
	SearchCondition* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
#line 236 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (IS_SAVED_SEARCH_DB_TABLE (self));
#line 236 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (id != NULL);
#line 236 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (IS_SEARCH_CONDITION (condition));
#line 237 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = condition;
#line 237 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_SEARCH_CONDITION_TEXT)) {
#line 1644 "SavedSearchDBTable.c"
		SearchConditionText* text = NULL;
		SearchCondition* _tmp1_ = NULL;
		SearchConditionText* _tmp2_ = NULL;
		sqlite3_stmt* stmt = NULL;
		gint res = 0;
		sqlite3* _tmp3_ = NULL;
		sqlite3_stmt* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		sqlite3_stmt* _tmp7_ = NULL;
		SavedSearchID _tmp8_ = {0};
		gint64 _tmp9_ = 0LL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		sqlite3_stmt* _tmp12_ = NULL;
		SearchConditionText* _tmp13_ = NULL;
		SearchConditionSearchType _tmp14_ = 0;
		SearchConditionSearchType _tmp15_ = 0;
		gchar* _tmp16_ = NULL;
		GDestroyNotify _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		sqlite3_stmt* _tmp20_ = NULL;
		SearchConditionText* _tmp21_ = NULL;
		SearchConditionTextContext _tmp22_ = 0;
		SearchConditionTextContext _tmp23_ = 0;
		gchar* _tmp24_ = NULL;
		GDestroyNotify _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		sqlite3_stmt* _tmp28_ = NULL;
		SearchConditionText* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		GDestroyNotify _tmp33_ = NULL;
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		sqlite3_stmt* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
#line 238 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp1_ = condition;
#line 238 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp2_ = _search_condition_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, TYPE_SEARCH_CONDITION_TEXT) ? ((SearchConditionText*) _tmp1_) : NULL);
#line 238 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		text = _tmp2_;
#line 240 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp3_ = database_table_db;
#line 240 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp5_ = sqlite3_prepare_v2 (_tmp3_, "INSERT INTO SavedSearchDBTable_Text (search_id, search_type, context, " "text) VALUES (?, ?, ?, ?)", -1, &_tmp4_, NULL);
#line 240 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_sqlite3_finalize0 (stmt);
#line 240 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		stmt = _tmp4_;
#line 240 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		res = _tmp5_;
#line 243 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp6_ = res;
#line 243 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_vala_assert (_tmp6_ == SQLITE_OK, "res == Sqlite.OK");
#line 245 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp7_ = stmt;
#line 245 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp8_ = *id;
#line 245 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp9_ = _tmp8_.id;
#line 245 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp10_ = sqlite3_bind_int64 (_tmp7_, 1, _tmp9_);
#line 245 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		res = _tmp10_;
#line 246 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp11_ = res;
#line 246 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 248 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp12_ = stmt;
#line 248 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp13_ = text;
#line 248 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp14_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 248 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp15_ = _tmp14_;
#line 248 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp16_ = search_condition_search_type_to_string (_tmp15_);
#line 248 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp17_ = g_free;
#line 248 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp18_ = sqlite3_bind_text (_tmp12_, 2, _tmp16_, -1, _tmp17_);
#line 248 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		res = _tmp18_;
#line 249 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp19_ = res;
#line 249 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_vala_assert (_tmp19_ == SQLITE_OK, "res == Sqlite.OK");
#line 251 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp20_ = stmt;
#line 251 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp21_ = text;
#line 251 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp22_ = search_condition_text_get_context (_tmp21_);
#line 251 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp23_ = _tmp22_;
#line 251 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp24_ = search_condition_text_context_to_string (_tmp23_);
#line 251 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp25_ = g_free;
#line 251 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp26_ = sqlite3_bind_text (_tmp20_, 3, _tmp24_, -1, _tmp25_);
#line 251 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		res = _tmp26_;
#line 252 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp27_ = res;
#line 252 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_vala_assert (_tmp27_ == SQLITE_OK, "res == Sqlite.OK");
#line 254 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp28_ = stmt;
#line 254 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp29_ = text;
#line 254 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp30_ = search_condition_text_get_text (_tmp29_);
#line 254 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp31_ = _tmp30_;
#line 254 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp32_ = g_strdup (_tmp31_);
#line 254 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp33_ = g_free;
#line 254 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp34_ = sqlite3_bind_text (_tmp28_, 4, _tmp32_, -1, _tmp33_);
#line 254 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		res = _tmp34_;
#line 255 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp35_ = res;
#line 255 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_vala_assert (_tmp35_ == SQLITE_OK, "res == Sqlite.OK");
#line 257 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp36_ = stmt;
#line 257 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp37_ = sqlite3_step (_tmp36_);
#line 257 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		res = _tmp37_;
#line 258 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp38_ = res;
#line 258 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_tmp38_ != SQLITE_DONE) {
#line 1790 "SavedSearchDBTable.c"
			gint _tmp39_ = 0;
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp39_ = res;
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			database_table_throw_error ("SavedSearchDBTable_Text.add", _tmp39_, &_inner_error_);
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_propagate_error (error, _inner_error_);
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_search_condition_unref0 (text);
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return;
#line 1808 "SavedSearchDBTable.c"
				} else {
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_search_condition_unref0 (text);
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_clear_error (&_inner_error_);
#line 259 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return;
#line 1820 "SavedSearchDBTable.c"
				}
			}
		}
#line 237 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_sqlite3_finalize0 (stmt);
#line 237 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_search_condition_unref0 (text);
#line 1828 "SavedSearchDBTable.c"
	} else {
		SearchCondition* _tmp40_ = NULL;
#line 260 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp40_ = condition;
#line 260 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, TYPE_SEARCH_CONDITION_MEDIA_TYPE)) {
#line 1835 "SavedSearchDBTable.c"
			SearchConditionMediaType* media_type = NULL;
			SearchCondition* _tmp41_ = NULL;
			SearchConditionMediaType* _tmp42_ = NULL;
			sqlite3_stmt* stmt = NULL;
			gint res = 0;
			sqlite3* _tmp43_ = NULL;
			sqlite3_stmt* _tmp44_ = NULL;
			gint _tmp45_ = 0;
			gint _tmp46_ = 0;
			sqlite3_stmt* _tmp47_ = NULL;
			SavedSearchID _tmp48_ = {0};
			gint64 _tmp49_ = 0LL;
			gint _tmp50_ = 0;
			gint _tmp51_ = 0;
			sqlite3_stmt* _tmp52_ = NULL;
			SearchConditionMediaType* _tmp53_ = NULL;
			SearchConditionSearchType _tmp54_ = 0;
			SearchConditionSearchType _tmp55_ = 0;
			gchar* _tmp56_ = NULL;
			GDestroyNotify _tmp57_ = NULL;
			gint _tmp58_ = 0;
			gint _tmp59_ = 0;
			sqlite3_stmt* _tmp60_ = NULL;
			SearchConditionMediaType* _tmp61_ = NULL;
			SearchConditionMediaTypeContext _tmp62_ = 0;
			SearchConditionMediaTypeContext _tmp63_ = 0;
			gchar* _tmp64_ = NULL;
			GDestroyNotify _tmp65_ = NULL;
			gint _tmp66_ = 0;
			gint _tmp67_ = 0;
			sqlite3_stmt* _tmp68_ = NULL;
			SearchConditionMediaType* _tmp69_ = NULL;
			SearchConditionMediaTypeMediaType _tmp70_ = 0;
			SearchConditionMediaTypeMediaType _tmp71_ = 0;
			gchar* _tmp72_ = NULL;
			GDestroyNotify _tmp73_ = NULL;
			gint _tmp74_ = 0;
			gint _tmp75_ = 0;
			sqlite3_stmt* _tmp76_ = NULL;
			gint _tmp77_ = 0;
			gint _tmp78_ = 0;
#line 261 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp41_ = condition;
#line 261 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp42_ = _search_condition_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, TYPE_SEARCH_CONDITION_MEDIA_TYPE) ? ((SearchConditionMediaType*) _tmp41_) : NULL);
#line 261 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			media_type = _tmp42_;
#line 263 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp43_ = database_table_db;
#line 263 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp45_ = sqlite3_prepare_v2 (_tmp43_, "INSERT INTO SavedSearchDBTable_MediaType (search_id, search_type, cont" \
"ext, " "type) VALUES (?, ?, ?, ?)", -1, &_tmp44_, NULL);
#line 263 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_sqlite3_finalize0 (stmt);
#line 263 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			stmt = _tmp44_;
#line 263 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = _tmp45_;
#line 266 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp46_ = res;
#line 266 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_vala_assert (_tmp46_ == SQLITE_OK, "res == Sqlite.OK");
#line 268 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp47_ = stmt;
#line 268 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp48_ = *id;
#line 268 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp49_ = _tmp48_.id;
#line 268 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp50_ = sqlite3_bind_int64 (_tmp47_, 1, _tmp49_);
#line 268 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = _tmp50_;
#line 269 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp51_ = res;
#line 269 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_vala_assert (_tmp51_ == SQLITE_OK, "res == Sqlite.OK");
#line 271 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp52_ = stmt;
#line 271 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp53_ = media_type;
#line 271 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp54_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 271 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp55_ = _tmp54_;
#line 271 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp56_ = search_condition_search_type_to_string (_tmp55_);
#line 271 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp57_ = g_free;
#line 271 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp58_ = sqlite3_bind_text (_tmp52_, 2, _tmp56_, -1, _tmp57_);
#line 271 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = _tmp58_;
#line 272 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp59_ = res;
#line 272 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_vala_assert (_tmp59_ == SQLITE_OK, "res == Sqlite.OK");
#line 274 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp60_ = stmt;
#line 274 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp61_ = media_type;
#line 274 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp62_ = search_condition_media_type_get_context (_tmp61_);
#line 274 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp63_ = _tmp62_;
#line 274 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp64_ = search_condition_media_type_context_to_string (_tmp63_);
#line 274 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp65_ = g_free;
#line 274 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp66_ = sqlite3_bind_text (_tmp60_, 3, _tmp64_, -1, _tmp65_);
#line 274 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = _tmp66_;
#line 275 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp67_ = res;
#line 275 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_vala_assert (_tmp67_ == SQLITE_OK, "res == Sqlite.OK");
#line 277 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp68_ = stmt;
#line 277 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp69_ = media_type;
#line 277 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp70_ = search_condition_media_type_get_media_type (_tmp69_);
#line 277 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp71_ = _tmp70_;
#line 277 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp72_ = search_condition_media_type_media_type_to_string (_tmp71_);
#line 277 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp73_ = g_free;
#line 277 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp74_ = sqlite3_bind_text (_tmp68_, 4, _tmp72_, -1, _tmp73_);
#line 277 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = _tmp74_;
#line 278 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp75_ = res;
#line 278 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_vala_assert (_tmp75_ == SQLITE_OK, "res == Sqlite.OK");
#line 280 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp76_ = stmt;
#line 280 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp77_ = sqlite3_step (_tmp76_);
#line 280 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = _tmp77_;
#line 281 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp78_ = res;
#line 281 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_tmp78_ != SQLITE_DONE) {
#line 1981 "SavedSearchDBTable.c"
				gint _tmp79_ = 0;
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp79_ = res;
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				database_table_throw_error ("SavedSearchDBTable_MediaType.add", _tmp79_, &_inner_error_);
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (_inner_error_->domain == DATABASE_ERROR) {
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						g_propagate_error (error, _inner_error_);
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_sqlite3_finalize0 (stmt);
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_search_condition_unref0 (media_type);
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						return;
#line 1999 "SavedSearchDBTable.c"
					} else {
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_sqlite3_finalize0 (stmt);
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_search_condition_unref0 (media_type);
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						g_clear_error (&_inner_error_);
#line 282 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						return;
#line 2011 "SavedSearchDBTable.c"
					}
				}
			}
#line 260 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_sqlite3_finalize0 (stmt);
#line 260 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_search_condition_unref0 (media_type);
#line 2019 "SavedSearchDBTable.c"
		} else {
			SearchCondition* _tmp80_ = NULL;
#line 283 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp80_ = condition;
#line 283 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp80_, TYPE_SEARCH_CONDITION_FLAGGED)) {
#line 2026 "SavedSearchDBTable.c"
				SearchConditionFlagged* flag_state = NULL;
				SearchCondition* _tmp81_ = NULL;
				SearchConditionFlagged* _tmp82_ = NULL;
				sqlite3_stmt* stmt = NULL;
				gint res = 0;
				sqlite3* _tmp83_ = NULL;
				sqlite3_stmt* _tmp84_ = NULL;
				gint _tmp85_ = 0;
				gint _tmp86_ = 0;
				sqlite3_stmt* _tmp87_ = NULL;
				SavedSearchID _tmp88_ = {0};
				gint64 _tmp89_ = 0LL;
				gint _tmp90_ = 0;
				gint _tmp91_ = 0;
				sqlite3_stmt* _tmp92_ = NULL;
				SearchConditionFlagged* _tmp93_ = NULL;
				SearchConditionSearchType _tmp94_ = 0;
				SearchConditionSearchType _tmp95_ = 0;
				gchar* _tmp96_ = NULL;
				GDestroyNotify _tmp97_ = NULL;
				gint _tmp98_ = 0;
				gint _tmp99_ = 0;
				sqlite3_stmt* _tmp100_ = NULL;
				SearchConditionFlagged* _tmp101_ = NULL;
				SearchConditionFlaggedState _tmp102_ = 0;
				SearchConditionFlaggedState _tmp103_ = 0;
				gchar* _tmp104_ = NULL;
				GDestroyNotify _tmp105_ = NULL;
				gint _tmp106_ = 0;
				gint _tmp107_ = 0;
				sqlite3_stmt* _tmp108_ = NULL;
				gint _tmp109_ = 0;
				gint _tmp110_ = 0;
#line 284 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp81_ = condition;
#line 284 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp82_ = _search_condition_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp81_, TYPE_SEARCH_CONDITION_FLAGGED) ? ((SearchConditionFlagged*) _tmp81_) : NULL);
#line 284 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				flag_state = _tmp82_;
#line 286 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp83_ = database_table_db;
#line 286 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp85_ = sqlite3_prepare_v2 (_tmp83_, "INSERT INTO SavedSearchDBTable_Flagged (search_id, search_type, " "flag_state) VALUES (?, ?, ?)", -1, &_tmp84_, NULL);
#line 286 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_sqlite3_finalize0 (stmt);
#line 286 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				stmt = _tmp84_;
#line 286 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				res = _tmp85_;
#line 289 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp86_ = res;
#line 289 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_vala_assert (_tmp86_ == SQLITE_OK, "res == Sqlite.OK");
#line 291 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp87_ = stmt;
#line 291 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp88_ = *id;
#line 291 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp89_ = _tmp88_.id;
#line 291 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp90_ = sqlite3_bind_int64 (_tmp87_, 1, _tmp89_);
#line 291 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				res = _tmp90_;
#line 292 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp91_ = res;
#line 292 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_vala_assert (_tmp91_ == SQLITE_OK, "res == Sqlite.OK");
#line 294 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp92_ = stmt;
#line 294 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp93_ = flag_state;
#line 294 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp94_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 294 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp95_ = _tmp94_;
#line 294 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp96_ = search_condition_search_type_to_string (_tmp95_);
#line 294 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp97_ = g_free;
#line 294 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp98_ = sqlite3_bind_text (_tmp92_, 2, _tmp96_, -1, _tmp97_);
#line 294 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				res = _tmp98_;
#line 295 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp99_ = res;
#line 295 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_vala_assert (_tmp99_ == SQLITE_OK, "res == Sqlite.OK");
#line 297 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp100_ = stmt;
#line 297 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp101_ = flag_state;
#line 297 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp102_ = search_condition_flagged_get_state (_tmp101_);
#line 297 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp103_ = _tmp102_;
#line 297 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp104_ = search_condition_flagged_state_to_string (_tmp103_);
#line 297 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp105_ = g_free;
#line 297 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp106_ = sqlite3_bind_text (_tmp100_, 3, _tmp104_, -1, _tmp105_);
#line 297 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				res = _tmp106_;
#line 298 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp107_ = res;
#line 298 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_vala_assert (_tmp107_ == SQLITE_OK, "res == Sqlite.OK");
#line 300 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp108_ = stmt;
#line 300 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp109_ = sqlite3_step (_tmp108_);
#line 300 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				res = _tmp109_;
#line 301 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp110_ = res;
#line 301 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_tmp110_ != SQLITE_DONE) {
#line 2144 "SavedSearchDBTable.c"
					gint _tmp111_ = 0;
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp111_ = res;
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					database_table_throw_error ("SavedSearchDBTable_Flagged.add", _tmp111_, &_inner_error_);
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_propagate_error (error, _inner_error_);
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_search_condition_unref0 (flag_state);
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return;
#line 2162 "SavedSearchDBTable.c"
						} else {
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_search_condition_unref0 (flag_state);
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_clear_error (&_inner_error_);
#line 302 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return;
#line 2174 "SavedSearchDBTable.c"
						}
					}
				}
#line 283 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_sqlite3_finalize0 (stmt);
#line 283 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_search_condition_unref0 (flag_state);
#line 2182 "SavedSearchDBTable.c"
			} else {
				SearchCondition* _tmp112_ = NULL;
#line 303 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp112_ = condition;
#line 303 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp112_, TYPE_SEARCH_CONDITION_MODIFIED)) {
#line 2189 "SavedSearchDBTable.c"
					SearchConditionModified* modified_state = NULL;
					SearchCondition* _tmp113_ = NULL;
					SearchConditionModified* _tmp114_ = NULL;
					sqlite3_stmt* stmt = NULL;
					gint res = 0;
					sqlite3* _tmp115_ = NULL;
					sqlite3_stmt* _tmp116_ = NULL;
					gint _tmp117_ = 0;
					gint _tmp118_ = 0;
					sqlite3_stmt* _tmp119_ = NULL;
					SavedSearchID _tmp120_ = {0};
					gint64 _tmp121_ = 0LL;
					gint _tmp122_ = 0;
					gint _tmp123_ = 0;
					sqlite3_stmt* _tmp124_ = NULL;
					SearchConditionModified* _tmp125_ = NULL;
					SearchConditionSearchType _tmp126_ = 0;
					SearchConditionSearchType _tmp127_ = 0;
					gchar* _tmp128_ = NULL;
					GDestroyNotify _tmp129_ = NULL;
					gint _tmp130_ = 0;
					gint _tmp131_ = 0;
					sqlite3_stmt* _tmp132_ = NULL;
					SearchConditionModified* _tmp133_ = NULL;
					SearchConditionModifiedContext _tmp134_ = 0;
					SearchConditionModifiedContext _tmp135_ = 0;
					gchar* _tmp136_ = NULL;
					GDestroyNotify _tmp137_ = NULL;
					gint _tmp138_ = 0;
					gint _tmp139_ = 0;
					sqlite3_stmt* _tmp140_ = NULL;
					SearchConditionModified* _tmp141_ = NULL;
					SearchConditionModifiedState _tmp142_ = 0;
					SearchConditionModifiedState _tmp143_ = 0;
					gchar* _tmp144_ = NULL;
					GDestroyNotify _tmp145_ = NULL;
					gint _tmp146_ = 0;
					gint _tmp147_ = 0;
					sqlite3_stmt* _tmp148_ = NULL;
					gint _tmp149_ = 0;
					gint _tmp150_ = 0;
#line 304 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp113_ = condition;
#line 304 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp114_ = _search_condition_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp113_, TYPE_SEARCH_CONDITION_MODIFIED) ? ((SearchConditionModified*) _tmp113_) : NULL);
#line 304 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					modified_state = _tmp114_;
#line 306 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp115_ = database_table_db;
#line 306 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp117_ = sqlite3_prepare_v2 (_tmp115_, "INSERT INTO SavedSearchDBTable_Modified (search_id, search_type, conte" \
"xt, " "modified_state) VALUES (?, ?, ?, ?)", -1, &_tmp116_, NULL);
#line 306 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 306 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					stmt = _tmp116_;
#line 306 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					res = _tmp117_;
#line 309 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp118_ = res;
#line 309 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_vala_assert (_tmp118_ == SQLITE_OK, "res == Sqlite.OK");
#line 311 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp119_ = stmt;
#line 311 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp120_ = *id;
#line 311 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp121_ = _tmp120_.id;
#line 311 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp122_ = sqlite3_bind_int64 (_tmp119_, 1, _tmp121_);
#line 311 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					res = _tmp122_;
#line 312 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp123_ = res;
#line 312 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_vala_assert (_tmp123_ == SQLITE_OK, "res == Sqlite.OK");
#line 314 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp124_ = stmt;
#line 314 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp125_ = modified_state;
#line 314 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp126_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 314 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp127_ = _tmp126_;
#line 314 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp128_ = search_condition_search_type_to_string (_tmp127_);
#line 314 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp129_ = g_free;
#line 314 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp130_ = sqlite3_bind_text (_tmp124_, 2, _tmp128_, -1, _tmp129_);
#line 314 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					res = _tmp130_;
#line 315 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp131_ = res;
#line 315 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_vala_assert (_tmp131_ == SQLITE_OK, "res == Sqlite.OK");
#line 317 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp132_ = stmt;
#line 317 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp133_ = modified_state;
#line 317 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp134_ = search_condition_modified_get_context (_tmp133_);
#line 317 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp135_ = _tmp134_;
#line 317 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp136_ = search_condition_modified_context_to_string (_tmp135_);
#line 317 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp137_ = g_free;
#line 317 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp138_ = sqlite3_bind_text (_tmp132_, 3, _tmp136_, -1, _tmp137_);
#line 317 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					res = _tmp138_;
#line 318 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp139_ = res;
#line 318 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_vala_assert (_tmp139_ == SQLITE_OK, "res == Sqlite.OK");
#line 320 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp140_ = stmt;
#line 320 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp141_ = modified_state;
#line 320 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp142_ = search_condition_modified_get_state (_tmp141_);
#line 320 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp143_ = _tmp142_;
#line 320 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp144_ = search_condition_modified_state_to_string (_tmp143_);
#line 320 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp145_ = g_free;
#line 320 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp146_ = sqlite3_bind_text (_tmp140_, 4, _tmp144_, -1, _tmp145_);
#line 320 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					res = _tmp146_;
#line 321 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp147_ = res;
#line 321 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_vala_assert (_tmp147_ == SQLITE_OK, "res == Sqlite.OK");
#line 323 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp148_ = stmt;
#line 323 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp149_ = sqlite3_step (_tmp148_);
#line 323 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					res = _tmp149_;
#line 324 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp150_ = res;
#line 324 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (_tmp150_ != SQLITE_DONE) {
#line 2335 "SavedSearchDBTable.c"
						gint _tmp151_ = 0;
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp151_ = res;
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						database_table_throw_error ("SavedSearchDBTable_Modified.add", _tmp151_, &_inner_error_);
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							if (_inner_error_->domain == DATABASE_ERROR) {
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								g_propagate_error (error, _inner_error_);
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								_sqlite3_finalize0 (stmt);
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								_search_condition_unref0 (modified_state);
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								return;
#line 2353 "SavedSearchDBTable.c"
							} else {
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								_sqlite3_finalize0 (stmt);
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								_search_condition_unref0 (modified_state);
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								g_clear_error (&_inner_error_);
#line 325 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								return;
#line 2365 "SavedSearchDBTable.c"
							}
						}
					}
#line 303 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 303 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_search_condition_unref0 (modified_state);
#line 2373 "SavedSearchDBTable.c"
				} else {
					SearchCondition* _tmp152_ = NULL;
#line 326 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp152_ = condition;
#line 326 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp152_, TYPE_SEARCH_CONDITION_RATING)) {
#line 2380 "SavedSearchDBTable.c"
						SearchConditionRating* rating = NULL;
						SearchCondition* _tmp153_ = NULL;
						SearchConditionRating* _tmp154_ = NULL;
						sqlite3_stmt* stmt = NULL;
						gint res = 0;
						sqlite3* _tmp155_ = NULL;
						sqlite3_stmt* _tmp156_ = NULL;
						gint _tmp157_ = 0;
						gint _tmp158_ = 0;
						sqlite3_stmt* _tmp159_ = NULL;
						SavedSearchID _tmp160_ = {0};
						gint64 _tmp161_ = 0LL;
						gint _tmp162_ = 0;
						gint _tmp163_ = 0;
						sqlite3_stmt* _tmp164_ = NULL;
						SearchConditionRating* _tmp165_ = NULL;
						SearchConditionSearchType _tmp166_ = 0;
						SearchConditionSearchType _tmp167_ = 0;
						gchar* _tmp168_ = NULL;
						GDestroyNotify _tmp169_ = NULL;
						gint _tmp170_ = 0;
						gint _tmp171_ = 0;
						sqlite3_stmt* _tmp172_ = NULL;
						SearchConditionRating* _tmp173_ = NULL;
						Rating _tmp174_ = 0;
						Rating _tmp175_ = 0;
						gint _tmp176_ = 0;
						gint _tmp177_ = 0;
						gint _tmp178_ = 0;
						sqlite3_stmt* _tmp179_ = NULL;
						SearchConditionRating* _tmp180_ = NULL;
						SearchConditionRatingContext _tmp181_ = 0;
						SearchConditionRatingContext _tmp182_ = 0;
						gchar* _tmp183_ = NULL;
						GDestroyNotify _tmp184_ = NULL;
						gint _tmp185_ = 0;
						gint _tmp186_ = 0;
						sqlite3_stmt* _tmp187_ = NULL;
						gint _tmp188_ = 0;
						gint _tmp189_ = 0;
#line 327 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp153_ = condition;
#line 327 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp154_ = _search_condition_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp153_, TYPE_SEARCH_CONDITION_RATING) ? ((SearchConditionRating*) _tmp153_) : NULL);
#line 327 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						rating = _tmp154_;
#line 329 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp155_ = database_table_db;
#line 329 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp157_ = sqlite3_prepare_v2 (_tmp155_, "INSERT INTO SavedSearchDBTable_Rating (search_id, search_type, rating," \
" " "context) VALUES (?, ?, ?, ?)", -1, &_tmp156_, NULL);
#line 329 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_sqlite3_finalize0 (stmt);
#line 329 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						stmt = _tmp156_;
#line 329 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						res = _tmp157_;
#line 332 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp158_ = res;
#line 332 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_vala_assert (_tmp158_ == SQLITE_OK, "res == Sqlite.OK");
#line 334 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp159_ = stmt;
#line 334 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp160_ = *id;
#line 334 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp161_ = _tmp160_.id;
#line 334 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp162_ = sqlite3_bind_int64 (_tmp159_, 1, _tmp161_);
#line 334 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						res = _tmp162_;
#line 335 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp163_ = res;
#line 335 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_vala_assert (_tmp163_ == SQLITE_OK, "res == Sqlite.OK");
#line 337 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp164_ = stmt;
#line 337 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp165_ = rating;
#line 337 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp166_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp165_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 337 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp167_ = _tmp166_;
#line 337 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp168_ = search_condition_search_type_to_string (_tmp167_);
#line 337 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp169_ = g_free;
#line 337 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp170_ = sqlite3_bind_text (_tmp164_, 2, _tmp168_, -1, _tmp169_);
#line 337 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						res = _tmp170_;
#line 338 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp171_ = res;
#line 338 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_vala_assert (_tmp171_ == SQLITE_OK, "res == Sqlite.OK");
#line 340 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp172_ = stmt;
#line 340 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp173_ = rating;
#line 340 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp174_ = search_condition_rating_get_rating (_tmp173_);
#line 340 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp175_ = _tmp174_;
#line 340 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp176_ = rating_serialize (_tmp175_);
#line 340 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp177_ = sqlite3_bind_int (_tmp172_, 3, _tmp176_);
#line 340 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						res = _tmp177_;
#line 341 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp178_ = res;
#line 341 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_vala_assert (_tmp178_ == SQLITE_OK, "res == Sqlite.OK");
#line 343 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp179_ = stmt;
#line 343 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp180_ = rating;
#line 343 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp181_ = search_condition_rating_get_context (_tmp180_);
#line 343 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp182_ = _tmp181_;
#line 343 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp183_ = search_condition_rating_context_to_string (_tmp182_);
#line 343 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp184_ = g_free;
#line 343 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp185_ = sqlite3_bind_text (_tmp179_, 4, _tmp183_, -1, _tmp184_);
#line 343 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						res = _tmp185_;
#line 344 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp186_ = res;
#line 344 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_vala_assert (_tmp186_ == SQLITE_OK, "res == Sqlite.OK");
#line 346 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp187_ = stmt;
#line 346 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp188_ = sqlite3_step (_tmp187_);
#line 346 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						res = _tmp188_;
#line 347 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp189_ = res;
#line 347 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (_tmp189_ != SQLITE_DONE) {
#line 2523 "SavedSearchDBTable.c"
							gint _tmp190_ = 0;
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp190_ = res;
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							database_table_throw_error ("SavedSearchDBTable_Rating.add", _tmp190_, &_inner_error_);
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								if (_inner_error_->domain == DATABASE_ERROR) {
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									g_propagate_error (error, _inner_error_);
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									_sqlite3_finalize0 (stmt);
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									_search_condition_unref0 (rating);
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									return;
#line 2541 "SavedSearchDBTable.c"
								} else {
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									_sqlite3_finalize0 (stmt);
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									_search_condition_unref0 (rating);
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									g_clear_error (&_inner_error_);
#line 348 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									return;
#line 2553 "SavedSearchDBTable.c"
								}
							}
						}
#line 326 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_sqlite3_finalize0 (stmt);
#line 326 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_search_condition_unref0 (rating);
#line 2561 "SavedSearchDBTable.c"
					} else {
						SearchCondition* _tmp191_ = NULL;
#line 349 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						_tmp191_ = condition;
#line 349 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp191_, TYPE_SEARCH_CONDITION_DATE)) {
#line 2568 "SavedSearchDBTable.c"
							SearchConditionDate* date = NULL;
							SearchCondition* _tmp192_ = NULL;
							SearchConditionDate* _tmp193_ = NULL;
							sqlite3_stmt* stmt = NULL;
							gint res = 0;
							sqlite3* _tmp194_ = NULL;
							sqlite3_stmt* _tmp195_ = NULL;
							gint _tmp196_ = 0;
							gint _tmp197_ = 0;
							sqlite3_stmt* _tmp198_ = NULL;
							SavedSearchID _tmp199_ = {0};
							gint64 _tmp200_ = 0LL;
							gint _tmp201_ = 0;
							gint _tmp202_ = 0;
							sqlite3_stmt* _tmp203_ = NULL;
							SearchConditionDate* _tmp204_ = NULL;
							SearchConditionSearchType _tmp205_ = 0;
							SearchConditionSearchType _tmp206_ = 0;
							gchar* _tmp207_ = NULL;
							GDestroyNotify _tmp208_ = NULL;
							gint _tmp209_ = 0;
							gint _tmp210_ = 0;
							sqlite3_stmt* _tmp211_ = NULL;
							SearchConditionDate* _tmp212_ = NULL;
							SearchConditionDateContext _tmp213_ = 0;
							SearchConditionDateContext _tmp214_ = 0;
							gchar* _tmp215_ = NULL;
							GDestroyNotify _tmp216_ = NULL;
							gint _tmp217_ = 0;
							gint _tmp218_ = 0;
							sqlite3_stmt* _tmp219_ = NULL;
							SearchConditionDate* _tmp220_ = NULL;
							GDateTime* _tmp221_ = NULL;
							GDateTime* _tmp222_ = NULL;
							gint64 _tmp223_ = 0LL;
							gint _tmp224_ = 0;
							gint _tmp225_ = 0;
							sqlite3_stmt* _tmp226_ = NULL;
							SearchConditionDate* _tmp227_ = NULL;
							GDateTime* _tmp228_ = NULL;
							GDateTime* _tmp229_ = NULL;
							gint64 _tmp230_ = 0LL;
							gint _tmp231_ = 0;
							gint _tmp232_ = 0;
							sqlite3_stmt* _tmp233_ = NULL;
							gint _tmp234_ = 0;
							gint _tmp235_ = 0;
#line 350 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp192_ = condition;
#line 350 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp193_ = _search_condition_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp192_, TYPE_SEARCH_CONDITION_DATE) ? ((SearchConditionDate*) _tmp192_) : NULL);
#line 350 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							date = _tmp193_;
#line 352 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp194_ = database_table_db;
#line 352 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp196_ = sqlite3_prepare_v2 (_tmp194_, "INSERT INTO SavedSearchDBTable_Date (search_id, search_type, " "context, date_one, date_two) VALUES (?, ?, ?, ?, ?)", -1, &_tmp195_, NULL);
#line 352 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 352 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							stmt = _tmp195_;
#line 352 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							res = _tmp196_;
#line 355 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp197_ = res;
#line 355 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_vala_assert (_tmp197_ == SQLITE_OK, "res == Sqlite.OK");
#line 357 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp198_ = stmt;
#line 357 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp199_ = *id;
#line 357 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp200_ = _tmp199_.id;
#line 357 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp201_ = sqlite3_bind_int64 (_tmp198_, 1, _tmp200_);
#line 357 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							res = _tmp201_;
#line 358 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp202_ = res;
#line 358 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_vala_assert (_tmp202_ == SQLITE_OK, "res == Sqlite.OK");
#line 360 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp203_ = stmt;
#line 360 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp204_ = date;
#line 360 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp205_ = search_condition_get_search_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 360 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp206_ = _tmp205_;
#line 360 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp207_ = search_condition_search_type_to_string (_tmp206_);
#line 360 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp208_ = g_free;
#line 360 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp209_ = sqlite3_bind_text (_tmp203_, 2, _tmp207_, -1, _tmp208_);
#line 360 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							res = _tmp209_;
#line 361 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp210_ = res;
#line 361 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_vala_assert (_tmp210_ == SQLITE_OK, "res == Sqlite.OK");
#line 363 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp211_ = stmt;
#line 363 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp212_ = date;
#line 363 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp213_ = search_condition_date_get_context (_tmp212_);
#line 363 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp214_ = _tmp213_;
#line 363 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp215_ = search_condition_date_context_to_string (_tmp214_);
#line 363 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp216_ = g_free;
#line 363 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp217_ = sqlite3_bind_text (_tmp211_, 3, _tmp215_, -1, _tmp216_);
#line 363 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							res = _tmp217_;
#line 364 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp218_ = res;
#line 364 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_vala_assert (_tmp218_ == SQLITE_OK, "res == Sqlite.OK");
#line 366 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp219_ = stmt;
#line 366 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp220_ = date;
#line 366 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp221_ = search_condition_date_get_date_one (_tmp220_);
#line 366 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp222_ = _tmp221_;
#line 366 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp223_ = g_date_time_to_unix (_tmp222_);
#line 366 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp224_ = sqlite3_bind_int64 (_tmp219_, 4, _tmp223_);
#line 366 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							res = _tmp224_;
#line 367 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp225_ = res;
#line 367 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_vala_assert (_tmp225_ == SQLITE_OK, "res == Sqlite.OK");
#line 369 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp226_ = stmt;
#line 369 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp227_ = date;
#line 369 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp228_ = search_condition_date_get_date_two (_tmp227_);
#line 369 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp229_ = _tmp228_;
#line 369 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp230_ = g_date_time_to_unix (_tmp229_);
#line 369 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp231_ = sqlite3_bind_int64 (_tmp226_, 5, _tmp230_);
#line 369 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							res = _tmp231_;
#line 370 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp232_ = res;
#line 370 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_vala_assert (_tmp232_ == SQLITE_OK, "res == Sqlite.OK");
#line 372 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp233_ = stmt;
#line 372 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp234_ = sqlite3_step (_tmp233_);
#line 372 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							res = _tmp234_;
#line 373 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_tmp235_ = res;
#line 373 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							if (_tmp235_ != SQLITE_DONE) {
#line 2736 "SavedSearchDBTable.c"
								gint _tmp236_ = 0;
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								_tmp236_ = res;
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								database_table_throw_error ("SavedSearchDBTable_Date.add", _tmp236_, &_inner_error_);
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
									if (_inner_error_->domain == DATABASE_ERROR) {
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
										g_propagate_error (error, _inner_error_);
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
										_sqlite3_finalize0 (stmt);
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
										_search_condition_unref0 (date);
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
										return;
#line 2754 "SavedSearchDBTable.c"
									} else {
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
										_sqlite3_finalize0 (stmt);
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
										_search_condition_unref0 (date);
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
										g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
										g_clear_error (&_inner_error_);
#line 374 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
										return;
#line 2766 "SavedSearchDBTable.c"
									}
								}
							}
#line 349 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 349 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_search_condition_unref0 (date);
#line 2774 "SavedSearchDBTable.c"
						} else {
#line 376 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_assert_not_reached ();
#line 2778 "SavedSearchDBTable.c"
						}
					}
				}
			}
		}
	}
}


static void saved_search_db_table_remove_conditions_for_search_id (SavedSearchDBTable* self, SavedSearchID* search_id, GError** error) {
	SavedSearchID _tmp0_ = {0};
	SavedSearchID _tmp1_ = {0};
	SavedSearchID _tmp2_ = {0};
	SavedSearchID _tmp3_ = {0};
	SavedSearchID _tmp4_ = {0};
	SavedSearchID _tmp5_ = {0};
	GError * _inner_error_ = NULL;
#line 381 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (IS_SAVED_SEARCH_DB_TABLE (self));
#line 381 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (search_id != NULL);
#line 382 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = *search_id;
#line 382 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_Text", &_tmp0_, &_inner_error_);
#line 382 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 382 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 382 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_propagate_error (error, _inner_error_);
#line 382 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2812 "SavedSearchDBTable.c"
		} else {
#line 382 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 382 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_clear_error (&_inner_error_);
#line 382 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2820 "SavedSearchDBTable.c"
		}
	}
#line 383 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp1_ = *search_id;
#line 383 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_MediaType", &_tmp1_, &_inner_error_);
#line 383 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 383 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 383 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_propagate_error (error, _inner_error_);
#line 383 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2835 "SavedSearchDBTable.c"
		} else {
#line 383 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 383 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_clear_error (&_inner_error_);
#line 383 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2843 "SavedSearchDBTable.c"
		}
	}
#line 384 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp2_ = *search_id;
#line 384 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_Flagged", &_tmp2_, &_inner_error_);
#line 384 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 384 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 384 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_propagate_error (error, _inner_error_);
#line 384 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2858 "SavedSearchDBTable.c"
		} else {
#line 384 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 384 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_clear_error (&_inner_error_);
#line 384 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2866 "SavedSearchDBTable.c"
		}
	}
#line 385 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp3_ = *search_id;
#line 385 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_Modified", &_tmp3_, &_inner_error_);
#line 385 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 385 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 385 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_propagate_error (error, _inner_error_);
#line 385 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2881 "SavedSearchDBTable.c"
		} else {
#line 385 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 385 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_clear_error (&_inner_error_);
#line 385 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2889 "SavedSearchDBTable.c"
		}
	}
#line 386 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp4_ = *search_id;
#line 386 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_Rating", &_tmp4_, &_inner_error_);
#line 386 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 386 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 386 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_propagate_error (error, _inner_error_);
#line 386 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2904 "SavedSearchDBTable.c"
		} else {
#line 386 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 386 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_clear_error (&_inner_error_);
#line 386 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2912 "SavedSearchDBTable.c"
		}
	}
#line 387 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp5_ = *search_id;
#line 387 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_db_table_remove_conditions_for_table (self, "SavedSearchDBTable_Date", &_tmp5_, &_inner_error_);
#line 387 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 387 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 387 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_propagate_error (error, _inner_error_);
#line 387 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2927 "SavedSearchDBTable.c"
		} else {
#line 387 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 387 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_clear_error (&_inner_error_);
#line 387 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 2935 "SavedSearchDBTable.c"
		}
	}
}


static void saved_search_db_table_remove_conditions_for_table (SavedSearchDBTable* self, const gchar* table_name, SavedSearchID* search_id, GError** error) {
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	sqlite3_stmt* _tmp8_ = NULL;
	SavedSearchID _tmp9_ = {0};
	gint64 _tmp10_ = 0LL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	sqlite3_stmt* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	GError * _inner_error_ = NULL;
#line 390 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (IS_SAVED_SEARCH_DB_TABLE (self));
#line 390 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (table_name != NULL);
#line 390 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (search_id != NULL);
#line 393 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = database_table_db;
#line 393 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp1_ = table_name;
#line 393 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp2_ = g_strdup_printf ("DELETE FROM %s WHERE search_id=?", _tmp1_);
#line 393 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp3_ = _tmp2_;
#line 393 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp5_ = sqlite3_prepare_v2 (_tmp0_, _tmp3_, -1, &_tmp4_, NULL);
#line 393 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 393 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp4_;
#line 393 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp6_ = _tmp5_;
#line 393 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_g_free0 (_tmp3_);
#line 393 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp6_;
#line 394 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp7_ = res;
#line 394 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 396 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp8_ = stmt;
#line 396 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp9_ = *search_id;
#line 396 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp10_ = _tmp9_.id;
#line 396 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp11_ = sqlite3_bind_int64 (_tmp8_, 1, _tmp10_);
#line 396 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp11_;
#line 397 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp12_ = res;
#line 397 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp12_ == SQLITE_OK, "res == Sqlite.OK");
#line 399 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp13_ = stmt;
#line 399 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp14_ = sqlite3_step (_tmp13_);
#line 399 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp14_;
#line 400 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp15_ = res;
#line 400 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp15_ != SQLITE_DONE) {
#line 3015 "SavedSearchDBTable.c"
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gint _tmp19_ = 0;
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp16_ = table_name;
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp17_ = g_strdup_printf ("%s.remove", _tmp16_);
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp18_ = _tmp17_;
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp19_ = res;
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_throw_error (_tmp18_, _tmp19_, &_inner_error_);
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_g_free0 (_tmp18_);
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				g_propagate_error (error, _inner_error_);
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_sqlite3_finalize0 (stmt);
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				return;
#line 3042 "SavedSearchDBTable.c"
			} else {
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_sqlite3_finalize0 (stmt);
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				g_clear_error (&_inner_error_);
#line 401 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				return;
#line 3052 "SavedSearchDBTable.c"
			}
		}
	}
#line 390 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 3058 "SavedSearchDBTable.c"
}


static GeeList* saved_search_db_table_get_conditions_for_id (SavedSearchDBTable* self, SavedSearchID* search_id, GError** error) {
	GeeList* result = NULL;
	GeeList* list = NULL;
	GeeArrayList* _tmp0_ = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	sqlite3_stmt* _tmp5_ = NULL;
	SavedSearchID _tmp6_ = {0};
	gint64 _tmp7_ = 0LL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	sqlite3* _tmp27_ = NULL;
	sqlite3_stmt* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	sqlite3_stmt* _tmp31_ = NULL;
	SavedSearchID _tmp32_ = {0};
	gint64 _tmp33_ = 0LL;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	sqlite3* _tmp54_ = NULL;
	sqlite3_stmt* _tmp55_ = NULL;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	sqlite3_stmt* _tmp58_ = NULL;
	SavedSearchID _tmp59_ = {0};
	gint64 _tmp60_ = 0LL;
	gint _tmp61_ = 0;
	gint _tmp62_ = 0;
	sqlite3* _tmp78_ = NULL;
	sqlite3_stmt* _tmp79_ = NULL;
	gint _tmp80_ = 0;
	gint _tmp81_ = 0;
	sqlite3_stmt* _tmp82_ = NULL;
	SavedSearchID _tmp83_ = {0};
	gint64 _tmp84_ = 0LL;
	gint _tmp85_ = 0;
	gint _tmp86_ = 0;
	sqlite3* _tmp105_ = NULL;
	sqlite3_stmt* _tmp106_ = NULL;
	gint _tmp107_ = 0;
	gint _tmp108_ = 0;
	sqlite3_stmt* _tmp109_ = NULL;
	SavedSearchID _tmp110_ = {0};
	gint64 _tmp111_ = 0LL;
	gint _tmp112_ = 0;
	gint _tmp113_ = 0;
	sqlite3* _tmp132_ = NULL;
	sqlite3_stmt* _tmp133_ = NULL;
	gint _tmp134_ = 0;
	gint _tmp135_ = 0;
	sqlite3_stmt* _tmp136_ = NULL;
	SavedSearchID _tmp137_ = {0};
	gint64 _tmp138_ = 0LL;
	gint _tmp139_ = 0;
	gint _tmp140_ = 0;
	GError * _inner_error_ = NULL;
#line 405 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (IS_SAVED_SEARCH_DB_TABLE (self), NULL);
#line 405 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (search_id != NULL, NULL);
#line 407 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = gee_array_list_new (TYPE_SEARCH_CONDITION, (GBoxedCopyFunc) search_condition_ref, search_condition_unref, NULL, NULL, NULL);
#line 407 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	list = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_LIST, GeeList);
#line 412 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp1_ = database_table_db;
#line 412 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp3_ = sqlite3_prepare_v2 (_tmp1_, "SELECT search_type, context, text FROM SavedSearchDBTable_Text " "WHERE search_id=?", -1, &_tmp2_, NULL);
#line 412 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 412 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp2_;
#line 412 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp3_;
#line 415 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp4_ = res;
#line 415 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp4_ == SQLITE_OK, "res == Sqlite.OK");
#line 417 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp5_ = stmt;
#line 417 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp6_ = *search_id;
#line 417 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp7_ = _tmp6_.id;
#line 417 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp8_ = sqlite3_bind_int64 (_tmp5_, 1, _tmp7_);
#line 417 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp8_;
#line 418 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp9_ = res;
#line 418 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp9_ == SQLITE_OK, "res == Sqlite.OK");
#line 3159 "SavedSearchDBTable.c"
	{
		gboolean _tmp10_ = FALSE;
#line 420 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp10_ = TRUE;
#line 420 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		while (TRUE) {
#line 3166 "SavedSearchDBTable.c"
			sqlite3_stmt* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			SearchConditionText* condition = NULL;
			sqlite3_stmt* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			SearchConditionSearchType _tmp18_ = 0;
			sqlite3_stmt* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			sqlite3_stmt* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			SearchConditionTextContext _tmp23_ = 0;
			SearchConditionText* _tmp24_ = NULL;
			GeeList* _tmp25_ = NULL;
			SearchConditionText* _tmp26_ = NULL;
#line 420 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (!_tmp10_) {
#line 3184 "SavedSearchDBTable.c"
			}
#line 420 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp10_ = FALSE;
#line 421 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp11_ = stmt;
#line 421 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp12_ = sqlite3_step (_tmp11_);
#line 421 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = _tmp12_;
#line 422 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp13_ = res;
#line 422 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_tmp13_ == SQLITE_DONE) {
#line 423 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				break;
#line 3200 "SavedSearchDBTable.c"
			} else {
				gint _tmp14_ = 0;
#line 424 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp14_ = res;
#line 424 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_tmp14_ != SQLITE_ROW) {
#line 3207 "SavedSearchDBTable.c"
					gint _tmp15_ = 0;
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp15_ = res;
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					database_table_throw_error ("SavedSearchDBTable_Text.get_all_rows", _tmp15_, &_inner_error_);
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_propagate_error (error, _inner_error_);
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3225 "SavedSearchDBTable.c"
						} else {
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_clear_error (&_inner_error_);
#line 425 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3237 "SavedSearchDBTable.c"
						}
					}
				}
			}
#line 427 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp16_ = stmt;
#line 427 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp17_ = sqlite3_column_text (_tmp16_, 0);
#line 427 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp18_ = search_condition_search_type_from_string (_tmp17_);
#line 427 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp19_ = stmt;
#line 427 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp20_ = sqlite3_column_text (_tmp19_, 2);
#line 427 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp21_ = stmt;
#line 427 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp22_ = sqlite3_column_text (_tmp21_, 1);
#line 427 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp23_ = search_condition_text_context_from_string (_tmp22_);
#line 427 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp24_ = search_condition_text_new (_tmp18_, _tmp20_, _tmp23_);
#line 427 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			condition = _tmp24_;
#line 432 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp25_ = list;
#line 432 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp26_ = condition;
#line 432 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 420 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_search_condition_unref0 (condition);
#line 3270 "SavedSearchDBTable.c"
		}
	}
#line 436 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp27_ = database_table_db;
#line 436 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp29_ = sqlite3_prepare_v2 (_tmp27_, "SELECT search_type, context, type FROM SavedSearchDBTable_MediaType " "WHERE search_id=?", -1, &_tmp28_, NULL);
#line 436 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 436 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp28_;
#line 436 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp29_;
#line 439 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp30_ = res;
#line 439 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp30_ == SQLITE_OK, "res == Sqlite.OK");
#line 441 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp31_ = stmt;
#line 441 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp32_ = *search_id;
#line 441 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp33_ = _tmp32_.id;
#line 441 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp34_ = sqlite3_bind_int64 (_tmp31_, 1, _tmp33_);
#line 441 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp34_;
#line 442 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp35_ = res;
#line 442 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp35_ == SQLITE_OK, "res == Sqlite.OK");
#line 3301 "SavedSearchDBTable.c"
	{
		gboolean _tmp36_ = FALSE;
#line 444 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp36_ = TRUE;
#line 444 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		while (TRUE) {
#line 3308 "SavedSearchDBTable.c"
			sqlite3_stmt* _tmp37_ = NULL;
			gint _tmp38_ = 0;
			gint _tmp39_ = 0;
			SearchConditionMediaType* condition = NULL;
			sqlite3_stmt* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			SearchConditionSearchType _tmp44_ = 0;
			sqlite3_stmt* _tmp45_ = NULL;
			const gchar* _tmp46_ = NULL;
			SearchConditionMediaTypeContext _tmp47_ = 0;
			sqlite3_stmt* _tmp48_ = NULL;
			const gchar* _tmp49_ = NULL;
			SearchConditionMediaTypeMediaType _tmp50_ = 0;
			SearchConditionMediaType* _tmp51_ = NULL;
			GeeList* _tmp52_ = NULL;
			SearchConditionMediaType* _tmp53_ = NULL;
#line 444 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (!_tmp36_) {
#line 3327 "SavedSearchDBTable.c"
			}
#line 444 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp36_ = FALSE;
#line 445 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp37_ = stmt;
#line 445 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp38_ = sqlite3_step (_tmp37_);
#line 445 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = _tmp38_;
#line 446 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp39_ = res;
#line 446 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_tmp39_ == SQLITE_DONE) {
#line 447 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				break;
#line 3343 "SavedSearchDBTable.c"
			} else {
				gint _tmp40_ = 0;
#line 448 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp40_ = res;
#line 448 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_tmp40_ != SQLITE_ROW) {
#line 3350 "SavedSearchDBTable.c"
					gint _tmp41_ = 0;
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp41_ = res;
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					database_table_throw_error ("SavedSearchDBTable_MediaType.get_all_rows", _tmp41_, &_inner_error_);
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_propagate_error (error, _inner_error_);
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3368 "SavedSearchDBTable.c"
						} else {
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_clear_error (&_inner_error_);
#line 449 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3380 "SavedSearchDBTable.c"
						}
					}
				}
			}
#line 451 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp42_ = stmt;
#line 451 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp43_ = sqlite3_column_text (_tmp42_, 0);
#line 451 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp44_ = search_condition_search_type_from_string (_tmp43_);
#line 451 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp45_ = stmt;
#line 451 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp46_ = sqlite3_column_text (_tmp45_, 1);
#line 451 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp47_ = search_condition_media_type_context_from_string (_tmp46_);
#line 451 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp48_ = stmt;
#line 451 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp49_ = sqlite3_column_text (_tmp48_, 2);
#line 451 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp50_ = search_condition_media_type_media_type_from_string (_tmp49_);
#line 451 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp51_ = search_condition_media_type_new (_tmp44_, _tmp47_, _tmp50_);
#line 451 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			condition = _tmp51_;
#line 456 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp52_ = list;
#line 456 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp53_ = condition;
#line 456 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 444 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_search_condition_unref0 (condition);
#line 3415 "SavedSearchDBTable.c"
		}
	}
#line 460 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp54_ = database_table_db;
#line 460 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp56_ = sqlite3_prepare_v2 (_tmp54_, "SELECT search_type, flag_state FROM SavedSearchDBTable_Flagged " "WHERE search_id=?", -1, &_tmp55_, NULL);
#line 460 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 460 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp55_;
#line 460 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp56_;
#line 463 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp57_ = res;
#line 463 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp57_ == SQLITE_OK, "res == Sqlite.OK");
#line 465 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp58_ = stmt;
#line 465 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp59_ = *search_id;
#line 465 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp60_ = _tmp59_.id;
#line 465 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp61_ = sqlite3_bind_int64 (_tmp58_, 1, _tmp60_);
#line 465 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp61_;
#line 466 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp62_ = res;
#line 466 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp62_ == SQLITE_OK, "res == Sqlite.OK");
#line 3446 "SavedSearchDBTable.c"
	{
		gboolean _tmp63_ = FALSE;
#line 468 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp63_ = TRUE;
#line 468 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		while (TRUE) {
#line 3453 "SavedSearchDBTable.c"
			sqlite3_stmt* _tmp64_ = NULL;
			gint _tmp65_ = 0;
			gint _tmp66_ = 0;
			SearchConditionFlagged* condition = NULL;
			sqlite3_stmt* _tmp69_ = NULL;
			const gchar* _tmp70_ = NULL;
			SearchConditionSearchType _tmp71_ = 0;
			sqlite3_stmt* _tmp72_ = NULL;
			const gchar* _tmp73_ = NULL;
			SearchConditionFlaggedState _tmp74_ = 0;
			SearchConditionFlagged* _tmp75_ = NULL;
			GeeList* _tmp76_ = NULL;
			SearchConditionFlagged* _tmp77_ = NULL;
#line 468 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (!_tmp63_) {
#line 3469 "SavedSearchDBTable.c"
			}
#line 468 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp63_ = FALSE;
#line 469 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp64_ = stmt;
#line 469 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp65_ = sqlite3_step (_tmp64_);
#line 469 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = _tmp65_;
#line 470 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp66_ = res;
#line 470 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_tmp66_ == SQLITE_DONE) {
#line 471 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				break;
#line 3485 "SavedSearchDBTable.c"
			} else {
				gint _tmp67_ = 0;
#line 472 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp67_ = res;
#line 472 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_tmp67_ != SQLITE_ROW) {
#line 3492 "SavedSearchDBTable.c"
					gint _tmp68_ = 0;
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp68_ = res;
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					database_table_throw_error ("SavedSearchDBTable_Flagged.get_all_rows", _tmp68_, &_inner_error_);
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_propagate_error (error, _inner_error_);
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3510 "SavedSearchDBTable.c"
						} else {
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_clear_error (&_inner_error_);
#line 473 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3522 "SavedSearchDBTable.c"
						}
					}
				}
			}
#line 475 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp69_ = stmt;
#line 475 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp70_ = sqlite3_column_text (_tmp69_, 0);
#line 475 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp71_ = search_condition_search_type_from_string (_tmp70_);
#line 475 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp72_ = stmt;
#line 475 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp73_ = sqlite3_column_text (_tmp72_, 1);
#line 475 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp74_ = search_condition_flagged_state_from_string (_tmp73_);
#line 475 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp75_ = search_condition_flagged_new (_tmp71_, _tmp74_);
#line 475 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			condition = _tmp75_;
#line 479 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp76_ = list;
#line 479 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp77_ = condition;
#line 479 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 468 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_search_condition_unref0 (condition);
#line 3551 "SavedSearchDBTable.c"
		}
	}
#line 483 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp78_ = database_table_db;
#line 483 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp80_ = sqlite3_prepare_v2 (_tmp78_, "SELECT search_type, context, modified_state FROM SavedSearchDBTable_Mo" \
"dified " "WHERE search_id=?", -1, &_tmp79_, NULL);
#line 483 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 483 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp79_;
#line 483 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp80_;
#line 486 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp81_ = res;
#line 486 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp81_ == SQLITE_OK, "res == Sqlite.OK");
#line 488 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp82_ = stmt;
#line 488 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp83_ = *search_id;
#line 488 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp84_ = _tmp83_.id;
#line 488 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp85_ = sqlite3_bind_int64 (_tmp82_, 1, _tmp84_);
#line 488 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp85_;
#line 489 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp86_ = res;
#line 489 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp86_ == SQLITE_OK, "res == Sqlite.OK");
#line 3582 "SavedSearchDBTable.c"
	{
		gboolean _tmp87_ = FALSE;
#line 491 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp87_ = TRUE;
#line 491 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		while (TRUE) {
#line 3589 "SavedSearchDBTable.c"
			sqlite3_stmt* _tmp88_ = NULL;
			gint _tmp89_ = 0;
			gint _tmp90_ = 0;
			SearchConditionModified* condition = NULL;
			sqlite3_stmt* _tmp93_ = NULL;
			const gchar* _tmp94_ = NULL;
			SearchConditionSearchType _tmp95_ = 0;
			sqlite3_stmt* _tmp96_ = NULL;
			const gchar* _tmp97_ = NULL;
			SearchConditionModifiedContext _tmp98_ = 0;
			sqlite3_stmt* _tmp99_ = NULL;
			const gchar* _tmp100_ = NULL;
			SearchConditionModifiedState _tmp101_ = 0;
			SearchConditionModified* _tmp102_ = NULL;
			GeeList* _tmp103_ = NULL;
			SearchConditionModified* _tmp104_ = NULL;
#line 491 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (!_tmp87_) {
#line 3608 "SavedSearchDBTable.c"
			}
#line 491 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp87_ = FALSE;
#line 492 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp88_ = stmt;
#line 492 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp89_ = sqlite3_step (_tmp88_);
#line 492 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = _tmp89_;
#line 493 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp90_ = res;
#line 493 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_tmp90_ == SQLITE_DONE) {
#line 494 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				break;
#line 3624 "SavedSearchDBTable.c"
			} else {
				gint _tmp91_ = 0;
#line 495 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp91_ = res;
#line 495 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_tmp91_ != SQLITE_ROW) {
#line 3631 "SavedSearchDBTable.c"
					gint _tmp92_ = 0;
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp92_ = res;
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					database_table_throw_error ("SavedSearchDBTable_Modified.get_all_rows", _tmp92_, &_inner_error_);
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_propagate_error (error, _inner_error_);
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3649 "SavedSearchDBTable.c"
						} else {
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_clear_error (&_inner_error_);
#line 496 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3661 "SavedSearchDBTable.c"
						}
					}
				}
			}
#line 498 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp93_ = stmt;
#line 498 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp94_ = sqlite3_column_text (_tmp93_, 0);
#line 498 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp95_ = search_condition_search_type_from_string (_tmp94_);
#line 498 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp96_ = stmt;
#line 498 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp97_ = sqlite3_column_text (_tmp96_, 1);
#line 498 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp98_ = search_condition_modified_context_from_string (_tmp97_);
#line 498 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp99_ = stmt;
#line 498 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp100_ = sqlite3_column_text (_tmp99_, 2);
#line 498 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp101_ = search_condition_modified_state_from_string (_tmp100_);
#line 498 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp102_ = search_condition_modified_new (_tmp95_, _tmp98_, _tmp101_);
#line 498 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			condition = _tmp102_;
#line 503 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp103_ = list;
#line 503 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp104_ = condition;
#line 503 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp104_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 491 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_search_condition_unref0 (condition);
#line 3696 "SavedSearchDBTable.c"
		}
	}
#line 507 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp105_ = database_table_db;
#line 507 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp107_ = sqlite3_prepare_v2 (_tmp105_, "SELECT search_type, rating, context FROM SavedSearchDBTable_Rating " "WHERE search_id=?", -1, &_tmp106_, NULL);
#line 507 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 507 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp106_;
#line 507 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp107_;
#line 510 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp108_ = res;
#line 510 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp108_ == SQLITE_OK, "res == Sqlite.OK");
#line 512 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp109_ = stmt;
#line 512 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp110_ = *search_id;
#line 512 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp111_ = _tmp110_.id;
#line 512 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp112_ = sqlite3_bind_int64 (_tmp109_, 1, _tmp111_);
#line 512 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp112_;
#line 513 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp113_ = res;
#line 513 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp113_ == SQLITE_OK, "res == Sqlite.OK");
#line 3727 "SavedSearchDBTable.c"
	{
		gboolean _tmp114_ = FALSE;
#line 515 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp114_ = TRUE;
#line 515 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		while (TRUE) {
#line 3734 "SavedSearchDBTable.c"
			sqlite3_stmt* _tmp115_ = NULL;
			gint _tmp116_ = 0;
			gint _tmp117_ = 0;
			SearchConditionRating* condition = NULL;
			sqlite3_stmt* _tmp120_ = NULL;
			const gchar* _tmp121_ = NULL;
			SearchConditionSearchType _tmp122_ = 0;
			sqlite3_stmt* _tmp123_ = NULL;
			gint _tmp124_ = 0;
			Rating _tmp125_ = 0;
			sqlite3_stmt* _tmp126_ = NULL;
			const gchar* _tmp127_ = NULL;
			SearchConditionRatingContext _tmp128_ = 0;
			SearchConditionRating* _tmp129_ = NULL;
			GeeList* _tmp130_ = NULL;
			SearchConditionRating* _tmp131_ = NULL;
#line 515 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (!_tmp114_) {
#line 3753 "SavedSearchDBTable.c"
			}
#line 515 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp114_ = FALSE;
#line 516 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp115_ = stmt;
#line 516 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp116_ = sqlite3_step (_tmp115_);
#line 516 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = _tmp116_;
#line 517 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp117_ = res;
#line 517 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_tmp117_ == SQLITE_DONE) {
#line 518 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				break;
#line 3769 "SavedSearchDBTable.c"
			} else {
				gint _tmp118_ = 0;
#line 519 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp118_ = res;
#line 519 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_tmp118_ != SQLITE_ROW) {
#line 3776 "SavedSearchDBTable.c"
					gint _tmp119_ = 0;
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp119_ = res;
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					database_table_throw_error ("SavedSearchDBTable_Rating.get_all_rows", _tmp119_, &_inner_error_);
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_propagate_error (error, _inner_error_);
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3794 "SavedSearchDBTable.c"
						} else {
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_clear_error (&_inner_error_);
#line 520 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3806 "SavedSearchDBTable.c"
						}
					}
				}
			}
#line 522 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp120_ = stmt;
#line 522 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp121_ = sqlite3_column_text (_tmp120_, 0);
#line 522 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp122_ = search_condition_search_type_from_string (_tmp121_);
#line 522 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp123_ = stmt;
#line 522 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp124_ = sqlite3_column_int (_tmp123_, 1);
#line 522 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp125_ = rating_unserialize (_tmp124_);
#line 522 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp126_ = stmt;
#line 522 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp127_ = sqlite3_column_text (_tmp126_, 2);
#line 522 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp128_ = search_condition_rating_context_from_string (_tmp127_);
#line 522 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp129_ = search_condition_rating_new (_tmp122_, _tmp125_, _tmp128_);
#line 522 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			condition = _tmp129_;
#line 527 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp130_ = list;
#line 527 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp131_ = condition;
#line 527 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp130_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp131_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 515 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_search_condition_unref0 (condition);
#line 3841 "SavedSearchDBTable.c"
		}
	}
#line 531 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp132_ = database_table_db;
#line 531 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp134_ = sqlite3_prepare_v2 (_tmp132_, "SELECT search_type, context, date_one, date_two FROM SavedSearchDBTabl" \
"e_Date " "WHERE search_id=?", -1, &_tmp133_, NULL);
#line 531 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 531 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp133_;
#line 531 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp134_;
#line 534 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp135_ = res;
#line 534 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp135_ == SQLITE_OK, "res == Sqlite.OK");
#line 536 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp136_ = stmt;
#line 536 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp137_ = *search_id;
#line 536 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp138_ = _tmp137_.id;
#line 536 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp139_ = sqlite3_bind_int64 (_tmp136_, 1, _tmp138_);
#line 536 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp139_;
#line 537 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp140_ = res;
#line 537 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp140_ == SQLITE_OK, "res == Sqlite.OK");
#line 3872 "SavedSearchDBTable.c"
	{
		gboolean _tmp141_ = FALSE;
#line 539 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp141_ = TRUE;
#line 539 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		while (TRUE) {
#line 3879 "SavedSearchDBTable.c"
			sqlite3_stmt* _tmp142_ = NULL;
			gint _tmp143_ = 0;
			gint _tmp144_ = 0;
			SearchConditionDate* condition = NULL;
			sqlite3_stmt* _tmp147_ = NULL;
			const gchar* _tmp148_ = NULL;
			SearchConditionSearchType _tmp149_ = 0;
			sqlite3_stmt* _tmp150_ = NULL;
			const gchar* _tmp151_ = NULL;
			SearchConditionDateContext _tmp152_ = 0;
			sqlite3_stmt* _tmp153_ = NULL;
			gint64 _tmp154_ = 0LL;
			GDateTime* _tmp155_ = NULL;
			GDateTime* _tmp156_ = NULL;
			sqlite3_stmt* _tmp157_ = NULL;
			gint64 _tmp158_ = 0LL;
			GDateTime* _tmp159_ = NULL;
			GDateTime* _tmp160_ = NULL;
			SearchConditionDate* _tmp161_ = NULL;
			SearchConditionDate* _tmp162_ = NULL;
			GeeList* _tmp163_ = NULL;
			SearchConditionDate* _tmp164_ = NULL;
#line 539 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (!_tmp141_) {
#line 3904 "SavedSearchDBTable.c"
			}
#line 539 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp141_ = FALSE;
#line 540 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp142_ = stmt;
#line 540 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp143_ = sqlite3_step (_tmp142_);
#line 540 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = _tmp143_;
#line 541 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp144_ = res;
#line 541 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_tmp144_ == SQLITE_DONE) {
#line 542 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				break;
#line 3920 "SavedSearchDBTable.c"
			} else {
				gint _tmp145_ = 0;
#line 543 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp145_ = res;
#line 543 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_tmp145_ != SQLITE_ROW) {
#line 3927 "SavedSearchDBTable.c"
					gint _tmp146_ = 0;
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp146_ = res;
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					database_table_throw_error ("SavedSearchDBTable_Date.get_all_rows", _tmp146_, &_inner_error_);
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_propagate_error (error, _inner_error_);
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3945 "SavedSearchDBTable.c"
						} else {
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (list);
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_clear_error (&_inner_error_);
#line 544 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 3957 "SavedSearchDBTable.c"
						}
					}
				}
			}
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp147_ = stmt;
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp148_ = sqlite3_column_text (_tmp147_, 0);
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp149_ = search_condition_search_type_from_string (_tmp148_);
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp150_ = stmt;
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp151_ = sqlite3_column_text (_tmp150_, 1);
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp152_ = search_condition_date_context_from_string (_tmp151_);
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp153_ = stmt;
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp154_ = sqlite3_column_int64 (_tmp153_, 2);
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp155_ = g_date_time_new_from_unix_local (_tmp154_);
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp156_ = _tmp155_;
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp157_ = stmt;
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp158_ = sqlite3_column_int64 (_tmp157_, 3);
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp159_ = g_date_time_new_from_unix_local (_tmp158_);
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp160_ = _tmp159_;
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp161_ = search_condition_date_new (_tmp149_, _tmp152_, _tmp156_, _tmp160_);
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp162_ = _tmp161_;
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_g_date_time_unref0 (_tmp160_);
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_g_date_time_unref0 (_tmp156_);
#line 546 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			condition = _tmp162_;
#line 551 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp163_ = list;
#line 551 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp164_ = condition;
#line 551 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, TYPE_SEARCH_CONDITION, SearchCondition));
#line 539 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_search_condition_unref0 (condition);
#line 4008 "SavedSearchDBTable.c"
		}
	}
#line 554 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	result = list;
#line 554 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 554 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return result;
#line 4017 "SavedSearchDBTable.c"
}


void saved_search_db_table_create_from_row (SavedSearchDBTable* self, SavedSearchRow* row, SavedSearchID* result, GError** error) {
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	SavedSearchRow* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GDestroyNotify _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	sqlite3_stmt* _tmp11_ = NULL;
	SavedSearchRow* _tmp12_ = NULL;
	SearchOperator _tmp13_ = 0;
	gchar* _tmp14_ = NULL;
	GDestroyNotify _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	sqlite3_stmt* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	SavedSearchID search_id = {0};
	sqlite3* _tmp22_ = NULL;
	gint64 _tmp23_ = 0LL;
	GError * _inner_error_ = NULL;
#line 558 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (IS_SAVED_SEARCH_DB_TABLE (self));
#line 558 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (IS_SAVED_SEARCH_ROW (row));
#line 560 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = database_table_db;
#line 560 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO SavedSearchDBTable (name, operator) VALUES (?, ?)", -1, &_tmp1_, NULL);
#line 560 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 560 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp1_;
#line 560 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp2_;
#line 562 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp3_ = res;
#line 562 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 564 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp4_ = stmt;
#line 564 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp5_ = row;
#line 564 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp6_ = _tmp5_->name;
#line 564 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 564 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp8_ = g_free;
#line 564 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp9_ = sqlite3_bind_text (_tmp4_, 1, _tmp7_, -1, _tmp8_);
#line 564 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp9_;
#line 565 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp10_ = res;
#line 565 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp10_ == SQLITE_OK, "res == Sqlite.OK");
#line 566 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp11_ = stmt;
#line 566 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp12_ = row;
#line 566 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp13_ = _tmp12_->operator;
#line 566 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp14_ = search_operator_to_string (_tmp13_);
#line 566 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp15_ = g_free;
#line 566 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp16_ = sqlite3_bind_text (_tmp11_, 2, _tmp14_, -1, _tmp15_);
#line 566 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp16_;
#line 567 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp17_ = res;
#line 567 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp17_ == SQLITE_OK, "res == Sqlite.OK");
#line 569 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp18_ = stmt;
#line 569 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp19_ = sqlite3_step (_tmp18_);
#line 569 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp19_;
#line 570 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp20_ = res;
#line 570 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp20_ != SQLITE_DONE) {
#line 4113 "SavedSearchDBTable.c"
		gint _tmp21_ = 0;
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp21_ = res;
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		database_table_throw_error ("SavedSearchDBTable.create_from_row", _tmp21_, &_inner_error_);
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				g_propagate_error (error, _inner_error_);
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_sqlite3_finalize0 (stmt);
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				return;
#line 4129 "SavedSearchDBTable.c"
			} else {
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_sqlite3_finalize0 (stmt);
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				g_clear_error (&_inner_error_);
#line 571 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				return;
#line 4139 "SavedSearchDBTable.c"
			}
		}
	}
#line 573 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp22_ = database_table_db;
#line 573 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp23_ = sqlite3_last_insert_rowid (_tmp22_);
#line 573 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_id_init (&search_id, _tmp23_);
#line 4149 "SavedSearchDBTable.c"
	{
		GeeList* _sc_list = NULL;
		SavedSearchRow* _tmp24_ = NULL;
		GeeList* _tmp25_ = NULL;
		GeeList* _tmp26_ = NULL;
		gint _sc_size = 0;
		GeeList* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gint _sc_index = 0;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp24_ = row;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp25_ = _tmp24_->conditions;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp26_ = _g_object_ref0 (_tmp25_);
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_sc_list = _tmp26_;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp27_ = _sc_list;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp28_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_COLLECTION, GeeCollection));
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp29_ = _tmp28_;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_sc_size = _tmp29_;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_sc_index = -1;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		while (TRUE) {
#line 4180 "SavedSearchDBTable.c"
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
			SearchCondition* sc = NULL;
			GeeList* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			gpointer _tmp35_ = NULL;
			SavedSearchID _tmp36_ = {0};
			SearchCondition* _tmp37_ = NULL;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp30_ = _sc_index;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_sc_index = _tmp30_ + 1;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp31_ = _sc_index;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp32_ = _sc_size;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (!(_tmp31_ < _tmp32_)) {
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				break;
#line 4202 "SavedSearchDBTable.c"
			}
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp33_ = _sc_list;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp34_ = _sc_index;
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp35_ = gee_list_get (_tmp33_, _tmp34_);
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			sc = (SearchCondition*) _tmp35_;
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp36_ = search_id;
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp37_ = sc;
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			saved_search_db_table_add_condition (self, &_tmp36_, _tmp37_, &_inner_error_);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_propagate_error (error, _inner_error_);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_search_condition_unref0 (sc);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_g_object_unref0 (_sc_list);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return;
#line 4232 "SavedSearchDBTable.c"
				} else {
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_search_condition_unref0 (sc);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_g_object_unref0 (_sc_list);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_clear_error (&_inner_error_);
#line 576 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return;
#line 4246 "SavedSearchDBTable.c"
				}
			}
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_search_condition_unref0 (sc);
#line 4251 "SavedSearchDBTable.c"
		}
#line 575 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_g_object_unref0 (_sc_list);
#line 4255 "SavedSearchDBTable.c"
	}
#line 579 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	*result = search_id;
#line 579 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 579 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return;
#line 4263 "SavedSearchDBTable.c"
}


void saved_search_db_table_remove (SavedSearchDBTable* self, SavedSearchID* search_id, GError** error) {
	SavedSearchID _tmp0_ = {0};
	SavedSearchID _tmp1_ = {0};
	gint64 _tmp2_ = 0LL;
	GError * _inner_error_ = NULL;
#line 582 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (IS_SAVED_SEARCH_DB_TABLE (self));
#line 582 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (search_id != NULL);
#line 583 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = *search_id;
#line 583 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_db_table_remove_conditions_for_search_id (self, &_tmp0_, &_inner_error_);
#line 583 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 583 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 583 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_propagate_error (error, _inner_error_);
#line 583 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 4288 "SavedSearchDBTable.c"
		} else {
#line 583 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 583 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_clear_error (&_inner_error_);
#line 583 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 4296 "SavedSearchDBTable.c"
		}
	}
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp1_ = *search_id;
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp2_ = _tmp1_.id;
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	database_table_delete_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp2_, &_inner_error_);
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_propagate_error (error, _inner_error_);
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 4313 "SavedSearchDBTable.c"
		} else {
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_clear_error (&_inner_error_);
#line 584 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 4321 "SavedSearchDBTable.c"
		}
	}
}


SavedSearchRow* saved_search_db_table_get_row (SavedSearchDBTable* self, SavedSearchID* search_id, GError** error) {
	SavedSearchRow* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	SavedSearchID _tmp5_ = {0};
	gint64 _tmp6_ = 0LL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	SavedSearchRow* row = NULL;
	SavedSearchRow* _tmp14_ = NULL;
	SavedSearchRow* _tmp15_ = NULL;
	SavedSearchID _tmp16_ = {0};
	SavedSearchRow* _tmp17_ = NULL;
	sqlite3_stmt* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	SavedSearchRow* _tmp21_ = NULL;
	sqlite3_stmt* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	SearchOperator _tmp24_ = 0;
	GError * _inner_error_ = NULL;
#line 587 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (IS_SAVED_SEARCH_DB_TABLE (self), NULL);
#line 587 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (search_id != NULL, NULL);
#line 589 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = database_table_db;
#line 589 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT name, operator FROM SavedSearchDBTable WHERE id=?", -1, &_tmp1_, NULL);
#line 589 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 589 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp1_;
#line 589 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp2_;
#line 591 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp3_ = res;
#line 591 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 593 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp4_ = stmt;
#line 593 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp5_ = *search_id;
#line 593 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp6_ = _tmp5_.id;
#line 593 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp7_ = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 593 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp7_;
#line 594 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp8_ = res;
#line 594 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 596 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp9_ = stmt;
#line 596 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp10_ = sqlite3_step (_tmp9_);
#line 596 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp10_;
#line 597 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp11_ = res;
#line 597 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (_tmp11_ == SQLITE_DONE) {
#line 598 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		result = NULL;
#line 598 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_sqlite3_finalize0 (stmt);
#line 598 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		return result;
#line 4404 "SavedSearchDBTable.c"
	} else {
		gint _tmp12_ = 0;
#line 599 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp12_ = res;
#line 599 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_tmp12_ != SQLITE_ROW) {
#line 4411 "SavedSearchDBTable.c"
			gint _tmp13_ = 0;
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp13_ = res;
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			database_table_throw_error ("SavedSearchDBTable.get_row", _tmp13_, &_inner_error_);
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_propagate_error (error, _inner_error_);
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return NULL;
#line 4427 "SavedSearchDBTable.c"
				} else {
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_clear_error (&_inner_error_);
#line 600 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return NULL;
#line 4437 "SavedSearchDBTable.c"
				}
			}
		}
	}
#line 602 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp14_ = saved_search_row_new ();
#line 602 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	row = _tmp14_;
#line 603 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp15_ = row;
#line 603 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp16_ = *search_id;
#line 603 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp15_->search_id = _tmp16_;
#line 604 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp17_ = row;
#line 604 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp18_ = stmt;
#line 604 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp19_ = sqlite3_column_text (_tmp18_, 0);
#line 604 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp20_ = g_strdup (_tmp19_);
#line 604 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_g_free0 (_tmp17_->name);
#line 604 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp17_->name = _tmp20_;
#line 605 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp21_ = row;
#line 605 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp22_ = stmt;
#line 605 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp23_ = sqlite3_column_text (_tmp22_, 1);
#line 605 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp24_ = search_operator_from_string (_tmp23_);
#line 605 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp21_->operator = _tmp24_;
#line 607 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	result = row;
#line 607 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 607 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return result;
#line 4480 "SavedSearchDBTable.c"
}


GeeList* saved_search_db_table_get_all_rows (SavedSearchDBTable* self, GError** error) {
	GeeList* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GeeList* rows = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 610 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_val_if_fail (IS_SAVED_SEARCH_DB_TABLE (self), NULL);
#line 612 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = database_table_db;
#line 612 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id, name, operator FROM SavedSearchDBTable", -1, &_tmp1_, NULL);
#line 612 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 612 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	stmt = _tmp1_;
#line 612 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	res = _tmp2_;
#line 614 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp3_ = res;
#line 614 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 616 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp4_ = gee_array_list_new (TYPE_SAVED_SEARCH_ROW, (GBoxedCopyFunc) saved_search_row_ref, saved_search_row_unref, NULL, NULL, NULL);
#line 616 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	rows = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_LIST, GeeList);
#line 4515 "SavedSearchDBTable.c"
	{
		gboolean _tmp5_ = FALSE;
#line 618 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		_tmp5_ = TRUE;
#line 618 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		while (TRUE) {
#line 4522 "SavedSearchDBTable.c"
			sqlite3_stmt* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			SavedSearchRow* row = NULL;
			SavedSearchRow* _tmp11_ = NULL;
			SavedSearchRow* _tmp12_ = NULL;
			sqlite3_stmt* _tmp13_ = NULL;
			gint64 _tmp14_ = 0LL;
			SavedSearchRow* _tmp15_ = NULL;
			sqlite3_stmt* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			SavedSearchRow* _tmp19_ = NULL;
			sqlite3_stmt* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			SearchOperator _tmp22_ = 0;
			GeeList* _tmp23_ = NULL;
			SavedSearchRow* _tmp24_ = NULL;
			SavedSearchID _tmp25_ = {0};
			GeeList* _tmp26_ = NULL;
			SavedSearchRow* _tmp27_ = NULL;
			GeeList* _tmp28_ = NULL;
			GeeList* _tmp29_ = NULL;
			SavedSearchRow* _tmp30_ = NULL;
#line 618 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (!_tmp5_) {
#line 4549 "SavedSearchDBTable.c"
			}
#line 618 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp5_ = FALSE;
#line 619 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp6_ = stmt;
#line 619 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp7_ = sqlite3_step (_tmp6_);
#line 619 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			res = _tmp7_;
#line 620 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp8_ = res;
#line 620 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (_tmp8_ == SQLITE_DONE) {
#line 621 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				break;
#line 4565 "SavedSearchDBTable.c"
			} else {
				gint _tmp9_ = 0;
#line 622 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				_tmp9_ = res;
#line 622 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_tmp9_ != SQLITE_ROW) {
#line 4572 "SavedSearchDBTable.c"
					gint _tmp10_ = 0;
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_tmp10_ = res;
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					database_table_throw_error ("SavedSearchDBTable.get_all_rows", _tmp10_, &_inner_error_);
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
						if (_inner_error_->domain == DATABASE_ERROR) {
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_propagate_error (error, _inner_error_);
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (rows);
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 4590 "SavedSearchDBTable.c"
						} else {
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_g_object_unref0 (rows);
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							_sqlite3_finalize0 (stmt);
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							g_clear_error (&_inner_error_);
#line 623 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
							return NULL;
#line 4602 "SavedSearchDBTable.c"
						}
					}
				}
			}
#line 625 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp11_ = saved_search_row_new ();
#line 625 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			row = _tmp11_;
#line 626 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp12_ = row;
#line 626 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp13_ = stmt;
#line 626 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp14_ = sqlite3_column_int64 (_tmp13_, 0);
#line 626 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			saved_search_id_init (&_tmp12_->search_id, _tmp14_);
#line 627 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp15_ = row;
#line 627 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp16_ = stmt;
#line 627 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp17_ = sqlite3_column_text (_tmp16_, 1);
#line 627 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp18_ = g_strdup (_tmp17_);
#line 627 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_g_free0 (_tmp15_->name);
#line 627 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp15_->name = _tmp18_;
#line 628 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp19_ = row;
#line 628 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp20_ = stmt;
#line 628 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp21_ = sqlite3_column_text (_tmp20_, 2);
#line 628 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp22_ = search_operator_from_string (_tmp21_);
#line 628 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp19_->operator = _tmp22_;
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp24_ = row;
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp25_ = _tmp24_->search_id;
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp26_ = saved_search_db_table_get_conditions_for_id (self, &_tmp25_, &_inner_error_);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp23_ = _tmp26_;
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_propagate_error (error, _inner_error_);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_saved_search_row_unref0 (row);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_g_object_unref0 (rows);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return NULL;
#line 4663 "SavedSearchDBTable.c"
				} else {
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_saved_search_row_unref0 (row);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_g_object_unref0 (rows);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					_sqlite3_finalize0 (stmt);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					g_clear_error (&_inner_error_);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
					return NULL;
#line 4677 "SavedSearchDBTable.c"
				}
			}
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp27_ = row;
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp28_ = _tmp23_;
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp23_ = NULL;
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_g_object_unref0 (_tmp27_->conditions);
#line 629 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp27_->conditions = _tmp28_;
#line 631 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp29_ = rows;
#line 631 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_tmp30_ = row;
#line 631 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_COLLECTION, GeeCollection), _tmp30_);
#line 618 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_g_object_unref0 (_tmp23_);
#line 618 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			_saved_search_row_unref0 (row);
#line 4700 "SavedSearchDBTable.c"
		}
	}
#line 634 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	result = rows;
#line 634 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_sqlite3_finalize0 (stmt);
#line 634 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	return result;
#line 4709 "SavedSearchDBTable.c"
}


void saved_search_db_table_rename (SavedSearchDBTable* self, SavedSearchID* search_id, const gchar* new_name, GError** error) {
	SavedSearchID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 637 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (IS_SAVED_SEARCH_DB_TABLE (self));
#line 637 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (search_id != NULL);
#line 637 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	g_return_if_fail (new_name != NULL);
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp0_ = *search_id;
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp1_ = _tmp0_.id;
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	_tmp2_ = new_name;
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "name", _tmp2_, &_inner_error_);
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_propagate_error (error, _inner_error_);
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 4740 "SavedSearchDBTable.c"
		} else {
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			g_clear_error (&_inner_error_);
#line 638 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
			return;
#line 4748 "SavedSearchDBTable.c"
		}
	}
}


static void saved_search_db_table_class_init (SavedSearchDBTableClass * klass) {
#line 33 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	saved_search_db_table_parent_class = g_type_class_peek_parent (klass);
#line 33 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	((DatabaseTableClass *) klass)->finalize = saved_search_db_table_finalize;
#line 4759 "SavedSearchDBTable.c"
}


static void saved_search_db_table_instance_init (SavedSearchDBTable * self) {
}


static void saved_search_db_table_finalize (DatabaseTable* obj) {
	SavedSearchDBTable * self;
#line 33 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SAVED_SEARCH_DB_TABLE, SavedSearchDBTable);
#line 33 "/home/jens/Source/shotwell/src/db/SavedSearchDBTable.vala"
	DATABASE_TABLE_CLASS (saved_search_db_table_parent_class)->finalize (obj);
#line 4773 "SavedSearchDBTable.c"
}


GType saved_search_db_table_get_type (void) {
	static volatile gsize saved_search_db_table_type_id__volatile = 0;
	if (g_once_init_enter (&saved_search_db_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SavedSearchDBTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) saved_search_db_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SavedSearchDBTable), 0, (GInstanceInitFunc) saved_search_db_table_instance_init, NULL };
		GType saved_search_db_table_type_id;
		saved_search_db_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "SavedSearchDBTable", &g_define_type_info, 0);
		g_once_init_leave (&saved_search_db_table_type_id__volatile, saved_search_db_table_type_id);
	}
	return saved_search_db_table_type_id__volatile;
}



