/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* directory.h */

#ifndef __DIRECTORY_H__
#define __DIRECTORY_H__

#include "showimg.h"
#include "imagefileitem.h"
#include "compressedfile.h"
#include "imagelisteview.h"
#include "mainwindow.h"
#include "directoryview.h"

#include <qlistview.h>
#include <qstring.h>
#include <qfile.h>
#include <qlist.h> 


class ImageListeView;
class ImageFileItem;
class ImageViewer;
class MainWindow;
class DirectoryView;

class Directory:public QListViewItem
{
public:
  Directory (DirectoryView* parent, ImageViewer * iv, ImageListeView * imageList, MainWindow * mw);
  Directory (Directory * parent, const char *filename, DirectoryView* dirView, ImageViewer * iv,  ImageListeView * imageList, MainWindow * mw);
  ~Directory();

  QString text (int column) const;
  const QPixmap *pixmap (int) const;

  QString fullName ();
  QString name ();
  QString path ();

  void setSelected (bool select);
  void setOpen (bool);
  void setup ();

  void loadDir (bool refresh=true);
  void unLoadDir ();
  void refresh();
  Directory *find (const char *);
  void goTo (const char *dest);
  void loadFirst ();

  void removeImage (ImageFileItem * imf);
  QString key (int column, bool ascending) const;

  void createDir(QString dirName);
  void rename(QString newDirName);
  void rename();
  void properties();
  
private:
  QString full;
  QFile f;
  Directory *p;
  bool readable;
  QString newDirName;
  QList < ImageFileItem > list;

  ImageViewer *iv;
  ImageListeView *imageList;
  MainWindow *mw;
  DirectoryView *dirView;

  QPixmap *p_open;
  QPixmap *p_close;
  QPixmap *p_none;

};


#endif
