/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __FILEITEM_H__
#define __FILEITEM_H__

#include <kfileiconview.h>
#include <kiconloader.h>
#include <kfileitem.h>

class FileItem:public KFileIconViewItem
{
public:
	FileItem(QIconView *parent, const char* path, const char* filename, const char* icon);
	virtual ~FileItem();

	virtual void setPixmap ( const QPixmap & icon, bool haspreview=false );
	bool hasPreview ();

	FileItem* nextItem ();
	FileItem* prevItem ();

	virtual void setName(QString n);
	virtual QString name();
	    
	virtual QString fullName();

	QString FileItem::mimetype() const;

	virtual bool suppression(bool);
	virtual bool suppression();

	virtual bool moveToTrash();
	virtual bool shred();	 

	virtual QString text(int i) const;
	virtual QString text() const;
	virtual void setWallpaper();

	void setKey ( const QString & k );

protected:
	QString getFileName(QString *fullName);
	QString getFileExt(QString *fullName);
	QString getFullName(QString *fullName);
	QString getFullPath(QString *fullName);

	QString getFileName(QString fullName);
	QString getFileExt(QString fullName);
	QString getFullName(QString fullName);
	QString getFullPath(QString fullName);

	QString *size;
	QString *extension;
	QString *type;
	QString *date;

	QFileInfo *info;	
	QString myName;
	bool haspreview;
};
#endif
