/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "formatconversion.h"

#include "jpgoptions.h"

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qheader.h>
#include <qlabel.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

static const char* const image0_data[] = { 
"16 16 25 1",
". c None",
"# c #000000",
"i c #00008b",
"s c #000473",
"p c #000c8b",
"b c #000c94",
"n c #080c83",
"w c #dee6ff",
"e c #e6daff",
"t c #e6e2ff",
"v c #e6e6ff",
"o c #eedeff",
"f c #eee2ff",
"h c #eee6ff",
"k c #eeeaff",
"l c #eeeeff",
"m c #eef2ff",
"u c #eef6ff",
"d c #f6e2ff",
"j c #f6eaff",
"g c #f6eeff",
"r c #f6f2ff",
"q c #f6f6ff",
"c c #ffeaff",
"a c #ffffff",
"...###########..",
"...#aaaaaaaaa#..",
"...#aaaaaaaaa###",
"...#aaaaaaaaaaa#",
"################",
"#bbbbbbbbbbbbbb#",
"#bcdbbebbfbghbb#",
"#bgijbgkklbmnob#",
"#pkgbbmbbmbqrbb#",
"#sritblbblbubbb#",
"#bhgbbvbbmbwbbb#",
"#bbbbbbbbbbbbbb#",
"################",
"...#aaaaaaaaaaa#",
"...#aaaaaaaaaaa#",
"...#############"};

static const char* const image1_data[] = { 
"16 16 23 1",
". c None",
"# c #000000",
"s c #000008",
"a c #000400",
"u c #000408",
"b c #000800",
"j c #000c00",
"l c #001000",
"k c #001400",
"o c #001408",
"n c #001800",
"m c #001c00",
"r c #002000",
"e c #080000",
"c c #080400",
"d c #080800",
"t c #080808",
"h c #081408",
"i c #081810",
"p c #207520",
"q c #297131",
"g c #bdbebd",
"f c #ffffff",
"...#a#b##cd##e..",
"...#fffffffff#g.",
"...afffffffffahi",
"...jfffffffffffa",
"abkjlmlljllljnba",
"opppppppppppppqa",
"bppffppfffpffffa",
"jpfpppppfppfpppb",
"rpfpfpppfppfffpb",
"npfppfppfppfpppj",
"jppffppfffpfpppb",
"bppppppppppppppb",
"aabjbjkjnjjjbbja",
"...#fffffffffff#",
"...sfffffffffff#",
"...#####t#usss#t"};

static const char* const image2_data[] = { 
"16 16 25 1",
". c None",
"# c #000000",
"c c #000008",
"g c #000400",
"r c #000800",
"t c #000c00",
"j c #080400",
"h c #080800",
"a c #080808",
"b c #080810",
"i c #080c00",
"u c #081000",
"v c #081008",
"k c #100c00",
"d c #101008",
"w c #101010",
"m c #181c00",
"n c #7b7d31",
"p c #838131",
"o c #838139",
"q c #838531",
"s c #838539",
"l c #8b8941",
"f c #c5c2c5",
"e c #ffffff",
"...##a##bb##c#..",
"...deeeeeeeee#f.",
"...#eeeeeeeeeg##",
"...#eeeeeeeeeee#",
"h#i#j##kghggigg#",
"#llllllllllllllg",
"gleeeleellleellg",
"mllellenelellllh",
"gllelleeolelellh",
"gllellellpeqlelg",
"rleellelslleellh",
"gllllllllllllllg",
"#gggtrturrrttggg",
"...reeeeeeeeeee#",
"...ueeeeeeeeeee#",
"...#vg##g####w#w"};

static const char* const image3_data[] = { 
"16 16 12 1",
". c None",
"# c #000000",
"j c #000400",
"h c #080800",
"i c #080808",
"g c #101008",
"c c #101410",
"e c #73757b",
"d c #83818b",
"b c #bdb6bd",
"f c #f6f6ff",
"a c #ffffff",
"...###########..",
"...#aaaaaaaaa#b.",
"...caaaaaaaaa###",
"...#aaaaaaaaaaa#",
"################",
"#dddddddddddddd#",
"#daadddaadaddad#",
"#daeadaddddaadd#",
"#daaddaddddaadd#",
"#dadddaddddaadd#",
"#daddddafdaddad#",
"#dddddddddddddd#",
"####ghi#jj##j#j#",
"...#aaaaaaaaaaa#",
"...#aaaaaaaaaaa#",
"...#############"};

static const char* const image4_data[] = { 
"16 16 6 1",
". c None",
"# c #000000",
"c c #520408",
"d c #521410",
"b c #b4b6b4",
"a c #ffffff",
"...###########..",
"...#aaaaaaaaa#b.",
"...#aaaaaaaaa###",
"...#aaaaaaaaaaa#",
"################",
"#cccccccccccccc#",
"#caaccaccaccaac#",
"#cadacaacacaccc#",
"#caaccacaacacac#",
"#cacccaccacacca#",
"#cacccaccaccaac#",
"#cccccccccccccc#",
"################",
"...#aaaaaaaaaaa#",
"...#aaaaaaaaaaa#",
"...#############"};

static const char* const image5_data[] = { 
"16 16 13 1",
". c None",
"# c #000000",
"d c #000008",
"e c #001018",
"a c #080810",
"f c #08696a",
"g c #106d6a",
"h c #186d6a",
"j c #206d6a",
"i c #207573",
"k c #316d6a",
"c c #d5d2d5",
"b c #ffffff",
"...###########..",
"...abbbbbbbbb#c.",
"...dbbbbbbbbb###",
"...ebbbbbbbbbbb#",
"################",
"#fffgffffffffff#",
"#hbbbffbbfffbff#",
"#ffbffbffffbibf#",
"#ffbffbfbffbjbf#",
"#ffbffbffbfbbbf#",
"#ffbfffbbffbfbf#",
"#fffffffffffffk#",
"################",
"...#bbbbbbbbbbb#",
"...#bbbbbbbbbbb#",
"...#############"};

static const char* const image6_data[] = { 
"16 16 5 1",
". c None",
"# c #000000",
"c c #000052",
"b c #bdc2bd",
"a c #ffffff",
"...###########..",
"...#aaaaaaaaa#b.",
"...#aaaaaaaaa###",
"...#aaaaaaaaaaa#",
"################",
"#cccccccccccccc#",
"#caaacaaacaaaac#",
"#ccacccaccacccc#",
"#ccacccaccaaacc#",
"#ccacccaccacccc#",
"#ccaccaaacacccc#",
"#cccccccccccccc#",
"################",
"...#aaaaaaaaaaa#",
"...#aaaaaaaaaaa#",
"...#############"};


/* 
 *  Constructs a FormatConversion which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
FormatConversion::FormatConversion( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : KDialog( parent, name, modal, fl )
{
	/*
	QPixmap image0( ( const char** ) image0_data );
	QPixmap image1( ( const char** ) image1_data );
	QPixmap image2( ( const char** ) image2_data );
	QPixmap image3( ( const char** ) image3_data );
	QPixmap image4( ( const char** ) image4_data );
	*/
	if ( !name )
	    setName( "FormatConversion" );
	resize( 500, 370 );
	setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, sizePolicy().hasHeightForWidth() ) );
	setMinimumSize( QSize( 500, 370 ) );
	setMaximumSize( QSize( 500, 370 ) );
	setCaption( i18n( "Format Conversion" ) );
	QWhatsThis::add(  this, i18n( "Frame to choose the format conversion" ) );

	GroupBox1 = new QGroupBox( this, "GroupBox1" );
	GroupBox1->setGeometry( QRect( 10, 10, 471, 190 ) );
	GroupBox1->setTitle( i18n( "Destination format" ) );

	listViewFormat = new QListView( GroupBox1, "listViewFormat" );
	listViewFormat->addColumn( i18n( "Extension" ) );
	listViewFormat->header()->setClickEnabled( FALSE, listViewFormat->header()->count() - 1 );
	listViewFormat->header()->setResizeEnabled( FALSE, listViewFormat->header()->count() - 1 );
	listViewFormat->addColumn( i18n( "Description" ) );
	listViewFormat->header()->setClickEnabled( FALSE, listViewFormat->header()->count() - 1 );
	listViewFormat->header()->setResizeEnabled( FALSE, listViewFormat->header()->count() - 1 );
	QListViewItem * item = new QListViewItem( listViewFormat, 0 );
	item->setText( 0,  "BMP"  );
	//item->setPixmap( 0, image0 );
	item->setText( 1, i18n( "Microsoft Windows Bitmap image file" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "GIF"  );
	//item->setPixmap( 0, image1 );
	item->setText( 1, i18n( " CompuServe Graphics Interchange format" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "JPG"  );
	//item->setPixmap( 0, image2 );
	item->setText( 1, i18n( "Joint Photographic Experts Group JFIF format" ) );
	listViewFormat->setCurrentItem (item);

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "PNG"  );
	//item->setPixmap( 0, image4 );
	item->setText( 1, i18n( "Portable Network Graphics" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "TGA"  );
	//item->setPixmap( 0, image5 );
	item->setText( 1, i18n( "Truevision Targa image file" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "TIF"  );
	//item->setPixmap( 0, image4 );
	item->setText( 1, i18n( "Tagged Image File Format" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "XPM"  );
	//item->setPixmap( 0, image4 );
	item->setText( 1, i18n( "X Windows system pixmap file" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "PS"  );
	//item->setPixmap( 0, image4 );
	item->setText( 1, i18n( "Adobe PostScript file" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "EPS"  );
	//item->setPixmap( 0, image4 );
	item->setText( 1, i18n( "Adobe Encapsulated PostScript file" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "PDF"  );
	//item->setPixmap( 0, image4 );
	item->setText( 1, i18n( "Portable Document Format" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "PCX"  );
	//item->setPixmap( 0, image4 );
	item->setText( 1, i18n( "ZSoft IBM PC Paintbrush file" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "ICO"  );
	//item->setPixmap( 0, image3 );
	item->setText( 1, i18n( "Microsoft icon" ) );

	item = new QListViewItem( listViewFormat, item );
	item->setText( 0,  "PNM"  );
	//item->setPixmap( 0, image4 );
	item->setText( 1, i18n( "Portable anymap" ) );

	listViewFormat->setGeometry( QRect( 70, 20, 270, 160 ) );
	listViewFormat->setAllColumnsShowFocus( TRUE );
	QWhatsThis::add(  listViewFormat, i18n( "Choose your format here" ) );

	pushButtonSetting = new QPushButton( GroupBox1, "pushButtonSetting" );
	pushButtonSetting->setGeometry( QRect( 350, 140, 111, 31 ) );
	pushButtonSetting->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, pushButtonSetting->sizePolicy().hasHeightForWidth() ) );
	pushButtonSetting->setText( i18n( "Format &Setting..." ) );
	QWhatsThis::add(  pushButtonSetting, i18n( "Edit the settings of\n"
		"the selected format" ) );

	pushButtonOK = new QPushButton( this, "pushButtonOK" );
	pushButtonOK->setGeometry( QRect( 320, 330, 80, 30 ) );
	pushButtonOK->setText( i18n( "&OK" ) );

	pushButtonCancel = new QPushButton( this, "pushButtonCancel" );
	pushButtonCancel->setGeometry( QRect( 410, 330, 80, 30 ) );
	pushButtonCancel->setText( i18n( "&Cancel" ) );

	GroupBox10 = new QGroupBox( this, "GroupBox10" );
	GroupBox10->setGeometry( QRect( 10, 210, 471, 111 ) );
	GroupBox10->setTitle( i18n( "Output" ) );

	QWidget* privateLayoutWidget = new QWidget( GroupBox10, "Layout2" );
	privateLayoutWidget->setGeometry( QRect( 10, 20, 360, 24 ) );
	Layout2 = new QHBoxLayout( privateLayoutWidget );
	Layout2->setSpacing( 6 );
	Layout2->setMargin( 0 );

	TextLabel2 = new QLabel( privateLayoutWidget, "TextLabel2" );
	TextLabel2->setText( i18n( "To folder:" ) );
	TextLabel2->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
	Layout2->addWidget( TextLabel2 );
	QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::MinimumExpanding, QSizePolicy::Minimum );
	Layout2->addItem( spacer );

	ComboBox1 = new QComboBox( FALSE, privateLayoutWidget, "ComboBox1" );
	ComboBox1->insertItem( i18n( "./" ) );
	ComboBox1->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)7, ComboBox1->sizePolicy().hasHeightForWidth() ) );
	ComboBox1->setMinimumSize( QSize( 270, 0 ) );
	ComboBox1->setMaximumSize( QSize( 300, 32767 ) );
	QWhatsThis::add(  ComboBox1, i18n( "Choose the destination of\n"
		"the converted images" ) );
	Layout2->addWidget( ComboBox1 );

	PushButton15 = new QPushButton( GroupBox10, "PushButton15" );
	PushButton15->setGeometry( QRect( 381, 20, 80, 30 ) );
	PushButton15->setText( i18n( "&Browse" ) );
	QWhatsThis::add(  PushButton15, i18n( "Browse to choose \n"
		"the destination diretory" ) );
	PushButton15->setEnabled(false);
	privateLayoutWidget->setEnabled(false);

	TextLabel3 = new QLabel( GroupBox10, "TextLabel3" );
	TextLabel3->setGeometry( QRect( 10, 60, 80, 40 ) );
	TextLabel3->setText( i18n( "Overwrite\n"
		"existing" ) );
	TextLabel3->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );
	TextLabel3->setEnabled(false);

	CheckBox1 = new QCheckBox( GroupBox10, "CheckBox1" );
	CheckBox1->setGeometry( QRect( 210, 70, 250, 21 ) );
	CheckBox1->setText( i18n( "Remove/replace original" ) );
	QWhatsThis::add(  CheckBox1, i18n( "Replace the original ?" ) );

	ComboBox2 = new QComboBox( FALSE, GroupBox10, "ComboBox2" );
	ComboBox2->insertItem( i18n( "Replace" ) );
	ComboBox2->insertItem( i18n( "Skip" ) );
	ComboBox2->insertItem( i18n( "Ask" ) );
	ComboBox2->setGeometry( QRect( 100, 70, 91, 21 ) );
	QWhatsThis::add(  ComboBox2, i18n( "If the file\n"
		"already exists" ) );
	ComboBox2->setEnabled(false);
	// signals and slots connections
	connect( pushButtonOK, SIGNAL( clicked() ), this, SLOT( accept() ) );
	connect( pushButtonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
	connect( listViewFormat, SIGNAL( selectionChanged(QListViewItem*) ), this, SLOT( enabledDisabledSettingButton(QListViewItem*) ) );
	connect( pushButtonSetting, SIGNAL( clicked() ), this, SLOT( showJPGOption() ) );
	// tab order
	setTabOrder( listViewFormat, pushButtonSetting );
	setTabOrder( pushButtonSetting, ComboBox1 );
	setTabOrder( ComboBox1, PushButton15 );
	setTabOrder( PushButton15, ComboBox2 );
	setTabOrder( ComboBox2, CheckBox1 );
	setTabOrder( CheckBox1, pushButtonOK );
	setTabOrder( pushButtonOK, pushButtonCancel );

	////
	options=QString(" ");
}

/*  
 *  Destroys the object and frees any allocated resources
 */
FormatConversion::~FormatConversion()
{
	// no need to delete child widgets, Qt does it all for us
}
QString FormatConversion::getOptions()
{
	return options;    
}

QString FormatConversion::getType()
{
	return listViewFormat->currentItem()->text(0).lower(); 
}

bool FormatConversion::replace()
{
	return CheckBox1->isChecked(); 
}
    
void FormatConversion::enabledDisabledSettingButton(QListViewItem* item)
{
	QString type=item->text(0);
	options="";
	if(type=="JPG")
		pushButtonSetting->setEnabled(true);
	else
		pushButtonSetting->setEnabled(false);	 
}
void FormatConversion::showJPGOption()
{
	JPGOptions opt (this);
	int res = opt.exec();
	switch(res)
	{
		case QDialog::Accepted : options = opt.getOptions();
		default:;
	}
}
