//
// Copyright (c) 2000-2001 - Andrew Richards <ajr@users.sourceforge.net>
//
// This file is part of the PikView image viewer released under the GNU GPL.
// For license details see the file COPYING included with this distribution.
//

#ifndef NUMSLIDER_H
#define NUMSLIDER_H

#include <qslider.h>
#include <qlayout.h>
#include <qlined.h>
#include <qvalidator.h>

#define SLIDERMAX 1000000

class numSlider : public QWidget
{
	Q_OBJECT;

 public:
	/**
		a slider with a number
	*/
	numSlider(QWidget *parent=0, const char *name=0 );
	numSlider(QBoxLayout::Direction aDir, QWidget *parent=0, const char *name=0);
	numSlider(double minValue, double maxValue, int decimals, double value,
						QBoxLayout::Direction aDir, QWidget *parent=0, const char *name=0);
	double value();

 protected slots:
	void sliderChanged(int value);
	void numberChanged();

 signals:
	 void valueChanged(double value);

 private:
	void init(double minValue, double maxValue, int decimals, double value,
						QBoxLayout::Direction aDir);
	void updateValue();

	QSlider *slider;
	QLineEdit *num;
	QBoxLayout::Direction dir;
	double theValue,theMax,theMin,range;
	int theDecimals;
};

#endif
