/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* extract.cpp*/

#include "extract.h"

#include <kio/job.h>

Extract::Extract (const char *filename)
{
	QString *s = new QString (filename);
	int  pos = s->findRev ("/");
	QString *res = new QString (s->right (s->length () - pos - 1));

	KShellProcess *proc = new KShellProcess ();
	connect (proc, SIGNAL (receivedStdout (KProcess *, char *, int)),
		this,   SLOT (    slotMsgRcv (KProcess *, char *, int)));    

	QString  dest;
	dest.setNum (getpid ());
	dest.prepend ("/tmp/.qlist");

	*proc << "mkdir ";
	*proc << (const char *) dest;
	*proc << "; ";

	dest.append ("/" + *res + "/");

	delete (s);
	delete (res);

	QString  ext = QString (filename).right (3);
	if (ext == "zip")
	{
		QString com;
		com.sprintf ("unzip -o -d '%s' '%s'  2>/dev/null >/dev/null; unzip -Z -1 ",
			(const char *) dest, (const char *) filename);
		*proc << (const char *) com;
	}
	else
	{
		*proc << "tar -ztf ";
	}

	*proc << filename;
	*proc << " | cat";

	proc->start (KShellProcess::Block, KShellProcess::All);

};


void
Extract::slotMsgRcv (KProcess * proc, char *buffer, int buflen)
{
	QString res = QString::fromLatin1 (buffer, buflen);

	if ( (res.find ("\n")==-1) && (res.find (".xvpics")==-1) )
		files.append (new QString (res));
	else
	{
		int pos = res.find ("\n");
		while (pos != -1)
		{
			if ( res.find (".xvpics")==-1 )
			  files.append (new QString (res.left (pos)));

			res = res.right (res.length () - pos - 1);
			pos = res.find ("\n");
		}
	}
}
