//
// Copyright (c) 2000-2001 - Andrew Richards <ajr@users.sourceforge.net>
//
// This file is part of the PikView image viewer released under the GNU GPL.
// For license details see the file COPYING included with this distribution.
//


#include <stdio.h>
#include <stdlib.h>

#include "numSlider.h"

extern int max(int a, int b);

numSlider::numSlider( QWidget *parent=0, const char *name=0 )
	: QWidget(parent, name)
{
	init(0, 10, 0, 0, QBoxLayout::LeftToRight);
}


numSlider::numSlider( QBoxLayout::Direction aDir, QWidget *parent=0,
											const char *name=0 )
	: QWidget(parent, name)
{
	init(0, 10, 0, 0, aDir);
}


numSlider::numSlider(double minValue, double maxValue, int decimals,
										 double value, QBoxLayout::Direction aDir,
										 QWidget *parent=0, const char *name=0 )
	: QWidget(parent, name)
{
	init(minValue, maxValue, decimals, value, aDir);
}


void
numSlider::init(double minValue, double maxValue, int decimals, double value,
								QBoxLayout::Direction aDir)
{
	QSlider::Orientation orient;
	QBoxLayout *bl;
	
	theDecimals=decimals;
	dir=aDir;
	bl=new QBoxLayout(this, dir, 2);
	
	if ((dir==QBoxLayout::TopToBottom) || (dir==QBoxLayout::BottomToTop))
		orient=QSlider::Vertical;
	else
		orient=QSlider::Horizontal;

	slider=new QSlider(0, SLIDERMAX, SLIDERMAX/20, 0, orient, this);
	if (orient==QSlider::Vertical)
		slider->setFixedWidth(20);
	else
		slider->setFixedHeight(20);
	bl->addWidget(slider);

	num=new QLineEdit(this);
	num->setFixedHeight(20);
	bl->addWidget(num);

	//	QDoubleValidator *dv=new QDoubleValidator(theMin,theMax,0,this);
	//	num->setValidator(dv);

	bl->activate();

	theValue=value;
	theMin=minValue;
	theMax=maxValue;

	char str[16];
	//sprintf(str,"00%.*f",decimals,theMin);
	int numWidth=max(20,num->fontMetrics().width(str));
	//printf("fm=%d\n",num->fontMetrics().width(str));
	//sprintf(str,"00%.*f",decimals,theMax);
	numWidth=max(numWidth,num->fontMetrics().width(str));
	//printf("fm=%d\n",num->fontMetrics().width(str));
	num->setFixedWidth(numWidth);
	
 	range=theMax-theMin;

	connect(slider, SIGNAL(sliderMoved(int)), this, SLOT(sliderChanged(int)));
	connect(num, SIGNAL(returnPressed()), this, SLOT(numberChanged()));

	updateValue();
	numberChanged();
}


void
numSlider::sliderChanged(int value)
{
	//printf("value %d\n",value);
	theValue=range*value/SLIDERMAX+theMin;
	updateValue();
}


void
numSlider::updateValue()
{
	QString numText;
	numText.sprintf("%.*f",theDecimals,theValue);
	num->setText(numText.data());

	emit valueChanged(theValue);
}


void
numSlider::numberChanged()
{
	theValue=atof(num->text());
	if (theValue>theMax) { theValue=theMax; }
	if (theValue<theMin) { theValue=theMin; }
	//printf("value %f\n",theValue);
	int sliderValue=int(SLIDERMAX*(theValue-theMin)/range);
	//	printf("slidervalue %d\n",sliderValue);
	slider->setValue(sliderValue);
	updateValue();
}


double
numSlider::value()
{
	return(theValue);
}
