#ifndef __PRINT_IMAGE_DIALOG_H__
#define __PRINT_IMAGE_DIALOG_H__

//
// Copyright (c) 2000-2001 - Andrew Richards <ajr@users.sourceforge.net>
//
// This file is part of the PikView image viewer released under the GNU GPL.
// For license details see the file COPYING included with this distribution.
//


#include <qprintdialog.h>
#include <qprinter.h>
#include <qpixmap.h>
#include <qrect.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <kapp.h>
#if KDE_VERSION > 220
#include <kprinter.h>
#endif
#include <kdialog.h>

#include "numSlider.h"


class printImageDialog : public KDialog
{
	Q_OBJECT;

public:
	/**
		construct a dialog to print a pixmap
		@param pixmap the pixmap to print
		@param printer the printer object
	*/
#if KDE_VERSION > 220
	printImageDialog(QWidget *parent, QPixmap pixmap, QString name, KPrinter *p);
#else
	printImageDialog(QWidget *parent, QPixmap pixmap, QString name, QPrinter *p);
#endif
	virtual ~printImageDialog();

 protected:
	virtual void paintEvent(QPaintEvent *e);

 private slots:
	void newScale(double sc);
	void printImage();
	void cancel();
	void back();

 private:
	void paintImage(QPainter *p);
	QRect pageDimensions();

#if KDE_VERSION > 220
	KPrinter  *prn;
#else
	QPrinter  *prn;
#endif
	QPixmap   pix;
	QRect     pageSize;
	QString   imageName;
	numSlider *slScale;

	float scale, pageScale;
};

#endif
