/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __RENAMESERIES_H__
#define __RENAMESERIES_H__

#include <qvariant.h>
#include <qspinbox.h>

#include <kdatepik.h>
#include <kdialog.h>

#include "batchrenamer.h"

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QButtonGroup;
class QCheckBox;
class QGroupBox;
class QLabel;
class QLineEdit;
class QListView;
class QListViewItem;
class QPushButton;
class QRadioButton;
class QSpinBox;



class RenameSeries : public KDialog
{
    Q_OBJECT

public:
    /**
    	construct a dialog to rename in series files
    */
    RenameSeries( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~RenameSeries();

    /**
    	@param filename a file to add for rename
    */
    void addFile(QString filename);
    
    int exec ();

public slots:
        void accept();

protected:
    QString getPath( QString fn );
    bool checkErrors(bool checkDir=true);

    QListViewItem *last;
    QArray<QString*> arrayNames;
    int taille;

    BatchRenamer *newNames;

    QListViewItem* currentItem;
    QGroupBox* GroupBox1;
    QLineEdit* paternLineEdit;
    QCheckBox* checkExtension;
    QPushButton* moveDownPushButton;
    QPushButton* moveUpPushButton;
    QGroupBox* GroupBox9;
    QLabel* TextLabel2_2;
    QSpinBox* spinIndex;
    QButtonGroup* ButtonGroup1;
    QRadioButton* optionMove;
    QRadioButton* optionRename;
    QLineEdit* dirname;
    QPushButton* buttonChooseDir;
    QRadioButton* optionCopy;
    QGroupBox* GroupBox5;
    QCheckBox* CheckBox7;
    QFrame* Frame3;
    QCheckBox* previewCheckBox;
    QLabel* PixmapLabel1;
    QFrame* Line2;
    QLabel* TextLabel1;
    QLabel* TextLabel2;
    QListView* remanedPreviewListView;
    QPushButton* cancelPushButton;
    QPushButton* renamePushButton;
    QCheckBox* overwrite;
    QHBoxLayout* Layout1;

    KDatePicker *kDate;

protected slots:
    virtual void slotMoveDown();
    virtual void slotMoveUp();
    virtual void slotSetImagePreview(int);
    virtual void slotUpdatePreview(QListViewItem*);
    virtual void slotUpdateRenamed(const QString &);
    virtual void slotUpdateRenamed();

    void chooseDir();
};

#endif 
