/***************************************************************************
                          listitem.h  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307   *
 *   USA.                                                                  *
 *                                                                         *
 *   For license exceptions see LICENSE.EXC file, attached with the source *
 *   code.                                                                 *
 *                                                                         *
 ***************************************************************************/

#ifndef LISTITEM_H
#define LISTITEM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE 
#include <klistview.h>

// Qt 
#include <qfile.h>
#include <qstring.h>

class ImageViewer;
class MainWindow;
class DirectoryView;
class ImageListView;
class FileIconItem;

class QListViewItem;
class QString;
class QPixmap;
class QString;
class QStringList;

class KURL;



class ListItem : public KListViewItem
{

public: 
	ListItem(DirectoryView *parent, ImageViewer *iv, ImageListView *imageList, MainWindow *mw);
	ListItem(ListItem *parent, const QString& filename, DirectoryView *dirView, ImageViewer *iv,  ImageListView *imageList, MainWindow *mw);
	virtual ~ListItem();

	virtual QString text (int column) const;

	virtual QString fullName ();
	virtual QString name ();
	virtual QString path ();
	virtual KURL getURL();

	virtual  void setSelected (bool select);

	virtual  void load (bool refresh=true);
	virtual  void unLoad ();
	virtual  bool refresh(bool preview=true);
	virtual  ListItem* find (const QString&);
	virtual  void goTo (const QString&);

	virtual  void removeImage ( FileIconItem* );
	virtual  QString key (int column, bool ascending)  const;
	virtual int compare ( QListViewItem * i, int col, bool ascending ) const;

	virtual  void create(const QString& dirName);

	virtual  bool add(const QStringList& uris);
	
	virtual  bool acceptDrop();
	
	virtual  void setReadOnly(bool readOnly=true);
	virtual  bool isReadOnly();
	
	
	virtual  void rename(const QString& newDirName);
	virtual  void rename();
	virtual  void updateChildren();
	virtual  void properties();
	
	QString getType(){return __type__;};
	void setType(const QString& type){__type__=type;};

	ListItem* firstChild();
	ListItem* nextSibling();
	ListItem* itemBelow();
	ListItem* itemAbove();
	ListItem* parent();
	
	void paintCell(QPainter *p, const QColorGroup &cg, int column, int width, int alignment);
	
	static const int TREE_CHECKBOX_MAXSIZE = 16;

	ImageViewer *iv;
	ImageListView *imageList;
	MainWindow *mw;
	DirectoryView *dirView;

protected:
	
	QFile f;
	QString full;
	
	QString size;
	QString extension;

	QString __type__;
	
	bool isReadOnly_;
};

#endif
