/*
   Siag, Scheme In A Grid
   Copyright (C) 1996-1998  Ulric Eriksson <ulric@siag.nu>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>

#include <Mowitz/MwUtils.h>
#include "../common/common.h"
#include "../siag/calc.h"

#include "selection.h"

/* ---
*/
int pack_string_selection(buffer *b, char *data, int s,
			int r1, int c1, int r2, int c2)
{
	int r, c, lastr, lastc;
	char *p, *q;

	q = data;
	lastr = line_last_used(b, s);
	if (lastr > r2) lastr = r2;
	for (r = r1; r <= lastr; r++) {
		lastc = col_last_used(b, s, r);
		if (lastc > c2) lastc = c2;
		for (c = c1; c <= lastc; c++) {
			if (data-q > 30000) goto toolong;
			p = ret_pvalue(NULL, b, s, r, c, -1);
			strcpy(data, p);
			data += strlen(data);
			if (c < c2) *data++ = ',';
		}
		*data++ = '\n';
	}
toolong:
	*data = '\0';
	return 0;
}

/* ---
*/
int unpack_string_selection(buffer *b, char *data, int s, int row, int col)
{
	char *p;
	int n = 0;
	cval value;
	value.number = 0;

	for (p = data; *p; p++)
		if (*p == '\n') n++;

	undo_save(b, s, row, col, row+n, col);

	while ((p = strchr(data, '\n')) != NULL) {
		*p = '\0';
		ins_data(b, siod_interpreter, data,
			value, LABEL, s, row, col);
		row++;
		data = p+1;
	}
	if (*data) {
		ins_data(b, siod_interpreter, data,
			value, LABEL, s, row, col);
	}
	pr_scr_flag = TRUE;
	show_cur(w_list);
	return 0;
}

