/**
 * HTTP/HTTPS client support
 *
 * Copyright (C) 2000 Jeffrey Fulmer <jdfulmer@armstrong.com>
 * This file is part of Siege
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   
 * 
 */
#include <client.h>
#include <http.h>
#include <cookie.h>

/** 
 * http_connect, coordinates function calls
 * in sock and http. 
 */
void 
http_connect( char *proto, char *host, int port, char *path, 
              url_access_t calltype, char *postdata, size_t postlen, int qid )
{
  int    SSL = 0;
  int    x = 0, y, n;
  int    sock;
  char   c;
  clock_t start, stop; 
  struct tms t_start, t_stop; 
  struct trans t;
  struct headers head;

  /* KLUDGE: make sure path is at least / */
  path = ( strlen( path ) == 0 ) ? strcpy( path, "/" ) : path;

  if(( strncasecmp( proto, "https", 5 )) == 0 ) SSL = 1;

  /* record transaction start time */
  start = times( &t_start );	

  /* create a socket, SSL: HTTPS=1, HTTP=0 */
  if(( sock = SIEGEsocket( host, port, SSL )) == -1 ){
    joe_error( "unable to unable to establish a socket" );
    return;
  }
 
  /* DEBUG the calltype and path */ 
  if( my.debug ){ 
    printf("Type: %s, Path: %s, ", calltype?"POST":" GET", path); fflush(stdout); 
  }

  /* send a HTTP request to the server */
  if( calltype == URL_GET ){
    if (( SIEGEhttp_send( host, path )) == -1 ){
      joe_error( "unable to send request to server" );
    }
  }
  else if( calltype == URL_POST ){
    if(( SIEGEhttp_post( host, path, postdata, postlen )) == -1 ){
      joe_error( "unable to send request to server" );
    }
  } 
  else{
    joe_error("invalid access");
  }
 
  /* read the headers from the socket */ 
  memset( &head, '\0', sizeof( head ));
  head    = SIEGEhttp_read_headers( host );
  
  /* read the content and determine bytes read */
  if( head.keepalive ){
    t.bytes = SIEGEhttp_read( head.length );
  } 
  else{
    t.bytes = SIEGEhttp_read( 0 ); /* Read until done */
  }
  
  /* record transaction stop time */
  stop    =  times( &t_stop ); 
  t.time  =  elapsed_time( stop - start ); 
  t.code  =  head.code;
  
  /* IPC message, siege lib/joedog/ipcmsg.h */ 		
  send_message( qid, t.bytes, t.code, t.time ); 

  /* print the result if verbose output is required */
  if( my.verbose ){ printf( "%s %d: %7d bytes ==> %s\n", head.head, t.code, t.bytes, path ); }

  /* close the socket */
  if( !head.keepalive ){
    my.keepalive = FALSE;
    SIEGEclose();
  } 
  else{
    my.keepalive = TRUE;
  }
  return;

} /** end of http_connect **/


