#include <Foundation/Foundation.h>
#include <AppKit/AppKit.h>
#include "GraphicToolbox.h"

@implementation NSBox (theme)
- (void) drawRect: (NSRect)rect
{
  NSColor *color = [_window backgroundColor];
  rect = NSIntersectionRect(_bounds, rect);
  // Fill inside
  [color set];
  NSRectFill(rect);
  [[NSColor grayColor] set];
  //NSRectFill(_border_rect);
  //[[NSColor colorWithCalibratedRed: 0 green: 0 blue: 0 alpha: 0.1] set]; 
  NSBezierPath* path = [NSBezierPath bezierPath];
  NSBezierPath* pathSup = [NSBezierPath bezierPath];
  NSBezierPath* pathDown = [NSBezierPath bezierPath];

  // Draw border
  switch (_border_type)
    {
    case NSNoBorder:
      break;
    case NSLineBorder:
      [[NSColor controlDarkShadowColor] set];
      NSFrameRect(_border_rect);
      break;
    case NSBezelBorder:
      NSDrawGrayBezel(_border_rect, rect);
      break;
    case NSGrooveBorder:
      [path setLineWidth: 0];
      NSRect plop = NSMakeRect (_border_rect.origin.x + 1, _border_rect.origin.y + 1, 
      		_border_rect.size.width - 2, _border_rect.size.height - 2);
      [path appendBezierPathWithRoundedRectangle: plop withRadius: 8.0];
      
      //[[NSColor colorWithCalibratedRed: 0.7 green: 0.7 blue: 0.7 alpha: 0.2] set];
      //[path fill];
      
      [pathDown setLineWidth: 0];
      NSRect shadow = NSMakeRect (_border_rect.origin.x + 1, _border_rect.origin.y +1, 
      		_border_rect.size.width - 2, _border_rect.size.height - 3);
      [pathDown appendBezierPathWithRoundedRectangle: shadow withRadius: 8.0];
      [[NSColor colorWithCalibratedRed: 0.7 green: 0.7 blue: 0.7 alpha: 0.4] set];
      //[[NSColor redColor] set];
      [pathDown stroke];
      
      [[NSColor grayColor] set];
      [path stroke];
      
      /*
      [pathSup appendBezierDemiSupPathWithRoundedRectangle: _border_rect withRadius: 8.0];
      [pathSup setLineWidth: 0];
      [[NSColor blackColor] set];
      [pathSup stroke];
      [pathDown appendBezierDemiDownPathWithRoundedRectangle: _border_rect withRadius: 8.0];
      [pathDown setLineWidth: 0];
      [[NSColor lightGrayColor] set];
      [pathDown stroke];
      */
      //NSDrawGroove(_border_rect, rect);
      break;
    }

  // Draw title
  if (_title_position != NSNoTitle)
    {
      [_cell setBackgroundColor: color];
      [_cell drawWithFrame: _title_rect inView: self];
    }
}

@end

