/*
**  Sinek (Video Player)
**  Copyright (c) 2001 - 2002 the Sinek Team, see the AUTHORS file.
**
**  This code is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License.
**
**  guile support, exported functions
*/

#include "common.h"
#include <guile/gh.h>

static SCM catcher(void *data, SCM tag, SCM throw_args);
static SCM gp_command(SCM arg);
static SCM gp_open(SCM arg);
static SCM gp_seek(SCM arg);
static SCM gp_get_position(void);
static SCM gp_get_playlist(void);
static SCM gp_clear_playlist(void);
static SCM gp_add_mrl(SCM arg);


void guile_init(void)
{
	gh_eval_str("(define sinek-stop-hook (make-hook 0))");
	gh_new_procedure("sinek-command", gp_command, 1, 0, 0);
	gh_new_procedure("sinek-open", gp_open, 1, 0, 0);
	gh_new_procedure("sinek-seek", gp_seek, 1, 0, 0);
	gh_new_procedure("sinek-get-position", gp_get_position, 0, 0, 0);
	gh_new_procedure("sinek-get-playlist", gp_get_playlist, 0, 0, 0);
	gh_new_procedure("sinek-clear-playlist", gp_clear_playlist, 0, 0, 0);
	gh_new_procedure("sinek-add-mrl", gp_add_mrl, 1, 0, 0);
}


void guile_execute(char *filename)
{
	gh_eval_file_with_catch(filename, catcher);
}


int guile_stop_hook(void)
{
	SCM t;
	t = gh_eval_str("(hook-empty? sinek-stop-hook)");
	if(t == SCM_BOOL_T) return(0);
	gh_eval_str_with_catch("(run-hook sinek-stop-hook)", catcher);
	return 1;
}


static SCM catcher(void *data, SCM tag, SCM throw_args)
{
	printf("Error in scheme script!\n");
	gh_display(tag);
	gh_newline();
	gh_display(throw_args);
	gh_newline();

	return SCM_BOOL_F;
}


static SCM gp_command(SCM arg)
{
	cmd_type cmd;
	char *command;

	SCM_DEFER_INTS;
	command = gh_scm2newstr(arg, NULL);
	if(command)
	{
		cmd = find_cmd(command);
		free(command);
		if(cmd != CMD_NONE) execute_cmd(cmd);
	}
	SCM_ALLOW_INTS;
	return SCM_EOL;
}


static SCM gp_open(SCM arg)
{
	char *mrl;
	SCM ret = SCM_BOOL_F;

	SCM_DEFER_INTS;
	mrl = gh_scm2newstr(arg, NULL);
	if(mrl)
	{
		if(video_play(mrl)) ret = SCM_BOOL_T;
		free(mrl);
	}
	SCM_ALLOW_INTS;
	return ret;
}


static SCM gp_seek(SCM arg)
{
	unsigned long msec;

	msec = gh_scm2ulong(arg);
	SCM_DEFER_INTS;
	video_seek(msec / 100);
	SCM_ALLOW_INTS;
	return SCM_EOL;
}


static SCM gp_get_position(void)
{
	SCM ret = SCM_EOL;
	unsigned long cur, total;

	SCM_DEFER_INTS;
	cur = xine_get_current_time(sinek.xine) * 100;
	total = xine_get_stream_length(sinek.xine) * 100;
	SCM_ALLOW_INTS;
	ret = gh_cons(gh_ulong2scm(cur), ret);
	ret = gh_cons(gh_ulong2scm(total), ret);
	ret = gh_reverse(ret);
	return ret;
}


static SCM gp_get_playlist(void)
{
	SCM list = SCM_EOL;
	char *mrl;
	int i;

	SCM_DEFER_INTS;
	for(i = 0; (mrl = pl_get_mrl(i)); i++)
	{
		list = gh_cons(gh_str02scm(mrl), list);
	}
	SCM_ALLOW_INTS;
	list = gh_reverse(list);
	return list;
}


static SCM gp_clear_playlist(void)
{
	SCM_DEFER_INTS;
	pl_remove_all();
	SCM_ALLOW_INTS;
	return SCM_EOL;
}


static SCM gp_add_mrl(SCM arg)
{
	char *mrl;

	SCM_DEFER_INTS;
	mrl = gh_scm2newstr(arg, NULL);
	if(mrl)
	{
		pl_append(mrl);
		free(mrl);
	}
	SCM_ALLOW_INTS;
	return SCM_EOL;
}
