/*
**  Sinek (Video Player)
**  Copyright (c) 2001 - 2002 the Sinek Team, see the AUTHORS file.
**
**  This code is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public License.
**
**  main
*/

#include "common.h"

struct sinek_globals sinek;

static int stream_finished = 0;

static void event_listener(void *this, xine_event_t *event);
static gboolean second_update(gpointer data);

#ifdef USE_GUILE
#include <guile/gh.h>

/* this strange code is necessary for guile's garbage collector */
void inner_main(int argc, char *argv[]);

int main(int argc, char *argv[])
{
	gh_enter(argc, argv, inner_main);
	return 0;
}

void inner_main(int argc, char *argv[])
#else
int main(int argc, char *argv[])
#endif
{
	memset(&sinek, 0, sizeof(sinek));

	srand(time(NULL));

	gtk_set_locale();
	xine_set_locale();
	bindtextdomain(PACKAGE, XINE_LOCALEDIR);
	textdomain(PACKAGE);

	guile_init();

	gtk_init(&argc, &argv);

	prf_init(argc, argv);

	if(!video_init()) exit(5);
	if(!audio_init()) exit(5);

	key_init();
	control_init();
	control_current_time(0);
	popup_init();

	xine_register_event_listener(sinek.xine, event_listener, &sinek);
	pl_init();
	g_timeout_add(500, (GSourceFunc)second_update, NULL);

	osd_init();

	if(sinek.script) guile_execute(sinek.script);
	if(sinek.start_mrl) video_play(sinek.start_mrl);

	gtk_main();

	exit(0);
}


static gboolean second_update(gpointer data)
{
	if(stream_finished)
	{
		if(!guile_stop_hook())
		{
			if(sinek.playing)
			{
				if(sinek.repeat_one)
					video_seek(0);
				else
					pl_next();
			}
		}
		stream_finished = 0;
	}
	if(xine_get_status(sinek.xine) == XINE_PLAY)
	{
		if(!sinek.seeking) control_current_time(xine_get_current_time(sinek.xine));
		if(sinek.osd_subtitles) osd_update();
		if(++sinek.cursor_timer == 3) video_cursor(0);
	}
	return TRUE;
}


static void event_listener(void *this, xine_event_t *event)
{
	switch(event->type)
	{
		case XINE_EVENT_PLAYBACK_FINISHED:
			if(!stream_finished) stream_finished = 1;
			break;
	}
}
