#include "messagebasictypes.h"
#include "messagecomplextypes.h"


namespace Msg
{


void pushFrontstring8(Message & message, const std::string & value)
{
  if (value.size()>255)
  {
    throw MessageException("pushFrontstring8 string to long");
  }
  uint8 strLength=value.size();
  for (int i=strLength-1;i>=0;i--)
  {
    pushFrontuint8(message,uint8(value[i]));
  }
  pushFrontuint8(message,strLength);
}


void pushBackstring8(Message & message, const std::string & value)
{
  if (value.size()>255)
  {
    throw MessageException("pushBackstring8 string to long");
  }
  uint8 strLength=value.size();
  pushBackuint8(message,strLength);
  for (int i=0;i<strLength;i++)
  {
    pushBackuint8(message,uint8(value[i]));
  }
}


void popFrontstring8(Message & message, std::string & returnValue)
{
  returnValue="";
  uint8 strLength;
  popFrontuint8(message,strLength);

  for (int i=0;i<strLength;i++)
  {
    uint8 stringPart;
    popFrontuint8(message,stringPart);
    returnValue+=char(stringPart);
  }
}


}
