#ifndef _measureserver_h
#define _measureserver_h


#include <asio.hpp>
#include "cpustat.h"
#include "netload.h"
#include "diskload.h"
#include "procinfo.h"


class MeasureServer
{
private:
  asio::io_service & ioservice;
  asio::deadline_timer timer;

  std::string bcast_address;

  unsigned long timeCounter;

  bool sendRestartFlag;

  ProcinfoMeter procinfoMeter;
  bool procinfonow;                 // flag that is set to send process infos if the load has changed dramatically

  CpustatMeter cpustatMeter;
  float lastidlepercent;

  NetloadMeter netloadMeter;
  DiskloadMeter diskloadMeter;

  std::string marker;
  int restartcounter;


public:
  MeasureServer(asio::io_service& io_service, const std::string & _bcast_address, const std::string & networkcard, const std::string & _marker);

  void timerEvent();
  void restartCounterEvent();


  void handle_timeout(); // asio part
};


#endif

