/*
 * Copyright (c) 2000 Phil Thompson (phil@river-bank.demon.co.uk)
 *
 * This file defined the SIP library internal interfaces.
 */


#ifndef _SIPINT_H
#define	_SIPINT_H


#ifdef __cplusplus
extern "C" {
#endif

#undef	TRUE
#define	TRUE		1

#undef	FALSE
#define	FALSE		0


/*
 * This defines an entry in a linked list of Python objects.
 */

typedef struct _sipThisList
{
	sipThisType *sipThis;		/* This Python object. */
	struct _sipThisList *next;	/* The next in the list. */
} sipThisList;


/*
 * This defines a single entry in an object map's hash table.
 */

typedef struct
{
	const void *key;		/* The C/C++ address. */
	sipThisList *vallist;		/* The list of objects at this address. */
	sipThisList first;		/* Storage for the first in the list. */
} sipHashEntry;


/*
 * This defines the interface to a hash table class for mapping C/C++ addresses
 * to the corresponding wrapped Python object.
 */

typedef struct
{
	int primeIdx;			/* Index into table sizes. */
	unsigned long size;		/* Size of hash table. */
	unsigned long neverUsed;	/* Nr. never used in hash table. */
	sipHashEntry *hash_array;	/* Current hash table. */
} sipObjectMap;


#ifdef SIP_QT_SUPPORT
PyObject *sipQObjectClass;		/* The Python QObject class. */
#endif


void sipOMInit Py_PROTO((sipObjectMap *));
void sipOMFinalise Py_PROTO((sipObjectMap *));
sipThisType *sipOMFindObject Py_PROTO((sipObjectMap *,const void *,PyObject *));
void sipOMAddObject Py_PROTO((sipObjectMap *,const void *,sipThisType *));
int sipOMRemoveObject Py_PROTO((sipObjectMap *,const void *,sipThisType *));


#ifdef __cplusplus
}
#endif

#endif
