/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.adaptor;

import com.google.clearsilver.jsilver.adaptor.JHdf;
import com.google.clearsilver.jsilver.adaptor.LoadPathToFileCache;
import com.google.clearsilver.jsilver.exceptions.JSilverTemplateNotFoundException;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.clearsilver.CSFileLoader;
import org.clearsilver.CSUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLoaderAdaptor
implements ResourceLoader {
    private final JHdf hdf;
    private final LoadPathToFileCache loadPathCache;
    private final CSFileLoader csFileLoader;
    private List<String> loadPaths;

    ResourceLoaderAdaptor(JHdf hdf, LoadPathToFileCache loadPathCache, CSFileLoader csFileLoader) {
        this.hdf = hdf;
        this.loadPathCache = loadPathCache;
        this.csFileLoader = csFileLoader;
    }

    @Override
    public Reader open(String name) throws IOException {
        if (this.csFileLoader != null) {
            if (this.hdf.getData() == null) {
                throw new IllegalStateException("HDF is already closed");
            }
            return new StringReader(this.csFileLoader.load(this.hdf, name));
        }
        File file = this.locateFile(name);
        if (file == null) {
            throw new FileNotFoundException("Could not locate file " + name);
        }
        return new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
    }

    @Override
    public Reader openOrFail(String name) throws JSilverTemplateNotFoundException, IOException {
        Reader reader = this.open(name);
        if (reader == null) {
            StringBuffer text = new StringBuffer();
            text.append("No file '");
            text.append(name);
            text.append("' ");
            if (this.loadPaths == null || this.loadPaths.isEmpty()) {
                text.append("with no load paths");
            } else if (this.loadPaths.size() == 1) {
                text.append("inside directory '");
                text.append(this.loadPaths.get(0));
                text.append("'");
            } else {
                text.append("inside directories ( ");
                for (String path : this.getLoadPaths()) {
                    text.append("'");
                    text.append(path);
                    text.append("' ");
                }
                text.append(")");
            }
            throw new JSilverTemplateNotFoundException(text.toString());
        }
        return reader;
    }

    File locateFile(String name) {
        String filePath;
        if (name.startsWith(File.separator)) {
            File file = this.newFile(name);
            return file.exists() ? file : null;
        }
        File file = null;
        if (this.loadPathCache != null && (filePath = this.loadPathCache.lookup(this.getLoadPaths(), name)) != null) {
            file = this.newFile(filePath);
            return file.exists() ? file : null;
        }
        file = this.locateFile(this.getLoadPaths(), name);
        if (file != null && this.loadPathCache != null) {
            this.loadPathCache.add(this.getLoadPaths(), name, file.getAbsolutePath());
        }
        return file;
    }

    File locateFile(List<String> loadPaths, String filename) {
        if (filename == null) {
            throw new NullPointerException("No filename provided");
        }
        if (loadPaths == null) {
            throw new NullPointerException("No loadpaths provided.");
        }
        for (String path : loadPaths) {
            File file = this.newFile(path, filename);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    File newFile(String filename) {
        return new File(filename);
    }

    File newFile(String path, String filename) {
        return new File(path, filename);
    }

    @Override
    public void close(Reader reader) throws IOException {
        reader.close();
    }

    @Override
    public Object getKey(String filename) {
        if (filename.startsWith(File.separator)) {
            return filename;
        }
        File file = this.locateFile(filename);
        if (file == null) {
            return LoadPathToFileCache.makeCacheKey(this.getLoadPaths(), filename);
        }
        return file.getAbsolutePath();
    }

    @Override
    public Object getResourceVersionId(String filename) {
        String fullPath;
        File file = this.locateFile(filename);
        if (file == null) {
            return null;
        }
        try {
            fullPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            fullPath = file.getAbsolutePath();
        }
        return String.format("%s@%s", fullPath, file.lastModified());
    }

    final CSFileLoader getCSFileLoader() {
        return this.csFileLoader;
    }

    private synchronized List<String> getLoadPaths() {
        if (this.loadPaths == null) {
            if (this.hdf.getData() == null) {
                throw new IllegalStateException("HDF is already closed");
            }
            this.loadPaths = CSUtil.getLoadPaths(this.hdf, true);
        }
        return this.loadPaths;
    }
}

